/*
   wspdef.h

   Base definitions

   Copyright (C) 1996 Free Software Foundation, Inc.

   This file is part of the Windows32 API Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   If you are interested in a warranty or support for this source code,
   contact Scott Christley <scottc@net-community.com> for more information.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   -----------
   DAL 2003 - this file modified extensively for my compiler.  New
   definitionswnwn added as well.
*/
#define SPLDS_ASSET_NUMBER TEXT("assetNumber")
#define SPLDS_BYTES_PER_MINUTE TEXT("bytesPerMinute")
#define SPLDS_DESCRIPTION TEXT("description")
#define SPLDS_DRIVER_KEY TEXT("DsDriver")
#define SPLDS_DRIVER_NAME TEXT("driverName")
#define SPLDS_DRIVER_VERSION TEXT("driverVersion")
#define SPLDS_FLAGS TEXT("flags")
#define SPLDS_LOCATION TEXT("location")
#define SPLDS_PORT_NAME TEXT("portName")
#define SPLDS_PRINTER_CLASS TEXT("printQueue")
#define SPLDS_PRINTER_LOCATIONS TEXT("printerLocations")
#define SPLDS_PRINTER_MODEL TEXT("printerModel")
#define SPLDS_PRINTER_NAME TEXT("printerName")
#define SPLDS_PRINTER_NAME_ALIASES TEXT("printerNameAliases")
#define SPLDS_PRINT_ATTRIBUTES TEXT("printAttributes")
#define SPLDS_PRINT_BIN_NAMES TEXT("printBinNames")
#define SPLDS_PRINT_COLLATE TEXT("printCollate")
#define SPLDS_PRINT_COLOR TEXT("printColor")
#define SPLDS_PRINT_DUPLEX_SUPPORTED TEXT("printDuplexSupported")
#define SPLDS_PRINT_END_TIME TEXT("printEndTime")
#define SPLDS_PRINT_KEEP_PRINTED_JOBS TEXT("printKeepPrintedJobs")
#define SPLDS_PRINT_LANGUAGE TEXT("printLanguage")
#define SPLDS_PRINT_MAC_ADDRESS TEXT("printMACAddress")
#define SPLDS_PRINT_MAX_RESOLUTION_SUPPORTED TEXT("printMaxResolutionSupported")
#define SPLDS_PRINT_MAX_X_EXTENT TEXT("printMaxXExtent")
#define SPLDS_PRINT_MAX_Y_EXTENT TEXT("printMaxYExtent")
#define SPLDS_PRINT_MEDIA_READY TEXT("printMediaReady")
#define SPLDS_PRINT_MEDIA_SUPPORTED TEXT("printMediaSupported")
#define SPLDS_PRINT_MEMORY TEXT("printMemory")
#define SPLDS_PRINT_MIN_X_EXTENT TEXT("printMinXExtent")
#define SPLDS_PRINT_MIN_Y_EXTENT TEXT("printMinYExtent")
#define SPLDS_PRINT_NETWORK_ADDRESS TEXT("printNetworkAddress")
#define SPLDS_PRINT_NOTIFY TEXT("printNotify")
#define SPLDS_PRINT_NUMBER_UP TEXT("printNumberUp")
#define SPLDS_PRINT_ORIENTATIONS_SUPPORTED TEXT("printOrientationsSupported")
#define SPLDS_PRINT_OWNER TEXT("printOwner")
#define SPLDS_PRINT_PAGES_PER_MINUTE TEXT("printPagesPerMinute")
#define SPLDS_PRINT_RATE TEXT("printRate")
#define SPLDS_PRINT_RATE_UNIT TEXT("printRateUnit")
#define SPLDS_PRINT_SEPARATOR_FILE TEXT("printSeparatorFile")
#define SPLDS_PRINT_SHARE_NAME TEXT("printShareName")
#define SPLDS_PRINT_SPOOLING TEXT("printSpooling")
#define SPLDS_PRINT_STAPLING_SUPPORTED TEXT("printStaplingSupported")
#define SPLDS_PRINT_START_TIME TEXT("printStartTime")
#define SPLDS_PRINT_STATUS TEXT("printStatus")
#define SPLDS_PRIORITY TEXT("priority")
#define SPLDS_SERVER_NAME TEXT("serverName")
#define SPLDS_SHORT_SERVER_NAME TEXT("shortServerName")
#define SPLDS_SPOOLER_KEY TEXT("DsSpooler")
#define SPLDS_UNC_NAME TEXT("uNCName")
#define SPLDS_URL TEXT("url")
#define SPLDS_USER_KEY TEXT("DsUser")
#define SPLDS_VERSION_NUMBER TEXT("versionNumber")

#define SPLREG_ARCHITECTURE TEXT("Architecture")
#define SPLREG_BEEP_ENABLED TEXT("BeepEnabled")
#define SPLREG_DEFAULT_SPOOL_DIRECTORY TEXT("DefaultSpoolDirectory")
#define SPLREG_DNS_MACHINE_NAME TEXT("DNSMachineName")
#define SPLREG_DS_PRESENT TEXT("DsPresent")
#define SPLREG_DS_PRESENT_FOR_USER TEXT("DsPresentForUser")
#define SPLREG_EVENT_LOG TEXT("EventLog")
#define SPLREG_MAJOR_VERSION TEXT("MajorVersion")
#define SPLREG_MINOR_VERSION TEXT("MinorVersion")
#define SPLREG_NET_POPUP TEXT("NetPopup")
#define SPLREG_NET_POPUP_TO_COMPUTER TEXT("NetPopupToComputer")
#define SPLREG_OS_VERSION TEXT("OSVersion")
#define SPLREG_PORT_THREAD_PRIORITY TEXT("PortThreadPriority")
#define SPLREG_PORT_THREAD_PRIORITY_DEFAULT TEXT("PortThreadPriorityDefault")
#define SPLREG_REMOTE_FAX TEXT("RemoteFax")
#define SPLREG_RESTART_JOB_ON_POOL_ENABLED TEXT("RestartJobOnPoolEnabled")
#define SPLREG_RESTART_JOB_ON_POOL_ERROR TEXT("RestartJobOnPoolError")
#define SPLREG_RETRY_POPUP TEXT("RetryPopup")
#define SPLREG_SCHEDULER_THREAD_PRIORITY TEXT("SchedulerThreadPriority")
#define SPLREG_SCHEDULER_THREAD_PRIORITY_DEFAULT TEXT("SchedulerThreadPriorityDefault")
#define APD_COPY_ALL_FILES (4)
#define APD_COPY_NEW_FILES (8)
#define APD_STRICT_DOWNGRADE (2)
#define APD_STRICT_UPGRADE (1)

#define DEF_PRIORITY (1)

#define DI_CHANNEL (1)
#define DI_MEMORYMAP_WRITE (1)
#define DI_READ_SPOOL_JOB (3)

#define DPD_DELETE_ALL_FILES (4)
#define DPD_DELETE_SPECIFIC_VERSION (2)
#define DPD_DELETE_UNUSED_FILES (1)

#define DRIVER_KERNELMODE (1)
#define DRIVER_USERMODE (2)

#define DSPRINT_PENDING (2147483647)
#define DSPRINT_PUBLISH (1)
#define DSPRINT_REPUBLISH (8)
#define DSPRINT_UNPUBLISH (4)
#define DSPRINT_UPDATE (2)

#define FORM_BUILTIN (1)
#define FORM_PRINTER (2)
#define FORM_USER (0)

#define JOB_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED | JOB_ACCESS_ADMINISTER)

#define JOB_READ (STANDARD_RIGHTS_READ | JOB_ACCESS_ADMINISTER)

#define JOB_WRITE (STANDARD_RIGHTS_WRITE | JOB_ACCESS_ADMINISTER)

#define JOB_EXECUTE (STANDARD_RIGHTS_EXECUTE | JOB_ACCESS_ADMINISTER)

#define JOB_ACCESS_ADMINISTER (16)
#define JOB_CONTROL_CANCEL (3)
#define JOB_CONTROL_DELETE (5)
#define JOB_CONTROL_PAUSE (1)
#define JOB_CONTROL_RESTART (4)
#define JOB_CONTROL_RESUME (2)
#define JOB_CONTROL_SENT_TO_PRINTER (6)
#define JOB_NOTIFY_FIELD_BYTES_PRINTED (23)
#define JOB_NOTIFY_FIELD_DATATYPE (5)
#define JOB_NOTIFY_FIELD_DEVMODE (9)
#define JOB_NOTIFY_FIELD_DOCUMENT (13)
#define JOB_NOTIFY_FIELD_DRIVER_NAME (8)
#define JOB_NOTIFY_FIELD_MACHINE_NAME (1)
#define JOB_NOTIFY_FIELD_NOTIFY_NAME (4)
#define JOB_NOTIFY_FIELD_PAGES_PRINTED (21)
#define JOB_NOTIFY_FIELD_PARAMETERS (7)
#define JOB_NOTIFY_FIELD_PORT_NAME (2)
#define JOB_NOTIFY_FIELD_POSITION (15)
#define JOB_NOTIFY_FIELD_PRINTER_NAME (0)
#define JOB_NOTIFY_FIELD_PRINT_PROCESSOR (6)
#define JOB_NOTIFY_FIELD_PRIORITY (14)
#define JOB_NOTIFY_FIELD_SECURITY_DESCRIPTOR (12)
#define JOB_NOTIFY_FIELD_START_TIME (17)
#define JOB_NOTIFY_FIELD_STATUS (10)
#define JOB_NOTIFY_FIELD_STATUS_STRING (11)
#define JOB_NOTIFY_FIELD_SUBMITTED (16)
#define JOB_NOTIFY_FIELD_TIME (19)
#define JOB_NOTIFY_FIELD_TOTAL_BYTES (22)
#define JOB_NOTIFY_FIELD_TOTAL_PAGES (20)
#define JOB_NOTIFY_FIELD_UNTIL_TIME (18)
#define JOB_NOTIFY_FIELD_USER_NAME (3)
#define JOB_NOTIFY_TYPE (1)
#define JOB_POSITION_UNSPECIFIED (0)
#define JOB_STATUS_BLOCKED_DEVQ (512)
#define JOB_STATUS_DELETED (256)
#define JOB_STATUS_DELETING (4)
#define JOB_STATUS_ERROR (2)
#define JOB_STATUS_OFFLINE (32)
#define JOB_STATUS_PAPEROUT (64)
#define JOB_STATUS_PAUSED (1)
#define JOB_STATUS_PRINTED (128)
#define JOB_STATUS_PRINTING (16)
#define JOB_STATUS_RESTART (2048)
#define JOB_STATUS_SPOOLING (8)
#define JOB_STATUS_USER_INTERVENTION (1024)

#define MAX_PRIORITY (99)

#define MIN_PRIORITY (1)

#define NO_PRIORITY (0)

#define PORT_STATUS_DOOR_OPEN (7)
#define PORT_STATUS_NO_TONER (6)
#define PORT_STATUS_OFFLINE (1)
#define PORT_STATUS_OUTPUT_BIN_FULL (4)
#define PORT_STATUS_OUT_OF_MEMORY (9)
#define PORT_STATUS_PAPER_JAM (2)
#define PORT_STATUS_PAPER_OUT (3)
#define PORT_STATUS_PAPER_PROBLEM (5)
#define PORT_STATUS_POWER_SAVE (12)
#define PORT_STATUS_TONER_LOW (10)
#define PORT_STATUS_TYPE_ERROR (1)
#define PORT_STATUS_TYPE_INFO (3)
#define PORT_STATUS_TYPE_WARNING (2)
#define PORT_STATUS_USER_INTERVENTION (8)
#define PORT_STATUS_WARMING_UP (11)
#define PORT_TYPE_NET_ATTACHED (8)
#define PORT_TYPE_READ (2)
#define PORT_TYPE_REDIRECTED (4)
#define PORT_TYPE_WRITE (1)

#define PRINTER_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED | PRINTER_ACCESS_ADMINISTER | PRINTER_ACCESS_USE)

#define PRINTER_READ (STANDARD_RIGHTS_READ | PRINTER_ACCESS_USE)

#define PRINTER_WRITE (STANDARD_RIGHTS_WRITE | PRINTER_ACCESS_USE)

#define PRINTER_EXECUTE (STANDARD_RIGHTS_EXECUTE | PRINTER_ACCESS_USE)

#define PRINTER_ACCESS_ADMINISTER (4)
#define PRINTER_ACCESS_USE (8)
#define PRINTER_ATTRIBUTE_DEFAULT (4)
#define PRINTER_ATTRIBUTE_DIRECT (2)
#define PRINTER_ATTRIBUTE_ENABLE_BIDI (2048)
#define PRINTER_ATTRIBUTE_ENABLE_DEVQ (128)
#define PRINTER_ATTRIBUTE_HIDDEN (32)
#define PRINTER_ATTRIBUTE_KEEPPRINTEDJOBS (256)
#define PRINTER_ATTRIBUTE_LOCAL (64)
#define PRINTER_ATTRIBUTE_NETWORK (16)
#define PRINTER_ATTRIBUTE_PUBLISHED (8192)
#define PRINTER_ATTRIBUTE_QUEUED (1)
#define PRINTER_ATTRIBUTE_RAW_ONLY (4096)
#define PRINTER_ATTRIBUTE_SHARED (8)
#define PRINTER_ATTRIBUTE_WORK_OFFLINE (1024)
#define PRINTER_CHANGE_ADD_FORM (65536)
#define PRINTER_CHANGE_ADD_JOB (256)
#define PRINTER_CHANGE_ADD_PORT (1048576)
#define PRINTER_CHANGE_ADD_PRINTER (1)
#define PRINTER_CHANGE_ADD_PRINTER_DRIVER (268435456)
#define PRINTER_CHANGE_ADD_PRINT_PROCESSOR (16777216)
#define PRINTER_CHANGE_ALL (2004353023)
#define PRINTER_CHANGE_CONFIGURE_PORT (2097152)
#define PRINTER_CHANGE_DELETE_FORM (262144)
#define PRINTER_CHANGE_DELETE_JOB (1024)
#define PRINTER_CHANGE_DELETE_PORT (4194304)
#define PRINTER_CHANGE_DELETE_PRINTER (4)
#define PRINTER_CHANGE_DELETE_PRINTER_DRIVER (1073741824)
#define PRINTER_CHANGE_DELETE_PRINT_PROCESSOR (67108864)
#define PRINTER_CHANGE_FAILED_CONNECTION_PRINTER (8)
#define PRINTER_CHANGE_FORM (458752)
#define PRINTER_CHANGE_JOB (65280)
#define PRINTER_CHANGE_PORT (7340032)
#define PRINTER_CHANGE_PRINTER (255)
#define PRINTER_CHANGE_PRINTER_DRIVER (1879048192)
#define PRINTER_CHANGE_PRINT_PROCESSOR (117440512)
#define PRINTER_CHANGE_SET_FORM (131072)
#define PRINTER_CHANGE_SET_JOB (512)
#define PRINTER_CHANGE_SET_PRINTER (2)
#define PRINTER_CHANGE_SET_PRINTER_DRIVER (536870912)
#define PRINTER_CHANGE_TIMEOUT (2147483647)
#define PRINTER_CHANGE_WRITE_JOB (2048)
#define PRINTER_CONTROL_PAUSE (1)
#define PRINTER_CONTROL_PURGE (3)
#define PRINTER_CONTROL_RESUME (2)
#define PRINTER_CONTROL_SET_STATUS (4)
#define PRINTER_ENUM_CONNECTIONS (4)
#define PRINTER_ENUM_CONTAINER (32768)
#define PRINTER_ENUM_DEFAULT (1)
#define PRINTER_ENUM_EXPAND (16384)
#define PRINTER_ENUM_FAVORITE (4)
#define PRINTER_ENUM_HIDE (16777216)
#define PRINTER_ENUM_ICON1 (65536)
#define PRINTER_ENUM_ICON2 (131072)
#define PRINTER_ENUM_ICON3 (262144)
#define PRINTER_ENUM_ICON4 (524288)
#define PRINTER_ENUM_ICON5 (1048576)
#define PRINTER_ENUM_ICON6 (2097152)
#define PRINTER_ENUM_ICON7 (4194304)
#define PRINTER_ENUM_ICON8 (8388608)
#define PRINTER_ENUM_ICONMASK (16711680)
#define PRINTER_ENUM_LOCAL (2)
#define PRINTER_ENUM_NAME (8)
#define PRINTER_ENUM_NETWORK (64)
#define PRINTER_ENUM_REMOTE (16)
#define PRINTER_ENUM_SHARED (32)
#define PRINTER_ERROR_INFORMATION (2147483647)
#define PRINTER_ERROR_JAM (2)
#define PRINTER_ERROR_OUTOFPAPER (1)
#define PRINTER_ERROR_OUTOFTONER (4)
#define PRINTER_ERROR_SEVERE (536870912)
#define PRINTER_ERROR_WARNING (1073741824)
#define PRINTER_NOTIFY_FIELD_ATTRIBUTES (13)
#define PRINTER_NOTIFY_FIELD_AVERAGE_PPM (21)
#define PRINTER_NOTIFY_FIELD_BYTES_PRINTED (25)
#define PRINTER_NOTIFY_FIELD_CJOBS (20)
#define PRINTER_NOTIFY_FIELD_COMMENT (5)
#define PRINTER_NOTIFY_FIELD_DATATYPE (11)
#define PRINTER_NOTIFY_FIELD_DEFAULT_PRIORITY (15)
#define PRINTER_NOTIFY_FIELD_DEVMODE (7)
#define PRINTER_NOTIFY_FIELD_DRIVER_NAME (4)
#define PRINTER_NOTIFY_FIELD_LOCATION (6)
#define PRINTER_NOTIFY_FIELD_OBJECT_GUID (26)
#define PRINTER_NOTIFY_FIELD_PAGES_PRINTED (23)
#define PRINTER_NOTIFY_FIELD_PARAMETERS (10)
#define PRINTER_NOTIFY_FIELD_PORT_NAME (3)
#define PRINTER_NOTIFY_FIELD_PRINTER_NAME (1)
#define PRINTER_NOTIFY_FIELD_PRINT_PROCESSOR (9)
#define PRINTER_NOTIFY_FIELD_PRIORITY (14)
#define PRINTER_NOTIFY_FIELD_SECURITY_DESCRIPTOR (12)
#define PRINTER_NOTIFY_FIELD_SEPFILE (8)
#define PRINTER_NOTIFY_FIELD_SERVER_NAME (0)
#define PRINTER_NOTIFY_FIELD_SHARE_NAME (2)
#define PRINTER_NOTIFY_FIELD_START_TIME (16)
#define PRINTER_NOTIFY_FIELD_STATUS (18)
#define PRINTER_NOTIFY_FIELD_STATUS_STRING (19)
#define PRINTER_NOTIFY_FIELD_TOTAL_BYTES (24)
#define PRINTER_NOTIFY_FIELD_TOTAL_PAGES (22)
#define PRINTER_NOTIFY_FIELD_UNTIL_TIME (17)
#define PRINTER_NOTIFY_INFO_DISCARDED (1)
#define PRINTER_NOTIFY_OPTIONS_REFRESH (1)
#define PRINTER_NOTIFY_TYPE (0)
#define PRINTER_STATUS_BUSY (512)
#define PRINTER_STATUS_DOOR_OPEN (4194304)
#define PRINTER_STATUS_ERROR (2)
#define PRINTER_STATUS_INITIALIZING (32768)
#define PRINTER_STATUS_IO_ACTIVE (256)
#define PRINTER_STATUS_MANUAL_FEED (32)
#define PRINTER_STATUS_NOT_AVAILABLE (4096)
#define PRINTER_STATUS_NO_TONER (262144)
#define PRINTER_STATUS_OFFLINE (128)
#define PRINTER_STATUS_OUTPUT_BIN_FULL (2048)
#define PRINTER_STATUS_OUT_OF_MEMORY (2097152)
#define PRINTER_STATUS_PAGE_PUNT (524288)
#define PRINTER_STATUS_PAPER_JAM (8)
#define PRINTER_STATUS_PAPER_OUT (16)
#define PRINTER_STATUS_PAPER_PROBLEM (64)
#define PRINTER_STATUS_PAUSED (1)
#define PRINTER_STATUS_PENDING_DELETION (4)
#define PRINTER_STATUS_POWER_SAVE (16777216)
#define PRINTER_STATUS_PRINTING (1024)
#define PRINTER_STATUS_PROCESSING (16384)
#define PRINTER_STATUS_SERVER_UNKNOWN (8388608)
#define PRINTER_STATUS_TONER_LOW (131072)
#define PRINTER_STATUS_USER_INTERVENTION (1048576)
#define PRINTER_STATUS_WAITING (8192)
#define PRINTER_STATUS_WARMING_UP (65536)

#define SERVER_ACCESS_ADMINISTER (1)
#define SERVER_ACCESS_ENUMERATE (2)
#define SERVER_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED | SERVER_ACCESS_ADMINISTER | SERVER_ACCESS_ENUMERATE)

#define SERVER_READ (STANDARD_RIGHTS_READ | SERVER_ACCESS_ENUMERATE)

#define SERVER_WRITE (STANDARD_RIGHTS_WRITE | SERVER_ACCESS_ADMINISTER | SERVER_ACCESS_ENUMERATE)

#define SERVER_EXECUTE (STANDARD_RIGHTS_EXECUTE | SERVER_ACCESS_ENUMERATE)

#define SPOOL_FILE_PERSISTENT (1)
#define SPOOL_FILE_TEMPORARY (2)
