/* powerpc-darwin.dylib-entry.h
   created from powerpc-darwin.dylib-entry.bin, 8437 (0x20f5) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2023 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2023 Laszlo Molnar
   Copyright (C) 2000-2023 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_POWERPC_DARWIN_DYLIB_ENTRY_SIZE    8437
#define STUB_POWERPC_DARWIN_DYLIB_ENTRY_ADLER32 0x6a84f499
#define STUB_POWERPC_DARWIN_DYLIB_ENTRY_CRC32   0x7bcb67f6

unsigned char stub_powerpc_darwin_dylib_entry[8437] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 20,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0, 26,124,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,
/* 0x0030 */   0,  0,  0,  0,124, 72,  2,166, 72,  0,  2,  5,124,  0, 41,236,
/* 0x0040 */ 125,168,  2,166, 40,  7,  0,  8, 64,130,  1, 60,144,166,  0,  0,
/* 0x0050 */ 124,132, 26, 20, 60,  0,128,  0, 61, 32,128,  0, 56, 99,255,255,
/* 0x0060 */  56,165,255,255, 57, 64,255,255, 72,  0,  1, 12, 57, 32,  0,  1,
/* 0x0070 */ 125, 41, 28, 44, 56, 99,  0,  4,124,  9,  0, 64,125, 41, 72, 20,
/* 0x0080 */  97, 41,  0,  1, 78,128,  0, 32,141,  3,  0,  1,157,  5,  0,  1,
/* 0x0090 */ 124,  9,  0, 64,125, 41, 74, 20, 65,162,255,213, 65,129,255,236,
/* 0x00a0 */  56,224,  0,  1, 72,  0,  0, 20, 56,231,255,255,125, 41, 72, 21,
/* 0x00b0 */  65,162,255,189,124,231, 57, 20,125, 41, 72, 21, 65,162,255,177,
/* 0x00c0 */ 124,231, 57, 20,124,  9,  0, 64,125, 41, 74, 20, 65,162,255,161,
/* 0x00d0 */  65,160,255,216, 57,  0,  0,  0, 52,231,255,253, 84,231, 64, 46,
/* 0x00e0 */  65,128,  0, 32,141, 99,  0,  1,124,234, 88,249,125, 74, 14,112,
/* 0x00f0 */  65,130,  0,  0,113,107,  0,  1, 65,162,  0, 80, 72,  0,  0, 20,
/* 0x0100 */ 124,  9,  0, 64,125, 41, 74, 20, 65,162,255,101, 65,161,  0, 60,
/* 0x0110 */  57,  0,  0,  1,124,  9,  0, 64,125, 41, 74, 20, 65,162,255, 81,
/* 0x0120 */  65,161,  0, 40,125, 41, 72, 21, 65,162,255, 69,125,  8, 65, 20,
/* 0x0130 */ 124,  9,  0, 64,125, 41, 74, 20, 65,162,255, 53, 65,160,255,232,
/* 0x0140 */  57,  8,  0,  2, 72,  0,  0, 16,125, 41, 72, 21, 65,162,255, 33,
/* 0x0150 */ 125,  8, 65, 20, 32,234,250,255, 57,  8,  0,  2,125,  8,  1,148,
/* 0x0160 */ 124,234, 42, 20,125,  9,  3,166,141,  7,  0,  1,157,  5,  0,  1,
/* 0x0170 */  66,  0,255,248, 56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44,
/* 0x0180 */  75,255,255, 16,124,  0, 41,236,125,168,  2,166, 40,  7,  0,  5,
/* 0x0190 */  64,130,  1, 32,144,166,  0,  0,124,132, 26, 20, 60,  0,128,  0,
/* 0x01a0 */  61, 32,128,  0, 56, 99,255,255, 56,165,255,255, 57, 64,255,255,
/* 0x01b0 */  72,  0,  0,240, 57, 32,  0,  1,125, 41, 28, 44, 56, 99,  0,  4,
/* 0x01c0 */ 124,  9,  0, 64,125, 41, 72, 20, 97, 41,  0,  1, 78,128,  0, 32,
/* 0x01d0 */ 141,  3,  0,  1,157,  5,  0,  1,124,  9,  0, 64,125, 41, 74, 20,
/* 0x01e0 */  65,162,255,213, 65,129,255,236, 56,224,  0,  1, 72,  0,  0, 20,
/* 0x01f0 */  56,231,255,255,125, 41, 72, 21, 65,162,255,189,124,231, 57, 21,
/* 0x0200 */ 125, 41, 72, 21, 65,162,255,177,124,231, 57, 21,124,  9,  0, 64,
/* 0x0210 */ 125, 41, 74, 20, 65,162,255,161, 65,160,255,216, 57,  0,  0,  0,
/* 0x0220 */  52,231,255,253, 84,231, 64, 46, 65,128,  0, 24,141, 99,  0,  1,
/* 0x0230 */ 124,234, 88,249,125, 74, 14,112, 65,130,  0,  0, 72,  0,  0, 12,
/* 0x0240 */ 125, 41, 72, 21, 65,162,255,113,125,  8, 65, 21,125, 41, 72, 21,
/* 0x0250 */  65,162,255,101,125,  8, 65, 21, 64,130,  0, 40, 57,  0,  0,  1,
/* 0x0260 */ 125, 41, 72, 21, 65,162,255, 81,125,  8, 65, 21,124,  9,  0, 64,
/* 0x0270 */ 125, 41, 74, 20, 65,162,255, 65, 65,160,255,232, 57,  8,  0,  2,
/* 0x0280 */  32,234,250,255, 57,  8,  0,  1,125,  8,  1,148,124,234, 42, 20,
/* 0x0290 */ 125,  9,  3,166,141,  7,  0,  1,157,  5,  0,  1, 66,  0,255,248,
/* 0x02a0 */  56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44, 75,255,255, 44,
/* 0x02b0 */ 124,  0, 41,236,125,168,  2,166, 40,  7,  0,  2, 64,130,  0,228,
/* 0x02c0 */ 144,166,  0,  0,124,132, 26, 20, 60,  0,128,  0, 61, 32,128,  0,
/* 0x02d0 */  56, 99,255,255, 56,165,255,255, 57, 64,255,255, 72,  0,  0,180,
/* 0x02e0 */ 124,  9,  0, 64,125, 41, 72, 20, 76,162,  0, 32, 57, 32,  0,  1,
/* 0x02f0 */ 125, 41, 28, 44, 56, 99,  0,  4,124,  9,  0, 64,125, 41, 73, 20,
/* 0x0300 */  78,128,  0, 32,141,  3,  0,  1,157,  5,  0,  1, 75,255,255,213,
/* 0x0310 */  65,129,255,244, 56,224,  0,  1, 75,255,255,201,124,231, 57, 21,
/* 0x0320 */  75,255,255,193, 65,160,255,244, 52,231,255,253, 57,  0,  0,  0,
/* 0x0330 */  65,128,  0, 20,141, 99,  0,  1, 84,231, 64, 46,124,234, 88,249,
/* 0x0340 */  65,130,  0,  0, 75,255,255,157,125,  8, 65, 21, 75,255,255,149,
/* 0x0350 */ 125,  8, 65, 21, 56,224,  0,  1, 64,130,  0, 28, 56,224,  0,  3,
/* 0x0360 */  57,  0,  0,  1, 75,255,255,125,125,  8, 65, 21, 75,255,255,117,
/* 0x0370 */  65,160,255,244, 33,106,242,255,125,  8, 57, 20,124,234, 42, 20,
/* 0x0380 */ 125,  9,  3,166,141,  7,  0,  1,157,  5,  0,  1, 66,  0,255,248,
/* 0x0390 */  56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44, 75,255,255,112,
/* 0x03a0 */  40,  7,  0, 14, 64,130,  0, 36,148, 33,255,232,124,  8,  2,166,
/* 0x03b0 */ 124,201, 51,120,129,  6,  0,  0,124,167, 43,120, 56,164,255,254,
/* 0x03c0 */  56,131,  0,  2,144,  1,  0,  8,136,  3,  0,  0, 84, 11,232,254,
/* 0x03d0 */  84, 12,  7,126, 56, 96,250,  0,124, 99, 88, 48, 56, 99,241,124,
/* 0x03e0 */ 124, 38, 11,120,124, 33, 26, 20, 84, 33,  0, 52, 56,  0,  0,  0,
/* 0x03f0 */ 124,195, 51,120,144,  9,  0,  0,148,  3,255,252,124,  1, 24, 64,
/* 0x0400 */  65,128,255,248,144,193,  0,  0,136,  4,255,255,144,225,  0,  8,
/* 0x0410 */  56,193,  0, 16,145, 33,  0, 12, 56, 97,  0, 20, 84, 11,225, 62,
/* 0x0420 */  84,  0,  7, 62,153,131,  0,  2,153, 99,  0,  1,152,  3,  0,  0,
/* 0x0430 */ 124,  8,  2,166,148, 33,255,160,189,193,  0, 24, 59, 32,  0,  0,
/* 0x0440 */ 125, 40,  3,166,124,206, 51,120,124,147, 35,120,144,  1,  0,100,
/* 0x0450 */ 124,245, 59,120,125, 20, 67,120,137, 67,  0,  2, 59,  3,  0,  4,
/* 0x0460 */  59,224,  0,  0,137, 99,  0,  1, 58,224,  0,  0, 59, 64,  0,  1,
/* 0x0470 */ 138, 67,  0,  0, 58, 32,  0,  1, 58,  0,  0,  1,147, 38,  0,  0,
/* 0x0480 */  57,224,  0,  1,147, 41,  0,  0, 57, 32,  3,  0,136,  3,  0,  1,
/* 0x0490 */ 124, 18,  2, 20,125, 41,  0, 48, 56,  9,  7, 54, 57, 32,  0,  1,
/* 0x04a0 */ 127,153,  0, 64,125, 43, 88, 48,125, 41, 80, 48, 57,107,255,255,
/* 0x04b0 */  57, 41,255,255,145, 97,  0, 12,145, 33,  0,  8, 57, 32,  0,  0,
/* 0x04c0 */  64,156,  0, 28,124,  9,  3,166, 57, 96,  4,  0, 85, 32,  8, 60,
/* 0x04d0 */  57, 41,  0,  1,125,120,  3, 46, 66,  0,255,244,127,147, 42, 20,
/* 0x04e0 */ 126,108,155,120, 56,160,  0,  0, 57,  0,255,255, 57, 96,  0,  0,
/* 0x04f0 */ 127,140,224,  0, 57,107,  0,  1, 47, 11,  0,  4, 84,169, 64, 46,
/* 0x0500 */  65,158,  8,156,136, 12,  0,  0, 57,140,  0,  1,125, 37,  3,120,
/* 0x0510 */  64,153,255,224,127,153,160, 64, 64,156,  8,100, 62,192,  0,255,
/* 0x0520 */  98,214,255,255,127,136,176, 64,128,  1,  0,  8,127, 35,  0, 56,
/* 0x0530 */  86,224, 32, 54,124,  0, 26, 20, 84,  6,  8, 60, 65,157,  0, 32,
/* 0x0540 */ 127,140,224,  0, 65,158,  8, 88,137, 44,  0,  0, 84,160, 64, 46,
/* 0x0550 */  85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,124,230,194, 46,
/* 0x0560 */  85,  0,170,254,125, 64, 57,214,127,133, 80, 64, 64,156,  1,172,
/* 0x0570 */ 128,  1,  0, 12, 47,151,  0,  6,125, 72, 83,120, 56, 96,  0,  1,
/* 0x0580 */ 127, 41,  0, 56, 32, 18,  0,  8,127,224,  6, 48,125, 41,144, 48,
/* 0x0590 */ 125, 41,  2, 20, 32,  7,  8,  0, 29, 41,  6,  0,124,  0, 46,112,
/* 0x05a0 */ 124,  7,  2, 20,124,  6,195, 46,125, 56, 74, 20, 56,201, 14,108,
/* 0x05b0 */  64,157,  0,180,124, 26,200, 80, 63, 96,  0,255,127,245,  0,174,
/* 0x05c0 */  99,123,255,255,127,136,216, 64, 87,255,  8, 60, 87,253,  5,238,
/* 0x05d0 */  84,100,  8, 60, 87,160,  8, 60,127, 12,224,  0,124,  6,  2, 20,
/* 0x05e0 */  84,169, 64, 46,124,224, 34, 20, 65,157,  0, 24, 65,154,  7,176,
/* 0x05f0 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x0600 */ 161,103,  2,  0, 85,  0,170,254, 47, 29,  0,  0,124,131, 35,120,
/* 0x0610 */ 125, 64, 89,214, 32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,
/* 0x0620 */ 124, 11,  2, 20,125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80,
/* 0x0630 */  64,156,  0, 20,176,  7,  2,  0,125, 72, 83,120, 65,186,  0, 24,
/* 0x0640 */  72,  0,  0, 28,177,103,  2,  0,124,170, 40, 80, 56,100,  0,  1,
/* 0x0650 */  65,154,  0, 12, 47,131,  0,255, 64,157,255,108, 47,131,  0,255,
/* 0x0660 */  65,157,  0,132, 63,224,  0,255, 99,255,255,255,127,136,248, 64,
/* 0x0670 */  84,103,  8, 60,127, 12,224,  0, 84,169, 64, 46,124,227, 59,120,
/* 0x0680 */  65,157,  0, 24, 65,154,  7, 24,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x0690 */  57,140,  0,  1,125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,
/* 0x06a0 */ 125, 64, 89,214, 32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,
/* 0x06b0 */ 124, 11,  2, 20,125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80,
/* 0x06c0 */  64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,
/* 0x06d0 */ 124,170, 40, 80,125,102, 59, 46, 56,103,  0,  1, 47,131,  0,255,
/* 0x06e0 */  64,157,255,140, 47,151,  0,  3, 84,127,  6, 62,127,249,169,174,
/* 0x06f0 */  59, 57,  0,  1, 65,157,  0, 12, 58,224,  0,  0, 72,  0,  6,120,
/* 0x0700 */  47,151,  0,  9, 65,157,  0, 12, 58,247,255,253, 72,  0,  6,104,
/* 0x0710 */  58,247,255,250, 72,  0,  6, 96,125, 10, 64, 80, 84,224,217,126,
/* 0x0720 */ 127,136,176, 64,124,  0, 56, 80, 86,233,  8, 60,124,  6,195, 46,
/* 0x0730 */ 124,170, 40, 80,124,248, 74, 20, 65,157,  0, 32,127,140,224,  0,
/* 0x0740 */  65,158,  6, 92,137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46,
/* 0x0750 */  57,140,  0,  1,124,  5, 75,120,161,103,  1,128, 85,  0,170,254,
/* 0x0760 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 64, 47,151,  0,  6,
/* 0x0770 */  32, 11,  8,  0,124,  0, 46,112,126, 15,131,120,124, 11,  2, 20,
/* 0x0780 */ 126, 48,139,120,176,  7,  1,128,125, 72, 83,120, 56,  0,  0,  0,
/* 0x0790 */ 127, 81,211,120, 64,157,  0,  8, 56,  0,  0,  3,124, 23,  3,120,
/* 0x07a0 */  56,216,  6,100, 72,  0,  2, 24,125, 10, 64, 80, 85, 96,217,126,
/* 0x07b0 */ 127,136,176, 64,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,128,
/* 0x07c0 */  65,157,  0, 32,127,140,224,  0, 65,158,  5,212,137, 44,  0,  0,
/* 0x07d0 */  84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,
/* 0x07e0 */ 161,103,  1,152, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x07f0 */  64,156,  0,188,127,138,176, 64, 32, 11,  8,  0,124,  0, 46,112,
/* 0x0800 */  86,233, 40, 52,124, 11,  2, 20,125, 56, 74, 20, 84,107,  8, 60,
/* 0x0810 */ 176,  7,  1,152,125, 72, 83,120,124,233, 90, 20, 65,157,  0, 32,
/* 0x0820 */ 127,140,224,  0, 65,158,  5,120,137, 44,  0,  0, 84,160, 64, 46,
/* 0x0830 */  85, 72, 64, 46, 57,140,  0,  1,124,  5, 75,120,161,103,  1,224,
/* 0x0840 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 72,
/* 0x0850 */  47,153,  0,  0, 32, 11,  8,  0,124,  0, 46,112,125, 72, 83,120,
/* 0x0860 */ 124, 11,  2, 20,176,  7,  1,224, 65,158,  5, 52, 47,151,  0,  6,
/* 0x0870 */  57, 32,  0,  9, 64,157,  0,  8, 57, 32,  0, 11,124, 26,200, 80,
/* 0x0880 */ 125, 55, 75,120,127,245,  0,174,127,249,169,174, 59, 57,  0,  1,
/* 0x0890 */  72,  0,  4,228, 85, 96,217,126,124,170, 40, 80,124,  0, 88, 80,
/* 0x08a0 */ 125, 10, 64, 80,176,  7,  1,224, 72,  0,  0,252,125, 10, 64, 80,
/* 0x08b0 */  85, 96,217,126,127,136,176, 64,124,  0, 88, 80,124,170, 40, 80,
/* 0x08c0 */ 176,  7,  1,152, 65,157,  0, 32,127,140,224,  0, 65,158,  4,208,
/* 0x08d0 */ 137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x08e0 */ 124,  5, 75,120,161,103,  1,176, 85,  0,170,254,125, 64, 89,214,
/* 0x08f0 */ 127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,125, 72, 83,120,
/* 0x0900 */ 124,  0, 46,112,126, 41,139,120,124, 11,  2, 20,176,  7,  1,176,
/* 0x0910 */  72,  0,  0,140,125, 10, 64, 80, 85, 96,217,126,127,136,176, 64,
/* 0x0920 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,176, 65,157,  0, 32,
/* 0x0930 */ 127,140,224,  0, 65,158,  4,104,137, 44,  0,  0, 84,160, 64, 46,
/* 0x0940 */  85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,161,103,  1,200,
/* 0x0950 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32,
/* 0x0960 */  32, 11,  8,  0,125, 72, 83,120,124,  0, 46,112,126,  9,131,120,
/* 0x0970 */ 124, 11,  2, 20,176,  7,  1,200, 72,  0,  0, 32, 85, 96,217,126,
/* 0x0980 */ 125,233,123,120,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,200,
/* 0x0990 */ 125, 10, 64, 80,126, 15,131,120,126, 48,139,120,127, 81,211,120,
/* 0x09a0 */ 125, 58, 75,120, 47,151,  0,  6, 56,  0,  0,  8, 64,157,  0,  8,
/* 0x09b0 */  56,  0,  0, 11,124, 23,  3,120, 56,216, 10,104,127,136,176, 64,
/* 0x09c0 */  65,157,  0, 32,127,140,224,  0, 65,158,  3,212,137, 44,  0,  0,
/* 0x09d0 */  84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,
/* 0x09e0 */ 161,102,  0,  0, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x09f0 */  64,156,  0, 48, 84,105, 32, 54, 32, 11,  8,  0,125, 38, 74, 20,
/* 0x0a00 */ 124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120, 56,137,  0,  4,
/* 0x0a10 */  59, 96,  0,  0,176,  6,  0,  0, 56, 96,  0,  3, 72,  0,  0,156,
/* 0x0a20 */ 125, 10, 64, 80, 85, 96,217,126,127,136,176, 64,124,  0, 88, 80,
/* 0x0a30 */ 124,170, 40, 80,176,  6,  0,  0, 65,157,  0, 32,127,140,224,  0,
/* 0x0a40 */  65,158,  3, 92,137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46,
/* 0x0a50 */  57,140,  0,  1,124,  5, 75,120,161,102,  0,  2, 85,  0,170,254,
/* 0x0a60 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48, 84,105, 32, 54,
/* 0x0a70 */  32, 11,  8,  0,125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,
/* 0x0a80 */ 125, 72, 83,120, 56,137,  1,  4, 59, 96,  0,  8,176,  6,  0,  2,
/* 0x0a90 */  56, 96,  0,  3, 72,  0,  0, 36, 85, 96,217,126,124,170, 40, 80,
/* 0x0aa0 */ 124,  0, 88, 80,125, 10, 64, 80,176,  6,  0,  2, 56,134,  2,  4,
/* 0x0ab0 */  59, 96,  0, 16, 56, 96,  0,  8, 63,224,  0,255,124,105,  3,166,
/* 0x0ac0 */  59,160,  0,  1, 99,255,255,255,127,136,248, 64, 87,167,  8, 60,
/* 0x0ad0 */ 127, 12,224,  0, 84,169, 64, 46,124,253, 59,120, 65,157,  0, 24,
/* 0x0ae0 */  65,154,  2,188,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0af0 */ 125, 37,  3,120,125,100, 58, 46, 85,  0,170,254,125, 64, 89,214,
/* 0x0b00 */  32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,124, 11,  2, 20,
/* 0x0b10 */ 125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,
/* 0x0b20 */ 125, 72, 83,120,124,  4, 59, 46, 72,  0,  0, 16,124,170, 40, 80,
/* 0x0b30 */  59,167,  0,  1,125,100, 59, 46, 66,  0,255,144, 47,151,  0,  3,
/* 0x0b40 */  56,  0,  0,  1,124,  0, 24, 48,127,160,232, 80,127,189,218, 20,
/* 0x0b50 */  65,157,  1,232, 47,157,  0,  3, 58,247,  0,  7,127,169,235,120,
/* 0x0b60 */  64,157,  0,  8, 57, 32,  0,  3, 85, 41, 56, 48, 63,224,  0,255,
/* 0x0b70 */ 125, 56, 74, 20, 99,255,255,255, 56,201,  3, 96, 57, 32,  0,  6,
/* 0x0b80 */ 125, 41,  3,166, 56,128,  0,  1,127,136,248, 64, 84,135,  8, 60,
/* 0x0b90 */ 127, 12,224,  0, 84,169, 64, 46,124,228, 59,120, 65,157,  0, 24,
/* 0x0ba0 */  65,154,  1,252,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0bb0 */ 125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,125, 64, 89,214,
/* 0x0bc0 */  32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,124, 11,  2, 20,
/* 0x0bd0 */ 125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,
/* 0x0be0 */ 125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80,
/* 0x0bf0 */  56,135,  0,  1,125,102, 59, 46, 66,  0,255,144, 56,132,255,192,
/* 0x0c00 */  47,132,  0,  3,124,154, 35,120, 64,157,  1, 40, 47,132,  0, 13,
/* 0x0c10 */ 124,137, 14,112, 84,128,  7,254, 57,105,255,255, 96, 26,  0,  2,
/* 0x0c20 */ 125,105,  3,166, 65,157,  0, 32,127, 90, 88, 48, 84,128,  8, 60,
/* 0x0c30 */  87, 73,  8, 60,125, 56, 74, 20,125, 32, 72, 80, 56,201,  5, 94,
/* 0x0c40 */  72,  0,  0,100, 57, 41,255,251, 61, 96,  0,255,125, 41,  3,166,
/* 0x0c50 */  97,107,255,255,127,136, 88, 64,127, 12,224,  0, 84,169, 64, 46,
/* 0x0c60 */  87, 90,  8, 60, 65,157,  0, 24, 65,154,  1, 52,136, 12,  0,  0,
/* 0x0c70 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120, 85,  8,248,126,
/* 0x0c80 */ 127,133, 64, 64, 65,156,  0, 12,124,168, 40, 80, 99, 90,  0,  1,
/* 0x0c90 */  66,  0,255,196, 56,  0,  0,  4, 87, 90, 32, 54,124,  9,  3,166,
/* 0x0ca0 */  56,216,  6, 68, 60, 96,  0,255, 56,128,  0,  1, 96, 99,255,255,
/* 0x0cb0 */  59,224,  0,  1,127,136, 24, 64, 87,231,  8, 60,127, 12,224,  0,
/* 0x0cc0 */  84,169, 64, 46,124,255, 59,120, 65,157,  0, 24, 65,154,  0,208,
/* 0x0cd0 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x0ce0 */ 125,102, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x0cf0 */  85,105,217,126,124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,
/* 0x0d00 */ 127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x0d10 */ 124,  6, 59, 46, 72,  0,  0, 20,124,170, 40, 80, 59,231,  0,  1,
/* 0x0d20 */ 125,102, 59, 46,127, 90, 35,120, 84,132,  8, 60, 66,  0,255,136,
/* 0x0d30 */  55, 90,  0,  1, 65,130,  0, 72,127,154,200, 64, 59,189,  0,  2,
/* 0x0d40 */  65,157,  0, 92,124, 26,200, 80, 59,189,255,255,127,245,  0,174,
/* 0x0d50 */  49,125,255,255,125, 43,233, 16,127,249,169,174, 59, 57,  0,  1,
/* 0x0d60 */ 124, 20,200, 16,124,  0,  1, 16,124,  0,  0,208,125, 43,  0, 57,
/* 0x0d70 */  64,130,255,212,127,153,160, 64, 65,156,247,172, 60,  0,  0,255,
/* 0x0d80 */  96,  0,255,255,127,136,  0, 64, 65,157,  0, 32,127,140,224,  0,
/* 0x0d90 */  56, 96,  0,  1, 65,158,  0, 40, 72,  0,  0, 12, 56, 96,  0,  1,
/* 0x0da0 */  72,  0,  0, 28, 57,140,  0,  1,125, 40,  2,166,124, 19, 96, 80,
/* 0x0db0 */  56, 96,  0,  0,144, 14,  0,  0,147, 41,  0,  0,128,  1,  0,100,
/* 0x0dc0 */ 185,193,  0, 24, 56, 33,  0, 96,124,  8,  3,166,124,  8,  2,166,
/* 0x0dd0 */ 148, 33,255,160,189,193,  0, 24, 59, 32,  0,  0,125, 40,  3,166,
/* 0x0de0 */ 124,206, 51,120,124,147, 35,120,144,  1,  0,100,124,245, 59,120,
/* 0x0df0 */ 125, 20, 67,120,137, 67,  0,  2, 59,  3,  0,  4, 59,224,  0,  0,
/* 0x0e00 */ 137, 99,  0,  1, 58,224,  0,  0, 59, 64,  0,  1,138, 67,  0,  0,
/* 0x0e10 */  58, 32,  0,  1, 58,  0,  0,  1,147, 38,  0,  0, 57,224,  0,  1,
/* 0x0e20 */ 147, 41,  0,  0, 57, 32,  3,  0,136,  3,  0,  1,124, 18,  2, 20,
/* 0x0e30 */ 125, 41,  0, 48, 56,  9,  7, 54, 57, 32,  0,  1,127,153,  0, 64,
/* 0x0e40 */ 125, 43, 88, 48,125, 41, 80, 48, 57,107,255,255, 57, 41,255,255,
/* 0x0e50 */ 145, 97,  0, 12,145, 33,  0,  8, 57, 32,  0,  0, 64,156,  0, 28,
/* 0x0e60 */ 124,  9,  3,166, 57, 96,  4,  0, 85, 32,  8, 60, 57, 41,  0,  1,
/* 0x0e70 */ 125,120,  3, 46, 66,  0,255,244,127,147, 42, 20,126,108,155,120,
/* 0x0e80 */  56,160,  0,  0, 57,  0,255,255, 57, 96,  0,  0,127,140,224,  0,
/* 0x0e90 */  57,107,  0,  1, 47, 11,  0,  4, 84,169, 64, 46, 65,158,  8,156,
/* 0x0ea0 */ 136, 12,  0,  0, 57,140,  0,  1,125, 37,  3,120, 64,153,255,224,
/* 0x0eb0 */ 127,153,160, 64, 64,156,  8,100, 62,192,  0,255, 98,214,255,255,
/* 0x0ec0 */ 127,136,176, 64,128,  1,  0,  8,127, 35,  0, 56, 86,224, 32, 54,
/* 0x0ed0 */ 124,  0, 26, 20, 84,  6,  8, 60, 65,157,  0, 32,127,140,224,  0,
/* 0x0ee0 */  65,158,  8, 88,137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46,
/* 0x0ef0 */  57,140,  0,  1,124,  5, 75,120,124,230,194, 46, 85,  0,170,254,
/* 0x0f00 */ 125, 64, 57,214,127,133, 80, 64, 64,156,  1,172,128,  1,  0, 12,
/* 0x0f10 */  47,151,  0,  6,125, 72, 83,120, 56, 96,  0,  1,127, 41,  0, 56,
/* 0x0f20 */  32, 18,  0,  8,127,224,  6, 48,125, 41,144, 48,125, 41,  2, 20,
/* 0x0f30 */  32,  7,  8,  0, 29, 41,  6,  0,124,  0, 46,112,124,  7,  2, 20,
/* 0x0f40 */ 124,  6,195, 46,125, 56, 74, 20, 56,201, 14,108, 64,157,  0,180,
/* 0x0f50 */ 124, 26,200, 80, 63, 96,  0,255,127,245,  0,174, 99,123,255,255,
/* 0x0f60 */ 127,136,216, 64, 87,255,  8, 60, 87,253,  5,238, 84,100,  8, 60,
/* 0x0f70 */  87,160,  8, 60,127, 12,224,  0,124,  6,  2, 20, 84,169, 64, 46,
/* 0x0f80 */ 124,224, 34, 20, 65,157,  0, 24, 65,154,  7,176,136, 12,  0,  0,
/* 0x0f90 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,161,103,  2,  0,
/* 0x0fa0 */  85,  0,170,254, 47, 29,  0,  0,124,131, 35,120,125, 64, 89,214,
/* 0x0fb0 */  32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,124, 11,  2, 20,
/* 0x0fc0 */ 125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 20,
/* 0x0fd0 */ 176,  7,  2,  0,125, 72, 83,120, 65,186,  0, 24, 72,  0,  0, 28,
/* 0x0fe0 */ 177,103,  2,  0,124,170, 40, 80, 56,100,  0,  1, 65,154,  0, 12,
/* 0x0ff0 */  47,131,  0,255, 64,157,255,108, 47,131,  0,255, 65,157,  0,132,
/* 0x1000 */  63,224,  0,255, 99,255,255,255,127,136,248, 64, 84,103,  8, 60,
/* 0x1010 */ 127, 12,224,  0, 84,169, 64, 46,124,227, 59,120, 65,157,  0, 24,
/* 0x1020 */  65,154,  7, 24,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x1030 */ 125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,125, 64, 89,214,
/* 0x1040 */  32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,124, 11,  2, 20,
/* 0x1050 */ 125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,
/* 0x1060 */ 125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80,
/* 0x1070 */ 125,102, 59, 46, 56,103,  0,  1, 47,131,  0,255, 64,157,255,140,
/* 0x1080 */  47,151,  0,  3, 84,127,  6, 62,127,249,169,174, 59, 57,  0,  1,
/* 0x1090 */  65,157,  0, 12, 58,224,  0,  0, 72,  0,  6,120, 47,151,  0,  9,
/* 0x10a0 */  65,157,  0, 12, 58,247,255,253, 72,  0,  6,104, 58,247,255,250,
/* 0x10b0 */  72,  0,  6, 96,125, 10, 64, 80, 84,224,217,126,127,136,176, 64,
/* 0x10c0 */ 124,  0, 56, 80, 86,233,  8, 60,124,  6,195, 46,124,170, 40, 80,
/* 0x10d0 */ 124,248, 74, 20, 65,157,  0, 32,127,140,224,  0, 65,158,  6, 92,
/* 0x10e0 */ 137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x10f0 */ 124,  5, 75,120,161,103,  1,128, 85,  0,170,254,125, 64, 89,214,
/* 0x1100 */ 127,133, 80, 64, 64,156,  0, 64, 47,151,  0,  6, 32, 11,  8,  0,
/* 0x1110 */ 124,  0, 46,112,126, 15,131,120,124, 11,  2, 20,126, 48,139,120,
/* 0x1120 */ 176,  7,  1,128,125, 72, 83,120, 56,  0,  0,  0,127, 81,211,120,
/* 0x1130 */  64,157,  0,  8, 56,  0,  0,  3,124, 23,  3,120, 56,216,  6,100,
/* 0x1140 */  72,  0,  2, 24,125, 10, 64, 80, 85, 96,217,126,127,136,176, 64,
/* 0x1150 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,128, 65,157,  0, 32,
/* 0x1160 */ 127,140,224,  0, 65,158,  5,212,137, 44,  0,  0, 84,160, 64, 46,
/* 0x1170 */  85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,161,103,  1,152,
/* 0x1180 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0,188,
/* 0x1190 */ 127,138,176, 64, 32, 11,  8,  0,124,  0, 46,112, 86,233, 40, 52,
/* 0x11a0 */ 124, 11,  2, 20,125, 56, 74, 20, 84,107,  8, 60,176,  7,  1,152,
/* 0x11b0 */ 125, 72, 83,120,124,233, 90, 20, 65,157,  0, 32,127,140,224,  0,
/* 0x11c0 */  65,158,  5,120,137, 44,  0,  0, 84,160, 64, 46, 85, 72, 64, 46,
/* 0x11d0 */  57,140,  0,  1,124,  5, 75,120,161,103,  1,224, 85,  0,170,254,
/* 0x11e0 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 72, 47,153,  0,  0,
/* 0x11f0 */  32, 11,  8,  0,124,  0, 46,112,125, 72, 83,120,124, 11,  2, 20,
/* 0x1200 */ 176,  7,  1,224, 65,158,  5, 52, 47,151,  0,  6, 57, 32,  0,  9,
/* 0x1210 */  64,157,  0,  8, 57, 32,  0, 11,124, 26,200, 80,125, 55, 75,120,
/* 0x1220 */ 127,245,  0,174,127,249,169,174, 59, 57,  0,  1, 72,  0,  4,228,
/* 0x1230 */  85, 96,217,126,124,170, 40, 80,124,  0, 88, 80,125, 10, 64, 80,
/* 0x1240 */ 176,  7,  1,224, 72,  0,  0,252,125, 10, 64, 80, 85, 96,217,126,
/* 0x1250 */ 127,136,176, 64,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,152,
/* 0x1260 */  65,157,  0, 32,127,140,224,  0, 65,158,  4,208,137, 44,  0,  0,
/* 0x1270 */  84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,
/* 0x1280 */ 161,103,  1,176, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x1290 */  64,156,  0, 32, 32, 11,  8,  0,125, 72, 83,120,124,  0, 46,112,
/* 0x12a0 */ 126, 41,139,120,124, 11,  2, 20,176,  7,  1,176, 72,  0,  0,140,
/* 0x12b0 */ 125, 10, 64, 80, 85, 96,217,126,127,136,176, 64,124,  0, 88, 80,
/* 0x12c0 */ 124,170, 40, 80,176,  7,  1,176, 65,157,  0, 32,127,140,224,  0,
/* 0x12d0 */  65,158,  4,104,137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46,
/* 0x12e0 */  57,140,  0,  1,124,  5, 75,120,161,103,  1,200, 85,  0,170,254,
/* 0x12f0 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,
/* 0x1300 */ 125, 72, 83,120,124,  0, 46,112,126,  9,131,120,124, 11,  2, 20,
/* 0x1310 */ 176,  7,  1,200, 72,  0,  0, 32, 85, 96,217,126,125,233,123,120,
/* 0x1320 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,200,125, 10, 64, 80,
/* 0x1330 */ 126, 15,131,120,126, 48,139,120,127, 81,211,120,125, 58, 75,120,
/* 0x1340 */  47,151,  0,  6, 56,  0,  0,  8, 64,157,  0,  8, 56,  0,  0, 11,
/* 0x1350 */ 124, 23,  3,120, 56,216, 10,104,127,136,176, 64, 65,157,  0, 32,
/* 0x1360 */ 127,140,224,  0, 65,158,  3,212,137, 44,  0,  0, 84,160, 64, 46,
/* 0x1370 */  85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,161,102,  0,  0,
/* 0x1380 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48,
/* 0x1390 */  84,105, 32, 54, 32, 11,  8,  0,125, 38, 74, 20,124,  0, 46,112,
/* 0x13a0 */ 124, 11,  2, 20,125, 72, 83,120, 56,137,  0,  4, 59, 96,  0,  0,
/* 0x13b0 */ 176,  6,  0,  0, 56, 96,  0,  3, 72,  0,  0,156,125, 10, 64, 80,
/* 0x13c0 */  85, 96,217,126,127,136,176, 64,124,  0, 88, 80,124,170, 40, 80,
/* 0x13d0 */ 176,  6,  0,  0, 65,157,  0, 32,127,140,224,  0, 65,158,  3, 92,
/* 0x13e0 */ 137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x13f0 */ 124,  5, 75,120,161,102,  0,  2, 85,  0,170,254,125, 64, 89,214,
/* 0x1400 */ 127,133, 80, 64, 64,156,  0, 48, 84,105, 32, 54, 32, 11,  8,  0,
/* 0x1410 */ 125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,
/* 0x1420 */  56,137,  1,  4, 59, 96,  0,  8,176,  6,  0,  2, 56, 96,  0,  3,
/* 0x1430 */  72,  0,  0, 36, 85, 96,217,126,124,170, 40, 80,124,  0, 88, 80,
/* 0x1440 */ 125, 10, 64, 80,176,  6,  0,  2, 56,134,  2,  4, 59, 96,  0, 16,
/* 0x1450 */  56, 96,  0,  8, 63,224,  0,255,124,105,  3,166, 59,160,  0,  1,
/* 0x1460 */  99,255,255,255,127,136,248, 64, 87,167,  8, 60,127, 12,224,  0,
/* 0x1470 */  84,169, 64, 46,124,253, 59,120, 65,157,  0, 24, 65,154,  2,188,
/* 0x1480 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x1490 */ 125,100, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x14a0 */  85,105,217,126,124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,
/* 0x14b0 */ 127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x14c0 */ 124,  4, 59, 46, 72,  0,  0, 16,124,170, 40, 80, 59,167,  0,  1,
/* 0x14d0 */ 125,100, 59, 46, 66,  0,255,144, 47,151,  0,  3, 56,  0,  0,  1,
/* 0x14e0 */ 124,  0, 24, 48,127,160,232, 80,127,189,218, 20, 65,157,  1,232,
/* 0x14f0 */  47,157,  0,  3, 58,247,  0,  7,127,169,235,120, 64,157,  0,  8,
/* 0x1500 */  57, 32,  0,  3, 85, 41, 56, 48, 63,224,  0,255,125, 56, 74, 20,
/* 0x1510 */  99,255,255,255, 56,201,  3, 96, 57, 32,  0,  6,125, 41,  3,166,
/* 0x1520 */  56,128,  0,  1,127,136,248, 64, 84,135,  8, 60,127, 12,224,  0,
/* 0x1530 */  84,169, 64, 46,124,228, 59,120, 65,157,  0, 24, 65,154,  1,252,
/* 0x1540 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x1550 */ 125,102, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x1560 */  85,105,217,126,124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,
/* 0x1570 */ 127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x1580 */ 124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80, 56,135,  0,  1,
/* 0x1590 */ 125,102, 59, 46, 66,  0,255,144, 56,132,255,192, 47,132,  0,  3,
/* 0x15a0 */ 124,154, 35,120, 64,157,  1, 40, 47,132,  0, 13,124,137, 14,112,
/* 0x15b0 */  84,128,  7,254, 57,105,255,255, 96, 26,  0,  2,125,105,  3,166,
/* 0x15c0 */  65,157,  0, 32,127, 90, 88, 48, 84,128,  8, 60, 87, 73,  8, 60,
/* 0x15d0 */ 125, 56, 74, 20,125, 32, 72, 80, 56,201,  5, 94, 72,  0,  0,100,
/* 0x15e0 */  57, 41,255,251, 61, 96,  0,255,125, 41,  3,166, 97,107,255,255,
/* 0x15f0 */ 127,136, 88, 64,127, 12,224,  0, 84,169, 64, 46, 87, 90,  8, 60,
/* 0x1600 */  65,157,  0, 24, 65,154,  1, 52,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x1610 */  57,140,  0,  1,125, 37,  3,120, 85,  8,248,126,127,133, 64, 64,
/* 0x1620 */  65,156,  0, 12,124,168, 40, 80, 99, 90,  0,  1, 66,  0,255,196,
/* 0x1630 */  56,  0,  0,  4, 87, 90, 32, 54,124,  9,  3,166, 56,216,  6, 68,
/* 0x1640 */  60, 96,  0,255, 56,128,  0,  1, 96, 99,255,255, 59,224,  0,  1,
/* 0x1650 */ 127,136, 24, 64, 87,231,  8, 60,127, 12,224,  0, 84,169, 64, 46,
/* 0x1660 */ 124,255, 59,120, 65,157,  0, 24, 65,154,  0,208,136, 12,  0,  0,
/* 0x1670 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,102, 58, 46,
/* 0x1680 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0, 85,105,217,126,
/* 0x1690 */ 124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,127,133, 80, 64,
/* 0x16a0 */ 125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46,
/* 0x16b0 */  72,  0,  0, 20,124,170, 40, 80, 59,231,  0,  1,125,102, 59, 46,
/* 0x16c0 */ 127, 90, 35,120, 84,132,  8, 60, 66,  0,255,136, 55, 90,  0,  1,
/* 0x16d0 */  65,130,  0, 72,127,154,200, 64, 59,189,  0,  2, 65,157,  0, 92,
/* 0x16e0 */ 124, 26,200, 80, 59,189,255,255,127,245,  0,174, 49,125,255,255,
/* 0x16f0 */ 125, 43,233, 16,127,249,169,174, 59, 57,  0,  1,124, 20,200, 16,
/* 0x1700 */ 124,  0,  1, 16,124,  0,  0,208,125, 43,  0, 57, 64,130,255,212,
/* 0x1710 */ 127,153,160, 64, 65,156,247,172, 60,  0,  0,255, 96,  0,255,255,
/* 0x1720 */ 127,136,  0, 64, 65,157,  0, 32,127,140,224,  0, 56, 96,  0,  1,
/* 0x1730 */  65,158,  0, 40, 72,  0,  0, 12, 56, 96,  0,  1, 72,  0,  0, 28,
/* 0x1740 */  57,140,  0,  1,125, 40,  2,166,124, 19, 96, 80, 56, 96,  0,  0,
/* 0x1750 */ 144, 14,  0,  0,147, 41,  0,  0,128,  1,  0,100,185,193,  0, 24,
/* 0x1760 */  56, 33,  0, 96,124,  8,  3,166,128,161,  0, 12,128,225,  0,  8,
/* 0x1770 */ 128,165,  0,  0,128, 33,  0,  0,124,165, 58, 20,128,  1,  0,  8,
/* 0x1780 */  56,165,255,255,128, 33,  0,  0,124,  8,  3,166,128,230,  0,  0,
/* 0x1790 */ 125,168,  3,166,124,100, 24, 80,124,135, 40, 80, 56, 99,  0,  1,
/* 0x17a0 */  56,132,  0,  1,144,134,  0,  0, 96,231,  0, 31,124,  0, 56,108,
/* 0x17b0 */ 124,  7, 40, 64,124,  0, 63,172, 56,231,  0, 32, 65,128,255,240,
/* 0x17c0 */ 124,  0,  4,172, 76,  0,  1, 44, 78,128,  0, 32,124,128,  0,  8,
/* 0x17d0 */ 148, 65,255,136,188, 97,  0,  4,127,232,  2,166,130,191,255,252,
/* 0x17e0 */ 131,191,255,244, 86,181,  1,186,127,189,170, 20, 58,181,255,252,
/* 0x17f0 */  56, 96,  0,  0,127,164,235,120, 56,160,  0,  3, 56,192, 16,  2,
/* 0x1800 */  56,224,255,255, 57,  0,  0,  0, 57, 32,  0,  0, 56,  0,  0,197,
/* 0x1810 */  68,  0,  0,  2, 56, 96,255,255,124,124, 27,120, 56,160,  1,136,
/* 0x1820 */ 124,169,  3,166,124,131,234, 20,124,117,250, 20,140,  3,255,255,
/* 0x1830 */ 156,  4,255,255, 66,  0,255,248,124,165,232, 80,124,136,  3,166,
/* 0x1840 */ 124,169,  3,166, 78,128,  0, 32,140,  3,255,255,156,  4,255,255,
/* 0x1850 */  66,  0,255,248,131,223,255,232,127,227,248, 80,127,228,250, 20,
/* 0x1860 */ 127,222, 26, 20,129,159,255,236,127, 68, 98, 20,127, 99, 98, 20,
/* 0x1870 */  59,123,255,232,129,154,  0,  4, 59, 90,  0, 12,127, 90, 98, 20,
/* 0x1880 */ 127, 88,211,120,127,121,219,120, 56,122,  0,  0, 72,  0,  0,189,
/* 0x1890 */  65,130,  0,104,127,123, 26, 20,124,119, 27,120, 56,122,  0,  4,
/* 0x18a0 */  72,  0,  0,169,127, 90, 26, 20,124,118, 27,120, 59, 90,  0, 12,
/* 0x18b0 */ 150,225,255,248,127,232,  3,166, 56,120,  0, 12,126,196,179,120,
/* 0x18c0 */ 127, 37,203,120,124, 38, 11,120,136,248,  0,  8,148, 33,255,232,
/* 0x18d0 */  78,128,  0, 33, 56, 33,  0, 32,136,216,  0,  9, 40,  6,  0,  0,
/* 0x18e0 */  65,130,255,160,136,184,  0, 10,128,152,  0,  0,127, 35,203,120,
/* 0x18f0 */  72,  0,  0,125, 75,255,255,140, 72,  0,  0, 29, 68,  0,  0,  2,
/* 0x1900 */  56, 96,255,255,184, 65,  0,  4, 56, 33,  0,120,125,136,  3,166,
/* 0x1910 */  78,128,  4, 32, 57,128,  0,  6,124,104,  2,166, 56, 99,  0, 24,
/* 0x1920 */ 125,137,  3,166,133,131,255,252,149,153,255,252, 66,  0,255,248,
/* 0x1930 */ 127, 40,  3,166,127,201,  3,166,127,131,227,120,127,164,235,120,
/* 0x1940 */  56,  0,  0, 73, 78,128,  0, 32,137,131,  0,  3,137, 99,  0,  2,
/* 0x1950 */  81,108, 68, 46,137, 99,  0,  1, 81,108,130, 30,137, 99,  0,  0,
/* 0x1960 */  81,108,192, 14,125,131, 99,121, 78,128,  0, 32, 40,  6,  0,208,
/* 0x1970 */  76,130,  0, 32, 84,132,240,191, 77,130,  0, 32, 60,  0,  0, 16,
/* 0x1980 */ 124,  4,  0, 64, 65,128,  0,  8,124,  4,  3,120, 56,165,  1, 32,
/* 0x1990 */ 124,103, 27,120, 56, 99,255,252,124,137,  3,166, 72,  0,  0, 28,
/* 0x19a0 */  85, 96,  2,186,124,  3,  0, 80,124,  0, 58, 20, 80, 11,  1,186,
/* 0x19b0 */ 145, 99,  0,  0, 78, 64,  0, 32,133, 99,  0,  4, 85, 96, 85,190,
/* 0x19c0 */ 124,  0, 40, 64, 65,162,255,220, 66,  0,255,240, 78,128,  0, 32,
/* 0x19d0 */  75,255,253,252,102,105,108,101, 32,102,111,114,109, 97,116, 32,
/* 0x19e0 */ 101,108,102, 51, 50, 45,112,111,119,101,114,112, 99, 10, 10, 83,
/* 0x19f0 */ 101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,
/* 0x1a00 */ 101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32,
/* 0x1a10 */  32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x1a20 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,
/* 0x1a30 */ 102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32,
/* 0x1a40 */  32, 48, 32, 77, 65, 67, 79, 83, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x1a50 */  32, 48, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32,
/* 0x1a60 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1a70 */  32, 49, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32,
/* 0x1a80 */  32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 99, 32, 32, 50,
/* 0x1a90 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x1aa0 */  50, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1ab0 */  48, 49, 52, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 99, 32,
/* 0x1ac0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1ad0 */  32, 32, 51, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32,
/* 0x1ae0 */  32, 32, 48, 49, 50, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x1af0 */  56, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1b00 */  84, 83, 10, 32, 32, 52, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32,
/* 0x1b10 */  32, 32, 32, 32, 32, 48,102, 48, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1b20 */  48, 50, 98, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1b30 */  69, 78, 84, 83, 10, 32, 32, 53, 32, 76, 90, 77, 65, 95, 69, 76,
/* 0x1b40 */  70, 48, 48, 32, 32, 32, 32, 48, 57, 48, 32, 32, 48, 32, 32, 48,
/* 0x1b50 */  32, 32, 48, 51, 97, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1b60 */  78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 76, 90, 77, 65, 95,
/* 0x1b70 */  68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 57, 57, 99, 32, 32, 48,
/* 0x1b80 */  32, 32, 48, 32, 32, 48, 52, 51, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x1b90 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32, 76, 90,
/* 0x1ba0 */  77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 57, 57, 99,
/* 0x1bb0 */  32, 32, 48, 32, 32, 48, 32, 32, 48,100, 99, 99, 32, 32, 50, 42,
/* 0x1bc0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56,
/* 0x1bd0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48,
/* 0x1be0 */  50, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 55, 54, 56, 32,
/* 0x1bf0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1c00 */  32, 32, 57, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32,
/* 0x1c10 */  32, 32, 48, 49, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 55,
/* 0x1c20 */  56, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1c30 */  84, 83, 10, 32, 49, 48, 32, 67, 70, 76, 85, 83, 72, 32, 32, 32,
/* 0x1c40 */  32, 32, 32, 32, 32, 48, 50, 52, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1c50 */  48, 49, 55, 97, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1c60 */  84, 69, 78, 84, 83, 10, 32, 49, 49, 32, 69, 76, 70, 77, 65, 73,
/* 0x1c70 */  78, 89, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32,
/* 0x1c80 */  32, 48, 49, 55, 99, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1c90 */  78, 84, 69, 78, 84, 83, 10, 32, 49, 50, 32, 69, 76, 70, 77, 65,
/* 0x1ca0 */  73, 78, 90, 32, 32, 32, 32, 32, 32, 48, 50, 48, 56, 32, 32, 48,
/* 0x1cb0 */  32, 32, 48, 32, 32, 48, 49, 55, 99, 99, 32, 32, 50, 42, 42, 48,
/* 0x1cc0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79,
/* 0x1cd0 */  76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ce0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x1cf0 */  69, 67, 51, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x1d00 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1d10 */ 100, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 48, 32, 78, 82,
/* 0x1d20 */  86, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1d30 */ 108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1d40 */  32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48,
/* 0x1d50 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 65, 67,
/* 0x1d60 */  79, 83, 48, 48, 48, 32, 48, 32, 77, 65, 67, 79, 83, 48, 48, 48,
/* 0x1d70 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1d80 */  32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 48, 32, 78, 82, 86,
/* 0x1d90 */  95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1da0 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48, 32, 78,
/* 0x1db0 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1dc0 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68, 32, 48, 32, 78, 82,
/* 0x1dd0 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1de0 */  32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78, 82, 86,
/* 0x1df0 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1e00 */  32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 48,
/* 0x1e10 */  32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48,
/* 0x1e20 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x1e30 */  65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x1e40 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1e50 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x1e60 */  32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x1e70 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x1e80 */  70, 76, 85, 83, 72, 32, 48, 32, 67, 70, 76, 85, 83, 72, 10, 48,
/* 0x1e90 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1ea0 */  69, 76, 70, 77, 65, 73, 78, 89, 32, 48, 32, 69, 76, 70, 77, 65,
/* 0x1eb0 */  73, 78, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32,
/* 0x1ec0 */  32, 32, 32, 32, 32, 77, 65, 67, 79, 83, 48, 48, 48, 32, 48, 32,
/* 0x1ed0 */  95,115,116, 97,114,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x1ee0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x1ef0 */  77, 65, 67, 79, 83, 48, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x1f00 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1f10 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x1f20 */  48, 48, 48, 52, 32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 50, 52,
/* 0x1f30 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 43,
/* 0x1f40 */  48,120, 48, 48, 48, 48, 48, 50, 48, 52, 10, 10, 82, 69, 76, 79,
/* 0x1f50 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x1f60 */  79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83,
/* 0x1f70 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x1f80 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x1f90 */  48, 48, 48, 98, 52, 32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 49,
/* 0x1fa0 */  52, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76,
/* 0x1fb0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x1fc0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93,
/* 0x1fd0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x1fe0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x1ff0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 80, 80,
/* 0x2000 */  67, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x2010 */  86, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x2020 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x2030 */  78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x2040 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2050 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 57,
/* 0x2060 */  48, 32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 49, 52, 32, 32, 32,
/* 0x2070 */  32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69,
/* 0x2080 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2090 */  32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,
/* 0x20a0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x20b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x20c0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 80,
/* 0x20d0 */  80, 67, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x20e0 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48, 48, 48, 48,
/* 0x20f0 */  48, 48, 50, 52, 10
};
