;**************************************;
; WASM Checksum Calculation, CRC Block ;
; By Eric Tauck                        ;
;                                      ;
; Defines:                             ;
;                                      ;
;   CrcBlk  return CRC of block        ;
;**************************************;

        jmp     _check3_end

;========================================
; Calculate the 16 bit xmodem type CRC of
; a block.
;
; In: BX= address of bytes; CX= number
;     of bytes.
;
; Out: AX= checksum.

CrcBlk  PROC    NEAR
        sub     ax, ax                  ;zero checksum
        jcxz    _ccblk3                 ;exit if no bytes

        push    di
        push    si
        mov     si, bx                  ;source bytes
        mov     di, OFFSET _ccblk4      ;table
        cld                             ;forward direction

;--- loop for each byte

_ccblk1 mov     bl, ah                  ;high byte to index
        mov     ah, al                  ;low byte to high byte
        lodsb                           ;load new byte
        sub     bh, bh                  ;zero high byte of index
        shl     bx                      ;offset into table
        xor     ax, [bx+di]             ;update CRC
        loop    _ccblk1                 ;loop if more bytes

;--- all bytes processed, send in 16 zero bits

        inc     cx
        inc     cx                      ;two more bytes

_ccblk2 mov     bl, ah                  ;high byte to index
        mov     ah, al                  ;low byte to high byte
        sub     al, al                  ;zero byte
        sub     bh, bh                  ;zero high byte of index
        shl     bx                      ;offset into table
        xor     ax, [bx+di]             ;update CRC
        loop    _ccblk2                 ;loop if more bytes

        pop     si
        pop     di
_ccblk3 ret

; This table is used to update a 16-bit CRC by a byte as follows:
;
;   CRC = ((LowByte(CRC) * 256) + NewByte) XOR CrcTable[HighByte(CRC)]

_ccblk4 LABEL   WORD
        DW      0, 4129, 8258, 12387, 16516, 20645, 24774, 28903
        DW      33032, 37161, 41290, 45419, 49548, 53677, 57806
        DW      61935, 4657, 528, 12915, 8786, 21173, 17044
        DW      29431, 25302, 37689, 33560, 45947, 41818, 54205
        DW      50076, 62463, 58334, 9314, 13379, 1056, 5121
        DW      25830, 29895, 17572, 21637, 42346, 46411, 34088
        DW      38153, 58862, 62927, 50604, 54669, 13907, 9842
        DW      5649, 1584, 30423, 26358, 22165, 18100, 46939
        DW      42874, 38681, 34616, 63455, 59390, 55197, 51132
        DW      18628, 22757, 26758, 30887, 2112, 6241, 10242
        DW      14371, 51660, 55789, 59790, 63919, 35144, 39273
        DW      43274, 47403, 23285, 19156, 31415, 27286, 6769
        DW      2640, 14899, 10770, 56317, 52188, 64447, 60318
        DW      39801, 35672, 47931, 43802, 27814, 31879, 19684
        DW      23749, 11298, 15363, 3168, 7233, 60846, 64911
        DW      52716, 56781, 44330, 48395, 36200, 40265, 32407
        DW      28342, 24277, 20212, 15891, 11826, 7761, 3696
        DW      65439, 61374, 57309, 53244, 48923, 44858, 40793
        DW      36728, 37256, 33193, 45514, 41451, 53516, 49453
        DW      61774, 57711, 4224, 161, 12482, 8419, 20484
        DW      16421, 28742, 24679, 33721, 37784, 41979, 46042
        DW      49981, 54044, 58239, 62302, 689, 4752, 8947
        DW      13010, 16949, 21012, 25207, 29270, 46570, 42443
        DW      38312, 34185, 62830, 58703, 54572, 50445, 13538
        DW      9411, 5280, 1153, 29798, 25671, 21540, 17413
        DW      42971, 47098, 34713, 38840, 59231, 63358, 50973
        DW      55100, 9939, 14066, 1681, 5808, 26199, 30326
        DW      17941, 22068, 55628, 51565, 63758, 59695, 39368
        DW      35305, 47498, 43435, 22596, 18533, 30726, 26663
        DW      6336, 2273, 14466, 10403, 52093, 56156, 60223
        DW      64286, 35833, 39896, 43963, 48026, 19061, 23124
        DW      27191, 31254, 2801, 6864, 10931, 14994, 64814
        DW      60687, 56684, 52557, 48554, 44427, 40424, 36297
        DW      31782, 27655, 23652, 19525, 15522, 11395, 7392
        DW      3265, 61215, 65342, 53085, 57212, 44955, 49082
        DW      36825, 40952, 28183, 32310, 20053, 24180, 11923
        DW      16050, 3793, 7920 
        ENDP

_check3_end
