;**********************************;
; WASM Character Drawing           ;
; By Eric Tauck                    ;
;                                  ;
; Defines:                         ;
;                                  ;
;   DrwBox  draw a double line box ;
;                                  ;
; Requires:                        ;
;                                  ;
;   VIDEO4.ASM                     ;
;   VIDEO5.ASM                     ;
;**********************************;

        jmps    _draw1_end

;================================================
; Display a top or bottom edge.
;
; In: AL= left corner character; AH= right corner
;     character; SI= rows and columns.

_drw_edge PROC  NEAR
        push    ax
        call    WrtChr          ;display left corner
        call    CurAdv          ;advance cursor

        mov     al, ''         ;bar
        mov     cx, si          ;put columns in CL
        dec     cl
        dec     cl              ;reduce for corners
        call    WrtChrs         ;display
        call    CurAdv          ;advance cursor

        pop     ax              ;restore corners
        mov     al, ah          ;load second corner
        call    WrtChr          ;display
        ret
        ENDP

;================================================
; Draw a double line box.  Note: this routine
; does not preserve the cursor location.
;
; In: BH= top left row; BL= top left
;     column; CH= bottom left row; CL=
;     bottom left column.

DrwBox  PROC   NEAR
        push    di
        push    si

        mov     di, bx          ;save home location
        sub     cx, bx          ;rows and columns in CH and CL
        mov     si, cx          ;save rows and columns in SI
        add     si, 0101H       ;adjust

;--- display top line

        mov     ax, di          ;home location
        call    CurMov          ;position cursor
        mov     ax, 'ɻ'        ;load corners
        call    _drw_edge       ;draw edge

;--- display bottom line

        mov     ax, si          ;rows and columns
        sub     al, al          ;zero columns
        add     ax, di          ;add base location
        dec     ah              ;adjust
        call    CurMov          ;position cursor
        mov     ax, 'ȼ'        ;load corners
        call    _drw_edge       ;draw edge

;--- display sides

        mov     ax, si          ;rows and columns
        sub     al, al          ;zero columns
        add     ax, di          ;add base, bottom left corner
        dec     ah              ;last row
        and     si, 00FFH       ;just keep columns
        dec     si              ;ajust, offset from edge to edge
        jmps    _drwbx2

_drwbx1 push    ax              ;save location
        call    CurMov          ;move cursor
        mov     al, ''         ;load character
        call    WrtChr          ;display
        pop     ax
        push    ax
        add     ax, si          ;add column offset
        call    CurMov          ;position cursor
        mov     al, ''         ;load character
        call    WrtChr          ;display
        pop     ax

_drwbx2 dec     ah              ;decrement row
        cmp     ax, di          ;check if done
        jne     _drwbx1

        pop     si
        pop     di
        ret
        ENDP

_draw1_end
