;***************************************;
; WASM File Module                      ;
; By Eric Tauck                         ;
;                                       ;
; Defines:                              ;
;                                       ;
;   FilOpn  open an existing file       ;
;   FilCre  create or truncate a file   ;
;   FilClo  close an open file          ;
;   FilRea  read from a file            ;
;   FilWri  write to a file             ;
;   FilSee  move the read/write pointer ;
;***************************************;

        jmps    _file_end

;========================================
; Global constants

;--- open types for FilOpn

OPEN_READ       EQU     0       ;open for reading
OPEN_WRITE      EQU     1       ;open for writing
OPEN_BOTH       EQU     2       ;open for reading and writing

;--- attributes for FilCre, attributes may be combined (ORed together)

ATTR_NORMAL     EQU     00000000B       ;normal file (no attributes)
ATTR_READONLY   EQU     00000001B       ;readonly file
ATTR_HIDDEN     EQU     00000010B       ;hidden file
ATTR_SYSTEM     EQU     00000100B       ;system file

;--- seek types for FilSee

SEEK_FRONT      EQU     0       ;from front, unsigned offset
SEEK_CURRENT    EQU     1       ;from current location, signed offset
SEEK_END        EQU     2       ;from end, signed offset

;========================================
; Open an existing file.
;
; In: AX= address of file name; CL= open
;     type.
;
; Out: AX= DOS error code or file handle;
;      CY= set if error.

FilOpn  PROC   NEAR
        mov     dx, ax          ;address of file name
        mov     ah, 3DH         ;open function
        mov     al, cl          ;open type
        int     21H             ;execute
        ret
        ENDP

;========================================
; Create a new file or truncate an
; existing one.
;
; In: AX= address of file name; CL= file
;     attribute.
;
; Out: AX= DOS error code or file handle;
;      CY= set if error.

FilCre  PROC   NEAR
        mov     dx, ax          ;address of file name
        mov     ah, 03CH        ;create file
        sub     ch, ch          ;zero high byte of attribute
        int     21H             ;execute
        ret
        ENDP

;========================================
; Close a file.
;
; In: BX= file handle.
;
; Out: AL= DOS error code; CY= set if
;      error.

FilClo  PROC  NEAR
        mov     ah, 3EH                 ;close file function
        int     21H                     ;execute
        ret
        ENDP

;========================================
; Read from a file.
;
; In: BX= file handle; DX:AX= address of
;     buffer; CX= bytes.
;
; Out: CX= bytes read; AL= DOS error
;      code (0 if EOF); CY= set if bytes
;      not all read.

FilRea  PROC   NEAR
        push    ds
        mov     ds, dx          ;
        mov     dx, ax          ;address of buffer in DS:DX
        mov     ah, 3FH         ;read file function
        int     21H             ;execute
        jc      _flrea1         ;jump if error
        xchg    cx, ax          ;swap target and actual bytes
        cmp     cx, ax          ;check if too few transfered
        jb      _flrea2         ;jump if so
        pop     ds
        clc
        ret

;--- error returned by DOS

_flrea1 sub     cx, cx          ;zero bytes transfered
        pop     ds
        stc
        ret

;--- not all bytes read, but no error

_flrea2 sub     al, al          ;zero error code
        pop     ds
        stc
        ret
        ENDP

;========================================
; Write to a file.
;
; In: BX= file handle; DX:AX= address of
;     buffer; CX= bytes.
;
; Out: CX= bytes written; AL= DOS error
;      code (0 if disk full); CY= set if
;      bytes not all written.

FilWri  PROC   NEAR
        push    ds
        mov     ds, dx          ;
        mov     dx, ax          ;address of buffer in DS:DX
        mov     ah, 40H         ;write file function
        int     21H             ;execute
        jc      _flwri1         ;jump if error
        xchg    cx, ax          ;swap target and actual bytes
        cmp     cx, ax          ;check if too few transfered
        jb      _flwri2         ;jump if so
        pop     ds
        clc
        ret

;--- error returned by DOS

_flwri1 sub     cx, cx          ;zero bytes transfered
        pop     ds
        stc
        ret

;--- not all bytes written, but no error

_flwri2 sub     al, al          ;zero error code
        pop     ds
        stc
        ret
        ENDP

;========================================
; Move a file read/write pointer.
;
; In: BX= file handle; CL= type of seek;
;     DX:AX= seek value.
;
; Out: AL= DOS error code; CY= set if
;      error.

FilSee  PROC   NEAR
        push    cx
        mov     cx, dx                  ;
        mov     dx, ax                  ;seek value
        pop     ax                      ;restore seek type
        mov     ah, 42H                 ;seek function
        int     21H                     ;execute
        ret
        ENDP

_file_end
