;*****************************************;
; WASM Multiplex Support, Resident Kernel ;
; By Eric Tauck                           ;
;                                         ;
; Defines:                                ;
;                                         ;
;   Old2F   old interrupt 2F              ;
;                                         ;
; Requires:                               ;
;                                         ;
;   MULPLX2.ASM                           ;
;                                         ;
; This code is the resident portion of    ;
; the multiplex support.  The routines in ;
; MULPLX2.ASM initialize this code and    ;
; data. This file should included within  ;
; the resident portion of the TSR, while  ;
; MULPLX2.ASM should be included in the   ;
; transient portion.                      ;
;                                         ;
; Note: This code must be branched around ;
; (with a JMP or JMPS).                   ;
;*****************************************;

; RES_OFF and RES_ID must be EQUated by the user.  RES_ID is a 16 bit value
; that should be unique for all programs using MULPLX1.ASM and MULPLX2.ASM.
; RES_OFF is the byte offset to subtract from all memory references if the
; TSR is shifted to a lower memory location.  If the TSR is not shifted,
; RES_OFF should be set to zero.

;================================================
; Multiplex interrupt handler.

;--- check multiplex number

_PlxNew seg     cs
        cmp     ax, _PlxNum - RES_OFF   ;check if query this TSR
        je      _PlxNe1                 ;jump if so
        seg     cs
        call    _PlxHan - RES_OFF       ;call custom handler
        jc      _PlxNe2                 ;jump if exit
        seg     cs
        jmp     PlxOld - RES_OFF        ;chain to old interrupt

;--- number matches query, return resident info

_PlxNe1 sub     ax, ax                  ;acknowledge
        mov     bx, RES_ID              ;return ID
        seg     cs
        mov     cx, _PlxVer - RES_OFF   ;return resident version
        mov     dx, cs                  ;return segment
_PlxNe2 iret

;================================================
; Dummy hander. Only chains to previous handler.

_PlxDef PROC    NEAR
        clc
        ret
        ENDP

;================================================
; Multiplex data.

PlxOld  LABEL   DWORD                   ;original interrupt address
        DS      4

_PlxNum DW      ?                       ;multiplex query number
_PlxVer DW      ?                       ;resident version number
_PlxHan DW      OFFSET _PlxDef-RES_OFF  ;user handler
