;********************************;
; WASM String Module             ;
; By Eric Tauck                  ;
;                                ;
; Defines:                       ;
;                                ;
;   StrLen  return string length ;
;   StrCpy  copy string          ;
;   StrCmp  compare two strings  ;
;********************************;

        jmps    _string_end

;========================================
; Determine the length of a string.
;
; In: AX= string address.
;
; Out: AX= length.

StrLen  PROC    NEAR
        push    di
        mov     cx, 0FFFFH      ;byte to scan
        mov     di, ax          ;address
        sub     al, al          ;byte to scan for
        cld                     ;forward direction
        repne
        scasb                   ;scan for zero
        mov     ax, cx          ;remaining bytes
        inc     ax
        inc     ax              ;adjust
        neg     ax              ;byte count
        pop     di
        ret
        ENDP

;========================================
; Copy a string to a new address.
;
; In: AX= source address; BX=
;     destination address.
;
; Out: AX= length of string copied.

StrCpy  PROC    NEAR
        push    di
        push    si
        mov     si, ax          ;load source
        mov     di, bx          ;load destination
        sub     ax, ax          ;zero length
        cld                     ;forward direction
        mov     ax, si          ;starting offset
_stcpy1 movsb                   ;copy byte
        cmp     BYTE [si-1], 0  ;check if end of string
        jnz     _stcpy1         ;loop back if not
        sub     ax, si          ;negative displacement
        neg     ax              ;return length
        dec     ax              ;don't count NUL
        pop     si
        pop     di
        ret
        ENDP

;========================================
; Compare two strings.
;
; In: AX= string one; BX= string two.
;
; Out: CY= set if different.

StrCmp  PROC    NEAR
        push    di
        push    si
        mov     si, ax          ;string one
        mov     di, bx          ;string two
        cld                     ;forward direction

;--- loop for each byte

_stcmp1 cmpsb                   ;compare bytes
        jne     _stcmp2         ;jump if not same
        cmp     BYTE [si-1], 0  ;check if end of string
        jnz     _stcmp1         ;loop back if not

;--- matched

        pop     si
        pop     di
        clc
        ret

;--- no match

_stcmp2 pop     si
        pop     di
        stc
        ret
        ENDP

_string_end
