;D. E. Johnson's Simple Macro-Using Translator (SMUT)
;Illustrative use of macros for easy-to-read assembly
 list-
;LET dest,p0{,m1,p1,...m4,p4} (dest := expression)
;  math operations: PLUS, MINUS, TIMES, DIVBY
;INPUT p (decimal word from keyboard)
;OUTPUT p1{,p2,...p4} (decimal words, space after)
;DISPLAY 'string of chars\' ('\'=eoln)
;REPEAT (non-nestable)
;UNTIL p1,cond,expression (cond = EQ,NE,LT,GT,LE,GE)
;STOP (return to DOS)
;START = required starting label (not a macro)
;
;DS=CS & regs AX & DX are local/parameters
	jmp	start	;skip to program
;***** REPEAT ... UNTIL subroutines ****
setr	pop	reta	;set repeat addr
	push	ax	;dummy addr
rpt	inc	sp	;remove return addr
	inc	sp
	jmp near [reta]	;goto start of loop
reta	dw	0	;loop addr
gt	jg	rpt	;repeat loop
	retn		;end of loop
lt	jl	rpt	;repeat loop
	retn		;end of loop
eq	je	rpt	;repeat loop
	retn		;end of loop
ne	jne	rpt	;repeat loop
	retn		;end of loop
le	jle	rpt	;repeat loop
	retn		;end of loop
ge	jge	rpt	;repeat loop
	retn		;end of loop
;**** Output subroutines **********
dchar	proc	near	;display char in AL
	push	si
	push	bx
	push	di
	push	bp
	xor	bx,bx
	mov	ah,14
	int	16	;bios output
	pop	bp
	pop	di
	pop	bx
	pop	si
	ret
  endp ;dchar
outs	proc	near	;display string
	pop	ax	;assume cs=ds
	push	si
	xchg	ax,si	;si = char addr
	cld
slp	lodsb
	test	al,al
	jz	estr
	cmp	al,'\'
	jne	dout
	mov	al,13	;cr
	call	dchar
	mov	al,10	;lf
dout	call	dchar	;display char
	jmps	slp	;next
estr	pop	ax
	xchg	ax,si
	push	ax	;return addr
	ret
  endp ;outs

ddisp	proc	near	;decimal display
	push	bx
	mov	bx,10
	mov	dl,-16	;+'0' = space
	push	dx	;trailer
	test	ax,ax
	jns	plp
	neg	ax	;output as +
	push	ax
	mov	al,'-' ;negative
	call	dchar
	pop	ax
plp	cwd		;32-bit
	idiv	bx
	push	dx	;remainder
	test	ax,ax
	jnz	plp
	dec	bx
	jns	olp
olp	pop	ax
	add	al,'0'
	call	dchar
	cmp	al,' '	;trailer?
	jnz	olp
	pop	bx
	ret
  endp ;ddisp
;****** Input subroutine ******
inax	proc	near	;cx <-- input
	push	cx
	xor	cx,cx	;word <-- 0
ilp	mov	ah,0
	int	22	;al <-- char
	call	dchar
	cmp	al,'9'	;valid digit?
	ja	ein
	sub	al,'0'
	js	ein
	mov	ah,0	;AX=digit't value
	xchg	ax,cx
	mov	dx,10
	mul	dx	;accumulated * 10
	add	cx,ax
	jmps	ilp
ein	xchg	ax,cx	;AX = decimal input
	pop	cx
	ret
   endp
;****** Equates for math ********
plus	equ	1
minus	equ	2
times	equ	3
divby	equ	4
;******** Macros *****************
math	macro a,b,c,d,e,f,g,h ;AX = accumulator
lx	equ	$
  if a=plus
    	add	ax,b
  elseif a=minus
	sub	ax,b
  elseif a=times
    if type(b)=type(300) ;immediate?
	mov	bp,b
	imul	bp
     else
	imul	b	;DX,AX = product
     endif
  elseif a=divby
	cwd	;DX,AX = quotient
    if type(b)=type(300) ;immediate?
	mov	bp,b
	idiv	bp
     else
	idiv	b
     endif
  else
	error 'Not a valid math operation'
  endif
  ifn type(c)=type() ;defined?
	math c,d,e,f,g,h ;recursively
  endif
 endm; math

let	macro r,a,j,b,k,c,l,d,m,e
;j - m = operations, a-e = operands, r = result
	mov	ax,a	;first operand
  ifn type(j)=type()	;operation?
	math	j,b,k,c,l,d,m,e
  endif
	mov	r,ax	;set result
  endm ;let

repeat	macro	;set loop start point
	call	setr	;tos=loop addr
 endm ;repeat

until	macro ls,ro,a,b,c,d,e,f,g,h,i
	mov	ax,a	;evaluate expression
  ifn type(b)=type()
	math	b,c,d,e,f,g,h,i
  endif
	cmp	ax,ls	;reverse  comparison
	call	ro
 endm ;until
;*** I/O macros *********
input	macro	inpar
	call	inax
	mov	inpar,ax
 endm ;input
output macro d1,d2,d3,d4
	mov	ax,d1
	call	ddisp
  ifn type(d2)=type()
	output d2,d3,d4
  endif
 endm ;output
display macro strp ;string output
	call	outs
	db	strp,0
 endm ;outstr

stop	macro ;return to DOS
	retn
 endm ; stop

