;=======================================================================
; Computer Reboot
;
; This program performs a cold (with memory check) or warm (without
; memory check) boot.  A cold boot is just as if the computer has
; been turned off and then back on.  The memory will be checked for
; errors.  A warm boot is the same as pressing CTRL-ALT-DEL.  The
; memory is not checked for errors.  This program might be useful
; in a batch file that changes the system parameters and then must
; restart the computer.
;
; Examples:
;
;  BOOT warm
;
;    this will initiate a warm boot
;
;  BOOT cold
;
;    this will initiate a cold boot
;
; WARNING: Booting the computer erases all data that has not been
; saved to disk or some other nonvolatile source.

;================================================
; Program entry point.

        cld                             ;forward direction
        mov     si, CMD_LINE            ;get command line location 
        lodsb                           ;load length and point to first byte
        or      al, al                  ;check if no parameter
        jz      main2

        mov     cl, al
        sub     ch, ch                  ;CX has byte count

;--- skip preceding delimiters in command line

main1   cmp     BYTE [si], ' '          ;check if space or control character
        ja      main3                   ;exit loop if not
        inc     si                      ;next byte
        loop    main1                   ;loop back if more

;--- illegal parameter

main2   mov     dx, OFFSET Err_Mes      ;message
        mov     ah, 9                   ;DOS print function
        int     21H                     ;execute

        mov     ax, 4CFFH               ;exit with error code 255
        int     21H                     ;execute

;--- found start of parameter

main3   cmp     cx, 4                   ;check if too few bytes
        jb      main2                   ;jump if so, error
        je      main4                   ;jump if same length
        mov     cx, 4                   ;set to max length, ignore other chars

main4   push    cx
        push    si

;--- check if cold parameter

        mov     ax, COLD_BOOT           ;cold boot flag
        mov     di, OFFSET Cold         ;check if cold message
        call    Cmp_Str                 ;compare strings
        jz      main5                   ;jump if equal, cold boot

;--- not cold, check if warm parameter

        pop     si
        pop     cx

        mov     ax, WARM_BOOT           ;warm boot flag
        mov     di, OFFSET Warm         ;check if warm message
        call    Cmp_Str                 ;compare strings
        jnz     main2                   ;jump if not equal, error

;--- continue with reboot, flag in ax

main5   sub     bx, bx
        mov     ds, bx                  ;segment zero
        mov     [RESET_FLAG], ax        ;set reset flag

;--- the following code initializes the registers and is probably not needed,
;--- the "Intel iAPX 86/88, 186/188 User's Manual Programmer's Reference" says
;--- this is done by a hardware reset (through the ResET lines) and it does
;--- seem to work okay without it

        sub     ax, ax                  ;zero to ax
        push    ax
        popf                            ;clear all flags

        mov     ds, ax
        mov     es, ax
        mov     ss, ax                  ;clear segment regs

;--- initiate reboot, jump to first instruction

        jmp     0, 0FFFFH               ;branch to FFFF:0000

;================================================
; Compare two (text) strings.
;  In: DI= string one; SI= string two, which is
;   converted to lower-case; CX= bytes to check.
;  Out: ZF= set if strings are equal.

Cmp_Str PROC NEAR
cmpstr1 or      BYTE [si], 'a'-'A'      ;make lower-case
        cmpsb                           ;compare bytes
        jne     cmpstr2                 ;jump if no match
        loop    cmpstr1                 ;loop back if more to check
cmpstr2 ret
        ENDP                    ;Cmp_Str

;================================================
; Program data.

;--- parameter data

CMD_LINE        EQU    80h       ;offset of command line
Cold            DB     'cold'    ;cold parameter
Warm            DB     'warm'    ;warm parameter

;--- reset flag data; note that since the flag's cleared value (cold boot) is
;--- is not defined in the BIOS data area, I used an abitrary number that is
;--- not equal to the set value; if the operating system or BIOS uses this
;--- variable for other purposes, doing a cold boot might cause unexpected
;--- results or a system crash

RESET_FLAG      EQU     0472h   ;memory offset, at segment 0
COLD_BOOT       EQU     0000h   ;value to set if cold boot, <> WARM_BOOT
WARM_BOOT       EQU     1234h   ;value to set if warm boot

;--- error message

Err_Mes         DB      'BOOT: usage is BOOT WARM or BOOT COLD',13,10,'$'
