/*
 *  wmilib.h    Windows Management Instrumentation (WMI) library functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WMILIB_
#define _WMILIB_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* WMI GUID registration information */
typedef struct  _WMIGUIDREGINFO {
    LPCGUID Guid;
    ULONG   InstanceCount;
    ULONG   Flags;
} WMIGUIDREGINFO;
typedef WMIGUIDREGINFO  *PWMIGUIDREGINFO;

/* WMI enable/disable control values */
typedef enum _WMIENABLEDISABLECONTROL {
    WmiEventControl     = 0,
    WmiDataBlockControl = 1
} WMIENABLEDISABLECONTROL;
typedef WMIENABLEDISABLECONTROL *PWMIENABLEDISABLECONTROL;

/* System control IRP dispositions */
typedef enum _SYSCTL_IRP_DISPOSITION {
    IrpProcessed    = 0,
    IrpNotCompleted = 1,
    IrpNotWmi       = 2,
    IrpForward      = 3
} SYSCTL_IRP_DISPOSITION;
typedef SYSCTL_IRP_DISPOSITION  *PSYSCTL_IRP_DISPOSITION;

/* WMI query callbacks */
typedef NTSTATUS (NTAPI WMI_QUERY_REGINFO_CALLBACK)( PDEVICE_OBJECT, PULONG, PUNICODE_STRING, PUNICODE_STRING *, PUNICODE_STRING, PDEVICE_OBJECT * );
typedef NTSTATUS (NTAPI WMI_QUERY_DATABLOCK_CALLBACK)( PDEVICE_OBJECT, PIRP, ULONG, ULONG, ULONG, PULONG, ULONG, PUCHAR );
typedef NTSTATUS (NTAPI WMI_SET_DATABLOCK_CALLBACK)( PDEVICE_OBJECT, PIRP, ULONG, ULONG, ULONG, PUCHAR );
typedef NTSTATUS (NTAPI WMI_SET_DATAITEM_CALLBACK)( PDEVICE_OBJECT, PIRP, ULONG, ULONG, ULONG, ULONG, PUCHAR );
typedef NTSTATUS (NTAPI WMI_EXECUTE_METHOD_CALLBACK)( PDEVICE_OBJECT, PIRP, ULONG, ULONG, ULONG, ULONG, ULONG, PUCHAR );
typedef NTSTATUS (NTAPI WMI_FUNCTION_CONTROL_CALLBACK)( PDEVICE_OBJECT, PIRP, ULONG, WMIENABLEDISABLECONTROL, BOOLEAN );
typedef WMI_QUERY_REGINFO_CALLBACK      *PWMI_QUERY_REGINFO;
typedef WMI_QUERY_DATABLOCK_CALLBACK    *PWMI_QUERY_DATABLOCK;
typedef WMI_SET_DATABLOCK_CALLBACK      *PWMI_SET_DATABLOCK;
typedef WMI_SET_DATAITEM_CALLBACK       *PWMI_SET_DATAITEM;
typedef WMI_EXECUTE_METHOD_CALLBACK     *PWMI_EXECUTE_METHOD;
typedef WMI_FUNCTION_CONTROL_CALLBACK   *PWMI_FUNCTION_CONTROL;

/* WMI library context */
typedef struct _WMILIB_CONTEXT {
    ULONG                   GuidCount;
    PWMIGUIDREGINFO         GuidList;
    PWMI_QUERY_REGINFO      QueryWmiRegInfo;
    PWMI_QUERY_DATABLOCK    QueryWmiDataBlock;
    PWMI_SET_DATABLOCK      SetWmiDataBlock;
    PWMI_SET_DATAITEM       SetWmiDataItem;
    PWMI_EXECUTE_METHOD     ExecuteWmiMethod;
    PWMI_FUNCTION_CONTROL   WmiFunctionControl;
} WMILIB_CONTEXT;
typedef WMILIB_CONTEXT  *PWMILIB_CONTEXT;

/* Functions in WMILIB.SYS */
#if (NTDDI_VERSION >= 0x05000000)
NTSTATUS NTAPI  WmiCompleteRequest( PDEVICE_OBJECT, PIRP, NTSTATUS, ULONG, CCHAR );
NTSTATUS NTAPI  WmiFireEvent( PDEVICE_OBJECT, LPGUID, ULONG, ULONG, PVOID );
NTSTATUS NTAPI  WmiSystemControl( PWMILIB_CONTEXT, PDEVICE_OBJECT, PIRP, PSYSCTL_IRP_DISPOSITION );
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WMILIB_ */
