/*
 *  evcode.h    ActiveMovie event codes
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ActiveMovie event codes */
#define EC_SYSTEMBASE                   0x0000
#define EC_USER                         0x8000
#define EC_COMPLETE                     0x0001
#define EC_USERABORT                    0x0002
#define EC_ERRORABORT                   0x0003
#define EC_TIME                         0x0004
#define EC_REPAINT                      0x0005
#define EC_STREAM_ERROR_STOPPED         0x0006
#define EC_STREAM_ERROR_STILLPLAYING    0x0007
#define EC_ERROR_STILLPLAYING           0x0008
#define EC_PALETTE_CHANGED              0x0009
#define EC_VIDEO_SIZE_CHANGED           0x000A
#define EC_QUALITY_CHANGE               0x000B
#define EC_SHUTTING_DOWN                0x000C
#define EC_CLOCK_CHANGED                0x000D
#define EC_PAUSED                       0x000E
#define EC_OPENING_FILE                 0x0010
#define EC_BUFFERING_DATA               0x0011
#define EC_FULLSCREEN_LOST              0x0012
#define EC_ACTIVATE                     0x0013
#define EC_NEED_RESTART                 0x0014
#define EC_WINDOW_DESTROYED             0x0015
#define EC_DISPLAY_CHANGED              0x0016
#define EC_STARVATION                   0x0017
#define EC_OLE_EVENT                    0x0018
#define EC_NOTIFY_WINDOW                0x0019
#define EC_STREAM_CONTROL_STOPPED       0x001A
#define EC_STREAM_CONTROL_STARTED       0x001B
#define EC_END_OF_SEGMENT               0x001C
#define EC_SEGMENT_STARTED              0x001D
#define EC_LENGTH_CHANGED               0x001E
#define EC_DEVICE_LOST                  0x001F
#define EC_SAMPLE_NEEDED                0x0020
#define EC_PROCESSING_LATENCY           0x0021
#define EC_SAMPLE_LATENCY               0x0022
#define EC_SCRUB_TIME                   0x0023
#define EC_STEP_COMPLETE                0x0024
#define EC_TIMECODE_AVAILABLE           0x0030
#define EC_EXTDEVICE_MODE_CHANGE        0x0031
#define EC_STATE_CHANGE                 0x0032
#define EC_GRAPH_CHANGED                0x0050
#define EC_CLOCK_UNSET                  0x0051
#define EC_VMR_RENDERDEVICE_SET         0x0053
#define EC_VMR_SURFACE_FLIPPED          0x0054
#define EC_VMR_RECONNECTION_FAILED      0x0055
#define EC_PREPROCESS_COMPLETE          0x0056
#define EC_CODECAPI_EVENT               0x0057
#define EC_WMT_EVENT_BASE               0x0251
#define EC_WMT_INDEX_EVENT              (EC_WMT_EVENT_BASE + 0)
#define EC_WMT_EVENT                    (EC_WMT_EVENT_BASE + 1)
#define EC_BUILT                        0x0300
#define EC_UNBUILT                      0x0311
#define EC_SKIP_FRAMES                  0x0025
#define EC_PLEASE_REOPEN                0x0040
#define EC_STATUS                       0x0041
#define EC_MARKER_HIT                   0x0042
#define EC_LOADSTATUS                   0x0043
#define EC_FILE_CLOSED                  0x0044
#define EC_ERRORABORTEX                 0x0045
#define EC_NEW_PIN                      0x0020
#define EC_RENDER_FINISHED              0x0021
#define EC_EOS_SOON                     0x0046
#define EC_CONTENTPROPERTY_CHANGED      0x0047
#define EC_BANDWIDTHCHANGE              0x0048
#define EC_VIDEOFRAMEREADY              0x0049

/* VMR render device flags */
#define VMR_RENDER_DEVICE_OVERLAY   0x0001
#define VMR_RENDER_DEVICE_VIDMEM    0x0002
#define VMR_RENDER_DEVICE_SYSMEM    0x0004

/* ActiveMovie load status values */
#define AM_LOADSTATUS_CLOSED        0x0000
#define AM_LOADSTATUS_LOADINGDESCR  0x0001
#define AM_LOADSTATUS_LOADINGMCAST  0x0002
#define AM_LOADSTATUS_LOCATING      0x0003
#define AM_LOADSTATUS_CONNECTING    0x0004
#define AM_LOADSTATUS_OPENING       0x0005
#define AM_LOADSTATUS_OPEN          0x0006

/* ActiveMovie content property flags */
#define AM_CONTENTPROPERTY_TITLE        0x0001
#define AM_CONTENTPROPERTY_AUTHOR       0x0002
#define AM_CONTENTPROPERTY_COPYRIGHT    0x0004
#define AM_CONTENTPROPERTY_DESCRIPTION  0x0008

/* Windows Media event data */
typedef struct {
    HRESULT hrStatus;
    void    *pData;
} AM_WMT_EVENT_DATA;

#ifdef __cplusplus
} /* extern "C" */
#endif
