/*
 *  mlang.h     Multilanguage interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __mlang_h__
#define __mlang_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <unknwn.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Script identifier data types */
typedef BYTE    SCRIPT_ID;
typedef __int64 SCRIPT_IDS;

/* Maximum name lengths */
#define MAX_MIMECP_NAME     64
#define MAX_MIMECSET_NAME   50
#define MAX_MIMEFACE_NAME   32
#define MAX_RFC1766_NAME    6
#define MAX_LOCALE_NAME     32
#define MAX_SCRIPT_NAME     48

/* IMultiLanguage2::ValidateCodePageEx() flags */
#define CPIOD_PEEK          0x40000000L
#define CPIOD_FORCE_PROMPT  0x80000000L

/* Multilanguage string flags */
typedef enum tagMLSTR_FLAGS {
    MLSTR_READ  = 1,
    MLSTR_WRITE = 2
} MLSTR_FLAGS;

/* MIME content flags */
typedef enum tagMIMECONTF {
    MIMECONTF_MAILNEWS          = 0x00000001,
    MIMECONTF_BROWSER           = 0x00000002,
    MIMECONTF_MINIMAL           = 0x00000004,
    MIMECONTF_IMPORT            = 0x00000008,
    MIMECONTF_SAVABLE_MAILNEWS  = 0x00000100,
    MIMECONTF_SAVABLE_BROWSER   = 0x00000200,
    MIMECONTF_EXPORT            = 0x00000400,
    MIMECONTF_PRIVCONVERTER     = 0x00010000,
    MIMECONTF_VALID             = 0x00020000,
    MIMECONTF_VALID_NLS         = 0x00040000,
    MIMECONTF_MIME_IE4          = 0x10000000,
    MIMECONTF_MIME_LATEST       = 0x20000000,
    MIMECONTF_MIME_REGISTRY     = 0x40000000
} MIMECONTF;

/* MIME code page information */
typedef struct tagMIMECPINFO {
    DWORD   dwFlags;
    UINT    uiCodePage;
    UINT    uiFamilyCodePage;
    WCHAR   wszDescription[MAX_MIMECP_NAME];
    WCHAR   wszWebCharset[MAX_MIMECSET_NAME];
    WCHAR   wszHeaderCharset[MAX_MIMECSET_NAME];
    WCHAR   wszBodyCharset[MAX_MIMECSET_NAME];
    WCHAR   wszFixedWidthFont[MAX_MIMEFACE_NAME];
    WCHAR   wszProportionalFont[MAX_MIMEFACE_NAME];
    BYTE    bGDICharset;
} MIMECPINFO;
typedef MIMECPINFO  *PMIMECPINFO;

/* MIME character set information */
typedef struct tagMIMECSETINFO {
    UINT    uiCodePage;
    UINT    uiInternetEncoding;
    WCHAR   wszCharset[MAX_MIMECSET_NAME];
} MIMECSETINFO;
typedef MIMECSETINFO    *PMIMECSETINFO;

/* RFC 1766 information */
typedef struct tagRFC1766INFO {
    LCID    lcid;
    WCHAR   wszRfc1766[MAX_RFC1766_NAME];
    WCHAR   wszLocaleName[MAX_LOCALE_NAME];
} RFC1766INFO;
typedef RFC1766INFO *PRFC1766INFO;

/* Script content flags */
typedef enum tagSCRIPTCONTF {
    sidDefault      = 0,
    sidMerge        = 1,
    sidAsciiSym     = 2,
    sidAsciiLatin   = 3,
    sidLatin        = 4,
    sidGreek        = 5,
    sidCyrillic     = 6,
    sidArmenian     = 7,
    sidHebrew       = 8,
    sidArabic       = 9,
    sidDevanagari   = 10,
    sidBengali      = 11,
    sidGurmukhi     = 12,
    sidGujarati     = 13,
    sidOriya        = 14,
    sidTamil        = 15,
    sidTelugu       = 16,
    sidKannada      = 17,
    sidMalayalam    = 18,
    sidThai         = 19,
    sidLao          = 20,
    sidTibetan      = 21,
    sidGeorgian     = 22,
    sidHangul       = 23,
    sidKana         = 24,
    sidBopomofo     = 25,
    sidHan          = 26,
    sidEthiopic     = 27,
    sidCanSyllabic  = 28,
    sidCherokee     = 29,
    sidYi           = 30,
    sidBraille      = 31,
    sidRunic        = 32,
    sidOgham        = 33,
    sidSinhala      = 34,
    sidSyriac       = 35,
    sidBurmese      = 36,
    sidKhmer        = 37,
    sidThaana       = 38,
    sidMongolian    = 39,
    sidUserDefined  = 40,
    sidLim          = 41,
    sidFEFirst      = sidHangul,
    sidFELast       = sidHan
} SCRIPTCONTF;

/* Script information */
typedef struct tagSCRIPTINFO {
    SCRIPT_ID   ScriptId;
    UINT        uiCodePage;
    WCHAR       wszDescription[MAX_SCRIPT_NAME];
    WCHAR       wszFixedWidthFont[MAX_MIMEFACE_NAME];
    WCHAR       wszProportionalFont[MAX_MIMEFACE_NAME];
} SCRIPTINFO;
typedef SCRIPTINFO  *PSCRIPTINFO;

/* Character set conversion flags */
typedef enum tagMLCONVCHARF {
    MLCONVCHARF_AUTODETECT      = 1,
    MLCONVCHARF_ENTITIZE        = 2,
    MLCONVCHARF_NCR_ENTITIZE    = 2,
    MLCONVCHARF_NAME_ENTITIZE   = 4,
    MLCONVCHARF_USEDEFCHAR      = 8,
    MLCONVCHARF_NOBESTFITCHARS  = 16,
    MLCONVCHARF_DETECTJPN       = 32
} MLCONVCHAR;

/* Code page flags */
typedef enum tagMLCPF {
    MLDETECTF_MAILNEWS              = 0x00000001,
    MLDETECTF_BROWSER               = 0x00000002,
    MLDETECTF_VALID                 = 0x00000004,
    MLDETECTF_VALID_NLS             = 0x00000008,
    MLDETECTF_PRESERVE_ORDER        = 0x00000010,
    MLDETECTF_PREFERRED_ONLY        = 0x00000020,
    MLDETECTF_FILTER_SPECIALCHAR    = 0x00000040,
    MLDETECTF_EURO_UTF8             = 0x00000080
} MLCP;

/* Code page detection flags */
typedef enum tagMLDETECTCP {
    MLDETECTCP_NONE     = 0,
    MLDETECTCP_7BIT     = 1,
    MLDETECTCP_8BIT     = 2,
    MLDETECTCP_DBCS     = 4,
    MLDETECTCP_HTML     = 8,
    MLDETECTCP_NUMBER   = 16
} MLDETECTCP;

/* Encoding detection information */
typedef struct tagDetectEncodingInfo {
    UINT    nLangID;
    UINT    nCodePage;
    INT     nDocPercent;
    INT     nConfidence;
} DetectEncodingInfo;
typedef DetectEncodingInfo  *pDetectEncodingInfo;

/* Script font content flags */
typedef enum tagSCRIPTFONTCONTF {
    SCRIPTCONTF_FIXED_FONT          = 0x00000001,
    SCRIPTCONTF_PROPORTIONAL_FONT   = 0x00000002,
    SCRIPTCONTF_SCRIPT_USER         = 0x00010000,
    SCRIPTCONTF_SCRIPT_HIDE         = 0x00020000,
    SCRIPTCONTF_SCRIPT_SYSTEM       = 0x00040000
} SCRIPTFONTCONTF;

/* Script font information */
typedef struct tagSCRIPTFONTINFO {
    SCRIPT_IDS  scripts;
    WCHAR       wszFont[MAX_MIMEFACE_NAME];
} SCRIPTFONTINFO;
typedef SCRIPTFONTINFO  *PSCRIPTFONTINFO;

/* Unicode range */
typedef struct tagUNICODERANGE {
    WCHAR   wcFrom;
    WCHAR   wcTo;
} UNICODERANGE;

/* GUIDs */
EXTERN_C const IID      LIBID_MultiLanguage;
EXTERN_C const IID      IID_IMLangStringBufW;
EXTERN_C const IID      IID_IMLangStringBufA;
EXTERN_C const IID      IID_IMLangString;
EXTERN_C const IID      IID_IMLangStringWStr;
EXTERN_C const IID      IID_IMLangStringAStr;
EXTERN_C const CLSID    CLSID_CMLangString;
EXTERN_C const IID      IID_IMLangLineBreakConsole;
EXTERN_C const IID      IID_IEnumCodePage;
EXTERN_C const IID      IID_IEnumRfc1766;
EXTERN_C const IID      IID_IEnumScript;
EXTERN_C const IID      IID_IMLangConvertCharset;
EXTERN_C const CLSID    CLSID_CMLangConvertCharset;
EXTERN_C const IID      IID_IMultiLanguage;
EXTERN_C const IID      IID_IMultiLanguage2;
EXTERN_C const IID      IID_IMLangCodePages;
EXTERN_C const IID      IID_IMLangFontLink;
EXTERN_C const IID      IID_IMLangFontLink2;
EXTERN_C const IID      IID_IMultiLanguage3;
EXTERN_C const CLSID    CLSID_CMultiLanguage;

/* IMLangStringBufW interface */
#undef INTERFACE
#define INTERFACE   IMLangStringBufW
DECLARE_INTERFACE_( IMLangStringBufW, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMLangStringBufW methods */
    STDMETHOD( GetStatus )( THIS_ long *, long * ) PURE;
    STDMETHOD( LockBuf )( THIS_ long, long, WCHAR **, long * ) PURE;
    STDMETHOD( UnlockBuf )( THIS_ const WCHAR *, long, long ) PURE;
    STDMETHOD( Insert )( THIS_ long, long, long * ) PURE;
    STDMETHOD( Delete )( THIS_ long, long ) PURE;
};

/* IMLangStringBufA interface */
#undef INTERFACE
#define INTERFACE   IMLangStringBufA
DECLARE_INTERFACE_( IMLangStringBufA, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IMLangStringBufA methods */
    STDMETHOD( GetStatus )( THIS_ long *, long * ) PURE;
    STDMETHOD( LockBuf )( THIS_ long, long, CHAR **, long * ) PURE;
    STDMETHOD( UnlockBuf )( THIS_ const CHAR *, long, long ) PURE;
    STDMETHOD( Insert )( THIS_ long, long, long * ) PURE;
    STDMETHOD( Delete )( THIS_ long, long ) PURE;
};

/* IMLangString interface */
#undef INTERFACE
#define INTERFACE   IMLangString
DECLARE_INTERFACE_( IMLangString, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMLangString methods */
    STDMETHOD( Sync )( THIS_ BOOL ) PURE;
    STDMETHOD( GetLength )( THIS_ long * ) PURE;
    STDMETHOD( SetMLStr )( THIS_ long, long, IUnknown *, long, long ) PURE;
    STDMETHOD( GetMLStr )( THIS_ long, long, IUnknown *, DWORD, const IID *, IUnknown **, long *, long * ) PURE;
};

/* IMLangStringWStr interface */
#undef INTERFACE
#define INTERFACE   IMLangStringWStr
DECLARE_INTERFACE_( IMLangStringWStr, IMLangString ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMLangString methods */
    STDMETHOD( Sync )( THIS_ BOOL ) PURE;
    STDMETHOD( GetLength )( THIS_ long * ) PURE;
    STDMETHOD( SetMLStr )( THIS_ long, long, IUnknown *, long, long ) PURE;
    STDMETHOD( GetMLStr )( THIS_ long, long, IUnknown *, DWORD, const IID *, IUnknown **, long *, long * ) PURE;

    /* IMLangStringWStr methods */
    STDMETHOD( SetWStr )( THIS_ long, long, const WCHAR *, long, long *, long * ) PURE;
    STDMETHOD( SetStrBufW )( THIS_ long, long, IMLangStringBufW *, long *, long * ) PURE;
    STDMETHOD( GetWStr )( THIS_ long, long, WCHAR *, long, long *, long * ) PURE;
    STDMETHOD( GetStrBufW )( THIS_ long, long, IMLangStringBufW **, long * ) PURE;
    STDMETHOD( LockWStr )( THIS_ long, long, long, long, WCHAR **, long *, long * ) PURE;
    STDMETHOD( UnlockWStr )( THIS_ const WCHAR *, long, long *, long * ) PURE;
    STDMETHOD( SetLocale )( THIS_ long, long, LCID ) PURE;
    STDMETHOD( GetLocale )( THIS_ long, long, LCID *, long *, long * ) PURE;
};

/* IMLangStringAStr interface */
#undef INTERFACE
#define INTERFACE   IMLangStringAStr
DECLARE_INTERFACE_( IMLangStringAStr, IMLangString ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMLangString methods */
    STDMETHOD( Sync )( THIS_ BOOL ) PURE;
    STDMETHOD( GetLength )( THIS_ long * ) PURE;
    STDMETHOD( SetMLStr )( THIS_ long, long, IUnknown *, long, long ) PURE;
    STDMETHOD( GetMLStr )( THIS_ long, long, IUnknown *, DWORD, const IID *, IUnknown **, long *, long * ) PURE;
    
    /* IMLangStringAStr methods */
    STDMETHOD( SetAStr )( THIS_ long, long, UINT, const CHAR *, long, long *, long * ) PURE;
    STDMETHOD( SetStrBufA )( THIS_ long, long, UINT, IMLangStringBufA *, long *, long * ) PURE;
    STDMETHOD( GetAStr )( THIS_ long, long, UINT, UINT *, CHAR *, long, long *, long * ) PURE;
    STDMETHOD( GetStrBufA )( THIS_ long, long, UINT *, IMLangStringBufA **, long * ) PURE;
    STDMETHOD( LockAStr )( THIS_ long, long, long, UINT, long, UINT *, CHAR **, long *, long * ) PURE;
    STDMETHOD( UnlockAStr )( THIS_ const CHAR *, long, long *, long * ) PURE;
    STDMETHOD( SetLocale )( THIS_ long, long, LCID ) PURE;
    STDMETHOD( GetLocale )( THIS_ long, long, LCID *, long *, long * ) PURE;
};

/* IMLangLineBreakConsole interface */
#undef INTERFACE
#define INTERFACE   IMLangLineBreakConsole
DECLARE_INTERFACE_( IMLangLineBreakConsole, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMLangLineBreakConsole methods */
    STDMETHOD( BreakLineML )( THIS_ IMLangString *, long, long, long, long, long *, long * ) PURE;
    STDMETHOD( BreakLineW )( THIS_ LCID, const WCHAR *, long, long, long *, long * ) PURE;
    STDMETHOD( BreakLineA )( THIS_ LCID, UINT, const CHAR *, long, long, long *, long * ) PURE;
};

/* IEnumCodePage interface */
#undef INTERFACE
#define INTERFACE   IEnumCodePage
DECLARE_INTERFACE_( IEnumCodePage, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumCodePage methods */
    STDMETHOD( Clone )( THIS_ IEnumCodePage ** ) PURE;
    STDMETHOD( Next )( THIS_ ULONG, PMIMECPINFO, ULONG * ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
};
typedef IEnumCodePage   *LPENUMCODEPAGE;

/* IEnumRfc1766 interface */
#undef INTERFACE
#define INTERFACE   IEnumRfc1766
DECLARE_INTERFACE_( IEnumRfc1766, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumRfc1766 methods */
    STDMETHOD( Clone )( THIS_ IEnumRfc1766 ** ) PURE;
    STDMETHOD( Next )( THIS_ ULONG, PRFC1766INFO, ULONG * ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
};
typedef IEnumRfc1766    *LPENUMRFC1766;

/* IEnumScript interface */
#undef INTERFACE
#define INTERFACE   IEnumScript
DECLARE_INTERFACE_( IEnumScript, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IEnumScript methods */
    STDMETHOD( Clone )( THIS_ IEnumScript ** ) PURE;
    STDMETHOD( Next )( THIS_ ULONG, PSCRIPTINFO, ULONG * ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
};
typedef IEnumScript *LPENUMScript;

/* IMLangConvertCharset interface */
#undef INTERFACE
#define INTERFACE   IMLangConvertCharset
DECLARE_INTERFACE_( IMLangConvertCharset, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMLangConvertCharset methods */
    STDMETHOD( Initialize )( THIS_ UINT, UINT, DWORD ) PURE;
    STDMETHOD( GetSourceCodePage )( THIS_ UINT * ) PURE;
    STDMETHOD( GetDestinationCodePage )( THIS_ UINT * ) PURE;
    STDMETHOD( GetProperty )( THIS_ DWORD * ) PURE;
    STDMETHOD( DoConversion )( THIS_ BYTE *, UINT *, BYTE *, UINT * ) PURE;
    STDMETHOD( DoConversionToUnicode )( THIS_ CHAR *, UINT *, WCHAR *, UINT * ) PURE;
    STDMETHOD( DoConversionFromUnicode )( THIS_ WCHAR *, UINT *, CHAR *, UINT * ) PURE;
};
typedef IMLangConvertCharset    *LPMLANGCONVERTCHARSET;

/* IMultiLanguage interface */
#undef INTERFACE
#define INTERFACE   IMultiLanguage
DECLARE_INTERFACE_( IMultiLanguage, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMultiLanguage methods */
    STDMETHOD( GetNumberOfCodePageInfo )( THIS_ UINT * ) PURE;
    STDMETHOD( GetCodePageInfo )( THIS_ UINT, PMIMECPINFO ) PURE;
    STDMETHOD( GetFamilyCodePage )( THIS_ UINT, UINT * ) PURE;
    STDMETHOD( EnumCodePages )( THIS_ DWORD, IEnumCodePage ** ) PURE;
    STDMETHOD( GetCharsetInfo )( THIS_ BSTR, PMIMECSETINFO ) PURE;
    STDMETHOD( IsConvertible )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( ConvertString )( THIS_ DWORD *, DWORD, DWORD, BYTE *, UINT *, BYTE *, UINT * ) PURE;
    STDMETHOD( ConvertStringToUnicode )( THIS_ DWORD *, DWORD, CHAR *, UINT *, WCHAR *, UINT * ) PURE;
    STDMETHOD( ConvertStringFromUnicode )( THIS_ DWORD *, DWORD, WCHAR *, UINT *, CHAR *, UINT * ) PURE;
    STDMETHOD( ConvertStringReset )( THIS ) PURE;
    STDMETHOD( GetRfc1766FromLcid )( THIS_ LCID, BSTR * ) PURE;
    STDMETHOD( GetLcidFromRfc1766 )( THIS_ LCID *, BSTR ) PURE;
    STDMETHOD( EnumRfc1766 )( THIS_ IEnumRfc1766 ** ) PURE;
    STDMETHOD( GetRfc1766Info )( THIS_ LCID, PRFC1766INFO ) PURE;
    STDMETHOD( CreateConvertCharset )( THIS_ UINT, UINT, DWORD, IMLangConvertCharset ** ) PURE;
};
typedef IMultiLanguage  *LPMULTILANGUAGE;

/* IMultiLanguage2 interface */
#undef INTERFACE
#define INTERFACE   IMultiLanguage2
DECLARE_INTERFACE_( IMultiLanguage2, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMultiLanguage2 methods */
    STDMETHOD( GetNumberOfCodePageInfo )( THIS_ UINT * ) PURE;
    STDMETHOD( GetCodePageInfo )( THIS_ UINT, PMIMECPINFO ) PURE;
    STDMETHOD( GetFamilyCodePage )( THIS_ UINT, UINT * ) PURE;
    STDMETHOD( EnumCodePages )( THIS_ DWORD, IEnumCodePage ** ) PURE;
    STDMETHOD( GetCharsetInfo )( THIS_ BSTR, PMIMECSETINFO ) PURE;
    STDMETHOD( IsConvertible )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( ConvertString )( THIS_ DWORD *, DWORD, DWORD, BYTE *, UINT *, BYTE *, UINT * ) PURE;
    STDMETHOD( ConvertStringToUnicode )( THIS_ DWORD *, DWORD, CHAR *, UINT *, WCHAR *, UINT * ) PURE;
    STDMETHOD( ConvertStringFromUnicode )( THIS_ DWORD *, DWORD, WCHAR *, UINT *, CHAR *, UINT * ) PURE;
    STDMETHOD( ConvertStringReset )( THIS ) PURE;
    STDMETHOD( GetRfc1766FromLcid )( THIS_ LCID, BSTR * ) PURE;
    STDMETHOD( GetLcidFromRfc1766 )( THIS_ LCID *, BSTR ) PURE;
    STDMETHOD( EnumRfc1766 )( THIS_ IEnumRfc1766 ** ) PURE;
    STDMETHOD( GetRfc1766Info )( THIS_ LCID, PRFC1766INFO ) PURE;
    STDMETHOD( CreateConvertCharset )( THIS_ UINT, UINT, DWORD, IMLangConvertCharset ** ) PURE;
    STDMETHOD( ConvertStringInIStream )( THIS_ DWORD *, DWORD, WCHAR *, DWORD, DWORD, IStream *, IStream * ) PURE;
    STDMETHOD( ConvertStringToUnicodeEx )( THIS_ DWORD *, DWORD, CHAR *, UINT *, WCHAR *, UINT *, DWORD, WCHAR * ) PURE;
    STDMETHOD( ConvertStringFromUnicodeEx )( THIS_ DWORD *, DWORD, WCHAR *, UINT *, CHAR *, UINT *, DWORD, WCHAR * ) PURE;
    STDMETHOD( DetectCodepageInIStream )( THIS_ DWORD, DWORD, IStream *, DetectEncodingInfo *, INT * ) PURE;
    STDMETHOD( DetectInputCodepage )( THIS_ DWORD, DWORD, CHAR *, INT *, DetectEncodingInfo *, INT * ) PURE;
    STDMETHOD( ValidateCodePage )( THIS_ UINT, HWND ) PURE;
    STDMETHOD( GetCodePageDescription )( THIS_ UINT, LCID, LPWSTR, int ) PURE;
    STDMETHOD( IsCodePageInstallable )( THIS_ UINT ) PURE;
    STDMETHOD( SetMimeDBSource )( THIS_ MIMECONTF ) PURE;
    STDMETHOD( GetNumberOfScripts )( THIS_ UINT * ) PURE;
    STDMETHOD( EnumScripts )( THIS_ DWORD, LANGID, IEnumScript ** ) PURE;
    STDMETHOD( ValidateCodePageEx )( THIS_ UINT, HWND, DWORD ) PURE;
};
typedef IMultiLanguage2 *LPMULTILANGUAGE2;

/* IMLangCodePages interface */
#undef INTERFACE
#define INTERFACE   IMLangCodePages
DECLARE_INTERFACE_( IMLangCodePages, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMLangCodePages methods */
    STDMETHOD( GetCharCodePages )( THIS_ WCHAR, DWORD * ) PURE;
    STDMETHOD( GetStrCodePages )( THIS_ const WCHAR *, long, DWORD, DWORD *, long * ) PURE;
    STDMETHOD( CodePageToCodePages )( THIS_ UINT, DWORD * ) PURE;
    STDMETHOD( CodePagesToCodePage )( THIS_ DWORD, UINT, UINT * ) PURE;
};
typedef IMLangCodePages *LPMLANGCODEPAGES;

/* IMLangFontLink interface */
#undef INTERFACE
#define INTERFACE   IMLangFontLink
DECLARE_INTERFACE_( IMLangFontLink, IMLangCodePages ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMLangCodePages methods */
    STDMETHOD( GetCharCodePages )( THIS_ WCHAR, DWORD * ) PURE;
    STDMETHOD( GetStrCodePages )( THIS_ const WCHAR *, long, DWORD, DWORD *, long * ) PURE;
    STDMETHOD( CodePageToCodePages )( THIS_ UINT, DWORD * ) PURE;
    STDMETHOD( CodePagesToCodePage )( THIS_ DWORD, UINT, UINT * ) PURE;

    /* IMLangFontLink methods */
    STDMETHOD( GetFontCodePages )( THIS_ HDC, HFONT, DWORD * ) PURE;
    STDMETHOD( MapFont )( THIS_ HDC, DWORD, HFONT, HFONT * ) PURE;
    STDMETHOD( ReleaseFont )( THIS_ HFONT ) PURE;
    STDMETHOD( ResetFontMapping )( THIS ) PURE;
};
typedef IMLangFontLink  *LPMLANGFONTLINK;

/* IMLangFontLink2 interface */
#undef INTERFACE
#define INTERFACE   IMLangFontLink2
DECLARE_INTERFACE_( IMLangFontLink2, IMLangCodePages ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMLangCodePages methods */
    STDMETHOD( GetCharCodePages )( THIS_ WCHAR, DWORD * ) PURE;
    STDMETHOD( GetStrCodePages )( THIS_ const WCHAR *, long, DWORD, DWORD *, long * ) PURE;
    STDMETHOD( CodePageToCodePages )( THIS_ UINT, DWORD * ) PURE;
    STDMETHOD( CodePagesToCodePage )( THIS_ DWORD, UINT, UINT * ) PURE;

    /* IMLangFontLink2 methods */
    STDMETHOD( GetFontCodePages )( THIS_ HDC, HFONT, DWORD * ) PURE;
    STDMETHOD( ReleaseFont )( THIS_ HFONT ) PURE;
    STDMETHOD( ResetFontMapping )( THIS ) PURE;
    STDMETHOD( MapFont )( THIS_ HDC, DWORD, HFONT, HFONT * ) PURE;
    STDMETHOD( GetFontUnicodeRanges )( THIS_ HDC, UINT *, UNICODERANGE * ) PURE;
    STDMETHOD( GetScriptFontInfo )( THIS_ SCRIPT_ID, DWORD, UINT *, SCRIPTFONTINFO * ) PURE;
    STDMETHOD( CodePageToScriptID )( THIS_ UINT, SCRIPT_ID * ) PURE;
};
typedef IMLangFontLink2 *LPMLANGFONTLINK2;

/* IMultiLanguage3 interface */
#undef INTERFACE
#define INTERFACE   IMultiLanguage3
DECLARE_INTERFACE_( IMultiLanguage3, IMultiLanguage2 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMultiLanguage2 methods */
    STDMETHOD( GetNumberOfCodePageInfo )( THIS_ UINT * ) PURE;
    STDMETHOD( GetCodePageInfo )( THIS_ UINT, PMIMECPINFO ) PURE;
    STDMETHOD( GetFamilyCodePage )( THIS_ UINT, UINT * ) PURE;
    STDMETHOD( EnumCodePages )( THIS_ DWORD, IEnumCodePage ** ) PURE;
    STDMETHOD( GetCharsetInfo )( THIS_ BSTR, PMIMECSETINFO ) PURE;
    STDMETHOD( IsConvertible )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( ConvertString )( THIS_ DWORD *, DWORD, DWORD, BYTE *, UINT *, BYTE *, UINT * ) PURE;
    STDMETHOD( ConvertStringToUnicode )( THIS_ DWORD *, DWORD, CHAR *, UINT *, WCHAR *, UINT * ) PURE;
    STDMETHOD( ConvertStringFromUnicode )( THIS_ DWORD *, DWORD, WCHAR *, UINT *, CHAR *, UINT * ) PURE;
    STDMETHOD( ConvertStringReset )( THIS ) PURE;
    STDMETHOD( GetRfc1766FromLcid )( THIS_ LCID, BSTR * ) PURE;
    STDMETHOD( GetLcidFromRfc1766 )( THIS_ LCID *, BSTR ) PURE;
    STDMETHOD( EnumRfc1766 )( THIS_ IEnumRfc1766 ** ) PURE;
    STDMETHOD( GetRfc1766Info )( THIS_ LCID, PRFC1766INFO ) PURE;
    STDMETHOD( CreateConvertCharset )( THIS_ UINT, UINT, DWORD, IMLangConvertCharset ** ) PURE;
    STDMETHOD( ConvertStringInIStream )( THIS_ DWORD *, DWORD, WCHAR *, DWORD, DWORD, IStream *, IStream * ) PURE;
    STDMETHOD( ConvertStringToUnicodeEx )( THIS_ DWORD *, DWORD, CHAR *, UINT *, WCHAR *, UINT *, DWORD, WCHAR * ) PURE;
    STDMETHOD( ConvertStringFromUnicodeEx )( THIS_ DWORD *, DWORD, WCHAR *, UINT *, CHAR *, UINT *, DWORD, WCHAR * ) PURE;
    STDMETHOD( DetectCodepageInIStream )( THIS_ DWORD, DWORD, IStream *, DetectEncodingInfo *, INT * ) PURE;
    STDMETHOD( DetectInputCodepage )( THIS_ DWORD, DWORD, CHAR *, INT *, DetectEncodingInfo *, INT * ) PURE;
    STDMETHOD( ValidateCodePage )( THIS_ UINT, HWND ) PURE;
    STDMETHOD( GetCodePageDescription )( THIS_ UINT, LCID, LPWSTR, int ) PURE;
    STDMETHOD( IsCodePageInstallable )( THIS_ UINT ) PURE;
    STDMETHOD( SetMimeDBSource )( THIS_ MIMECONTF ) PURE;
    STDMETHOD( GetNumberOfScripts )( THIS_ UINT * ) PURE;
    STDMETHOD( EnumScripts )( THIS_ DWORD, LANGID, IEnumScript ** ) PURE;
    STDMETHOD( ValidateCodePageEx )( THIS_ UINT, HWND, DWORD ) PURE;

    /* IMultiLanguage3 methods */
    STDMETHOD( DetectOutboundCodePage )( THIS_ DWORD, LPCWSTR, UINT, UINT *, UINT, UINT *, UINT *, WCHAR * ) PURE;
    STDMETHOD( DetectOutboundCodePageInIStream )( THIS_ DWORD, IStream *, UINT *, UINT, UINT *, UINT *, WCHAR * ) PURE;
};
typedef IMultiLanguage3 *LPMULTILANGUAGE3;

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IMLangStringBufW_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMLangStringBufW_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMLangStringBufW_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMLangStringBufW_GetStatus( x, p1, p2 ) \
        (x)->lpVtbl->GetStatus( x, p1, p2 )
    #define IMLangStringBufW_LockBuf( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->LockBuf( x, p1, p2, p3, p4 )
    #define IMLangStringBufW_UnlockBuf( x, p1, p2, p3 ) \
        (x)->lpVtbl->UnlockBuf( x, p1, p2, p3 )
    #define IMLangStringBufW_Insert( x, p1, p2, p3 ) \
        (x)->lpVtbl->Insert( x, p1, p2, p3 )
    #define IMLangStringBufW_Delete( x, p1, p2 ) \
        (x)->lpVtbl->Delete( x, p1, p2 )
    #define IMLangStringBufA_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMLangStringBufA_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMLangStringBufA_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMLangStringBufA_GetStatus( x, p1, p2 ) \
        (x)->lpVtbl->GetStatus( x, p1, p2 )
    #define IMLangStringBufA_LockBuf( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->LockBuf( x, p1, p2, p3, p4 )
    #define IMLangStringBufA_UnlockBuf( x, p1, p2, p3 ) \
        (x)->lpVtbl->UnlockBuf( x, p1, p2, p3 )
    #define IMLangStringBufA_Insert( x, p1, p2, p3 ) \
        (x)->lpVtbl->Insert( x, p1, p2, p3 )
    #define IMLangStringBufA_Delete( x, p1, p2 ) \
        (x)->lpVtbl->Delete( x, p1, p2 )
    #define IMLangString_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMLangString_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMLangString_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMLangString_Sync( x, p ) \
        (x)->lpVtbl->Sync( x, p )
    #define IMLangString_GetLength( x, p ) \
        (x)->lpVtbl->GetLength( x, p )
    #define IMLangString_SetMLStr( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->SetMLStr( x, p1, p2, p3, p4, p5 )
    #define IMLangString_GetMLStr( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->GetMLStr( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IMLangStringWStr_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMLangStringWStr_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMLangStringWStr_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMLangStringWStr_Sync( x, p ) \
        (x)->lpVtbl->Sync( x, p )
    #define IMLangStringWStr_GetLength( x, p ) \
        (x)->lpVtbl->GetLength( x, p )
    #define IMLangStringWStr_SetMLStr( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->SetMLStr( x, p1, p2, p3, p4, p5 )
    #define IMLangStringWStr_GetMLStr( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->GetMLStr( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IMLangStringWStr_SetWStr( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->SetWStr( x, p1, p2, p3, p4, p5, p6 )
    #define IMLangStringWStr_SetStrBufW( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->SetStrBufW( x, p1, p2, p3, p4, p5 )
    #define IMLangStringWStr_GetWStr( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->GetWStr( x, p1, p2, p3, p4, p5, p6 )
    #define IMLangStringWStr_GetStrBufW( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetStrBufW( x, p1, p2, p3, p4 )
    #define IMLangStringWStr_LockWStr( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->LockWStr( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IMLangStringWStr_UnlockWStr( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->UnlockWStr( x, p1, p2, p3, p4 )
    #define IMLangStringWStr_SetLocale( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetLocale( x, p1, p2, p3 )
    #define IMLangStringWStr_GetLocale( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetLocale( x, p1, p2, p3, p4, p5 )
    #define IMLangStringWStr_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMLangStringAStr_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMLangStringAStr_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMLangStringAStr_Sync( x, p ) \
        (x)->lpVtbl->Sync( x, p )
    #define IMLangStringAStr_GetLength( x, p ) \
        (x)->lpVtbl->GetLength( x, p )
    #define IMLangStringAStr_SetMLStr( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->SetMLStr( x, p1, p2, p3, p4, p5 )
    #define IMLangStringAStr_GetMLStr( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->GetMLStr( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IMLangStringAStr_SetAStr( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->SetAStr( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IMLangStringAStr_SetStrBufA( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->SetStrBufA( x, p1, p2, p3, p4, p5, p6 )
    #define IMLangStringAStr_GetAStr( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->GetAStr( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IMLangStringAStr_GetStrBufA( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetStrBufA( x, p1, p2, p3, p4, p5 )
    #define IMLangStringAStr_LockAStr( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 ) \
        (x)->lpVtbl->LockAStr( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 )
    #define IMLangStringAStr_UnlockAStr( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->UnlockAStr( x, p1, p2, p3, p4 )
    #define IMLangStringAStr_SetLocale( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetLocale( x, p1, p2, p3 )
    #define IMLangStringAStr_GetLocale( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetLocale( x, p1, p2, p3, p4, p5 )
    #define IMLangLineBreakConsole_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMLangLineBreakConsole_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMLangLineBreakConsole_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMLangLineBreakConsole_BreakLineML( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->BreakLineML( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IMLangLineBreakConsole_BreakLineW( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->BreakLineW( x, p1, p2, p3, p4, p5, p6 )
    #define IMLangLineBreakConsole_BreakLineA( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->BreakLineA( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IEnumCodePage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumCodePage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumCodePage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumCodePage_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IEnumCodePage_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumCodePage_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumCodePage_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumRfc1766_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumRfc1766_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumRfc1766_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumRfc1766_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IEnumRfc1766_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumRfc1766_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumRfc1766_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumScript_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumScript_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumScript_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumScript_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IEnumScript_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumScript_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumScript_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IMLangConvertCharset_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMLangConvertCharset_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMLangConvertCharset_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMLangConvertCharset_Initialize( x, p1, p2, p3 ) \
        (x)->lpVtbl->Initialize( x, p1, p2, p3 )
    #define IMLangConvertCharset_GetSourceCodePage( x, p ) \
        (x)->lpVtbl->GetSourceCodePage( x, p )
    #define IMLangConvertCharset_GetDestinationCodePage( x, p ) \
        (x)->lpVtbl->GetDestinationCodePage( x, p )
    #define IMLangConvertCharset_GetProperty( x, p ) \
        (x)->lpVtbl->GetProperty( x, p )
    #define IMLangConvertCharset_DoConversion( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->DoConversion( x, p1, p2, p3, p4 )
    #define IMLangConvertCharset_DoConversionToUnicode( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->DoConversionToUnicode( x, p1, p2, p3, p4 )
    #define IMLangConvertCharset_DoConversionFromUnicode( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->DoConversionFromUnicode( x, p1, p2, p3, p4 )
    #define IMultiLanguage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMultiLanguage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMultiLanguage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMultiLanguage_GetNumberOfCodePageInfo( x, p ) \
        (x)->lpVtbl->GetNumberOfCodePageInfo( x, p )
    #define IMultiLanguage_GetCodePageInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetCodePageInfo( x, p1, p2 )
    #define IMultiLanguage_GetFamilyCodePage( x, p1, p2 ) \
        (x)->lpVtbl->GetFamilyCodePage( x, p1, p2 )
    #define IMultiLanguage_EnumCodePages( x, p1, p2 ) \
        (x)->lpVtbl->EnumCodePages( x, p1, p2 )
    #define IMultiLanguage_GetCharsetInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetCharsetInfo( x, p1, p2 )
    #define IMultiLanguage_IsConvertible( x, p1, p2 ) \
        (x)->lpVtbl->IsConvertible( x, p1, p2 )
    #define IMultiLanguage_ConvertString( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->ConvertString( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IMultiLanguage_ConvertStringToUnicode( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->ConvertStringToUnicode( x, p1, p2, p3, p4, p5, p6 )
    #define IMultiLanguage_ConvertStringFromUnicode( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->ConvertStringFromUnicode( x, p1, p2, p3, p4, p5, p6 )
    #define IMultiLanguage_ConvertStringReset( x ) \
        (x)->lpVtbl->ConvertStringReset( x )
    #define IMultiLanguage_GetRfc1766FromLcid( x, p1, p2 ) \
        (x)->lpVtbl->GetRfc1766FromLcid( x, p1, p2 )
    #define IMultiLanguage_GetLcidFromRfc1766( x, p1, p2 ) \
        (x)->lpVtbl->GetLcidFromRfc1766( x, p1, p2 )
    #define IMultiLanguage_EnumRfc1766( x, p ) \
        (x)->lpVtbl->EnumRfc1766( x, p )
    #define IMultiLanguage_GetRfc1766Info( x, p1, p2 ) \
        (x)->lpVtbl->GetRfc1766Info( x, p1, p2 )
    #define IMultiLanguage_CreateConvertCharset( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->CreateConvertCharset( x, p1, p2, p3, p4 )
    #define IMultiLanguage2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMultiLanguage2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMultiLanguage2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMultiLanguage2_GetNumberOfCodePageInfo( x, p ) \
        (x)->lpVtbl->GetNumberOfCodePageInfo( x, p )
    #define IMultiLanguage2_GetCodePageInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetCodePageInfo( x, p1, p2 )
    #define IMultiLanguage2_GetFamilyCodePage( x, p1, p2 ) \
        (x)->lpVtbl->GetFamilyCodePage( x, p1, p2 )
    #define IMultiLanguage2_EnumCodePages( x, p1, p2 ) \
        (x)->lpVtbl->EnumCodePages( x, p1, p2 )
    #define IMultiLanguage2_GetCharsetInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetCharsetInfo( x, p1, p2 )
    #define IMultiLanguage2_IsConvertible( x, p1, p2 ) \
        (x)->lpVtbl->IsConvertible( x, p1, p2 )
    #define IMultiLanguage2_ConvertString( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->ConvertString( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IMultiLanguage2_ConvertStringToUnicode( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->ConvertStringToUnicode( x, p1, p2, p3, p4, p5, p6 )
    #define IMultiLanguage2_ConvertStringFromUnicode( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->ConvertStringFromUnicode( x, p1, p2, p3, p4, p5, p6 )
    #define IMultiLanguage2_ConvertStringReset( x ) \
        (x)->lpVtbl->ConvertStringReset( x )
    #define IMultiLanguage2_GetRfc1766FromLcid( x, p1, p2 ) \
        (x)->lpVtbl->GetRfc1766FromLcid( x, p1, p2 )
    #define IMultiLanguage2_GetLcidFromRfc1766( x, p1, p2 ) \
        (x)->lpVtbl->GetLcidFromRfc1766( x, p1, p2 )
    #define IMultiLanguage2_EnumRfc1766( x, p ) \
        (x)->lpVtbl->EnumRfc1766( x, p )
    #define IMultiLanguage2_GetRfc1766Info( x, p1, p2 ) \
        (x)->lpVtbl->GetRfc1766Info( x, p1, p2 )
    #define IMultiLanguage2_CreateConvertCharset( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->CreateConvertCharset( x, p1, p2, p3, p4 )
    #define IMultiLanguage2_ConvertStringInIStream( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->ConvertStringInIStream( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IMultiLanguage2_ConvertStringToUnicodeEx( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->ConvertStringToUnicodeEx( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IMultiLanguage2_ConvertStringFromUnicodeEx( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->ConvertStringFromUnicodeEx( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IMultiLanguage2_DetectCodepageInIStream( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->DetectCodepageInIStream( x, p1, p2, p3, p4, p5 )
    #define IMultiLanguage2_DetectInputCodepage( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->DetectInputCodepage( x, p1, p2, p3, p4, p5, p6 )
    #define IMultiLanguage2_ValidateCodePage( x, p1, p2 ) \
        (x)->lpVtbl->ValidateCodePage( x, p1, p2 )
    #define IMultiLanguage2_GetCodePageDescription( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetCodePageDescription( x, p1, p2, p3, p4 )
    #define IMultiLanguage2_IsCodePageInstallable( x, p ) \
        (x)->lpVtbl->IsCodePageInstallable( x, p )
    #define IMultiLanguage2_SetMimeDBSource( x, p ) \
        (x)->lpVtbl->SetMimeDBSource( x, p )
    #define IMultiLanguage2_GetNumberOfScripts( x, p ) \
        (x)->lpVtbl->GetNumberOfScripts( x, p )
    #define IMultiLanguage2_EnumScripts( x, p1, p2, p3 ) \
        (x)->lpVtbl->EnumScripts( x, p1, p2, p3 )
    #define IMultiLanguage2_ValidateCodePageEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->ValidateCodePageEx( x, p1, p2, p3 )
    #define IMLangCodePages_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMLangCodePages_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMLangCodePages_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMLangCodePages_GetCharCodePages( x, p1, p2 ) \
        (x)->lpVtbl->GetCharCodePages( x, p1, p2 )
    #define IMLangCodePages_GetStrCodePages( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetStrCodePages( x, p1, p2, p3, p4, p5 )
    #define IMLangCodePages_CodePageToCodePages( x, p1, p2 ) \
        (x)->lpVtbl->CodePageToCodePages( x, p1, p2 )
    #define IMLangCodePages_CodePagesToCodePage( x, p1, p2, p3 ) \
        (x)->lpVtbl->CodePagesToCodePage( x, p1, p2, p3 )
    #define IMLangFontLink_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMLangFontLink_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMLangFontLink_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMLangFontLink_GetCharCodePages( x, p1, p2 ) \
        (x)->lpVtbl->GetCharCodePages( x, p1, p2 )
    #define IMLangFontLink_GetStrCodePages( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetStrCodePages( x, p1, p2, p3, p4, p5 )
    #define IMLangFontLink_CodePageToCodePages( x, p1, p2 ) \
        (x)->lpVtbl->CodePageToCodePages( x, p1, p2 )
    #define IMLangFontLink_CodePagesToCodePage( x, p1, p2, p3 ) \
        (x)->lpVtbl->CodePagesToCodePage( x, p1, p2, p3 )
    #define IMLangFontLink_GetFontCodePages( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetFontCodePages( x, p1, p2, p3 )
    #define IMLangFontLink_MapFont( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->MapFont( x, p1, p2, p3, p4 )
    #define IMLangFontLink_ReleaseFont( x, p ) \
        (x)->lpVtbl->ReleaseFont( x, p )
    #define IMLangFontLink_ResetFontMapping( x ) \
        (x)->lpVtbl->ResetFontMapping( x )
    #define IMLangFontLink2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMLangFontLink2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMLangFontLink2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMLangFontLink2_GetCharCodePages( x, p1, p2 ) \
        (x)->lpVtbl->GetCharCodePages( x, p1, p2 )
    #define IMLangFontLink2_GetStrCodePages( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetStrCodePages( x, p1, p2, p3, p4, p5 )
    #define IMLangFontLink2_CodePageToCodePages( x, p1, p2 ) \
        (x)->lpVtbl->CodePageToCodePages( x, p1, p2 )
    #define IMLangFontLink2_CodePagesToCodePage( x, p1, p2, p3 ) \
        (x)->lpVtbl->CodePagesToCodePage( x, p1, p2, p3 )
    #define IMLangFontLink2_GetFontCodePages( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetFontCodePages( x, p1, p2, p3 )
    #define IMLangFontLink2_ReleaseFont( x, p ) \
        (x)->lpVtbl->ReleaseFont( x, p )
    #define IMLangFontLink2_ResetFontMapping( x ) \
        (x)->lpVtbl->ResetFontMapping( x )
    #define IMLangFontLink2_MapFont( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->MapFont( x, p1, p2, p3, p4 )
    #define IMLangFontLink2_GetFontUnicodeRanges( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetFontUnicodeRanges( x, p1, p2, p3 )
    #define IMLangFontLink2_GetScriptFontInfo( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetScriptFontInfo( x, p1, p2, p3, p4 )
    #define IMLangFontLink2_CodePageToScriptID( x, p1, p2 ) \
        (x)->lpVtbl->CodePageToScriptID( x, p1, p2 )
    #define IMultiLanguage3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMultiLanguage3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMultiLanguage3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMultiLanguage3_GetNumberOfCodePageInfo( x, p ) \
        (x)->lpVtbl->GetNumberOfCodePageInfo( x, p )
    #define IMultiLanguage3_GetCodePageInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetCodePageInfo( x, p1, p2 )
    #define IMultiLanguage3_GetFamilyCodePage( x, p1, p2 ) \
        (x)->lpVtbl->GetFamilyCodePage( x, p1, p2 )
    #define IMultiLanguage3_EnumCodePages( x, p1, p2 ) \
        (x)->lpVtbl->EnumCodePages( x, p1, p2 )
    #define IMultiLanguage3_GetCharsetInfo( x, p1, p2 ) \
        (x)->lpVtbl->GetCharsetInfo( x, p1, p2 )
    #define IMultiLanguage3_IsConvertible( x, p1, p2 ) \
        (x)->lpVtbl->IsConvertible( x, p1, p2 )
    #define IMultiLanguage3_ConvertString( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->ConvertString( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IMultiLanguage3_ConvertStringToUnicode( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->ConvertStringToUnicode( x, p1, p2, p3, p4, p5, p6 )
    #define IMultiLanguage3_ConvertStringFromUnicode( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->ConvertStringFromUnicode( x, p1, p2, p3, p4, p5, p6 )
    #define IMultiLanguage3_ConvertStringReset( x ) \
        (x)->lpVtbl->ConvertStringReset( x )
    #define IMultiLanguage3_GetRfc1766FromLcid( x, p1, p2 ) \
        (x)->lpVtbl->GetRfc1766FromLcid( x, p1, p2 )
    #define IMultiLanguage3_GetLcidFromRfc1766( x, p1, p2 ) \
        (x)->lpVtbl->GetLcidFromRfc1766( x, p1, p2 )
    #define IMultiLanguage3_EnumRfc1766( x, p ) \
        (x)->lpVtbl->EnumRfc1766( x, p )
    #define IMultiLanguage3_GetRfc1766Info( x, p1, p2 ) \
        (x)->lpVtbl->GetRfc1766Info( x, p1, p2 )
    #define IMultiLanguage3_CreateConvertCharset( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->CreateConvertCharset( x, p1, p2, p3, p4 )
    #define IMultiLanguage3_ConvertStringInIStream( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->ConvertStringInIStream( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IMultiLanguage3_ConvertStringToUnicodeEx( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->ConvertStringToUnicodeEx( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IMultiLanguage3_ConvertStringFromUnicodeEx( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->ConvertStringFromUnicodeEx( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IMultiLanguage3_DetectCodepageInIStream( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->DetectCodepageInIStream( x, p1, p2, p3, p4, p5 )
    #define IMultiLanguage3_DetectInputCodepage( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->DetectInputCodepage( x, p1, p2, p3, p4, p5, p6 )
    #define IMultiLanguage3_ValidateCodePage( x, p1, p2 ) \
        (x)->lpVtbl->ValidateCodePage( x, p1, p2 )
    #define IMultiLanguage3_GetCodePageDescription( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetCodePageDescription( x, p1, p2, p3, p4 )
    #define IMultiLanguage3_IsCodePageInstallable( x, p ) \
        (x)->lpVtbl->IsCodePageInstallable( x, p )
    #define IMultiLanguage3_SetMimeDBSource( x, p ) \
        (x)->lpVtbl->SetMimeDBSource( x, p )
    #define IMultiLanguage3_GetNumberOfScripts( x, p ) \
        (x)->lpVtbl->GetNumberOfScripts( x, p )
    #define IMultiLanguage3_EnumScripts( x, p1, p2, p3 ) \
        (x)->lpVtbl->EnumScripts( x, p1, p2, p3 )
    #define IMultiLanguage3_ValidateCodePageEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->ValidateCodePageEx( x, p1, p2, p3 )
    #define IMultiLanguage3_DetectOutboundCodePage( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->DetectOutboundCodePage( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IMultiLanguage3_DetectOutboundCodePageInIStream( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->DetectOutboundCodePageInIStream( x, p1, p2, p3, p4, p5, p6, p7 )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __mlang_h__ */
