/*
 *  ras.h       Remote Access Service (RAS) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _RAS_H_
#define _RAS_H_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <lmcons.h>
#include <inaddr.h>
#include <in6addr.h>
#ifdef USES_RAS_QUARANTINE_APIS
    #include <naptypes.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* RAS connection handle */
DECLARE_HANDLE( HRASCONN );
typedef HRASCONN    *LPHRASCONN;

/* RAS NAP flags */
#ifdef USES_RAS_QUARANTINE_APIS
    #define RASNAP_ProbationTime    0x00000001L
#endif

/* RAS tunnel endpoint types */
#if (WINVER >= 0x0601)
    #define RASTUNNELENDPOINT_UNKNOWN   0L
    #define RASTUNNELENDPOINT_IPv4      1L
    #define RASTUNNELENDPOINT_IPv6      2L
#endif

/* RAS maximum sizes */
#define RAS_MaxDeviceType           16
#define RAS_MaxPhoneNumber          128
#define RAS_MaxIpAddress            15
#define RAS_MaxIpxAddress           21
#if (WINVER >= 0x0400)
    #define RAS_MaxEntryName        256
    #define RAS_MaxDeviceName       128
    #define RAS_MaxCallbackNumber   RAS_MaxPhoneNumber
#else
    #define RAS_MaxEntryName        20
    #define RAS_MaxDeviceName       32
    #define RAS_MAxCallbackNumber   48
#endif
#define RAS_MaxAreaCode             10
#define RAS_MaxPadType              32
#define RAS_MaxX25Address           200
#define RAS_MaxFacilities           200
#define RAS_MaxUserData             200
#define RAS_MaxReplyMessage         1024
#define RAS_MaxDnsSuffix            256

/* RAS connection flags */
#if (WINVER >= 0x0501)
    #define RASCF_AllUsers      0x00000001L
    #define RASCF_GlobalCreds   0x00000002L
    #define RASCF_OwnerKnown    0x00000004L
    #define RASCF_OwnerMatch    0x00000008L
#endif

/* Macros to manipulate RAS connection flags */
#if (WINVER >= 0x0501)
    #define RASCF_IsOwner( x ) \
        (((x) & (RASCF_OwnerKnown | RASCF_OwnerMatch)) == (RASCF_OwnerKnown | \
        RASCF_OwnerMatch)
    #define RASCF_IsNotOwner( x ) \
        (((x) & (RASCF_OwnerKnown | RASCF_OwnerMatch)) == RASCF_OwnerKnown)
#endif

/* RAS connection state flags */
#define RASCS_PAUSED    0x00001000L
#define RASCS_DONE      0x00002000L

/* RAS connection substate flags */
#if (WINVER >= 0x0601)
    #define RASCSS_DONE 0x00002000L
#endif

/* RasDial() extended options */
#define RDEOPT_UsePrefixSuffix              0x00000001L
#define RDEOPT_PausedStates                 0x00000002L
#define RDEOPT_IgnoreModemSpeaker           0x00000004L
#define RDEOPT_SetModemSpeaker              0x00000008L
#define RDEOPT_IgnoreSoftwareCompression    0x00000010L
#define RDEOPT_SetSoftwareCompression       0x00000020L
#define RDEOPT_DisableConnectedUI           0x00000040L
#define RDEOPT_DisableReconnectUI           0x00000080L
#define RDEOPT_DisableReconnect             0x00000100L
#define RDEOPT_NoUser                       0x00000200L
#define RDEOPT_PauseOnScript                0x00000400L
#define RDEOPT_Router                       0x00000800L
#if (WINVER >= 0x0500)
    #define RDEOPT_CustomDial               0x00001000L
#endif
#if (WINVER >= 0x0501)
    #define RDEOPT_UseCustomScripting       0x00002000L
#endif

/* RAS entry name flags */
#define REN_User        0x00000000L
#define REN_AllUsers    0x00000001L

/* RAS IP options */
#if (WINVER >= 0x0500)
    #define RASIPO_VJ   0x00000001L
#endif

/* LCP authentication protocols */
#if (WINVER >= 0x0500)
    #define RASLCPAP_PAP    0x0000C023L
    #define RASLCPAP_SPAP   0x0000C027L
    #define RASLCPAP_CHAP   0x0000C223L
    #define RASLCPAP_EAP    0x0000C227L
#endif

/* LCP authentication data */
#if (WINVER >= 0x0500)
    #define RASLCPAD_CHAP_MD5   0x00000005L
    #define RASLCPAD_CHAP_MS    0x00000080L
    #define RASLCPAD_CHAP_MSV2  0x00000081L
#endif

/* LCP options */
#if (WINVER >= 0x0500)
    #define RASLCPO_PFC     0x00000001L
    #define RASLCPO_ACFC    0x00000002L
    #define RASLCPO_SSHF    0x00000004L
    #define RASLCPO_DES_56  0x00000008L
    #define RASLCPO_3_DES   0x00000010L
#endif
#if (WINVER >= 0x0600)
    #define RASLCPO_AES_128 0x00000020L
    #define RASLCPO_AES_256 0x00000040L
#endif

/* CCP compression algorithms */
#if (WINVER >= 0x0500)
    #define RASCCPCA_MPPC   0x00000006L
    #define RASCCPCA_STAC   0x00000005L
#endif

/* CCP options */
#if (WINVER >= 0x0500)
    #define RASCCPO_Compression         0x00000001L
    #define RASCCPO_HistoryLess         0x00000002L
    #define RASCCPO_Encryption56bit     0x00000010L
    #define RASCCPO_Encryption40bit     0x00000020L
    #define RASCCPO_Encryption128bit    0x00000100L
#endif

/* RAS IKEv2 flags */
#if (WINVER >= 0x0601)
    #define RASIKEv2_FLAGS_MOBIKESUPPORTED  0x00000001L
    #define RASIKEv2_FLAGS_BEHIND_NAT       0x00000002L
    #define RASIKEv2_FLAGS_SERVERBEHIND_NAT 0x00000004L
#endif

/* RAS IKEv2 authentication protocols */
#if (WINVER >= 0x0601)
    #define RASIKEv2_AUTH_MACHINECERTIFICATES   1L
    #define RASIKEv2_AUTH_EAP                   2L
#endif

/* RAS registered message */
#define RASDIALEVENT    "RasDialEvent"

/* RAS message */
#define WM_RASDIALEVENT 0xCCCD

/* Encryption types */
#if (WINVER >= 0x0500)
    #define ET_None         0L
    #define ET_Require      1L
    #define ET_RequireMax   2L
    #define ET_Optional     3L
#endif

/* VPN strategies */
#define VS_Default          0L
#define VS_PptpOnly         1L
#define VS_PptpFirst        2L
#define VS_L2tpOnly         3L
#define VS_L2tpFirst        4L
#if (WINVER >= 0x0600)
    #define VS_SstpOnly     5L
    #define VS_SstpFirst    6L
#endif
#if (WINVER >= 0x0601)
    #define VS_Ikev2Only    7L
    #define VS_Ikev2First   8L
    #define VS_PptpSstp     12L
    #define VS_L2tpSstp     13L
    #define VS_Ikev2Sstp    14L
#endif

/* RAS entry options */
#define RASEO_UseCountryAndAreaCodes    0x00000001L
#define RASEO_SpecificIpAddr            0x00000002L
#define RASEO_SpecificNameServers       0x00000004L
#define RASEO_IpHeaderCompression       0x00000008L
#define RASEO_RemoteDefaultGateway      0x00000010L
#define RASEO_DisableLcpExtensions      0x00000020L
#define RASEO_TerminalBeforeDial        0x00000040L
#define RASEO_TerminalAfterDial         0x00000080L
#define RASEO_ModemLights               0x00000100L
#define RASEO_SwCompression             0x00000200L
#define RASEO_RequireEncryptedPw        0x00000400L
#define RASEO_RequireMsEncryptedPw      0x00000800L
#define RASEO_RequireDataEncryption     0x00001000L
#define RASEO_NetworkLogon              0x00002000L
#define RASEO_UseLogonCredentials       0x00004000L
#define RASEO_PromoteAlternates         0x00008000L
#if (WINVER >= 0x0401)
    #define RASEO_SecureLocalFiles      0x00010000L
#endif
#if (WINVER >= 0x0500)
    #define RASEO_RequireEAP            0x00020000L
    #define RASEO_RequirePAP            0x00040000L
    #define RASEO_RequireSPAP           0x00080000L
    #define RASEO_Custom                0x00100000L
    #define RASEO_PreviewPhoneNumber    0x00200000L
    #define RASEO_SharedPhoneNumbers    0x00800000L
    #define RASEO_PreviewUserPw         0x01000000L
    #define RASEO_PreviewDomain         0x02000000L
    #define RASEO_ShowDialingProgress   0x04000000L
    #define RASEO_RequireCHAP           0x08000000L
    #define RASEO_RequireMsCHAP         0x10000000L
    #define RASEO_RequireMsCHAP2        0x20000000L
    #define RASEO_RequireW95MSCHAP      0x40000000L
    #define RASEO_CustomScript          0x80000000L
#endif

/* RAS entry secondary options */
#if (WINVER >= 0x0501)
    #define RASEO2_SecureFileAndPrint           0x00000001L
    #define RASEO2_SecureClientForMSNet         0x00000002L
    #define RASEO2_DontNegotiateMultilink       0x00000004L
    #define RASEO2_DontUseRasCredentials        0x00000008L
    #define RASEO2_UsePreSharedKey              0x00000010L
    #define RASEO2_Internet                     0x00000020L
    #define RASEO2_DisableNbtOverIP             0x00000040L
    #define RASEO2_UseGlobalDeviceSettings      0x00000080L
    #define RASEO2_ReconnectIfDropped           0x00000100L
    #define RASEO2_SharePhoneNumbers            0x00000200L
#endif
#if (WINVER >= 0x0600)
    #define RASEO2_SecureRoutingCompartment     0x00000400L
    #define RASEO2_UseTypicalSettings           0x00000800L
    #define RASEO2_IPv6SpecificNameServers      0x00001000L
    #define RASEO2_IPv6RemoteDefaultGateway     0x00002000L
    #define RASEO2_RegisterIpWithDNS            0x00004000L
    #define RASEO2_UseDNSSuffixForRegistration  0x00008000L
    #define RASEO2_IPv4ExplicitMetric           0x00010000L
    #define RASEO2_IPv6ExplicitMetric           0x00020000L
    #define RASEO2_DisableIKENameEkuCheck       0x00040000L
#endif
#if (WINVER >= 0x0601)
    #define RASEO2_DisableClassBasedStaticRoute 0x00080000L
    #define RASEO2_SpecificIPv6Addr             0x00100000L
    #define RASEO2_DisableMobility              0x00200000L
    #define RASEO2_RequireMachineCertificates   0x00400000L
#endif

/* RAS entry protocols */
#define RASNP_NetBEUI   0x00000001L
#define RASNP_Ipx       0x00000002L
#define RASNP_Ip        0x00000004L
#if (WINVER >= 0x0600)
    #define RASNP_Ipv6  0x00000008L
#endif

/* RAS entry framing protocols */
#define RASFP_Ppp   0x00000001L
#define RASFP_Slip  0x00000002L
#define RASFP_Ras   0x00000004L

/* RAS entry device types */
#define RASDT_Modem         TEXT( "modem" )
#define RASDT_Isdn          TEXT( "isdn" )
#define RASDT_X25           TEXT( "x25" )
#define RASDT_Vpn           TEXT( "vpn" )
#define RASDT_Pad           TEXT( "pad" )
#define RASDT_Generic       TEXT( "GENERIC" )
#define RASDT_Serial        TEXT( "SERIAL" )
#define RASDT_FrameRelay    TEXT( "FRAMERELAY" )
#define RASDT_Atm           TEXT( "ATM" )
#define RASDT_Sonet         TEXT( "SONET" )
#define RASDT_SW56          TEXT( "SW56" )
#define RASDT_Irda          TEXT( "IRDA" )
#define RASDT_Parallel      TEXT( "PARALLEL" )
#if (WINVER >= 0x0501)
    #define RASDT_PPPoE     TEXT( "PPPoE" )
#endif

/* RAS entry types */
#define RASET_Phone         1L
#define RASET_Vpn           2L
#if (WINVER < 0x0600)
    #define RASET_Direct    3L
#endif
#define RASET_Internet      4L
#if (WINVER >= 0x0501)
    #define RASET_Broadband 5L
#endif

/* RasConnectionNotification() flags */
#if (WINVER >= 0x0400)
    #define RASCN_Connection        0x00000001L
    #define RASCN_Disconnection     0x00000002L
    #define RASCN_BandwidthAdded    0x00000004L
    #define RASCN_BandwidthRemoved  0x00000008L
    #define RASCN_Dormant           0x00000010L
    #define RASCN_ReConnection      0x00000020L
#endif

/* RAS entry dial modes */
#if (WINVER >= 0x0401)
    #define RASEDM_DialAll      1L
    #define RASEDM_DialAsNeeded 2L
#endif

/* RAS entry idle disconnect seconds special values */
#if (WINVER >= 0x0401)
    #define RASIDS_Disabled         0xFFFFFFFFL
    #define RASIDS_UseGlobalValues  0x00000000L
#endif

/* RAS autodial flags */
#if (WINVER >= 0x0401)
    #define RASADFLG_PositionDlg    0x00000001L
#endif

/* RAS credential masks */
#if (WINVER >= 0x0401)
    #define RASCM_UserName              0x00000001L
    #define RASCM_Password              0x00000002L
    #define RASCM_Domain                0x00000004L
#endif
#if (WINVER >= 0x0501)
    #define RASCM_DefaultCreds          0x00000008L
    #define RASCM_PreSharedKey          0x00000010L
    #define RASCM_ServerPreSharedKey    0x00000020L
    #define RASCM_DDMPreSharedKey       0x00000040L
#endif

/* RasGetAutodialParam() control parameter values */
#if (WINVER >= 0x0401)
    #define RASADP_DisableConnectionQuery   0L
    #define RASADP_LoginSessionDisable      1L
    #define RASADP_SavedAddressesLimit      2L
    #define RASADP_FailedConnectionTimeout  3L
    #define RASADP_ConnectionQueryTimeout   4L
#endif

/* RasGetEapUserIdentity() flags */
#if (WINVER >= 0x0500)
    #define RASEAPF_NonInteractive  0x00000002L
    #define RASEAPF_Logon           0x00000004L
    #define RASEAPF_Preview         0x00000008L
#endif

/* RAS custom delete flags */
#if (WINVER >= 0x0500)
    #define RCD_SingleUser  0x00000000L
    #define RCD_AllUsers    0x00000001L
    #define RCD_Eap         0x00000002L
    #define RCD_Logon       0x00000004L
#endif

/* RAS NAP state */
#ifdef USES_RAS_QUARANTINE_APIS
typedef struct _tagRasNapState {
    DWORD           dwSize;
    DWORD           dwFlags;
    IsolationState  isolationState;
    ProbationTime   probationTime;
} RASNAPSTATE;
typedef RASNAPSTATE *LPRASNAPSTATE;
#endif

/* RAS API version numbers */
typedef enum RASAPIVERSION {
    RASAPIVERSION_500   = 1,
    RASAPIVERSION_501   = 2,
    RASAPIVERSION_600   = 3,
    RASAPIVERSION_601   = 4
} RASAPIVERSION;
#define RASAPIVERSION_CURRENT   RASAPIVERSION_601

/* RAS IP address */
typedef struct RASIPADDR {
    BYTE    a;
    BYTE    b;
    BYTE    c;
    BYTE    d;
} RASIPADDR;

/* RAS IPv4 and IPv6 addresses */
#if (WINVER >= 0x0600)
typedef struct in_addr  RASIPV4ADDR;
typedef struct in6_addr RASIPV6ADDR;
#endif

/* RAS tunnel endpoint */
#if (WINVER >= 0x0601)
typedef struct RASTUNNELENDPOINT {
    DWORD   dwType;
    union {
        RASIPV4ADDR ipv4;
        RASIPV6ADDR ipv6;
    };
} RASTUNNELENDPOINT;
#endif

/* RAS connection */
typedef struct tagRASCONNA {
    DWORD       dwSize;
    HRASCONN    hrasconn;
    CHAR        szEntryName[RAS_MaxEntryName + 1];
#if (WINVER >= 0x0400)
    CHAR        szDeviceType[RAS_MaxDeviceType + 1];
    CHAR        szDeviceName[RAS_MaxDeviceName + 1];
#endif
#if (WINVER >= 0x0401)
    CHAR        szPhonebook[MAX_PATH];
    DWORD       dwSubEntry;
#endif
#if (WINVER >= 0x0500)
    GUID        guidEntry;
#endif
#if (WINVER >= 0x0501)
    DWORD       dwFlags;
    LUID        luid;
#endif
#if (WINVER >= 0x0600)
    GUID        guidCorrelationId;
#endif
} RASCONNA;
typedef RASCONNA    *LPRASCONNA;
typedef struct tagRASCONNW {
    DWORD       dwSize;
    HRASCONN    hrasconn;
    WCHAR       szEntryName[RAS_MaxEntryName + 1];
#if (WINVER >= 0x0400)
    WCHAR       szDeviceType[RAS_MaxDeviceType + 1];
    WCHAR       szDeviceName[RAS_MaxDeviceName + 1];
#endif
#if (WINVER >= 0x0401)
    WCHAR       szPhonebook[MAX_PATH];
    DWORD       dwSubEntry;
#endif
#if (WINVER >= 0x0500)
    GUID        guidEntry;
#endif
#if (WINVER >= 0x0501)
    DWORD       dwFlags;
    LUID        luid;
#endif
#if (WINVER >= 0x0600)
    GUID        guidCorrelationId;
#endif
} RASCONNW;
typedef RASCONNW    *LPRASCONNW;
#ifdef UNICODE
typedef RASCONNW    RASCONN;
typedef LPRASCONNW  LPRASCONN;
#else
typedef RASCONNA    RASCONN;
typedef LPRASCONNA  LPRASCONN;
#endif

/* RAS connection states */
typedef enum tagRASCONNSTATE {
    RASCS_OpenPort,
    RASCS_PortOpened,
    RASCS_ConnectDevice,
    RASCS_DeviceConnected,
    RASCS_AllDevicesConnected,
    RASCS_Authenticate,
    RASCS_AuthNotify,
    RASCS_AuthRetry,
    RASCS_AuthCallback,
    RASCS_AuthChangePassword,
    RASCS_AuthProject,
    RASCS_AuthLinkSpeed,
    RASCS_AuthAck,
    RASCS_ReAuthenticate,
    RASCS_Authenticated,
    RASCS_PrepareForCallback,
    RASCS_WaitForModemReset,
    RASCS_WaitForCallback,
    RASCS_Projected,
#if (WINVER >= 0x0400)
    RASCS_StartAuthentication,
    RASCS_CallbackComplete,
    RASCS_LogonNetwork,
#endif
    RASCS_SubEntryConnected,
    RASCS_SubEntryDisconnected,
#if (WINVER >= 0x0601)
    RASCS_ApplySettings,
#endif
    RASCS_Interactive           = RASCS_PAUSED,
    RASCS_RetryAuthentication,
    RASCS_CallbackSetByCaller,
    RASCS_PasswordExpired,
#if (WINVER >= 0x0500)
    RASCS_InvokeEapUI,
#endif
    RASCS_Connected             = RASCS_DONE,
    RASCS_Disconnected
} RASCONNSTATE;
typedef RASCONNSTATE    *LPRASCONNSTATE;

/* RAS connection substates */
#if (WINVER >= 0x0601)
typedef enum tagRASCONNSUBSTATE {
    RASCSS_None         = 0,
    RASCSS_Dormant      = 1,
    RASCSS_Reconnecting = 2,
    RASCSS_Reconnected  = RASCSS_DONE
} RASCONNSUBSTATE;
typedef RASCONNSUBSTATE *LPRASCONNSUBSTATE;
#endif

/* RAS connection status */
typedef struct tagRASCONNSTATUSA {
    DWORD               dwSize;
    RASCONNSTATE        rasconnstate;
    DWORD               dwError;
    CHAR                szDeviceType[RAS_MaxDeviceType + 1];
    CHAR                szDeviceName[RAS_MaxDeviceName + 1];
#if (WINVER >= 0x0401)
    CHAR                szPhoneNumber[RAS_MaxPhoneNumber + 1];
#endif
#if (WINVER >= 0x0601)
    RASTUNNELENDPOINT   localEndPoint;
    RASTUNNELENDPOINT   remoteEndPoint;
    RASCONNSUBSTATE     rasconnsubstate;
#endif
} RASCONNSTATUSA;
typedef RASCONNSTATUSA      *LPRASCONNSTATUSA;
typedef struct tagRASCONNSTATUSW {
    DWORD               dwSize;
    RASCONNSTATE        rasconnstate;
    DWORD               dwError;
    WCHAR               szDeviceType[RAS_MaxDeviceType + 1];
    WCHAR               szDeviceName[RAS_MaxDeviceName + 1];
#if (WINVER >= 0x0401)
    WCHAR               szPhoneNumber[RAS_MaxPhoneNumber + 1];
#endif
#if (WINVER >= 0x0601)
    RASTUNNELENDPOINT   localEndPoint;
    RASTUNNELENDPOINT   remoteEndPoint;
    RASCONNSUBSTATE     rasconnsubstate;
#endif
} RASCONNSTATUSW;
typedef RASCONNSTATUSW      *LPRASCONNSTATUSW;
#ifdef UNICODE
typedef RASCONNSTATUSW      RASCONNSTATUS;
typedef LPRASCONNSTATUSW    LPRASCONNSTATUS;
#else
typedef RASCONNSTATUSA      RASCONNSTATUS;
typedef LPRASCONNSTATUSA    LPRASCONNSTATUS;
#endif

/* RasDial() parameters */
typedef struct tagRASDIALPARAMSA {
    DWORD       dwSize;
    CHAR        szEntryName[RAS_MaxEntryName + 1];
    CHAR        szPhoneNumber[RAS_MaxPhoneNumber + 1];
    CHAR        szCallbackNumber[RAS_MaxCallbackNumber + 1];
    CHAR        szUserName[UNLEN + 1];
    CHAR        szPassword[PWLEN + 1];
    CHAR        szDomain[DNLEN + 1];
#if (WINVER >= 0x0401)
    DWORD       dwSubEntry;
    ULONG_PTR   dwCallbackId;
#endif
#if (WINVER >= 0x0601)
    DWORD       dwIfIndex;
#endif
} RASDIALPARAMSA;
typedef RASDIALPARAMSA      *LPRASDIALPARAMSA;
typedef struct tagRASDIALPARAMSW {
    DWORD       dwSize;
    WCHAR       szEntryName[RAS_MaxEntryName + 1];
    WCHAR       szPhoneNumber[RAS_MaxPhoneNumber + 1];
    WCHAR       szCallbackNumber[RAS_MaxCallbackNumber + 1];
    WCHAR       szUserName[UNLEN + 1];
    WCHAR       szPassword[PWLEN + 1];
    WCHAR       szDomain[DNLEN + 1];
#if (WINVER >= 0x0401)
    DWORD       dwSubEntry;
    ULONG_PTR   dwCallbackId;
#endif
#if (WINVER >= 0x0601)
    DWORD       dwIfIndex;
#endif
} RASDIALPARAMSW;
typedef RASDIALPARAMSW      *LPRASDIALPARAMSW;
#ifdef UNICODE
typedef RASDIALPARAMSW      RASDIALPARAMS;
typedef LPRASDIALPARAMSW    LPRASDIALPARAMS;
#else
typedef RASDIALPARAMSA      RASDIALPARAMS;
typedef LPRASDIALPARAMSA    LPRASDIALPARAMS;
#endif

/* RAS Extensible Authentication Protocol (EAP) information */
#if (WINVER >= 0x0500)
typedef struct tagRASEAPINFO {
    DWORD   dwSizeofEapInfo;
    BYTE    *pbEapInfo;
} RASEAPINFO;
#endif

/* RAS device-specific information */
#if (WINVER >= 0x0601)
typedef struct tagRASDEVSPECIFICINFO {
    DWORD   dwSize;
    BYTE    *pbDevSpecificInfo;
} RASDEVSPECIFICINFO;
typedef RASDEVSPECIFICINFO  *PRASDEVSPECIFICINFO;
#endif

/* RasDial() extensions */
typedef struct tagRASDIALEXTENSIONS {
    DWORD               dwSize;
    DWORD               dwfOptions;
    HWND                hwndParent;
    ULONG_PTR           reserved;
#if (WINVER >= 0x0500)
    ULONG_PTR           reserved1;
    RASEAPINFO          RasEapInfo;
#endif
#if (WINVER >= 0x0601)
    BOOL                fSkipPppAuth;
    RASDEVSPECIFICINFO  RasDevSpecificInfo;
#endif
} RASDIALEXTENSIONS;
typedef RASDIALEXTENSIONS   *LPRASDIALEXTENSIONS;

/* RAS entry name */
typedef struct tagRASENTRYNAMEA {
    DWORD   dwSize;
    CHAR    szEntryName[RAS_MaxEntryName + 1];
#if (WINVER >= 0x0500)
    DWORD   dwFlags;
    CHAR    szPhonebookPath[MAX_PATH + 1];
#endif
} RASENTRYNAMEA;
typedef RASENTRYNAMEA   *LPRASENTRYNAMEA;
typedef struct tagRASENTRYNAMEW {
    DWORD   dwSize;
    WCHAR   szEntryName[RAS_MaxEntryName + 1];
#if (WINVER >= 0x0500)
    DWORD   dwFlags;
    WCHAR   szPhonebookPath[MAX_PATH + 1];
#endif
} RASENTRYNAMEW;
typedef RASENTRYNAMEW   *LPRASENTRYNAMEW;
#ifdef UNICODE
typedef RASENTRYNAMEW   RASENTRYNAME;
typedef LPRASENTRYNAMEW LPRASENTRYNAME;
#else
typedef RASENTRYNAMEA   RASENTRYNAME;
typedef LPRASENTRYNAMEA LPRASENTRYNAME;
#endif

/* RAS projections */
typedef enum tagRASPROJECTION {
    RASP_Amb        = 0x00010000,
    RASP_PppNbf     = 0x0000803F,
    RASP_PppIpx     = 0x0000802B,
    RASP_PppIp      = 0x00008021,
#if (WINVER >= 0x0500)
    RASP_PppCcp     = 0x000080FD,
#endif
    RASP_PppLcp     = 0x0000C021,
#if (WINVER >= 0x0600)
    RASP_PppIpv6    = 0x00008057
#else
    RASP_Slip       = 0x00020000
#endif
} RASPROJECTION;
typedef RASPROJECTION   *LPRASPROJECTION;

/* RAS Authentication Message Block (AMB) */
typedef struct tagRASAMBA {
    DWORD   dwSize;
    DWORD   dwError;
    CHAR    szNetBiosError[NETBIOS_NAME_LEN + 1];
    BYTE    bLana;
} RASAMBA;
typedef RASAMBA     *LPRASAMBA;
typedef struct tagRASAMBW {
    DWORD   dwSize;
    DWORD   dwError;
    WCHAR   szNetBiosError[NETBIOS_NAME_LEN + 1];
    BYTE    bLana;
} RASAMBW;
typedef RASAMBW     *LPRASAMBW;
#ifdef UNICODE
typedef RASAMBW     RASAMB;
typedef LPRASAMBW   LPRASAMB;
#else
typedef RASAMBA     RASAMB;
typedef LPRASAMBA   LPRASAMB;
#endif

/* RAS PPP NBF */
typedef struct tagRASPPPNBFA {
    DWORD   dwSize;
    DWORD   dwError;
    DWORD   dwNetBiosError;
    CHAR    szNetBiosError[NETBIOS_NAME_LEN + 1];
    CHAR    szWorkstationName[NETBIOS_NAME_LEN + 1];
    BYTE    bLana;
} RASPPPNBFA;
typedef RASPPPNBFA      *LPRASPPPNBFA;
typedef struct tagRASPPPNBFW {
    DWORD   dwSize;
    DWORD   dwError;
    DWORD   dwNetBiosError;
    WCHAR   szNetBiosError[NETBIOS_NAME_LEN + 1];
    WCHAR   szWorkstationName[NETBIOS_NAME_LEN + 1];
    BYTE    bLana;
} RASPPPNBFW;
typedef RASPPPNBFW      *LPRASPPPNBFW;
#ifdef UNICODE
typedef RASPPPNBFW      RASPPPNBF;
typedef LPRASPPPNBFW    LPRASPPPNBF;
#else
typedef RASPPPNBFA      RASPPPNBF;
typedef LPRASPPPNBFA    LPRASPPPNBF;
#endif

/* RAS Internetwork Packet Exchange (IPX) */
typedef struct tagRASIPXA {
    DWORD   dwSize;
    DWORD   dwError;
    CHAR    szIpxAddress[RAS_MaxIpxAddress + 1];
} RASIPXA;
typedef RASIPXA     *LPRASIPXA;
typedef struct tagRASIPXW {
    DWORD   dwSize;
    DWORD   dwError;
    WCHAR   szIpxAddress[RAS_MaxIpxAddress + 1];
} RASIPXW;
typedef RASIPXW     *LPRASIPXW;
#ifdef UNICODE
typedef RASIPXW     RASIPX;
typedef LPRASIPXW   LPRASIPX;
#else
typedef RASIPXA     RASIPX;
typedef LPRASIPXA   LPRASIPX;
#endif

/* RAS PPP IP */
typedef struct tagRASPPPIPA {
    DWORD   dwSize;
    DWORD   dwError;
    CHAR    szIpAddress[RAS_MaxIpAddress + 1];
#ifndef WINNT35COMPATIBLE
    CHAR    szServerIpAddress[RAS_MaxIpAddress + 1];
#endif
#if (WINVER >= 0x0500)
    DWORD   dwOptions;
    DWORD   dwServerOptions;
#endif
} RASPPPIPA;
typedef RASPPPIPA   *LPRASPPPIPA;
typedef struct tagRASPPPIPW {
    DWORD   dwSize;
    DWORD   dwError;
    WCHAR   szIpAddress[RAS_MaxIpAddress + 1];
#ifndef WINNT35COMPATIBLE
    WCHAR   szServerIpAddress[RAS_MaxIpAddress + 1];
#endif
#if (WINVER >= 0x0500)
    DWORD   dwOptions;
    DWORD   dwServerOptions;
#endif
} RASPPPIPW;
typedef RASPPPIPW   *LPRASPPPIPW;
#ifdef UNICODE
typedef RASPPPIPW   RASPPPIP;
typedef LPRASPPPIPW LPRASPPPIP;
#else
typedef RASPPPIPA   RASPPPIP;
typedef LPRASPPPIPA LPRASPPPIP;
#endif

/* RAS PPP IPv6 */
#if (WINVER >= 0x0600)
typedef struct tagRASPPPIPV6 {
    DWORD   dwSize;
    DWORD   dwError;
    BYTE    bLocalInterfaceIdentifier[8];
    BYTE    bPeerInterfaceIdentifier[8];
    BYTE    bLocalCompressionProtocol[2];
    BYTE    bPeerCompressionProtocol[2];
} RASPPPIPV6;
typedef RASPPPIPV6  *LPRASPPPIPV6;
#endif

/* RAS PPP LCP */
typedef struct tagRASPPPLCPA {
    DWORD   dwSize;
    BOOL    fBundled;
#if (WINVER >= 0x0500)
    DWORD   dwError;
    DWORD   dwAuthenticationProtocol;
    DWORD   dwAuthenticationData;
    DWORD   dwEapTypeId;
    DWORD   dwServerAuthenticationProtocol;
    DWORD   dwServerAuthenticationData;
    DWORD   dwServerEapTypeId;
    BOOL    fMultilink;
    DWORD   dwTerminateReason;
    DWORD   dwServerTerminateReason;
    CHAR    szReplyMessage[RAS_MaxReplyMessage];
    DWORD   dwOptions;
    DWORD   dwServerOptions;
#endif
} RASPPPLCPA;
typedef RASPPPLCPA      *LPRASPPPLCPA;
typedef struct tagRASPPPLCPW {
    DWORD   dwSize;
    BOOL    fBundled;
#if (WINVER >= 0x0500)
    DWORD   dwError;
    DWORD   dwAuthenticationProtocol;
    DWORD   dwAuthenticationData;
    DWORD   dwEapTypeId;
    DWORD   dwServerAuthenticationProtocol;
    DWORD   dwServerAuthenticationData;
    DWORD   dwServerEapTypeId;
    BOOL    fMultilink;
    DWORD   dwTerminateReason;
    DWORD   dwServerTerminateReason;
    WCHAR   szReplyMessage[RAS_MaxReplyMessage];
    DWORD   dwOptions;
    DWORD   dwServerOptions;
#endif
} RASPPPLCPW;
typedef RASPPPLCPW      *LPRASPPPLCPW;
#ifdef UNICODE
typedef RASPPPLCPW      RASPPPLCP;
typedef LPRASPPPLCPW    LPRASPPPLCP;
#else
typedef RASPPPLCPA      RASPPPLCP;
typedef LPRASPPPLCPA    LPRASPPPLCP;
#endif

/* RAS Serial Line IP (SLIP) */
#if (WINVER < 0x0600)
typedef struct tagRASSLIPA {
    DWORD   dwSize;
    DWORD   dwError;
    CHAR    szIpAddress[RAS_MaxIpAddress + 1];
} RASSLIPA;
typedef RASSLIPA    *LPRASSLIPA;
typedef struct tagRASSLIPW {
    DWORD   dwSize;
    DWORD   dwError;
    WCHAR   szIpAddress[RAS_MaxIpAddress + 1];
} RASSLIPW;
typedef RASSLIPW    *LPRASSLIPW;
#ifdef UNICODE
typedef RASSLIPW    RASSLIP;
typedef LPRASSLIPW  LPRASSLIP;
#else
typedef RASSLIPA    RASSLIP;
typedef LPRASSLIPA  LPRASSLIP;
#endif
#endif

/* RAS PPP Compression Control Protocol (CCP) */
#if (WINVER >= 0x0500)
typedef struct tagRASPPPCCP {
    DWORD   dwSize;
    DWORD   dwError;
    DWORD   dwCompressionAlgorithm;
    DWORD   dwOptions;
    DWORD   dwServerCompressionAlgorithm;
    DWORD   dwServerOptions;
} RASPPPCCP;
typedef RASPPPCCP   *LPRASPPPCCP;
#endif

/* RAS PPP projection information */
#if (WINVER >= 0x0601)
typedef struct _RASPPP_PROJECTION_INFO {
    DWORD       dwIPv4NegotiationError;
    RASIPV4ADDR ipv4Address;
    RASIPV4ADDR ipv4ServerAddress;
    DWORD       dwIPv4Options;
    DWORD       dwIPv4ServerOptions;
    DWORD       dwIPv6NegotiationError;
    BYTE        bInterfaceIdentifier[8];
    BYTE        bServerInterfaceIdentifier[8];
    BOOL        fBundled;
    BOOL        fMultilink;
    DWORD       dwAuthenticationProtocol;
    DWORD       dwAuthenticationData;
    DWORD       dwServerAuthenticationProtocol;
    DWORD       dwServerAuthenticationData;
    DWORD       dwEapTypeId;
    DWORD       dwServerEapTypeId;
    DWORD       dwLcpOptions;
    DWORD       dwLcpServerOptions;
    DWORD       dwCcpError;
    DWORD       dwCcpCompressionAlgorithm;
    DWORD       dwCcpServerCompressionAlgorithm;
    DWORD       dwCcpOptions;
    DWORD       dwCcpServerOptions;
} RASPPP_PROJECTION_INFO;
typedef RASPPP_PROJECTION_INFO  *PRASPPP_PROJECTION_INFO;
#endif

/* RAS IKEv2 projection information */
#if (WINVER >= 0x0601)
typedef struct _RASIKEV2_PROJECTION_INFO {
    DWORD       dwIPv4NegotiationError;
    RASIPV4ADDR ipv4Address;
    RASIPV4ADDR ipv4ServerAddress;
    DWORD       dwIPv6NegotiationError;
    RASIPV6ADDR ipv6Address;
    RASIPV6ADDR ipv6ServerAddress;
    DWORD       dwPrefixLength;
    DWORD       dwAuthenticationProtocol;
    DWORD       dwEapTypeId;
    DWORD       dwFlags;
    DWORD       dwEncryptionMethod;
    DWORD       numIPv4ServerAddresses;
    RASIPV4ADDR *ipv4ServerAddresses;
    DWORD       numIPv6ServerAddresses;
    RASIPV6ADDR *ipv6ServerAddresses;
} RASIKEV2_PROJECTION_INFO;
typedef RASIKEV2_PROJECTION_INFO    *PRASIKEV2_PROJECTION_INFO;
#endif

/* RAS projection information types */
#if (WINVER >= 0x0601)
typedef enum _RASPROJECTION_INFO_TYPE {
    PROJECTION_INFO_TYPE_PPP    = 1,
    PROJECTION_INFO_TYPE_IKEv2  = 2
} RASPROJECTION_INFO_TYPE;
#endif

/* RAS projection information */
#if (WINVER >= 0x0601)
typedef struct _RAS_PROJECTION_INFO {
    RASAPIVERSION           verison;
    RASPROJECTION_INFO_TYPE type;
    union {
        RASPPP_PROJECTION_INFO      ppp;
        RASIKEV2_PROJECTION_INFO    ikev2;
    };
} RAS_PROJECTION_INFO;
typedef RAS_PROJECTION_INFO *PRAS_PROJECTION_INFO;
#endif

/* RAS callbacks */
typedef VOID (WINAPI *RASDIALFUNC)( UINT, RASCONNSTATE, DWORD );
typedef VOID (WINAPI *RASDIALFUNC1)( HRASCONN, UINT, RASCONNSTATE, DWORD, DWORD );
typedef DWORD (WINAPI *RASDIALFUNC2)( ULONG_PTR, DWORD, HRASCONN, UINT, RASCONNSTATE, DWORD, DWORD );

/* RAS device information */
typedef struct tagRASDEVINFOA {
    DWORD   dwSize;
    CHAR    szDeviceType[RAS_MaxDeviceType + 1];
    CHAR    szDeviceName[RAS_MaxDeviceName + 1];
} RASDEVINFOA;
typedef RASDEVINFOA     *LPRASDEVINFOA;
typedef struct tagRASDEVINFOW {
    DWORD   dwSize;
    WCHAR   szDeviceType[RAS_MaxDeviceType + 1];
    WCHAR   szDeviceName[RAS_MaxDeviceName + 1];
} RASDEVINFOW;
typedef RASDEVINFOW     *LPRASDEVINFOW;
#ifdef UNICODE
typedef RASDEVINFOW     RASDEVINFO;
typedef LPRASDEVINFOW   LPRASDEVINFO;
#else
typedef RASDEVINFOA     RASDEVINFO;
typedef LPRASDEVINFOA   LPRASDEVINFO;
#endif

/* RAS country information */
typedef struct tagRASCTRYINFO {
    DWORD   dwSize;
    DWORD   dwCountryID;
    DWORD   dwNextCountryID;
    DWORD   dwCountryCode;
    DWORD   dwCountryNameOffset;
} RASCTRYINFO;
typedef RASCTRYINFO     *LPRASCTRYINFO;
typedef RASCTRYINFO     RASCTRYINFOA;
typedef RASCTRYINFO     RASCTRYINFOW;
typedef RASCTRYINFOA    *LPRASCTRYINFOA;
typedef RASCTRYINFOW    *LPRASCTRYINFOW;

/* RAS entry */
typedef struct tagRASENTRYA {
    DWORD       dwSize;
    DWORD       dwfOptions;
    DWORD       dwCountryID;
    DWORD       dwCountryCode;
    CHAR        szAreaCode[RAS_MaxAreaCode + 1];
    CHAR        szLocalPhoneNumber[RAS_MaxPhoneNumber + 1];
    DWORD       dwAlternateOffset;
    RASIPADDR   ipaddr;
    RASIPADDR   ipaddrDns;
    RASIPADDR   ipaddrDnsAlt;
    RASIPADDR   ipaddrWins;
    RASIPADDR   ipaddrWinsAlt;
    DWORD       dwFrameSize;
    DWORD       dwfNetProtocols;
    DWORD       dwFramingProtocol;
    CHAR        szScript[MAX_PATH];
    CHAR        szAutodialDll[MAX_PATH];
    CHAR        szAutodialFunc[MAX_PATH];
    CHAR        szDeviceType[RAS_MaxDeviceType + 1];
    CHAR        szDeviceName[RAS_MaxDeviceName + 1];
    CHAR        szX25PadType[RAS_MaxPadType + 1];
    CHAR        szX25Address[RAS_MaxX25Address + 1];
    CHAR        szX25Facilities[RAS_MaxFacilities + 1];
    CHAR        szX25UserData[RAS_MaxUserData + 1];
    DWORD       dwChannels;
    DWORD       dwReserved1;
    DWORD       dwReserved2;
#if (WINVER >= 0x0401)
    DWORD       dwSubEntries;
    DWORD       dwDialMode;
    DWORD       dwDialExtraPercent;
    DWORD       dwDialExtraSampleSeconds;
    DWORD       dwHangUpExtraPercent;
    DWORD       dwHangUpExtraSampleSeconds;
    DWORD       dwIdleDisconnectSeconds;
#endif
#if (WINVER >= 0x0500)
    DWORD       dwType;
    DWORD       dwEncryptionType;
    DWORD       dwCustomAuthKey;
    GUID        guidId;
    CHAR        szCustomDialDll[MAX_PATH];
    DWORD       dwVpnStrategy;
#endif
#if (WINVER >= 0x0501)
    DWORD       dwfOptions2;
    DWORD       dwfOptions3;
    CHAR        szDnsSuffix[RAS_MaxDnsSuffix];
    DWORD       dwTcpWindowSize;
    CHAR        szPrerequisitePbk[MAX_PATH];
    CHAR        szPrerequisiteEntry[RAS_MaxEntryName + 1];
    DWORD       dwRedialCount;
    DWORD       dwRedialPause;
#endif
#if (WINVER >= 0x0600)
    RASIPV6ADDR ipv6addrDns;
    RASIPV6ADDR ipv6addrDnsAlt;
    DWORD       dwIPv4InterfaceMetric;
    DWORD       dwIPv6InterfaceMetric;
#endif
#if (WINVER >= 0x0601)
    RASIPV6ADDR ipv6addr;
    DWORD       dwIPv6PrefixLength;
    DWORD       dwNetworkOutageTime;
#endif
} RASENTRYA;
typedef RASENTRYA   *LPRASENTRYA;
typedef struct tagRASENTRYW {
    DWORD       dwSize;
    DWORD       dwfOptions;
    DWORD       dwCountryID;
    DWORD       dwCountryCode;
    WCHAR       szAreaCode[RAS_MaxAreaCode + 1];
    WCHAR       szLocalPhoneNumber[RAS_MaxPhoneNumber + 1];
    DWORD       dwAlternateOffset;
    RASIPADDR   ipaddr;
    RASIPADDR   ipaddrDns;
    RASIPADDR   ipaddrDnsAlt;
    RASIPADDR   ipaddrWins;
    RASIPADDR   ipaddrWinsAlt;
    DWORD       dwFrameSize;
    DWORD       dwfNetProtocols;
    DWORD       dwFramingProtocol;
    WCHAR       szScript[MAX_PATH];
    WCHAR       szAutodialDll[MAX_PATH];
    WCHAR       szAutodialFunc[MAX_PATH];
    WCHAR       szDeviceType[RAS_MaxDeviceType + 1];
    WCHAR       szDeviceName[RAS_MaxDeviceName + 1];
    WCHAR       szX25PadType[RAS_MaxPadType + 1];
    WCHAR       szX25Address[RAS_MaxX25Address + 1];
    WCHAR       szX25Facilities[RAS_MaxFacilities + 1];
    WCHAR       szX25UserData[RAS_MaxUserData + 1];
    DWORD       dwChannels;
    DWORD       dwReserved1;
    DWORD       dwReserved2;
#if (WINVER >= 0x0401)
    DWORD       dwSubEntries;
    DWORD       dwDialMode;
    DWORD       dwDialExtraPercent;
    DWORD       dwDialExtraSampleSeconds;
    DWORD       dwHangUpExtraPercent;
    DWORD       dwHangUpExtraSampleSeconds;
    DWORD       dwIdleDisconnectSeconds;
#endif
#if (WINVER >= 0x0500)
    DWORD       dwType;
    DWORD       dwEncryptionType;
    DWORD       dwCustomAuthKey;
    GUID        guidId;
    WCHAR       szCustomDialDll[MAX_PATH];
    DWORD       dwVpnStrategy;
#endif
#if (WINVER >= 0x0501)
    DWORD       dwfOptions2;
    DWORD       dwfOptions3;
    WCHAR       szDnsSuffix[RAS_MaxDnsSuffix];
    DWORD       dwTcpWindowSize;
    WCHAR       szPrerequisitePbk[MAX_PATH];
    WCHAR       szPrerequisiteEntry[RAS_MaxEntryName + 1];
    DWORD       dwRedialCount;
    DWORD       dwRedialPause;
#endif
#if (WINVER >= 0x0600)
    RASIPV6ADDR ipv6addrDns;
    RASIPV6ADDR ipv6addrDnsAlt;
    DWORD       dwIPv4InterfaceMetric;
    DWORD       dwIPv6InterfaceMetric;
#endif
#if (WINVER >= 0x0601)
    RASIPV6ADDR ipv6addr;
    DWORD       dwIPv6PrefixLength;
    DWORD       dwNetworkOutageTime;
#endif
} RASENTRYW;
typedef RASENTRYW   *LPRASENTRYW;
#ifdef UNICODE
typedef RASENTRYW   RASENTRY;
typedef LPRASENTRYW LPRASENTRY;
#else
typedef RASENTRYA   RASENTRY;
typedef LPRASENTRYA LPRASENTRY;
#endif

/* Old autodial function */
typedef BOOL (WINAPI *ORASADFUNC)( HWND, LPSTR, DWORD, LPDWORD );

/* RAS autodial parameters */
#if (WINVER >= 0x0401)
typedef struct tagRASADPARAMS {
    DWORD   dwSize;
    HWND    hwndOwner;
    DWORD   dwFlags;
    LONG    xDlg;
    LONG    yDlg;
} RASADPARAMS;
typedef RASADPARAMS *LPRASADPARAMS;
#endif

/* RAS autodial function */
#if (WINVER >= 0x0401)
typedef BOOL (WINAPI *RASADFUNCA)( LPSTR, LPSTR, LPRASADPARAMS, LPDWORD );
typedef BOOL (WINAPI *RASADFUNCW)( LPWSTR, LPWSTR, LPRASADPARAMS, LPDWORD );
#ifdef UNICODE
    #define RASADFUNC   RASADFUNCW
#else
    #define RASADFUNC   RASADFUNCA
#endif
#endif

/* RAS subentry */
#if (WINVER >= 0x0401)
typedef struct tagRASSUBENTRYA {
    DWORD   dwSize;
    DWORD   dwfFlags;
    CHAR    szDeviceType[RAS_MaxDeviceType + 1];
    CHAR    szDeviceName[RAS_MaxDeviceName + 1];
    CHAR    szLocalPhoneNumber[RAS_MaxPhoneNumber + 1];
    DWORD   dwAlternateOffset;
} RASSUBENTRYA;
typedef RASSUBENTRYA    *LPRASSUBENTRYA;
typedef struct tagRASSUBENTRYW {
    DWORD   dwSize;
    DWORD   dwfFlags;
    WCHAR   szDeviceType[RAS_MaxDeviceType + 1];
    WCHAR   szDeviceName[RAS_MaxDeviceName + 1];
    WCHAR   szLocalPhoneNumber[RAS_MaxPhoneNumber + 1];
    DWORD   dwAlternateOffset;
} RASSUBENTRYW;
typedef RASSUBENTRYW    *LPRASSUBENTRYW;
#ifdef UNICODE
typedef RASSUBENTRYW    RASSUBENTRY;
typedef LPRASSUBENTRYW  LPRASSUBENTRY;
#else
typedef RASSUBENTRYA    RASSUBENTRY;
typedef LPRASSUBENTRYA  LPRASSUBENTRY;
#endif
#endif

/* RAS credentials */
#if (WINVER >= 0x0401)
typedef struct tagRASCREDENTIALSA {
    DWORD   dwSize;
    DWORD   dwMask;
    CHAR    szUserName[UNLEN + 1];
    CHAR    szPassword[PWLEN + 1];
    CHAR    szDomain[DNLEN + 1];
} RASCREDENTIALSA;
typedef RASCREDENTIALSA     *LPRASCREDENTIALSA;
typedef struct tagRASCREDENTIALSW {
    DWORD   dwSize;
    DWORD   dwMask;
    WCHAR   szUserName[UNLEN + 1];
    WCHAR   szPassword[PWLEN + 1];
    WCHAR   szDomain[DNLEN + 1];
} RASCREDENTIALSW;
typedef RASCREDENTIALSW     *LPRASCREDENTIALSW;
#ifdef UNICODE
typedef RASCREDENTIALSW     RASCREDENTIALS;
typedef LPRASCREDENTIALSW   LPRASCREDENTIALS;
#else
typedef RASCREDENTIALSA     RASCREDENTIALS;
typedef LPRASCREDENTIALSA   LPRASCREDENTIALS;
#endif
#endif

/* RAS autodial entry */
#if (WINVER >= 0x0401)
typedef struct tagRASAUTODIALENTRYA {
    DWORD   dwSize;
    DWORD   dwFlags;
    DWORD   dwDialingLocation;
    CHAR    szEntry[RAS_MaxEntryName + 1];
} RASAUTODIALENTRYA;
typedef RASAUTODIALENTRYA   *LPRASAUTODIALENTRYA;
typedef struct tagRASAUTODIALENTRYW {
    DWORD   dwSize;
    DWORD   dwFlags;
    DWORD   dwDialingLocation;
    WCHAR   szEntry[RAS_MaxEntryName + 1];
} RASAUTODIALENTRYW;
typedef RASAUTODIALENTRYW   *LPRASAUTODIALENTRYW;
#ifdef UNICODE
typedef RASAUTODIALENTRYW   RASAUTODIALENTRY;
typedef LPRASAUTODIALENTRYW LPRASAUTODIALENTRY;
#else
typedef RASAUTODIALENTRYA   RASAUTODIALENTRY;
typedef LPRASAUTODIALENTRYA LPRASAUTODIALENTRY;
#endif
#endif

/* RAS EAP user identity */
#if (WINVER >= 0x0500)
typedef struct tagRASEAPUSERIDENTITYA {
    CHAR    szUserName[UNLEN + 1];
    DWORD   dwSizeofEapInfo;
    BYTE    pbEapInfo[1];
} RASEAPUSERIDENTITYA;
typedef RASEAPUSERIDENTITYA     *LPRASEAPUSERIDENTITYA;
typedef struct tagRASEAPUSERIDENTITYW {
    WCHAR   szUserName[UNLEN + 1];
    DWORD   dwSizeofEapInfo;
    BYTE    pbEapInfo[1];
} RASEAPUSERIDENTITYW;
typedef RASEAPUSERIDENTITYW     *LPRASEAPUSERIDENTITYW;
#ifdef UNICODE
typedef RASEAPUSERIDENTITYW     RASEAPUSERIDENTITY;
typedef LPRASEAPUSERIDENTITYW   LPRASEAPUSERIDENTITY;
#else
typedef RASEAPUSERIDENTITYA     RASEAPUSERIDENTITY;
typedef LPRASEAPUSERIDENTITYA   LPRASEAPUSERIDENTITY;
#endif
#endif

/* RAS buffer callbacks */
#if (WINVER >= 0x0500)
typedef DWORD (WINAPI *PFNRASGETBUFFER)( PBYTE *, PDWORD );
typedef DWORD (WINAPI *PFNRASFREEBUFFER)( PBYTE );
typedef DWORD (WINAPI *PFNRASSENDBUFFER)( HANDLE, PBYTE, DWORD );
typedef DWORD (WINAPI *PFNRASRECEIVEBUFFER)( HANDLE, PBYTE, PDWORD, DWORD, HANDLE );
typedef DWORD (WINAPI *PFNRASRETRIEVEBUFFER)( HANDLE, PBYTE, PDWORD );
#endif

/* RAS custom script execute function */
#if (WINVER >= 0x0500)
typedef DWORD (WINAPI *RasCustomScriptExecuteFn)( HANDLE, LPCWSTR, LPCWSTR, PFNRASGETBUFFER, PFNRASFREEBUFFER, PFNRASSENDBUFFER, PFNRASRECEIVEBUFFER, PFNRASRETRIEVEBUFFER, HWND, RASDIALPARAMS *, PVOID );
#endif

/* RAS communication settings */
#if (WINVER >= 0x0501)
typedef struct tagRASCOMMSETTINGS {
    DWORD   dwSize;
    BYTE    bParity;
    BYTE    bStop;
    BYTE    bByteSize;
    BYTE    bAlign;
} RASCOMMSETTINGS;
#endif

/* RAS communication settings callback */
#if (WINVER >= 0x0501)
typedef DWORD (WINAPI *PFNRASSETCOMMSETTINGS)( HANDLE, RASCOMMSETTINGS *, PVOID );
#endif

/* RAS custom script extensions */
#if (WINVER >= 0x0501)
typedef struct tagRASCUSTOMSCRIPTEXTENSIONS {
    DWORD                   dwSize;
    PFNRASSETCOMMSETTINGS   pfnRasSetCommSettings;
} RASCUSTOMSCRIPTEXTENSIONS;
#endif

/* RAS statistics */
#if (WINVER >= 0x0500)
typedef struct _RAS_STATS {
    DWORD   dwSize;
    DWORD   dwBytesXmited;
    DWORD   dwBytesRcved;
    DWORD   dwFramesXmited;
    DWORD   dwFramesRcved;
    DWORD   dwCrcErr;
    DWORD   dwTimeoutErr;
    DWORD   dwAlignmentErr;
    DWORD   dwHardwareOverrunErr;
    DWORD   dwFramingErr;
    DWORD   dwBufferOverrunErr;
    DWORD   dwCompressionRatioIn;
    DWORD   dwCompressionRatioOut;
    DWORD   dwBps;
    DWORD   dwConnectDuration;
} RAS_STATS;
typedef RAS_STATS   *PRAS_STATS;
#endif

/* RAS custom functions */
#if (WINVER >= 0x0500)
typedef DWORD (WINAPI *RasCustomHangUpFn)( HRASCONN );
typedef DWORD (WINAPI *RasCustomDialFn)( HINSTANCE, LPRASDIALEXTENSIONS, LPCWSTR, LPRASDIALPARAMS, DWORD, LPVOID, LPHRASCONN, DWORD );
typedef DWORD (WINAPI *RasCustomDeleteEntryNotifyFn)( LPCWSTR, LPCWSTR, DWORD );
#endif

/* RasUpdateConnection() parameters */
#if (WINVER >= 0x0601)
typedef struct tagRASUPDATECONN {
    RASAPIVERSION       version;
    DWORD               dwSize;
    DWORD               dwFlags;
    DWORD               dwIfIndex;
    RASTUNNELENDPOINT   localEndPoint;
    RASTUNNELENDPOINT   remoteEndPoint;
} RASUPDATECONN;
typedef RASUPDATECONN   *LPRASUPDATECONN;
#endif

/* Functions in RASAPI32.DLL */
DWORD APIENTRY  RasConnectionNotificationA( HRASCONN, HANDLE, DWORD );
DWORD APIENTRY  RasConnectionNotificationW( HRASCONN, HANDLE, DWORD );
DWORD APIENTRY  RasCreatePhonebookEntryA( HWND, LPCSTR );
DWORD APIENTRY  RasCreatePhonebookEntryW( HWND, LPCWSTR );
DWORD APIENTRY  RasDeleteEntryA( LPCSTR, LPCSTR );
DWORD APIENTRY  RasDeleteEntryW( LPCWSTR, LPCWSTR );
DWORD APIENTRY  RasDialA( LPRASDIALEXTENSIONS, LPCSTR, LPRASDIALPARAMSA, DWORD, LPVOID, LPHRASCONN );
DWORD APIENTRY  RasDialW( LPRASDIALEXTENSIONS, LPCWSTR, LPRASDIALPARAMSW, DWORD, LPVOID, LPHRASCONN );
DWORD APIENTRY  RasEditPhonebookEntryA( HWND, LPCSTR, LPCSTR );
DWORD APIENTRY  RasEditPhonebookEntryW( HWND, LPCWSTR, LPCWSTR );
DWORD APIENTRY  RasEnumConnectionsA( LPRASCONNA, LPDWORD, LPDWORD );
DWORD APIENTRY  RasEnumConnectionsW( LPRASCONNW, LPDWORD, LPDWORD );
DWORD APIENTRY  RasEnumDevicesA( LPRASDEVINFOA, LPDWORD, LPDWORD );
DWORD APIENTRY  RasEnumDevicesW( LPRASDEVINFOW, LPDWORD, LPDWORD );
DWORD APIENTRY  RasEnumEntriesA( LPCSTR, LPCSTR, LPRASENTRYNAMEA, LPDWORD, LPDWORD );
DWORD APIENTRY  RasEnumEntriesW( LPCWSTR, LPCWSTR, LPRASENTRYNAMEW, LPDWORD, LPDWORD );
DWORD APIENTRY  RasGetConnectStatusA( HRASCONN, LPRASCONNSTATUSA );
DWORD APIENTRY  RasGetConnectStatusW( HRASCONN, LPRASCONNSTATUSW );
DWORD APIENTRY  RasGetCountryInfoA( LPRASCTRYINFOA, LPDWORD );
DWORD APIENTRY  RasGetCountryInfoW( LPRASCTRYINFOW, LPDWORD );
DWORD APIENTRY  RasGetEntryDialParamsA( LPCSTR, LPRASDIALPARAMSA, LPBOOL );
DWORD APIENTRY  RasGetEntryDialParamsW( LPCWSTR, LPRASDIALPARAMSW, LPBOOL );
DWORD APIENTRY  RasGetEntryPropertiesA( LPCSTR, LPCSTR, LPRASENTRYA, LPDWORD, LPBYTE, LPDWORD );
DWORD APIENTRY  RasGetEntryPropertiesW( LPCWSTR, LPCWSTR, LPRASENTRYW, LPDWORD, LPBYTE, LPDWORD );
DWORD APIENTRY  RasGetErrorStringA( UINT, LPSTR, DWORD );
DWORD APIENTRY  RasGetErrorStringW( UINT, LPWSTR, DWORD );
DWORD APIENTRY  RasGetProjectionInfoA( HRASCONN, RASPROJECTION, LPVOID, LPDWORD );
DWORD APIENTRY  RasGetProjectionInfoW( HRASCONN, RASPROJECTION, LPVOID, LPDWORD );
DWORD APIENTRY  RasHangUpA( HRASCONN );
DWORD APIENTRY  RasHangUpW( HRASCONN );
DWORD APIENTRY  RasRenameEntryA( LPCSTR, LPCSTR, LPCSTR );
DWORD APIENTRY  RasRenameEntryW( LPCWSTR, LPCWSTR, LPCWSTR );
DWORD APIENTRY  RasSetEntryDialParamsA( LPCSTR, LPRASDIALPARAMSA, BOOL );
DWORD APIENTRY  RasSetEntryDialParamsW( LPCWSTR, LPRASDIALPARAMSW, BOOL );
DWORD APIENTRY  RasSetEntryPropertiesA( LPCSTR, LPCSTR, LPRASENTRYA, DWORD, LPBYTE, DWORD );
DWORD APIENTRY  RasSetEntryPropertiesW( LPCWSTR, LPCWSTR, LPRASENTRYW, DWORD, LPBYTE, DWORD );
DWORD APIENTRY  RasValidateEntryNameA( LPCSTR, LPCSTR );
DWORD APIENTRY  RasValidateEntryNameW( LPCWSTR, LPCWSTR );
#if (WINVER >= 0x0401)
DWORD APIENTRY  RasEnumAutodialAddressesA( LPSTR *, LPDWORD, LPDWORD );
DWORD APIENTRY  RasEnumAutodialAddressesW( LPWSTR *, LPDWORD, LPDWORD );
DWORD APIENTRY  RasGetAutodialAddressA( LPCSTR, LPDWORD, LPRASAUTODIALENTRYA, LPDWORD, LPDWORD );
DWORD APIENTRY  RasGetAutodialAddressW( LPCWSTR, LPDWORD, LPRASAUTODIALENTRYW, LPDWORD, LPDWORD );
DWORD APIENTRY  RasGetAutodialEnableA( DWORD, LPBOOL );
DWORD APIENTRY  RasGetAutodialEnableW( DWORD, LPBOOL );
DWORD APIENTRY  RasGetAutodialParamA( DWORD, LPVOID, LPDWORD );
DWORD APIENTRY  RasGetAutodialParamW( DWORD, LPVOID, LPDWORD );
DWORD APIENTRY  RasGetCredentialsA( LPCSTR, LPCSTR, LPRASCREDENTIALSA );
DWORD APIENTRY  RasGetCredentialsW( LPCWSTR, LPCWSTR, LPRASCREDENTIALSW );
DWORD APIENTRY  RasGetSubEntryHandleA( HRASCONN, DWORD, LPHRASCONN );
DWORD APIENTRY  RasGetSubEntryHandleW( HRASCONN, DWORD, LPHRASCONN );
DWORD APIENTRY  RasGetSubEntryPropertiesA( LPCSTR, LPCSTR, DWORD, LPRASSUBENTRYA, LPDWORD, LPBYTE, LPDWORD );
DWORD APIENTRY  RasGetSubEntryPropertiesW( LPCWSTR, LPCWSTR, DWORD, LPRASSUBENTRYW, LPDWORD, LPBYTE, LPDWORD );
DWORD APIENTRY  RasSetAutodialAddressA( LPCSTR, DWORD, LPRASAUTODIALENTRYA, DWORD, DWORD );
DWORD APIENTRY  RasSetAutodialAddressW( LPCWSTR, DWORD, LPRASAUTODIALENTRYW, DWORD, DWORD );
DWORD APIENTRY  RasSetAutodialEnableA( DWORD, BOOL );
DWORD APIENTRY  RasSetAutodialEnableW( DWORD, BOOL );
DWORD APIENTRY  RasSetAutodialParamA( DWORD, LPVOID, DWORD );
DWORD APIENTRY  RasSetAutodialParamW( DWORD, LPVOID, DWORD );
DWORD APIENTRY  RasSetCredentialsA( LPCSTR, LPCSTR, LPRASCREDENTIALSA, BOOL );
DWORD APIENTRY  RasSetCredentialsW( LPCWSTR, LPCWSTR, LPRASCREDENTIALSW, BOOL );
DWORD APIENTRY  RasSetSubEntryPropertiesA( LPCSTR, LPCSTR, DWORD, LPRASSUBENTRYA, DWORD, LPBYTE, DWORD );
DWORD APIENTRY  RasSetSubEntryPropertiesW( LPCWSTR, LPCWSTR, DWORD, LPRASSUBENTRYW, DWORD, LPBYTE, DWORD );
#endif
#if (WINVER >= 0x0500)
DWORD APIENTRY  RasClearConnectionStatistics( HRASCONN );
DWORD APIENTRY  RasClearLinkStatistics( HRASCONN, DWORD );
VOID APIENTRY   RasFreeEapUserIdentityA( LPRASEAPUSERIDENTITYA );
VOID APIENTRY   RasFreeEapUserIdentityW( LPRASEAPUSERIDENTITYW );
DWORD APIENTRY  RasGetConnectionStatistics( HRASCONN, RAS_STATS * );
DWORD APIENTRY  RasGetCustomAuthDataA( LPCSTR, LPCSTR, BYTE *, DWORD * );
DWORD APIENTRY  RasGetCustomAuthDataW( LPCWSTR, LPCWSTR, BYTE *, DWORD * );
DWORD APIENTRY  RasGetEapUserDataA( HANDLE, LPCSTR, LPCSTR, BYTE *, DWORD * );
DWORD APIENTRY  RasGetEapUserDataW( HANDLE, LPCWSTR, LPCWSTR, BYTE *, DWORD * );
DWORD APIENTRY  RasGetEapUserIdentityA( LPCSTR, LPCSTR, DWORD, HWND, LPRASEAPUSERIDENTITYA * );
DWORD APIENTRY  RasGetEapUserIdentityW( LPCWSTR, LPCWSTR, DWORD, HWND, LPRASEAPUSERIDENTITYW * );
DWORD APIENTRY  RasGetLinkStatistics( HRASCONN, DWORD, RAS_STATS * );
DWORD APIENTRY  RasInvokeEapUI( HRASCONN, DWORD, LPRASDIALEXTENSIONS, HWND );
DWORD APIENTRY  RasSetCustomAuthDataA( LPCSTR, LPCSTR, BYTE *, DWORD );
DWORD APIENTRY  RasSetCustomAuthDataW( LPCWSTR, LPCWSTR, BYTE *, DWORD );
DWORD APIENTRY  RasSetEapUserDataA( HANDLE, LPCSTR, LPCSTR, BYTE *, DWORD );
DWORD APIENTRY  RasSetEapUserDataW( HANDLE, LPCWSTR, LPCWSTR, BYTE *, DWORD );
#endif
#if (WINVER >= 0x0501)
DWORD APIENTRY  RasDeleteSubEntryA( LPCSTR, LPCSTR, DWORD );
DWORD APIENTRY  RasDeleteSubEntryW( LPCWSTR, LPCWSTR, DWORD );
#ifdef USES_RAS_QUARANTINE_APIS
DWORD APIENTRY  RasGetNapStatus( HRASCONN, LPRASNAPSTATE );
#endif
#endif
#if (WINVER >= 0x0601)
DWORD APIENTRY  RasGetProjectionInfoEx( HRASCONN, PRAS_PROJECTION_INFO, LPDWORD );
DWORD APIENTRY  RasUpdateConnection( HRASCONN, LPRASUPDATECONN );
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define RasConnectionNotification       RasConnectionNotificationW
    #define RasCreatePhonebookEntry         RasCreatePhonebookEntryW
    #define RasDeleteEntry                  RasDeleteEntryW
    #define RasDial                         RasDialW
    #define RasEditPhonebookEntry           RasEditPhonebookEntryW
    #define RasEnumConnections              RasEnumConnectionsW
    #define RasEnumDevices                  RasEnumDevicesW
    #define RasEnumEntries                  RasEnumEntriesW
    #define RasGetConnectStatus             RasGetConnectStatusW
    #define RasGetCountryInfo               RasGetCountryInfoW
    #define RasGetEntryDialParams           RasGetEntryDialParamsW
    #define RasGetEntryProperties           RasGetEntryPropertiesW
    #define RasGetErrorString               RasGetErrorStringW
    #define RasGetProjectionInfo            RasGetProjectionInfoW
    #define RasHangUp                       RasHangUpW
    #define RasRenameEntry                  RasRenameEntryW
    #define RasSetEntryDialParams           RasSetEntryDialParamsW
    #define RasSetEntryProperties           RasSetEntryPropertiesW
    #define RasValidateEntryName            RasValidateEntryNameW
    #if (WINVER >= 0x0401)
        #define RasEnumAutodialAddresses    RasEnumAutodialAddressesW
        #define RasGetAutodialAddress       RasGetAutodialAddressW
        #define RasGetAutodialEnable        RasGetAutodialEnableW
        #define RasGetAutodialParam         RasGetAutodialParamW
        #define RasGetCredentials           RasGetCredentialsW
        #define RasGetSubEntryHandle        RasGetSubEntryHandleW
        #define RasGetSubEntryProperties    RasGetSubEntryPropertiesW
        #define RasSetAutodialAddress       RasSetAutodialAddressW
        #define RasSetAutodialEnable        RasSetAutodialEnableW
        #define RasSetAutodialParam         RasSetAutodialParamW
        #define RasSetCredentials           RasSetCredentialsW
        #define RasSetSubEntryProperties    RasSetSubEntryPropertiesW
    #endif
    #if (WINVER >= 0x0500)
        #define RasFreeEapUserIdentity      RasFreeEapUserIdentityW
        #define RasGetCustomAuthData        RasGetCustomAuthDataW
        #define RasGetEapUserData           RasGetEapUserDataW
        #define RasGetEapUserIdentity       RasGetEapUserIdentityW
        #define RasSetCustomAuthData        RasSetCustomAuthDataW
        #define RasSetEapUserData           RasSetEapUserDataW
    #endif
    #if (WINVER >= 0x0501)
        #define RasDeleteSubEntry           RasDeleteSubEntryW
    #endif
#else
    #define RasConnectionNotification       RasConnectionNotificationA
    #define RasCreatePhonebookEntry         RasCreatePhonebookEntryA
    #define RasDeleteEntry                  RasDeleteEntryA
    #define RasDial                         RasDialA
    #define RasEditPhonebookEntry           RasEditPhonebookEntryA
    #define RasEnumConnections              RasEnumConnectionsA
    #define RasEnumDevices                  RasEnumDevicesA
    #define RasEnumEntries                  RasEnumEntriesA
    #define RasGetConnectStatus             RasGetConnectStatusA
    #define RasGetCountryInfo               RasGetCountryInfoA
    #define RasGetEntryDialParams           RasGetEntryDialParamsA
    #define RasGetEntryProperties           RasGetEntryPropertiesA
    #define RasGetErrorString               RasGetErrorStringA
    #define RasGetProjectionInfo            RasGetProjectionInfoA
    #define RasHangUp                       RasHangUpA
    #define RasRenameEntry                  RasRenameEntryA
    #define RasSetEntryDialParams           RasSetEntryDialParamsA
    #define RasSetEntryProperties           RasSetEntryPropertiesA
    #define RasValidateEntryName            RasValidateEntryNameA
    #if (WINVER >= 0x0401)
        #define RasEnumAutodialAddresses    RasEnumAutodialAddressesA
        #define RasGetAutodialAddress       RasGetAutodialAddressA
        #define RasGetAutodialEnable        RasGetAutodialEnableA
        #define RasGetAutodialParam         RasGetAutodialParamA
        #define RasGetCredentials           RasGetCredentialsA
        #define RasGetSubEntryHandle        RasGetSubEntryHandleA
        #define RasGetSubEntryProperties    RasGetSubEntryPropertiesA
        #define RasSetAutodialAddress       RasSetAutodialAddressA
        #define RasSetAutodialEnable        RasSetAutodialEnableA
        #define RasSetAutodialParam         RasSetAutodialParamA
        #define RasSetCredentials           RasSetCredentialsA
        #define RasSetSubEntryProperties    RasSetSubEntryPropertiesA
    #endif
    #if (WINVER >= 0x0500)
        #define RasFreeEapUserIdentity      RasFreeEapUserIdentityA
        #define RasGetCustomAuthData        RasGetCustomAuthDataA
        #define RasGetEapUserData           RasGetEapUserDataA
        #define RasGetEapUserIdentity       RasGetEapUserIdentityA
        #define RasSetCustomAuthData        RasSetCustomAuthDataA
        #define RasSetEapUserData           RasSetEapUserDataA
    #endif
    #if (WINVER >= 0x0501)
        #define RasDeleteSubEntry           RasDeleteSubEntryA
    #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _RAS_H_ */
