/*
 *  tcpmib.h    TCP Management Information Base (MIB) definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _TCPMIB_
#define _TCPMIB_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Value used to declare an array of an unknown size */
#ifndef ANY_SIZE
    #define ANY_SIZE    1
#endif

/* TCP/IP owning module size */
#ifndef TCPIP_OWNING_MODULE_SIZE
    #define TCPIP_OWNING_MODULE_SIZE    16
#endif

/* MIB TCP maximum connection dynamic */
#define MIB_TCP_MAXCONN_DYNAMIC 0xFFFFFFFFL

/* MIB TCP states */
typedef enum {
    MIB_TCP_STATE_CLOSED        = 1,
    MIB_TCP_STATE_LISTEN        = 2,
    MIB_TCP_STATE_SYN_SENT      = 3,
    MIB_TCP_STATE_SYN_RCVD      = 4,
    MIB_TCP_STATE_ESTAB         = 5,
    MIB_TCP_STATE_FIN_WAIT1     = 6,
    MIB_TCP_STATE_FIN_WAIT2     = 7,
    MIB_TCP_STATE_CLOSE_WAIT    = 8,
    MIB_TCP_STATE_CLOSING       = 9,
    MIB_TCP_STATE_LAST_ACK      = 10,
    MIB_TCP_STATE_TIME_WAIT     = 11,
    MIB_TCP_STATE_DELETE_TCB    = 12
} MIB_TCP_STATE;

/* TCP connection offload states */
typedef enum {
    TcpConnectionOffloadStateInHost     = 0,
    TcpConnectionOffloadStateOffloading = 1,
    TcpConnectionOffloadStateOffloaded  = 2,
    TcpConnectionOffloadStateUploading  = 3,
    TcpConnectionOffloadStateMax        = 4
} TCP_CONNECTION_OFFLOAD_STATE;
typedef TCP_CONNECTION_OFFLOAD_STATE    *PTCP_CONNECTION_OFFLOAD_STATE;

/* MIB TCP row */
typedef struct _MIB_TCPROW_LH {
    union {
        DWORD           dwState;
        MIB_TCP_STATE   State;
    };
    DWORD   dwLocalAddr;
    DWORD   dwLocalPort;
    DWORD   dwRemoteAddr;
    DWORD   dwRemotePort;
} MIB_TCPROW_LH;
typedef MIB_TCPROW_LH   *PMIB_TCPROW_LH;
typedef struct _MIB_TCPROW_W2K {
    DWORD   dwState;
    DWORD   dwLocalAddr;
    DWORD   dwLocalPort;
    DWORD   dwRemoteAddr;
    DWORD   dwRemotePort;
} MIB_TCPROW_W2K;
typedef MIB_TCPROW_W2K  *PMIB_TCPROW_W2K;
#if (NTDDI_VERSION >= 0x06000000)
typedef MIB_TCPROW_LH   MIB_TCPROW;
typedef MIB_TCPROW_LH   *PMIB_TCPROW;
#elif (NTDDI_VERSION >= 0x05000000)
typedef MIB_TCPROW_W2K  MIB_TCPROW;
typedef MIB_TCPROW_W2K  *PMIB_TCPROW;
#else
typedef MIB_TCPROW_LH   MIB_TCPROW;
typedef MIB_TCPROW_LH   *PMIB_TCPROW;
#endif

/* MIB TCP table */
typedef struct _MIB_TCPTABLE {
    DWORD       dwNumEntries;
    MIB_TCPROW  table[ANY_SIZE];
} MIB_TCPTABLE;
typedef MIB_TCPTABLE    *PMIB_TCPTABLE;

/* MIB TCP row (version 2) */
typedef struct _MIB_TCPROW2 {
    DWORD                           dwState;
    DWORD                           dwLocalAddr;
    DWORD                           dwLocalPort;
    DWORD                           dwRemoteAddr;
    DWORD                           dwRemotePort;
    DWORD                           dwOwningPid;
    TCP_CONNECTION_OFFLOAD_STATE    dwOffloadState;
} MIB_TCPROW2;
typedef MIB_TCPROW2 *PMIB_TCPROW2;

/* MIB TCP table (version 2) */
typedef struct _MIB_TCPTABLE2 {
    DWORD       dwNumEntries;
    MIB_TCPROW2 table[ANY_SIZE];
} MIB_TCPTABLE2;
typedef MIB_TCPTABLE2   *PMIB_TCPTABLE2;

/* MIB TCP row owner protocol identifier */
typedef struct _MIB_TCPROW_OWNER_PID {
    DWORD   dwState;
    DWORD   dwLocalAddr;
    DWORD   dwLocalPort;
    DWORD   dwRemoteAddr;
    DWORD   dwRemotePort;
    DWORD   dwOwningPid;
} MIB_TCPROW_OWNER_PID;
typedef MIB_TCPROW_OWNER_PID    *PMIB_TCPROW_OWNER_PID;

/* MIB TCP table owner protocol identifier */
typedef struct _MIB_TCPTABLE_OWNER_PID {
    DWORD                   dwNumEntries;
    MIB_TCPROW_OWNER_PID    table[ANY_SIZE];
} MIB_TCPTABLE_OWNER_PID;
typedef MIB_TCPTABLE_OWNER_PID  *PMIB_TCPTABLE_OWNER_PID;

/* MIB TCP row owner module */
typedef struct _MIB_TCPROW_OWNER_MODULE {
    DWORD           dwState;
    DWORD           dwLocalAddr;
    DWORD           dwLocalPort;
    DWORD           dwRemoteAddr;
    DWORD           dwRemotePort;
    DWORD           dwOwningPort;
    LARGE_INTEGER   liCreateTimestamp;
    ULONGLONG       OwningModuleInfo[TCPIP_OWNING_MODULE_SIZE];
} MIB_TCPROW_OWNER_MODULE;
typedef MIB_TCPROW_OWNER_MODULE *PMIB_TCPROW_OWNER_MODULE;

/* MIB TCP table owner module */
typedef struct _MIB_TCPTABLE_OWNER_MODULE {
    DWORD                   dwNumEntries;
    MIB_TCPROW_OWNER_MODULE table[ANY_SIZE];
} MIB_TCPTABLE_OWNER_MODULE;
typedef MIB_TCPTABLE_OWNER_MODULE   *PMIB_TCPTABLE_OWNER_MODULE;

/* MIB TCPv6 row */
#ifdef _WINSOCK2API_
typedef struct _MIB_TCP6ROW {
    MIB_TCP_STATE   State;
    IN6_ADDR        LocalAddr;
    DWORD           dwLocalScopeId;
    DWORD           dwLocalPort;
    IN6_ADDR        RemoteAddr;
    DWORD           dwRemoteScopeId;
    DWORD           dwRemotePort;
} MIB_TCP6ROW;
typedef MIB_TCP6ROW *PMIB_TCP6ROW;
#endif

/* MIB TCPv6 table */
#ifdef _WINSOCK2API_
typedef struct _MIB_TCP6TABLE {
    DWORD       dwNumEntries;
    MIB_TCP6ROW table[ANY_SIZE];
} MIB_TCP6TABLE;
typedef MIB_TCP6TABLE   *PMIB_TCP6TABLE;
#endif

/* MIB TCPv6 row (version 2) */
#ifdef _WINSOCK2API_
typedef struct _MIB_TCP6ROW2 {
    IN6_ADDR                        LocalAddr;
    DWORD                           dwLocalScopeId;
    DWORD                           dwLocalPort;
    IN6_ADDR                        RemoteAddr;
    DWORD                           dwRemoteScopeId;
    DWORD                           dwRemotePort;
    MIB_TCP_STATE                   State;
    DWORD                           dwOwningPid;
    TCP_CONNECTION_OFFLOAD_STATE    dwOffloadState;
} MIB_TCP6ROW2;
typedef MIB_TCP6ROW2    *PMIB_TCP6ROW2;
#endif

/* MIB TCPv6 table (version 2) */
#ifdef _WINSOCK2API_
typedef struct _MIB_TCP6TABLE2 {
    DWORD           dwNumEntries;
    MIB_TCP6ROW2    table[ANY_SIZE];
} MIB_TCP6TABLE2;
typedef MIB_TCP6TABLE2  *PMIB_TCP6TABLE2;
#endif

/* MIB TCPv6 row owner protocol identifier */
#ifdef _WINSOCK2API_
typedef struct _MIB_TCP6ROW_OWNER_PID {
    UCHAR   ucLocalAddr[16];
    DWORD   dwLocalScopeId;
    DWORD   dwLocalPort;
    UCHAR   ucRemoteAddr[16];
    DWORD   dwRemoteScopeId;
    DWORD   dwRemotePort;
    DWORD   dwState;
    DWORD   dwOwningPid;
} MIB_TCP6ROW_OWNER_PID;
typedef MIB_TCP6ROW_OWNER_PID   *PMIB_TCP6ROW_OWNER_PID;
#endif

/* MIB TCPv6 table owner protocol identifier */
#ifdef _WINSOCK2API_
typedef struct _MIB_TCP6TABLE_OWNER_PID {
    DWORD                   dwNumEntries;
    MIB_TCP6ROW_OWNER_PID   table[ANY_SIZE];
} MIB_TCP6TABLE_OWNER_PID;
typedef MIB_TCP6TABLE_OWNER_PID *PMIB_TCP6TABLE_OWNER_PID;
#endif

/* MIB TCPv6 row owner module */
#ifdef _WINSOCK2API_
typedef struct _MIB_TCP6ROW_OWNER_MODULE {
    UCHAR           ucLocalAddr[16];
    DWORD           dwLocalScopeId;
    DWORD           dwLocalPort;
    UCHAR           ucRemoteAddr[16];
    DWORD           dwRemoteScopeId;
    DWORD           dwRemotePort;
    DWORD           dwState;
    DWORD           dwOwningPid;
    LARGE_INTEGER   liCreateTimestamp;
    ULONGLONG       OwningModuleInfo[TCPIP_OWNING_MODULE_SIZE];
} MIB_TCP6ROW_OWNER_MODULE;
typedef MIB_TCP6ROW_OWNER_MODULE    *PMIB_TCP6ROW_OWNER_MODULE;
#endif

/* MIB TCPv6 table owner module */
#ifdef _WINSOCK2API_
typedef struct _MIB_TCP6TABLE_OWNER_MODULE {
    DWORD                       dwNumEntries;
    MIB_TCP6ROW_OWNER_MODULE    table[ANY_SIZE];
} MIB_TCP6TABLE_OWNER_MODULE;
typedef MIB_TCP6TABLE_OWNER_MODULE  *PMIB_TCP6TABLE_OWNER_MODULE;
#endif

/* TCP RTO algorithms */
typedef enum {
    TcpRtoAlgorithmOther    = 0,
    TcpRtoAlgorithmConstant = 1,
    TcpRtoAlgorithmRsre     = 2,
    TcpRtoAlgorithmVanj     = 3
} TCP_RTO_ALGORITHM;
typedef TCP_RTO_ALGORITHM   *PTCP_RTO_ALGORITHM;

/* MIB TCP statistics */
typedef struct _MIB_TCPSTATS_LH {
    union {
        DWORD               dwRtoAlgorithm;
        TCP_RTO_ALGORITHM   RtoAlgorithm;
    };
    DWORD   dwRtoMin;
    DWORD   dwRtoMax;
    DWORD   dwMaxConn;
    DWORD   dwActiveOpens;
    DWORD   dwPassiveOpens;
    DWORD   dwAttemptFails;
    DWORD   dwEstabResets;
    DWORD   dwCurrEstab;
    DWORD   dwInSegs;
    DWORD   dwOutSegs;
    DWORD   dwRetransSegs;
    DWORD   dwInErrs;
    DWORD   dwOutRsts;
    DWORD   dwNumConns;
} MIB_TCPSTATS_LH;
typedef MIB_TCPSTATS_LH *PMIB_TCPSTATS_LH;
typedef struct _MIB_TCPSTATS_W2K {
    DWORD   dwRtoAlgorithm;
    DWORD   dwRtoMin;
    DWORD   dwRtoMax;
    DWORD   dwMaxConn;
    DWORD   dwActiveOpens;
    DWORD   dwPassiveOpens;
    DWORD   dwAttemptFails;
    DWORD   dwEstabResets;
    DWORD   dwCurrEstab;
    DWORD   dwInSegs;
    DWORD   dwOutSegs;
    DWORD   dwRetransSegs;
    DWORD   dwInErrs;
    DWORD   dwOutRsts;
    DWORD   dwNumConns;
} MIB_TCPSTATS_W2K;
typedef MIB_TCPSTATS_W2K    *PMIB_TCPSTATS_W2K;
#if (NTDDI_VERSION >= 0x06000000)
typedef MIB_TCPSTATS_LH     MIB_TCPSTATS;
typedef MIB_TCPSTATS_LH     *PMIB_TCPSTATS;
#elif (NTDDI_VERSION >= 0x05000000)
typedef MIB_TCPSTATS_W2K    MIB_TCPSTATS;
typedef MIB_TCPSTATS_W2K    *PMIB_TCPSTATS;
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _TCPMIB_ */
