/***************************************************************************
 * FILE: signal.h/csignal (Signal definitions)
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 *    Copyright (c) 2002-2010 Open Watcom Contributors. All Rights Reserved.
 *    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 *
 * Description: This header is part of the C/C++ standard library. It
 *              declares facilities for handling signals in programs.
 ***************************************************************************/
#ifndef _SIGNAL_H_INCLUDED
#define _SIGNAL_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus

#include <csignal>

// C99 types in signal.h.
using std::sig_atomic_t;

// C99 functions in signal.h.
using std::signal;
using std::raise;

#else /* __cplusplus not defined */

#ifndef _COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifndef __TYPES_H_INCLUDED
 #include <sys/types.h>
#endif

typedef int sig_atomic_t;

typedef void (*__sig_func)( int );
typedef __sig_func __sighandler_t;

#ifndef _ARCH_DIR
 #if defined(__386__)
  #define _ARCH_DIR i386
 #elif defined(__MIPS__)
  #define _ARCH_DIR mips
 #else
  #error unknown platform
  #define _ARCH_DIR
 #endif
 #define _ARCH_INCLUDE(hdr) <arch/ ## _ARCH_DIR ## / ## hdr ## >
#endif /* !_ARCH_DIR */
#include _ARCH_INCLUDE(signal.h)

#if defined(_POSIX_SOURCE) || !defined(NO_EXT_KEYS) /* extensions enabled */

#pragma pack( __push, 8 )

#include _ARCH_INCLUDE(sigposix.h)

#pragma pack( __pop )

#endif /* extensions enabled */

#define _SIGMIN     1

_WCRTLINK extern int  raise( int __sig );
_WCRTLINK extern void (*signal( int __sig, void (*__func)(int) ) )(int);

#if defined(_POSIX_SOURCE) || defined(_LINUX_SOURCE) || !defined(NO_EXT_KEYS) /* extensions enabled */
_WCRTLINK extern int  kill( pid_t __pid, int __signum );
_WCRTLINK extern int  sigaction( int __signo, const struct sigaction *__act, struct sigaction *__oact );
_WCRTLINK extern int  sigaddset( sigset_t *__set, int __signo );
_WCRTLINK extern int  sigdelset( sigset_t *__set, int __signo );
_WCRTLINK extern int  sigemptyset( sigset_t *__set );
_WCRTLINK extern int  sigfillset( sigset_t *__set );
_WCRTLINK extern int  sigismember( const sigset_t *__set, int __signo );
_WCRTLINK extern int  sigpending( sigset_t *__set );
_WCRTLINK extern int  sigprocmask( int __how, const sigset_t *__set, sigset_t *__oset );
_WCRTLINK extern int  sigsuspend( const sigset_t *sigmask );
#endif /* extensions enabled */

#endif /* __cplusplus not defined */

#endif
