/*
 *  ntsecpkg.h  NT Local Security Authority (LSA) package functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _NTSECPKG_
#define _NTSECPKG_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* LSA client request data type */
typedef PVOID   *PLSA_CLIENT_REQUEST;

/* Aliases of Win32 types */
#ifdef _NTDEF_
typedef PVOID                   SEC_THREAD_START;
typedef PVOID                   SEC_ATTRS;
#else
typedef LPTHREAD_START_ROUTINE  SEC_THREAD_START;
typedef LPSECURITY_ATTRIBUTES   SEC_ATTRS;
#endif

/* LSA security handle data type */
typedef ULONG_PTR       LSA_SEC_HANDLE;
typedef LSA_SEC_HANDLE  *PLSA_SEC_HANDLE;

/* LSA authentication package routine names */
#define LSA_AP_NAME_INITIALIZE_PACKAGE          "LsaApInitializePackage\0"
#define LSA_AP_NAME_LOGON_USER                  "LsaApLogonUser\0"
#define LSA_AP_NAME_LOGON_USER_EX               "LsaApLogonUserEx\0"
#define LSA_AP_NAME_CALL_PACKAGE                "LsaApCallPackage\0"
#define LSA_AP_NAME_LOGON_TERMINATED            "LsaApLogonTerminated\0"
#define LSA_AP_NAME_CALL_PACKAGE_UNTRUSTED      "LsaApCallPackageUntrusted\0"
#define LSA_AP_NAME_CALL_PACKAGE_PASSTHROUGH    "LsaApCallPackagePassthrough\0"
#define LSA_AP_NAME_LOGON_USER_EX2              "LsaApLogonUserEx2\0"

/* SAM routine names */
#define SAM_CREDENTIAL_UPDATE_NOTIFY_ROUTINE    "CredentialUpdateNotify"
#define SAM_CREDENTIAL_UPDATE_REGISTER_ROUTINE  "CredentialUpdateRegister"
#define SAM_CREDENTIAL_UPDATE_FREE_ROUTINE      "CredentialUpdateFree"
#define SAM_CREDENTIAL_UPDATE_REGISTER_MAPPED_ENTRYPOINTS_ROUTINE \
    "RegisterMappedEntrypoints"

/* Security package client flags */
#define SECPKG_CLIENT_PROCESS_TERMINATED    0x01
#define SECPKG_CLIENT_THREAD_TERMINATED     0x02

/* Security package call attributes */
#define SECPKG_CALL_KERNEL_MODE     0x00000001L
#define SECPKG_CALL_ANSI            0x00000002L
#define SECPKG_CALL_URGENT          0x00000004L
#define SECPKG_CALL_RECURSIVE       0x00000008L
#define SECPKG_CALL_IN_PROC         0x00000010L
#define SECPKG_CALL_CLEANUP         0x00000020L
#define SECPKG_CALL_WOWCLIENT       0x00000040L
#define SECPKG_CALL_THREAD_TERM     0x00000080L
#define SECPKG_CALL_PROCESS_TERM    0x00000100L
#define SECPKG_CALL_IS_TCB          0x00000200L
#define SECPKG_CALL_NETWORK_ONLY    0x00000400L
#define SECPKG_CALL_WINLOGON        0x00000800L
#define SECPKG_CALL_ASYNC_UPDATE    0x00001000L
#define SECPKG_CALL_SYSTEM_PROC     0x00002000L
#define SECPKG_CALL_NEGO            0x00004000L
#define SECPKG_CALL_NEGO_EXTENDER   0x00008000L
#define SECPKG_CALL_BUFFER_MARSHAL  0x00010000L

/* Security package credential version number */
#define SECPKG_CREDENTIAL_VERSION   201

/* Security package credential flags */
#define SECPKG_CREDENTIAL_FLAGS_CALLER_HAS_TCB  0x00000001L

/* Security buffer flags */
#define SECBUFFER_UNMAPPED      0x40000000L
#define SECBUFFER_KERNEL_MAP    0x20000000L

/* Primary credential flags */
#define PRIMARY_CRED_CLEAR_PASSWORD                 0x00000001L
#define PRIMARY_CRED_OWF_PASSWORD                   0x00000002L
#define PRIMARY_CRED_UPDATE                         0x00000004L
#define PRIMARY_CRED_CACHED_LOGON                   0x00000008L
#define PRIMARY_CRED_LOGON_NO_TCB                   0x00000010L
#define PRIMARY_CRED_LOGON_LUA                      0x00000020L
#define PRIMARY_CRED_INTERACTIVE_SMARTCARD_LOGON    0x00000040L
#define PRIMARY_CRED_REFRESH_NEEDED                 0x00000080L
#define PRIMARY_CRED_LOGON_PACKAGE_SHIFT            24
#define PRIMARY_CRED_PACKAGE_MASK                   0xFF000000L

/* Maximum credential size */
#define MAX_CRED_SIZE   1024

/* Security package machine state flags */
#define SECPKG_STATE_ENCRYPTION_PERMITTED           0x00000001L
#define SECPKG_STATE_STRONG_ENCRYPTION_PERMITTED    0x00000002L
#define SECPKG_STATE_DOMAIN_CONTROLLER              0x00000004L
#define SECPKG_STATE_WORKSTATION                    0x00000008L
#define SECPKG_STATE_STANDALONE                     0x00000010L

/* Security package maximum object identifier length */
#define SECPKG_MAX_OID_LENGTH   32

/* Security pakcage attributes */
#define SECPKG_ATTR_SASL_CONTEXT    0x00010000L
#define SECPKG_ATTR_THUNK_ALL       0x00010000L

/* Long names values */
#define UNDERSTANDS_LONG_NAMES  1L
#define NO_LONG_NAMES           2L

/* Notifier flags */
#define NOTIFIER_FLAG_NEW_THREAD    0x00000001L
#define NOTIFIER_FLAG_ONE_SHOT      0x00000002L
#define NOTIFIER_FLAG_SECONDS       0x80000000L

/* Notifier types */
#define NOTIFIER_TYPE_INTERVAL      1L
#define NOTIFIER_TYPE_HANDLE_WAIT   2L
#define NOTIFIER_TYPE_STATE_CHANGE  3L
#define NOTIFIER_TYPE_NOTIFY_EVENT  4L
#define NOTIFIER_TYPE_IMMEDIATE     16L

/* Notify classes */
#define NOTIFY_CLASS_PACKAGE_CHANGE     1L
#define NOTIFY_CLASS_ROLE_CHANGE        2L
#define NOTIFY_CLASS_DOMAIN_CHANGE      3L
#define NOTIFY_CLASS_REGISTRY_CHANGE    4L

/* Security package change types */
#define SECPKG_PACKAGE_CHANGE_LOAD      0L
#define SECPKG_PACKAGE_CHANGE_UNLOAD    1L
#define SECPKG_PACKAGE_CHANGE_SELECT    2L

/* Credential flags */
#ifdef _WINCRED_H_
    #define CREDP_FLAGS_IN_PROCESS              0x00000001L
    #define CREDP_FLAGS_USE_MIDL_HEAP           0x00000002L
    #define CREDP_FLAGS_DONT_CACHE_TI           0x00000004L
    #define CREDP_FLAGS_CLEAR_PASSWORD          0x00000008L
    #define CREDP_FLAGS_USER_ENCRYPTED_PASSWORD 0x00000010L
    #define CREDP_FLAGS_TRUSTED_CALLER          0x00000020L
#endif

/* Credential marshaled TI size */
#ifdef _WINCRED_H_
    #define CRED_MARSHALED_TI_SIZE_SIZE 12
#endif

/* Security package routine names */
#define SP_ACCEPT_CREDENTIALS_NAME  "SpAcceptCredentials\0"

/* Security package initialization routine names */
#define SECPKG_LSAMODEINIT_NAME     "SpLsaModeInitialize"
#define SECPKG_USERMODEINIT_NAME    "SpUserModeInitialize"

/* Security package interface versions */
#define SECPKG_INTERFACE_VERSION    0x00010000L
#define SECPKG_INTERFACE_VERSION_2  0x00020000L
#define SECPKG_INTERFACE_VERSION_3  0x00040000L
#define SECPKG_INTERFACE_VERSION_4  0x00080000L
#define SECPKG_INTERFACE_VERSION_5  0x00100000L
#define SECPKG_INTERFACE_VERSION_6  0x00200000L

/* LSA token information type */
typedef enum _LSA_TOKEN_INFORMATION_TYPE {
    LsaTokenInformationNull = 0,
    LsaTokenInformationV1   = 1,
    LsaTokenInformationV2   = 2
} LSA_TOKEN_INFORMATION_TYPE;
typedef LSA_TOKEN_INFORMATION_TYPE  *PLSA_TOKEN_INFORMATION_TYPE;

/* LSA null token information */
typedef struct _LSA_TOKEN_INFORMATION_NULL {
    LARGE_INTEGER   ExpirationTime;
    PTOKEN_GROUPS   Groups;
} LSA_TOKEN_INFORMATION_NULL;
typedef LSA_TOKEN_INFORMATION_NULL  *PLSA_TOKEN_INFORMATION_NULL;

/* LSA V1 token information */
typedef struct _LSA_TOKEN_INFORMATION_V1 {
    LARGE_INTEGER       ExpriationTime;
    TOKEN_USER          User;
    PTOKEN_GROUPS       Groups;
    TOKEN_PRIMARY_GROUP PrimaryGroup;
    PTOKEN_PRIVILEGES   Privileges;
    TOKEN_OWNER         Owner;
    TOKEN_DEFAULT_DACL  DefaultDacl;
} LSA_TOKEN_INFORMATION_V1;
typedef LSA_TOKEN_INFORMATION_V1    *PLSA_TOKEN_INFORMATION_V1;
typedef LSA_TOKEN_INFORMATION_V1    LSA_TOKEN_INFORMATION_V2;
typedef LSA_TOKEN_INFORMATION_V1    *PLSA_TOKEN_INFORMATION_V2;

/* Authentication package callbacks */
typedef NTSTATUS (NTAPI LSA_CREATE_LOGON_SESSION)( PLUID );
typedef NTSTATUS (NTAPI LSA_DELETE_LOGON_SESSION)( PLUID );
typedef NTSTATUS (NTAPI LSA_ADD_CREDENTIAL)( PLUID, ULONG, PLSA_STRING, PLSA_STRING );
typedef NTSTATUS (NTAPI LSA_GET_CREDENTIALS)( PLUID, ULONG, PULONG, BOOLEAN, PLSA_STRING, PULONG, PLSA_STRING );
typedef NTSTATUS (NTAPI LSA_DELETE_CREDENTIAL)( PLUID, ULONG, PLSA_STRING );
typedef PVOID (NTAPI LSA_ALLOCATE_LSA_HEAP)( ULONG );
typedef VOID (NTAPI LSA_FREE_LSA_HEAP)( PVOID );
typedef PVOID (NTAPI LSA_ALLOCATE_PRIVATE_HEAP)( SIZE_T );
typedef VOID (NTAPI LSA_FREE_PRIVATE_HEAP)( PVOID );
typedef NTSTATUS (NTAPI LSA_ALLOCATE_CLIENT_BUFFER)( PLSA_CLIENT_REQUEST, ULONG, PVOID * );
typedef NTSTATUS (NTAPI LSA_FREE_CLIENT_BUFFER)( PLSA_CLIENT_REQUEST, PVOID );
typedef NTSTATUS (NTAPI LSA_COPY_TO_CLIENT_BUFFER)( PLSA_CLIENT_REQUEST, ULONG, PVOID, PVOID );
typedef NTSTATUS (NTAPI LSA_COPY_FROM_CLIENT_BUFFER)( PLSA_CLIENT_REQUEST, ULONG, PVOID, PVOID );
typedef LSA_CREATE_LOGON_SESSION    *PLSA_CREATE_LOGON_SESSION;
typedef LSA_DELETE_LOGON_SESSION    *PLSA_DELETE_LOGON_SESSION;
typedef LSA_ADD_CREDENTIAL          *PLSA_ADD_CREDENTIAL;
typedef LSA_GET_CREDENTIALS         *PLSA_GET_CREDENTIALS;
typedef LSA_DELETE_CREDENTIAL       *PLSA_DELETE_CREDENTIAL;
typedef LSA_ALLOCATE_LSA_HEAP       *PLSA_ALLOCATE_LSA_HEAP;
typedef LSA_FREE_LSA_HEAP           *PLSA_FREE_LSA_HEAP;
typedef LSA_ALLOCATE_PRIVATE_HEAP   *PLSA_ALLOCATE_PRIVATE_HEAP;
typedef LSA_FREE_PRIVATE_HEAP       *PLSA_FREE_PRIVATE_HEAP;
typedef LSA_ALLOCATE_CLIENT_BUFFER  *PLSA_ALLOCATE_CLIENT_BUFFER;
typedef LSA_FREE_CLIENT_BUFFER      *PLSA_FREE_CLIENT_BUFFER;
typedef LSA_COPY_TO_CLIENT_BUFFER   *PLSA_COPY_TO_CLIENT_BUFFER;
typedef LSA_COPY_FROM_CLIENT_BUFFER *PLSA_COPY_FROM_CLIENT_BUFFER;

/* LSA dispatch table */
typedef struct _LSA_DISPATCH_TABLE {
    PLSA_CREATE_LOGON_SESSION       CreateLogonSession;
    PLSA_DELETE_LOGON_SESSION       DeleteLogonSession;
    PLSA_ADD_CREDENTIAL             AddCredential;
    PLSA_GET_CREDENTIALS            GetCredentials;
    PLSA_DELETE_CREDENTIAL          DeleteCredential;
    PLSA_ALLOCATE_LSA_HEAP          AllocateLsaHeap;
    PLSA_FREE_LSA_HEAP              FreeLsaHeap;
    PLSA_ALLOCATE_CLIENT_BUFFER     AllocateClientBuffer;
    PLSA_FREE_CLIENT_BUFFER         FreeClientBuffer;
    PLSA_COPY_TO_CLIENT_BUFFER      CopyToClientBuffer;
    PLSA_COPY_FROM_CLIENT_BUFFER    CopyFromClientBuffer;
} LSA_DISPATCH_TABLE;
typedef LSA_DISPATCH_TABLE  *PLSA_DISPATCH_TABLE;

/* Authentication package exported callbacks */
typedef NTSTATUS (NTAPI LSA_AP_INITIALIZE_PACKAGE)( ULONG, PLSA_DISPATCH_TABLE, PLSA_STRING, PLSA_STRING, PLSA_STRING * );
typedef NTSTATUS (NTAPI LSA_AP_LOGON_USER)( PLSA_CLIENT_REQUEST, SECURITY_LOGON_TYPE, PVOID, PVOID, ULONG, PVOID *, PULONG, PLUID, PNTSTATUS, PLSA_TOKEN_INFORMATION_TYPE, PVOID *, PLSA_UNICODE_STRING *, PLSA_UNICODE_STRING * );
typedef NTSTATUS (NTAPI LSA_AP_LOGON_USER_EX)( PLSA_CLIENT_REQUEST, SECURITY_LOGON_TYPE, PVOID, PVOID, ULONG, PVOID *, PULONG, PLUID, PNTSTATUS, PLSA_TOKEN_INFORMATION_TYPE, PVOID *, PUNICODE_STRING *, PUNICODE_STRING *, PUNICODE_STRING * );
typedef NTSTATUS (NTAPI LSA_AP_CALL_PACKAGE)( PLSA_CLIENT_REQUEST, PVOID, PVOID, ULONG, PVOID *, PULONG, PNTSTATUS );
typedef NTSTATUS (NTAPI LSA_AP_CALL_PACKAGE_PASSTHROUGH)( PLSA_CLIENT_REQUEST, PVOID, PVOID, ULONG, PVOID *, PULONG, PNTSTATUS );
typedef VOID (NTAPI LSA_AP_LOGON_TERMINATED)( PLUID );
typedef LSA_AP_CALL_PACKAGE             LSA_AP_CALL_PACKAGE_UNTRUSTED;
typedef LSA_AP_INITIALIZE_PACKAGE       *PLSA_AP_INITIALIZE_PACKAGE;
typedef LSA_AP_LOGON_USER               *PLSA_AP_LOGON_USER;
typedef LSA_AP_LOGON_USER_EX            *PLSA_AP_LOGON_USER_EX;
typedef LSA_AP_CALL_PACKAGE             *PLSA_AP_CALL_PACKAGE;
typedef LSA_AP_CALL_PACKAGE_PASSTHROUGH *PLSA_AP_CALL_PACKAGE_PASSTHROUGH;
typedef LSA_AP_LOGON_TERMINATED         *PLSA_AP_LOGON_TERMINATED;
typedef LSA_AP_CALL_PACKAGE_UNTRUSTED   *PLSA_AP_CALL_PACKAGE_UNTRUSTED;

/* SAM register mapping element */
typedef struct {
    PSTR    Original;
    PSTR    Mapped;
    BOOLEAN Continuable;
} SAM_REGISTER_MAPPING_ELEMENT;
typedef SAM_REGISTER_MAPPING_ELEMENT    *PSAM_REGISTER_MAPPING_ELEMENT;

/* SAM register mapping list */
typedef struct {
    ULONG                           Count;
    PSAM_REGISTER_MAPPING_ELEMENT   Elements;
} SAM_REGISTER_MAPPING_LIST;
typedef SAM_REGISTER_MAPPING_LIST   *PSAM_REGISTER_MAPPING_LIST;

/* SAM register mapping table */
typedef struct {
    ULONG                       Count;
    PSAM_REGISTER_MAPPING_LIST  Lists;
} SAM_REGISTER_MAPPING_TABLE;
typedef SAM_REGISTER_MAPPING_TABLE  *PSAM_REGISTER_MAPPING_TABLE;

/* SAM callbacks */
typedef NTSTATUS (*PSAM_CREDENTIAL_UPDATE_NOTIFY_ROUTINE)( PUNICODE_STRING, PVOID, ULONG, ULONG, PUNICODE_STRING, PUNICODE_STRING, PUNICODE_STRING, PUNICODE_STRING, PVOID *, ULONG * );
typedef BOOLEAN (*PSAM_CREDENTIAL_UPDATE_REGISTER_ROUTINE)( PUNICODE_STRING );
typedef VOID (*PSAM_CREDENTIAL_UPDATE_FREE_ROUTINE)( PVOID );
typedef NTSTATUS (*PSAM_CREDENTIAL_UPDATE_REGISTER_MAPPED_ENTRYPOINTS_ROUTINE)( SAM_REGISTER_MAPPING_TABLE * );

/* Security package client information */
typedef struct _SECPKG_CLIENT_INFO {
    LUID                            LogonId;
    ULONG                           ProcessID;
    ULONG                           ThreadID;
    BOOLEAN                         HasTcbPrivilege;
    BOOLEAN                         Impersonating;
    BOOLEAN                         Restricted;
    UCHAR                           ClientFlags;
    SECURITY_IMPERSONATION_LEVEL    ImpersonationLevel;
    HANDLE                          ClientToken;
} SECPKG_CLIENT_INFO;
typedef SECPKG_CLIENT_INFO  *PSECPKG_CLIENT_INFO;

/* Security package call information */
typedef struct _SECPKG_CALL_INFO {
    ULONG   ProcessId;
    ULONG   ThreadId;
    ULONG   Attributes;
    ULONG   CallCount;
    PVOID   MechOid;
} SECPKG_CALL_INFO;
typedef SECPKG_CALL_INFO    *PSECPKG_CALL_INFO;

/* Security package supplemental credential */
typedef struct _SECPKG_SUPPLEMENTAL_CRED {
    UNICODE_STRING  PackageName;
    ULONG           CredentialSize;
    PUCHAR          Credentials;
} SECPKG_SUPPLEMENTAL_CRED;
typedef SECPKG_SUPPLEMENTAL_CRED    *PSECPKG_SUPPLEMENTAL_CRED;

/* Security package byte vector */
typedef struct _SECPKG_BYTE_VECTOR {
    ULONG   ByteArrayOffset;
    USHORT  ByteArrayLength;
} SECPKG_BYTE_VECTOR;
typedef SECPKG_BYTE_VECTOR  *PSECPKG_BYTE_VECTOR;

/* Security package short vector */
typedef struct _SECPKG_SHORT_VECTOR {
    ULONG   ShortArrayOffset;
    USHORT  ShortArrayCount;
} SECPKG_SHORT_VECTOR;
typedef SECPKG_SHORT_VECTOR *PSECPKG_SHORT_VECTOR;

/* Security supplied credential */
typedef struct _SECPKG_SUPPLIED_CREDENTIAL {
    USHORT              cbHeaderLength;
    USHORT              cbStructureLength;
    SECPKG_SHORT_VECTOR UserName;
    SECPKG_SHORT_VECTOR DomainName;
    SECPKG_BYTE_VECTOR  PackedCredentials;
    ULONG               CredFlags;
} SECPKG_SUPPLIED_CREDENTIAL;
typedef SECPKG_SUPPLIED_CREDENTIAL  *PSECPKG_SUPPLIED_CREDENTIAL;

/* Security package credential */
typedef struct _SECPKG_CREDENTIAL {
    ULONG64             Version;
    USHORT              cbHeaderLength;
    ULONG               cbStructureLength;
    ULONG               ClientProcess;
    ULONG               ClientThread;
    LUID                LogonId;
    HANDLE              ClientToken;
    ULONG               SessionId;
    LUID                ModifiedId;
    ULONG               fCredentials;
    ULONG               Flags;
    SECPKG_BYTE_VECTOR  PrincipalName;
    SECPKG_BYTE_VECTOR  PackageList;
    SECPKG_BYTE_VECTOR  MarshaledSuppliedCreds;
} SECPKG_CREDENTIAL;
typedef SECPKG_CREDENTIAL   *PSECPKG_CREDENTIAL;

/* Security package supplemental credential array */
typedef struct _SECPKG_SUPPLEMENTAL_CRED_ARRAY {
    ULONG                       CredentialCount;
    SECPKG_SUPPLEMENTAL_CRED    Credentials[1];
} SECPKG_SUPPLEMENTAL_CRED_ARRAY;
typedef SECPKG_SUPPLEMENTAL_CRED_ARRAY  *PSECPKG_SUPPLEMENTAL_CRED_ARRAY;

/* LSA callback */
typedef NTSTATUS (NTAPI LSA_CALLBACK_FUNCTION)( ULONG_PTR, ULONG_PTR, PSecBuffer, PSecBuffer );
typedef LSA_CALLBACK_FUNCTION   *PLSA_CALLBACK_FUNCTION;

/* Security package primary credential */
typedef struct _SECPKG_PRIMARY_CRED {
    LUID            LogonId;
    UNICODE_STRING  DownlevelName;
    UNICODE_STRING  DomainName;
    UNICODE_STRING  Password;
    UNICODE_STRING  OldPassword;
    PSID            UserSid;
    ULONG           Flags;
    UNICODE_STRING  DnsDomainName;
    UNICODE_STRING  Upn;
    UNICODE_STRING  LogonServer;
    UNICODE_STRING  Spare1;
    UNICODE_STRING  Spare2;
    UNICODE_STRING  Spare3;
    UNICODE_STRING  Spare4;
} SECPKG_PRIMARY_CRED;
typedef SECPKG_PRIMARY_CRED *PSECPKG_PRIMARY_CRED;

/* Security package parameters */
typedef struct _SECPKG_PARAMETERS {
    ULONG           Version;
    ULONG           MachineState;
    ULONG           SetupMode;
    PSID            DomainSid;
    UNICODE_STRING  DomainName;
    UNICODE_STRING  DnsDomainName;
    GUID            DomainGuid;
} SECPKG_PARAMETERS;
typedef SECPKG_PARAMETERS   *PSECPKG_PARAMETERS;
typedef SECPKG_PARAMETERS   SECPKG_EVENT_DOMAIN_CHANGE;
typedef SECPKG_PARAMETERS   *PSECPKG_EVENT_DOMAIN_CHANGE;

/* Security package extended information classes */
typedef enum _SECPKG_EXTENDED_INFORMATION_CLASS {
    SecpkgGssInfo           = 1,
    SecpkgContextThunks     = 2,
    SecpkgMutualAuthLevel   = 3,
    SecpkgWowClientDll      = 4,
    SecpkgExtraOids         = 5,
    SecpkgMaxInfo           = 6,
    SecpkgNego2Info         = 7
} SECPKG_EXTENDED_INFORMATION_CLASS;

/* Security package GSS information */
typedef struct _SECPKG_GSS_INFO {
    ULONG   EncodedIdLength;
    UCHAR   EncodedId[4];
} SECPKG_GSS_INFO;
typedef SECPKG_GSS_INFO *PSECPKG_GSS_INFO;

/* Security package context thunks */
typedef struct _SECPKG_CONTEXT_THUNKS {
    ULONG   InfoLevelCount;
    ULONG   Levels[1];
} SECPKG_CONTEXT_THUNKS;
typedef SECPKG_CONTEXT_THUNKS   *PSECPKG_CONTEXT_THUNKS;

/* Security package mutual authentication level */
typedef struct _SECPKG_MUTUAL_AUTH_LEVEL {
    ULONG   MutualAuthLevel;
} SECPKG_MUTUAL_AUTH_LEVEL;
typedef SECPKG_MUTUAL_AUTH_LEVEL    *PSECPKG_MUTUAL_AUTH_LEVEL;

/* Security package WOW client DLL */
typedef struct _SECPKG_WOW_CLIENT_DLL {
    SECURITY_STRING WowClientDllPath;
} SECPKG_WOW_CLIENT_DLL;
typedef SECPKG_WOW_CLIENT_DLL   *PSECPKG_WOW_CLIENT_DLL;

/* Security package serialized object identifier */
typedef struct _SECPKG_SERIALIZED_OID {
    ULONG   OidLength;
    ULONG   OidAttributes;
    UCHAR   OidValue[SECPKG_MAX_OID_LENGTH];
} SECPKG_SERIALIZED_OID;
typedef SECPKG_SERIALIZED_OID   *PSECPKG_SERIALIZED_OID;

/* Security package extra object identifiers */
typedef struct _SECPKG_EXTRA_OIDS {
    ULONG                   OidCount;
    SECPKG_SERIALIZED_OID   Oids[1];
} SECPKG_EXTRA_OIDS;
typedef SECPKG_EXTRA_OIDS   *PSECPKG_EXTRA_OIDS;

/* Security package Nego2 information */
typedef struct _SECPKG_NEGO2_INFO {
    UCHAR   AuthScheme[16];
    ULONG   PackageFlags;
} SECPKG_NEGO2_INFO;
typedef SECPKG_NEGO2_INFO   *PSECPKG_NEGO2_INFO;

/* Security package extended information */
typedef struct _SECPKG_EXTENDED_INFORMATION {
    SECPKG_EXTENDED_INFORMATION_CLASS   Class;
    union {
        SECPKG_GSS_INFO             GssInfo;
        SECPKG_CONTEXT_THUNKS       ContextThunks;
        SECPKG_MUTUAL_AUTH_LEVEL    MutualAuthLevel;
        SECPKG_WOW_CLIENT_DLL       WowClientDll;
        SECPKG_EXTRA_OIDS           ExtraOids;
        SECPKG_NEGO2_INFO           Nego2Info;
    } Info;
} SECPKG_EXTENDED_INFORMATION;
typedef SECPKG_EXTENDED_INFORMATION *PSECPKG_EXTENDED_INFORMATION;

/* Security package target information */
typedef struct _SECPKG_TARGETINFO {
    PSID    DomainSid;
    PCWSTR  ComputerName;
} SECPKG_TARGETINFO;
typedef SECPKG_TARGETINFO   *PSECPKG_TARGETINFO;

/* Security package context SASL context */
typedef struct _SecPkgContext_SaslContext {
    PVOID   SaslContext;
} SecPkgContext_SaslContext;
typedef SecPkgContext_SaslContext   *PSecPkgContext_SaslContext;

/* Security user data */
typedef struct _SECURITY_USER_DATA {
    SECURITY_STRING UserName;
    SECURITY_STRING LogonDomainName;
    SECURITY_STRING LogonServer;
    PSID            pSid;
} SECURITY_USER_DATA;
typedef SECURITY_USER_DATA  *PSECURITY_USER_DATA;
typedef SECURITY_USER_DATA  SecurityUserData;
typedef SECURITY_USER_DATA  *PSecurityUserData;

/* Security package session information types */
typedef enum _SECPKG_SESSIONINFO_TYPE {
    SecSessionPrimaryCred   = 0
} SECPKG_SESSIONINFO_TYPE;

/* Security package name types */
typedef enum _SECPKG_NAME_TYPE {
    SecNameSamCompatible    = 0,
    SecNameAlternateId      = 1,
    SecNameFlat             = 2,
    SecNameDN               = 3,
    SecNameSPN              = 4
} SECPKG_NAME_TYPE;

/* Security package manager callbacks */
typedef NTSTATUS (NTAPI LSA_IMPERSONATE_CLIENT)( VOID );
typedef NTSTATUS (NTAPI LSA_UNLOAD_PACKAGE)( VOID );
typedef NTSTATUS (NTAPI LSA_DUPLICATE_HANDLE)( HANDLE, PHANDLE );
typedef NTSTATUS (NTAPI LSA_SAVE_SUPPLEMENTAL_CREDENTIALS)( PLUID, ULONG, PVOID, BOOLEAN );
typedef HANDLE (NTAPI LSA_CREATE_THREAD)( SEC_ATTRS, ULONG, SEC_THREAD_START, PVOID, ULONG, PULONG );
typedef NTSTATUS (NTAPI LSA_GET_CLIENT_INFO)( PSECPKG_CLIENT_INFO );
typedef HANDLE (NTAPI LSA_REGISTER_NOTIFICATION)( SEC_THREAD_START, PVOID, ULONG, ULONG, ULONG, ULONG, HANDLE );
typedef NTSTATUS (NTAPI LSA_CANCEL_NOTIFICATION)( HANDLE );
typedef NTSTATUS (NTAPI LSA_MAP_BUFFER)( PSecBuffer, PSecBuffer );
typedef NTSTATUS (NTAPI LSA_CREATE_TOKEN)( PLUID, PTOKEN_SOURCE, SECURITY_LOGON_TYPE, SECURITY_IMPERSONATION_LEVEL, LSA_TOKEN_INFORMATION_TYPE, PVOID, PTOKEN_GROUPS, PUNICODE_STRING, PUNICODE_STRING, PUNICODE_STRING, PUNICODE_STRING, PHANDLE, PNTSTATUS );
typedef NTSTATUS (NTAPI LSA_CREATE_TOKEN_EX)( PLUID, PTOKEN_SOURCE, SECURITY_LOGON_TYPE, SECURITY_IMPERSONATION_LEVEL, LSA_TOKEN_INFORMATION_TYPE, PVOID, PTOKEN_GROUPS, PUNICODE_STRING, PUNICODE_STRING, PVOID, SECPKG_SESSIONINFO_TYPE, PHANDLE, PNTSTATUS );
typedef VOID (NTAPI LSA_AUDIT_LOGON)( NTSTATUS, NTSTATUS, PUNICODE_STRING, PUNICODE_STRING, PUNICODE_STRING, PSID, SECURITY_LOGON_TYPE, PTOKEN_SOURCE, PLUID );
typedef NTSTATUS (NTAPI LSA_CALL_PACKAGE)( PUNICODE_STRING, PVOID, ULONG, PVOID *, PULONG, PNTSTATUS );
typedef NTSTATUS (NTAPI LSA_CALL_PACKAGEEX)( PUNICODE_STRING, PVOID, PVOID, ULONG, PVOID *, PULONG, PNTSTATUS );
typedef NTSTATUS (NTAPI LSA_CALL_PACKAGE_PASSTHROUGH)( PUNICODE_STRING, PVOID, PVOID, ULONG, PVOID *, PULONG, PNTSTATUS );
typedef BOOLEAN (NTAPI LSA_GET_CALL_INFO)( PSECPKG_CALL_INFO );
typedef PVOID (NTAPI LSA_CREATE_SHARED_MEMORY)( ULONG, ULONG );
typedef PVOID (NTAPI LSA_ALLOCATE_SHARED_MEMORY)( PVOID, ULONG );
typedef VOID (NTAPI LSA_FREE_SHARED_MEMORY)( PVOID, PVOID );
typedef BOOLEAN (NTAPI LSA_DELETE_SHARED_MEMORY)( PVOID );
typedef NTSTATUS (NTAPI LSA_OPEN_SAM_USER)( PSECURITY_STRING, SECPKG_NAME_TYPE, PSECURITY_STRING, BOOLEAN, ULONG, PVOID * );
typedef NTSTATUS (NTAPI LSA_GET_USER_CREDENTIALS)( PVOID, PVOID *, PULONG, PVOID *, PULONG );
typedef NTSTATUS (NTAPI LSA_GET_USER_AUTH_DATA)( PVOID, PUCHAR *, PULONG );
typedef NTSTATUS (NTAPI LSA_CLOSE_SAM_USER)( PVOID );
typedef NTSTATUS (NTAPI LSA_GET_AUTH_DATA_FOR_USER)( PSECURITY_STRING, SECPKG_NAME_TYPE, PSECURITY_STRING, PUCHAR *, PULONG, PUNICODE_STRING );
typedef NTSTATUS (NTAPI LSA_CONVERT_AUTH_DATA_TO_TOKEN)( PVOID, ULONG, SECURITY_IMPERSONATION_LEVEL, PTOKEN_SOURCE, SECURITY_LOGON_TYPE, PUNICODE_STRING, PHANDLE, PLUID, PUNICODE_STRING, PNTSTATUS );
typedef NTSTATUS (NTAPI LSA_CRACK_SINGLE_NAME)( ULONG, BOOLEAN, PUNICODE_STRING, PUNICODE_STRING, ULONG, PUNICODE_STRING, PUNICODE_STRING, PULONG );
typedef NTSTATUS (NTAPI LSA_AUDIT_ACCOUNT_LOGON)( ULONG, BOOLEAN, PUNICODE_STRING, PUNICODE_STRING, PUNICODE_STRING, NTSTATUS );
typedef NTSTATUS (NTAPI LSA_CLIENT_CALLBACK)( PCHAR, ULONG_PTR, ULONG_PTR, PSecBuffer, PSecBuffer );
typedef NTSTATUS (NTAPI LSA_REGISTER_CALLBACK)( ULONG, PLSA_CALLBACK_FUNCTION );
typedef NTSTATUS (NTAPI LSA_UPDATE_PRIMARY_CREDENTIALS)( PSECPKG_PRIMARY_CRED, PSECPKG_SUPPLEMENTAL_CRED_ARRAY );
typedef VOID (NTAPI LSA_PROTECT_MEMORY)( PVOID, ULONG );
typedef NTSTATUS (NTAPI LSA_OPEN_TOKEN_BY_LOGON_ID)( PLUID, HANDLE * );
typedef NTSTATUS (NTAPI LSA_EXPAND_AUTH_DATA_FOR_DOMAIN)( PUCHAR, ULONG, PVOID, PUCHAR *, PULONG );
typedef PVOID (NTAPI LSA_LOCATE_PKG_BY_ID)( ULONG );
typedef LSA_IMPERSONATE_CLIENT              *PLSA_IMPERSONATE_CLIENT;
typedef LSA_UNLOAD_PACKAGE                  *PLSA_UNLOAD_PACKAGE;
typedef LSA_DUPLICATE_HANDLE                *PLSA_DUPLICATE_HANDLE;
typedef LSA_SAVE_SUPPLEMENTAL_CREDENTIALS   *PLSA_SAVE_SUPPLEMENTAL_CREDENTIALS;
typedef LSA_CREATE_THREAD                   *PLSA_CREATE_THREAD;
typedef LSA_GET_CLIENT_INFO                 *PLSA_GET_CLIENT_INFO;
typedef LSA_REGISTER_NOTIFICATION           *PLSA_REGISTER_NOTIFICATION;
typedef LSA_CANCEL_NOTIFICATION             *PLSA_CANCEL_NOTIFICATION;
typedef LSA_MAP_BUFFER                      *PLSA_MAP_BUFFER;
typedef LSA_CREATE_TOKEN                    *PLSA_CREATE_TOKEN;
typedef LSA_AUDIT_LOGON                     *PLSA_AUDIT_LOGON;
typedef LSA_CALL_PACKAGE                    *PLSA_CALL_PACKAGE;
typedef LSA_CALL_PACKAGEEX                  *PLSA_CALL_PACKAGEEX;
typedef LSA_GET_CALL_INFO                   *PLSA_GET_CALL_INFO;
typedef LSA_CREATE_SHARED_MEMORY            *PLSA_CREATE_SHARED_MEMORY;
typedef LSA_ALLOCATE_SHARED_MEMORY          *PLSA_ALLOCATE_SHARED_MEMORY;
typedef LSA_FREE_SHARED_MEMORY              *PLSA_FREE_SHARED_MEMORY;
typedef LSA_DELETE_SHARED_MEMORY            *PLSA_DELETE_SHARED_MEMORY;
typedef LSA_OPEN_SAM_USER                   *PLSA_OPEN_SAM_USER;
typedef LSA_GET_USER_CREDENTIALS            *PLSA_GET_USER_CREDENTIALS;
typedef LSA_GET_USER_AUTH_DATA              *PLSA_GET_USER_AUTH_DATA;
typedef LSA_CLOSE_SAM_USER                  *PLSA_CLOSE_SAM_USER;
typedef LSA_CONVERT_AUTH_DATA_TO_TOKEN      *PLSA_CONVERT_AUTH_DATA_TO_TOKEN;
typedef LSA_CLIENT_CALLBACK                 *PLSA_CLIENT_CALLBACK;
typedef LSA_REGISTER_CALLBACK               *PLSA_REGISTER_CALLBACK;
typedef LSA_UPDATE_PRIMARY_CREDENTIALS      *PLSA_UPDATE_PRIMARY_CREDENTIALS;
typedef LSA_GET_AUTH_DATA_FOR_USER          *PLSA_GET_AUTH_DATA_FOR_USER;
typedef LSA_CRACK_SINGLE_NAME               *PLSA_CRACK_SINGLE_NAME;
typedef LSA_AUDIT_ACCOUNT_LOGON             *PLSA_AUDIT_ACCOUNT_LOGON;
typedef LSA_CALL_PACKAGE_PASSTHROUGH        *PLSA_CALL_PACKAGE_PASSTHROUGH;
typedef LSA_PROTECT_MEMORY                  *PLSA_PROTECT_MEMORY;
typedef LSA_OPEN_TOKEN_BY_LOGON_ID          *PLSA_OPEN_TOKEN_BY_LOGON_ID;
typedef LSA_EXPAND_AUTH_DATA_FOR_DOMAIN     *PLSA_EXPAND_AUTH_DATA_FOR_DOMAIN;
typedef LSA_CREATE_TOKEN_EX                 *PLSA_CREATE_TOKEN_EX;
typedef LSA_LOCATE_PKG_BY_ID                *PLSA_LOCATE_PKG_BY_ID;

/* Security package event package change */
typedef struct _SECPKG_EVENT_PACKAGE_CHANGE {
    ULONG           ChangeType;
    LSA_SEC_HANDLE  PackageId;
    SECURITY_STRING PackageName;
} SECPKG_EVENT_PACKAGE_CHANGE;
typedef SECPKG_EVENT_PACKAGE_CHANGE *PSECPKG_EVENT_PACKAGE_CHANGE;

/* Security package event role change */
typedef struct _SECPKG_EVENT_ROLE_CHANGE {
    ULONG   PreviousRole;
    ULONG   NewRole;
} SECPKG_EVENT_ROLE_CHANGE;
typedef SECPKG_EVENT_ROLE_CHANGE    *PSECPKG_EVENT_ROLE_CHANGE;

/* Security change event notify */
typedef struct _SECPKG_EVENT_NOTIFY {
    ULONG   EventClass;
    ULONG   Reserved;
    ULONG   EventDataSize;
    PVOID   EventData;
    PVOID   PackageParameter;
} SECPKG_EVENT_NOTIFY;
typedef SECPKG_EVENT_NOTIFY *PSECPKG_EVENT_NOTIFY;

/* Encrypted credential */
#ifdef _WINCRED_H_
typedef struct _ENCRYPTED_CREDENTIALW {
    CREDENTIALW Cred;
    ULONG       ClearCredentialBlobSize;
} ENCRYPTED_CREDENTIALW;
typedef ENCRYPTED_CREDENTIALW   *PENCRYPTED_CREDENTIALW;
#endif

/* Credential parsed user name types */
#ifdef _WINCRED_H_
typedef enum _CredParsedUserNameType {
    parsedUsernameInvalid       = 0,
    parsedUsernameUpn           = 1,
    parsedUsernameNt4Style      = 2,
    parsedUsernameCertificate   = 3,
    parsedUsernameNotQualified  = 4
} CredParsedUserNameType;
#endif

/* Credential callbacks */
#ifdef _WINCRED_H_
typedef NTSTATUS (NTAPI CredReadFn)( PLUID, ULONG, LPWSTR, ULONG, ULONG, PENCRYPTED_CREDENTIALW * );
typedef NTSTATUS (NTAPI CredReadDomainCredentialsFn)( PLUID, ULONG, PCREDENTIAL_TARGET_INFORMATIONW, ULONG, PULONG, PENCRYPTED_CREDENTIALW ** );
typedef VOID (NTAPI CredFreeCredentialsFn)( ULONG, PENCRYPTED_CREDENTIALW * );
typedef NTSTATUS (NTAPI CredWriteFn )( PLUID, ULONG, PENCRYPTED_CREDENTIALW, ULONG );
typedef NTSTATUS (NTAPI CrediUnmarshalandDecodeStringFn)( LPWSTR, LPBYTE *, ULONG *, BOOLEAN * );
#endif

/* Authentication identity (32-bit version) */
typedef struct _SEC_WINNT_AUTH_IDENTITY32 {
    ULONG   User;
    ULONG   UserLength;
    ULONG   Domain;
    ULONG   DomainLength;
    ULONG   Password;
    ULONG   PasswordLength;
    ULONG   Flags;
} SEC_WINNT_AUTH_IDENTITY32;
typedef SEC_WINNT_AUTH_IDENTITY32   *PSEC_WINNT_AUTH_IDENTITY32;

/* Authentication identity (extended 32-bit version) */
typedef struct _SEC_WINNT_AUTH_IDENTITY_EX32 {
    ULONG   Version;
    ULONG   Length;
    ULONG   User;
    ULONG   UserLength;
    ULONG   Domain;
    ULONG   DomainLength;
    ULONG   Password;
    ULONG   PasswordLength;
    ULONG   Flags;
    ULONG   PackageList;
    ULONG   PackageListLength;
} SEC_WINNT_AUTH_IDENTITY_EX32;
typedef SEC_WINNT_AUTH_IDENTITY_EX32    *PSEC_WINNT_AUTH_IDENTITY_EX32;

/* LSA security package function table */
typedef struct _LSA_SECPKG_FUNCTION_TABLE {
    PLSA_CREATE_LOGON_SESSION           CreateLogonSession;
    PLSA_DELETE_LOGON_SESSION           DeleteLogonSession;
    PLSA_ADD_CREDENTIAL                 AddCredential;
    PLSA_GET_CREDENTIALS                GetCredentials;
    PLSA_DELETE_CREDENTIAL              DeleteCredential;
    PLSA_ALLOCATE_LSA_HEAP              AllocateLsaHeap;
    PLSA_FREE_LSA_HEAP                  FreeLsaHeap;
    PLSA_ALLOCATE_CLIENT_BUFFER         AllocateClientBuffer;
    PLSA_FREE_CLIENT_BUFFER             FreeClientBuffer;
    PLSA_COPY_TO_CLIENT_BUFFER          CopyToClientBuffer;
    PLSA_COPY_FROM_CLIENT_BUFFER        CopyFromClientBuffer;
    PLSA_IMPERSONATE_CLIENT             ImpersonateClient;
    PLSA_UNLOAD_PACKAGE                 UnloadPackage;
    PLSA_DUPLICATE_HANDLE               DuplicateHandle;
    PLSA_SAVE_SUPPLEMENTAL_CREDENTIALS  SaveSupplementalCredentials;
    PLSA_CREATE_THREAD                  CreateThread;
    PLSA_GET_CLIENT_INFO                GetClientInfo;
    PLSA_REGISTER_NOTIFICATION          RegisterNotification;
    PLSA_CANCEL_NOTIFICATION            CancelNotification;
    PLSA_MAP_BUFFER                     MapBuffer;
    PLSA_CREATE_TOKEN                   CreateToken;
    PLSA_AUDIT_LOGON                    AuditLogon;
    PLSA_CALL_PACKAGE                   CallPackage;
    PLSA_FREE_LSA_HEAP                  FreeReturnBuffer;
    PLSA_GET_CALL_INFO                  GetCallInfo;
    PLSA_CALL_PACKAGEEX                 CallPackageEx;
    PLSA_CREATE_SHARED_MEMORY           CreatedSharedMemory;
    PLSA_ALLOCATE_SHARED_MEMORY         AllocateSharedMemory;
    PLSA_FREE_SHARED_MEMORY             FreeSharedMemory;
    PLSA_DELETE_SHARED_MEMORY           DeleteSharedMemory;
    PLSA_OPEN_SAM_USER                  OpenSamUser;
    PLSA_GET_USER_CREDENTIALS           GetUserCredentials;
    PLSA_GET_USER_AUTH_DATA             GetUserAuthData;
    PLSA_CLOSE_SAM_USER                 CloseSamUser;
    PLSA_CONVERT_AUTH_DATA_TO_TOKEN     ConvertAuthDataToToken;
    PLSA_CLIENT_CALLBACK                ClientCallback;
    PLSA_UPDATE_PRIMARY_CREDENTIALS     UpdateCredentials;
    PLSA_GET_AUTH_DATA_FOR_USER         GetUserDataForUser;
    PLSA_CRACK_SINGLE_NAME              CrackSingleName;
    PLSA_AUDIT_ACCOUNT_LOGON            AuditAccountLogon;
    PLSA_CALL_PACKAGE_PASSTHROUGH       CallPackagePassthrough;
#ifdef _WINCRED_H_
    CredReadFn                          *CrediRead;
    CredReadDomainCredentialsFn         *CrediReadDomainCredentials;
    CredFreeCredentialsFn               *CrediFreeCredentials;
#else
    PLSA_PROTECT_MEMORY                 DummyFunction1;
    PLSA_PROTECT_MEMORY                 DummyFunction2;
    PLSA_PROTECT_MEMORY                 DummyFunction3;
#endif
    PLSA_PROTECT_MEMORY                 LsaProtectMemory;
    PLSA_PROTECT_MEMORY                 LsaUnprotectMemory;
    PLSA_OPEN_TOKEN_BY_LOGON_ID         OpenTokenByLogonId;
    PLSA_EXPAND_AUTH_DATA_FOR_DOMAIN    ExpandAuthDataForDomain;
    PLSA_ALLOCATE_PRIVATE_HEAP          AllocatePrivateHeap;
    PLSA_FREE_PRIVATE_HEAP              FreePrivateHeap;
    PLSA_CREATE_TOKEN_EX                CreateTokenEx;
#ifdef _WINCRED_H_
    CredWriteFn                         *CrediWrite;
    CrediUnmarshalandDecodeStringFn     *CrediUnmarshalandDecodeString;
#else
    PLSA_PROTECT_MEMORY                 DummyFunction4;
    PLSA_PROTECT_MEMORY                 DummyFunction5;
#endif
} LSA_SECPKG_FUNCTION_TABLE;
typedef LSA_SECPKG_FUNCTION_TABLE   *PLSA_SECPKG_FUNCTION_TABLE;

/* Security package DLL functions */
typedef struct _SECPKG_DLL_FUNCTIONS {
    PLSA_ALLOCATE_LSA_HEAP  AllocateHeap;
    PLSA_FREE_LSA_HEAP      FreeHeap;
    PLSA_REGISTER_CALLBACK  RegisterCallback;
    PLSA_LOCATE_PKG_BY_ID   LocatePackageById;
} SECPKG_DLL_FUNCTIONS;
typedef SECPKG_DLL_FUNCTIONS    *PSECPKG_DLL_FUNCTIONS;

/* Security package callbacks */
typedef NTSTATUS (NTAPI SpInitializeFn)( ULONG_PTR, PSECPKG_PARAMETERS, PLSA_SECPKG_FUNCTION_TABLE );
typedef NTSTATUS (NTAPI SpShutdownFn)( VOID );
typedef NTSTATUS (NTAPI SpGetInfoFn)( PSecPkgInfo );
typedef NTSTATUS (NTAPI SpGetExtendedInformationFn)( SECPKG_EXTENDED_INFORMATION_CLASS, PSECPKG_EXTENDED_INFORMATION * );
typedef NTSTATUS (NTAPI SpSetExtendedInformationFn)( SECPKG_EXTENDED_INFORMATION_CLASS, PSECPKG_EXTENDED_INFORMATION );
typedef NTSTATUS (NTAPI LSA_AP_LOGON_USER_EX2)( PLSA_CLIENT_REQUEST, SECURITY_LOGON_TYPE, PVOID, PVOID, ULONG, PVOID *, PULONG, PLUID, PNTSTATUS, PLSA_TOKEN_INFORMATION_TYPE, PVOID *, PUNICODE_STRING *, PUNICODE_STRING *, PUNICODE_STRING *, PSECPKG_PRIMARY_CRED *, PSECPKG_SUPPLEMENTAL_CRED_ARRAY * );
typedef NTSTATUS (NTAPI SpAcceptCredentialsFn)( SECURITY_LOGON_TYPE, PUNICODE_STRING, PSECPKG_PRIMARY_CRED, PSECPKG_SUPPLEMENTAL_CRED );
typedef NTSTATUS (NTAPI SpAcquireCredentialsHandleFn)( PUNICODE_STRING, ULONG, PLUID, PVOID, PVOID, PVOID, PLSA_SEC_HANDLE, PTimeStamp );
typedef NTSTATUS (NTAPI SpFreeCredentialsHandleFn)( LSA_SEC_HANDLE );
typedef NTSTATUS (NTAPI SpQueryCredentialsAttributesFn)( LSA_SEC_HANDLE, ULONG, PVOID );
typedef NTSTATUS (NTAPI SpSetCredentialsAttributesFn)( LSA_SEC_HANDLE, ULONG, PVOID, ULONG );
typedef NTSTATUS (NTAPI SpAddCredentialsFn)( LSA_SEC_HANDLE, PUNICODE_STRING, PUNICODE_STRING, ULONG, PVOID, PVOID, PVOID, PTimeStamp );
typedef NTSTATUS (NTAPI SpSaveCredentialsFn)( LSA_SEC_HANDLE, PSecBuffer );
typedef NTSTATUS (NTAPI SpGetCredentialsFn)( LSA_SEC_HANDLE, PSecBuffer );
typedef NTSTATUS (NTAPI SpDeleteCredentialsFn)( LSA_SEC_HANDLE, PSecBuffer );
typedef NTSTATUS (NTAPI SpInitLsaModeContextFn)( LSA_SEC_HANDLE, LSA_SEC_HANDLE, PUNICODE_STRING, ULONG, ULONG, PSecBufferDesc, PLSA_SEC_HANDLE, PSecBufferDesc, PULONG, PTimeStamp, PBOOLEAN, PSecBuffer );
typedef NTSTATUS (NTAPI SpDeleteContextFn)( LSA_SEC_HANDLE );
typedef NTSTATUS (NTAPI SpApplyControlTokenFn)( LSA_SEC_HANDLE, PSecBufferDesc );
typedef NTSTATUS (NTAPI SpAcceptLsaModeContextFn)( LSA_SEC_HANDLE, LSA_SEC_HANDLE, PSecBufferDesc, ULONG, ULONG, PLSA_SEC_HANDLE, PSecBufferDesc, PULONG, PTimeStamp, PBOOLEAN, PSecBuffer );
typedef NTSTATUS (NTAPI SpGetUserInfoFn)( PLUID, ULONG, PSecurityUserData * );
typedef NTSTATUS (NTAPI SpQueryContextAttributesFn)( LSA_SEC_HANDLE, ULONG, PVOID );
typedef NTSTATUS (NTAPI SpSetContextAttributesFn)( LSA_SEC_HANDLE, ULONG, PVOID, ULONG );
typedef NTSTATUS (NTAPI SpChangeAccountPasswordFn)( PUNICODE_STRING, PUNICODE_STRING, PUNICODE_STRING, PUNICODE_STRING, BOOLEAN, PSecBufferDesc );
typedef NTSTATUS (NTAPI SpQueryMetaDataFn)( LSA_SEC_HANDLE, PUNICODE_STRING, ULONG, PULONG, PUCHAR *, PLSA_SEC_HANDLE );
typedef NTSTATUS (NTAPI SpExchangeMetaDataFn)( LSA_SEC_HANDLE, PUNICODE_STRING, ULONG, ULONG, PUCHAR, PLSA_SEC_HANDLE );
typedef NTSTATUS (NTAPI SpGetCredUIContextFn)( LSA_SEC_HANDLE, GUID *, PULONG, PUCHAR * );
typedef NTSTATUS (NTAPI SpUpdateCredentialsFn)( LSA_SEC_HANDLE, GUID *, ULONG, PUCHAR );
typedef NTSTATUS (NTAPI SpValidateTargetInfoFn)( PLSA_CLIENT_REQUEST, PVOID, PVOID, ULONG, PSECPKG_TARGETINFO );
typedef NTSTATUS (NTAPI SpInstanceInitFn)( ULONG, PSECPKG_DLL_FUNCTIONS, PVOID * );
typedef NTSTATUS (NTAPI SpInitUserModeContextFn)( LSA_SEC_HANDLE, PSecBuffer );
typedef NTSTATUS (NTAPI SpMakeSignatureFn)( LSA_SEC_HANDLE, ULONG, PSecBufferDesc, ULONG );
typedef NTSTATUS (NTAPI SpVerifySignatureFn)( LSA_SEC_HANDLE, PSecBufferDesc, ULONG, PULONG );
typedef NTSTATUS (NTAPI SpSealMessageFn)( LSA_SEC_HANDLE, ULONG, PSecBufferDesc, ULONG );
typedef NTSTATUS (NTAPI SpUnsealMessageFn)( LSA_SEC_HANDLE, PSecBufferDesc, ULONG, PULONG );
typedef NTSTATUS (NTAPI SpGetContextTokenFn)( LSA_SEC_HANDLE, PHANDLE );
typedef NTSTATUS (NTAPI SpExportSecurityContextFn)( LSA_SEC_HANDLE, ULONG, PSecBuffer, PHANDLE );
typedef NTSTATUS (NTAPI SpImportSecurityContextFn)( PSecBuffer, HANDLE, PLSA_SEC_HANDLE );
typedef NTSTATUS (NTAPI SpCompleteAuthTokenFn)( LSA_SEC_HANDLE, PSecBufferDesc );
typedef NTSTATUS (NTAPI SpFormatCredentialsFn)( PSecBuffer, PSecBuffer );
typedef NTSTATUS (NTAPI SpMarshallSupplementalCredsFn)( ULONG, PUCHAR, PULONG, PVOID * );
typedef LSA_AP_LOGON_USER_EX2           *PLSA_AP_LOGON_USER_EX2;

/* Security package function table */
typedef struct _SECPKG_FUNCTION_TABLE {
    PLSA_AP_INITIALIZE_PACKAGE          InitializePackage;
    PLSA_AP_LOGON_USER                  LogonUser;
    PLSA_AP_CALL_PACKAGE                CallPackage;
    PLSA_AP_LOGON_TERMINATED            LogonTerminated;
    PLSA_AP_CALL_PACKAGE_UNTRUSTED      CallPackageUntrusted;
    PLSA_AP_CALL_PACKAGE_PASSTHROUGH    CallPackagePassthrough;
    PLSA_AP_LOGON_USER_EX               LogonUserEx;
    PLSA_AP_LOGON_USER_EX2              LogonUserEx2;
    SpInitializeFn                      *Initialize;
    SpShutdownFn                        *Shutdown;
    SpGetInfoFn                         *GetInfo;
    SpAcceptCredentialsFn               *AcceptCredentials;
    SpAcquireCredentialsHandleFn        *AcquireCredentialsHandle;
    SpQueryCredentialsAttributesFn      *QueryCredentialsAttributes;
    SpFreeCredentialsHandleFn           *FreeCredentialsHandle;
    SpSaveCredentialsFn                 *SaveCredentials;
    SpGetCredentialsFn                  *GetCredentials;
    SpDeleteCredentialsFn               *DeleteCredentials;
    SpInitLsaModeContextFn              *InitLsaModeContext;
    SpAcceptLsaModeContextFn            *AcceptLsaModeContext;
    SpDeleteContextFn                   *DeleteContext;
    SpApplyControlTokenFn               *ApplyControlToken;
    SpGetUserInfoFn                     *GetUserInfo;
    SpGetExtendedInformationFn          *GetExtendedInformation;
    SpQueryContextAttributesFn          *QueryContextAttributes;
    SpAddCredentialsFn                  *AddCredentials;
    SpSetExtendedInformationFn          *SetExtendedInformation;
    SpSetContextAttributesFn            *SetContextAttributes;
    SpSetCredentialsAttributesFn        *SetCredentialsAttributes;
    SpChangeAccountPasswordFn           *ChangeAccountPassword;
    SpQueryMetaDataFn                   *QueryMetaData;
    SpExchangeMetaDataFn                *ExchangeMetaData;
    SpGetCredUIContextFn                *GetCredUIContext;
    SpUpdateCredentialsFn               *UpdateCredentials;
    SpValidateTargetInfoFn              *ValidateTargetInfo;
} SECPKG_FUNCTION_TABLE;
typedef SECPKG_FUNCTION_TABLE   *PSECPKG_FUNCTION_TABLE;

/* Security package user function table */
typedef struct _SECPKG_USER_FUNCTION_TABLE {
    SpInstanceInitFn                *InstanceInit;
    SpInitUserModeContextFn         *InitUserModeContext;
    SpMakeSignatureFn               *MakeSignature;
    SpVerifySignatureFn             *VerifySignature;
    SpSealMessageFn                 *SealMessage;
    SpUnsealMessageFn               *UnsealMessage;
    SpGetContextTokenFn             *GetContextToken;
    SpQueryContextAttributesFn      *QueryContextAttributes;
    SpCompleteAuthTokenFn           *CompleteAuthToken;
    SpDeleteContextFn               *DeleteUserModeContext;
    SpFormatCredentialsFn           *FormatCredentials;
    SpMarshallSupplementalCredsFn   *MarshallSupplementalCreds;
    SpExportSecurityContextFn       *ExportContext;
    SpImportSecurityContextFn       *ImportContext;
} SECPKG_USER_FUNCTION_TABLE;
typedef SECPKG_USER_FUNCTION_TABLE  *PSECPKG_USER_FUNCTION_TABLE;

/* Security package initialization callbacks */
typedef NTSTATUS (SEC_ENTRY *SpLsaModeInitializeFn)( ULONG, PULONG, PSECPKG_FUNCTION_TABLE *, PULONG );
typedef NTSTATUS (SEC_ENTRY *SpUserModeInitializeFn)( ULONG, PULONG, PSECPKG_USER_FUNCTION_TABLE *, PULONG );

/* Kernel security context types */
typedef enum _KSEC_CONTEXT_TYPE {
    KSecPaged       = 0,
    KSecNonPaged    = 1
} KSEC_CONTEXT_TYPE;

/* Kernel security list entry */
typedef struct _KSEC_LIST_ENTRY {
    LIST_ENTRY  List;
    LONG        RefCount;
    ULONG       Signature;
    PVOID       OwningList;
    PVOID       Reserved;
} KSEC_LIST_ENTRY;
typedef KSEC_LIST_ENTRY *PKSEC_LIST_ENTRY;

/* Kernel security callbacks */
typedef PVOID (SEC_ENTRY KSEC_CREATE_CONTEXT_LIST)( KSEC_CONTEXT_TYPE );
typedef VOID (SEC_ENTRY KSEC_INSERT_LIST_ENTRY)( PVOID, PKSEC_LIST_ENTRY );
typedef NTSTATUS (SEC_ENTRY KSEC_REFERENCE_LIST_ENTRY)( PKSEC_LIST_ENTRY, ULONG, BOOLEAN );
typedef VOID (SEC_ENTRY KSEC_DEREFERENCE_LIST_ENTRY)( PKSEC_LIST_ENTRY, BOOLEAN * );
typedef NTSTATUS (SEC_ENTRY KSEC_SERIALIZE_WINNT_AUTH_DATA)( PVOID, PULONG, PVOID * );
typedef NTSTATUS (SEC_ENTRY KSEC_SERIALIZE_SCHANNEL_AUTH_DATA)( PVOID, PULONG, PVOID * );
typedef PVOID (SEC_ENTRY KSEC_LOCATE_PKG_BY_ID)( ULONG );
typedef KSEC_CREATE_CONTEXT_LIST            *PKSEC_CREATE_CONTEXT_LIST;
typedef KSEC_INSERT_LIST_ENTRY              *PKSEC_INSERT_LIST_ENTRY;
typedef KSEC_REFERENCE_LIST_ENTRY           *PKSEC_REFERENCE_LIST_ENTRY;
typedef KSEC_DEREFERENCE_LIST_ENTRY         *PKSEC_DEREFERENCE_LIST_ENTRY;
typedef KSEC_SERIALIZE_WINNT_AUTH_DATA      *PKSEC_SERIALIZE_WINNT_AUTH_DATA;
typedef KSEC_SERIALIZE_SCHANNEL_AUTH_DATA   *PKSEC_SERIALIZE_SCHANNEL_AUTH_DATA;
typedef KSEC_LOCATE_PKG_BY_ID               *PKSEC_LOCATE_PKG_BY_ID;

/* Security package kernel functions */
typedef struct _SECPKG_KERNEL_FUNCTIONS {
    PLSA_ALLOCATE_LSA_HEAP              AllocateHeap;
    PLSA_FREE_LSA_HEAP                  FreeHeap;
    PKSEC_CREATE_CONTEXT_LIST           CreateContextList;
    PKSEC_INSERT_LIST_ENTRY             InsertListEntry;
    PKSEC_REFERENCE_LIST_ENTRY          ReferenceListEntry;
    PKSEC_DEREFERENCE_LIST_ENTRY        DereferenceListEntry;
    PKSEC_SERIALIZE_WINNT_AUTH_DATA     SerializeWinntAuthData;
    PKSEC_SERIALIZE_SCHANNEL_AUTH_DATA  SerializeSchannelAuthData;
    PKSEC_LOCATE_PKG_BY_ID              LocatePackageById;
} SECPKG_KERNEL_FUNCTIONS;
typedef SECPKG_KERNEL_FUNCTIONS *PSECPKG_KERNEL_FUNCTIONS;

/* Kernel security package callbacks */
typedef NTSTATUS (NTAPI KspInitPackageFn)( PSECPKG_KERNEL_FUNCTIONS );
typedef NTSTATUS (NTAPI KspDeleteContextFn)( LSA_SEC_HANDLE, PLSA_SEC_HANDLE );
typedef NTSTATUS (NTAPI KspInitContextFn)( LSA_SEC_HANDLE, PSecBuffer, PLSA_SEC_HANDLE );
typedef NTSTATUS (NTAPI KspMakeSignatureFn)( LSA_SEC_HANDLE, ULONG, PSecBufferDesc, ULONG );
typedef NTSTATUS (NTAPI KspVerifySignatureFn)( LSA_SEC_HANDLE, PSecBufferDesc, ULONG, PULONG );
typedef NTSTATUS (NTAPI KspSealMessageFn)( LSA_SEC_HANDLE, ULONG, PSecBufferDesc, ULONG );
typedef NTSTATUS (NTAPI KspUnsealMessageFn)( LSA_SEC_HANDLE, PSecBufferDesc, ULONG, PULONG );
typedef NTSTATUS (NTAPI KspGetTokenFn)( LSA_SEC_HANDLE, PHANDLE, PACCESS_TOKEN * );
typedef NTSTATUS (NTAPI KspQueryAttributesFn)( LSA_SEC_HANDLE, ULONG, PVOID );
typedef NTSTATUS (NTAPI KspCompleteTokenFn)( LSA_SEC_HANDLE, PSecBufferDesc );
typedef NTSTATUS (NTAPI KspMapHandleFn)( LSA_SEC_HANDLE, PLSA_SEC_HANDLE );
typedef NTSTATUS (NTAPI KspSetPagingModeFn)( BOOLEAN );
typedef NTSTATUS (NTAPI KspSerializeAuthDataFn)( PVOID, PULONG, PVOID * );

/* Security package kernel function table */
typedef struct _SECPKG_KERNEL_FUNCTION_TABLE {
    KspInitPackageFn            *Initialize;
    KspDeleteContextFn          *DeleteContext;
    KspInitContextFn            *InitContext;
    KspMapHandleFn              *MapHandle;
    KspMakeSignatureFn          *Sign;
    KspVerifySignatureFn        *Verify;
    KspSealMessageFn            *Seal;
    KspUnsealMessageFn          *Unseal;
    KspGetTokenFn               *GetToken;
    KspQueryAttributesFn        *QueryAttributes;
    KspCompleteTokenFn          *CompleteToken;
    SpExportSecurityContextFn   *ExportContext;
    SpImportSecurityContextFn   *ImportContext;
    KspSetPagingModeFn          *SetPackagePagingMode;
    KspSerializeAuthDataFn      *SerializeAuthData;
} SECPKG_KERNEL_FUNCTION_TABLE;
typedef SECPKG_KERNEL_FUNCTION_TABLE    *PSECPKG_KERNEL_FUNCTION_TABLE;

/* Functions in SECUR32.DLL */
#ifdef _WINCRED_H_
NTSTATUS NTAPI  CredMarshalTargetInfo( PCREDENTIAL_TARGET_INFORMATIONW, PUSHORT *, PULONG );
NTSTATUS NTAPI  CredUnmarshalTargetInfo( PUSHORT, ULONG, PCREDENTIAL_TARGET_INFORMATIONW *, PULONG );
#endif

/* Functions in KSECDD.SYS */
SECURITY_STATUS SEC_ENTRY   KSecRegisterSecurityProvider( PSECURITY_STRING, PSECPKG_KERNEL_FUNCTION_TABLE );

/* Functions implemented as macros */
#define SecEqualLuid( p1, p2 ) \
    ((((PLUID)p1)->LowPart == ((PLUID)p2)->LowPart) && \
    (((PLUID)p1)->HighPart == ((PLUID)p2)->HighPart))
#define SecIsZeroLuid( p ) \
    (((p)->LowPart | (p)->HighPart) == 0L)
#define KsecInitializeListEntry( p1, p2 ) \
    { \
        ((PKSEC_LIST_ENTRY)p1)->List.Flink = NULL; \
        ((PKSEC_LIST_ENTRY)p1)->List.Blink = NULL; \
        ((PKSEC_LIST_ENTRY)p1)->RefCount = 1; \
        ((PKSEC_LIST_ENTRY)p1)->Signature = p2; \
        ((PKSEC_LIST_ENTRY)p1)->OwningList = NULL; \
        ((PKSEC_LIST_ENTRY)p1)->Reserved = NULL;  \
    }

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NTSECPKG_ */
