/*
 *  unknwn.h    Definition of the IUnknown and IClassFactory interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __unknwn_h__
#define __unknwn_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* GUIDs */
EXTERN_C const IID  IID_IUnknown;
EXTERN_C const IID  IID_IClassFactory;

/* IUnknown interface */
#undef INTERFACE
#define INTERFACE   IUnknown
DECLARE_INTERFACE( IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
};
typedef IUnknown    *LPUNKNOWN;

/* IClassFactory interface */
#undef INTERFACE
#define INTERFACE   IClassFactory
DECLARE_INTERFACE_( IClassFactory, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IClassFactory methods */
    STDMETHOD( CreateInstance )( THIS_ IUnknown *, REFIID, void ** ) PURE;
    STDMETHOD( LockServer )( THIS_ BOOL ) PURE;
};
typedef IClassFactory   *LPCLASSFACTORY;

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IUnknown_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IUnknown_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IUnknown_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IClassFactory_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IClassFactory_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IClassFactory_Release( x ) \
        (x)->lpVtbl->Release( x )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __unknwn_h__ */
