; Copyright (C) 2017 Jerome Shidel
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License along
;   with this program; if not, write to the Free Software Foundation, Inc.,
;   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

; NASM 2.14rc0 for DOS

; -----------------------------------------------------------------------------
; FORWARD
; -----------------------------------------------------------------------------

%ifidni CODE_STAGE, BLOCK_FORWARD

; Memory management macros

%idefine STACK_MARGIN 0x0002            ; Padding above new stack

; Fill memory with Byte
;   DS:%1   Start location
;   %2      Count
%imacro RAM_Fill 3 ; Start, Count, Data
    push        cx
    push        di
    %ifnidni 2, di
        mov         di, %1
        mov         cx, %2
    %else
        mov         cx, %2
        mov         di, %1
    %endif
    %ifnidni  3, al
        push    ax
        mov         al, %3
    %endif
    cld
%%FillLoop:
    stosb
    loop        %%FillLoop
    %ifnidni  3, al
        pop    ax
    %endif
    pop         di
    pop         cx
%endmacro

; Wipe memory with Zeros
;   DS:%1   Start location
;   %2      Count
; Output:
;   AL = 0
%imacro RAM_Zero 2 ; Start, Count
    xor al, al
    RAM_Fill %1, %2, al
%endmacro

; Initialized Default PDA items.
; Normally with a heap, on exit AX = Start of Heap
; Otherwise, figure it out.
%imacro RAM_Prepare 0

    %ifndef DONTZEROBSS
        ; Takes place before stack is moved so it is ok
        RAM_Zero     BSS_START, PDA(END) - BSS_START
    %endif

    ; STDIN_HDL is 0

    %ifdef STDOUT_BUFFER
        mov         al, 0x01
        mov         [PDA(STDOUT_HDL)], ax
    %endif
    %ifdef STDERR_BUFFER
        mov         al, 0x02
        mov         [PDA(STDERR_HDL)], ax
    %endif
    %ifdef STDAUX_BUFFER
        mov         al, 0x03
        mov         [PDA(STDAUX_HDL)], ax
    %endif
    %ifdef STDPRT_BUFFER
        mov         al, 0x03
        mov         [PDA(STDPRT_HDL)], ax
    %endif

    %ifdef SIZEOF_STACK
        mov         sp, PDA(STACK) + SIZEOF_STACK
        mov         ax, sp
        add         ax, STACK_MARGIN

        %ifdef SIZEOF_MEMORY
            mov         [PDA(HEAPBEGIN)], ax
            mov         [PDA(HEAPPTR)], ax
            mov         [PDA(HEAPEND)], ax
        %endif
    %else
        %ifdef SIZEOF_MEMORY
            %fatal "Cannot use the HEAP without specifying STACK size"
        %endif
    %endif
%endmacro

; Resize programs MCB to smallest size to prepare for ShellExec
%imacro RAM_ShrinkMCB 0
    %ifdef SIZEOF_MEMORY
        OS_ResizeMCB cs, [PDA(HEAPEND)]
    else
        On_ResizeMCB cs, PDA(STACK) + SIZEOF_STACK + STACK_MARGIN
    %endif
%endmacro

%endif