#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <fcntl.h>
#include <io.h>
#include <dos.h>
#include <conio.h>


int main (unsigned int argc, char *argv[])
{
    int iFile, iHandle;
    unsigned int iPercent, iWritten;
    unsigned long lFreeMb, lTotalMb, lFileBytes;
    unsigned char *pcBuffer;
    struct diskfree_t udtDiskFree;
    char acFile[_MAX_PATH];

    
    break_on();
    cprintf("ZEROFILL R1.09	Fill with zeros empty disk space\r\n");
    cprintf("Copyright (c) 2012-2022 by Javier Gutierrez Chamorro (Guti).\r\n\r\n");
    
    /* If we have enought arguments */
    if (argc >= 2)
    {	
    	argv[1][0] = toupper(argv[1][0]);
       	cprintf("Filling with zero empty space on drive %c:...\r\n", argv[1][0]);
        lTotalMb = 0;

        /* If success getting free disk space */
        /* ToDo: Use AX=0x36 or AX=0x7303 (extended) to get free disk space */
        if (_dos_getdiskfree(argv[1][0] - 'A' + 1, &udtDiskFree) == 0)
        {        	
			lFreeMb = ((unsigned long long) udtDiskFree.avail_clusters * udtDiskFree.sectors_per_cluster * udtDiskFree.bytes_per_sector) >> 20;

            pcBuffer = malloc(INT_MAX + 1);
            /* If we have allocated memory */
            if (pcBuffer != NULL)
            {
                memset(pcBuffer, 0, INT_MAX + 1);
                iFile = 0;
                iWritten = 0;
                lFileBytes = ULONG_MAX;
                /* Loop until end */
                do
                {
                    /* If first time or last file is full */
                    if (lFileBytes >= (LONG_MAX >> 2))
                    {
                        /* Try to resume existing fills */
						do
						{
							_dos_close(iHandle);
	                        sprintf(acFile, "%c:\\ZEROFILL.%03d", argv[1][0], iFile);
							iFile++;
						}
						while (_dos_open(acFile, O_RDONLY, &iHandle) == 0);
                    	_dos_close(iHandle);
                    	
						/* Create a new file */
                        if (_dos_creat(acFile, _A_NORMAL, &iHandle) == 0)
                        {
                        	/* Update total counter unless on first iteration */
                        	if (iWritten != 0)
                        	{
								lTotalMb += (lFileBytes >> 20);
							}
							lFileBytes = 0;
                        }
                        else
                        {
                            cprintf("Error. Cannot create file %s.\r\n", acFile);
                        }
                    }
                    /* Write data */
                    if (_dos_write(iHandle, pcBuffer, INT_MAX + 1, &iWritten) != 0)
                   	{
                   		cprintf("Error. Cannot write data on %s.\r\n", acFile);
                   	}
                    lFileBytes += iWritten;
                    /* Update progress only after 1 MB */
                    if ((lFileBytes & 1048575L) == 0)
                    {
                    	iPercent = ((lFileBytes >> 20) + lTotalMb) * 50 / lFreeMb;
                    	memset(acFile, 0, sizeof(acFile));
                    	memset(acFile, 178, iPercent);
                    	memset(&acFile[iPercent], 176, 50 - iPercent);
						cprintf("\r%ld MB / % ld MB %s [%u%%]", (lFileBytes >> 20) + lTotalMb, lFreeMb, acFile, iPercent << 1);
					}
                }
                while (((lFileBytes >> 20) + lTotalMb) < lFreeMb);
                _dos_close(iHandle);
                free(pcBuffer);
                /* Delete temporary files */
                while (iFile >= 0)
                {
                    sprintf(acFile, "%c:\\ZEROFILL.%03d", argv[1][0], iFile);
                    unlink(acFile);
                    iFile--;
                }
            }
            else
            {
                cprintf("Error. Cannot allocate memory.\r\n");
            }
        }
        else
        {
        	cprintf("Error. Cannot get free disk space for %c:.\r\n", argv[1][0]);
        }
    }
    else
    {
        cprintf("ZEROFILL [drive:]\r\n\r\n");
        cprintf("ZEROFILL writes zeros on the empty disk space for the selected drive. It helps\r\n");
        cprintf("virtual machine, and disk compression softwares to compact the volume, and so\r\n");
        cprintf("on reducing its disk usage.\r\n\r\n");
        cprintf("Examples:\r\n\r\n");
        cprintf("	ZEROFILL C:\r\n");
        cprintf("	Will fill with zeros all available space in drive C.\r\n\r\n");
        cprintf("More information at:\r\n\r\n");
        cprintf("	http://nikkhokkho.sourceforge.net/static.php?page=ZEROFILL\r\n");
        cprintf("Press ENTER to continue...");
        getch();
        cprintf("\r\n");
    }
    return(0);
}
