/*  ABSLFN (mod version)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	TO DO:
		- Complete cache buffers, to speed up disk access
		- Add Microsoft CDFS/Juliet format

*/

//#define LFNDOS_BETA
//#define DEBUG_CREATE

typedef unsigned char byte;

#define MAXDIRLEN 240

#include <Stdio.h>
#include <dos.h>
#include <Dir.h>
#include <Conio.h>
#include <String.h>
#include <Process.h>
#include <malloc.h>
#include <Errno.h>
#include <stdlib.h>
#include <Direct.h>
#include <Ctype.h>
#include <Mem.h>

struct DriveInformation {
	short	drive_number;   // kind of redundant, 0=A, 1=B, etc
	short	bytes_per_sector;
	short	sectors_per_cluster;
	short	sectors_per_fat;
	short	number_of_root_dir_sectors;
	long	root_dir_start_sector;
	short	fat_start_sector;
	long	dir_area_start;
	char	file_system_id[ 9 ];  // eg. 'FAT16   '
};

#pragma pack( 1 )

struct DirectoryEntry {
	char	filename[ 8 ];
	char	extension[ 3 ];
	char	attrib;
	char	reserved;
	char	creat_milli;
	short	creat_time;
	short	creat_date;
	short	access_date;
	short	cluster_high;   // (FAT32 only)
	short	modify_time;
	short	modify_date;
	short	startcluster;
	long	filesize;
};

struct LFNDirectoryEntry {
	unsigned char	index;
	unsigned int	name1[ 5 ];
	char		attrib;
	char		reserved;
	unsigned char	checksum;
	unsigned int	name2[ 6 ];
	short		startcluster;
	unsigned int	name3[ 2 ];
};

#pragma pack()

#define BUFFERSIZE 512

struct myffblk {
	short	ff_reserved[ 6 ];	// [0]=bytes/sector [2]=sector/cluster [3]=drive number [4]=root dir? [5]=rootdirsects
	char 	ff_attrib;
	short	ff_ftime;
	short	ff_fdate;
	long	ff_fsize;
	char	ff_name[ 13 ];
	char	ff_longname[ 255 ];
	short	ff_adate;		// last access
	char	filespec[ 70 ];
	unsigned long		bstarton, bendofclus;
	unsigned long		bsclus;
	int			baa;
	DriveInformation	drinfo;
	char			bbuffr[ BUFFERSIZE + 100 ];
};

struct CacheEntry {
	char	*buffer;  // the buffer
	int	drive;    // drive (0=A, 1=B)
	long	sectnum;  // sector it corresponds to
};

#define MAXBUFFERS 5
CacheEntry diskbuffer[ MAXBUFFERS ];

unsigned char	*buffr = NULL; // = ( char* ) malloc( BUFFERSIZE + 10 );
unsigned long	starton, endofclus;
unsigned long	sclus;
char	*filemask;
char	curlfn[ 255 ];
char	tempb[ 255 ];
int	aa = 0;
int	lfnchdir = 0;   // this can be changed by linked programs

void uselfnchdir( int yesorno )
{
	lfnchdir = yesorno;
}

//#define debugprint( xxx ) printf( xxx )
#define debugprint( xxx )

//int bpstable[ 26 ];  // bytes/sector lookup table

struct dfree dftable[ 26 ];

void initabslfn()
{
	memset( &diskbuffer[ 0 ], 0, sizeof( CacheEntry ) * MAXBUFFERS );
	//memset( &bpstable[ 0 ], 0, sizeof( int ) * 26 );
	memset( &dftable[ 0 ], 0, sizeof( dfree ) * 26 );
	buffr = ( char* ) malloc( BUFFERSIZE + 100 );
	if( buffr == NULL ) {
		printf( "ABSLFN: insufficient memory\n" );
		exit( 6 );
	}
}

#pragma startup initabslfn

struct DiskReadPacket {
	unsigned long	sector_number;
	unsigned short	num_sectors;
	void far	*transfer_address;
};

int fat32_absread( int dissk, int numsect, long sectn, void* bff )
{
	int	meant_abswrite = 0;
	if( dissk > 100 ) {
		meant_abswrite = 1;
		dissk -= 100;
	}
	DiskReadPacket	drp;
	drp.transfer_address = bff;
	drp.sector_number = sectn;
	drp.num_sectors = numsect;

	union REGS	ree;
	SREGS		sree;

	ree.x.ax = 0x7305;
	ree.x.cx = 0xffff;
	ree.x.dx = dissk + 1;
	ree.x.si = meant_abswrite;  // reading (setting to 1 will do ABSWRITE instead)
	ree.x.bx = FP_OFF( &drp );
	ree.x.flags = 1;
	sree.ds = FP_SEG( &drp );
	int86x( 0x21, &ree, &ree, &sree );
	if( ree.x.cflag == 0 )
		return -2;   // fat32 has different boot sector
	return -1;
}

int my_absread( int dissk, int numsect, long sectn, void* bff )
{
	if( absread( dissk, numsect, sectn, bff ) == -1 ) {
		if( ( errno & 0x00ff ) == 7 )
			return fat32_absread( dissk, numsect, sectn, bff );
		return -1;
	}
	return 0;
}
#define absread my_absread

int my_abswrite( int dissk, int numsect, long sectn, void* bff )
{
	if( abswrite( dissk, numsect, sectn, bff ) == -1 ) {
		if( ( errno & 0x00ff ) == 7 )
			return fat32_absread( dissk + 100, numsect, sectn, bff );
		return -1;
	}
	return 0;
}
#define abswrite my_abswrite

#ifdef ADIR_STANDALONE    // the cache doesn't work in interrupt mode

// NOTE: This caches the whole thing, so free space will not be recalculated
// If you write to a file, invalidate the cache

void mygetdfree( unsigned char drii, dfree* dd )
{
	/*if( drii < 3 )
		dftable[ drii ].df_bsec = 0;  // refresh floppy disk*/
	if( dftable[ drii ].df_bsec == 0 )
		getdfree( drii, &dftable[ drii ] );
	memcpy( dd, &dftable[ drii ], sizeof( dfree ) );
}
#define getdfree mygetdfree

#define absreadori absread
// this has a major bug: once filled, a cache entry is never overwritten
// also, changing a floppy disk doesn't invalidate cache
int absreadcache( int driv, int nsects, long lsect, void* buff )
{
	//debugprint( "Z" );
	//getch();
	int	usecache = -1, wasnull = -1, retcod = 0;
	if( nsects == 1 ) {
		for( int gg = 0; gg < MAXBUFFERS; gg++ ) {
			if( diskbuffer[ gg ].buffer == NULL ) {
				if( wasnull < 0 )
					wasnull = gg;
				continue;
			}
			if( ( diskbuffer[ gg ].drive == driv ) && ( diskbuffer[ gg ].sectnum == lsect ) ) {
				usecache = gg;
				break;
			}
		}

		dfree	dt;
		getdfree( driv + 1, &dt );
		if( ( wasnull >= 0 ) && ( usecache < 0 ) ) {
			diskbuffer[ wasnull ].buffer = ( char* ) malloc( dt.df_bsec + 10 );
			diskbuffer[ wasnull ].drive = driv;
			diskbuffer[ wasnull ].sectnum = lsect;
			retcod = absreadori( driv, nsects, lsect, diskbuffer[ wasnull ].buffer );
			usecache = wasnull;
		}
		if( usecache >= 0 )
			memcpy( buff, diskbuffer[ usecache ].buffer, dt.df_bsec );
	}
	//debugprint( "Y" ); getch();
	if( usecache < 0 )
		retcod = absreadori( driv, nsects, lsect, buff );
	return retcod;
}
#define absread absreadcache

int abswritecache( int driv, int nsects, long lsect, void* buff )
{
	for( int gg = 0; gg < MAXBUFFERS; gg++ ) {
		if( nsects != 1 )
			break;  // should check anyway
		if( diskbuffer[ gg ].buffer == NULL )
			continue;
		if( ( diskbuffer[ gg ].drive == driv ) && ( diskbuffer[ gg ].sectnum == lsect ) ) {
			dfree dt;
			getdfree( driv + 1, &dt );
			memcpy( diskbuffer[ gg ].buffer, buff, dt.df_bsec );
		}
		//diskbuffer[ gg ].buffer = NULL;   // invalidate cache
	}
	return abswrite( driv, nsects, lsect, buff );
}
#define abswrite abswritecache

#endif  // ADIR_STANDALONE

int resetdirectory( DriveInformation*, char* );

struct BootSectorStruct {
	char		signature[ 3 ];
	char		oemid[ 8 ];
	unsigned short	bytes_per_sector;
	unsigned char	sectors_per_cluster;
	unsigned short	reserved_sectors;
	unsigned char	number_of_fat_copies;
	unsigned short	root_directory_entries;
	unsigned short	unused;
	unsigned char	media_descriptor;
	unsigned short	sectors_per_fat;
	// physical disk layout info
	unsigned short	sectors_per_track;
	unsigned short	number_of_sides;
	unsigned long	number_of_hidden_sectors;
	unsigned long	total_number_of_sectors;
	unsigned short	physical_drive_number;  // for use with biosread/bioswrite
	// back to normal info
	unsigned char	boot_record_signature;
	unsigned long	serial_number;
	unsigned char	volume_label[11];
	unsigned char	file_system_id[8];
};

struct BootSectorStructFAT32 {
	unsigned char	signature[ 3 ];		// Must be 0xEB, 0x58, 0x90 = jmp 5A
	unsigned char	oemid[ 8 ];		// Probably:   "MSWIN4.1"
	unsigned short	bytes_per_sector;
	unsigned char	sectors_per_cluster;
	unsigned short	reserved_sectors;	// Reserved sectors at the beginning (33)
	unsigned char	number_of_fat_copies;

	unsigned long	unused;
	unsigned char	media_descriptor;	// Media descriptor byte (F8h)
	unsigned short	sectors_per_fat_small;

	unsigned short	sectors_per_track;
	unsigned short	number_of_sides;
	unsigned long	number_of_hidden_sectors;
	unsigned long	total_number_of_sectors;
	unsigned long	sectors_per_fat;	// Sectors per FAT (big)
	unsigned char	fat_attr;		/* FAT attributes (I guess)		*/

	unsigned char	fs_ver_maj;		/* File System Version (major)		*/
	unsigned short	fs_ver_min;		/* File System Version (minor)		*/

	unsigned long	root_clust;		/* First cluster in root		*/

	unsigned short	fs_sect_num;		/* FS Sector number (1) ???		*/
	unsigned short	bs_bak_sect;		/* Boot sector backup (6)		*/

	unsigned char	resrvd2[ 12 ];		/* Reserved				*/
	unsigned short	physical_drive_number;	// for use with biosread/bioswrite

	unsigned char	ext_signat;		/* Extended Boot Record signature (29h)	*/
	unsigned long	serial_number;		/* Volume serial number			*/
	unsigned char	volume_label[11];
	unsigned char	file_system_id[8];
};

void readdiskinfo( int disknum, DriveInformation* dri )
{
	// this bit is unnecessarily duplicated - maybe it could do with some
	// classes and inheritance?
	if( absread( disknum, 1, 0, &buffr[ 0 ] ) == -2 ) {
		BootSectorStructFAT32* bssp32;
		bssp32 = ( BootSectorStructFAT32* ) &buffr[ 0 ];
		dri->bytes_per_sector = bssp32->bytes_per_sector;
		dri->sectors_per_cluster = bssp32->sectors_per_cluster;
		dri->sectors_per_fat = bssp32->sectors_per_fat;

		/*short rootdirsects = ( ( bssp32->root_directory_entries ) * 32 ) / dri->bytes_per_sector;
		dri->number_of_root_dir_sectors = rootdirsects;*/

		dri->number_of_root_dir_sectors = 0;  // FAT32 root is normal directory

		// root dir is first sector after 2 FATs and boot record
		dri->dir_area_start = ( dri->sectors_per_fat * bssp32->number_of_fat_copies ) + bssp32->reserved_sectors;
		dri->root_dir_start_sector = dri->dir_area_start;
		dri->root_dir_start_sector += ( ( long ) dri->sectors_per_cluster * ( long )( bssp32->root_clust - 2 ) );
		//dri->root_dir_start_sector = ( ( long ) dri->sectors_per_cluster * ( long ) bssp32->root_clust );
		dri->fat_start_sector=bssp32->reserved_sectors;
		memcpy( dri->file_system_id, bssp32->file_system_id, 8 );
		dri->file_system_id[ 8 ] = 0;
	} else {
		BootSectorStruct* bssp;
		bssp = ( BootSectorStruct* ) &buffr[ 0 ];
		dri->bytes_per_sector = bssp->bytes_per_sector;
		dri->sectors_per_cluster = bssp->sectors_per_cluster;
		dri->sectors_per_fat = bssp->sectors_per_fat;
		short rootdirsects = ( ( bssp->root_directory_entries ) * 32 ) / dri->bytes_per_sector;
		dri->number_of_root_dir_sectors = rootdirsects;

		// root dir is first sector after 2 FATs and boot record
		dri->root_dir_start_sector = ( dri->sectors_per_fat * bssp->number_of_fat_copies ) + bssp->reserved_sectors;
		dri->dir_area_start = dri->root_dir_start_sector;
		dri->fat_start_sector = bssp->reserved_sectors;
		memcpy( dri->file_system_id, bssp->file_system_id, 8 );
		dri->file_system_id[ 8 ] = 0;
	}
	dri->drive_number = disknum;
}

// calculatechecksum: calculates the LFN checksum
// pass it the short name, padded with spaces, eg. 'PROGRA~1   '
unsigned char calculatechecksum( char* texx )
{
	unsigned char cursum = 0;

	for( int dd = 0; dd < 11; dd++ ) {
		cursum += texx[ dd ];
		if( dd >= 10 )
			break;
		//if( dd >= strlen( texx ) - 1 )
		//	break;
		unsigned char	tflag = 0;
		if( cursum & 1 )
			tflag = 0x80;
		cursum >>= 1;
		cursum |= tflag;
	}
	return cursum;
}

int matchesfilespec( char* toco )
{
	strupr( &filemask[ 0 ] );

	int	retuva = 0;
	char	*cufip;

	cufip = &filemask[ 0 ];

	char	*tocpt;
	tocpt = toco;
	//if( toco[ 0 ] == 'D' ) printf( "*" );
	//printf( "fm: '%s'  fil %s\n", filemask, toco );
	if( ( strcmp( filemask, "*." ) == 0 ) && ( strchr( toco, '.' ) == NULL ) )
		return 1; // special case: typing *. should give stuff without extnshn
	if( ( toco[ 0 ] == '.' ) && ( stricmp( filemask, "*.*" ) == 0 ) )
		return 1; // special case: . and .. entries should be found.
	while( cufip[ 0 ] != 0 ) {
		if( tocpt[ 0 ] == 0 ) {
			if( strncmp( cufip, ".*", 2 ) == 0 ) ;
			else
				if( cufip[ 0 ] == '*' ) ;
				else {
					retuva = 0;
					break;
				}
			 retuva = 1;
			 break;
		}
		char tocc = tocpt[ 0 ];
		tocc = toupper( tocc );
		//printf( "comparing mask '%s' with '%s'\n", cufip, tocpt );
		if( cufip[ 0 ] == '*' ) {
			if( cufip[ 1 ] == 0 ) {
				// allow all remaining chars
				retuva = 1;
				break;
			} else {
				char	remainingmask[ 50 ];
				strcpy( remainingmask, &cufip[ 1 ] );
				if( strchr( remainingmask, '?' ) )
					*( strchr( remainingmask, '?' ) ) = 0;
				if( strchr( remainingmask, '*' ) )
					*( strchr( remainingmask, '*' ) ) = 0;
				while( ( tocpt[ 0 ] != 0) && ( strnicmp( tocpt, remainingmask, strlen( remainingmask ) ) != 0 ) )
					tocpt++;
				//while( ( tocpt[ 0 ] != 0) && ( toupper( tocpt[ 0 ] ) != cufip[ 1 ] ) )
				//	tocpt++;
			}
			//if( ( tocpt[ 1 ] == 0 ) && ( cufip[ 2 ] == '*' ) ) { retuva = 1; break; }
			if( ( tocpt[ 0 ] == 0 ) && ( cufip[ 1 ] == '.' ) && ( cufip[ 2 ] == '*' ) ) {
				retuva = 1;
				break;
			}   // find directories with '*.*'
			if( tocpt[ 0 ] == 0 ) {
				retuva = 0;
				break;
			}
			tocpt--;
			//cufip++;
		} else
			if( ( cufip[ 0 ] != tocc ) && ( cufip[ 0 ] != '?' ) ) {
				retuva = 0;
				break;
			} else
				if( ( cufip[ 1 ] == 0 ) && ( tocpt[ 1 ] == 0 ) )
					retuva = 1;
		cufip++;
		tocpt++;
	}
	//if( ( cufip[ 0 ] == 0 ) && ( tocpt[ 0 ] == 0 ) )
	//	retuva = 1;
	return retuva;
}

void dirtodosname( char* buffr, char* _name )
{
	int	cc;

	_name[ 0 ] = 0;
	for( cc = 0; cc < 8; cc++ ) {
		if( buffr[ cc ] == ' ' ) {
			_name[ cc ] = 0;
			break;
		}
		_name[ cc ] = buffr[ cc ];
	}
	_name[ cc ] = 0;
	if( buffr[ 8 ] != ' ' ) {
		strcat( _name, "." );
		char tbuf[ 2 ];
		for( cc = 8; cc < 11; cc++) {
			if( buffr[ cc ] == ' ' )
				break;
			tbuf[ 0 ] = buffr[ cc ];
			tbuf[ 1 ] = 0;
			strcat( _name, tbuf );
		}
	}
}

#define sclus2starton( drivthing ) \
	if( sclus > 0 ) { \
		sclus -= 2; \
		if( drivthing.file_system_id[ 3 ] != '3' ) \
			starton += drivthing.number_of_root_dir_sectors; \
	} \
	starton += ( long ) sclus * ( long ) drivthing.sectors_per_cluster;

#define sclus2startonptr( drivthing ) \
	if( sclus > 0 ) { \
		sclus -= 2; \
		if( drivthing->file_system_id[ 3 ] != '3' ) \
			starton += drivthing->number_of_root_dir_sectors; \
	} \
	starton += ( long ) sclus * ( long ) drivthing->sectors_per_cluster;

/* start of FAT manipulation functions. These are disk-format dependant,
   and currently support FAT12, FAT16 and FAT32.
   To add new disk types, these need to be modified.   */

int nextinfatchain( int drii )
{
	char	buff[ 512 ];
	//if( ff->ff_reserved[ 4 ] )
	//	return -1;  // root dir limit
	DriveInformation	driv;
	readdiskinfo( drii, &driv );
	long	entryoff;
	int	halfbit = 0;
	int	fatbits = 16;
	if( strncmp( driv.file_system_id, "FAT", 3 ) != 0 ) {
		printf( "Only FAT (ie. DOS-formatted) disk drives are supported.\n" );
		exit( 1 );
	}
	if( strcmp( driv.file_system_id, "FAT16   " ) == 0 )
		entryoff = ( long ) sclus * 2;
	else if( strcmp( driv.file_system_id, "FAT12   " ) == 0 ) {
		fatbits = 12;
		//sclus -= 2;
		entryoff = ( ( long ) sclus * 3 ) / 2;
		halfbit = ( ( long ) sclus * 3 ) % 2;
	} else if( strcmp( driv.file_system_id, "FAT32   " ) == 0 ) {
		fatbits = 32;
		entryoff = ( long ) sclus * 4;
	}
	else {
		printf( "ABSLFN: Unknown file system.\n" );
		exit( 1 );
	}
	//starton = driv.root_dir_start_sector;
	starton = driv.dir_area_start;
	unsigned long sectnu = entryoff / ( long ) driv.bytes_per_sector;
	absread( drii, 1, ( long ) driv.fat_start_sector + sectnu, &buff[ 0 ] );
	//printf( "Sectnu:%u  entryoff=%ld\n", sectnu, entryoff );
	//unsigned long temm;
	long temm;
	unsigned short *temmptr;
	temmptr = ( unsigned short* ) &buff[ entryoff - ( long ) sectnu * ( long ) driv.bytes_per_sector + ( fatbits * 2 ) / 8 ];
	//printf( "temmptr: %p\n", temmptr );
	if( fatbits <= 16 )
		temm = temmptr[ 0 ];
	else {
		unsigned long *llptr;
		llptr = ( unsigned long* ) temmptr;
		temm = llptr[ 0 ];
	}
	//printf( "temm: %ld  %d ", temm, temmptr[ 0 ] );
	if( fatbits == 12 ) {
		unsigned char *chptr;
		chptr=( char* ) temmptr;
		if( halfbit == 1 )
			temm = ( ( short ) ( chptr[ 0 ] >> 4 ) ) | ( ( short) chptr[ 1 ] << 4 );
		 else
			temm = ( ( short ) chptr[ 0 ] | ( ( short ) ( chptr[ 1 ] & 0x0f ) << 8 ) );
		//temm |= temmptr[ 1 ] & bitmask[ ( fatbits - halfbit ) / 4 ];
		//printf( "temm: %d (0x%X)  ch1: %X %X\n", temm, temm, chptr[ 0 ], chptr[ 1 ] );
		if( temm == 0xfff )
			temm = 0xFFFFFFFF;  // so it recognises end-of-file
	} else if( fatbits == 16 ) {
		if( temm == 0xffff )
			temm = 0xFFFFFFFF;
	}
	//printf( "Temm=%u\n", temm ); exit( 1 );
	if( temm == 0xFFFFFFFF )
		return -1;
	sclus = temm;
	//printf( "going to sector %ld ", sclus );
	sclus2starton( driv );
	//printf( "became %ld\n", starton );
	return 0;
}

/*
short allocate_new_cluster( DriveInformation* drip )
{
	int	fatbits = 16;
	if( strcmp( drip->file_system_id, "FAT12   " ) == 0 ) {
		fatbits = 12;
	} else if( strcmp( drip->file_system_id, "FAT16   " ) == 0 ) {
		fatbits=16;
	} else if( strcmp( drip->file_system_id, "FAT32   " ) == 0 ) {
		fatbits=32;
	} else {
		printf( "unknown file system '%s'\n", drip->file_system_id );
		exit( 5 );
	}
}
*/
// end of FAT manipulation functions

int currentisdirty = 0;
//REGPACK rr;

void rereadcurrentsector( DriveInformation* dri )
{
	absread( dri->drive_number, 1, starton, &buffr[ 0 ] );
}

#pragma hdrstop
#ifndef ADIR_STANDALONE
#define CUSTOM_LFNLOADED
int lfnloaded()
{
	return 0;
}
#endif

struct REGPACK rr;

int lfnlockdrive( int drive )
{ // 0=default, 1=A, 2=B, etc
	if( lfnloaded() == 0 ) {
		if( _osmajor < 7 )
			return 1;   // no locking needed in DOS 6-
		rr.r_ax = 0x440D;
		rr.r_bx = 0x0400 + drive; // 0x0100 + drive;
		rr.r_cx = 0x084A;
		rr.r_dx = 2;  // fail all operations
		intr( 0x21, &rr );
		if( rr.r_flags & 0x0001 )
			return 0;
		return 1;
	}
	rr.r_ax = 0x440D;
	rr.r_bx = 0x0100 + drive;
	rr.r_cx = 0x084A;
	intr( 0x21, &rr );
	if( rr.r_flags & 0x0001 )
		return 0;
	rr.r_ax = 0x440D;
	rr.r_bx = 0x0200 + drive;
	rr.r_cx = 0x084A;
	intr( 0x21, &rr );
	if( rr.r_flags & 0x0001 )
		return 0;
	rr.r_ax = 0x440D;
	rr.r_bx = 0x0300 + drive;
	rr.r_cx = 0x084A;
	intr( 0x21, &rr );
	if( rr.r_flags & 0x0001 )
		return 0;
	return 1;
}

int lfnunlockdrive( int drive )
{
	if( lfnloaded() == 0 ) {
		if( _osmajor < 7 )
			return 1;   // no locking needed in DOS 6-
		rr.r_ax = 0x440D;
		rr.r_bx = drive;
		rr.r_cx = 0x086A;
		intr( 0x21, &rr );
		if( rr.r_flags & 0x0001 )
			return 0;
		return 1;
	}
	for( int tt = 0; tt < 3; tt++ ) {
		rr.r_ax = 0x440D;
		rr.r_bx = drive;
		rr.r_cx = 0x086A;
		intr( 0x21, &rr );
		if( rr.r_flags & 0x0001 )
			return 0;
	}
	return 1;
}

void writecurrentsectorif( DriveInformation* dri )
{
	if( currentisdirty ) {
		if( ( _osmajor >= 7 ) && ( dri->drive_number > 1 ) ) {
			if( lfnlockdrive( dri->drive_number + 1 ) == 0 ) {
				printf( "lock error\n" );
				exit( 7 );
			}
			/*rr.r_ax = 0x440D;
			rr.r_bx = 0x0401 + dri->drive_number;
			rr.r_cx = 0x084A;
			rr.r_dx = 2;  // fail all operations
			intr( 0x21, &rr );
			if( rr.r_flags & 0x0001 ) {
				printf( "lock error\n" );
				exit( 7 );
			}*/
		}
		abswrite( dri->drive_number, 1, starton, &buffr[ 0 ] );
		if( ( _osmajor >= 7 ) && ( dri->drive_number > 1 ) ) {
			lfnunlockdrive( dri->drive_number + 1 );
			/*rr.r_ax = 0x440D;
			rr.r_bx = dri->drive_number + 1;
			rr.r_cx = 0x086A;
			intr( 0x21, &rr );*/
		}
		currentisdirty = 0;
	}
}

int nextdirentry( DriveInformation* dri, int isroot )
{
	aa += 32;
	if( aa >= dri->bytes_per_sector ) {
		writecurrentsectorif( dri );
		starton++;
		aa = 0;
		if( endofclus == starton ) {
			if( isroot )
				return -1;
			if( nextinfatchain( dri->drive_number ) )
				return -1;
			endofclus= starton + dri->sectors_per_cluster;
		}
		absread( dri->drive_number, 1, starton, &buffr[ 0 ] );
	}
	return 0;
}

char* strbchr( char* strr, int chh )
{
	for( int hh = strlen( strr ) - 1; hh >= 0; hh-- ) {
		if( strr[ hh ] == chh )
			return &strr[ hh ];
	}
	return NULL;
}

// Includes unicode conversion table, v1.07
#include "unicode.h"

void buildlfn()
{
	char tlfn[ 32 ] = { 0 };
	tlfn[ 0 ] = 0;
	int cntl = 0, cc;
	for( cc = 1; cc < 32; cc += 2 ) {
		if( cc == 11 ) {
			cc++;
			continue;
		}
		if( cc == 26 )
			continue;

		if( buffr[ aa + cc + 1 ] ) {	// Unicode found, v1.07
			int	m;
			unsigned char b1, b2;
			b1 = buffr[ aa + cc ];
			b2 = buffr[ aa + cc + 1 ];
			for( m = 0; m < 17860; m += 2 )
				if( gb_unicode[ m ] != b1 )
					continue;
				else if( gb_unicode[ m + 1 ] == b2 )
					break;
			m >>= 1;
			b1 = 161 + m % 94;
			b2 = 160 + m / 94;
			tlfn[ cntl ] = b2;
			cntl++;
			tlfn[ cntl ] = b1;
			cntl++;
		} else {			// Normal ANSI char, v1.07
			tlfn[ cntl ] = buffr[ aa + cc ];
			cntl++;
		}
	}
	tlfn[ cntl ] = 0;
	strcpy( tempb, curlfn );
	sprintf( curlfn, "%s%s", tlfn, tempb );
	//if( ( buffr[ aa ] == 'A' ) || ( buffr[ aa ] == 1 ) )
	//	printf( "%s\n", curlfn );
}

int myfindnext( struct myffblk* ff )
{
	int	cc;
	char	*bufwas = buffr;

	buffr = &ff->bbuffr[ 0 ];
	starton = ff->bstarton;
	endofclus = ff->bendofclus;
	sclus = ff->bsclus;
	aa = ff->baa;
	// FindNext loop
	// 1: Increment pointer by size of a directory entry (32 bytes)
	debugprint( "findnext" );
	filemask = &ff->filespec[ 0 ];

	int retval = 0;
	curlfn[ 0 ] = 0;
	while( 1 ) {
		if( nextdirentry( &ff->drinfo, ff->ff_reserved[ 4 ] ) ) {
			retval = -1;
			break;
		}
		if( buffr[ aa ] == 0 ) {
			retval = -1;
			break;
		}   // end of directory
		if( buffr[ aa ] == 229 )
			continue;  // deleted file
		if( buffr[ aa + 11 ] == 0x0F ) {  // long filename
			buildlfn();
			continue;
		}
		int ttt = ( buffr[ aa + 11 ] & ff->ff_reserved[ 1 ] );
		if( buffr[ aa + 11 ] != ttt ) {
			curlfn[ 0 ] = 0;
			continue;
		}
		dirtodosname( &buffr[ aa ], ff->ff_name );
		if( curlfn[ 0 ] == 0 )
			strcpy( curlfn, ff->ff_name );
		strcpy( ff->ff_longname, curlfn );
		if( matchesfilespec( ff->ff_longname ) == 0 ) {
			if( matchesfilespec( ff->ff_name ) == 0 ) {
				curlfn[ 0 ] = 0;
				continue;
			}
		}
		ff->ff_attrib = buffr[ aa + 11 ];
		memcpy( &ff->ff_fsize, &buffr[ aa + 28 ], 4 );
		memcpy( &ff->ff_fdate, &buffr[ aa + 24 ], 2 );
		memcpy( &ff->ff_ftime, &buffr[ aa + 22 ], 2 );
		memcpy( &ff->ff_adate, &buffr[ aa + 18 ], 2 );
		curlfn[ 0 ] = 0;
		break;
	}
	ff->bstarton = starton;
	ff->bendofclus = endofclus;
	ff->bsclus = sclus;
	ff->baa = aa;
	buffr = bufwas;
	return retval;
}

char	shortnameof[ 80 ];
char	longnameof[ 200 ];

unsigned long findclusterof( struct myffblk* ff, char* cursd )
{
	//char cursd[ 80 ];
	//getcwd( cursd, 80 );
	//printf( "findclusterof: %s\n", cursd );

	char	*tppt;
	tppt = &cursd[ 3 ];  // skip "C:\"
	ff->ff_reserved[ 4 ] = 1;
	unsigned long clusnum = 0;
	//int drivnum = cursd[ 0 ] - 'A';
	int drivnum = ff->ff_reserved[ 3 ];

	DriveInformation driv;
	readdiskinfo( drivnum, &driv );
	if( strcmp( driv.file_system_id, "FAT32   " ) == 0 )
		ff->ff_reserved[ 4 ] = 0;  // root dir is normal on fat32
	sprintf( shortnameof, "%c:", drivnum + 'A' );
	strcpy( longnameof, shortnameof );

	starton = driv.root_dir_start_sector;
	absread( drivnum, 1, starton, &buffr[ 0 ] );
	endofclus = starton + driv.number_of_root_dir_sectors;
	if( ff->ff_reserved[ 4 ] == 0 ) { // num_root_dir_sect is invalid on Fat32
		endofclus += driv.sectors_per_cluster;
		clusnum = ( ( driv.root_dir_start_sector - driv.dir_area_start ) / ( long ) driv.sectors_per_cluster ) + 2;
	}
	aa =- 32;
	curlfn[ 0 ] = 0;

	char	*eoli = strchr( tppt, '\\' );
	if( eoli != NULL )
		eoli[ 0 ] = 0;
	if( tppt[ 0 ] == 0 ) {
		strcat( shortnameof, "\\" ); // it's the root dir
		strcat( longnameof, "\\" );
	}
	while( tppt[ 0 ] != 0 ) {
		if( nextdirentry( &driv, ff->ff_reserved[ 4 ] ) ) {
			clusnum = -1;
			break;
		}
		if( buffr[ aa ] == 0 ) {
			clusnum = -1;
			break;
		}
		if( buffr[ aa ] == 229 )
			continue;
		if( buffr[ aa + 11 ] == 0x0f ) {
			buildlfn();
			continue;
		}
		if( ( buffr[ aa + 11 ] & FA_DIREC ) == 0 ) {
			curlfn[ 0 ] = 0;
			continue;
		}
		char	ddbuf[ 15 ];
		dirtodosname( &buffr[ aa ], ddbuf );
		//printf( "fnd: %s\n", ddbuf );
		//printf( "tppt: '%s'  curlfn: '%s'\n", tppt, curlfn );
		if( ( stricmp( ddbuf, tppt ) == 0 ) || ( stricmp( tppt, curlfn ) == 0 ) ) {
			ff->ff_reserved[ 4 ] = 0;
			strcat( shortnameof, "\\" );
			strcat( shortnameof, ddbuf );
			strcat( longnameof, "\\" );
			if( curlfn[ 0 ] != 0 )
				strcat( longnameof, curlfn );
			else
				strcat( longnameof, ddbuf );
			unsigned short stmp = *( short* ) &buffr[ aa + 26 ];
			clusnum = stmp;
			if( strcmp( driv.file_system_id, "FAT32   " ) == 0 ) {
				unsigned short scnd = *( short* ) &buffr[aa + 20 ];
				clusnum |= ( ( long ) scnd ) << 16L;
			}
			if( eoli != NULL )
				eoli[ 0 ] = '\\';
			else
				break;
			tppt = eoli + 1;
			eoli = strchr( tppt, '\\' );
			if( eoli != NULL )
				eoli[ 0 ] = 0;
			//starton = driv.root_dir_start_sector;
			starton = driv.dir_area_start;
			sclus = clusnum;
			sclus2starton( driv );
			absread( drivnum, 1, starton, &buffr[ 0 ] );
			aa = -32;
			endofclus = starton + driv.sectors_per_cluster;
			//printf( "clus: %ld\n", starton );
		}
		curlfn[ 0 ] = 0;
	}
	if( shortnameof[ strlen( shortnameof ) - 1 ]== ':' )
		strcat( shortnameof, "\\" );
	if( longnameof[ strlen( longnameof ) - 1 ] == ':' )
		strcat( longnameof, "\\" );
	return clusnum;
}

int mychdir( char* newdir )
{
	if( lfnchdir == 0 )
		return chdir( newdir );
	rr.r_ax = 0x713B;
	rr.r_ds = FP_SEG( newdir );
	rr.r_dx = FP_OFF( newdir );
	rr.r_flags = 1;
	intr( 0x21,&rr );
	if( rr.r_flags & 1 )
		return -1;
	return 0;
}

char tempcpwas[ 100 ];

int myfindfirst( char* pathn, int attrib, struct myffblk* ff )
{
	strupr( pathn );
	errno = 0;
	debugprint( "in findfirst" );
	//printf( "req: '%s' ", pathn );
	char	*curptt;
	curptt = pathn;

	// 1. Parse path name, obtain drive letter if present
	int	olddrive = getdisk();
	char	tempcurpat[ 80 ];
	filemask = &ff->filespec[ 0 ];
	if( curptt[ 1 ] == ':' ) {
		setdisk( curptt[ 0 ] - 'A' );
		if( getdisk() != ( curptt[ 0 ] - 'A' ) ) {
			errno = EINVDRV;
			return -1;
		}
	}
	char	oridirec[ 80 ];
	getcwd( oridirec, 80 );
	//printf( "oridi: '%s'", oridirec );
	if( ( curptt[ 2 ] == '\\' ) && ( curptt[ 1 ] == ':' ) )
		strcpy( tempcurpat, curptt );
	else
		if( curptt[ 0 ] == '\\' )
			sprintf( tempcurpat, "%c:%s", getdisk() + 'A', curptt );
		else {
			if( curptt[ 1 ] == ':' )
				curptt += 2;
			getcwd( tempcurpat, 80 );
			if( tempcurpat[ strlen( tempcurpat ) - 1 ] != '\\' )
				strcat( tempcurpat, "\\" );
			strcat( tempcurpat, curptt );
		}

	//printf( "tempcurpat: '%s'\n", tempcurpat );
	ff->ff_reserved[ 3 ] = getdisk();
	strcpy( tempcpwas, tempcurpat );
	findclusterof( ff, tempcurpat );

	// determine if the path or file wasn't found
	//printf( "shortn: '%s' tempcurpat: '%s'\n", shortnameof, tempcpwas );
	char	*lastslash = strbchr( tempcpwas, '\\' );
	if( lastslash == NULL ) ;
	else
		if( stricmp( shortnameof, tempcpwas ) == 0) ; // both full dir paths
		else {
			int	numslash = 0, uu, numslte = 0;
			for( uu = 0; uu < strlen( shortnameof ); uu++ ) {
				if( shortnameof[ uu ] == '\\' )
					numslash++;
			}
			for( uu = 0; uu < strlen( tempcpwas ); uu++ ) {
				if( tempcpwas[ uu ] == '\\' )
					numslte++;
			}
			if( lastslash[ -1 ] == ':' )
				numslash--;
			if( numslash != numslte - 1 ) {
				errno = ENOPATH;
				setdisk( olddrive );
				return -1;
			}
			//printf( "shortname: '%s'\n", shortnameof );
			strcpy( filemask, "*.*" );
			char	*sss = strbchr( shortnameof, '\\' );
			// we check if the supplied name is a directory, and if it is, then
			// append \*.* to it to list the contents.
			// But first, we check if they want to find directories, in which case
			// we don't do this.
			if( chdir( shortnameof ) ) {
				if( sss != NULL ) {
					sss[ 0 ] = 0;
					if( chdir( shortnameof ) ) {
						chdir( oridirec );
						//errno = ENOPATH;
						return -1;
					}
					strcpy( filemask, sss + 1 );
				} else {
					chdir( oridirec );
					//errno = ENOPATH;
					return -1;
				}
			}
		}

	char	*srt = strbchr( pathn, '\\' );
	if( srt == NULL )
		srt = strbchr( pathn, ':' );
	if( srt == NULL )
		strcpy( filemask, pathn );
	else
		strcpy( filemask, srt + 1 );
	int gg = strlen( shortnameof ) - strlen( filemask );
	// This line below causes problem if mask is parent directory name
	// Actually, I can't remember what this line is for
	if( ( stricmp( filemask, &shortnameof[ gg ] ) == 0 ) && ( shortnameof[ gg - 1 ] == '\\' ) )
		strcpy( filemask, "*" );

	// 2. do other stuff that needs to be in correct directory
	ff->ff_reserved[ 3 ] = getdisk();
	DriveInformation	drin;
	readdiskinfo( ff->ff_reserved[ 3 ], &drin );
	//printf( "bps: %d  buf: %d\n", drin.bytes_per_sector, BUFFERSIZE );
	if( drin.bytes_per_sector > BUFFERSIZE ) {
		printf( "Too many bytes/sector\n" );
		return -1;
	}
	memcpy( &ff->drinfo, &drin, sizeof( DriveInformation ) );

	ff->ff_reserved[ 0 ] = drin.bytes_per_sector;
	ff->ff_reserved[ 2 ] = drin.sectors_per_cluster;
	ff->ff_reserved[ 5 ] = drin.number_of_root_dir_sectors;

	attrib |= FA_ARCH | FA_RDONLY;
	ff->ff_reserved[ 1 ] = attrib;

	char thisdir[ 80 ];
	getcwd( thisdir, 79 );
	//sclus = findclusterof(ff,thisdir);
	debugprint( "3" );

	// 3. restore original drive and directory
	//printf( "oridirec: '%s'\n", oridirec );
	setdisk( olddrive );
	mychdir( oridirec );
	//mychdir( tempcurpat );
	//free( tempcurpat );

	debugprint( "4" );
	ff->ff_reserved[ 4 ] = resetdirectory( &drin, thisdir );
	aa = -32;
	curlfn[ 0 ] = 0;
	ff->bstarton = starton;
	ff->bendofclus = endofclus;
	ff->bsclus = sclus;
	ff->baa = aa;
	memcpy( ff->bbuffr, buffr, BUFFERSIZE );

	debugprint( "5" );
	return myfindnext( ff );
	//return 0;
}

int resetdirectory( DriveInformation* drip, char* dirna )
{
	char	dirname[ 80 ];
	//printf( "resetdirfor: '%s' ", dirna );
	debugprint( "a" );
	_getdcwd( drip->drive_number + 1, dirname, 80 );
	if( ( dirna[ 1 ] == ':' ) && ( dirna[ 2 ] == '\\' ) )
		strcpy( dirname, dirna );
	else
		if( dirna[ 1 ] == ':' ) {
			if( dirna[ 2 ] != 0 ) {
				if( dirname[ strlen( dirname ) - 1 ] != '\\' )
					strcat( dirname, "\\" );
				strcat( dirname, &dirna[ 2 ] );
			}
		} else
			if( dirna[ 0 ] == '\\' )
				sprintf( dirname, "%c:%s", drip->drive_number + 'A', dirna );
			else
				if( dirna[ 0 ] == 0) ;
				else {
					if( dirname[ strlen( dirname ) - 1 ] != '\\' )
						strcat( dirname, "\\" );
					strcat( dirname, dirna );
				}
	//printf( "resetdir: %s\n", dirname );

	debugprint( "b" );
	myffblk ffb;
	ffb.ff_reserved[ 3 ] = drip->drive_number;
	sclus = findclusterof( &ffb, dirname );
	if( sclus == ( ( unsigned long ) -1 ) )
		return -1;
	// root dir is first sector after FATs and boot record
#ifdef LFNDOS_BETA
	printf( "startonnow: %ld  ", starton );
	printf( "tocluster %ld  dirarea: %ld  rootdir: %ld\n", sclus, drip->dir_area_start, drip->root_dir_start_sector );
#endif
	starton = drip->dir_area_start;
	//starton = drip->root_dir_start_sector;
	sclus2startonptr( drip );

	debugprint( "c" );
	//printf( "cluster: %ld \n", starton );
	// read in the first sector of the directory
	absread( ffb.ff_reserved[ 3 ], 1, starton, &buffr[ 0 ] );
	if( ffb.ff_reserved[ 4 ] == 1 )
		endofclus = starton + drip->number_of_root_dir_sectors;
	else
		endofclus = starton + drip->sectors_per_cluster;

	debugprint( "d" );
	aa = -32;
	return ffb.ff_reserved[ 4 ];
}

// WRITING FUNCTIONS ---------------------------------

char	*direntryimage;

void createdirectoryentry( char*, int = 0 );

int	foundondrive, isrootdir;

int findfreeentries( char* directry, int numentry )
{
	int	disknum = 0;
	if( directry[ 1 ] != ':' )
		disknum = getdisk();
	else {
		disknum = directry[ 0 ] - 'A';
		if( directry[ 0 ] >= 'a' )
			disknum = ( directry[ 0 ] -'a' );
	}
	DriveInformation driv;
	readdiskinfo( disknum, &driv );
	isrootdir = resetdirectory( &driv, directry );
	if( isrootdir < 0 )
		return -1;

	int	consecfound = 0;
	int	entrynum = 0, foundnum = -1, amhere = 0;

	while( 1 ) {
		// BUG: This will not create a new sector if directory overflows
		entrynum++;
		if( nextdirentry( &driv, isrootdir ) )
			break;
		if( foundnum == entrynum) {
			amhere = 1;
			break;
		}
		if( ( buffr[ aa ] == 0 ) || ( buffr[ aa ] == 229 ) )
			consecfound++;
		else {
			consecfound = 0;
			continue;
		}
		if( consecfound < numentry )
			continue;

		// ok, we found the consecutive free entries
		foundnum = ( entrynum - consecfound ) + 1;
		entrynum = 0;
		// reset the directory, this time go to the gap found.
		isrootdir = resetdirectory( &driv, directry );
	}
	foundondrive = driv.drive_number;
	if( amhere ) {
		//printf( "Found entry at sector %ld offset %d: %X %X\n", starton, aa, buffr[ aa ], buffr[ aa + 1 ] );
		return 0;
	} else {
		printf( "LFNDOS: couldn't create directory entry\n" );
		return -1;
	}
}

// findentry - see if the file "directry" exists, and if so copy it's
// short name equivalent into shortform

unsigned char	*direntryptr;
DriveInformation driv;
int	attrsfound = 0;

int findentry( char* directry, char* shortform, int rewind = 0 )
{
	int	disknum = 0;
	if( directry[ 1 ] != ':' )
		disknum = getdisk();
	else {
		disknum = ( directry[ 0 ] - 'A' );
		if( directry[ 0 ] >= 'a' )
			disknum = ( directry[ 0 ] - 'a' );
	}
	readdiskinfo( disknum, &driv );

	int	resetindx = -1, itwas;
	// printf( "direc: '%s' ", directry );
	char	*filnam = strbchr( directry, '\\' );
	if( filnam == NULL ) {
		filnam = strchr( directry, ':' );
		if( filnam != NULL )
			filnam++;
		else
			filnam = &directry[ 0 ];
		resetindx = 0;
	} else {
		filnam++;
		resetindx = -1;
		if( ( filnam == directry + 1 ) || ( filnam[ -2 ] == ':' ) )
			resetindx = 0;  // it's C:\, so don't erase the \
	}

	/*if( filnam != &directry[ 0 ] )
		resetindx = -1;
	else
		resetindx = 0;*/
	itwas = filnam[ resetindx ];
	filnam[ resetindx ] = 0;  // reset directory doesn't like having a filename on the end

	isrootdir = resetdirectory( &driv, directry );
	filnam[ resetindx ] = itwas;

	attrsfound = 0;
	int	foundentry = 0;
	curlfn[ 0 ] = 0;
	//aa = -32;
	int	entrynum = 0, foundat = -1;
	int	lastlfnstart = 0;
	//printf( "in findentry for '%s'\n", directry );
	while( 1 ) {
		// BUG: This will not create a new sector if directory overflows
		if( nextdirentry( &driv, isrootdir ) )
			break;
		if( buffr[ aa ] == 229 )
			continue;
		if( buffr[ aa ] == 0 )
			break;
		entrynum++;
		if( entrynum == foundat )
			break;
		if( buffr[ aa + 11 ] == 0x0f ) {
			if( lastlfnstart == 0 )
				lastlfnstart = entrynum;
			buildlfn();
			continue;
		}
		char	ddbuf[ 15 ];
		dirtodosname( &buffr[ aa ], ddbuf );
		//printf( "fnd: '%s'\n", ddbuf );
		if( ( stricmp( ddbuf, filnam ) == 0 ) || ( stricmp( curlfn, filnam ) == 0 ) ) ;
		else {
			curlfn[ 0 ] = 0;
			lastlfnstart = 0;
			continue;
		}
		// we found the file entry
		foundat = ( lastlfnstart == 0 ) ? entrynum : lastlfnstart;
		foundentry = 1;
		direntryptr = &buffr[ aa ];
		if( shortform != NULL ) {
			strcpy( shortform, shortnameof );
			if( shortform[ strlen( shortform ) - 1 ] != '\\' )
				strcat( shortform, "\\" );
			strcat( shortform, ddbuf );
		}
		curlfn[ 0 ] = 0;
		attrsfound = buffr[ aa + 11 ];
		//printf( "fnd: entry %d\n", entrynum );
		if( rewind ) {  // go back to the gap found
			//printf( "rewinding.\n" );
			filnam[ resetindx ] = 0;  // reset directory doesn't like having a filename on the end
			isrootdir = resetdirectory( &driv, directry );
			entrynum = 0;
			filnam[ resetindx ] = itwas;
		} else
			break;
		lastlfnstart = 0;
	}
	//printf( "broke on entry %d\n", entrynum );
	return foundentry;
}

int deletefile( char* filnaa )
{
	char	shorteq[ 80 ];
	errno = 0;
	attrsfound = 0;
	if( findentry( filnaa, shorteq, 1 ) == 0 ) {
		errno = ENOFILE;
		return 0;
	}
	if( attrsfound & FA_DIREC ) {
		if( rmdir( shorteq ) != 0 )
		return 0;
	} else
		if( unlink( shorteq ) )
		return 0;
	//printf( "ghe buf[0]=%X ", buffr[ aa ] );
	//printf( "shortname:'%s' ", shorteq );

	rereadcurrentsector( &driv );
	while( ( buffr[aa + 11 ] == 0x0f ) && ( buffr[ aa ] != 229 ) ) {
		buffr[ aa ] = 229;  // mark as erased
		currentisdirty = 1;
		if( nextdirentry( &driv, isrootdir ) )
			break;
	}
	writecurrentsectorif( &driv );
	return 1;
}

myffblk		mfgl;

int delete_wildcards( char* fil )
{
	//printf( "delwild: '%s'\n", fil );
	int	ddd = myfindfirst( fil, 0, &mfgl );
	char	tbfr[ 250 ];
	if( ddd )
		return 0;
	int	succeeded = 0, ourerr = 0;
	errno = 0;
	while( ddd == 0 ) {
		if( strchr( fil, '\\' ) != NULL ) {
			char	*ppp = strbchr( fil, '\\' );
			int	wass = ppp[ 0 ];
			ppp[ 0 ] = 0;
			sprintf( tbfr, "%s\\%s", fil, mfgl.ff_name );
			ppp[ 0 ] = wass;
		} else
			if( fil[ 1 ] == ':' )
				sprintf( tbfr, "%c:%s", fil[ 0 ], mfgl.ff_name );
			else
				strcpy( tbfr, mfgl.ff_name );
		//printf( "delting: '%s'\n", tbfr );
		if( deletefile( tbfr ) )
			succeeded++;
		ourerr = errno;
		ddd = myfindnext( &mfgl );
		//myfindfirst( fil, 0, &mfgl );
	}
	if( succeeded == 0 ) {
		errno = ourerr;
		return 0;
	}
	/*if( succeeded == 0 ) {
		errno = EACCES;
		return 0;
	}  // no files were deleted (because R/O, etc)*/
	return 1;
}

int make_directory( char* longna )
{
	char	shorteq[ 80 ];

	if( findentry( longna, shorteq ) != 0 ) {
		errno = EEXIST;
		return 0;
	}  // already exists
	shorteq[ 0 ] = 0;
	if( ( longna[ 0 ] == '\\' ) && ( strchr( &longna[ 1 ], '\\' ) == NULL ) )
		shorteq[ 0 ] = 0;
	else
		if( ( longna[ 1 ] == ':' ) && ( longna[ 2 ] == '\\' ) && ( strchr( &longna[ 3 ], '\\' ) == NULL ) )
			sprintf( shorteq, "%c:", longna[ 0 ] );
		else
			if( strchr( longna, '\\' ) != NULL ) {
				char *offso = strbchr( longna, '\\' );
				offso[ 0 ] = 0;
				if( findentry( longna, shorteq, 1 ) == 0 ) { // parent not found
					errno = ENOPATH;
					return 0;
				}
				offso[ 0 ] = '\\';
			} else
				if( longna[ 1 ] == ':' )
					sprintf( shorteq, "%c:", longna[ 0 ] );
				else
					strcpy( shorteq, "." );

	// create a temporary directory so DOS will allocate the FAT chain
	char	otemp[ 80 ];
	sprintf( otemp, "%s\\__lfndos", shorteq );
	//printf( "make directory '%s'\n", otemp );
	if( mkdir( otemp ) != 0 ) {
		errno = ENOENT;
		return 0;
	}
	if( strncmp( otemp, ".\\", 2 ) == 0 )
		memmove( otemp, &otemp[ 2 ], strlen( otemp ) - 1 );
	if( findentry( otemp, NULL, 1 ) == 0 ) {
		printf( "LFNDOS: Internal error MD001\n" );
		exit( 6 );
	}
	//fwrite( &buffr[aa], 32, 1, stderr );
	char	deimage[ 32 ];
	memcpy( deimage, &buffr[ aa ], 32 );
	direntryimage = &deimage[ 0 ];

	// erase the original __lfndos entry
	buffr[ aa ] = 0xe5;
	currentisdirty = 1;
	writecurrentsectorif( &driv );

	//printf( "creating: '%s'\n", longna );
	createdirectoryentry( longna, 1 );
	return 1;
}

int renamefile( char* oldd, char* neew )
{
	char	shorteq[ 80 ];
	if( findentry( neew, shorteq ) != 0 )
		return -2;  // already exists
	char	copyofentry[ 32 ];
	if( findentry( oldd, shorteq, 1 ) == 0 )
		return -1;
	while( buffr[ aa + 11 ] == 0x0f ) {
		buffr[ aa ] = 229;
		currentisdirty = 1;
		if( nextdirentry( &driv, isrootdir ) )
			break;
	}
	memcpy( copyofentry, &buffr[ aa ], 32 );  // back up the entry
	direntryimage = &copyofentry[ 0 ];
	buffr[ aa ] = 229;
	currentisdirty = 1;
	writecurrentsectorif( &driv );
	createdirectoryentry( neew, 1 );
	return 0;
}

// isallowedchar: This function determines whether a given character is
// allowed in a DOS file name

int	resetallowed = 0;

int isallowedchar( byte chh )
{
	if( ( chh >= '@' ) && ( chh <= 'Z' ) )
		return 1;
	if( ( chh >= 'a' ) && ( chh <= 'z' ) )
		return 1;
	if( ( chh >= '0' ) && ( chh <= '9' ) )
		return 1;
	if( ( chh >= 161 ) && ( chh <= 254 ) )  // GB2312 charset, v1.07
		return 1;
	if( chh == '_' )
		return 1;
	if( chh == '-' )
		return 1;
	if( ( chh >= 33 ) && ( chh <= 45 ) )
		return 1;  // various symbols are allowed
	if( ( chh == '.' ) && ( resetallowed == 1 ) ) {  // only allow one .
		resetallowed--;
		return 1;
	} else
		if( ( chh == '.' ) && ( resetallowed > 1 ) ) {
			resetallowed--;
			return 0;
		}
	return 0;
}

void generateshortname( byte* fillnori, int indexx, byte* shortnam )
{
	char	filln[ 80 ];
	int	newind = 0, filin = 0;

	resetallowed = 0;
	int numdots;
	for( newind = 0; newind < strlen( fillnori ); newind++ ) {
		if( fillnori[ newind ] == '.' )
			resetallowed++;
	 }
	newind = 0;
	while( fillnori[ filin ] != 0 ) {
		// Unicode allowed, v1.07
		if( isallowedchar( fillnori[ filin ] ) && ( fillnori[ filin ] < 128 ) ) {
			filln[ newind ] = fillnori[ filin ];
			newind++;
		}
		filin++;
	}
	filln[ newind ] = 0;
	//char	*pointptr = strbchr( fillnori, '.' );
	char	*pointptr = strbchr( filln, '.' );
	if( pointptr != NULL )
		pointptr[ 0 ] = 0;
	char	newname[ 13 ];
	strncpy( newname, filln, 8 );
		newname[ 8 ] = 0;
	char	tailbit[ 5 ];
		sprintf( tailbit, "~%d", indexx );
	int	useoffs = 0;
	if( strlen( newname ) + strlen( tailbit ) <= 8 )
		useoffs = strlen( newname );
	else
		useoffs = 8 - strlen( tailbit );
	if( indexx > 0 )
		strcpy( &newname[ useoffs ], tailbit );
	if( pointptr != NULL )
		pointptr[ 0 ] = '.';
	if( pointptr != NULL ) {
		pointptr++;
		strcat( newname, "." );
		int	oldlen = strlen( newname );
		strncpy( &newname[ oldlen ], pointptr, 3 );
		newname[ oldlen + 3 ] = 0;
	}
	strcpy( shortnam, newname );
	//printf( "shortname: %s\n", shortnam );
}

void getdate2filedate( date* datt, short* fildat )
{
	if( ( datt->da_year < 1980 ) || ( datt->da_year > 2100 ) ) {
		printf( "invalid date (1980 < date < 2100)\n" );
		exit( 9 );
	}
	fildat[ 0 ] = ( datt->da_year - 1980 ) << 9;
	fildat[ 0 ] |= datt->da_mon << 5;
	fildat[ 0 ] |= datt->da_day;
}

void gettime2filetime( struct time* tii, short* filtim )
{
	filtim[ 0 ] = tii->ti_hour << 11;
	filtim[ 0 ] |= tii->ti_min << 5;
	filtim[ 0 ] |= tii->ti_sec >> 1;
}

void dostodirname( char* shortname, char* destdirname )
{
	unsigned char	dirshortname[ 12 ] = "           ";
	for( int jj = 0; jj < 8; jj++ ) {
		if( shortname[ jj ] == '.' )
			break;
		if( shortname[ jj ] == 0 )
			break;
		dirshortname[ jj ] = shortname[ jj ];
	}
	if( shortname[ jj ] == '.' )
		jj++;
	int	jjwas = jj;
	for( ; jj < jjwas + 3; jj++ ) {
		if( shortname[ jj ] == 0 )
			break;
		dirshortname[ ( jj - jjwas ) + 8 ] = shortname[ jj ];
	}
	memcpy( destdirname, dirshortname, 11 );
}

int w_strlen( byte* str )
{
	int	i, len = strlen( str ), res = 0;

	for( i = 0; i < len; i++ )
		if( str[ i ] > 128 )
			res++;
	res >>= 1;
	return( len - res );
}

//#define DEBUG_CREATE

char generatedshortname[ MAXDIRLEN ];

void createdirectoryentry( char* filln, int useimage )
{
	int	entriesneeded = 0;

	generatedshortname[ 0 ] = 0;
	//printf( "create: '%s'\n", filln );
	char	*oldfilln = filln;
	filln = strbchr( oldfilln, '\\' );
	if( filln == NULL )
		filln = oldfilln;
	else
		filln++;

	char	tempbu[ 80 ];
	char	shortname[ 15 ];
	int	notruncate = 0;
	if( filln[ 1 ] == ':' )
		filln += 2;  // don't include directory names
	if( strchr( filln, '\\' ) != NULL )
		filln = strchr( filln, '\\' ) + 1;

	if( ( strlen( filln ) > 8 ) && ( strchr( filln, '.' ) == NULL ) ) ;
	else
		// Considering unicode, v1.07
		if( w_strlen( filln ) < 13 ) {
			resetallowed = 1;
		for( int ii = 0; ii < strlen( filln ); ii++ )
			if( isallowedchar( filln[ ii ] ) == 0 )
				notruncate = 2;
		char	*tptt = strchr( filln, '.' );
		if( notruncate == 2 )
			notruncate = 0;
		else
			if( ( tptt != NULL ) && ( strlen( &tptt[ 1 ] ) > 3 ) ) ;  // like abc.longext
			else
				if( ( tptt != NULL ) && ( ( &tptt[ 0 ] - &filln[ 0 ] ) > 8 ) ) ; // like nineletrs.a
				else
					notruncate = 1;
	}
	int	genindex = 0;
	if( notruncate ) {
		strcpy( tempbu, filln );
		strupr( tempbu );
		if( strcmp( tempbu, filln ) == 0 )
			entriesneeded = 1;
		else
			entriesneeded = 2;
		strcpy( shortname, tempbu );
	} else {
		genindex = 1;
		// Considering unicode, v1.07
		entriesneeded = ( w_strlen( filln ) / 13 ) + 2;
		if( w_strlen( filln ) % 13 == 0 )
			entriesneeded--;
		generateshortname( filln, genindex, shortname );
	}

	ffblk	fft;
	int	dunn;
	//printf( "generated: '%s'\n", generatedshortname );

	if( filln[ 0 ] == '\\' )
		filln[ 0 ] = 0;
	int	wasok;
	if( strchr( oldfilln, '\\' ) == NULL ) {
		char	tempst[ 5 ] = "\0";
		if( oldfilln[ 1 ] == ':' )
			sprintf( tempst, "%c:", oldfilln[ 0 ] );
		wasok = findfreeentries( tempst, entriesneeded );
	} else {
		char	*lastone = strbchr( oldfilln, '\\' );
		int	indx = 0;
		if( lastone == oldfilln )
			indx = 1;  // absolute path (eg.  \WINDOWS)
		else
			if( ( lastone == oldfilln + 2 ) && ( oldfilln[ 1 ] == ':' ) )
				indx = 1;
		char	itwas = lastone[ indx ];
		lastone[ indx ] = 0;   // don't give filename, path only
		//printf( "passing: '%s'\n", oldfilln );
		wasok = findfreeentries( oldfilln, entriesneeded );
		lastone[ indx ] = itwas;
	}
	if( filln[ 0 ] == 0 )
		filln[ 0 ] = '\\';
	if( shortnameof[ strlen( shortnameof ) - 1 ] != '\\' )
		strcat( shortnameof, "\\" );

	do {
		char	newnam[ MAXDIRLEN ];
		sprintf( newnam, "%s%s", shortnameof, shortname );
		//printf("prop: '%s'\n",newnam);
		strcpy( generatedshortname, newnam );
		dunn = findfirst( newnam, &fft, 0 );
		if( dunn )
			break;
		genindex++;
		generateshortname( filln, genindex, shortname );
	} while( !dunn );
	//strcpy( generatedshortname, shortname );

#ifdef DEBUG_CREATE
	printf( "entries: %d   short name: '%s' fail:%d\n", entriesneeded, shortname, wasok );
#endif
	if( wasok ) {
		generatedshortname[ 0 ] = 0;
		return;
	}  // failed for some reason
	strupr( shortname );

	// the globals are set up in the right place now
	DriveInformation	driv;
	unsigned char   b1, b2;
	unsigned int	m1, m2, m;
	readdiskinfo( foundondrive, &driv );
	rereadcurrentsector( &driv );
	// generate the space-padded name
	char	dirshortname[ 15 ] = { 0 };
	dostodirname( shortname, dirshortname );
	// make the directory entries
	DirectoryEntry*		dirent;
	LFNDirectoryEntry*	lfnent;
	int			myindex = 0;
	for( int ii = 0; ii < entriesneeded; ii++ ) {
		memset( &buffr[ aa ], 0, 32 );
		memset( &buffr[ aa ], ' ', 11 );
		if( ( ii == entriesneeded - 1 ) && ( useimage == 2 ) )
			memcpy( &buffr[ aa ], direntryimage, 32 );
		else if( ( ii == entriesneeded - 1 ) && ( useimage == 1 ) ) {
			//printf( "dont overwrite name.\n" );
			memcpy( &buffr[ aa ], direntryimage, 32 );  // don't overwrite name
			strncpy( &buffr[ aa ], dirshortname, 11 );
		} else if( ii == entriesneeded - 1 ) {  // actual directory entry
				dirent = ( DirectoryEntry* ) &buffr[ aa ];
				strcpy( dirent->filename, dirshortname );
				date		curdate;
				struct time	curtim;
				getdate( &curdate );
				gettime( &curtim );
				getdate2filedate( &curdate, &dirent->modify_date );
				gettime2filetime( &curtim, &dirent->modify_time );
				dirent->creat_date = dirent->modify_date;
				dirent->creat_time = dirent->modify_time;
				dirent->access_date = dirent->modify_date;
				dirent->attrib = 0;  // take this line out and watch FAT32 die!
/*
				printf( "\ncurentry: " );
				int	jj;
				for( jj = 0; jj < 32; jj++ )
					printf( "%02X ", buffr[ aa + jj ] );
*/
			} else {   // an LFN entry
				memset( &buffr[ aa ], 0xff, 32 );
				lfnent = ( LFNDirectoryEntry* ) &buffr[ aa ];
				int	thisindex = ( entriesneeded - 1 ) - ii;
				lfnent->index = thisindex;
				if( ii == 0 )
					lfnent->index |= 0x40;   // first entry
					lfnent->attrib = 0x0f;
					lfnent->startcluster = 0;
					lfnent->reserved = 0;
					//thisindex = ( thisindex - 1 ) * 13;
					for( int kk = 0; kk < 13; kk++ ) {
						// GB2312 -> Unicode Conversion, v1.07
						if( kk < 5 ) {
							b1 = filln[ myindex ];
							if( b1 >= 160 && b1 <= 254 ) {
								b2 = filln[ myindex + 1 ];
								m1 = b1 - 160;
								m2 = b2 - 161;
								m1 = m1 * 94;
								m1 += m2;
								m1 <<= 1;
								b1 = gb_unicode[ m1 ];
								b2 = gb_unicode[ m1 + 1 ];
								m1 = b2;
								m1 <<= 8;
								m1 |= b1;
								lfnent->name1[ kk ] = m1;
								myindex++;
							} else
								lfnent->name1[ kk ] = filln[ myindex ];
						} else if( kk < 11 ) {
							b1 = filln[ myindex ];
							if( b1 >= 160 && b1 <= 254 ) {
								b2 = filln[ myindex + 1 ];
								m1 = b1 - 160;
								m2 = b2 - 161;
								m1 = m1 * 94;
								m1 += m2;
								m1 <<= 1;
								b1 = gb_unicode[ m1 ];
								b2 = gb_unicode[ m1 + 1 ];
								m1 = b2;
								m1 <<= 8;
								m1 |= b1;
								lfnent->name2[ kk - 5 ] = m1;
								myindex++;
							} else
								lfnent->name2[ kk - 5 ] = filln[ myindex ];
						} else {
							b1 = filln[ myindex ];
							if( b1 >= 160 && b1 <= 254 ) {
								b2 = filln[ myindex + 1 ];
								m1 = b1 - 160;
								m2 = b2 - 161;
								m1 = m1 * 94;
								m1 += m2;
								m1 <<= 1;
								b1 = gb_unicode[ m1 ];
								b2 = gb_unicode[ m1 + 1 ];
								m1 = b2;
								m1 <<= 8;
								m1 |= b1;
								lfnent->name3[ kk - 11 ] = m1;
								myindex++;
							} else
								lfnent->name3[ kk - 11 ] = filln[ myindex ];
						}
						if( filln[ myindex ] == 0 )
							break;
						myindex++;
					}
					lfnent->checksum = calculatechecksum( dirshortname );
			}
		currentisdirty = 1;
		//printf( "entry created.\n" );
		if( nextdirentry( &driv, isrootdir ) )
			break;
	}
	writecurrentsectorif( &driv );
}
