unit FnFont2;
{ FNfont2 
  Tato unita se zabyva vsemi problemy spojenymi s vystupem textu a praci s
  fonty. Klicovou funkci je procedura "Print_FN", ktera ma dva rezimy cin-
  nosti: automaticky a rucni. Prepinacem je promenna FN_ignore.
  Pokud jsi v rucnim rezimu, je tvoje starost, abys dal procedure Print_FN
  nahrany font. Pokud jsi v automatickem rezimu, parametr FONT se naopak
  ignoruje a vse se ridi podle promenne FN_Font (string). System si fonty sam
  kontroluje a dynamicky nahrava. V automatickem rezimu muzes pouzivat zmenu
  fontu ZA LETU.
  Problemy muze delat Y-souradnice u procedury Print_FN. Zadava se totiz ne
  horni okraj napisu, ale linka, na ktere pismena sedi (s tim, ze nozicky
  nekterych pismen zasahuji pod tuto linku). Pokud misto normalni Y-sourad.
  zadas konstantu AUTO_LINE, radkovani probiha automaticky (uzitecne pro
  vypisovani delsich textu).
  Procedurami SetBasicLine a SetLastLine to muzes ridit.

  UPOZORNENI: Procedury, ktere pouzivaji jako parametr PChar a do kterych se
  take zadava pozice, chapou pozici pocitanou od 1. Tedy prvni znak PCharu ma
  index 1 a nikoliv 0.


  ZMENA FONTU ZA LETU:
  V automatickem rezimu si system hlida urcite tagy. Podobne jako v HTML se
  uzaviraji do znaku vetsi-mensi: <>
  Na rozdil od HTML ale muze byt v jednom tagu uvedeno vice direktiv.
  V tom pripade se oddeluji znakem ;. Priklad:
  <Font=laser.fn; Barva=15>

  Na velikosti pismen nezalezi. Na "odmezerovani" taky ne.
  Pokud chces napsat znak "<" (vetsi), zadej toto "<<"
  A pokud chces napsat znak ">" (mensi), zadej ">>"
  Samostatny znak ">" v textu nebude vypsan.

  Soupis direktiv:
     FONT=     zmena fontu. Pokud je hned za "=" znak "*", nebude stavajici
               font ukladan na zasobnik pro pozdejsi obnovu

     BARVA=    zmena barvy. Pokud je hned za "=" znak "*", nebude stavajici
               barva ukladana na zasobnik pro pozdejsi obnovu

     VYSKA=    zmena vysky. Muzes zadat jeden nebo dva parametry:
               <VYSKA=20>      prostor nad radkou bude 20, pod radkou 0
               <VYSKA=20,5>    nad radkou 20, pod radkou 5
               Je vhodne dat tuto direktivu na konec radku, jinak to muze byt
               pretluceno direktivami FONT nebo SF

     POZADI=   zmena pozadi. Kdyz chces pozadi pruhledne, zavolej
               <POZADI=->. Pokud je hned za "=" znak "*", nebude stavajici
               pozadi ukladano na zasobnik pro pozdejsi obnovu

     PODTRH=   <PODTRH=+> zapne podtrhavani <PODTRH=-> vypne podtrhavani

     SF        undo fontu
     SB        undo barvy
     SP        undo pozadi
     SKOK=     presune pomyslny kurzor na novou pozici. Naslehuji 2 parametry
               Je mozne zadavat absolutni i relativni souradnice vzhledem
               k velikosti obrazovky ci oba zpusoby kombinovat
               <SKOK=200,80>
               <SKOK=50%,10%>
               <SKOK=50%-40,75%+15>
     IMG=      Nacte obrazek. Umi zpracovavat obrazky PCX, GIF, BMP, PNG a JPG
               Tyto formaty jsou rozpoznavany podle pripony, nikoliv podle
               vnitrni struktury dat!
               Tento prikaz ma nepovinne parametry, ktere se tykaji pozicovani
               a zpusobu zobrazeni
               Priklady:
                <IMG=obr.pcx>       proste nacteni a zobrazeni
                <IMG=obr.gif:-5>    obrazek posune o 5 pixelu doprava
                <IMG=obr.gif:-5,40> s posunem o 5 px vlevo a 40 dolu
                <IMG=obr.pcx (-)>   nepouzije se transparence
                <IMG=obr.bmp (15)>  jako transparentni barva se pouzije b. 15
                <IMG=obr.jpg:2,5 (-)>  pozicovani + zakaz transparence

     IMGBAL=   nacte obrazek z knihovny specifikovane promennou FN_PCX.
               to je muj format na ulozeni vice PCX obrazku do jednoho souboru
               Pozicovat se da stejne jako direktiva IMG
               Priklad:
                <IMGBAL=2>        Nacte 2. obrazek z knihovny
                <IMGBAL=8:200,30> Nacte 8. obr. z knihovny a napozicuje ho

     BALIK=    urci, z ktere knihovny ma direktiva IMGBAL nacitat obrazky
               V knihovne jsou ulozeny obrazky ve formatu PCX. Knihovny muzes
               tvorit prilozenou utilitou KNIHOMOL.


Navazujici jednotky nebo dalsi aplikace si mohou pridavat dalsi tagy. Prikladem
je jednotka Wokna32, ktera pro objekt Tlacitko zpracovava tag KLAVESY.
Syntaxe je:
     KLAVESY=  seznam klaves, ktere funguji jako aktivatory tlacitka
               Priklad:
               <KLAVESY=aA>       Tlacitko ma horke klavesy "a","A"
}

{$IFDEF FPC}
{$MODE FPC}
{$ENDIF}

{$Q-}
{$R-}
{$S-}
{$D-}

{$INCLUDE defines.inc}

interface
uses VenomGFX;
const
   FN_OK =       0;
   NO_FILE =    -1;
   NO_FN =      -2;
   UNKNOWN_FN = -3;
   PRAZDNY_ZASOBNIK = -4;
   TOO_Y =      -9000000;
   AUTO_LINE  = -1;    { automaticke zajistovani radkovani }
   MAXFONT = 35;
   FN_PRUHLEDNE = -1;     {konstanta pro pruhledne pozadi}
   MAX_ZASOBNIKU_BAREV = 8;
   MAX_ZASOBNIKU_FONTU = 8;
   MAX_ZASOBNIKU_POZADI = 8;

   FN_FONT_VGA16   = '__VGA16';    {proporcionalni VGA 8x16 font}
   FN_FONT_VGA16_U = '__VGA16_U';  {neproporcionalni VGA 6x16 font}

   FN_FONT_VGA14 = '__VGA14';    {proporcionalni VGA 8x14 font}
   FN_FONT_VGA8  = '__VGA8';     {proporcionalni VGA 8x8 font}

type
znakdef = packed record
  relx:shortint;
  rely:shortint;
  sirka:byte;
  vyska:byte;
  shift:shortint;
  dp:word;
  data:pointer;
end;

fnatrb = record
  font:string[15];
  barva:word;
  pozadi:longint;
  podtrh:boolean;
  end;

_pole_znaku = array[0..65535] of znakdef;
pole_znaku = ^_pole_znaku;


{Struktura FN obsahuje informace o fontu. Budto muzes nacitat fonty z D.mentova
 formaru FN, obraz znakove sady VGA nebo primo parave pouzivana znakova z
 generatiru VGA. Rovnez mohou byt nacitany Unicode fonty od Matheuse Viste.
 Pokud jsou je nacten 256 znakovy font (tzn. ne unicode), jsou v poli DATA
 bitmapy rozpakovane. Tedy jeden pixel = 1 bajt. Pokud je to unicode, jsou
 zapakovane: jeden pixel = 1 bit.}
fn = ^_fn;
_fn = record
  jmeno:string[30];
  first,last:longint;   { prvni definovany, posledni definovany }
  poc_znaku:longint;    {pocet skutecne definovanych znaku. Ma vyznam pro unicode}
  so,su,add:shortint;{ space over, space under, pevna cast mezery mezi znaky }
  maxpred,maxza,maxpod,maxnad:shortint;
  unicode:boolean;
  komp:boolean;
  znak:pole_znaku;
end;

pzas_fnt = ^zas_fnt;
zas_fnt = array[0..MAX_ZASOBNIKU_FONTU] of string[15];
{Nulty index neni soucasti zasobniku, ale nekdy se sem uklada FN_DEFAULT}
pzas_bar = ^zas_bar;
zas_bar = array[0..MAX_ZASOBNIKU_BAREV] of word;
pzas_poz = ^zas_poz;
zas_poz = array[0..MAX_ZASOBNIKU_POZADI] of longint;


type _fnslr = record
  font:fn;
  id:string;
  end;
fnslr = ^Tfnslr;
Tfnslr = array[1..MAXFONT] of _fnslr;

Procedure Init_FNSLR;
Procedure Znic_FNSLR;
Procedure SetBasicLine(a:longint);
Function GetBasicLine:longint;
Procedure SetLastLine(a:longint);
Function GetLastLine:longint;
Procedure NastavVystup(var v:virtualwindow);
Procedure ZjistiVystup(var v:virtualwindow);
Function Nacti_FNSLR(s:string):byte;
Procedure CiziFormat_Do_FN(s:string;var f:fn);
Procedure Nacti_FN(s:string;var f:fn);         { nahraje do pamti font FN }
Function ZkontrolujUnicodeFormat(s:string):boolean;
Procedure Print_FN(x,y:longint;s:pchar;e:fn); { jako OutTextXY }
Procedure Print_FN(x,y:longint;s:pchar;delka:longint;e:fn);
Procedure Print_FN(x,y:longint;p:string;e:fn);
Procedure Print_FN(x,y:longint;p:string;delka:longint;e:fn);
Function VratPismeno(x,y:longint;var s:string;f:fn;xpoz,ypoz:longint):byte;
Procedure FontAdr(s:string);
Function GetFontAdr:string;
function AktualniFont:fn;
function String2FN(s:string):fn;
Procedure Znic_FN(var f:fn);                   { uvoln pam }

Function Vyska_FN(f:fn):longint;             { vrac vku nejvyho psmena }
Function Sirka_FN(s:string;e:fn):longint; { stejn jako "TextWidth" z unitu Graph }
Function Sirka_FN(s:pchar;e:fn;delka:longint):longint;
Function Sirka_FN(s:pchar;e:fn):longint;
Function Sirka_FN(s:string;e:fn;delka:longint):longint;
Function Vyska_FN_default:byte;
Function Sirka_FN_na_Xpoz(p:pchar;font:fn;x:longint):longint;
{Da sirku toho, co je pred kurzorem}
Procedure VyskaRadky(s:pchar;delka:longint;var cv,hv,dv:longint);
Procedure VyskaRadky(s:pchar;var cv,hv,dv:longint);
Function RychlaVyskaRadky(s:string):longint;
Function RychlaVyskaSO(s:string):longint;
Function RychlaVyskaRadky(s:pchar):longint;
Function RychlaVyskaSO(s:pchar):longint;
Function Pozice_v_Retezci(x,y,xs,ys:longint;s:pchar;delka:longint;e:fn):longint;
Function Pozice_v_Retezci(x,y,xs,ys:longint;s:pchar;e:fn):longint;
Procedure Make_proporcional(e:fn;var f:fn);
Procedure KomprimujZnak(var z:znakdef);
Procedure KomprimujFont(f:fn);
Procedure DekomprimujFont(e:fn;var f:fn);
Procedure UlozUnicodeFont(f:fn;s:string);
Procedure NactiUnicodeFont(s:string;var f:fn);
Function OdstranTagy(s:ansistring):ansistring;
Function Jsou_def_znaky_FN(s:string;f:fn):longint;
{Jsou-li definovavy vsechny znaky v retezci, vrati 0, jinak pozici prvniho
nenalezeneho znaku v retezci}
Function PocetTagu(s:ansistring):longint;
Function SmazMezery_v_tagach(t:ansistring):ansistring;
Procedure LokalizujSlovo_FN(t:pchar;delka,p:longint;uni:boolean;za_mez:byte;var z,k:longint);
Procedure LokalizujSlovo_FN_s(s:string;p:longint;uni:boolean;za_mez:byte;var z,k:longint);
Procedure Lokalizuj_Nte_slovo_FN(t:pchar;delka,sl:longint;uni:boolean;var z,k:longint);
Function ZjistiKolikateSlovo_FN(t:pchar;delka,p:longint;uni:boolean):longint;
Function Dej_Pocet_Slov_FN(t:pchar;delka:longint;uni:boolean):longint;
Function FNznakVpred(p:pchar;delka,i:longint;uni:boolean;var j:longint):longint;
Function FNznakZpet(p:pchar;delka,i:longint;uni:boolean;var j:longint):longint;
Function FNznakZpet_s(s:string;i:longint;uni:boolean;var j:longint):longint;
Function Dej_nty_tag(s:ansistring;n:longint):string;
Function Tag_to_FNatrb(s:string):fnatrb;
Function FNatrb_To_Tag(fna:fnatrb):string;
Function PrvniVyskytZnaku(p:pchar;z:char;poz:longint):longint;
Function NajdiTag(s:ansistring;tag:string;var separat:string):longint;

Procedure Charset_2_FN(s:string;var f:fn); { Vytvori FN font z definice
                                             znakove sady na disku
                                             (255 znaku v rastru 8x16 = 4096b) }

Procedure UlozNaZasobnikFontu(s:string);
Procedure UlozNaZasobnikBarev(w:word);
Procedure UlozNaZasobnikPozadi(w:longint);
Function OdeberZeZasobnikuFontu:string;
Function OdeberZeZasobnikuBarev:word;
Function OdeberZeZasobnikuPozadi:longint;
Procedure ZalohujZasobnikFontu(p:pzas_fnt;var v:byte);
Procedure ObnovZasobnikFontu(p:pzas_fnt;var v:byte);
Procedure ZalohujZasobnikBarev(p:pzas_bar;var v:byte);
Procedure ObnovZasobnikBarev(p:pzas_bar;var v:byte);
Procedure ZalohujZasobnikPozadi(p:pzas_poz;var v:byte);
Procedure ObnovZasobnikPozadi(p:pzas_poz;var v:byte);
Procedure VycistiZasobnikFontu;
Procedure VycistiZasobnikBarev;
Procedure VycistiZasobnikPozadi;

const
      VOLNY_OBRAZEK    = 1;
      OBRAZEK_V_BALIKU = 2;
      NORMAL     = 0;
      URCIPOLOHU = 1;
      URCIZNAK   = 2;


      FN_error:longint = FN_OK;
      FN_pozadi:longint = FN_PRUHLEDNE;
      FN_color:word = 65535;
      OFN_color:word = 65535;
      FN_color2:word = 65535;
      FN_podtrh:boolean = false;
      FN_ignore:boolean = false;
      FN_beztagu:boolean = false;
      FN_default:string[30] = '__vga16';   { proporcionalni VGA font }
      FN_syst_font:string[30] = '__vga16';
      FN_KONECVSTUPU=5;
      FN_PCX_adresar:string = '';
      FN_PCX:string = '';
      FN_VGA16:fn = nil;
      FN_VGA16_u:fn = nil;
      FN_VGA14:fn = nil;
      FN_VGA8:fn = nil;
      Fn_default_fn:fn = nil;
      FN_poz_v_ret_delka_radky:longint=0;
      zamcene_zasobniky:boolean = false;

var FN_selector:fnslr;
    FN_skut_znak:longint;
    FN_vsuvka:array[1..4] of string;                                        { po urcitem poctu tiku             }
    FN_vyskaradky:record
    hv,dv,cv:longint;
    end;

    FN_poloha:record
    x,y:longint;
    b:byte;
    n:longint;
    _odz,_doz:longint;
    _posunv:longint;
    _posunm:longint;
    posund:longint;   {vraci posledni znak na posledni zobrazovane radce}
    posunh:longint;   {posledni skut. zobr. znak na posl. zobr. radce}
    font:string[12];  {jakym fontem bylo vypsano posledni pismeno}
    attr:fnatrb;
    trg:boolean;
    end;

implementation
uses Lacrt,Go32,Vnm_PCX,Vnm_GIF,Vnm_PNG,Vnm_JPG,Dos;
const fnmagic:pchar='mon ';
      unimagic:pchar='a';
      ak_Y:longint = 0;
      FN_adresar:string = '';
      max_Y:longint = 479;
      vrchol_zf:byte = 0;
      vrchol_zb:byte = 0;
      vrchol_zp:byte = 0;

type
pcharset = ^charset;
charset = packed array[0..255,1..16] of Byte;

     unifont_header = packed record
     magic:array[1..4] of char;
     first:longint;
     last:longint;
     nahore:word;
     dole:word;
     end;

var target:PVirtualwindow;
    vrchol_zzf:byte;
    zasobnik_fontu:zas_fnt;
    zasobnik_barev:zas_bar;
    zasobnik_pozadi:zas_poz;

Procedure Vychod(s:shortint);
begin
FN_error:=s;
Exit;
end;

Procedure NastavVystup(var v:virtualwindow);
var p:pointer;
begin
p:=addr(v);
target:=p;
end;

Procedure ZjistiVystup(var v:virtualwindow);
begin
v:=target^;
end;

Procedure SetBasicLine(a:longint);
begin
ak_Y:=a;
end;

Function GetBasicLine:longint;
begin
GetBasicLine:=ak_Y;
end;

Procedure SetLastLine(a:longint);
begin
max_Y:=a;
end;

Function GetLastLine:longint;
begin
GetLastLine:=max_Y;
end;

Function CompareHeader(p:pointer):boolean;
var a:byte;
    b:pchar;
begin
b:=p;
CompareHeader:=true;
for a:=0 to 6 do
  begin
  if b^<>fnmagic[a] then CompareHeader:=false;
  inc(b);
  end;
end;

Procedure Expand(a:byte;p:pointer);
var b:byte;
    q:^boolean;
begin
q:=p;
inc(q,7);
for b:=0 to 7 do
    begin
    q^:=odd(a);
    a:=a shr 1;
    dec(q);
    end;
end;

Procedure UlozNaZasobnikFontu(s:string);
var a:longint;
begin
if zamcene_zasobniky then Exit;
if vrchol_zf<MAX_ZASOBNIKU_FONTU then
   begin
   inc(vrchol_zf);
   zasobnik_fontu[vrchol_zf]:=s;
   end
   else begin {na zasobniku uz neni misto?}
   for a:=1 to MAX_ZASOBNIKU_FONTU-1 do         {ted se zasobnik zachova}
       zasobnik_fontu[a]:=zasobnik_fontu[a+1];  {jako fronta :-)}
   zasobnik_fontu[MAX_ZASOBNIKU_FONTU]:=s;
   end;
end;

Procedure UlozNaZasobnikBarev(w:word);
var a:longint;
begin
if zamcene_zasobniky then Exit;
if vrchol_zb<MAX_ZASOBNIKU_BAREV then
   begin
   inc(vrchol_zb);
   zasobnik_barev[vrchol_zb]:=w;
   end
   else begin {na zasobniku uz neni misto?}
   for a:=1 to MAX_ZASOBNIKU_BAREV-1 do         {ted se zasobnik zachova}
       zasobnik_barev[a]:=zasobnik_barev[a+1];  {jako fronta :-)}
   zasobnik_barev[MAX_ZASOBNIKU_BAREV]:=w;
   end;
end;

Procedure UlozNaZasobnikPozadi(w:longint);
var a:longint;
begin
if zamcene_zasobniky then Exit;
if vrchol_zp<MAX_ZASOBNIKU_POZADI then
   begin
   inc(vrchol_zp);
   zasobnik_pozadi[vrchol_zp]:=w;
   end
   else begin {na zasobniku uz neni misto?}
   for a:=1 to MAX_ZASOBNIKU_POZADI-1 do         {ted se zasobnik zachova}
       zasobnik_pozadi[a]:=zasobnik_pozadi[a+1];  {jako fronta :-)}
   zasobnik_pozadi[MAX_ZASOBNIKU_POZADI]:=w;
   end;
end;


Function OdeberZeZasobnikuFontu:string;
begin
if zamcene_zasobniky then Exit;
if vrchol_zf<=0 then
   begin
   fn_error:=PRAZDNY_ZASOBNIK;
   OdeberZeZasobnikuFontu:='';
   end
   else begin
   fn_error:=FN_OK;
   OdeberZeZasobnikuFontu:=zasobnik_fontu[vrchol_zf];
   dec(vrchol_zf);
   end;
end;

Function OdeberZeZasobnikuBarev:word;
begin
if zamcene_zasobniky then Exit;
if vrchol_zb<=0 then
   begin
   fn_error:=PRAZDNY_ZASOBNIK;
   OdeberZeZasobnikuBarev:=0;
   end
   else begin
   fn_error:=FN_OK;
   OdeberZeZasobnikuBarev:=zasobnik_barev[vrchol_zb];
   dec(vrchol_zb);
   end;
end;

Function OdeberZeZasobnikuPozadi:longint;
begin
if zamcene_zasobniky then Exit;
if vrchol_zp<=0 then
   begin
   fn_error:=PRAZDNY_ZASOBNIK;
   OdeberZeZasobnikuPozadi:=0;
   end
   else begin
   fn_error:=FN_OK;
   OdeberZeZasobnikuPozadi:=zasobnik_pozadi[vrchol_zp];
   dec(vrchol_zp);
   end;
end;

Procedure ZalohujZasobnikFontu(p:pzas_fnt;var v:byte);
begin
p^:=zasobnik_fontu;
v:=vrchol_zf;
p^[0]:=fn_default;
end;

Procedure ObnovZasobnikFontu(p:pzas_fnt;var v:byte);
begin
zasobnik_fontu:=p^;
vrchol_zf:=v;
fn_default:=p^[0];
end;

Procedure ZalohujZasobnikBarev(p:pzas_bar;var v:byte);
begin
p^:=zasobnik_barev;
v:=vrchol_zb;
p^[0]:=fn_color;
end;

Procedure ObnovZasobnikBarev(p:pzas_bar;var v:byte);
begin
zasobnik_barev:=p^;
vrchol_zb:=v;
fn_color:=p^[0];
end;

Procedure ZalohujZasobnikPozadi(p:pzas_poz;var v:byte);
begin
p^:=zasobnik_pozadi;
v:=vrchol_zp;
p^[0]:=fn_pozadi;
end;

Procedure ObnovZasobnikPozadi(p:pzas_poz;var v:byte);
begin
zasobnik_pozadi:=p^;
vrchol_zp:=v;
fn_pozadi:=p^[0];
end;

Procedure VycistiZasobnikBarev;
begin vrchol_zb:=0;end;

Procedure VycistiZasobnikFontu;
begin vrchol_zf:=0;end;

Procedure VycistiZasobnikPozadi;
begin vrchol_zp:=0;end;


Procedure Nacti_FN(s:string;var f:fn);
var fl:file;
     l:longint;
     ss:string;
     r,p,q,z2,z3,t:^byte;
     b,n,m,oo,v,w:word;
     z:pointer;

begin
s:=FN_adresar+s;
if not ExistFile(s) then Vychod(NO_FILE);
Assign(fl,s);
Reset(fl,1);
p:=@ss;
BlockRead(fl,p^,10);     { nacte cely soubor do pameti }
Close(fl);
{***************** U je to v pamti, jdeme to zpracovat ******************}
if not CompareHeader(p) then     {chybi signatura formatu FN?}
   begin
   CiziFormat_Do_FN(s,f);            {tak je to asi ve formatu Unicode}
   Exit;
   end;

Assign(fl,s);
Reset(fl,1);
l:=filesize(fl);
GetMem(p,l);
BlockRead(fl,p^,l,w);
Close(fl);               { zavreme diskovy soubor }
r:=p;                    { ukazatel na prvni znak }
q:=p;
inc(q,7);                { preskocime magic }
p:=q;                    { synchronizace, adresa uplneho zacatku je v R }
ss:='';
while p^<>0 do
   begin
   ss:=ss+char(p^);
   inc(p);
   end;
New(f);
f^.jmeno:=ss;
inc(p);                      { preskocime nulovy bajt }
q:=p;                        { a synchronizujeme }
f^.first:=q^;inc(q);
f^.last:=q^;inc(q);
f^.poc_znaku:=f^.last-f^.first+1;
f^.so:=shortint(q^);inc(q);
f^.su:=shortint(q^);inc(q);
f^.add:=shortint(q^);inc(q);
if q^<>0 then Vychod(UNKNOWN_FN); { tento bajt se nazyva Future, musi byt 0 }
inc(q);
p:=r;                             { synchronizace s uplnym zacatkem souboru }
f^.maxpred     :=127;
f^.maxza       :=-127;
f^.maxnad      :=127;
f^.maxpod      :=-127;
f^.unicode     :=false;
f^.komp        :=true;
GetMem(f^.znak,256*sizeof(znakdef));
GetMem(z,2048);
for b:=0 to f^.first do f^.znak^[b].data:=nil;
for b:=f^.last to 255 do f^.znak^[b].data:=nil;
for b:=f^.first to f^.last do
   begin
   Move(q^,f^.znak^[b],5);inc(q,5);  { presune data do struktury }
   v:=f^.znak^[b].sirka*f^.znak^[b].vyska; { pocet bodu, ze kterych znak je }
   if v>0 then
      begin
      f^.znak^[b].dp:=v;
      GetMem(f^.znak^[b].data,v); { alokuje bitmapu }
      move(q^,w,2);      { presune word do W, typ motorola }
      inc(p,w); { offset od uplneho zacatku souboru }
      { ************* rozepisovn znaku ************* }
      if f^.znak^[b].sirka mod 8=0 then  { v kolika bajtech je def. 1 radku }
         n:=f^.znak^[b].sirka div 8 else n:=f^.znak^[b].sirka div 8 + 1;
      t:=f^.znak^[b].data;     { zapisovaci pointer nastavi na bitmapu }
      for oo:=1 to f^.znak^[b].vyska do
         begin
         z2:=z;
         for m:=1 to n do
            begin
            Expand(p^,z2);
            inc(z2,8);
            inc(p);
            end;
         Move(z^,t^,f^.znak^[b].sirka);
         inc(t,f^.znak^[b].sirka);
         end;

      {znak jsme dekomprimovali, ale ted ho prekvapive budu znovu komprimovat}
      {predchozi komprese totiz pakovala jednotlive radky zvlast, kdezto ja
      zapakuju celou bitmapu vcelku}
      KomprimujZnak(f^.znak^[b]);
      end else f^.znak^[b].data:=nil; { if V>0 }
   inc(q,2);
   { *************************************************************** }
   p:=r;
   with f^.znak^[b] do
     begin
     if relX<f^.maxpred       then f^.maxpred :=relX;
     if relY<f^.maxnad        then f^.maxnad  :=relY;
     if relX+sirka-1>f^.maxza  then f^.maxza   :=relX+sirka-1;
     if relY+vyska-1>f^.maxpod then f^.maxpod  :=relY+vyska-1;
     end;
   end;
p:=r;
FreeMem(z,2048);
system.FreeMem(p,l);
end;

Procedure KomprimujZnak(var z:znakdef);
var a,b,c,d:longint;
    p,g,pp:pbyte;
    j:byte;
begin
d:=z.dp mod 8;
a:=z.dp div 8;
if d=0 then
   c:=a else c:=a+1; {v kolika bajtech bude definice znaku}
GetMem(p,c);
pp:=p;
g:=z.data;
for b:=1 to a do {projedu vsechny cele zaplnene bajty}
    begin
    j:=g[0] shl 7 + g[1] shl 6 + g[2] shl 5 + g[3] shl 4 + g[4] shl 3 + g[5] shl 2 + g[6] shl 1 + g[7];
    pp^:=j;inc(pp);
    inc(g,8);
    end;
{a ted jeste co zbylo (jestli neco zbylo)}
if d<>0 then
   begin
   j:=0;
   for b:=1 to d do
       begin
       j:=j+g^ shl (8-b);
       inc(g);
       end;
   pp^:=j;
   end;
FreeMem(z.data,z.dp);
z.dp:=c;
z.data:=p;
end;

Procedure KomprimujFont(f:fn);
var a,b:longint;
begin
for a:=f^.first to f^.last do
    if f^.znak^[a].data<>nil then KomprimujZnak(f^.znak^[a]);
f^.komp:=true;
end;

Procedure Znic_FN(var f:fn);
var a:longint;
begin
for a:=f^.first to f^.last do
   if f^.znak^[a].data<>nil then FreeMem(f^.znak^[a].data,f^.znak^[a].dp);
if f^.unicode=false then FreeMem(f^.znak,256*sizeof(znakdef))
                    else FreeMem(f^.znak,65536*sizeof(znakdef));
Dispose(f);
end;

function String2FN(s:string):fn;
var t:string;
    a:byte;
begin
a:=Nacti_FNSLR(s);
String2FN:=FN_selector^[a].font;
end;

Function AktualniFont:fn;
begin
AktualniFont:=String2FN(fn_default);
end;

Function IzolujSlovo_z_Tagu(s:string;b:byte):string;
const oddelovace:set of char = [';','>',#13,#10];
var a,c,d:byte;
    t:string;
begin
a:=b;
c:=b;
d:=Length(s)+1;
while (a>0) and (not (s[a] in oddelovace)) do dec(a);
while (c<d) and (not (s[c] in oddelovace)) do inc(c);
t:=Copy(s,a+1,c-a-1);
IzolujSlovo_z_Tagu:=t;
end;

Function Vysekni_Tag(s:pchar;l,ds:longint;var delka:longint):string;
var m:longint;
    t:string;
begin
if (FN_ignore=false) or (FN_beztagu) or (l>ds) then
   begin delka:=0;Exit('');end;

if (s[l-1]='>') then
   begin delka:=1;Exit('');end;

if (s[l-1]<>'<') then
   begin delka:=0;Exit('');end;

if (l=ds) then   {potencialni bug. Kdyz je < poslednim znakem retezce}
   begin delka:=0;Exit('');end;

if (s[l]='<') then begin
   delka:=1;Exit('');
   end;
m:=PSearch(s,'>',l);
if m=0 then m:=ds;  { neuzavreny tag? }
if m>255 then
   begin
   delka:=0;Vysekni_Tag:=''; {nekorektni ultradlouhy retezec?}
   Exit;
   end;
t:=Mid(s,l,m);
delka:=Length(t)-1;
t:=SkipAllSpaces(t);
Vysekni_Tag:=Convert_Up(t);
end;

Function Vysekni_Tag_vzad(s:pchar;l,ds:longint;var delka:longint):string;
var m:longint;
    t:string;
begin
if (FN_ignore=false) or (FN_beztagu) or (l<=1) then
   begin delka:=0;Exit('');end;

if (s[l-2]='<') then
   begin delka:=1;Exit('');end;

if (s[l-2]<>'>') then
   begin delka:=0;Exit('');end;

if l=2 then
   begin delka:=1;Exit('');end;

if s[l-2]='>' then
   begin delka:=1;Exit('');end;


m:=BackSearch(s,'<',ds-l+1-1);
if m=0 then m:=ds;  { neuzavreny tag? }

if m>255 then
   begin
   delka:=0;Exit(''); {nekorektni ultradlouhy retezec?}
   end;

t:=Mid(s,ds-m+1,l-1);
delka:=Length(t)-1;
t:=SkipAllSpaces(t);
Vysekni_Tag_vzad:=Convert_Up(t);
end;


Procedure Vyska_ze_Selektoru(s:string;var cv,hv,dv:longint);
var c,p:longint;
begin
c:=Nacti_FNSLR(s);  { nacist do selectoru }
p:=Vyska_FN(FN_selector^[c].font); { pripadne prohozeni }
if p>cv then cv:=p;
p:=FN_selector^[c].font^.so;
if p>hv then hv:=p;
p:=FN_selector^[c].font^.su;
if p>dv then dv:=p;
end;

Procedure Vyska_z_Tagu(t:string;var cv,hv,dv:longint);
{Je volana funkci VyskaRadky, ktera zalohuje zasobnik. Tady to uz tedy neni
 potreba}
var b:boolean;
    v,prac:string;
    i,delka2:longint;
begin
delete(t,1,1);
repeat
v:=IzolujSlovo_z_Tagu(t,1);
delka2:=Length(v)+1;
delete(t,1,delka2);

if Copy(v,1,5)='FONT=' then
   begin
   prac:=Copy(v,6,delka2);
   UlozNaZasobnikFontu(fn_default);
   Vyska_ze_selektoru(prac,cv,hv,dv);
   end else
   if Copy(v,1,2)='SF' then
      begin
      prac:=OdeberZeZasobnikuFontu;
      if fn_error=FN_OK then fn_default:=prac;
      Vyska_ze_selektoru(fn_default,cv,hv,dv);
      end;

if Copy(v,1,6)='VYSKA=' then
   begin
   prac:=Copy(v,7,delka2);
   i:=Pos(',',prac);
   dv:=0;
   if i=0 then hv:=MyVal(prac) else
      begin
      hv:=MyVal(Copy(prac,1,i-1));
      dv:=MyVal(Copy(prac,i+1,255));
      end;
   cv:=hv+dv;
   end;
until Length(t)<2;     { Mozna by stacilo "...=0" }
end;

Procedure VyskaRadky(s:pchar;delka:longint;var cv,hv,dv:longint);
var p,c,d:longint;
    t,zd:string;
    zf:zas_fnt;
    zv:byte;
begin
if FN_ignore=false then
   begin
   cv:=0;hv:=0;dv:=0;
   Exit;
   end;
zd:=FN_default;
ZalohujZasobnikFontu(@zf,zv);
c:=0;
p:=Nacti_FNSLR(FN_default);
cv:=Vyska_FN_default;
hv:=FN_selector^[p].font^.so;
dv:=FN_selector^[p].font^.su;
if delka>0 then
   repeat
   inc(c);
   t:=Vysekni_Tag(s,c,delka,d);
   inc(c,d);
   if t<>'' then Vyska_z_Tagu(t,cv,hv,dv);  { novy font ? }
   until (c>=delka) or ((s[c-1]=#13) and (s[c]=#10));
FN_default:=zd;
ObnovZasobnikFontu(@zf,zv);
end;

Procedure VyskaRadky(s:pchar;var cv,hv,dv:longint);
var i:longint;
begin
i:=PLength(s);
VyskaRadky(s,i,cv,hv,dv);
end;

Function RychlaVyskaRadky(s:pchar):longint;
var cv,hv,dv:longint;
begin
VyskaRadky(s,cv,hv,dv);
RychlavyskaRadky:=cv;
end;

Function RychlaVyskaSO(s:pchar):longint;
var cv,hv,dv:longint;
begin
VyskaRadky(s,cv,hv,dv);
RychlavyskaSO:=hv;
end;

Function RychlaVyskaRadky(s:string):longint;
var p:pchar;
begin
s:=s+#0;
p:=@s[1];
RychlaVyskaRadky:=RychlaVyskaRadky(p);
end;

Function RychlaVyskaSO(s:string):longint;
var p:pchar;
begin
s:=s+#0;
p:=@s[1];
RychlaVyskaSO:=RychlaVyskaSO(p);
end;

Procedure Zatemni_FN(x1,y1,x2,y2:longint);
begin
if FN_pozadi=FN_PRUHLEDNE then Exit;
Bar(target^,x1,y1,x2,y2,FN_pozadi);
end;

Procedure Podtrhni_FN(x1,x2,y:longint);
begin
if FN_podtrh then LineHorz(target^,x1,x2,y,FN_color);
end;

Procedure Prechod_na_novy_font(s:string);
var a:byte;
begin
UlozNaZasobnikFontu(fn_default);
a:=Nacti_FNSLR(s);
FN_default:=s;
FN_default_fn:=FN_selector^[a].font;
end;

Procedure Prechod_na_stary_font;
var s:string;
    a:byte;
begin
s:=OdeberZeZasobnikuFontu;
if fn_error=FN_OK then FN_default:=s;
a:=Nacti_FNSLR(fn_default);
FN_default_fn:=FN_selector^[a].font;
end;

Procedure Prechod_na_novou_barvu(s:string);
begin
UlozNaZasobnikBarev(FN_color);
OFN_color:=FN_color;
if s='*' then FN_color:=FN_color2 else FN_color:=MyVal(s);
end;

Procedure Prechod_na_starou_barvu;
var w:word;
begin
w:=OdeberZeZasobnikuBarev;
if fn_error=FN_OK then FN_color:=w;
end;

Procedure Prechod_na_nove_pozadi(s:string);
begin
UlozNaZasobnikPozadi(FN_pozadi);
if s[1]='-' then FN_pozadi:=FN_PRUHLEDNE else
   FN_pozadi:=MyVal(s);
end;

Procedure Prechod_na_stare_pozadi;
var l:longint;
begin
l:=OdeberZeZasobnikuPozadi;
if fn_error=FN_OK then FN_pozadi:=l;
end;

Procedure Zmen_Podtrzeni(s:string);
begin
if s[1]='+' then FN_podtrh:=true else
if s[1]='-' then FN_podtrh:=false;
end;

Procedure Zmen_Balik_s_obrazky(s:string);
begin
FN_PCX:=s;
end;

Procedure Skok_na_novou_pozici(t:string;var x,y:longint);
var a,b:byte;
    s:string;
    r:real;
begin
a:=Pos(',',t);
s:=Copy(t,1,a-1);
delete(t,1,a);
{v S mame X-souradnici, v T Y-souradnici}
b:=Pos('%',s);       {Jdeme resit Xovou souradnici}
if b=0 then x:=MyVal(s) else
   begin
   r:=MyVal(Copy(s,1,b-1))/100*target^.breiteminus1;
   if s[b+1]='+' then r:=r+MyVal(Copy(s,b+2,255)) else
   if s[b+1]='-' then r:=r-MyVal(Copy(s,b+2,255));
   x:=round(r);
   end;

b:=Pos('%',t);       {Jdeme resit Yovou souradnici}
if b=0 then y:=MyVal(t) else
   begin
   r:=MyVal(Copy(t,1,b-1))/100*target^.hoeheminus1;
   if t[b+1]='+' then r:=r+MyVal(Copy(t,b+2,255)) else
   if t[b+1]='-' then r:=r-MyVal(Copy(t,b+2,255));
   y:=round(r);
   end;
end;

Procedure Nacti_Obrazek(jak:byte;s:string;x,y:longint);
var v:virtualwindow;
    a,b,xp,yp:longint;
    prac,prac2:string;
    pruhlednost:boolean;
    barpr:longint;
begin
s:=SkipAllSpaces(s);
pruhlednost:=true;
barpr:=0;
a:=Pos('(',s);
b:=Pos(')',s);
if b>a then
   begin
   if s[a+1]='-' then pruhlednost:=false else
      barpr:=MyVal(Copy(s,a+1,b-a));
   delete(s,a,b-a+1);
   end;
a:=Pos(':',s);       { budeme obrazek polohovat?}
if a=0 then {ne?}
   begin
   prac:=s;
   xp:=0;
   yp:=0;
   end else {jo?}
   begin
   prac:=Copy(s,1,a-1);
   delete(s,1,a);
   a:=Pos(',',s);
   if a=0 then
      begin
      xp:=MyVal(s);
      yp:=0;
      end
      else
      begin
      xp:=MyVal(Copy(s,1,a-1));
      yp:=MyVal(Copy(s,a+1,Length(s)));
      end;
   end;

if jak=VOLNY_OBRAZEK then
   begin
   prac2:=Convert_UP(StripExt(prac));
   if prac2='.PCX' then Load_PCX(FN_PCX_adresar+prac,v) else
   if prac2='.BMP' then Load_BMP(FN_PCX_adresar+prac,v) else
   if prac2='.GIF' then Load_GIF(FN_PCX_adresar+prac,v) else
   if prac2='.PNG' then Load_PNG(FN_PCX_adresar+prac,v) else
   if prac2='.JPG' then Load_JPG(FN_PCX_adresar+prac,v);
   end;

if FN_poloha.b<>URCIPOLOHU then     { doopravdy chceme vykreslovat? }
   {jo...}
   if pruhlednost then PutClippedHCSprite(target^,v,x+xp,y+yp,barpr) else
                       PutClippedSprite(target^,v,x+xp,y+yp)
   else
   {ne...}
   if (FN_poloha.x>=x+xp) and (FN_poloha.y>=y+yp) and
      (FN_poloha.x<=x+xp+v.breiteminus1) and (FN_poloha.y<=y+yp+v.hoeheminus1) then
      begin
      FN_poloha.n:=a;
      end;
Kill_VW(v);
end;

Procedure Zpracuj_Tag(t:string;var x,y:longint;vsechno:boolean);
var v,w:string;
    delka2:longint;
begin
delete(t,1,1);
repeat
v:=IzolujSlovo_z_Tagu(t,1);
delka2:=Length(v)+1;
delete(t,1,delka2);

if Copy(v,1,5)='FONT=' then        { ZMENA FONTU }
   Prechod_na_novy_font(Copy(v,6,delka2))
   else

if Copy(v,1,2)='SF' then           { FONT PREDTIM }
   Prechod_na_stary_font else

if Copy(v,1,5)='SKOK=' then        { PRESUN GRAFICKEHO KURZORU}
   Skok_na_novou_pozici(Copy(v,6,delka2),x,y)
   else

if VSECHNO then
if Copy(v,1,6)='BARVA=' then       { ZMENA BARVY }
   Prechod_na_novou_barvu(Copy(v,7,delka2))
   else

if Copy(v,1,7)='POZADI=' then      { ZMENA POZADI }
   Prechod_na_nove_pozadi(Copy(v,8,delka2))
   else

if Copy(v,1,7)='PODTRH=' then
   Zmen_Podtrzeni(Copy(v,8,delka2)) { PODTRZENI TEXTU }
   else

if Copy(v,1,2)='SP' then           { POZADI PREDTIM }
   Prechod_na_stare_pozadi
   else

if Copy(v,1,2)='SB' then           { BARVA PREDTIM }
   Prechod_na_starou_barvu
   else

if Copy(v,1,4)='IMG=' then         { NACTE OBRAZEK }
   Nacti_Obrazek(VOLNY_OBRAZEK,Copy(v,5,delka2),x,y)
   else

if Copy(v,1,7)='IMGBAL=' then      { NACTE OBRAZEK Z BALICKU }
   Nacti_Obrazek(OBRAZEK_V_BALIKU,Copy(v,5,delka2),x,y)
   else

if Copy(v,1,4)='BALIK=' then       { ZMENI BALICEK }
   Zmen_Balik_s_obrazky(Copy(v,7,delka2));

if Copy(v,1,6)='VYSKA=' then begin end;  { NEDELA NIC :-) }

until Length(t)<2;     { Mozna by stacilo "...=0" }
end;

Function NeznamyZnak(x,y:longint):longint;
begin
LineClipped(target^,x,y,x+6,y,36960);
LineClipped(target^,x,y+6,x+6,y+6,36960);
LineClipped(target^,x,y,x,y+6,36960);
LineClipped(target^,x+6,y,x+6,y+6,36960);
NeznamyZnak:=7;
end;

Function FNatrb_To_Tag(fna:fnatrb):string;
var s:string;
begin
s:='<FONT='+fna.font+';BARVA='+mystr(fna.barva)+';POZADI='+mystr(fna.pozadi)+';PODRTH=';
if fna.podtrh=true then s:=s+'+>' else s:=s+'->';
FNatrb_To_Tag:=s;
end;

Function Tag_to_FNatrb(s:string):fnatrb;
var zs:boolean;
    sf:string;
    sb:word;
    sp,x,y:longint;
    spo:boolean;
    f:fnatrb;
begin
zs:=Zamcene_zasobniky;
Zamcene_zasobniky:=true;
sf:=FN_default;
sb:=FN_color;
sp:=FN_pozadi;
spo:=FN_podtrh;
s:=Convert_up(s);
Zpracuj_Tag(s,x,y,true);
f.font:=FN_default;
f.barva:=FN_color;
f.pozadi:=FN_pozadi;
f.podtrh:=FN_podtrh;
FN_default:=sf;
FN_color:=sb;
FN_pozadi:=sp;
FN_podtrh:=spo;
Zamcene_zasobniky:=zs;
Tag_to_FNatrb:=f;
end;

Procedure Print_FN(x,y:longint;s:pchar;delka:longint;e:fn);
var a,d,znak,k,cv,hv,dv,mimo:longint;
    v,w1,w2,w3,w4,w5,w6,xr,dw:longint;
    ap:byte;
    ww:^word;
    mm:boolean;
    t:string;
    bb:^byte;
     f:fn;
begin
k:=0;
if s='' then Exit;
FN_error:=FN_OK;
if FN_ignore then   { zapnuta inteligence }
   begin
   fn_default_fn:=AktualniFont;{implicitni font nahran, bud z disku nebo z pameti}
   if y=AUTO_LINE then
      begin
      VyskaRadky(s,cv,hv,dv);
      FN_vyskaradky.cv:=cv;
      FN_vyskaradky.hv:=hv;
      FN_vyskaradky.dv:=dv;

      FN_poloha._doz:=0;
      FN_poloha._odz:=0;
      FN_poloha._posunv:=0;
      FN_poloha._posunm:=0;
      FN_poloha.trg:=false;

      w1:=x;        {Pozor - ac nenapadne a zdanlive nesmyslne, tak velice dulezite}
      w3:=ak_y;     {V jedne situaci tyto radky vyuzije rizeni kurzoru}
                    {(tyka se to preskoku na prazdny radek)}
      y:=Ak_Y+hv;
      w2:=y+cv;
      if w2>Max_Y then
         begin
         FN_Error:=TOO_Y;
         if y>Max_Y then Exit;
         end;

      (*if y+cv>Max_Y then
         begin
         FN_error:=TOO_Y;
         Exit;
         end;*)

      inc(Ak_Y,cv);

      if w2<0 then Exit;  {optimalizace?}

      end;
   end else
       begin { vypnuta inteligence }
       f:=fn_default_fn;fn_default_fn:=e;
       end;

if FN_poloha.b=URCIPOLOHU then
   if (FN_poloha.y>=y-f^.so) and (FN_poloha.y<=y+f^.su) then
      mm:=true else mm:=false
   else
   begin
   mm:=false;
   OFN_color:=FN_color;
   end;

w5:=y-fn_default_fn^.so;
w6:=y+fn_default_fn^.su;
mimo:=-1;      {to znamena, ze dosud nebylo nic vypsano}
xr:=x;
a:=1;
repeat
{----------------------------------------------------------------------------}

t:=Vysekni_Tag(s,a,delka,d);inc(a,d);
if t<>'' then
   begin
{*** 1.VARIANTA - TAG *******************************************************}
   Zpracuj_Tag(t,x,y,true)
   end else  { mozna jsem narazil na tag, }

if (s[a-1]=#13) and
   (a<delka) and
   (s[a]=#10) then
                                            { mozna na konec radky... }
   begin
{*** 2.VARIANTA - KONEC RADKY ***********************************************}
   x:=xr;y:=y+fn_default_fn^.so+fn_default_fn^.su;
   w5:=y-fn_default_fn^.so;
   w6:=y+fn_default_fn^.su;
   inc(a);
   if FN_poloha.b=URCIPOLOHU then
      if (FN_poloha.y>=y-f^.so) and (FN_poloha.y<=y+f^.su) then
         mm:=true else mm:=false;

   {if FN_poloha.b=URCIZNAK then FN_poloha.x:=-2;}
   end
   else begin          { ...mozna na nic mimoradneho }
{*** 3.VARIANTA - PISMENO ***************************************************}
   if fn_default_fn^.unicode=false then znak:=byte(s[a-1])
      else begin
      znak:=UTF82word(s,delka,a,ap);
      inc(a,ap-1);
      end;
   bb:=fn_default_fn^.znak^[znak].data;
   v:=fn_default_fn^.znak^[znak].sirka;
   w1:=fn_default_fn^.znak^[znak].relX+x;
   w2:=fn_default_fn^.znak^[znak].relY+y;
   w3:=y-fn_default_fn^.so;
   w4:=fn_default_fn^.znak^[znak].shift+fn_default_fn^.add;
   if FN_poloha.B<>URCIPOLOHU then
      begin
      Zatemni_FN(x,w5,w1+w4-1,w6);
      Podtrhni_FN(x,w1+w4-1,y+1);
      dw:=fn_default_fn^.znak^[znak].dp;
      if bb<>nil then mimo:=PutChar_FN(target^,bb,w1,w2,v,fn_default_fn^.znak^[znak].vyska,dw,FN_color)
                 else                    {kam, data, x, y, sirka, vyska, komprese, poc.bytu, barva}
                 begin
                 if znak<>32 then       {mezera nekdy neni ve FN fontech explicitne definovana}
                    NeznamyZnak(w1,w2);
                 mimo:=0;
                 end;
   case mimo of
      1:{moc vpravo}if FN_poloha._doz=0 then
                       begin
                       FN_poloha._doz:=a;
                       FN_poloha._posunv:=w4;
                       delka:=a;  {jsme na pravem okraji - nema smysl dale psat}
                       end;
      2:{moc vlevo} begin
                    FN_poloha._odz:=a;
                    FN_poloha._posunm:=w1;
                    end;
      4:{castecne moc vlevo}
        begin
        FN_poloha._odz:=a;
        FN_poloha._posunm:=w1;
        end;

      3:{castecne moc vpravo}
        if FN_poloha._doz=0 then
           begin
           FN_poloha._doz:=a;
           FN_poloha._posunv:=w4;
             dec(FN_poloha._posunv,target^.breite-1-w1);
           if FN_poloha._posunv<=0 then  {spravne by nemelo nikdy nastat, lec obcas nekdy nastane}
              begin
              FN_poloha._posunv:=w4;
              end;
           delka:=a;  {jsme na pravem okraji - nema smysl dale psat}
           end;
      end;
      end;

   if mm then
      if (FN_poloha.x>=w1) and (FN_poloha.x<=w1+v-1) then
         begin
         FN_poloha.n:=a;
         mm:=false;
         end;
   x:=x+w4;
   end;

{w3:=w2;}
if (FN_poloha.B=URCIZNAK) then
   begin
   {zapamatuje si nastaveni textu na pozici kurzoru}
   FN_poloha.attr.font:=FN_default;
   FN_poloha.attr.barva:=FN_color;
   FN_poloha.attr.pozadi:=FN_pozadi;
   FN_poloha.attr.podtrh:=FN_podtrh;
   {-----------------------------------------------}
   if FN_poloha.posunh=0 then FN_poloha.posunh:=-a;
   if FN_poloha.n=-2 then  {Nastane, je-li kurzor pred prvnim znakem na radku}
     begin
     FN_poloha.x:=w1;
     FN_poloha.y:=w3;
     FN_poloha.b:=NORMAL;  {Nalezeno. Uz s tim nebudeme hybat!}
     FN_poloha.trg:=true;
     end else
   if (FN_poloha.N=0) then {Nevim, jestli nekdy nastane}
      begin
      FN_poloha.x:=x;
      FN_poloha.y:=y;
      FN_poloha.b:=NORMAL;  {Nalezeno. Uz s tim nebudeme hybat!}
      FN_poloha.trg:=true;
      end else
   if (FN_poloha.N=a) then {Nastane, je-li kurzor nekde mezi znaky}
      begin
      {FN_poloha.x:=w1+fn_default_fn^.znak^[znak].shift+fn_default_fn^.add;}
      if mimo=-1 then
         begin
         FN_poloha.x:=x;
         FN_poloha.y:=y;
         end
         else begin
         FN_poloha.x:=w1+w4-fn_default_fn^.znak^[znak].relX;
         FN_poloha.y:=w3;
         end;
      FN_poloha.b:=NORMAL;  {Nalezeno. Uz s tim nebudeme hybat!}
      FN_poloha.trg:=true;
      end;
   end;
inc(a);
if k>0 then dec(k);
until a>delka;
FN_poloha.font:=fn_default;
if fn_ignore then FN_default_fn:=f;
end;

Procedure Print_FN(x,y:longint;s:pchar;e:fn);
var delka:longint;
begin
delka:=PLength(s);
Print_FN(x,y,s,delka,e);
end;

Procedure Print_FN(x,y:longint;p:string;e:fn); { jako OutTextXY }
var s:pchar;
    i:longint;
begin
i:=Length(p);
p:=p+#0;
s:=@p[1];
print_fn(x,y,s,i,e);
end;

Procedure Print_FN(x,y:longint;p:string;delka:longint;e:fn); { jako OutTextXY }
var s:pchar;
begin
p:=p+#0;
s:=@p[1];
print_fn(x,y,s,delka,e);
end;

Function Vyska_FN(f:fn):longint;
begin
Vyska_FN:=f^.so+f^.su;
end;

Function Vyska_FN_default:byte;
var f:fn;
    a:byte;
begin
f:=AktualniFont;
Vyska_FN_default:=Vyska_FN(f);
end;

Function Sirka_FN(s:pchar;e:fn;delka:longint):longint;
var b:longint;
    f:fn;
    d,a,c,x0,y0:longint;
    ap:byte;
    t,tt:string;
    zf:zas_fnt;
    zv:byte;

begin
if delka=0 then begin FN_skut_znak:=1;Sirka_FN:=0;Exit;end;
ZalohujZasobnikFontu(@zf,zv);
if FN_ignore then   { zapnuta inteligence }
   begin
   a:=Nacti_FNSLR(fn_default);
   f:=FN_selector^[a].font;{implicitni font nahran, bud z disku nebo z pameti}
   end else f:=e;
FN_default_fn:=f;
a:=1;
b:=0;
tt:=s;
FN_skut_znak:=1;
x0:=0;y0:=0;

repeat
t:=Vysekni_Tag(s,a,delka,d);
if t<>'' then Zpracuj_tag(t,x0,y0,false)
   else begin
   if fn_default_fn^.unicode=false then c:=byte(s[a-1])
      else begin
      c:=UTF82word(s,delka,a,ap);
      inc(a,ap-1);
      end;
   b:=b+fn_default_fn^.znak^[c].shift+fn_default_fn^.add;
   end;
inc(a,d);
inc(a);
inc(FN_skut_znak);
until a>delka;
FN_default_fn:=f;
ObnovZasobnikFontu(@zf,zv);
Sirka_FN:=b;
end;

Function Sirka_FN(s:pchar;e:fn):longint;
var x:longint;
begin
x:=PLength(s);
Sirka_FN:=Sirka_FN(s,e,x);
end;

Function Sirka_FN(s:string;e:fn):longint;
var p:pchar;
    i:longint;
begin
i:=Length(s);
s:=s+#0;
p:=@s[1];
Sirka_FN:=Sirka_FN(p,e,i);
end;

Function Sirka_FN(s:string;e:fn;delka:longint):longint;
var p:pchar;
begin
s:=s+#0;
p:=@s[1];
Sirka_FN:=Sirka_FN(p,e,delka);
end;

Function Sirka_FN_na_Xpoz(p:pchar;font:fn;x:longint):longint;
{Da sirku toho, co je pred kurzorem}
var c:char;
    xx:longint;
begin
dec(x);
c:=p[x];
p[x]:=#0;
xx:=Sirka_FN(p,font,x);
p[x]:=c;
Sirka_FN_na_Xpoz:=xx;
end;

Function _Pozice_v_Retezci(x,y,xs,ys:longint;s:pchar;delka:longint;e:fn):longint;
{X,Y relativni souradnice mysi bez pricteni Poc_Zobr}
{XS ze zacatku byva Poc_ZobrX a YS Poc_ZobrY}
var obx,bx,by,tt:longint;
    f:fn;
    d,a,c,x0,y0:longint;
    ap:byte;
    t:string;
  Function Potom(a:longint):longint;
  begin
  inc(FN_skut_znak);
  if fn_default_fn^.unicode=false then exit(a+1)
     else Exit(a+UniZnakVpred(s,a-1));
  end;

begin
FN_skut_znak:=1;
if s='' then
   begin
   FN_poz_v_ret_delka_radky:=0;
   Exit(1);
   end;
if x<xs then Exit(0);
if x=xs then Exit(1);
if FN_ignore then   { zapnuta inteligence }
   begin
   a:=Nacti_FNSLR(fn_default);
   f:=FN_selector^[a].font;{implicitni font nahran, bud z disku nebo z pameti}
   end else f:=e;

FN_default_fn:=f;
tt:=fn_default_fn^.so+fn_default_fn^.su;
a:=1;
bx:=xs;
by:=ys;
x0:=0;
y0:=0;
(*if y-by<0 then Exit(0);  {Pokud jsme na prvnim radku a zachytime sipku nahoru,}*)
repeat                   {tak skoc na uplne prvni znak}
t:=Vysekni_Tag(s,a,delka,d);
if t<>'' then
   begin
   Zpracuj_tag(t,x0,y0,false);
   tt:=fn_default_fn^.so+fn_default_fn^.su;
   end else
   if (s[a-1]=#13) and (s[a]=#10) then
      begin
      {MOMENTALNE NEPOUZIVANO}
      if {(y>=by) and} (by+fn_default_fn^.so+fn_default_fn^.su>=y) then
         begin
         FN_default_fn:=f;
         FN_poz_v_ret_delka_radky:=bx-xs+1;
         if a+1=delka then Exit(a-3);
         Exit(a-1);
         end;
      bx:=xs;
      by:=by+fn_default_fn^.so+fn_default_fn^.su;
      inc(a);
      {======================}
      end
   else begin
   if fn_default_fn^.unicode=false then c:=byte(s[a])
      else begin
      c:=UTF82word(s,delka,a,ap);
      inc(d,ap-1);
      end;
   obx:=bx;
   inc(bx,fn_default_fn^.znak^[c].shift+fn_default_fn^.add);
   if (bx>x) {and (y<=by+tt)} then
      begin
      FN_default_fn:=f;
      FN_poz_v_ret_delka_radky:=bx-xs+1;
      {Exit(a);}
      if bx-x>x-obx then Exit(a) else Exit(Potom(a));
      end;
   end;
inc(a,d);
inc(a);
inc(FN_skut_znak);
until a>delka;
FN_poz_v_ret_delka_radky:=bx-xs+1;
FN_default_fn:=f;
_Pozice_v_Retezci:=a;
end;

Function Pozice_v_Retezci(x,y,xs,ys:longint;s:pchar;e:fn):longint;
var i:longint;
begin
i:=PLength(s);
Pozice_v_Retezci:=Pozice_v_Retezci(x,y,xs,ys,s,i,e);
end;

Function Pozice_v_Retezci(x,y,xs,ys:longint;s:pchar;delka:longint;e:fn):longint;
var i:longint;
begin
i:=_Pozice_v_Retezci(x,y,xs,ys,s,delka,e);
if i=0 then i:=1;      {to je takovej vojeb - to by nikdy nastat nemelo :-(}
Pozice_v_Retezci:=i;
end;

Function VratPismeno(x,y:longint;var s:string;f:fn;xpoz,ypoz:longint):byte;
begin
FN_poloha.b:=URCIPOLOHU;
FN_poloha.x:=xpoz;
FN_poloha.y:=ypoz;
FN_poloha.n:=0;
Print_FN(x,y,s,f);
FN_poloha.b:=NORMAL;
VratPismeno:=FN_poloha.n;
end;

Procedure Init_FNSLR;
var a:byte;
begin
New(FN_selector);
for a:=1 to MAXFONT do
    begin
    FN_selector^[a].font:=nil;
    FN_selector^[a].ID:='';
    end;
end;

Procedure Znic_FNSLR;
var a:byte;
begin
for a:=1 to MAXFONT do
   if FN_selector^[a].font<>nil then
      begin
      Znic_FN(FN_selector^[a].font);
      FN_selector^[a].font:=nil;
      end;
Dispose(FN_selector);
end;

Function Nacti_FNSLR(s:string):byte;
var a,b:byte;
begin
b:=1;
s:=Convert_up(s);
for a:=1 to MAXFONT do
   if FN_selector^[a].font=nil then b:=a else
      if FN_selector^[a].id=s then
         begin
         NACTI_FNSLR:=a;
         Exit;
         end;

{ tady by melo byt inteligentni osetreni toho, kdyby byla tabulka plna,
  ale na to zatim kaslu }
if s=FN_FONT_VGA16 then
   begin
   FN_selector^[b].font:=FN_VGA16;
   FN_selector^[b].id:=FN_FONT_VGA16;
   end
   else
if s=FN_FONT_VGA16_U then
   begin
   FN_selector^[b].font:=FN_VGA16_u;
   FN_selector^[b].id:=FN_FONT_VGA16_U;
   end
   else
if s=FN_FONT_VGA14 then
   begin
   FN_selector^[b].font:=FN_VGA14;
   FN_selector^[b].id:=FN_FONT_VGA14;
   end
   else
if s=FN_FONT_VGA8 then
   begin
   FN_selector^[b].font:=FN_VGA8;
   FN_selector^[b].id:=FN_FONT_VGA8;
   end
   else
   begin
   Nacti_FN(s,FN_selector^[b].font);
   FN_selector^[b].id:=s;
   end;
Nacti_FNSLR:=b;
end;



Procedure LoadCharsetFromVGA(var c:charset;vyska:byte);
{Stahne jeden font z VGA do pameti.
 Pozn: VGA fonty jsou jiz stazene z hardwaroveho znakoveho generatoru
 jednotkou VenomGFX}

var b:Byte;
    p:^rawvgachar;
begin
if vyska=16 then p:=@rawvga16 else
if vyska=14 then p:=@rawvga14 else begin p:=@rawvga8;vyska:=8;end;

for b:=0 to 255 do
    Move(p^[b,1],c[b,1],vyska);

end;


Function LoadCharsetFromDisk(var c:charset;s:string):longint;
var f:file;
    l:longint;
    a:byte;
begin
Assign(f,s);
Reset(f,1);
l:=FileSize(f) div 256;
for a:=0 to 255 do BlockRead(f,c[a,1],l);
Close(f);
LoadCharsetFromDisk:=l;
end;


Function AnalyzujVGAFont(ch:PCharset;l:byte):boolean;
{Zanalyzuje VGA font, jestli pro definici znaku pismen vyuziva i 7.bit.
 Pokud totiz ano, tak neni bezpecne provadet zrcadleni 7.bitu do 8.bitu pro
 znaky $B0 az $DF}
var a:longint;
begin
for a:=1 to L do
    if odd(ch^[byte('M'),a]) then Exit(false);
AnalyzujVGAFont:=true;
end;


Procedure VGAfont_2_FN(s:string;var f:fn);
var ch:charset;
    a,b,c:byte;
    lh,ld,l,l9,r:longint;
    p:pbyte;
    ff:file;
    prac:array[0..4095] of byte;
    povol_8bit_copy:boolean;

begin
New(f);
if s=FN_FONT_VGA8 then
   begin
   LoadCharsetFromVGA(ch,8);
   l:=8;
   lh:=8;
   ld:=0;
   end else
if s=FN_FONT_VGA14 then
   begin
   LoadCharsetFromVGA(ch,14);
   l:=14;
   lh:=13;
   ld:=1;
   end else
if s=FN_FONT_VGA16_U then
   begin
   LoadCharsetFromVGA(ch,16);
   l:=16;
   lh:=14;
   ld:=2;
   end else
   begin
   l:=LoadCharsetFromdisk(ch,s);
   f^.jmeno:=s;
   end;
case l of
   8:begin lh:=8;ld:=0;end;
  14:begin lh:=13;ld:=1;end;
  16:begin lh:=13;ld:=3;end;
  else begin lh:=l;ld:=0;end;
end;
f^.first:=0;
f^.last:=255;
f^.poc_znaku:=256;
f^.so:=lh;
f^.su:=ld;
f^.add:=0;
f^.maxpred:=0;
f^.maxza:=9;
f^.maxnad:=-Lh;
f^.maxpod:=ld;
f^.unicode:=false;
f^.komp:=false;
GetMem(f^.znak,256*sizeof(znakdef));
L9:=9*L;

povol_8bit_copy:=AnalyzujVGAFont(@ch,L);

for a:=0 to 255 do
    begin
    {FillChar(prac,4096,0);}            {radeji si vymazeme pole}
    f^.znak^[a].relx:=0;
    f^.znak^[a].rely:=-Lh;
    f^.znak^[a].shift:=9;
    f^.znak^[a].sirka:=9;
    f^.znak^[a].vyska:=Lh+ld;
    f^.znak^[a].dp:=L9;
    p:=@prac;
    for b:=1 to L do
        begin
        Expand(ch[a,b],p);
        if (a>$b9) and (a<$e0) and (povol_8bit_copy=true)
           then                     { musime vyresit 9. bit znaku }
           begin                    { u znaku $C0 az $DF se do 9. bitu kopiruje 8. }
           inc(p,7);                { u ostatnich je prazdny }
           c:=p^;
           inc(p);
           p^:=c;
           end else
           begin
           inc(p,8);
           p^:=0;
           end;
        inc(p);
        end;

    GetMem(f^.znak^[a].data,L9);
    Move(prac,f^.znak^[a].data^,L9);
    end;
end;


Procedure StareNacitaniUnicode(s:string;var f:fn);
{Pouzitelne pouze pro pripad prevodu suroveho unicode fontu}
var a,b,c:longint;
    g:file;
    p,prac:pbyte;
    e,ff:fn;
begin
Assign(g,s);
Reset(g,1);
a:=FileSize(g);
GetMem(prac,a);
BlockRead(g,prac^,a);

New(f);
f^.first:=0;
f^.last:=65535;
f^.so:=32;
f^.su:=0;
f^.add:=0;
f^.maxpred:=0;
f^.maxza:=17;
f^.maxnad:=-32;
f^.maxpod:=0;
f^.unicode:=true;
f^.komp:=true;
GetMem(f^.znak,65536*sizeof(znakdef));
p:=prac;
{inc(p);}
for b:=0 to 65535 do
    begin
    f^.znak^[b].relx:=0;
    f^.znak^[b].rely:=-32;
    f^.znak^[b].shift:=17{9};
    f^.znak^[b].sirka:=16;
    f^.znak^[b].vyska:=32;
    f^.znak^[b].dp:=64;

    if (b<128) or (is_bitmap_empty(p^,64)=false) then
       begin
       GetMem(f^.znak^[b].data,64);
       Move(p^,f^.znak^[b].data^,64);
       end else f^.znak^[b].data:=nil;
    {spakovana varianta}
    inc(p,64);
    end;
FreeMem(prac,a);
Close(g);

{DekomprimujFont(f,e);
Make_Proporcional(e,ff);
KomprimujFont(ff);
f:=ff;
UlozUnicodeFont(f,'unibig.uf2');}
end;



Procedure CiziFormat_Do_FN(s:string;var f:fn);
var ch:charset;
    a,b,c,d:longint;
    p,z:pbyte;
    prac:pointer;
    g:file;
    e,ff:fn;
begin
Assign(g,s);
Reset(g,1);
a:=FileSize(g);
if (a=2048) or (a=4096) or (a=3584)then {jeste jedna moznost - neni to unicode font, ale}
   begin                 {obraz VGA fontu na disku}
   Close(g);
   VGAfont_2_FN(s,e);
   Make_proporcional(e,f);
   Znic_FN(e);
   KomprimujFont(f);
   Exit;
   end;
NactiUnicodeFont(s,f);
end;


Procedure MyVGA_2_FN;
var f8,f14,f16:fn;
begin
{asm mov ax,1102h;int 10h;end;}      {8x8}
VGAfont_2_FN(FN_FONT_VGA8,f8);
{asm mov ax,3;int 10h;end;
asm mov ax,1101h;int 10h;end;}      {8x14}
VGAfont_2_FN(FN_FONT_VGA14,f14);
{asm mov ax,3;int 10h;end;
asm mov ax,1104h;int 10h;end;}      {8x16}
VGAfont_2_FN(FN_FONT_VGA16_u,f16);
{asm mov ax,3;int 10h;end;}

Make_proporcional(f8,FN_VGA8);
KomprimujFont(fn_vga8);

Make_proporcional(f14,FN_VGA14);
KomprimujFont(fn_vga14);

Make_proporcional(f16,FN_VGA16);
KomprimujFont(fn_vga16);

FN_VGA16_u:=f16;
KomprimujFont(fn_vga16_u);

Znic_fn(f8);
Znic_fn(f14);
{a f16 ponecham}
end;


Procedure Charset_2_FN(s:string;var f:fn);
begin
VGAfont_2_FN(s,f);
end;

Procedure Make_proporcional(e:fn;var f:fn);
var a,c,d,l,vlevo,vpravo:longint;
    p:pointer;
    _v,_s:longint;
    h,ch:^byte;
    bod:boolean;
begin
New(f);
f^:=e^;
if e^.unicode then l:=65536 else l:=256;
GetMem(f^.znak,l*sizeof(znakdef));
for a:=f^.first to f^.last do
 if e^.znak^[a].data=nil then
    begin
    f^.znak^[a]:=e^.znak^[a];
    f^.znak^[a].data:=nil;
    end
    else begin
    f^.znak^[a]:=e^.znak^[a];
    vlevo:=0;
    vpravo:=0;
    p:=e^.znak^[a].data;
    bod:=false;
    for d:=0 to e^.znak^[a].sirka-1 do
        begin
        h:=p;
        inc(h,d);
        for c:=1 to e^.znak^[a].vyska do
            begin
            if h^<>0 then begin bod:=true;Break;end;
            inc(h,e^.znak^[a].sirka);
            end;
        if bod then Break else inc(vlevo);
        end;

    if bod=true then
       begin
       bod:=false;
       for d:=0 to e^.znak^[a].sirka-1 do
           begin
           h:=p;
           inc(h,e^.znak^[a].sirka-1);
           dec(h,d);
           for c:=1 to e^.znak^[a].vyska do
               begin
               if h^<>0 then begin bod:=true;Break;end;
               inc(h,e^.znak^[a].sirka);
               end;
           if bod then Break else inc(vpravo);
           end;
       {Znak vlevo orizneme o VLEVO a vpravo o VPRAVO}
       dec(f^.znak^[a].sirka,vpravo+vlevo);
       if vpravo+vlevo<>0 then dec(f^.znak^[a].shift,vpravo+vlevo-2);
       d:=f^.znak^[a].sirka;

       if f^.unicode and (vlevo<>0) then
          vlevo:=vlevo; {PRO DEBUGOVANI}

       f^.znak^[a].dp:=f^.znak^[a].vyska*f^.znak^[a].sirka;
       GetMem(f^.znak^[a].data,f^.znak^[a].dp);
       ch:=f^.znak^[a].data;
       for c:=0 to e^.znak^[a].vyska-1 do
           begin
           h:=p;
           inc(h,c*e^.znak^[a].sirka+vlevo);
           move(h^,ch^,d);
           inc(ch,d);
           end;


       {if f^.unicode then f^.znak^[a].shift:=20;}

       end else
       begin
       l:=e^.znak^[a].vyska*e^.znak^[a].sirka;
       e^.znak^[a].dp:=l;
       GetMem(f^.znak^[a].data,l);
       move(p^,f^.znak^[a].data^,l);
       end;
    end;
end;

Procedure DekomprimujFont(e:fn;var f:fn);
var a,b,c:longint;
    p,q:pbyte;
    prac:array[0..4095] of byte;
begin
New(f);
f^:=e^;
f^.komp:=false;
if e^.unicode then a:=65536 else a:=256;
GetMem(f^.znak,a*sizeof(znakdef));
for b:=e^.first to e^.last do
    if e^.znak^[b].data<>nil then
       begin
       f^.znak^[b]:=e^.znak^[b];
       c:=e^.znak^[b].dp*8;
       p:=e^.znak^[b].data;
       q:=@prac;
       for a:=1 to e^.znak^[b].dp do
           begin
           Expand(p^,q);
           inc(p);
           inc(q,8);
           end;

       GetMem(f^.znak^[b].data,c);
       move(prac,f^.znak^[b].data^,c);
       f^.znak^[b].dp:=c;
       end
       else begin
       f^.znak^[b]:=e^.znak^[b];
       f^.znak^[b].data:=nil;
       end;
end;

Procedure UlozUnicodeFont(f:fn;s:string);
var t:file;
    u:unifont_header;
    a,b,k:word;
    r:packed record b:byte;w:word;end;
    w:packed record dp:byte;sirka:byte;end;
begin
Assign(t,s);
Rewrite(t,1);
move(unimagic^,u.magic,4);
u.first:=f^.first;
u.last:=f^.last;
u.nahore:=f^.so;
u.dole:=f^.su;
BlockWrite(t,u,sizeof(unifont_header));
b:=0;
for a:=f^.first to f^.last do
    if f^.znak^[a].data=nil then inc(b)
       else begin
       if b<>0 then
          begin
          r.b:=0;  {tento znak je prazdny}
          r.w:=b;  {prazdnych znaku je tolik a tolik}
          BlockWrite(t,r,sizeof(r));
          b:=0;
          end;
       w.dp:=f^.znak^[a].dp;
       w.sirka:=f^.znak^[a].sirka;
       BlockWrite(t,w,sizeof(w));  {v kolika bajtech je znak ulozen}
       BlockWrite(t,f^.znak^[a].data^,w.dp);
       end;
if b<>0 then
   begin
   r.b:=0;  {tento znak je prazdny}
   r.w:=b;  {prazdnych znaku je tolik a tolik}
   BlockWrite(t,r,sizeof(r));
   end;
Close(t);
end;

Function ZkontrolujUnicodeFormat(s:string):boolean;
var f:file;
    p:array[1..4] of byte;
    q:pchar;
begin
Assign(f,s);
Reset(f,1);
if FileSize(f)<5 then
   begin
   Close(f);
   Exit(false);
   end;
q:=@p;
BlockRead(f,p,4);
Close(f);
ZkontrolujUnicodeFormat:=comparebyte(q^,unimagic^,4)=0;
end;

Procedure NactiUnicodeFont(s:string;var f:fn);
var t:file;
    p:pointer;
    q:pbyte;
    a,l:longint;
    b,c:word;
    u:unifont_header;
    dp,sirka:byte;
    maxs:longint;
begin
Assign(t,s);
Reset(t,1);
l:=FileSize(t);
GetMem(p,l);
BlockRead(t,p^,l);
q:=p;
Close(t);
New(f);
GetMem(f^.znak,65536*sizeof(znakdef));

Move(q^,u,sizeof(unifont_header));
inc(q,sizeof(unifont_header));
f^.first:=u.first;
f^.last:=u.last;
f^.so:=u.nahore;
f^.su:=u.dole;
f^.add:=0;
f^.poc_znaku:=0;
f^.maxpred:=0;
f^.maxza:=0;
f^.maxnad:=-u.nahore;
f^.maxpod:=u.dole;
f^.unicode:=true;
f^.komp:=true;
maxs:=0;
a:=u.first;
repeat
    dp:=q^;inc(q);
    if dp=0 then   {nulovy bajt - to znamena, ze bude nasledovat B nedefinovanych znaku}
       begin
       move(q^,b,2);inc(q,2);
       for c:=a to a+b-1 do
           begin
           f^.znak^[c].data:=nil;
           f^.znak^[c].shift:=8;
           f^.znak^[c].dp:=0;
           f^.znak^[c].rely:=-u.nahore;
           end;
       inc(a,b);
       end
       else begin
       sirka:=q^;inc(q);
       if sirka>maxs then maxs:=sirka;
       f^.znak^[a].dp:=dp;
       GetMem(f^.znak^[a].data,dp);
       Move(q^,f^.znak^[a].data^,dp);inc(q,dp);
       f^.znak^[a].relx:=0;
       f^.znak^[a].rely:=-u.nahore;
       f^.znak^[a].sirka:=sirka;
       f^.znak^[a].shift:=sirka+2;
       f^.znak^[a].vyska:=u.nahore+u.dole;
       inc(f^.poc_znaku);
       inc(a);
       end;
until a>u.last;
f^.maxza:=maxs;
FreeMem(p,l);
end;

Function OdstranTagy(s:ansistring):ansistring;
var i,j,k,l:longint;
    t:ansistring;
begin
i:=1;
t:='';
j:=Length(s);
if j=0 then
   begin
   OdstranTagy:='';
   Exit;
   end;
repeat
if (s[i]='<') then
   if (s[i+1]='<') then begin inc(i);t:=t+'<<';end
     else begin
     {nasli jsme tag}
     k:=i;
     while s[i]<>'>' do inc(i);
        {if i<=j then inc(i) else begin dec(i);Break;end;}
     end
     else t:=t+s[i];
inc(i);
until i>j;
OdstranTagy:=t;
end;

Function SmazMezery_v_tagach(t:ansistring):ansistring;
var a,b,j:longint;
    v_tagu:boolean;
begin
a:=1;
j:=Length(t);
v_tagu:=false;
repeat
b:=1;
if t[a]='>' then v_tagu:=false else
if t[a]='<' then v_tagu:=not v_tagu else
   if v_tagu and (t[a]=' ') then
      begin delete(t,a,1);dec(j);b:=0;end;
inc(a,b);
until a>j;
SmazMezery_v_tagach:=t;
end;

Function PocetTagu(s:ansistring):longint;
var i,j,k,l:longint;
begin
i:=1;
l:=0;
j:=Length(s);
repeat
if (s[i]='<') then
   if (s[i+1]='<') then inc(i)
     else begin
     {nasli jsme tag}
     k:=i;
     while s[i]<>'>' do inc(i);
        {if i<=j then inc(i) else begin dec(i);Break;end;}
     inc(l);
     end;
inc(i);
until i>j;
PocetTagu:=l;
end;

Function Dej_nty_tag(s:ansistring;n:longint):string;
var i,j,k,o:longint;
    t:string;
begin
i:=1;
o:=0;
t:='';
j:=Length(s);
repeat
if (s[i]='<') then
   if (s[i+1]='<') then inc(i)
     else begin
     {nasli jsme tag}
     k:=i;
     inc(o);
     while s[i]<>'>' do inc(i);
        {if i<=j then inc(i) else begin dec(i);Break;end;}
     if o=n then
        begin
        t:=Copy(s,k,i-k+1);
        break;
        end;
     end;
inc(i);
until i>j;
Dej_nty_tag:=t;
end;

Function Jsou_def_znaky_FN(s:string;f:fn):longint;
var i,j:longint;
    ap:byte;
    w:word;
begin
s:=OdstranTagy(s);
j:=Length(s);
i:=1;
if f^.unicode then
   repeat
   w:=UTF82word(@s[1],j,i,ap);
   if f^.znak^[w].data=nil then Exit(i);
   inc(i,ap);
   until i>j
   else
   for i:=1 to Length(s) do
       if f^.znak^[byte(s[i])].data=nil then Exit(i);
Jsou_def_znaky_FN:=0;
end;

Function NajdiTag(s:ansistring;tag:string;var separat:string):longint;
var a,b,c,d:longint;
    v_tagu:boolean;
    t:ansistring;
begin
b:=Length(s);
v_tagu:=false;
tag:=Convert_Up(tag);
c:=Length(tag);
t:=Convert_Up(s);
for a:=1 to b do
    begin
    if t[a]='>' then v_tagu:=false else
    if t[a]='<' then v_tagu:=not v_tagu else
    if v_tagu and (Copy(t,a,c)=tag) then
       begin
       d:=a;
       repeat inc(d);
       until (d>=b) or (t[d+1]=';') or (t[d+1]='>');
       separat:=Mid(s,a,d);
       Exit(a);
       end;
    end;
separat:='';
NajdiTag:=0;
end;

Function Fnatrb_na_pozici(s:ansistring;i:longint;tag:string):fnatrb;
begin

end;


Procedure LokalizujSlovo_FN(t:pchar;delka,p:longint;uni:boolean;za_mez:byte;var z,k:longint);
{vstup:  T=zdrojovy text, P=pozice v textu, UNI=unicode?,
         ZA_MEZ=jak zareagovat pokud se prvotne odkazujeme na mezeru
            0: rovnou ohlas Z=-1, K=-1
            1: krokuj zpet dokud nenarazis na slovo
            2: krokuj vpred dokud nenarazis na slovo
 vystup: Z=odkud je slovo, K=kam je slovo
 POZN: vsechny pozice jsou pocitany od 0 (abych byl konzistentni se zbytkem unity)}
var a,b,j:longint;
    v_tagu:boolean;
begin
if p<0 then p:=0;                {mensi nez min?}
if p>delka-1 then p:=delka-1;    {vetsi nez max?}
if b>2 then b:=2;                {omezeni na definovane hodnoty}
a:=p;
{napred poresime pripad, ze na uvedene pozici je mezera}
if t[p]=' ' then
   if za_mez=0 then begin z:=-1;k:=-1;Exit;end else
   if za_mez=1 then
      begin
      while t[p]=' ' do
         begin     {t.j. za_mez=true}
         b:=FNznakZpet(t,delka,p,uni,j);
         if b=0 then begin z:=-1;k:=-1;Exit;end {dosazeno zacatku retezce}
                else dec(p,b);
         end;
      end
      else
      while t[p]=' ' do
         begin     {t.j. za_mez=true}
         b:=FNznakVpred(t,delka,p,uni,j);
         if b=0 then begin z:=-1;k:=-1;Exit;end {dosazeno konce retezce}
                else inc(p,b);
         end;

{jsme v bode, kdy vime, ze P neni na mezere}
a:=p;
z:=0;
k:=delka-1;

while (a>=0) and (t[a]<>' ') do
   begin
   b:=FNznakZpet(t,delka,a,uni,j);
   if b=0 then a:=-1 else dec(a,b);
   end;
inc(a);  {chceme prvni pismeno slovo, nikoliv posledni znak mezer}
if a<0 then a:=0;   {nemelo by nastat, ale pro jistotu...}
z:=a;   {mame lokalizovany zacatek slova}


while (p<delka) and (t[p]<>' ') do
   begin
   b:=FNznakVpred(t,delka,p,uni,j);
   if b=0 then p:=delka else inc(p,b);
   end;
dec(p);  {chceme posledni pismeno slovo, nikoliv prvni znak mezer}

if p>delka-1 then p:=delka-1;
k:=p;
end;


Procedure LokalizujSlovo_FN_s(s:string;p:longint;uni:boolean;za_mez:byte;var z,k:longint);
var q:pchar;
    dlk:byte;
begin
dlk:=Length(s);
s:=s+#0;
q:=@s[1];
LokalizujSlovo_FN(q,dlk,p-1,uni,za_mez,z,k);
end;


Procedure Lokalizuj_Nte_slovo_FN(t:pchar;delka,sl:longint;uni:boolean;var z,k:longint);
var a,p:longint;
begin
if sl<1 then begin z:=-1;k:=-1;Exit;end;
a:=0;
p:=0;
repeat
   LokalizujSlovo_FN(t,delka,p,uni,2{krokuj vpred},z,k);
   if z=-1 then Exit;{Z=K=-1} {neni co lokalizovat, v retezci jsou jen mezery}
   inc(a);
   p:=k+1;
   if a<sl then
      if p>delka-1 then begin z:=-1;k:=-1;Exit;end;
until a=sl;
end;


Function ZjistiKolikateSlovo_FN(t:pchar;delka,p:longint;uni:boolean):longint;
{Pred prvnim slovem vraci 0, mezi slovy vraci cislo predesleho}
var a,z,k:longint;
begin
a:=0;
repeat
   LokalizujSlovo_FN(t,delka,p,uni,1{krokuj zpet},z,k);
   if z=-1 then Exit(a);
   p:=z-1;
   inc(a);
until z=0;
ZjistiKolikateSlovo_FN:=a;
end;


Function FNznakVpred(p:pchar;delka,i:longint;uni:boolean;var j:longint):longint;
var n:longint;
begin
if i<0 then i:=0;
if i>delka-1 then Exit(0);
n:=i;
j:=0;
if p[i]='<' then
   if p[i+1]='<' then Exit(2)
   else begin
   inc(i);
   while p[i]<>'>' do inc(i);
   inc(i);
   j:=i-n;
   end
else if p[i]='>' then Exit(2);
if uni then Exit(i-n+UniZnakVpred(p,i)) else Exit(i-n+1);
end;

Function FNznakZpet(p:pchar;delka,i:longint;uni:boolean;var j:longint):longint;
{I perdpoklada cislovat od 0, tak jak je to u PCharu}
var n:longint;
    pp:string;
begin
if i>delka-1 then i:=delka-1;    {abychom nebyli za retezcem}
if i<=0 then Exit(0);          {Vice vlevo jiz nelze?}
n:=i;
j:=0;
pp:=p;
if p[i-1]='>' then
   if p[i-2]='>' then Exit(2)
   else begin
   dec(i);
   while p[i-1]<>'<' do dec(i);
   dec(i);
   j:=n-i;
   end
else if p[i-1]='<' then Exit(2);
if uni then Exit(n-i+UniZnakZpet(p,i)) else Exit(n-i+1);
end;

Function FNznakZpet_s(s:string;i:longint;uni:boolean;var j:longint):longint;
{I predpoklada cislovat od 1, tak jak je u stringu zvykem}
var p:pchar;
    dlk:byte;
begin
dlk:=Length(s);
s:=s+#0;
p:=@s[1];
FNznakZpet_s:=FNznakZpet(p,dlk,i-1,uni,j);
end;


Function Dej_Pocet_Slov_FN(t:pchar;delka:longint;uni:boolean):longint;
var a:longint;
begin
a:=ZjistiKolikateSlovo_FN(t,delka,delka,uni);
Dej_Pocet_Slov_FN:=a;
end;


Function PrvniVyskytZnaku(p:pchar;z:char;poz:longint):longint;
var i,j:longint;
    vtagu:boolean;
begin
dec(poz,2);
vtagu:=false;
repeat
inc(poz);
if (p[poz]=z) and (vtagu=false) then Exit(poz+1);
if p[poz]='<' then
   if p[poz+1]='<' then inc(poz) else vtagu:=true;
if p[poz]='>' then vtagu:=false;
until p[poz]=#0;
PrvniVyskytZnaku:=0;
end;

Procedure FontAdr(s:string);
begin
if ExistDir(s)=false Then Exit;
fn_adresar:=s;
end;

Function GetFontAdr:string;
begin
GetFontAdr:=fn_adresar;
end;

Procedure Urci_adresar_s_fonty;
var s:string;
begin
s:=GetEnv('fnfontpath');
if s<>'' then FontAdr(s);
FN_adresar:=s;
end;

Procedure Init_FNfont2;
begin
MyVGA_2_FN;
Init_FNSLR;
Nacti_FNSLR(FN_FONT_VGA16);
Nacti_FNSLR(FN_FONT_VGA16_U);
Nacti_FNSLR(FN_FONT_VGA14);
Nacti_FNSLR(FN_FONT_VGA8);
UlozNaZasobnikFontu(FN_FONT_VGA16);
Urci_adresar_s_fonty;
FN_poloha.b:=NORMAL;
NastavVystup(vga);
end;

begin
Init_FNfont2;
end.
