' переход на указанную линию
' параметр:
' iRow - номер строки , на которую надо перейти
sub GotoLine(iRow as Long)
	
	' если строка в диапазоне имеющихся строк
	if iRow > 0 andalso iRow <= pObj.pList.GetSize() then
		
		dim as Long iWinRow
		
		' если строка больше числа строк на экране
		if iRow > pObj.iHeightRows-2 then
			
			' устанавливаем начальное смещение по высоте в экране
			pObj.iStartRowInWindow = iRow - (pObj.iHeightRows-2)
			
			' строка окажется самой последней в экране , не считая статусбара
			iWinRow = pObj.iHeightRows-1
			
		else
		
			' устанавливаем начальное смещение по высоте в экране на самое начало
			pObj.iStartRowInWindow = 1
			
			' строка будет равна параметру функции
			iWinRow = iRow
			
		EndIf
		
		' переходим на строку , курсор в начале строки
		SetPositionWithPosAndRow(1 , iWinRow , pObj.iStartRowInWindow , 1)
		
	endif
	
End Sub

' просто отдельный обработчик событий для перехода на строку
' режим GOTO
sub GotoBox()
	
	dim as Long iKey ' буфер для клавиши
	
	dim as string sBuf ' буфер для введенной строки
	
	dim as Long iCountLines = pObj.pList.GetSize() ' общее кол-во строк
	
	dim as string sInitial = "Goto line [1-" & iCountLines & "] :" ' начальная строка с кол-вом строк
	
	ClearLine(pObj.iHeightRows) ' очистка последней строки на экране
	
	DrawInPos(0 , sInitial , pObj.iHeightRows , 1 , (pObj.iColorBackGround shl 4) or pObj.iColorStatusBar) ' печатаем начальную строку
	
	do
		
		dim as Long iKey = GetOnlyAscKey() ' получим любой не юникод символ
		
		select case iKey ' что это за клавиша
			
			Case CVK_ENTER
				
				dim as long iRow = val(sBuf) ' переводим строковое значение в числовое
				
				if iRow <= iCountLines andalso iRow > 0 then ' если в диапазоне имеющихся строк
					
					GotoLine(iRow) ' переходим на строку
					
					exit do ' выходим из цикла
					
				EndIf
				
			Case CVK_BACKSPACE
				
				sBuf = left(sBuf , len(sBuf)-1) ' отрезаем от буфера один символ
				
				ClearLine(pObj.iHeightRows) ' очищаем строку
				
				' печатаем строку
				DrawInPos(0 , sInitial & sBuf , pObj.iHeightRows , 1 , (pObj.iColorBackGround shl 4) or pObj.iColorStatusBar)
				
			case 48 to 57 ' если вводим числа
				
				if len(sBuf) < 7 then ' если номер строки меньше 1000000 :)
					
					sBuf &= chr(iKey) ' заносим символ в буфер
					
				EndIf
				
				ClearLine(pObj.iHeightRows) ' очищаем строку
				
				' печатаем строку
				DrawInPos(0 , sInitial & sBuf , pObj.iHeightRows , 1 , (pObj.iColorBackGround shl 4) or pObj.iColorStatusBar)
				
			case CVK_ESC
			
				exit do ' выходим из режима GOTO
			
		End Select
		
	Loop
	
	' очистим последние линии
	ClearLine(pObj.iHeightRows-1)
	ClearLine(pObj.iHeightRows)
	
End Sub