 /*
 *    TTTTTTTTTTTTTT  EEEEEEEEEEEEEE  OOOOOOOOOOOOOO
 *    TTTTTTTTTTTTTT  EEEEEEEEEEEEEE  OOOOOOOOOOOOOO
 *          TT        EE              OO          OO
 *          TT        EE              OO          OO
 *          TT        EE              OO          OO
 *          TT        EEEEEEEEEE      OO          OO
 *          TT        EEEEEEEEEE      OO          OO
 *          TT        EE              OO          OO
 *          TT        EE              OO          OO
 *          TT        EE              OO          OO
 *          TT        EEEEEEEEEEEEEE  OOOOOOOOOOOOOO
 *          TT        EEEEEEEEEEEEEE  OOOOOOOOOOOOOO
 *
 *                  L'mulateur Thomson TO8
 *
 *  Copyright (C) 1997-2017 Gilles Ftis, Eric Botcazou, Alexandre Pukall,
 *                          Jrmie Guillaume, Franois Mouret
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *  Module     : debug/dacc.c
 *  Version    : 1.8.4
 *  Cr par   : Gilles Ftis & Franois Mouret 10/05/2014
 *  Modifi par: Franois Mouret 04/06/2015 16/11/2015 14/07/2016
 *
 *  Dbogueur 6809 - Affichage des accumulateurs.
 */


#ifndef SCAN_DEPEND
   #include <stdio.h>
#endif

#include "defs.h"
#include "teo.h"
#include "mc68xx/mc6809.h"


/* ------------------------------------------------------------------------- */


void dacc_GetDumpFor16Bits (char *p, int address)
{ 
    int i;
    int c;

    *p = '\0';
    address &= 0xffff;

    /* write address */
    p += sprintf (p, "%04X  ", address);

    /* write bytes */
    for (i=0; i<8; i++)
        p += sprintf(p, "%02X ",
                     mc6809_interface.LoadByte((address+i)&0xffff));

    /* write characters */
    p += sprintf(p, " ");
    for (i=0; i<8; i++)
    {
        c = mc6809_interface.LoadByte((address+i)&0xffff);
        switch (c&0xff)
        {
            default :
                if ((c<0x20) || (c>0x7e))
                    p += sprintf(p, ".");
                else
                    p += sprintf(p, "%c", c);
                break;
        }
    }
}

