/*********************************************************
 * cc90hfe (c) Teo Developers
 *********************************************************
 *
 *  Copyright (C) 2012-2017 Franois Mouret
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *  Module     : cc90.c
 *  Version    : 0.7.0
 *  Cr par   : Franois Mouret 27/02/2013
 *  Modifi par: Franois Mouret 27/07/2013 31/05/2015
 *
 *  Management of CC90 interface.
 */


/*
 * 0 'SAVE"INSTALL.BAS",A
 * 5 '
 * 10 DATA "8EE7E0CE45001A50",&H3D2
 * 15 DATA "4F5FED02CC03FFED",&H458
 * 20 DATA "84CC043CED028D2F",&H33B
 * 25 DATA "1F988D2B33CB8D27",&H321
 * 30 DATA "1F988D23E7C04A26",&H37E
 * 35 DATA "F9E684C42026FACC",&H533
 * 40 DATA "0A02E700C6031E88",&H262
 * 45 DATA "1F884A26F58D0827",&H2C8
 * 50 DATA "D5E784ECC36ECB34",&H55C
 * 55 DATA "02C601E784E6842B",&H3C9
 * 60 DATA "FCE6842BF8C6801E",&H4ED
 * 65 DATA "881F88A600485624",&H297
 * 70 DATA "F63582",&H1AD
 * 75 '
 * 80 LOCATE,,0:CLS:CONSOLE,,1
 * 85 D=PEEK(&HFFF2)
 * 90 IF D<128 THEN D=16384 ELSE D=0
 * 95 A=D
 * 100 FOR I=1 TO 13
 * 105  READ A$,C:R=0
 * 110  FOR J=1 TO LEN(A$)-1 STEP2
 * 115   V=VAL("&H"+MID$(A$,J,2))
 * 120   R=R+V
 * 125   POKE A,V
 * 130   A=A+1
 * 135  NEXTJ
 * 140  IF R<>C THEN PRINT"Error line";I;"of datas (&H";HEX$(R);"<>&H";HEX$(C);")":END
 * 145 NEXTI
 * 150 '
 * 155 A=D/256
 * 160 POKE D+1,&HA7+A:POKE D+4,&H05+A
 * 165 EXEC D
*/

#ifndef SCAN_DEPEND
   #include <stdio.h>
   #include <stdlib.h>
   #include <unistd.h>
   #include <string.h>
   #include <ctype.h>
   #include <time.h>
#endif

#include "defs.h"
#include "main.h"
#include "cc90.h"
#include "serial.h"
#include "port.h"
#include "std.h"
#include "errors.h"

#define CC90_VERSION_CODE  1

#define CC90_CODE_BREAK         0
#define CC90_CODE_ASK           1
#define CC90_CODE_LOADSECTORS   2
#define CC90_CODE_SAVESECTORS   3
#define CC90_CODE_SENDMEMORY    4
#define CC90_CODE_GETMEMORY     5
#define CC90_CODE_FORMATDISK    6
#define CC90_CODE_LOADMFMTRACK  7
#define CC90_CODE_SAVEMFMTRACK  8

#define CC90_CONTROLLER_THMFC1    6
#define CC90_CONTROLLER_WD2793    5
#define CC90_CONTROLLER_CD90_640  4
#define CC90_CONTROLLER_CD90_015  3
#define CC90_CONTROLLER_INT_QDD   2
#define CC90_CONTROLLER_CQ90_028  1
#define CC90_CONTROLLER_UNKNOWN   0

#define CC90_COMPUTER_MO       0x00
#define CC90_COMPUTER_TO       0x08
#define CC90_COMPUTER_MO5      (0x00 | CC90_COMPUTER_MO)
#define CC90_COMPUTER_MO6      (0x01 | CC90_COMPUTER_MO)
#define CC90_COMPUTER_TO7      (0x00 | CC90_COMPUTER_TO)
#define CC90_COMPUTER_TO770    (0x01 | CC90_COMPUTER_TO)
#define CC90_COMPUTER_TO9      (0x02 | CC90_COMPUTER_TO)
#define CC90_COMPUTER_TO8      (0x03 | CC90_COMPUTER_TO)
#define CC90_COMPUTER_TO9P     (0x06 | CC90_COMPUTER_TO)

#define THOMSON_MFM_TRACK_POSITION  0x4000
#define CC90_WRITE_TRACK_LENGTH     6248
#define CC90_READ_TRACK_LENGTH      7400

#define CC90_SYS_COMPUT            1
#define CC90_SYS_COMPUT_TYPE_MASK  0x0f
#define CC90_SYS_CONFIG            2
#define CC90_SYS_CONFIG_DSTY_MASK  0x08
#define CC90_SYS_CONFIG_CTRL_MASK  0x07
#define CC90_SYS_VERSION           3

#define CURRENT_BANK 0

#define THOMSON_INIT_DRIVE      0x0001

#define MASK_DISK_PROTECT  0x80

#define DATA_SIZE_MAX  1024


#define FIELD_ERROR    -1
#define FIELD_AS_IS     0
#define FIELD_REBUILT   1

#define TRACK_ERROR    -1
#define TRACK_OK        0

enum {
    RELATIVE_ADDR_MSB = 0,
    RELATIVE_ADDR_LSB,
    DATA_SIZE,
    RELATIVE_EXEC_MSB,
    RELATIVE_EXEC_LSB,
    SEND_COMMAND,
    INSTALL_BUFFER_SIZE
};

#define WAIT_FOR_NEXT      0x00  /* cts on  */
#define TRANSMISSION_STOP  0x03  /* cts off */

/* cc90 variables */
static int mfm_track_ptr = THOMSON_MFM_TRACK_POSITION+0x4000;

/* storage variables */
static uint8 *tmp_track = NULL;
static uint8 *tmp_data  = NULL;
static uint8 *tmp_clck  = NULL;
static int src_i;
static int dst_i;

/* synchronization analyser variables */
static int gap_i;
static int synchro_i;
static int data_i;
static int synchro_length;

static uint8 cc90_bin[] = {
    0x00, 0x00, 0x80, 0x00, 0x3e,
    0x7e, 0x00, 0x00, 0x30, 0x8d, 0x07, 0x90, 0x96, 0x36, 0x17, 0x08, 0x49,
    0x1a, 0x50, 0x10, 0x9e, 0x09, 0x33, 0x8c, 0xd7, 0x8e, 0x00, 0x06, 0x17,
    0x04, 0x63, 0xd6, 0x29, 0xc1, 0x09, 0x24, 0x13, 0x30, 0x8c, 0x07, 0xe6,
    0x85, 0x3a, 0xad, 0x84, 0x20, 0xe2, 0x09, 0x3d, 0x86, 0x83, 0xa6, 0xd2,
    0xd9, 0xf0, 0xf7, 0xc6, 0x03, 0x10, 0xde, 0x3c, 0x34, 0x04, 0x17, 0x07,
    0xe7, 0x10, 0x9e, 0x07, 0x86, 0x01, 0xa7, 0xa4, 0x8e, 0x00, 0x2c, 0x30,
    0x00, 0x3d, 0xe6, 0xa4, 0x2a, 0xf6, 0x30, 0x1f, 0x26, 0xf7, 0xe6, 0xe0,
    0xc1, 0x02, 0x25, 0x03, 0x17, 0x06, 0x19, 0x86, 0x03, 0xa7, 0xa4, 0xa6,
    0xa4, 0x84, 0x40, 0x27, 0xfa, 0x20, 0x9c, 0xd6, 0x2a, 0xc4, 0x0f, 0x9e,
    0x09, 0xe7, 0x01, 0xd6, 0x2a, 0x17, 0x00, 0xd1, 0xd6, 0x2a, 0x58, 0x2a,
    0x03, 0x17, 0x01, 0x72, 0xd6, 0x35, 0xc1, 0x0b,

    0x00, 0x00, 0x80, 0x00, 0xbe,
    0x25, 0x12, 0xd6, 0x2b, 0x54, 0x54, 0x54, 0xf7, 0x60, 0x7c, 0xdc, 0x2b,
    0x58, 0x49, 0x84, 0x0f, 0x54, 0xfd, 0x60, 0x7d, 0x96, 0x11, 0xd6, 0x12,
    0x44, 0x59, 0x58, 0x58, 0x58, 0xda, 0x13, 0xd7, 0x31, 0x8d, 0x21, 0x33,
    0x8d, 0xff, 0x4a, 0x8e, 0x00, 0x06, 0x16, 0x04, 0xf8, 0x86, 0x08, 0x8c,
    0x86, 0x02, 0x8d, 0x13, 0xd6, 0x2a, 0xed, 0x20, 0xd6, 0x2b, 0x4f, 0xed,
    0x22, 0xdc, 0x2c, 0xdd, 0x0d, 0x17, 0x00, 0xc7, 0x16, 0x05, 0xac, 0xc6,
    0x07, 0x0d, 0x10, 0x10, 0x26, 0xff, 0x66, 0x39, 0x8d, 0x1e, 0xe6, 0xc4,
    0x63, 0xc4, 0xe1, 0xc4, 0x10, 0x27, 0x07, 0x37, 0xe7, 0xc4, 0x30, 0x84,
    0x27, 0x07, 0x8d, 0xe0, 0x17, 0x03, 0xae, 0x20, 0xdb, 0x10, 0xde, 0x3c,
    0x8d, 0xd6, 0x6e, 0xc4, 0xd6, 0x2a, 0x27, 0x03, 0x17, 0x06, 0xa3, 0xde,
    0x2b, 0x9e, 0x2d, 0x39, 0x8d, 0xf2, 0x8d, 0xc4,

    0x00, 0x00, 0x80, 0x01, 0x3e,
    0x16, 0x04, 0xa2, 0x8d, 0xc2, 0xc6, 0x10, 0xe7, 0x20, 0x9d, 0x3e, 0x86,
    0x80, 0xd6, 0x2a, 0xed, 0x20, 0xd6, 0x2b, 0xe7, 0x25, 0x17, 0x00, 0xa1,
    0x20, 0xaa, 0x8d, 0x0c, 0x17, 0x05, 0xf6, 0x20, 0xa3, 0x8d, 0x05, 0x17,
    0x05, 0x5f, 0x20, 0x9c, 0x17, 0xff, 0x9c, 0xc6, 0x0a, 0x96, 0x31, 0x84,
    0x07, 0x81, 0x06, 0x10, 0x26, 0xfe, 0xfe, 0xdc, 0x2a, 0xa7, 0x21, 0x4f,
    0xed, 0x22, 0x39, 0x3a, 0x31, 0x28, 0x27, 0x30, 0x34, 0xd8, 0x0f, 0x2a,
    0x41, 0xc6, 0x07, 0x96, 0x35, 0x81, 0x0b, 0x10, 0x25, 0xfe, 0xe2, 0xf6,
    0x60, 0x81, 0xc8, 0x80, 0xd7, 0x0f, 0xf7, 0x60, 0x81, 0xf7, 0xe7, 0xe7,
    0x34, 0x70, 0x30, 0x8d, 0xfe, 0x6c, 0x33, 0x8d, 0xfe, 0x6c, 0x10, 0x8e,
    0x00, 0x04, 0x8d, 0x0e, 0x9e, 0x09, 0x33, 0x8d, 0xfe, 0x64, 0x10, 0x8e,
    0x00, 0x11, 0x8d, 0x02, 0x35, 0xf0, 0xa6, 0x84,

    0x00, 0x00, 0x80, 0x01, 0xbe,
    0xe6, 0xc4, 0xe7, 0x80, 0xa7, 0xc0, 0x31, 0x3f, 0x26, 0xf4, 0x39, 0x8d,
    0x0a, 0xe6, 0x20, 0xc4, 0x08, 0x27, 0x25, 0xc6, 0x02, 0xe7, 0x20, 0x33,
    0x8d, 0x00, 0xef, 0xa6, 0xc0, 0x27, 0x19, 0x91, 0x0d, 0x25, 0xf8, 0x91,
    0x0e, 0x22, 0xf4, 0xa7, 0x24, 0x4a, 0xd6, 0x11, 0x27, 0x02, 0x44, 0x56,
    0xd3, 0x3a, 0xed, 0x27, 0x8d, 0x18, 0x20, 0xe3, 0x39, 0xdc, 0x3a, 0xed,
    0x27, 0x9e, 0x3f, 0xad, 0x06, 0x59, 0x6d, 0x23, 0x27, 0x02, 0x6a, 0x23,
    0x54, 0x25, 0x11, 0x39, 0xe7, 0x20, 0x9d, 0x3e, 0x24, 0xe6, 0xa6, 0x26,
    0x85, 0x51, 0x26, 0x04, 0x9d, 0x3e, 0x24, 0xdc, 0xa6, 0x26, 0xc6, 0x06,
    0x85, 0x51, 0x27, 0x07, 0xc6, 0x08, 0x44, 0x24, 0x02, 0xc6, 0x05, 0x16,
    0xfe, 0x47, 0x34, 0x70, 0x17, 0xfe, 0xd4, 0x33, 0x8d, 0x00, 0x92, 0x86,
    0x24, 0xa7, 0xc6, 0x81, 0x10, 0x23, 0x02, 0x6f,

    0x00, 0x00, 0x80, 0x02, 0x3e,
    0xc6, 0x97, 0x12, 0x4a, 0x26, 0xf3, 0x0f, 0x11, 0xde, 0x09, 0xe6, 0x41,
    0xc1, 0x04, 0x27, 0x1b, 0xd6, 0x13, 0x27, 0x08, 0x0c, 0x11, 0xc1, 0x02,
    0x23, 0x02, 0x8d, 0x11, 0x9e, 0x3a, 0x10, 0x8e, 0x08, 0x00, 0xce, 0xe5,
    0xe5, 0xef, 0x81, 0x31, 0x3f, 0x26, 0xfa, 0x35, 0xf0, 0x0f, 0x11, 0xc1,
    0x04, 0x25, 0x11, 0xc6, 0x40, 0x8d, 0x95, 0xc6, 0x10, 0x8d, 0x91, 0x8d,
    0x71, 0x4d, 0x26, 0x06, 0xc6, 0x04, 0x8d, 0x88, 0x0c, 0x11, 0x8d, 0x71,
    0xd7, 0x12, 0x26, 0x02, 0xc6, 0x07, 0x34, 0x04, 0x33, 0x8c, 0x49, 0x4f,
    0x5f, 0x4c, 0xa7, 0xc5, 0xeb, 0xe4, 0x5a, 0x5c, 0xc4, 0x0f, 0x6d, 0xc5,
    0x27, 0xf3, 0x81, 0x10, 0x26, 0xf5, 0x30, 0x8c, 0x21, 0x4f, 0xe6, 0xc6,
    0xe7, 0x80, 0x6f, 0xc6, 0xd6, 0x13, 0xc1, 0x04, 0x25, 0x06, 0x0d, 0x11,
    0x27, 0x01, 0x4c, 0x4c, 0x4c, 0x84, 0x0f, 0x6d,

    0x00, 0x00, 0x0a, 0x02, 0xbe,
    0xc6, 0x26, 0xe7, 0x5c, 0xc1, 0x16, 0x26, 0xf4, 0x35, 0x84,

    0x00, 0x00, 0x80, 0x02, 0xec,
    0xd6, 0x13, 0xc1, 0x06, 0x10, 0x26, 0x01, 0x9b, 0x16, 0x00, 0xce, 0x1a,
    0x50, 0xd6, 0x13, 0x27, 0x14, 0xc1, 0x06, 0x10, 0x26, 0x00, 0xef, 0x33,
    0x8d, 0x00, 0xbe, 0x0d, 0x11, 0x27, 0x03, 0x33, 0x8c, 0x04, 0x16, 0x01,
    0x61, 0x39, 0x34, 0x76, 0xce, 0xfe, 0xc7, 0x86, 0x38, 0x8d, 0x61, 0xc6,
    0x06, 0x33, 0x8c, 0x56, 0x30, 0x1f, 0x27, 0x48, 0xa6, 0xa4, 0x85, 0x01,
    0x27, 0xf6, 0xa6, 0x23, 0x86, 0x28, 0xa7, 0xa4, 0xa6, 0xa4, 0x2a, 0xfc,
    0xa6, 0x23, 0xa7, 0xc0, 0x5a, 0x26, 0xf5, 0x33, 0x8c, 0x38, 0xe6, 0x42,
    0xe7, 0xe4, 0xcc, 0xef, 0x21, 0x8e, 0x00, 0x04, 0x34, 0x20, 0x10, 0x8e,
    0x00, 0x08, 0x58, 0x49, 0x66, 0xc4, 0x69, 0xc4, 0x28, 0x04, 0x88, 0x10,
    0xc8, 0x21, 0x68, 0xc4, 0x31, 0x3f, 0x26, 0xee, 0x33, 0x41, 0x30, 0x1f,
    0x26, 0xe4, 0x35, 0x20, 0xa3, 0xc4, 0x27, 0x02,

    0x00, 0x00, 0x0a, 0x03, 0x6c,
    0x6f, 0xe4, 0x6f, 0xa4, 0xc6, 0x40, 0xe7, 0x22, 0x35, 0xf6,

    0x00, 0x00, 0x80, 0x03, 0x7c,
    0x34, 0x42, 0x1a, 0x50, 0x10, 0x9e, 0x0b, 0x9e, 0x09, 0xe6, 0x0f, 0xca,
    0x04, 0xe7, 0x22, 0xc4, 0xfb, 0xe7, 0x22, 0xe6, 0x21, 0xc4, 0x02, 0x27,
    0xf0, 0xe6, 0x01, 0x54, 0x25, 0x02, 0xca, 0x40, 0x5c, 0xe7, 0x22, 0xe7,
    0x0f, 0xcc, 0xbf, 0x00, 0x6d, 0x88, 0x10, 0x26, 0x0e, 0xe6, 0x03, 0xc1,
    0x39, 0x2a, 0x05, 0xcc, 0x9f, 0x20, 0x20, 0x03, 0xcc, 0x1f, 0x22, 0xa7,
    0x27, 0xe7, 0x21, 0x35, 0x42, 0xef, 0x23, 0xa7, 0xa4, 0x8e, 0x17, 0x70,
    0x39, 0x34, 0x76, 0xce, 0xa1, 0x0a, 0x86, 0x1a, 0x8d, 0xae, 0xc6, 0x03,
    0x30, 0x1f, 0x27, 0x98, 0xa6, 0xa4, 0x85, 0x02, 0x27, 0xf6, 0xa6, 0x23,
    0xa7, 0xe4, 0xa6, 0xa4, 0x2a, 0xfc, 0xa6, 0x23, 0x5a, 0x26, 0xf5, 0xe6,
    0xa4, 0xc5, 0x08, 0x27, 0xfa, 0xc5, 0x04, 0x16, 0xff, 0x78, 0xc1, 0x03,
    0x26, 0x79, 0xc6, 0x01, 0x8d, 0x18, 0xc6, 0x02,

    0x00, 0x00, 0x80, 0x03, 0xfc,
    0x8d, 0x14, 0x1f, 0x10, 0x83, 0x3c, 0xc1, 0x8e, 0x00, 0x0f, 0x83, 0x02,
    0x3e, 0x25, 0x04, 0x30, 0x1f, 0x26, 0xf7, 0x1f, 0x10, 0x39, 0x34, 0x24,
    0x10, 0x9e, 0x0b, 0xe7, 0x24, 0x6f, 0x28, 0x9e, 0x09, 0xa6, 0x01, 0xc6,
    0x01, 0x21, 0x58, 0x4a, 0x2a, 0xfc, 0xe7, 0x28, 0xc6, 0xc4, 0xe7, 0x22,
    0x8e, 0x5f, 0x46, 0x30, 0x1f, 0x27, 0x2e, 0xe6, 0x23, 0x2a, 0x07, 0x54,
    0x24, 0xf5, 0xa6, 0xa4, 0x20, 0xf1, 0xe6, 0x22, 0xc5, 0x20, 0x27, 0x0e,
    0x9e, 0x09, 0xa6, 0x01, 0x30, 0x09, 0x48, 0xce, 0x80, 0x00, 0xef, 0x86,
    0x20, 0x0c, 0xe6, 0x22, 0xc4, 0x08, 0x27, 0x09, 0xe6, 0x24, 0xc4, 0x0f,
    0x27, 0x03, 0x8e, 0x00, 0x00, 0x6c, 0xa4, 0xa6, 0x24, 0xa6, 0x22, 0x86,
    0xc0, 0xa7, 0x22, 0x6f, 0x28, 0x35, 0xa4, 0x33, 0x8c, 0x1d, 0x4f, 0x8d,
    0x03, 0x26, 0x01, 0x39, 0x4c, 0x34, 0x02, 0xc6,

    0x00, 0x00, 0x80, 0x04, 0x7c,
    0x01, 0xad, 0xc4, 0x4d, 0x27, 0x09, 0xa1, 0xe4, 0x27, 0x06, 0x5c, 0xc1,
    0x10, 0x23, 0xf2, 0x5f, 0x5d, 0x35, 0x82, 0x34, 0x26, 0x10, 0x9e, 0x0b,
    0x86, 0xc0, 0xa7, 0xa4, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x86,
    0x03, 0xe6, 0xa4, 0xc5, 0x02, 0x27, 0x09, 0xe6, 0x23, 0x4a, 0x26, 0xf5,
    0xe7, 0xe4, 0x20, 0xf1, 0x54, 0x25, 0xee, 0xc5, 0x0e, 0x27, 0x02, 0x6f,
    0xe4, 0x35, 0xa6, 0x34, 0x34, 0x8d, 0x05, 0x17, 0x00, 0xc5, 0x20, 0x16,
    0x1a, 0x50, 0xcc, 0xe2, 0x95, 0xdd, 0x00, 0x10, 0x9e, 0x07, 0xc6, 0x01,
    0xd7, 0x06, 0x39, 0x34, 0x34, 0x8d, 0xed, 0x17, 0x00, 0xbf, 0xa7, 0xc0,
    0x8e, 0xdc, 0xc1, 0x12, 0xe6, 0xa4, 0x2a, 0x1c, 0xe6, 0xa4, 0x2a, 0x18,
    0xe6, 0xa4, 0x2a, 0x14, 0x30, 0x1f, 0xe6, 0xa4, 0x2a, 0x0e, 0x8c, 0x00,
    0x01, 0xe6, 0xa4, 0x2a, 0x07, 0x24, 0xe5, 0xc6,

    0x00, 0x00, 0x80, 0x04, 0xfc,
    0x02, 0x16, 0xfb, 0x73, 0x1f, 0x88, 0xe6, 0xa4, 0x2b, 0xda, 0xd6, 0x00,
    0xe8, 0x5f, 0xd7, 0x04, 0xe6, 0xa4, 0x58, 0x46, 0xd6, 0x04, 0x54, 0x54,
    0x54, 0x54, 0xd7, 0x05, 0x12, 0xe6, 0xa4, 0x58, 0x46, 0xd6, 0x05, 0xd8,
    0x04, 0xd7, 0x04, 0xd7, 0x05, 0x12, 0xe6, 0xa4, 0x58, 0x46, 0xd6, 0x05,
    0x54, 0x54, 0x54, 0xd7, 0x05, 0x12, 0x12, 0xe6, 0xa4, 0x58, 0x46, 0xd6,
    0x05, 0xd8, 0x01, 0xd7, 0x01, 0xae, 0x61, 0xe6, 0xa4, 0x58, 0x46, 0xd6,
    0x04, 0x58, 0x58, 0x58, 0x58, 0xd7, 0x05, 0x12, 0xe6, 0xa4, 0x58, 0x46,
    0xd6, 0x05, 0xd8, 0x01, 0xd7, 0x00, 0xc6, 0x03, 0xd7, 0x06, 0xe6, 0xa4,
    0x58, 0x46, 0xd6, 0x05, 0x58, 0xd8, 0x04, 0xd7, 0x01, 0x12, 0x12, 0xe6,
    0xa4, 0x58, 0x46, 0x12, 0x30, 0x1f, 0xaf, 0x61, 0x10, 0x26, 0xff, 0x66,
    0x97, 0x02, 0x8d, 0x21, 0x97, 0x03, 0x9e, 0x00,

    0x00, 0x00, 0x80, 0x05, 0x7c,
    0x9c, 0x02, 0x26, 0x02, 0x35, 0xb4, 0xc6, 0x04, 0x16, 0xfa, 0xec, 0x86,
    0x01, 0xa7, 0xa4, 0xe6, 0xa4, 0x2b, 0xfc, 0x1f, 0x88, 0xe6, 0xa4, 0x2b,
    0xf6, 0x21, 0xfe, 0x20, 0x2f, 0x8e, 0xdc, 0xc1, 0x86, 0x01, 0xa7, 0xa4,
    0xe6, 0xa4, 0x2a, 0x1c, 0xe6, 0xa4, 0x2a, 0x18, 0xe6, 0xa4, 0x2a, 0x14,
    0x30, 0x1f, 0xe6, 0xa4, 0x2a, 0x0e, 0x8c, 0x00, 0x01, 0xe6, 0xa4, 0x2a,
    0x07, 0x24, 0xe5, 0xc6, 0x02, 0x16, 0xfa, 0xb3, 0x1f, 0x88, 0xe6, 0xa4,
    0x2b, 0xda, 0x1f, 0x88, 0x8e, 0x00, 0x07, 0x21, 0xfe, 0xe6, 0xa4, 0x58,
    0x46, 0x30, 0x00, 0x12, 0x30, 0x1f, 0x26, 0xf3, 0x21, 0xfe, 0xe6, 0xa4,
    0x58, 0x46, 0xd6, 0x06, 0xe7, 0xa4, 0x39, 0x34, 0x34, 0x17, 0xfe, 0xdc,
    0x86, 0x04, 0x8e, 0x7b, 0x0f, 0xe6, 0xa4, 0xc4, 0x20, 0x27, 0x0c, 0x30,
    0x1f, 0x26, 0xf6, 0x4a, 0x26, 0xf0, 0xc6, 0x01,

    0x00, 0x00, 0x80, 0x05, 0xfc,
    0x16, 0xfa, 0x74, 0xae, 0x61, 0x12, 0xa6, 0xc4, 0xc6, 0x02, 0xe7, 0xa4,
    0x1e, 0x88, 0x1e, 0x88, 0xc6, 0x01, 0x44, 0x59, 0xe7, 0xa4, 0xd6, 0x00,
    0xe8, 0xc0, 0xd7, 0x04, 0x12, 0xc6, 0x01, 0x44, 0x59, 0xe7, 0xa4, 0xd6,
    0x04, 0x54, 0x54, 0x54, 0x54, 0xd7, 0x05, 0xc6, 0x01, 0x44, 0x59, 0xe7,
    0xa4, 0xd6, 0x05, 0xd8, 0x04, 0xd7, 0x04, 0xd7, 0x05, 0xc6, 0x01, 0x44,
    0x59, 0xe7, 0xa4, 0xd6, 0x05, 0x54, 0x54, 0x54, 0xd7, 0x05, 0x12, 0xc6,
    0x01, 0x44, 0x59, 0xe7, 0xa4, 0xd6, 0x05, 0xd8, 0x01, 0xd7, 0x01, 0x12,
    0x12, 0xc6, 0x01, 0x44, 0x59, 0xe7, 0xa4, 0xd6, 0x04, 0x58, 0x58, 0x58,
    0x58, 0xd7, 0x05, 0xc6, 0x01, 0x44, 0x59, 0xe7, 0xa4, 0xd6, 0x05, 0xd8,
    0x01, 0xd7, 0x00, 0x12, 0x12, 0xc6, 0x01, 0x44, 0x59, 0xe7, 0xa4, 0xd6,
    0x05, 0x58, 0xd8, 0x04, 0xd7, 0x01, 0x12, 0x96,

    0x00, 0x00, 0x80, 0x06, 0x7c,
    0x00, 0xc6, 0x03, 0xe7, 0xa4, 0x21, 0xfe, 0x30, 0x1f, 0x10, 0x26, 0xff,
    0x78, 0x8d, 0x08, 0x12, 0x12, 0x96, 0x01, 0x8d, 0x02, 0x35, 0xb4, 0xc6,
    0x02, 0xe7, 0xa4, 0x30, 0x00, 0x8e, 0x00, 0x08, 0x1e, 0x88, 0xc6, 0x01,
    0x44, 0x59, 0xe7, 0xa4, 0x30, 0x1f, 0x26, 0xf4, 0x1f, 0x88, 0x1f, 0x88,
    0xc6, 0x03, 0xe7, 0xa4, 0x39, 0x5f, 0x34, 0x34, 0x17, 0xfe, 0x0d, 0xa6,
    0xe4, 0x8d, 0xd8, 0x12, 0x12, 0xa6, 0xe4, 0x8d, 0xd2, 0x35, 0xb4, 0x34,
    0x2b, 0x9e, 0x38, 0x30, 0x89, 0x03, 0x0d, 0x31, 0x89, 0x18, 0x68, 0x33,
    0xa9, 0x18, 0x68, 0x30, 0x1f, 0x86, 0x08, 0xa7, 0x61, 0xc6, 0xff, 0x68,
    0x84, 0x24, 0x02, 0xc6, 0x0a, 0xa6, 0xa2, 0xed, 0xc3, 0x6a, 0x61, 0x26,
    0xf0, 0x9c, 0x38, 0x26, 0xe6, 0x10, 0xae, 0x63, 0x30, 0x89, 0x03, 0x0d,
    0x1f, 0x10, 0xc3, 0x30, 0xd0, 0xed, 0x8d, 0x00,

    0x00, 0x00, 0x80, 0x06, 0xfc,
    0x16, 0x17, 0x00, 0x9e, 0xd6, 0xd1, 0xc4, 0x04, 0x26, 0x19, 0xc6, 0x04,
    0x8d, 0x25, 0xee, 0x81, 0x96, 0xd0, 0x2a, 0xfc, 0xdf, 0xd3, 0x8c, 0x00,
    0x00, 0x25, 0xf3, 0x96, 0xd0, 0x2a, 0xfc, 0x8d, 0x0b, 0x35, 0xab, 0x8d,
    0x07, 0x35, 0x2b, 0xc6, 0x05, 0x16, 0xf9, 0x4b, 0x0f, 0xd0, 0xc6, 0x40,
    0xd7, 0xd2, 0x39, 0x34, 0x04, 0xd6, 0xd1, 0xc5, 0x40, 0x26, 0xfa, 0xd6,
    0xd1, 0xc5, 0x40, 0x27, 0xfa, 0x96, 0xd0, 0x2a, 0xfc, 0x96, 0xd3, 0x96,
    0xd0, 0x2a, 0xfc, 0x96, 0xd3, 0xcc, 0xa1, 0x0a, 0xdd, 0xd3, 0x35, 0x04,
    0xd7, 0xd0, 0x39, 0x9e, 0x38, 0x30, 0x89, 0x03, 0x9d, 0x1f, 0x10, 0xc3,
    0x39, 0xd0, 0xed, 0x8d, 0x00, 0x12, 0x34, 0x09, 0x17, 0x00, 0x37, 0xc6,
    0x18, 0x8d, 0xc4, 0x96, 0xd0, 0x2a, 0xfc, 0xd6, 0xd3, 0xed, 0x81, 0x8c,
    0x00, 0x00, 0x25, 0xf3, 0x8d, 0xae, 0x35, 0x09,

    0x00, 0x00, 0x80, 0x07, 0x7c,
    0xde, 0x38, 0x30, 0xc9, 0x03, 0x9d, 0x31, 0x84, 0x86, 0x08, 0x34, 0x02,
    0xec, 0x81, 0x44, 0x66, 0xc4, 0xe7, 0xa0, 0x6a, 0xe4, 0x26, 0xf5, 0x35,
    0x02, 0x33, 0x41, 0xac, 0x8d, 0xff, 0xd9, 0x25, 0xe7, 0x39, 0xc6, 0x40,
    0xe7, 0x20, 0x9d, 0x3e, 0x10, 0x25, 0xfa, 0x72, 0xd6, 0x36, 0xcb, 0xa7,
    0x1f, 0x9b, 0xa6, 0x21, 0x44, 0x25, 0x02, 0x8b, 0x40, 0x4c, 0x97, 0xd2,
    0xa7, 0x2f, 0x1a, 0x50, 0x8a, 0x04, 0x97, 0xd2, 0x84, 0xfb, 0x97, 0xd2,
    0xe6, 0x22, 0xc1, 0x39, 0xcc, 0x9f, 0x20, 0x25, 0x03, 0xcc, 0x1f, 0x22,
    0x97, 0xd7, 0xd7, 0xd1, 0x39, 0x0a, 0x0d, 0xbe, 0xce, 0x60, 0x00, 0x96,
    0x35, 0x26, 0x04, 0x5a, 0x26, 0x6f, 0x39, 0x81, 0x08, 0x24, 0x09, 0x5c,
    0xc1, 0x07, 0x22, 0x65, 0xf7, 0xa7, 0xe5, 0x39, 0xce, 0xa0, 0x00, 0x30,
    0x8c, 0x5f, 0x81, 0x0a, 0x24, 0x18, 0x5a, 0xc1,

    0x00, 0x00, 0x80, 0x07, 0xfc,
    0x05, 0x22, 0x52, 0x10, 0x8e, 0xe7, 0xc0, 0xa6, 0x2b, 0x84, 0xfb, 0xa7,
    0x2b, 0xe6, 0x85, 0xe7, 0x29, 0x8a, 0x04, 0xa7, 0x2b, 0x39, 0x26, 0x2e,
    0x34, 0x04, 0xb6, 0xe7, 0xc9, 0x84, 0x07, 0xd6, 0x37, 0x8d, 0x1c, 0x35,
    0x04, 0xc1, 0x06, 0x23, 0xd5, 0xb6, 0xe7, 0xc9, 0x8a, 0xf8, 0xcb, 0x37,
    0xc4, 0x41, 0xcb, 0x03, 0xc4, 0x44, 0x34, 0x04, 0xf6, 0xe7, 0xc3, 0xc4,
    0xaf, 0xe8, 0xe0, 0xb7, 0xe7, 0xc9, 0xf7, 0xe7, 0xc3, 0x39, 0x30, 0x8c,
    0x16, 0xb6, 0x60, 0x81, 0x84, 0x10, 0x27, 0xae, 0x5c, 0xf7, 0xe7, 0xe5,
    0x39, 0xc6, 0x09, 0x16, 0xf8, 0x1d, 0x0f, 0x17, 0xe7, 0x67, 0xa7, 0x27,
    0x0f, 0x17, 0xe7, 0xa7, 0x67, 0x27, 0x96, 0x36, 0x30, 0x8c, 0x5d, 0x8d,
    0x08, 0xc6, 0x07, 0x20, 0x2c, 0x6d, 0x80, 0x2a, 0xfc, 0x5a, 0x2a, 0xf9,
    0x8c, 0x8d, 0x11, 0x8c, 0x8d, 0x1f, 0xe6, 0x80,

    0x00, 0x00, 0x80, 0x08, 0x7c,
    0xc1, 0x20, 0x25, 0xf5, 0x2c, 0xf6, 0xc4, 0x7f, 0xc1, 0x20, 0x24, 0x11,
    0x34, 0x10, 0x30, 0x8c, 0x1f, 0x8d, 0xe2, 0x35, 0x90, 0x8d, 0x06, 0xe6,
    0x80, 0x2a, 0xfa, 0xc4, 0x7f, 0x4d, 0x27, 0x0c, 0xbd, 0xe8, 0x03, 0xf6,
    0xe7, 0xc3, 0xca, 0x01, 0xf7, 0xe7, 0xc3, 0x39, 0x3f, 0x02, 0x3f, 0x86,
    0x43, 0x4f, 0x4d, 0xa0, 0x44, 0x69, 0x73, 0x6b, 0xa0, 0x20, 0x45, 0x72,
    0x72, 0x6f, 0xf2, 0x4e, 0x6f, 0x74, 0x20, 0x52, 0x65, 0x61, 0x64, 0xf9,
    0x00, 0x83, 0x00, 0x52, 0x74, 0x73, 0x82, 0x00, 0x42, 0x73, 0x74, 0x61,
    0x72, 0x74, 0x82, 0x42, 0x72, 0x65, 0x61, 0xeb, 0x00, 0x43, 0x72, 0x63,
    0x82, 0x01, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x65, 0xe4, 0x01,
    0x49, 0x2f, 0x4f, 0x82, 0x01, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x82,
    0x01, 0x83, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79,

    0x00, 0x00, 0x80, 0x08, 0xfc,
    0x82, 0x4e, 0x65, 0x65, 0x64, 0x20, 0x54, 0x48, 0x4d, 0x46, 0x43, 0xb1,
    0x30, 0x8d, 0xf6, 0xf4, 0x1f, 0x10, 0x1f, 0x8b, 0xc6, 0x3e, 0x6f, 0x80,
    0x5a, 0x26, 0xfb, 0x8e, 0x3f, 0x40, 0xa6, 0x84, 0x63, 0x84, 0xa8, 0x84,
    0x63, 0x84, 0x43, 0x84, 0x40, 0x97, 0x36, 0x8b, 0x20, 0xc6, 0x48, 0xdd,
    0x09, 0xc6, 0xcc, 0xdd, 0x3c, 0x1f, 0x04, 0xc3, 0x7f, 0x38, 0xdd, 0x3f,
    0xc3, 0x07, 0xcc, 0xdd, 0x0b, 0xc6, 0xe0, 0xdd, 0x07, 0x96, 0x36, 0x44,
    0x44, 0x44, 0xba, 0xff, 0xf0, 0x97, 0x35, 0x81, 0x0a, 0x23, 0x0d, 0xb6,
    0x60, 0xcd, 0xc6, 0x10, 0x3d, 0x58, 0x44, 0x56, 0x1f, 0x98, 0x20, 0x0f,
    0x26, 0x0f, 0xb6, 0xe7, 0xc3, 0x97, 0x37, 0xb6, 0x60, 0x74, 0x84, 0x02,
    0x48, 0x48, 0x48, 0x9a, 0x35, 0x97, 0x30, 0xc6, 0x01, 0xd7, 0x2f, 0xc6,
    0x01, 0xd7, 0x32, 0xcc, 0x40, 0x00, 0x9b, 0x36,

    0x00, 0x00, 0x80, 0x09, 0x7c,
    0xdd, 0x38, 0x17, 0x00, 0xa6, 0xcc, 0x1f, 0x40, 0x9b, 0x36, 0x83, 0x10,
    0x00, 0xdd, 0x3a, 0x1a, 0x50, 0xde, 0x07, 0x6f, 0x42, 0x6f, 0x43, 0xcc,
    0x03, 0xff, 0xed, 0x40, 0xcc, 0x04, 0x3c, 0xed, 0x42, 0xa6, 0x41, 0x43,
    0xa7, 0x41, 0xa1, 0x41, 0x27, 0x07, 0xc6, 0x00, 0x17, 0xfe, 0xb7, 0x20,
    0xfe, 0x63, 0x41, 0xc6, 0x03, 0xe7, 0x40, 0x8d, 0x03, 0x16, 0xf6, 0x92,
    0x96, 0x35, 0x81, 0x0b, 0x25, 0x16, 0x8d, 0x11, 0x0d, 0x10, 0x26, 0x0d,
    0x10, 0x9e, 0x09, 0x6f, 0x21, 0xc6, 0x01, 0xe7, 0x20, 0x9d, 0x3e, 0x6f,
    0x23, 0x17, 0xf7, 0xbd, 0x9e, 0x3f, 0xc6, 0x55, 0xeb, 0x1c, 0xeb, 0x1d,
    0xeb, 0x1e, 0xe0, 0x1f, 0xd7, 0x10, 0x26, 0x13, 0x9e, 0x3f, 0xa6, 0x1f,
    0xc6, 0x06, 0x30, 0x8d, 0xf7, 0x8f, 0xa1, 0x80, 0x27, 0x03, 0x5a, 0x26,
    0xf9, 0xd7, 0x13, 0x39, 0x8d, 0x27, 0x10, 0x8e,

    0x00, 0x00, 0x80, 0x09, 0xfc,
    0x02, 0x58, 0xe6, 0x84, 0x57, 0xea, 0x88, 0x28, 0xe7, 0x80, 0x31, 0x3f,
    0x26, 0xf4, 0x8d, 0x15, 0x30, 0x89, 0x02, 0x7f, 0x10, 0x8e, 0x02, 0x7f,
    0xec, 0x82, 0x44, 0x56, 0xea, 0x01, 0xe7, 0x01, 0x31, 0x3f, 0x26, 0xf4,
    0x39, 0x96, 0x36, 0x5f, 0x1f, 0x01, 0x39, 0x32, 0xe8, 0xe5, 0x30, 0xe4,
    0x33, 0x8d, 0xfe, 0x61, 0x86, 0x1b, 0xe6, 0xc0, 0xe7, 0x80, 0x4a, 0x26,
    0xf9, 0xd6, 0x36, 0x26, 0x13, 0xcc, 0x74, 0x73, 0xa7, 0x8c, 0x5d, 0xe7,
    0x8c, 0x5c, 0xcc, 0x70, 0x75, 0xa7, 0x8c, 0x62, 0xe7, 0x8d, 0x00, 0x9f,
    0x96, 0x36, 0x30, 0x8c, 0x32, 0xad, 0x62, 0x8d, 0x9f, 0x96, 0x36, 0x30,
    0x8c, 0x4c, 0xad, 0x62, 0x32, 0xe8, 0x1b, 0x8d, 0xa5, 0x8d, 0xba, 0x31,
    0x88, 0x28, 0x8e, 0x7f, 0xfc, 0x8d, 0x12, 0x8e, 0x40, 0x06, 0x86, 0x0b,
    0x8d, 0x0b, 0x4a, 0x26, 0xfb, 0x8e, 0x7f, 0xfe,

    0x00, 0x00, 0x75, 0x0a, 0x7c,
    0x8d, 0x03, 0x8e, 0x3f, 0xfe, 0xaf, 0xa4, 0x31, 0xa8, 0x28, 0x39, 0x14,
    0x1f, 0x20, 0x20, 0x1f, 0x12, 0x14, 0x1b, 0x23, 0x20, 0x44, 0x1b, 0x23,
    0x20, 0x56, 0x1b, 0x66, 0x1f, 0x20, 0x20, 0x1f, 0x10, 0x11, 0x0c, 0x1b,
    0x69, 0x1b, 0x4f, 0x1f, 0x41, 0x43, 0x43, 0x43, 0x39, 0xcf, 0x1f, 0x40,
    0x4c, 0x1b, 0x4c, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x20, 0x64, 0x65,
    0x76, 0x69, 0x63, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x43, 0x43, 0x39,
    0x4f, 0x2d, 0x32, 0x33, 0x32, 0x1f, 0x41, 0x4c, 0x76, 0x32, 0x2e, 0x4f,
    0x20, 0x50, 0x75, 0x6c, 0x73, 0x20, 0x28, 0x63, 0x29, 0x20, 0x66, 0x65,
    0x62, 0x72, 0x20, 0x32, 0x4f, 0x31, 0x33, 0x1f, 0x20, 0x22, 0x1f, 0x10,
    0x13, 0x1b, 0x42, 0x1b, 0x54, 0x0c, 0x1b, 0x68, 0xbe,

    0xff, 0x00, 0x00, 0x09, 0x08
};


/* send_install_datas:
 *  Send a data block for install.
 */
static int send_install_datas (uint8 *ptr, int size, int relative_addr)
{
    int err = 0;
    uint8 buf[INSTALL_BUFFER_SIZE];

    buf[RELATIVE_ADDR_MSB] = (uint8)(relative_addr >> 8);
    buf[RELATIVE_ADDR_LSB] = (uint8)relative_addr;
    buf[DATA_SIZE]         = (uint8)size;
    buf[RELATIVE_EXEC_MSB] = (uint8)0x00;
    buf[RELATIVE_EXEC_LSB] = (uint8)0x00;
    buf[SEND_COMMAND]      = (uint8)WAIT_FOR_NEXT;

    if (((err = serial_Write (buf, 3)) == 0)
     && ((err = serial_Write (ptr, size)) == 0)
     && ((err = serial_Read (buf, 1)) == 0))
    {
        if (*buf != 0xff)
            err = error_Message (CC90HFE_ERROR_SERIAL_IO, NULL);
        else
            err = serial_Write (buf+SEND_COMMAND, 1);
    }
    return err;
}



/* send_install_exec:
 *  Send a exec block for install.
 */
static int send_install_exec (int relative_addr)
{
    int err = 0;
    uint8 buf[INSTALL_BUFFER_SIZE];

    buf[RELATIVE_ADDR_MSB] = 0x00;
    buf[RELATIVE_ADDR_LSB] = 0x00;
    buf[DATA_SIZE]         = 0x02;
    buf[RELATIVE_EXEC_MSB] = (uint8)(relative_addr >> 8);
    buf[RELATIVE_EXEC_LSB] = (uint8)relative_addr;
    buf[SEND_COMMAND]      = (uint8)TRANSMISSION_STOP;

    if (((err = serial_Write (buf, SEND_COMMAND)) == 0)
     && ((err = serial_Read (buf, 1)) == 0))
    {
        if (*buf != 0xff)
            err = error_Message (CC90HFE_ERROR_SERIAL_IO, NULL);
        else
            err = serial_Write (buf+SEND_COMMAND, 1);
    }
    return err;
}



/* cc90_ComputeCrc:
 *  Compute a Thomson CRC.
 */
static int cc90_ComputeCrc (uint8 *buffer, int length, int start_value)
{
    int i;
    int crc_high = (start_value >> 8) & 0xff;
    int crc_low  = start_value & 0xff;
    int c;

    for (i=0; i<length; i++)
    {
        c = (crc_high ^ (int)*(buffer++)) & 0xff;
        c ^= (c >> 4);
        crc_low ^= (c >> 3);
        crc_high = ((c << 4) ^ crc_low) & 0xff;
        crc_low = ((c << 5) ^ c) & 0xff;
    }
    return (crc_high << 8) | crc_low;
}



/* check_if_error:
 *  Check if an error occurred.
 */
static int check_if_error (int err1, int err2)
{
    int err = 0;
    const int code[]=
    {
        0,      /* never sent */
        0,      /* never sent */
        CC90HFE_ERROR_CC90_BSTART,
        0,      /* never sent */
        CC90HFE_ERROR_CC90_CRC,
        CC90HFE_ERROR_DISK_PROTECT,
        CC90HFE_ERROR_DISK_IO,
        CC90HFE_ERROR_DISK_ACCESS,
        CC90HFE_ERROR_DISK_NONE,
        CC90HFE_ERROR_CC90_MEMORY,
        CC90HFE_ERROR_CC90_THMFC1
    };

    if ((err1 | err2) != 0)
    {
        if ((err1 == err2) && (err1 < (int)(sizeof(code)/sizeof(int))))
            err = error_Message (code[err1], NULL);
        else
            err = error_Message (CC90HFE_ERROR, NULL);
    }

    return err;
}



/* send_datas:
 *  Send a data block.
 */
static int send_datas (uint8 *buf, int size)
{
    int err = 0;
    int crc;
    uint8 tmpBuf[2];

    crc = cc90_ComputeCrc (buf, size, MFM_CRC_DATA_INIT);
    tmpBuf[0] = (uint8)(crc>>8);
    tmpBuf[1] = (uint8)crc;

    serial_InfiniteTimeout ();
    if ((err = serial_Write (buf, size)) == 0)
    {
        if ((err = serial_Write (tmpBuf, 2)) == 0)
        {
            if ((err = serial_Read (tmpBuf, 2)) == 0)
                err = check_if_error (tmpBuf[0], tmpBuf[1]);
        }
    }
    return err;
}



/* send_info:
 *  Send an info block.
 */
static int send_info (int code, int info1, int info2,
                          int info3, int info4, int info5)
{
    uint8 buf[6];
    
    buf[0] = code;
    buf[1] = info1;
    buf[2] = info2;
    buf[3] = info3;
    buf[4] = info4;
    buf[5] = info5;

    return send_datas (buf, 6);
}



/* get_datas:
 *  Receive a data block.
 */
static int get_datas (uint8 *buf, int size)
{
    int err = 0;
    uint8 crc_buf[2];
    int crc;

    serial_InfiniteTimeout ();
    if ((err = serial_Read (buf, size)) == 0)
    {
        if ((err = serial_Read (crc_buf, 2)) == 0)
        {
            crc = (int)((crc_buf[0] << 8) | crc_buf[1]);
            if (cc90_ComputeCrc (buf, size, MFM_CRC_DATA_INIT) != crc)
                err = error_Message (CC90HFE_ERROR_CC90_CRC, NULL);
        }
    }
    return err;
}



/* get_info:
 *  Receive an info block.
 */
static int get_info (uint8 *buf)
{
    return get_datas (buf, 6);
}



/* get_memory:
 *  Receive a memory block.
 */
static int get_memory (int bank, uint8 *buf, int size, int trackPtr)
{
    int err = 0;
    int data_size;
    int index = 0;

    while (index < size)
    {
        data_size = ((size-index)>DATA_SIZE_MAX)?DATA_SIZE_MAX:(size-index);
        err = send_info (
                     CC90_CODE_GETMEMORY, bank,
                     (trackPtr+index)>>8,
                     trackPtr+index,
                     data_size>>8,
                     data_size);

        if (err == 0)
            err = get_datas (buf + index, data_size);

        index += data_size;
    }
    return err;
}



/* send_memory:
 *  Send a memory block.
 */
static int send_memory (int bank, uint8 *buf, int size, int trackPtr)
{
    int err = 0;
    int data_size;
    int index = 0;

    while (index < size) {
        data_size = ((size - index) > DATA_SIZE_MAX) ? DATA_SIZE_MAX : (size - index);
        err = send_info (CC90_CODE_SENDMEMORY,
                     bank,
                     (trackPtr + index) >> 8,
                     trackPtr + index,
                     data_size >> 8,
                     data_size);

        if (err == 0)
            err = send_datas (buf + index, data_size);

        index += data_size;
    }

    return err;
}



/* seek_to_next_synchro:
 *  Analyse the synchros
 *    In a formatted sector, the first synchronization word
 *    has not been overwritten since the track was written in
 *    one pass; we must always find stable number of consecutive
 *    synchronization words.
 *    For a written sector, the first synchronization word
 *    is generally "swallowed", especially because of the automatic
 *    operations.
 */
static int seek_to_next_synchro (int i, int track_size)
{
    gap_i = i;

    /* skip gap datas */
    while ((i < track_size) && (tmp_clck[i] < SYNCHRO_CLOCK_MARK))
        i++;
    synchro_i = i;

    /* skip gap datas */
    while ((i < track_size) && (tmp_clck[i] >= SYNCHRO_CLOCK_MARK))
        i++;
    data_i = i;

    /* error if not enough datas left */
    if (((synchro_i-gap_i) < 2) || ((data_i-synchro_i) == 0))
        return 0;

    /* adjust synchro field length */
    if (tmp_data[synchro_i-1] != tmp_data[synchro_i-2])
        synchro_i--;

    return i;
}



/* analyse_track_sync:
 *  Analyse a synchro for a full track and
 *  return the count of synchro fields.
 */
static int analyse_track_sync (int track_size)
{
    int count = 0;

    data_i = 0;
    synchro_length = 0;
    while (seek_to_next_synchro (data_i, track_size) > 0)
    {
        /* select longest synchro field */
        if ((data_i-synchro_i) > synchro_length)
            synchro_length = data_i-synchro_i;

        count++;
    }

    return count;
}



/* display_range:
 *  Display a range of datas
 */
#define WIDTH_MAX  16
static void display_range (int pos, int size, uint8 *data, uint8 *clck)
{
    int i,n;
    int data_length;
    int str_len;

    for (i=0; i<size; i+=WIDTH_MAX)
    {
        data_length = ((size-i) < WIDTH_MAX) ? size-i : WIDTH_MAX;
        str_len = fprintf (fd_debug, "%04x  ", pos+i);
        for (n=0; n<data_length; n++)
            str_len += fprintf (fd_debug, " %02x%02x", clck[pos+i+n], data[pos+i+n]);
        for (n=str_len; n<(6+5*WIDTH_MAX+2); n++)
            fprintf (fd_debug, " ");
        for (n=0; n<data_length; n++)
            fprintf (fd_debug, "%c", isprint(data[pos+i+n]) ? data[pos+i+n] : '.');
        fprintf (fd_debug, "\n");
    }
}



/* display_position:
 *  Display the position while process running.
 */
static void display_position (char *op, int drive, int track)
{
    if (fd_debug != NULL)
        fprintf (fd_debug,
                 "\n------------ %s track %d drive %d ------------\n\n",
                 op, track, drive);

    if (windowed_mode == 0)
    {
        printf ("\r%s track %d drive %d", op, track, drive);
        fflush (stdout);
    }
}


/* ____________________________ Thomson tracks ____________________________ */


/* write_thomson_info_field:
 *  Write the Thomson info field of a sector.
 */
static int write_thomson_info_field (int side)
{
    int field_type = FIELD_ERROR;

    if ((src_i > 5)
     && (src_i <= (disk.track_size-362))
     && (tmp_data[src_i] == MFM_INFO_ID)
     && (tmp_clck[src_i] < SYNCHRO_CLOCK_MARK)
     && (tmp_data[src_i+4] == 1))   /* only DD Thomson (256 bytes/sector) */
    {
        if ((tmp_data[src_i-4] == MFM_PRE_SYNC_DATA_VALUE)
         && (tmp_clck[src_i-4] < SYNCHRO_CLOCK_MARK)
         && (tmp_data[src_i-3] == MFM_SYNCHRO_DATA_VALUE)
         && (tmp_clck[src_i-3] >= SYNCHRO_CLOCK_MARK))
        {
            memcpy (disk.data[side]+dst_i, tmp_data+gap_i, data_i-gap_i+7);
            memcpy (disk.clck[side]+dst_i, tmp_clck+gap_i, data_i-gap_i+7);

            if (fd_debug != NULL)
            {
                fprintf (fd_debug, "%4sthomson info field as is\n", "");
                display_range (gap_i, data_i-gap_i+7, tmp_data, tmp_clck);
            }

            dst_i += data_i-gap_i+7;
            field_type = FIELD_AS_IS;
        }
        else
        {
            memset (disk.data[side]+dst_i, MFM_GAP_DATA_VALUE, 32);
            memset (disk.data[side]+dst_i+32, MFM_PRE_SYNC_DATA_VALUE, 12);
            memset (disk.data[side]+dst_i+44, MFM_SYNCHRO_DATA_VALUE, 3);
            memset (disk.clck[side]+dst_i+44, SYNCHRO_CLOCK_MARK, 3);
            memcpy (disk.data[side]+dst_i+47, tmp_data+src_i, 7);

            if (fd_debug != NULL)
            {
                fprintf (fd_debug, "%4sthomson info field overwritten\n", "");
                display_range (src_i, 7, tmp_data, tmp_clck);
            }

            dst_i += 54;
            field_type = FIELD_REBUILT;
        }
        src_i += 7;
    }
    return field_type;
}



/* write_thomson_data_field:
 *  Write the Thomson data field of a sector.
 */
static int write_thomson_data_field (int side)
{
    int type = FIELD_ERROR;

    /* thomson-like sector ? */
    if ((src_i > 5)
     && (src_i <= (disk.track_size-259))
     && (tmp_data[src_i] == MFM_SECTOR_ID)
     && (tmp_clck[src_i] < SYNCHRO_CLOCK_MARK))
    {
        /* formatted or overwritten ? */
        if ((tmp_data[src_i-4] == MFM_PRE_SYNC_DATA_VALUE)
         && (tmp_clck[src_i-4] < SYNCHRO_CLOCK_MARK)
         && (tmp_data[src_i-3] == MFM_SYNCHRO_DATA_VALUE)
         && (tmp_clck[src_i-3] >= SYNCHRO_CLOCK_MARK))
        {
            /* write data field as is */
            memcpy (disk.data[side]+dst_i, tmp_data+gap_i, data_i-gap_i+259);
            memcpy (disk.clck[side]+dst_i, tmp_clck+gap_i, data_i-gap_i+259);

            if (fd_debug != NULL)
            {
                fprintf (fd_debug, "%4sthomson data field as is\n", "");
                display_range (gap_i, data_i-gap_i+259, tmp_data, tmp_clck);
            }

            dst_i += data_i-gap_i+259;
            type = FIELD_AS_IS;
        }
        else
        {
            /* rebuild thomson-like data field */
            memset (disk.data[side]+dst_i, MFM_GAP_DATA_VALUE, 22);    
            memset (disk.data[side]+dst_i+22, MFM_PRE_SYNC_DATA_VALUE, 12);
            memset (disk.data[side]+dst_i+34, MFM_SYNCHRO_DATA_VALUE, 3);
            memset (disk.clck[side]+dst_i+34, SYNCHRO_CLOCK_MARK, 3);
            memcpy (disk.data[side]+dst_i+37, tmp_data+src_i, 259);

            if (fd_debug != NULL)
            {
                fprintf (fd_debug, "%4sthomson data field overwritten\n", "");
                display_range (src_i, 259, tmp_data, tmp_clck);
            }

            dst_i += 37+259;
            type = FIELD_REBUILT;
        }
        src_i += 259;
    }
    return type;
}



/* write_thomson_track:
 *  Check if the track is a MFM formatted track.
 */
static int write_thomson_track (int side)
{
    int data_type = 0;

    /* analyse the track */
    if ((analyse_track_sync (disk.track_size+100) < 32)
     || (synchro_length != 3))
        return TRACK_ERROR;

    /* initialize start of the track */
    src_i = 0;
    dst_i = 0;
    memset (disk.clck[side], DATA_CLOCK_MARK, disk.track_size);

    /* create track */
    while (seek_to_next_synchro (src_i, disk.track_size) > 0)
    {
        src_i = data_i;
        if (write_thomson_info_field (side) == FIELD_ERROR)
            return TRACK_ERROR;

        if (seek_to_next_synchro (src_i, disk.track_size) <= 0)
            return TRACK_ERROR;

        src_i = data_i;
        if ((data_type = write_thomson_data_field (side)) == FIELD_ERROR)
            return TRACK_ERROR;
    }

    /* fill rest of track */
    if (dst_i < disk.track_size)
    {
        if (data_type == FIELD_AS_IS)
        {
            if (fd_debug != NULL)
                fprintf (fd_debug, "%4sthomson track end  (as is)\n", "");

            memset (disk.data[side]+dst_i,
                    tmp_data[disk.track_size-1],
                    disk.track_size-dst_i);

            memcpy (disk.data[side]+dst_i,
                    tmp_data+src_i,
                    disk.track_size - ((src_i>dst_i) ? src_i : dst_i));
        }
        else
        {
            if (fd_debug != NULL)
                fprintf (fd_debug, "%4sthomson track end (rebuilt)\n", "");

            memset (disk.data[side]+dst_i,
                    MFM_GAP_DATA_VALUE,
                    disk.track_size-dst_i);
        }
        if (fd_debug != NULL)
            display_range (dst_i, disk.track_size-dst_i,
                           disk.data[side], disk.clck[side]);
    }

    return TRACK_OK;
}


/* __________________________ Sectored tracks __________________________ */


/* write_sectored_track:
 *  Write a sectored track.
 */
static int write_sectored_track (int side)
{
    int i;
    int start;

    /* return if no sector */
    if (analyse_track_sync (disk.track_size) == 0)
        return TRACK_ERROR;

    /* initialize start of the track */
    src_i = 0;
    dst_i = 0;
    memset (disk.clck[side], DATA_CLOCK_MARK, disk.track_size);
    memset (disk.data[side], MFM_GAP_DATA_VALUE, 12);
    
    /* create track */
    while ((i = seek_to_next_synchro (src_i, disk.track_size-50)) > 0)
    {
        start = dst_i;

        /* give up if unexpected synchro */
        if (tmp_data[i-1] != MFM_SYNCHRO_DATA_VALUE)
            return TRACK_ERROR;

        src_i = i;

        /* count pre-synchro field words if PC or Thomson disk */
        i = src_i-synchro_length;
        if (synchro_length == 3)
        {
            while ((i > 0)
             && ((tmp_data[i-1] == 0x00) || (tmp_data[i-1] == 0xff)))
                i--;
        }
        else
            i--;

        /* only even length of pre-synchro field */
        if ((i > 0) && (((src_i-synchro_length-i) & 1) != 0))
            i--;

        /* write gap, pre-synchro and synchro fields */
        memcpy (disk.data[side]+dst_i, tmp_data+gap_i, i-gap_i);
        dst_i += i-gap_i;
        memset (disk.data[side]+dst_i, MFM_PRE_SYNC_DATA_VALUE, src_i-synchro_length-i);
        dst_i += src_i-synchro_length-i;
        memset (disk.data[side]+dst_i, MFM_SYNCHRO_DATA_VALUE, synchro_length);
        memset (disk.clck[side]+dst_i, SYNCHRO_CLOCK_MARK, synchro_length);
        dst_i += synchro_length;

        if (fd_debug != NULL)
        {
            fprintf (fd_debug, "%4ssectored datas\n", "");
            fprintf (fd_debug, "----- src\n");
            display_range (gap_i, src_i-gap_i, tmp_data, tmp_clck);
            fprintf (fd_debug, "----- dst\n");
            display_range (start, dst_i-start, disk.data[side], disk.clck[side]);
        }
    }

    /* fill rest of track */
    if (dst_i < disk.track_size)
    {
        memset (disk.data[side]+dst_i,
                tmp_data[disk.track_size-1],
                disk.track_size-dst_i);

        memcpy (disk.data[side]+dst_i,
                tmp_data+src_i,
                disk.track_size - ((src_i>dst_i) ? src_i : dst_i));

        if (fd_debug != NULL)
        {
            fprintf (fd_debug, "%4ssectored track end\n", "");
            display_range (dst_i, disk.track_size-dst_i,
                           disk.data[side], disk.clck[side]);
        }
    }
    return TRACK_OK;
}



/* read_cc90_track:
 *  Read a Thomson track via CC90.
 */
static int read_cc90_track (int drive, int side, int track)
{
    int err;

    /* ask the Thomson to load the track */
    err = send_info (CC90_CODE_LOADMFMTRACK, drive*2+side, track, 0, 0, 0);

    /* ask the Thomson to send the track datas to Terminal */
    if (err == 0)
        err = get_memory (CURRENT_BANK, tmp_track, (disk.pack_size/8)*9,
                          mfm_track_ptr);
    return err;
}



/* unpack_cc90_track:
 *  Unpack a track read via CC90.
 */
static void unpack_cc90_track (void)
{
    int i;

    for (i=0; i<disk.pack_size; i++)
    {
        tmp_clck[i] = (((tmp_track[i>>3]>>(i&7))&1) == 0)
                       ? DATA_CLOCK_MARK : SYNCHRO_CLOCK_MARK;
        tmp_data[i] = tmp_track[(disk.pack_size/8)+i];
    }
    /* avoid synchro at start of track */
    memset (tmp_clck, DATA_CLOCK_MARK, 5);
}



/* read_track:
 *  Read a track.
 */
static int read_track (int drive, int side, int track)
{
    int err = 0;
    int count[2] = { 0, 0 };
    int stop;

    disk.data[side] = std_free (disk.data[side]);
    disk.clck[side] = std_free (disk.clck[side]);

    if (((tmp_track  = malloc ((disk.pack_size/8)*9)) != NULL)
     && ((tmp_data   = malloc (disk.pack_size)) != NULL)
     && ((tmp_clck   = malloc (disk.pack_size)) != NULL)
     && ((disk.data[side] = malloc (disk.track_size)) != NULL)
     && ((disk.clck[side] = malloc (disk.track_size)) != NULL))
    {
        display_position ("Reading", drive*2+side, track);

        do
        {
            stop = TRUE;
            if ((err = read_cc90_track (drive, side, track)) == 0)
            {
                unpack_cc90_track ();
                if (write_thomson_track (side) == TRACK_ERROR)
                {
                    if (gui.not_thomson_side[side&1] == FALSE)
                    {
                        err = error_Message (CC90HFE_ERROR_TRACK_READ, NULL);
                        if (++count[side&1] < gui.read_retry_max)
                            stop = FALSE;
                    }
                    else
                    if (write_sectored_track (side) == TRACK_ERROR)
                    {
                        /* otherwise, raw-copy of the track */
                        memcpy (disk.data[side], tmp_data, disk.track_size);
                        memcpy (disk.clck[side], tmp_clck, disk.track_size);

                        if (fd_debug != NULL)
                        {
                            fprintf (fd_debug, "%4sundefined track\n", "");
                            display_range (0, disk.track_size,
                                           disk.data[side], disk.clck[side]);
                        }
                    }
                }
            }
        } while ((stop == FALSE) && (progress_on!=0));
    }
    else
        err = error_Message (CC90HFE_ERROR_ALLOC, NULL);

    tmp_track = std_free (tmp_track);
    tmp_data  = std_free (tmp_data);
    tmp_clck  = std_free (tmp_clck);

    return err;
}



/* pack_cc90_track:
 *  Pack a track for CC90.
 */
static void pack_cc90_track (int side)
{
    int i;

    memset (tmp_track, 0x00, (disk.pack_size/8)*9);

    for (i=0; i<disk.pack_size; i++)
    {
        tmp_track[(disk.pack_size>>3)+i] = disk.data[side][i];
        tmp_track[i>>3] |= ((disk.clck[side][i]&SYNCHRO_CLOCK_MARK)>>7)<<(i&7);
    }
}    



/* write_cc90_track:
 *  Write a Thomson track via CC90.
 */
static int write_cc90_track (int drive, int side, int track)
{
    int err;

    /* send the track datas to the Thomson */
    err = send_memory (CURRENT_BANK,
                       tmp_track,
                       (disk.pack_size/8)*9,
                       mfm_track_ptr);

    /* ask the Thomson to write the track */
    if (err == 0)
        err = send_info (CC90_CODE_SAVEMFMTRACK, drive*2+side, track, 0, 0, 0);

    return err;
}



/* write_track:
 *  Write a track.
 */
static int write_track (int drive, int side, int track)
{
    int err = 0;

    if ((tmp_track = malloc ((disk.pack_size/8)*9)) != NULL)
    {
        pack_cc90_track (side);
        display_position ("Writing", drive*2+side, track);
        err = write_cc90_track (drive, side, track);
    }
    else
        err = error_Message (CC90HFE_ERROR_ALLOC, NULL);

    tmp_track = std_free (tmp_track);

    return err;
}



/* ask_date:
 *  Return a formatted date.
 */
static int ask_date (void)
{
    time_t raw_time;
    struct tm *t;

    if (time (&raw_time) > 0)
        if ((t = gmtime (&raw_time)) != NULL)
            return (t->tm_mday<<11) | ((t->tm_mon+1)<<7) | (t->tm_year%100);

    return 0;
}


/* ------------------------------------------------------------------------- */


/* cc90_Install:
 *  Send the program onto the Thomson via INSTALL.BAS.
 */
int cc90_Install (void)
{
    int err = 0;
    int i = 0;
    int size = 0;
    int last = 0;
    int addr = 0;
    
    if ((err = port_Open ()) == 0)
    {
        serial_RestoreTimeout ();
        while ((cc90_bin[i] == 0x00) && (err == 0))
        {
            size = (int)cc90_bin[i+2];
            addr = (int)((cc90_bin[i+3]<<8) + cc90_bin[i+4]);
            err = send_install_datas (cc90_bin+i+5, size, addr-last);
            i += 5+size;
            last = addr+size;
        }

        if (err == 0)
        {
            size = 2;
            addr = (int)((cc90_bin[i+3]<<8) + cc90_bin[i+4]);
            err = send_install_exec (addr-last);
        }
    }
    cc90_Close();

    return err;
}



/* cc90_ReadTrack:
 *  Read both sides of track.
 */
int cc90_ReadTrack (int drive, int track)
{
    int err = 0;

    disk.pack_size = CC90_READ_TRACK_LENGTH;

    if ((err = read_track (drive, SIDE_0, track)) == 0)
        err = read_track (drive, SIDE_1, track);

    return err;
}



/* cc90_WriteTrack:
 *  Write both sides of track.
 */
int cc90_WriteTrack (int drive, int track)
{
    int err = 0;

    disk.pack_size = CC90_WRITE_TRACK_LENGTH;

    if ((err = write_track (drive, SIDE_0, track)) == 0)
        err = write_track (drive, SIDE_1, track);
        
    return err;
}



/* cc90_Open:
 *  Open the CC90 interface.
 */
int cc90_Open (void)
{
    int date, drive_info;
    uint8 buf[6];

    /* open the serial port */
    if (port_Open () < 0)
        return CC90HFE_ERROR;

    /* send ASK block to the Thomson */
    date = ask_date ();
    drive_info = 0;
    if (send_info (CC90_CODE_ASK, drive_info, date>>8, date&0xff, 0, 0) < 0)
        return CC90HFE_ERROR;

    /* Get SYS block */
    if (get_info (buf) < 0)
        return CC90HFE_ERROR;

    /* only the right version of CC90 program */
    if (buf[CC90_SYS_VERSION] != CC90_VERSION_CODE)
        return error_Message (CC90HFE_ERROR_CC90_VERSION, NULL);

    /* only THMFC1 */
    if ((buf[CC90_SYS_CONFIG] & CC90_SYS_CONFIG_CTRL_MASK) != 6)
        return error_Message (CC90HFE_ERROR_DISK_NONE, NULL);

    /* only double density */
    if ((buf[CC90_SYS_CONFIG] & CC90_SYS_CONFIG_DSTY_MASK) != 0)
        return error_Message (CC90HFE_ERROR_DISK_NONE, NULL);

    /* adjust track pointer */
    if ((buf[CC90_SYS_COMPUT]&CC90_SYS_COMPUT_TYPE_MASK) >= CC90_COMPUTER_TO)
        mfm_track_ptr = THOMSON_MFM_TRACK_POSITION + 0x4000;  /* TO track ptr */
    else
        mfm_track_ptr = THOMSON_MFM_TRACK_POSITION;   /* MO track ptr */

    return 0;
}



/* cc90_Close:
 *  Close the CC90 interface.
 */
void cc90_Close (void)
{
    serial_Close();
}

