#define TRUE 1
#define FALSE 0
#include <conio.h>
#include <stdio.h>
#include <pc.h>
#include <string.h>
#include <math.h>
#include <keyboard.c>
#include <mouse.c>
struct {
	unsigned char xsize, ysize, xhotspot, yhotspot;
	unsigned short size, offset;
} pobdata[38];
struct {
  unsigned short width, height;
  char *offset;
} font[1];
#include <gfx.c>
#include <sound.c>

long chickens_killed = 0;
unsigned char ground[320];
struct {
  short x, y;
  short button;
  char hold;
} mouse;
char nr_chickens;
struct {
  short c1;
  short t;
  short difficulty;
} timer;
long points;
struct {
  char name[10];
  long points;
} hiscore[5];

char *vrscr, *backg, *gamepal, *pal, *pal2, *pobs, *hsscr;
char *gfx1;
char quit = 0;

// sound
void play_sample(char *address, unsigned long length, long frequency, unsigned long loop_start, unsigned long loop_end, unsigned long loop_length, char volume, unsigned long position);
char *samples;
struct {
  char *address;
  unsigned long length;
} sample[3];
char sample_channel = 0;
char sound_blaster = 0;

// interrupts
_go32_dpmi_seginfo old_timer_interrupt;
void get_timer_interrupt(void);
void timer_interrupt(void);
void release_timer_interrupt(void);
short ticks;

char hiscore_screen(void);
void load_hiscores(void);
void save_hiscores(void);
void reset_hiscores(void);
void init_objects(void);
void generate_ground(void);
void test_input(void);
void draw_output(void);
void draw_number(short x, short y, long n);
#include <intro.c>
#include <objects.c>

char update = 0;

void main(void) {
  short x, y, c;
  short offs;
  short time, time2, die;
  char k;
  FILE *infile;
  int timer_speed;

  pobs = allocate_mem(10000);
  vrscr = allocate_mem(64000);
  backg = allocate_mem(64000);
  gfx1 = allocate_mem(64000);
  gamepal = allocate_mem(768);
  pal = allocate_mem(768);
  pal2 = allocate_mem(768);
  hsscr = allocate_mem(4000);
  load_pobs("data01.chk", pobs);
  load_pcx("data02.chk", gfx1, gamepal);
  load_hiscores();

  if (check_error() != NULL) exit(3);

  infile = fopen("data11.chk", "rb");
  fread(hsscr, 1, 3840, infile); // 80 x 24
  fclose(infile);

  infile = fopen("data03.chk", "rb");
  sample[0].length = filelength(fileno(infile));
  sample[0].address = (char *)malloc(sample[0].length);
  for (c = 0; c < sample[0].length; c++) {
    sample[0].address[c] = fgetc(infile) - 128; // make it signed
  }
  fclose(infile);
  infile = fopen("data04.chk", "rb");
  sample[1].length = filelength(fileno(infile));
  sample[1].address = (char *)malloc(sample[1].length);
  for (c = 0; c < sample[1].length; c++) {
    sample[1].address[c] = fgetc(infile) - 128; // make it signed
  }
  fclose(infile);
  infile = fopen("data05.chk", "rb");
  sample[2].length = filelength(fileno(infile));
  sample[2].address = (char *)malloc(sample[2].length);
  for (c = 0; c < sample[2].length; c++) {
    sample[2].address[c] = fgetc(infile) - 128; // make it signed
  }
  fclose(infile);

  set_video_mcga();
  init_gfx();
  randomize();
  get_timer_interrupt();
  if (sb_init(4)) sound_blaster = 1;

  intro();

  play_again:

  set_video_mcga();
  init_gfx();

  set_palette(gamepal);
  generate_ground();
  init_objects();

  while (!quit) {

    //ticks = 1;
    for (c = 0; c < ticks; c++) {
      timer.c1++;
      if (timer.c1 > 49) {
        timer.c1 = 0;
        timer.t--;
        if (timer.t < 1) quit = 1;
      }
      timer.difficulty++;
      if (timer.difficulty > 200) {
        timer.difficulty = 0;
        nr_chickens++;
        add_chicken();
      }
      get_mouse_pos(&mouse.x, &mouse.y, &mouse.button);
      test_input();

      move_fire_fuel();
      move_fire();
      move_chicken();
      move_spark();
      move_blood();
      move_bdrop();
      move_mslogo();
      move_msdebr();
      move_programmer();
      move_crystal();
    }
    ticks = 0;

    draw_fire();
    draw_programmer();
    draw_mslogo();
    draw_msdebr();
    draw_spark();
    draw_bdrop();
    draw_blood();
    draw_crystal();
    draw_chicken();
    draw_output();
    put_pob(mouse.x, mouse.y, 0, pobs, vrscr);

    //set_color(0, 0, 0, 0);
    //wait_vertical_retrace();
    //if (k == 99) set_color(0, 32, 16, 8);
    while (!update);
    while ((inportb(0x3da) & 8) == 0);
    timer_speed = 1193180 / 75;
    outportb(0x43, 0x36);
    outportb(0x40, timer_speed & 0xFF);
    outportb(0x40, timer_speed >> 8);
    copy_screen(video, vrscr);
    copy_screen(vrscr, backg);
    update = 0;

    if (kbhit()) {
      k = getch();
      if (k == 27) quit = 1;
      if (k == 115) screen_dump(video, pal, "chicken2.pcx");
    }
    else k = 0;
  }

  if (hiscore_screen()) goto play_again;

  if (sound_blaster == 1) sb_deinit();
  release_timer_interrupt();
  free(vrscr);
}





void timer_interrupt(void) {
  //unsigned short timer_speed;

  //set_color(0, 0, 0, 63);
  /*while ((inportb(0x03DA) & 0x08) == 0);
  while ((inportb(0x03DA) & 0x08) != 0);*/

  //set_color(0, 0, 0, 0);

  ticks++;
  update = 1;

  /*timer_speed = 1193180 / 75;
  outportb(0x43, 0x36);
  outportb(0x40, timer_speed & 0xFF);
  outportb(0x40, timer_speed >> 8);*/

  outportb(0x20, 0x20);
}

void get_timer_interrupt(void) {
  _go32_dpmi_seginfo handler;
  unsigned short timer_speed;

  handler.pm_offset = (int)timer_interrupt;
  _go32_dpmi_allocate_iret_wrapper(&handler);
  _go32_dpmi_get_protected_mode_interrupt_vector(0x8, &old_timer_interrupt);
  _go32_dpmi_set_protected_mode_interrupt_vector(0x8, &handler);

  // Set speed: 50 Hz
  timer_speed = 1193180 / 69.8;
  outportb(0x43, 0x36);
  outportb(0x40, timer_speed & 0xFF);
  outportb(0x40, timer_speed >> 8);
}

void release_timer_interrupt(void) {
  _go32_dpmi_set_protected_mode_interrupt_vector(8, &old_timer_interrupt);
}

void save_hiscores(void) {
  FILE *outfile;
  short c, c2;
  long *p;
  long checksum = 0;

  outfile = fopen("data12.chk", "wb");

  for (c = 0; c < 5; c++) {
    for (c2 = 0; c2 < 10; c2++) {
      fputc(hiscore[c].name[c2] + c2 + 1, outfile);
      checksum += hiscore[c].name[c2];
    }
    p = &hiscore[c].points;
    fwrite(p, 4, 1, outfile);
    checksum += hiscore[c].points;
  }
  fwrite(&checksum, 4, 1, outfile);

  fclose(outfile);
}

void reset_hiscores(void) {
  strcpy(hiscore[0].name, "  Coding  ");
  strcpy(hiscore[1].name, " Blue Sky ");
  strcpy(hiscore[2].name, " Graphics ");
  strcpy(hiscore[3].name, " Blue Sky ");
  strcpy(hiscore[4].name, "   1997   ");
  hiscore[0].points = 300;
  hiscore[1].points = 200;
  hiscore[2].points = 150;
  hiscore[3].points = 100;
  hiscore[4].points = 50;

  save_hiscores();
}

void load_hiscores(void) {
  FILE *infile;
  short c, c2;
  long *p;
  long sum = 0, checksum;

  infile = fopen("data12.chk", "rb");

  for (c = 0; c < 5; c++) {
    for (c2 = 0; c2 < 10; c2++) {
      hiscore[c].name[c2] = fgetc(infile) - c2 - 1;
      sum += hiscore[c].name[c2];
    }
    p = &hiscore[c].points;
    fread(p, 4, 1, infile);
    sum += hiscore[c].points;
  }
  fread(&checksum, 4, 1, infile);

  fclose(infile);

  if (sum != checksum) {
    reset_hiscores();
    for (c = 0; c < 5; c++) strcpy(hiscore[c].name, " CHEATER! ");
  }
}

char hiscore_screen(void) {
  short c, c2;
  char k = 0;
  char buf[10];
  char place = 5;

  set_video_text();
  for (c = 0; c < 3840; c++) {
    video[c] = hsscr[c];
  }

  for (c = 4; c >= 0; c--) { // check position
    if (points > hiscore[c].points) place--;
  }
  if (place < 4) {
    for (c = 4; c > place; c--) {
      hiscore[c].points = hiscore[c - 1].points;
      strcpy(hiscore[c].name, hiscore[c - 1].name);
    }
    hiscore[place].points = points;
    strcpy(hiscore[place].name, "          ");
  }
  if (place == 4) {
    hiscore[place].points = points;
    strcpy(hiscore[place].name, "          ");
  }

  for (c = 0; c < 5; c++) {
    gotoxy(32, 11 + c);
    for (c2 = 0; c2 < 10; c2++) {
      if (hiscore[c].name[c2] != 0) putch(hiscore[c].name[c2]);
    }
    gotoxy(45, 11 + c);
    printf("%d\n", hiscore[c].points);
  }

  if (place < 5) { // enter name!
    strcpy(buf, "          ");
    gotoxy(32, 11 + place);
    //for (c = 0; c < 10; c++) buf[c] = 0;
    c = 0;
    while (k != 13) {
      k = getch();
      if (k != 8) { // not backspace
        if (c < 10) { // not filled
          buf[c] = k;
          putch(k);
          c++;
        }
      }
      else { // backspace
        if (c > 0) { // not empty
          buf[c] = 32;
          c--;
          putch(k);
          putch(32);
          putch(k);
        }
      }
    }
    strcpy(hiscore[place].name, buf);
    save_hiscores();
    while (kbhit()) getch();
    k = 0;
  }

  gotoxy(23, 21);
  printf("Play again? [y][enter] / [n][esc]: \n");
  gotoxy(23 + 35, 21);

  c = 2;
  while (c == 2) {
    if (kbhit()) {
      k = getch();
    }
    if (k == 110) c = 0;
    if (k == 27) c = 0;
    if (k == 121) c = 1;
    if (k == 13) c = 1;
    if (k == 114) reset_hiscores();
    k = 0;
  }

  return c;
}

void draw_number(short x, short y, long n) {
  long p;
  long nr1, nr10, nr100, nr1000, nr10000, nr100000;

  p = n;
  nr100000 = p / 100000;
  p -= nr100000 * 100000;
  nr10000 = p / 10000;
  p -= nr10000 * 10000;
  nr1000 = p / 1000;
  p -= nr1000 * 1000;
  nr100 = p / 100;
  p -= nr100 * 100;
  nr10 = p / 10;
  p -= nr10 * 10;
  nr1 = p;

  if (n > 99999) put_pob(x, y, nr100000 + 28, pobs, vrscr);
  if (n > 9999) put_pob(x + 5, y, nr10000 + 28, pobs, vrscr);
  if (n > 999) put_pob(x + 10, y, nr1000 + 28, pobs, vrscr);
  if (n > 99) put_pob(x + 15 + 2, y, nr100 + 28, pobs, vrscr);
  if (n > 9) put_pob(x + 20 + 2, y, nr10 + 28, pobs, vrscr);
  put_pob(x + 25 + 2, y, nr1 + 28, pobs, vrscr);
}

void draw_output(void) {
  put_pob(130, 6, 27, pobs, vrscr);
  draw_number(160, 6, timer.t);
  draw_number(160, 14, points);
  draw_number(160, 22, chickens_killed);
}

void test_input(void) {
  short c, c2;
  char splat_sound = 0;
  if ((mouse.button == 1) && (mouse.hold == 0)) {
    mouse.hold = 1;
    timer.t--;
    play_sample(sample[0].address, sample[0].length, 22000, 0, 0, 0, 64, 0);

    for (c = 0; c < 5; c++) {
      add_spark(mouse.x, mouse.y, (float)(rnd(40) - 20) / 10, (float)(rnd(30) - 30) / 10);
    }

    for (c = 0; c < 40; c++) {
      if (chicken[c].live != 0) {
        if ((chicken[c].x > (mouse.x - 40)) && (chicken[c].x < (mouse.x + 40)) && (chicken[c].y > (mouse.y - 40)) && (chicken[c].y < (mouse.y + 40))) {
          chicken[c].live = 0;
          for (c2 = 0; c2 < 5; c2++) {
            add_blood(chicken[c].x, chicken[c].y, (float)(chicken[c].x - mouse.x + rnd(8) - 4) / 20, (float)-40 / (abs(chicken[c].x - mouse.x + rnd(16) - 8) + 10));
          }
          for (c2 = 0; c2 < 15; c2++) {
            add_bdrop(chicken[c].x, chicken[c].y, (float)(chicken[c].x - mouse.x + rnd(32) - 16) / 20, (float)-40 / (abs(chicken[c].x - mouse.x + rnd(32) - 16) + 10));
          }
          crystal_spawn++;
          if (crystal_spawn > (2 + nr_chickens / 8)) {
            crystal_spawn = 0;
            add_crystal(chicken[c].x, chicken[c].y, (float)(chicken[c].x - mouse.x + rnd(32) - 16) / 20, (float)-100 / (abs(chicken[c].x - mouse.x + rnd(32) - 16) + 10));
          }
          chickens_killed++;
          add_chicken();
          points += 100;
          if (splat_sound == 0) play_sample(sample[2].address, sample[0].length, 25000 + rnd(10000), 0, 0, 0, 64, 0);
          splat_sound = 1;
        }
      }
    }

    for (c = 0; c < 4; c++) {
      if (mslogo[c].live != 0) {
        if ((mslogo[c].x > (mouse.x - 40)) && (mslogo[c].x < (mouse.x + 40)) && (mslogo[c].y > (mouse.y - 40)) && (mslogo[c].y < (mouse.y + 40))) {
          mslogo[c].live = 0;
          for (c2 = 0; c2 < 15; c2++) {
            add_msdebr(mslogo[c].x, mslogo[c].y, (float)(mslogo[c].x - mouse.x + rnd(32) - 16) / 20, (float)-40 / (abs(mslogo[c].x - mouse.x + rnd(32) - 16) + 10));
          }
        }
      }
    }

    for (c = 0; c < 4; c++) {
      if (programmer[c].live != 0) {
        if ((programmer[c].x > (mouse.x - 40)) && (programmer[c].x < (mouse.x + 40)) && (programmer[c].y > (mouse.y - 40)) && (programmer[c].y < (mouse.y + 40))) {
          programmer[c].live = 0;
          for (c2 = 0; c2 < 10; c2++) {
            add_blood(programmer[c].x, programmer[c].y, (float)(programmer[c].x - mouse.x + rnd(32) - 16) / 20, (float)-70 / (abs(programmer[c].x - mouse.x + rnd(32) - 16) + 10));
          }
          for (c2 = 0; c2 < 30; c2++) {
            add_bdrop(programmer[c].x, programmer[c].y, (float)(programmer[c].x - mouse.x + rnd(32) - 16) / 20, (float)-70 / (abs(programmer[c].x - mouse.x + rnd(32) - 16) + 10));
          }
        }
      }
    }
  }
  if (mouse.button != 1) mouse.hold = 0;

  for (c = 0; c < 40; c++) {
    if (crystal[c].live != 0) {
      if ((crystal[c].x > (mouse.x - 8)) && (crystal[c].x < (mouse.x + 8)) && (crystal[c].y > (mouse.y - 8)) && (crystal[c].y < (mouse.y + 8))) {
        play_sample(sample[1].address, sample[1].length, 30000 + rnd(2000), 0, 0, 0, 64, 0);
        crystal[c].live = 0;
        timer.t += 3;
        points += 1000;
      }
    }
  }
}



void init_objects(void) {
  short c;

  quit = 0;
  ticks = 0;
  nr_chickens = 10;
  points = 0;
  timer.c1 = 0;
  timer.t = 60;
  mouse.hold = 0;
  mouse.button = 0;
  crystal_spawn = 0;

  for (c = 0; c < 3200; c++) {
    fire_b[c] = 0;
    fire_c[c] = 0;
  }
  fire.c1 = 0;

  for (c = 0; c < 40; c++) {
    chicken[c].live = 0;
  }
  for (c = 0; c < 40; c++) {
    blood[c].live = 0;
  }
  for (c = 0; c < 4; c++) {
    mslogo[c].live = 0;
  }
  for (c = 0; c < 40; c++) {
    msdebr[c].live = 0;
  }
  for (c = 0; c < 4; c++) {
    programmer[c].live = 0;
  }
  for (c = 0; c < 20; c++) {
    fire_fuel[c].live = 0;
  }
  for (c = 0; c < 40; c++) {
    spark[c].live = 0;
  }
  for (c = 0; c < 200; c++) {
    bdrop[c].live = 0;
  }
  for (c = 0; c < 40; c++) {
    crystal[c].live = 0;
  }

  for (c = 0; c < nr_chickens; c++) {
    add_chicken();
  }
}

void generate_ground(void) {
  short x, y, c;
  unsigned char color;

  clear_screen(backg, /*24*/0x18181818);
  y = 120;
  for (x = 0; x < 320; x++) {
    y += rnd(5) - 2;
    ground[x] = y;
    for (c = 199; c > ground[x]; c--) {
      color = gfx1[((c % 20) + 20) * 320 + (x % 20)];
      color = color + (c - 110) / 2;
      if (c == ground[x] + 1) {
        if (color < 96) color = 96;
        color += 5;
      }
      if (color > 111) color = 111;
      if (color < 96) color = 96;
      put_pixel(x, c, color, backg);
    }
  }

  y = 150;
  for (x = 0; x < 320; x++) {
    y += rnd(3) - 1;
    ground[x] = y;
    for (c = 199; c > ground[x]; c--) {
      color = gfx1[(c % 20) * 320 + (x % 20)];
      color = color + (c - y) / 8;
      if (color > 63) color = 63;
      put_pixel(x, c, color, backg);
    }
    for (c = ground[x] + 19; c > ground[x]; c--) {
      color = gfx1[(c - ground[x]) * 320 + (x % 20) + 20];
      if (color != 0) put_pixel(x, c, color, backg);
    }
  }
}

void play_sample(char *address, unsigned long length, long frequency, unsigned long loop_start, unsigned long loop_end, unsigned long loop_length, char volume, unsigned long position) {
  channel[sample_channel].address = address;
  channel[sample_channel].length = length << 16;
  channel[sample_channel].add = (65536L / 2) * frequency / 10000L;
  channel[sample_channel].loop_start = loop_start;
  channel[sample_channel].loop_end = loop_end;
  channel[sample_channel].loop_length = loop_length;
  channel[sample_channel].volume = volume;
  channel[sample_channel].position = position;
  channel[sample_channel].playing = 1;
  sample_channel++;
  if (sample_channel > (nr_channels - 1)) sample_channel = 0;
}
