/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#include <stdlib.h>
#include <stdio.h>

#include "Sprite.h"
//---------------------------------------------------------------------------
Sprite::Sprite() {

  Size=0;

}
//---------------------------------------------------------------------------
Sprite::~Sprite() {};
//---------------------------------------------------------------------------
void Sprite::ReadSpriteFromBuf(DblBuf *buf,int width,int height) {

   W=width;
   H=height;
   Size=W*H;

   PtrSprite=(unsigned char *) malloc(Size);
   memcpy(PtrSprite,buf->FrameBuf,Size);

}
//---------------------------------------------------------------------------
void Sprite::ReadSpriteFromBuf_2(DblBuf *buf,int x,int y,
                                 int width,int height) {


 int i,startOff,incx=-1,incy=0;
 int precalc=0;

   W=width;
   H=height;
   Size=W*H;

   PtrSprite=(unsigned char *) malloc(Size);

   startOff=x+y*320;

  for(i=0;i<Size;i++) {

    if(incx<(W-1)) incx++;

     else {
       incx=0;
       incy++;
       precalc=incy*320;
     }

      PtrSprite[i]=buf->FrameBuf[startOff+(incx+precalc)];

  }

}
//---------------------------------------------------------------------------
void Sprite::LoadFrom_SPR_File(char *filename) {

 FILE *rawfile;
 int tmpSize;

    rawfile=fopen(filename,"rb");

     fread(&W,1,sizeof(W),rawfile);
     fread(&H,1,sizeof(H),rawfile);
     Size=W*H;

     tmpSize=Size;

      PtrSprite=(unsigned char*) malloc(Size);

     fread(PtrSprite,1,Size,rawfile);

    fclose(rawfile);

}
//---------------------------------------------------------------------------
void Sprite::LoadFrom_RAW_File(char *filename) {

 FILE *rawfile;

    rawfile=fopen(filename,"rb");

     W=320;H=200;
     Size=W*H;

      PtrSprite=(unsigned char *) malloc(Size);

     fread(PtrSprite,1,Size,rawfile);

    fclose(rawfile);

}
//---------------------------------------------------------------------------
void Sprite::SaveToFile(char *filename) {

 FILE *sprfile;

  sprfile=fopen(filename,"wb");

    fwrite(&W,sizeof(W),1,sprfile);
    fwrite(&H,sizeof(H),1,sprfile);
    fwrite(PtrSprite,Size,1,sprfile);

  fclose(sprfile);

}
//---------------------------------------------------------------------------
void Sprite::DrawSprite(int x,int y,unsigned char *dblbuf) {

 int i,startOff,incx=-1,incy=0;
 int precalc=0;
 unsigned char testCol;

 if(Size==0) return;
  /*
  if((Blink)&&(BlinkCnt<10)) {
    BlinkCnt++;
    Visible=false;
   }

   else {
    BlinkCnt=0;
    Visible=true;
   }
    */
//  if(!Visible) return;


   startOff=x+y*320;

  for(i=0;i<Size;i++) {

    if(incx<(W-1)) incx++;

     else {
       incx=0;
       incy++;
       precalc=incy*320;
     }

     testCol=PtrSprite[i];

      if((testCol!=0)&&((x+incx)<320)&&((y+incy)<200)&&
                       ((x+incx)>0)&&((y+incy)>0))

        dblbuf[startOff+(incx+precalc)]=testCol;

  }

}
//---------------------------------------------------------------------------
void Sprite::Transform(char type,Sprite *outSprite) {

 int i,j;

 switch(type) {

  case ROTATE_180DEG_LEFT:outSprite->W=W;
                         outSprite->H=H;
                         outSprite->Size=outSprite->W*outSprite->H;
                         outSprite->PtrSprite=(unsigned char *)malloc(outSprite->Size);

                         for(j=0;j<H;j++)
                          for(i=0;i<W;i++)
                           outSprite->PtrSprite[i+j*W]=PtrSprite[((W-1)-i)+j*W];

                         break;

  case ROTATE_90DEG_LEFT:outSprite->W=H;
                         outSprite->H=W;
                         outSprite->Size=outSprite->W*outSprite->H;
                         outSprite->PtrSprite=(unsigned char *)malloc(outSprite->Size);

                         for(j=0;j<outSprite->H;j++)
                          for(i=0;i<outSprite->W;i++)
                           outSprite->PtrSprite[i+j*outSprite->W]=PtrSprite[((W-1)-j)+i*W];

                         break;
 }

}
//---------------------------------------------------------------------------

