#!/bin/awk

BEGIN {
  INC="invdata.inc" ; ASM="inv.a86"

  no[86]   = no[203]  = no[207]  = no[253]  = no[457]  = no[468]  = 1
  no[493]  = no[867]  = no[869]  = no[890]  = no[972]  = no[994]  = 1
  no[1012] = no[1042] = no[1601] = no[2051] = 1
}

($1 !~ /^;/) && ($2 ~ /D[BWD]/) {
  printf("EXTRN %s:%s\n",$1,substr($2,2)) > INC
}
/BEGIN:/ { sub("^","include " INC "\n") }
/\[0\]$/ { sub("\\[0\\]$","") }
/RemoveNewInt9.* PROC/,/ ENDP/ { sub("OldInt9Addr","cs:&") }
/NewInt9Hand.* PROC/,/NotIntercept:/ { if ($1 == "MOV") sub($2,"cs:&") }
/NotIntercept:/,/CLC/ { sub("StoreAX","cs:&") ; sub("40:","") }

/JMP / {
  if ((!(NR in no)) && (NR<633 || NR>829) && (NR<1379 || NR>1472))
    sub("JMP ","&SHORT ")
}

{ print > ASM }
