#!/bin/awk -f
BEGIN {
  if(nasm){ASM="inv-nasm.asm";INC="inv-nasm.inc"}else ASM="inv-fasm.asm"
  if(nasm)print "%idefine offset\n%define LEA MOV\n" \
    "%define B byte\n%define W word\n%include '" INC "'" >ASM
  else print "OFFSET equ\nOffset equ\nLEA equ MOV" >ASM
}

linenum && (NR % 100)==0 { print "linenum=",NR }
/^;|^ *$|CODE_SEG|END/ { next }
/LEA / { print >ASM; next }
/\[[1-9]\]/ { for(i=1;i <= 9;i++) sub("\\["i"\\]","+"i) }
nasm && /[+]BX/ { gsub("\\[|\\]","") }

$2 ~ /^D[BWD]$/ {
  sub(" DD "," DW 0,")
  if (nasm) print "%define s_" $1,substr($2,2,1) >INC
  print >ASM; next
}

/^RemoveNewInt9 *PROC |CLC/ { cseg = !cseg }

{
  sub(";.*|\\[0\\]|40:|Word Ptr","")
  sub(" *PROC .*",":"); sub("ES:\\[","[ES:"); sub(","," ")

  if ($1 ~ /:$/) {
    print $1 >ASM
    for(i=2;i <= NF;i++)$(i-1)=$i; $NF=""; NF--
  }

  if (((NF > 2) && ($2 ~ /^[A-Z][^ ][^ ][^ ]*/)) ||
     (($1 ~ /DEC|INC/) && ($2 ~ /^[A-Z][^ ][^ ][^ ]*/)))
    if (nasm) $2="s_"$2"["$2"]"; else $2="["$2"]"
  else if (($3 ~ /^[A-Z][^ ][^ ][^ ]*/) && ($3 !~ /^O[fF]/))
    if (nasm) $3="s_"$3"["$3"]"; else $3="["$3"]"

  if (nasm) sub("[+].*\\[","[")

  if (cseg && ($0 !~ /\[0/)) sub("\\[","[cs:")

  for(i=1;i <= NF;i++)
    printf "%s%c%s",$i,(i==2 && NF > 2)?",":" ",(i==NF)?"\n":"" >ASM
}
# EOF
