{//-------------------------------------------------------------------------}
{/*                                                                         }
{Copyright (C) 1990, 2009 - Apogee Software, Ltd.                           }
{                                                                           }
{This file is part of Supernova.  Supernova is free software; you can       }
{redistribute it and/or modify it under the terms of the GNU General Public }
{License as published by the Free Software Foundation; either version 2     }
{of the License, or (at your option) any later version.                     }
{                                                                           }
{This program is distributed in the hope that it will be useful,            }
{but WITHOUT ANY WARRANTY; without even the implied warranty of             }
{MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                       }
{                                                                           }
{See the GNU General Public License for more details.                       }
{                                                                           }
{You should have received a copy of the GNU General Public License          }
{along with this program; if not, write to the Free Software                }
{Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.}
{                                                                           }
{Original Source: 1990 Scott Miller                                         }
{Prepared for public release: 03/19/09 - Joe Siegler, Apogee Software, Ltd. }
{*/                                                                         }
{//-------------------------------------------------------------------------}
(****************************************************************************)
(*                             SUPERNOVA VERSION B                          *)
(*     >> This file contains the special room routines for Supernova <<     *)
(*                         Programmer: Scott Miller                         *)
(*                       << Began February 2, 1985 >>                       *)
(*                       Copyright 1985 Scott Miller                        *)
(****************************************************************************)

{$C-,R-,V-,K-}

const
   VMax    = 95;     { Verbs   }
   NMax    = 133;    { Nouns   }
   PMax    = 11;     { Preps   }
   AMax    = 4;      { Adverbs }
   TMax    = 30;     { Timers  }
   RMax    = 109;    { Rooms   }
   MMax    = 29;     { Mov's   }
   Null    = 0;
   Legal   = 255;

type
   Str1    = string[1];
   Str9    = string[9];
   Str19   = string[19];
   Str29   = string[29];
   Str53   = string[53];
   Str77   = string[77];
   Str78   = string[78];
   Str130  = string[131];
   Str234  = string[234];
   Str255  = string[255];
   Entr    = record AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags:integer;end;
   LSet    = set of 1..NMax;
   SaveSet = record
              aInv    : set of 1..MMax;
              aPStat  : set of 1..6;
              aEvents : set of 1..255;
              aSocket,
              aWear   : set of 1..MMax
             end;

var
   SetSave : SaveSet;
   Sets    : file of SaveSet;
   Objects : file of LSet;
   Things  : file of byte;
   Timers  : file of integer;
   V{erb}  : array [1..VMax] of Str29;
   N{oun}  : array [1..NMax] of Str29;
   P{rep}  : array [1..PMax] of Str29;
   A{dvb}  : array [1..AMax] of Str53;
   RN{ame} : array [1..RMax]   of Str19;{ Name of each room stored here.      }
   R{oom}  : array [1..MMax] of byte;   { Knows which room a Mov object is in.}
   L{ocate}: array [0..RMax] of LSet;   { Locates all non-Mov objects.        }
   T{imer} : array [1..TMax] of integer;
   Dir     : array [1..8]    of Str9;
   M{max}  : array [1..3]    of byte;    {******************}
   PStat        : set of 1..6;           {* Player Status: *}
   NoNounOnly   : set of 1..VMax;        {* [] = Healthy   *}
   OneNounMaybe : set of 1..VMax;        {*  2 = Hungry    *}
   ToNounOnly   : set of 1..VMax;        {*  3 = Sick      *}
   ToNounMaybe  : set of 1..VMax;        {*  4 = Injured   *}
   Events       : set of 1..255;         {*  5 = Tired     *}
   Mov{able objects},                    {*  6 = Thirsty   *}
   Inv{ventory},                         {******************}
   Socket,
   Wear         : set of 1..MMax;
   Brief        : set of 1..RMax;
   NounSet      : set of 1..NMax;
   MugCon,         { All -Con variables are containers. }
   FoodCon,
   SatchCon,
   HolstCon,
   NicheCon,
   PyraCon,
   HingeCon,
   PodumCon,
   RobotCon,
   CodeSet,
   ScrnSet,
   Vb,
   N1,
   N2,
   Pr,
   Md,
   VNP,
   Prm,      { Player Room }
   EFlag,    { Error Flag  }
   FFlag,    { Format Flag }
   TFlag,    { Timer Flag  }
   list,
   Num,
   Region,   { Knows what room to go in when exiting the player's ship }
   AlienRm,
   FriendRm,
   SinkRm,
   Serum,    { Begins at zero, dispenser jams at 2! }
   Weight,
   Old,      { for Block Reader }
   Old2,
   x,y,o   : byte;
   Code,     { dials, etc }
   Tic,
   StoreR,   { Knows if the previous Room that was read is the same as the  }
   StoreS,   { Room that is about to be read.  If so, then it simply writes }
   StoreL,   { that variable again! }
   StoreC,
   RC,       { Endless Room Counter }
   Sc,       { Score       }
   TestC,
   Floor,
   i,j     : integer;
   Input,
   Again,
   Line    : Str130;
   Text1,
   Text2,
   Text4   : Str234;
   Text3   : Str78;
   Text5   : Str77;
   R1,R2,S1: file of Str234;
   L1      : file of Str78;
   C1      : file of Str77;
   T1,T2   : text[2500];
   Identity,
   VStr,
   NStr,
   PStr,
   LastNoun,
   Word    : Str29;
   Result  : Entr;
   Drive,
   Log,
   CFlag   : char;
   Maze,
   Crawl,
   Color,
   QFlag,
   SFlag   : boolean;  { If TRUE then a Special action took place. }
{----------}

{$Ia:ADPAR.pas   <<<<<------  LOADS IN MANY PARSER COMMANDS  ***************}

procedure Describe(Room:byte);
 begin
  col(9,9);write(RN[Prm]);col(11,7);writeln;
  if(en(1))or(not(en(1))and not(Prm in Brief))then
   begin Brief:=Brief+[Prm];
    case Prm of   { Alternate Room Descriptions }
     29:if en(35) then begin RS(130);RS(131)end else RR(29);
     34:if en(30) then begin RS(81);RS(82)end else RR(34);
     52:if en(39) then RS(126)else RR(52);
     91:if en(51) then begin RS(157);RS(158)end else RR(91)
     else RR(Room)
    end;
   end;
  case Prm of     { For initial object's description }
    1:if 16 in L[1] then RL(150);
   107:if 19 in L[107] then RL(518);
   38:if 17 in L[38] then RL(260);
   41:if(18 in L[41])and not en(34)then RS(96);
   55:if 11 in L[55] then RL(290);
   63:if 20 in L[63] then RL(356);
   73:if 28 in L[73] then RL(352);
   80:if 17 in L[80] then RL(395);
   94:begin if 26 in L[94] then RL(397);if 2 in L[94] then RL(398)end;
  end;
  for o:=1 to MMax do  { Print the objects that are lying in the room }
   if r[o]=Prm then
    begin
     if o=6 then write('There is some ',FN(o),' here.')
     else
      begin Word:=FN(o);
       if Word[1] in['a','e','i','o','u']then
        write('There is an ',FN(o),' here.')else
        write('There is a ',FN(o),' here.')
      end;
     if((o=29)and(MugCon<>Null))or((o=7)and(HolstCon<>Null))or
       ((o=5)and(SatchCon<>Null))then write('  (with something in it)');
     if(o=5)and(R[5]=20)then write('  (lying in some trash)');
     if(o=7)and(7 in L[12])and(R[7]=12)then write('  (on the shelf)');
     if o=NicheCon then write('  (on the niche)');
     if(en(6))and(o=16)then write('  (on the seat)');
     if o=PyraCon then write('  (in the pyramid''s slot)');
     if o=HingeCon then write('  (inside the statue''s mouth)');
     if o=PodumCon then write('  (on top of the podium)');
     if(o=16)and en(37)then write('  (under the crystal)');
     if o=RobotCon then write('  (in the robot''s panel)');
     if o in Socket then write('  (in one of the regulator''s sockets)');
     writeln;
    end;
 end; { Describe }

procedure Move{New:byte};
 begin SF;
  if en(7) then RL(22) else
  if en(8) then RL(23) else
  begin
   if(MugCon<>Null)and(29 in Inv)then
    begin if Prm<>8 then L[Prm]:=L[Prm]-[MugCon];L[New]:=L[New]+[MugCon]end;
   if(SatchCon<>Null)and(5 in Inv)then
    begin L[Prm]:=L[Prm]-[SatchCon];L[New]:=L[New]+[SatchCon]end;
   if(HolstCon<>Null)and(7 in Inv)then
    begin L[Prm]:=L[Prm]-[HolstCon];L[New]:=L[New]+[HolstCon]end;
   Prm:=New;
   Describe(Prm);
  end
 end; { Move }


{$Ia:VOCAB.pas    <<<<<-------  Loads in VOCABULARY LIST  **********}


{****************************** ROOM ROUTINES *******************************}
overlay procedure Room1;   { The Player's Ship }
begin
case Prm of
 1:case Vb of  { Bridge }
   2,13:Door(2,50);
   11:RL(199);
   22,24,28:case N1 of
        37,38,55,44:if Md<>Null then RL(534)else RB(3,11);103:RL(317);
        35:if en(6)then RL(542)else RL(543);
        59:case Region of
            1:RS(46);
            2:RS(63);
            4:RS(T[9]+46);
           end
       end;
   35:if N1 in[16,35] then
       if(here(16))and(en(6))then
        if not en(4) then
         begin Add(7);sound(440);RS(19);T[6]:=4;for x:=1 to random(30)+9 do
          begin y:=random(6000)+60;play(y,y,70);delay(9)end;Score(10,67)
         end
        else begin Add(7);RL(149); for x:=1 to random(9)+9 do
            begin y:=random(9999);play(y,y,30);delay(55)end;end
       else RL(141);
   56:if en(7)and en(6)then
       if T[6]>0 then
        if input=Identity then
         begin RS(21);T[6]:=Null;Score(15,4);play(400,400,200)end
        else RL(142)
       else
        if input='r2/20-8 d2/vega' then
         if not(Region in[2,4]) then
          begin RS(28);Add(26);Min(27);play(600,600,99)end
         else RL(154)
        else
         begin Min(26);RS(39);Min(27);play(600,600,99)end
       else RL(179);
   44:if en(7)and en(6)then
       case N1 of
        43:begin play(750,750,200);  { Purple }
            if Region=4 then
             if T[9]=11 then begin Score(5,68);Region:=2;T[13]:=3;TFlag:=2;
              n[126]:='hinged mouth\mouth\hinge\';
              RB(9,11);Explode(30)end
             else RS(64)
            else RL(198)
           end;
        40:begin play(900,900,200);  { Cyan }
            if en(26) then begin RS(37);Add(27)end
            else RL(195)
           end;
        41:begin play(600,600,200);  { Tan }
            if en(27) then
             if not(en(22))and not(en(23))then
              begin col(28,23);RL(180);col(11,7);
               RS(38);T[8]:=7;
               for x:=1 to 6 do
                for y:=30 to 200 do begin sound(y);delay(5)end;nosound;
              end
             else begin RS(40);play(500,999,3);Min(26);Min(27)end
            else if en(26)then RL(184)else RL(185)
           end;
       end {case}
      else RL(179);
   39:if(16 in NounSet)and en(6)then
       if en(7)then RL(575)else begin Min(6);RL(145);SFlag:=false;end;
   end; {Vb}
 end; {main case}
end; { Room1 }
{----------}
overlay procedure Room2;   { The Player's Ship }
begin
case Prm of
 2:case Vb of  { Forward Corridor }
   9,13,51:if(n1 in[0,62,64,71])then
     if en(23) then begin RL(237);case Region of 1:move(22);2:move(24);end end
     else RL(99);
   1,11:Door(1,50);
   2:move(3);
   4:move(4);
   24,28:if NStr='hatch' then if en(23) then RL(163)else RL(99);
   50:if N1=78 then
       if en(22)then begin RL(160);Min(22)end else
        begin RL(161);Add(22);
         if T[8]>0 then begin RS(40);play(500,999,3);T[8]:=0;Min(27)end end;
   41:if NStr='hatch' then
       if Region<>4 then
        if en(22) then
         begin RL(96);Add(23);
          if(not en(44))and(Region=2)then
           begin Add(44);RL(327);for i:=1 to 400 do sound(random(3500)+999);
            for i:=7500 downto 500 do begin sound(random(i)+i);
             sound(random(3500)+2000)end;
            for i:=1 to 300 do sound(random(3500)+2500);nosound;
           end
         end
        else RL(97)
       else begin RS(45);DEAD end;
   53:if N1=56 then
       if en(23) then begin RL(98);Min(23)end else say('hatch','closed');
   end; {Vb}

 3:case Vb of  { Rear Corridor }
   1,13:move(2);
   3:move(6);
   4:move(7);
   28,31:if N1 in[55,81] then begin RB2(4,12);Pause;end;
   24,41,76:if N1=55 then if Md in[1,4]then RL(533)else begin RS(22);DEAD;end;
   end; {Vb}
 end; {main case}
end; { Room2 }
{----------}
overlay procedure Room3;   { The Player's Ship }
begin
case Prm of

 4:case Vb of  { Ship's Lab }
   3,13:move(2);
   28,22:case N1 of
          90:RS(23); 52:RS(26); 38:RS(27); 55:RS(31);
          81,119:begin RB(10,14);Pause;end;
          64:if NicheCon<>Null then
              writeln('There is a ',FN(NicheCon),' sitting on the niche.')
             else RL(152);
         end;
   31:if N1 in[81,119] then begin RB(10,14);Pause;end;
   41..44,88:if N1=55 then RL(174);
   33:if N2=64 then
       if N1 in[3,4,8,9,12,17,29] then
        if Pr in[1,5,10] then
         if NicheCon=Null then
          begin Van(N1);R[N1]:=4;NicheCon:=N1;RL(147)end
         else RL(148)
        else crazy
       else RL(146);
   54:if N1 in[38,90]then begin RL(321);Serum:=1;end;
   56:begin Serum:=Serum+1;
       if Serum<3 then
        if NicheCon=Null then RS(24)
        else if NicheCon<>29 then
         writeln('A small amount of serum drips onto the ',FN(NicheCon),' and ',
                  'dries up.')
         else
          if MugCon=Null then begin MugCon:=92;RS(25);L[4]:=L[4]+[92];
           if input='6' then Add(42)else Min(42)end
          else
           if MugCon in[79,92,99] then
            writeln('The serum mixes with the ',FN(MugCon),' inside the mug.')
           else
            writeln('The serum drips on the ',FN(MugCon),' inside the mug and',
                    ' quickly evaporates.')
       else RS(135)
      end; {type}

   end; {Vb}

 5:case Vb of  { Sanitary Facilities }
   2,13:move(6);
   22,28:if N1=98 then RL(122);
   end; {Vb}

 6:case Vb of  { Sleep Chamber }
   1,11:move(5);
   4,13:move(3);
   28:case N1 of 80:RL(159); 69:RS(29) end;
   51:if N1=69 then Vb:=35;
   end; {Vb}

 7:case Vb of  { Cargo Area }
   3,13:move(3);
   22,28:if N1=32 then RL(155);
   24:if N1=32 then RL(156);
   41,53:if N1=32 then RL(157);
   39:if 32 in NounSet then RL(158);
   end; {Vb}

 end; {main case}
end; { Room3 }
{----------}
overlay procedure Room4;   { The Tavern }
begin
case Prm of
 8:case Vb of  { Tavern }
   2,13:if en(7)then RL(22)else begin RL(93);move(13)end;
   3,9,11,51:if en(7)then RL(22)
       else if(N1 in[null,71])then begin RL(283);move(9)end
       else if N1=126 then RL(473);
   31:if N1 in[81,119]then RB(2,9);
   35:case N1 of
      83:if T[1] in[4..7,11..17] then RS(8) else begin Add(19);Add(7);RL(30)end;
      35,84,85:begin Add(7);RL(30);if N1 in[35,84] then Add(2)else Min(2)end;
      end;
   65:if N1=124 then
       if en(2) then
        if T[1] in[5..7,11..18] then
         if(md=1)or(en(18))then begin RL(31);Score(20,3);
          if not en(18)then begin Add(18);T[1]:=8;end end
         else RL(32)
        else RL(41)
       else RL(33);
   28:case N1 of 56:RL(371);81,119:RB(2,9);111:RL(44)end;
   41:if N1=56 then RL(394);
   39:if(29 in NounSet)and not en(21)then RL(86);
   54,93:if N1=111 then begin RS(32);DEAD;end;
   42,44,75:if N1=111 then RL(474);
   59:if N1=126 then RL(473);
   20:if N1=126 then RL(178);
   end; {Vb}

 9:case Vb of  { West Hallway }
   1,2:RL(89);
   3,11:move(10);
   28:if N1=56 then RL(92);
   4,10,13,51:if(n1 in[null,71])then begin RL(284);move(8)end;
   54:if(N1=56)and(T[1]<1)then RS(13)else RL(123);
   41,88:if N1=56 then
          case N2 of 0:RL(107);3:RL(101)else RL(137)end;
   end; {Vb}

10:case Vb of  { Central Hallway }
   1:RL(89);
   4,13:move(9);
   3:move(11);
   28:if N1=56 then if en(11)then RL(370)else RL(92);
   2,11:if en(11) then begin RL(90);Score(5,69);move(12);Min(11)end
        else RL(89);
   41,88:if N1=56 then case N2 of 0:RL(107);3:begin;end else RL(137)end;
   54:if N1=56 then RL(123);
   end; {Vb}

11:case Vb of  { East Hallway }
   1,2:RL(89);
   4,13:move(10);
   28:if N1=56 then RL(92);
   41,88:if N1=56 then
          case N2 of 0:RL(107);3:RL(101)else RL(137)end;
   54:if N1=56 then RL(123);
   53:if N1=56 then begin RL(92);Min(11)end;
   end; {Vb}

12:case Vb of  { Suite #4 }
   1,13:if en(7)then RL(22)else
        if en(11) then begin RL(91);move(10);Min(11)end else RL(92);
   41,88:if N1=56 then begin RL(104);Add(11)end;
   22,28,76:
      case N1 of
       56:if en(11)then RL(370)else RL(92);
       80:if Md<>Null then RL(535)else RL(536);
       87:if 7 in L[12] then begin RL(106);R[7]:=12;Score(5,24)end;
       98:RL(121);
      end;
   53:if N1=56 then begin RL(92);Min(11)end;
   39:if(7 in NounSet)or(30 in NounSet)then Score(5,24);
   end; {vb}

 end; {main case}
end; { Room4 }
{----------}
overlay procedure Room5;   { Barre-An Planet }
 procedure Zap; begin for x:=1 to 29 do if R[x]=Prm then Van(x) end;
begin
case Prm of
13:case Vb of  { Crossroads }
   1,11:if en(7)then RL(22)else begin RL(93);move(8)end;
   2:move(18);
   3:move(16);
   4:move(14);
   28,31:if N1 in[81,88] then begin Score(5,70);RB2(5,6);Pause;end;
   41:if N1=56 then RL(394);
   end; {Vb}

14:case Vb of  { Dusty Road }
   3:move(13);
   4:begin RC:=1;move(15)end;
   end; {Vb}

15:case Vb of  { Dusty Road (endless) }
   3:begin Zap;RC:=RC-1;if RC<1 then move(14)else move(15)end;
   4:begin Zap;RC:=RC+1;move(15);if RC=40 then
      writeln('You notice something unusual.')end;
   11,13:if RC=40 then begin RL(135);Explode(3);play(1,9999,0);play(9999,1,0);
          walls(10);Explode(5);TFlag:=4;Inv:=[1,6,12,17,20,26,28,29];move(78);
          T[3]:=120;T[4]:=120;T[5]:=120;PStat:=[];MugCon:=79;Bor(0,0)end;
   end; {Vb}

16:case Vb of  { Gravel Road }
   2,11:begin RL(108);move(20)end;
   3:begin RC:=1;move(17)end;
   4:move(13);
   28,31:if N1=81 then RL(109);
   end; {Vb}

17:case Vb of  { Gravel Road (endless) }
   3:begin Zap;RC:=RC+1;if(RC=80)and(Inv<>[])then
       begin move(17);RS(17);Inv:=[];end
      else move(17)end;
   4:begin Zap;RC:=RC-1;if RC<1 then move(16)else move(17)end;
   end; {Vb}

18:case Vb of  { Paved Road }
   1:move(13);
   2:begin RC:=1;move(19);end;
   4,11:move(21);
   end; {Vb}

19:case Vb of  { Paved Road (endless) }
   1:begin Zap;RC:=RC-1;if RC<1then move(18)else move(19)end;
   2:if RC=60 then RS(18) else begin Zap;RC:=RC+1;move(19)end;
   end; {Vb}

20:case Vb of  { General Store }
   1,13:move(16);
   28:if N1=132 then RL(88);
   20,26,76:if(N1 in[86,87])and(5 in L[20])then
       begin RS(14);R[5]:=20;Score(15,20)end;
   39:if(5 in NounSet)or(30 in NounSet)then Score(15,20);
   end; {Vb}

21:case Vb of  { Gravel Lot }
   3,13:move(18);
   1,4..8:RL(27);
   2,9,51:if N1 in[Null,62,71] then begin RL(234);move(22)end;
   28,31:if n1=81 then begin Score(5,71);RB(1,7);Pause;end;
   end; {Vb}

22:case Vb of  { Top of Ship (Barre-An) }
   1:begin RL(235);move(21)end;
   10,11,51:if(n1 in[null,62,64,71])then
        if en(23) then begin RL(236);move(2);Score(15,72)end else RL(99);
   24,28,31:case N1 of
       56:if en(23) then RL(163)else RL(99);81:begin RB(1,7);Pause;end end;
   50:if N1=78 then
       if en(22)then begin RL(94);Min(22)end else begin RL(95);Add(22)end;
   41:if N1=56 then
       if en(22) then begin RL(96);Add(23);Score(5,73)end else RL(97);
   53:if N1=56 then
       if en(23) then begin RL(98);Min(23)end else say('hatch','closed');
   59:if(N1 in[49,122])or(VStr='jump off')then move(21);
   end; {Vb}

 end {main case}
end; { Room5 }
{----------}
overlay procedure Room6;   { Jungle Planet }
begin
case Prm of
23:case Vb of  { Deep Pit }
    1..13,51:RL(217);
    28,31:case N1 of  73:RL(218); 81,116:RS(80) end;
    75:if N1=73 then move(34);
   end;

24:case Vb of { Top of Ship (Jungle planet) }
   3:begin RL(235);move(25)end;
   10,11,51:if(n1 in[null,62,64,71])then
        if en(23) then begin Score(5,74);RL(236);move(2)end else RL(99);
   24,28:if N1=56 then if en(23) then RL(163)else RL(99);
   50:if N1=78 then
       if en(22)then begin RL(94);Min(22)end else begin RL(95);Add(22)end;
   41:if N1=56 then
       if en(22) then begin RL(96);Add(23)end else RL(97);
   53:if N1=56 then
       if en(23) then begin RL(98);Min(23)end else say('hatch','closed');
   59:if(N1 in[49,122])or(VStr='jump off')then move(25);
   end; {Vb}

25:case Vb of { Sandy Clearing }
   4,9,51:if N1 in[Null,62,71] then begin RL(234);move(24)end;
   1:begin move(26);Score(5,75)end;
   1..8:RL(200);
   end; {Vb}

26:case Vb of { Winding Path 1 }
   2:move(25);
   5:begin RS(65);DEAD;end;
   59:if N1=66 then
       if VStr='jump in' then begin RL(288);DEAD;end
       else begin RS(66);move(27);Score(25,76)end;
   1..8:RL(200);
   9,51:if N1=112 then RL(204);
   28:if N1=66 then RS(85);
   35,62:if N1=66 then begin RL(288);DEAD;end;
   75,76:if N1=66 then RL(285);
   83:if N1=66 then RL(286);
   84:if N1=66 then begin RL(287);DEAD;end;
   end;

27:case Vb of { Winding Path 2 }
   6:move(28);
   8,11:begin RS(65);DEAD;end;
   1..8:RL(200);
   9,51:if N1=112 then RL(204);
   59:if N1=66 then
       if VStr='jump in' then begin RL(288);DEAD;end
       else begin RS(66);move(26)end;
   28:if N1=66 then RS(85);
   35,62:if N1=66 then begin RL(288);DEAD;end;
   75,76:if N1=66 then RL(285);
   83:if N1=66 then RL(286);
   84:if N1=66 then begin RL(287);DEAD;end;
   end;

28:case Vb of { Winding Path 3 }
   7:move(27);
   6:move(29);
   8:begin RS(67);DEAD;end;
   1..8:RL(200);
   9,51:if N1=112 then RL(204);
   28:if N1=112 then RS(86);
   24:if N1=112 then RL(553);
   end;

29:case Vb of { Winding Path 4 }
   7:move(28);
   5:if en(29) then move(32) else
      begin col(10,7);RS(72);col(11,7);T[12]:=146;Add(29);move(32)end;
   9,51:if N1 in[Null,112] then begin RL(201);move(30)end;
   6:begin RS(69);Prm:=31;T[11]:=4;end;
   8:if en(35)or en(130)then begin RC:=1;move(59);Score(20,77)end;
   1..8:RL(200);
   28:case N1 of 112:RL(238);120:RL(544);
       113:if Md=1 then begin RL(314);Add(130)end end;
   59:if N1=120 then begin RL(541);Prm:=31;T[11]:=4;end;
   end;

 end {main case}
end; { Room6 }
{----------}
overlay procedure Room7;   { Jungle Planet }
begin
case Prm of
30:case Vb of { Top of Tree }
   9:RL(202);
   10,51:if N1 in[Null,112] then begin RL(203);move(29)end;
   1..8:RL(200);
   20..28:if N1=68 then RS(79);
   18,17:RL(603);
   end;

31:case Vb of { Quicksand Pit }
   1..8:RL(206);
   9,51:if N1=112 then RL(204);
   39,42,76:if N1=47 then
     if en(78)then RL(549)else begin T[11]:=0;RS(71);Prm:=29;Score(25,78)end;
   28:case N1 of 47:RL(239); 120:RL(240);end
   end;

32:case Vb of { Winding Path 5 }
   1:move(33);
   8:begin move(29);if en(35) and not en(40) then begin RL(314);Add(40)end end;
   1..8:RL(200);
   9,51:if N1=112 then RL(204);
   end;

33:case Vb of { Winding Path 6 }
   2:move(32);
   6:if not en(28)then begin RS(68);Add(28);move(34)end else move(34);
   1..8:RL(200);
   9,51:if N1=112 then RL(204);
   end;

34:case Vb of { Front of Pyramid }
   7:move(33);
   41..44,54,75,88:if N1=56 then RL(220) else
      if N1=126 then
       if HingeCon<>Null then
        begin writeln('The hinged mouth opens, revealing a ',FN(HingeCon),
                      ' inside.');Add(31);R[HingeCon]:=34;Score(25,79)end
       else begin RL(226);Add(31)end;
    53:if N1=56 then RL(220) else
       if N1=126 then
        begin RL(227);if HingeCon<>Null then R[HingeCon]:=Null;Min(31)end;
   1,11:if en(30) then begin Score(25,80);move(35)end else RL(219);
   39:if(PyraCon in NounSet)or((30 in Nounset)and(PyraCon=9))then
       begin RL(225);Min(30);SFlag:=false;end else
      if HingeCon in NounSet then begin RL(228);SFlag:=false;end;
   1..8:RL(200);
   9,51:if N1=112 then RL(204);
   92:if N1 in[Null,49,122] then begin RL(216);move(23) end;
   31:if N1 in[81,89,119] then begin RB(8,7);Pause;end;
   28,24:case N1 of 68:RS(87); 89:RS(88); 81,119:begin RB(8,7);Pause;end;
          64:if PyraCon=Null then RL(241)else
              writeln('The small slot contains a ',FN(PyraCon),'.');
          56:if en(30) then RL(244)else RL(245);
          126:if en(31)then
               if HingeCon=Null then RL(242)else
               writeln('The open mouth contains a ',FN(HingeCon),'.')
              else RL(243);
         end;
   end;

 end {main case}
end; { Room7 }
{----------}
overlay procedure Room8;   { Inside Pyramid (Top Level) }
begin
case Prm of
35:case Vb of  { Vestibule }
   2,13:move(34);
   10,11,51:if N1 in[Null,71] then
     if en(32) then move(36) else begin RS(84);Add(32);move(36)end;
   28:if N1=56 then if en(30) then RL(244)else RL(245);
   end;

36:case Vb of  { Descending Stairs }
   10,11,51:if N1 in[Null,71] then move(37);
   9,13:move(35);
   end;

37:case Vb of  { Halcyon Hall }
   1:if T[16]>1 then begin RL(278);DEAD;end else move(39);
   3:move(38);
   10,51:if N1 in[Null,71] then move(42);
   9,13:move(36);
   end;

38:case Vb of  { Departure Room }
   4,13:move(37);
   28:case N1 of
       73:if 10 in L[38] then begin RL(253);RL(252)end else RL(253);
       10:if 10 in L[38] then RL(254);
       30:if 17 in L[38] then begin SF;writeln('It''s a grey disk!')end
      end;
   26:if(N1=10)and(10 in L[38])then RL(255);
   42,44:if N1 in[10,73] then RL(256);
   75:if N1=73 then RL(257);
   47,83,84:RL(258);
   39:if(10 in L[38])and(10 in NounSet)then
       begin L[38]:=L[38]+[17];RL(259);Score(15,81);SFlag:=false;end
      else if(30 in NounSet)and(17 in L[38])then R[17]:=38;
   end;

 end {main case}
end; { Room8 }
{----------}
overlay procedure Room9;   { Inside Pyramid (Top Level) }
begin
case Prm of
39:case Vb of  { Holey Hall }
   2,13:if T[15]>1 then begin RL(269);move(37);Score(5,82)end else move(37);
   4,11:if T[15]>1 then begin RS(95);DEAD;end else move(40);
   end;

40:case Vb of  { Pyramid Lobby }
   1,11:if T[14]>1 then
         begin n[68]:='podium\alter\column\';WRITE('');move(41)end;
   3,13:if(18 in Inv)or(4 in Inv)then begin Brief:=Brief-[39];move(39);
          T[15]:=3;T[16]:=9;col(10,7);RS(93);
          for i:=500 to 5500 do sound(random(i)+random(i));
          for j:=1 to 7000 do sound(random(i)+random(i));
          for j:=i downto 500 do sound(random(j)+random(j));nosound;
         end
        else move(39);
   42,44,51,75,84,94:
     if N1=68 then
      if T[14]>1 then RL(246) else
       if en(33) then begin T[14]:=7;RL(261);Walls(8);end
       else begin T[14]:=7;Score(20,33);RS(89);Walls(8);end;
   28:case N1 of 56:if T[14]>1 then RL(370)else RL(92);68:RL(247)end;
   end;

41:case Vb of  { Treasure's Keeper }
   2,13:if T[14]>1 then begin n[68]:='pyramid\podium\';WRITE('');move(40)end
        else RL(248);
   28,22:case N1 of
          56:if T[14]>1 then RL(370)else RL(92);
          68:if PodumCon=Null then RL(264) else
             writeln('There is a ',FN(PodumCon),' on the podium.');
          18:if(18 in L[41])and not en(34)then RS(90);
         end;
   33:if N2=68 then
       if Pr=1 then
        if N1 in Mov then
         if PodumCon=Null then
          begin Van(N1);R[N1]:=41;PodumCon:=N1;RL(266)end
         else RL(268)
       else crazy;
   75:if N1=68 then RL(276);
   50:if N1=68 then begin RL(277);Walls(8);T[14]:=7;end;
   39:if(30 in NounSet)and(18 in L[41])then R[18]:=41;
   end;

 end {main case}
end; { Room9 }
{----------}
overlay procedure Room10;   { Pyramid Maze }
begin
case Prm of
42:case Vb of  { Ladder Room }
   1..13:if Maze then case Vb of 9,13:move(37);6:move(43);3,8:move(42)end
         else case Vb of 9,13:move(37)end;
   41..44,50,55:if N1=116 then RL(325);
   28:if N1=116 then RL(547);
   end;

43:case Vb of  { Shifting Room NW }
   1..8:if Maze then case Vb of 7:move(42)end
        else case Vb of 2:move(44);8:move(45)end;
   41..44,50,55:if N1=116 then RL(325);
   28:if N1=116 then RL(547);
   end;

44:case Vb of  { Shifting Room W }
   1..8:if Maze then case Vb of 7:move(47);2:move(45)end
        else case Vb of 1:move(43);5:move(44)end;
   41..44,50,55:if N1=116 then RL(325);
   28:if N1=116 then RL(547);
   end;

45:case Vb of  { Shifting Room SW }
   1..8:if Maze then case Vb of 1,3:move(45)end
        else case Vb of 1:move(45);6:move(43)end;
   41..44,50,55:if N1=116 then RL(325);
   28:if N1=116 then RL(547);
   end;

46:case Vb of  { Shifting Room N }
   1..8:if Maze then
         case Vb of 1:begin RS(98);DEAD;end;
          7:begin Score(50,84);move(50)end end
        else
         case Vb of 1:begin RS(98);DEAD;end;
          7:begin Score(50,84);move(50)end;3:move(48);8:move(45)end;
   41..44,50,55:if N1=116 then RL(325);
   28:if N1=116 then RL(547);
   end;

47:case Vb of  { Shifting Room S }
   1..8:if Maze then case Vb of 6:move(44)end
        else case Vb of 3:move(49);1:move(47);4:move(45)end;
   41..44,50,55:if N1=116 then RL(325);
   28:if N1=116 then RL(547);
   end;

48:case Vb of  { Shifting Room NE }
   1..8:if Maze then case Vb of 7:move(49);3,4:move(48)end
        else case Vb of 4:move(46);1,2:move(48)end;
   41..44,50,55:if N1=116 then RL(325);
   28:if N1=116 then RL(547);
   end;

49:case Vb of  { Shifting Room SE }
   1..8:if Maze then case Vb of 5:move(48)end
        else case Vb of 4:move(47);2:move(45)end;
   41..44,50,55:if N1=116 then RL(325);
   28:if N1=116 then RL(547);
   end;

50:case Vb of  { Stairway Room E }
   6:move(46);
   4,10,13,51:move(51);
   41..44,50,55:if N1=116 then RL(325);
   end;

 end {main case}
end; { Room10 }
{----------}
overlay procedure Room11;   { Inside Pyramid (Bottom Level) }
begin
case Prm of
51:case Vb of  { Lower Stairway }
   3,9,13,51:move(50);
   1:move(52);
   end;

52:case Vb of  { Misty Passage }
   2:if T[19]>1 then begin RS(129);DEAD;end else move(51);
   4:if en(35)then begin RL(305);DEAD;end else move(53);
   33:if(N1=11)and(11 in Inv)then
       if Pr in[1,5,7,10] then
        if N2 in[34,49,64] then
         if T[19]>0 then
          begin Score(40,39);Van(11);L[52]:=L[52]+[11];T[19]:=0;RS(127)end
         else begin Van(N1);R[N1]:=52;RL(586)end;
   39:if(11 in NounSet)and en(39)then RL(307);
   28:case N1 of 11:RL(312); 64:RL(313) end;
   42,44,55:case N1 of 11:RL(307); 34:RL(308); end;

   end;

53:case Vb of  { Damp Passage }
   2:begin move(54);if en(35)then begin RS(122);DEAD;end end;
   3:if T[18]>1 then begin RL(305);DEAD;end else move(52);
   59:if N1=66 then
       begin RS(125);Brief:=Brief-[52];move(52);T[18]:=0;T[19]:=3;
        col(10,7);RL(306);Walls(12);Score(20,85)end;
   end;

54:case Vb of  { Dark Passage }
   1:move(53);
   2:move(55);
   end;

55:case Vb of  { Circular Chamber }
   1:begin Brief:=Brief-[54];move(54);
      if en(35)then
       if Crawl=true then
        begin col(10,7);RS(119);RS(120);Pause;L[53]:=L[53]+[66];Score(20,86);
         Brief:=Brief-[53];move(53);col(10,7);RS(121);Walls(12);T[18]:=4;end
       else begin col(10,7);RS(118);DEAD;end end;
   2:if Md=1 then RS(230)else
      if random(2)=1 then begin Prm:=58;RL(563)end else begin RS(100);DEAD;end;
   3:begin move(56);if 11 in Inv then begin RS(102);DEAD;end end;
   4:if Md=1 then RS(231)else begin RS(99);DEAD;end;
   39:if(11 in NounSet)then begin RS(101);SFlag:=false;end
      else if(30 in Nounset)and(11 in L[55])then R[11]:=55;
   end;

 end {main case}
end; { Room11 }
{----------}
overlay procedure Room12;   { Inside Pyramid (Bottom Level) }
begin
case Prm of
56:case Vb of  { The Erusaert }
   2,11:if en(36) then begin Score(5,88);move(57)end;
   4,13:if T[17]>4 then begin RS(108);DEAD;end else move(55);
   22,28:case N1 of
         1:if not en(35) then RL(292);
         34:if 1 in L[56]then RL(291)
            else if not en(35)then begin RS(103);L[56]:=L[56]+[1]end;
         49:RS(105);
         56:RL(370);
         66:RL(295);
         68:RS(104);
         110:RL(293);
         end;
   26:if N1 in[49,68] then RL(295);
   39:if 1 in NounSet then
       begin
        if not en(35)then RL(300) else
        if T[17]>4 then
         begin RS(113);T[17]:=3;Van(1);Inv:=Inv+[1];Score(50,87)end
       end
      else if(30 in NounSet)then RL(578);
   37:if not(1 in NounSet)and(not en(35))then RL(300);
   35,51,62:if N1=68 then begin RS(106);DEAD;end;
   59:begin RS(107);DEAD;end;
   41,88:if N1 in[68,110] then
          if N2=4 then
           if not en(35)then
            if here(16)and en(37)then
             begin RS(117);T[17]:=6;L[56]:=L[56]+[1,56];Add(35);Min(37)end
            else begin RS(111);DEAD;end
           else RL(273)
          else RL(296);
   33:if N1=16 then
       begin
        if Pr in[1,10] then
         if N2 in[49,1] then
          begin Van(16);Add(37);R[16]:=56;
           if not en(35)then
            if Pr=1 then RL(297)else RL(298)
           else RL(297)
          end
         else
          if(N2=34)and(Pr=10)then
           begin writeln('Done.');Van(16);SF;R[16]:=56;end
          else if N2=68 then RL(299)
       end
      else
       if N2 in[68,110] then
        if Pr=1 then RL(299) else
        if Pr=5 then
         if N1=4 then
          if not en(35)then
           if here(16)and en(37)then
            begin RS(117);T[17]:=6;L[56]:=L[56]+[1];Add(35);Min(37)end
           else begin RS(111);DEAD;end
          else RL(273)
         else RL(296);
   54,75,76:case N1 of
            1:if 1 in L[56] then RL(300);
            34:RL(304);
            end;
   end; {Vb}

 end {main case}
end; { Room12 }
{----------}
overlay procedure Room13;   { Inside Pyramid (Bottom Level) }
begin
case Prm of
57:case Vb of  { Solar Chamber }
   1,13:move(56);
   28:case N1 of 56:RL(370);72,82,116:RS(149);109:RS(150)end;
   44,75:if N1=103 then begin Prm:=58;RS(233);Walls(5);Static end;
   end; {Vb}

58:case Vb of  { Eternal Trap }
   9,13,51:RL(554);
   92:RL(555)
   end;

59:case Vb of  { Overgrown Path }
   5:begin RC:=RC-1;if RC<1 then begin RL(309);move(29)end else RL(310)end;
   8:begin RC:=RC+1;if RC>7 then begin RL(309);move(60)end else RL(310)end;
   1..8:RL(200);
   9,51:if N1=112 then RL(204);
   end;

60:case Vb of  { Antenna Building (Outside) }
   4,11:begin Door(61,25);
         if not en(43)then begin RS(137);Score(10,43)end end;
   5:move(59);
   1..8:RL(200);
   28:case N1 of 96:RL(323);115:RL(324)end;
   41..44,54,75,88:if N1=56 then RL(315);
   9,51:if N1=112 then RL(204)else RL(316);
   end;

61:case Vb of  { Monitor Outpost }
   3,13:Door(60,25);
   2,11:move(62);
   28,24,31:case N1 of 37,59:RS(133);38,44:RL(322);93:RL(319);
             94:RS(134)end;
   42,44,75:if N1 in[37,38,44] then RL(318);
   end;

62:case Vb of  { Booth (Jungle Planet) }
   1,13:move(61);
   42,44,75:
     case N1 of
      37,38:RL(318);
      44:begin RS(138);
          for y:=60 downto 1 do for x:=800 downto 1 do sound(x*y);
          nosound;TFlag:=3;Brief:=Brief-[70];Score(10,89);
          for x:=1 to MMax do if R[x]=62 then R[x]:=70;move(70)
         end
     end;
   28,24,31:case N1 of 37,59:RS(133);38:RL(322);93:RL(319);
             94:RS(134);44:RL(320);end;
   end; {Vb}

63:case Vb of  { Booth (Ringed Planet) }
   1,13:RL(328);
   42,44,75:case N1 of
            37,38:RL(318);
            44:begin RS(138);
                for y:=60 downto 1 do for x:=800 downto 1 do sound(x*y);
                nosound;TFlag:=3;Brief:=Brief-[70];
                for x:=1 to MMax do if R[x]=63 then R[x]:=70;move(70)
               end
            end;
   28,24,31:case N1 of 37,59:RS(133);38:RL(322);93:RL(319);
             94:RS(134);44:RL(320);end;
   39:if(30 in NounSet)and(20 in L[63])then R[20]:=63;
   end; {Vb}

 end {main case}
end; { Room13 }
{----------}
overlay procedure Room14;   { Inner Planet }
begin
case Prm of
64:case Vb of  { Lobby }
   1,13:begin DOpen(99);RS(139);DEAD;end;
   2,11:move(65);
   28:case N1 of 35:RL(330);49,122:RL(334);72,116:begin Score(5,90);RS(148)end;
       81:RB(5,11);86:RL(333);127:RL(351)end;
   31:if N1=81 then RB(5,11);
   20,24:if N1=127 then RS(142);
   54:if N1=127 then if Md=3 then begin RL(537);DEAD;end else RL(538);
   end;

65:case Vb of  { North Corridor }
   1:move(64);
   2:move(66);
   4:Door(68,20);
   28:if N1=56 then RL(92);
   end;

66:case Vb of  { Central Corridor }
   1:move(65);
   2:move(67);
   3:if T[20]>1 then begin Score(15,91);move(73)end else RL(92);
   4:move(72);
   28:case N1 of 56:if T[20]>1 then RL(370)else RL(92);64:RL(335)end;
   33:if N2=64 then
       if Pr=5 then
        if N1=12 then
         begin RL(336);T[20]:=3;DOpen(20);Score(5,92)end
        else RL(137);
   end; {Vb}

67:case Vb of  { South Corridor }
   1:move(66);
   2,11:Door(75,5);
   4:move(71);
   end;

71:case Vb of  { Monitor Station }
   3:move(67);
   28:case N1 of 59:if CodeSet=4 then RL(353)else RL(355);116:RL(354)end;
   31:if N1=59 then
       if CodeSet=4 then begin RB2(11,14);Pause;end else RL(355);
   end;

72:case Vb of  { Reactor Control }
   3:move(66);
   28,24:case N1 of 128:RL(560);
       37,38:RL(339);46:if Md<>Null then begin Score(5,93);RL(343)end
              else RS(145);
       55:if en(46)then
           if RobotCon<>Null then
            writeln('The robot''s panel contains a ',FN(RobotCon),'.')
           else RL(346)
          else RL(344);
      end;
   33:if N2=55 then
       if Pr=5 then
        if en(46)then
         if RobotCon=Null then
          if N1 in[3,4,8,12,17]then
           begin Van(N1);RL(347);R[N1]:=72;RobotCon:=N1;end
          else RL(137)
         else RL(348)
        else RL(344);
   41:if N1 in[55,46] then
       if RobotCon=Null then RL(558)else
        begin R[RobotCon]:=72;Add(46);Score(25,94);
         writeln('The panel slides open, revealing a ',FN(RobotCon),' inside.')
        end;
   53:if N1=55 then begin Van(RobotCon);Min(46);RL(344)end;
   42,44:case N1 of
          37,38,44:begin RL(340);Walls(9);gotoxy(43,wherey-1);col(28,31);
                    writeln('BOOM!');Explode(32);DEAD;end;
          46:if(VStr='turn on')or(VStr='activat')or
               (VStr='turn off')then RL(341)
             else if(not en(94))and(not en(93))then begin RL(342);RL(559)end
                  else RL(342)
         end;
   end; {Vb}

 end {main case}
end; { Room14 }
{----------}
overlay procedure Room15;   { Inner Planet }
begin
case Prm of
68:case Vb of  { Decontamination }
   3,13:if en(45)then Door(65,20) else RL(331);
   4,11:Door(69,20);
   28,24:case N1 of 131:RL(329);end;
   42,44,75:if N1=44 then begin RL(332);Add(45);play(20,99,7);play(99,99,600);
      play(99,20,7);Score(10,95)end;
   end;

69:case Vb of  { Waiting Room }
   2,11:Door(70,50);
   3,13:Door(68,20);
   28,24:case N1 of 35:RL(330);131:RL(329);end;
   end;

70:case Vb of  { Transporter Booth }
   1,13:Door(69,50);
   28,24:case N1 of 44:RS(140);93:RL(319);94:RS(141);end;
   42,44,75:
     if N1 in[40..43]then
      begin Brief:=Brief-[62,63,78];RS(138);Min(45);
       for y:=60 downto 1 do for x:=800 downto 1 do sound(x*y);nosound;
        case N1 of
         40:begin for x:=1 to MMax do if R[x]=70 then R[x]:=78;
             TFlag:=4;move(78);Score(15,97)end;
         41:begin for x:=1 to MMax do if R[x]=70 then R[x]:=62;
             TFlag:=2;move(62)end;
         43:begin for x:=1 to MMax do if R[x]=70 then R[x]:=63;
             TFlag:=2;move(63);Score(10,96)end
        end;
      end;
   end; {Vb}

{ 71 and 72 are in Room14 }

 end {main case}
end; { Room15 }
{----------}
overlay procedure Room16;   { Inner Planet }
begin
case Prm of
73:case Vb of  { Communications }
   1:move(74);
   4:Door(66,20);
   28:case N1 of
       48:begin RL(366);writeln('The dial is set at number ',CodeSet,'.')end;
       115:RL(350);121:RL(367);127:RL(351)
      end;
   50:if N1=48 then
       if Pr>Null then
        if(code>0)and(code<11)then
         begin RL(363);CodeSet:=Code;if Code=4 then Score(10,98)end
        else RL(362)
       else RL(365);
   end; {Vb}

74:case Vb of  { Computer Station }
   2:move(73);
   28:case N1 of 37:RL(349);38:RL(322);52:RL(37);
       59:begin RB2(7,10);col(26,23);RL(364);Score(5,47)end end;
   31:if N1=59 then begin RB2(7,10);col(26,23);RL(364);Add(47)end;
   end;

75:case Vb of  { Elevator  1st Floor }
   1:Door(67,5);
   42,44,75:begin RS(143);play(20,42,20);sound(42);delay(5500);RL(338);
   play(42,20,20);Prm:=76;for x:=1 to MMax do if R[x]=75 then R[x]:=76;end;
   end;

76:case Vb of  { Elevator  2nd  Floor }
   1:begin Score(5,99);Door(77,5)end;
   42,44,75:begin RS(144);play(20,42,20);sound(42);delay(5500);RL(338);
             play(42,20,20);Prm:=75;for x:=1 to MMax do if R[x]=76 then R[x]:=75;end;
   end;

77:case Vb of  { Observatory }
   2:Door(76,5);
   28:case N1 of 34:RL(562);104:if Nstr='eyepiec' then RL(561)else RS(146)end;
   24:if N1=104 then
       if 20 in Wear then begin Score(5,100);RS(147)end
       else begin RL(368);RL(369)end;
   end;

 end {main case}
end; { Room16 }
{----------}
overlay procedure Room17;   { Planetship }
begin
case Prm of
78:case Vb of  { Icy Platform }
   3,11:door(79,25);
   28:case N1 of
       54:RL(379);93:RL(380);96:RL(381);103:RL(500);115:RL(350);118:RL(382)
      end;
   59:if N1=54 then begin RL(400);DEAD;end;
   end;

79:case Vb of  { Confirmation Port }
   4,13:door(78,25);
   28:case N1 of 44:RL(383);64:RL(384);116:RL(600)end;
   44,75:if N1=44 then begin RS(156);Score(10,50);
          play(20,99,7);play(99,99,600);play(99,20,7)end;
   33:if N2=64 then
       if Pr=5 then
        if N1=17 then
         begin Explode(1);sound(50);RS(151);
          for i:=9000 downto 1 do
           for j:=1 to 4 do sound(random(i div 2 + 400)+i);nosound;
          Van(17);L[80]:=L[80]+[17];move(80);Add(7);T[22]:=3;T[26]:=91;
          delay(900);sound(70);RL(399);delay(999);nosound;Score(25,101);
          n[40]:='sockets\socket\';
          n[82]:='laser beam\laser\beam\';
          n[110]:='speaker\';
         end
        else RL(137);
   end;

80:case Vb of  { Inspection Lobby }
   4,13:door(81,65);
   9:RL(523);
   28:case N1 of 55:RL(385);86:if 17 in L[80]then RL(395);72,116:RS(148)end;
   41..44,88,53:if N1=55 then RL(405);
   end;

 end {main case}
end; { Room17 }
{----------}
overlay procedure Room18;   { Planetship }
begin
case Prm of
81:case Vb of  { Circular Corridor }
   2:move(82);
   3,11:door(80,65);
   6:move(88);
   28:case N1 of 72:RL(386)end;
   end;

82:case Vb of  { Circular Corridor }
   1:move(81);
   3:door(96,50);
   4:door(93,5);
   8:move(83);
   28:case N1 of 72,103:RL(387)end;
   end;

83:case Vb of  { Circular Corridor }
   2,11:door(95,25);
   4:move(84);
   5:move(82);
   28:case N1 of 72,115:RL(388)end;
   end;

93:case Vb of  { Central Elevator }
   3,11,13:case Floor of
      1:door(82,5);
      2..5,30..40,89..95,170..230,333..444,543..600,793..812:RL(413);
      480:if en(64)then
           begin door(98,5);delay(999);RS(217);Score(20,102);
            for x:=1 to 7 do begin i:=random(7000)+1500;j:=random(600)+400;
             play(i,i,j)end;
            RL(516)end
           else RL(413)
      else begin door(97,5);Score(5,103)end
     end;
   28:if N1 in[44,52] then RS(188);
   56:begin val(input,i,testc);
       if testc=0 then
        if(i>0)and(i<837)then
         if i<>Floor then
          begin j:=i;i:=abs(floor-i);Floor:=j;RL(411);play(20,36,35);
           sound(37);for x:=1 to 200 do delay(i div 4);
           RL(412);play(36,20,35);
          end
         else RL(410)
        else RL(410)
       else crazy
      end
   end;

95:case Vb of  { Transmission Room }
   1,13:door(83,25);
   28:if N1 in[38,121]then RS(191);
   42,44,75:if N1=44 then begin Score(5,104);RL(404);play(1200,1200,99);
     if en(48)then Min(48)else Add(48)end;
   end;

96:case Vb of  { Station Control }
   4,13:door(82,50);
   28:case N1 of 38:RS(192);59:begin Score(5,105);RB2(11,5);Pause;end end;
   31:if N1=59 then begin Score(5,105);RB2(11,5);Pause;end;
   end;

 end {main case}
end; { Room18 }
{----------}
overlay procedure Room19;   { Planetship }
begin
case Prm of
84:case Vb of  { Circular Corridor }
   2,11:door(94,65);
   3:move(83);
   6:move(85);
   28:case N1 of 72,46:RL(389)end;
   end;

85:case Vb of  { Circular Corridor }
   1:move(86);
   4,11:door(92,65);
   7:move(84);
   28:case N1 of 72:RL(390)end;
   end;

86:case Vb of  { Circular Corridor }
   2:move(85);
   4,11:if T[21]>1 then begin Score(15,107);move(91);
      if en(52)then T[23]:=2;end else RL(92);
   5:move(87);
   28:case N1 of 56:if T[21]>1 then RL(370);64:RL(335);72,69:RL(391)end;
   33:if N2=64 then
       if Pr=5 then
        if N1=12 then
         begin RL(336);T[21]:=3;DOpen(15);Score(5,106)end
        else RL(137);
   end;

87:case Vb of  { Circular Corridor }
   1,11:door(89,65);
   3:move(88);
   8:move(86);
   28:case N1 of 72:RL(392)end;
   end;

88:case Vb of  { Circular Corridor }
   1,11:door(90,65);
   4:move(87);
   7:move(81);
   28:case N1 of 72:RL(392)end;
   end;

89:case Vb of  { Reactors West }
   2,13:door(87,65);
   3:move(90);
   28:case N1 of 38:RL(414);59:RL(401);128:RS(189)end;
   31:if N1=59 then
       case ScrnSet of
        1:RB2(8,6);   { Orange Crystal }
        2:RB2(10,10); { Green Crystal  }
        3:RB2(12,14); { Yellow Crystal }
        4:begin RB2(14,9);  { Blue Crystal (Cracked) }
           x:=wherex;y:=wherey;gotoxy(40,14);col(25,23);write('LACITIRC');
           gotoxy(x,y);Score(20,108)
          end;
       end;
    44,75:if N1=44 then
           begin RL(402);ScrnSet:=ScrnSet+1;if ScrnSet>4 then ScrnSet:=1;
            for x:=1 to 30 do
             begin i:=random(7000)+999;play(i,i,50);delay(random(15)+5)end
           end else
          if N1 in[38,128]then RL(403);
     42,75:if N1 in[38,128]then RL(403);
   end;

 end {main case}
end; { Room19 }
{----------}
overlay procedure Room20;   { Planetship }
begin
case Prm of
90:case Vb of  { Reactors East }
   2,13:door(88,65);
   4:move(89);
   28:case N1 of 38:RL(393);59:RL(402);128:RS(190)end;
   31:if N1=59 then begin Score(5,109);RB2(9,random(14)+1)end;
   42,44,75:if N1 in[38,128]then RL(403);
   end;

91:case Vb of  { Emergency Override }
   3,13:begin if T[25]>2 then
      begin Col(10,7);RL(424);T[25]:=Null;T[24]:=Null;T[26]:=14;Add(52)end;
      door(86,15);
      if(T[24]>0)and not en(64)then begin T[24]:=Null;T[26]:=14;Add(52)end
     end;
   4,11:RL(92);
   28:case N1 of 37,38,51:RL(393);44:RL(469);59:RL(468);64:RL(335);
       69:if en(51)then RL(426)else if Md=1 then RL(467)else RS(182);
      end;
   31:if N1=59 then RL(468);
   24:if N1=69 then if en(51)then crazy else RL(427);
   75:if N1=69 then if en(51)then crazy else RL(428);
   54:case N1 of
       69:if en(51)then RL(426)else
          if N2 in[0,60]then RL(601)else
          if not(N2 in[10,18,29])then RL(602)else
           begin RS(160);L[91]:=L[91]+[123];L[91]:=L[91]-[44,129];T[23]:=15;
            Add(51)end;
      end;
   42,44:if(N1=69)and not en(51)then RL(470)else
         if N1=44 then begin RL(471);play(20,440,1);play(440,440,500);
          play(440,20,1);end;
   41,88:if N1=69 then if en(51)then crazy else RL(467);
   39:if N1=95 then RL(442);
   49:if N2=123 then
       if Pr=1 then
        if N1=1 then
         if(T[24]>1)and(T[24]<6)then
          begin T[24]:=Null;T[25]:=7;RS(181)end
         else RL(429)
        else RL(425);
   33:if N2=64 then
       if Pr=5 then
        if N1=12 then RL(577);
   end;

92:case Vb of  { Climate Control }
   3,13:door(85,65);
   28,31:case N1 of 59:RS(152);end;
   end;

 end {main case}
end; { Room20 }
{----------}
overlay procedure Room21;   { Planetship }
begin
case Prm of
94:case Vb of  { Maintenance }
   1,13:door(84,65);
   28:case N1 of
       51:RL(489);
       87:begin RL(490);Score(15,110);
           if not en(49)then
            begin Score(10,49);RL(396);L[94]:=L[94]+[26];end
           else if 26 in L[94] then RL(397);
          end;
      end; {case}
   39:begin
       if(30 in NounSet)then
        begin if 2 in L[94] then R[2]:=94;if 26 in L[94] then R[26]:=94;end;
       if(51 in NounSet)then
        begin RL(491);NounSet:=NounSet-[51];
         if not(NounSet=[])then SFlag:=false end
      end;
   end;

97:case Vb of  { Cryogenic Chamber }
   4,11,13:door(93,5);
   28:if N1=69 then RS(193);
   18:begin RS(194);Van(N1)end;
   end;

98:case Vb of  { Identity Booth }
   2,11:begin door(99,0);
      if T[27]>1 then begin Col(10,7);RS(208);delay(999);Blast;DEAD end
      else begin T[27]:=2000;Col(10,7);RL(504);play(22,22,999);RS(210);
            delay(999);Blast;RL(505)end
     end;
   4,13:door(93,5);
   28,31:case N1 of 81,119:if NStr='message' then RL(517)else RB2(13,13);
          59:RL(517)end;
   end;

99:case Vb of  { Security Tunnel #1 }
   1,13:door(98,0);
   2,11:begin Score(15,111);door(100,0)end;
   4:RL(506);
   41,88:if N1=55 then RL(509);
   28:case N1 of 46:RS(216);55:RL(510);88:RL(511)end;
   42,44,75:if N1=46 then begin RL(513);T[27]:=2000;Add(7)end;
   39:if 88 in NounSet then begin RL(513);T[27]:=2000;Add(7)end;
   end;

100:case Vb of  { Security Tunnel #2 }
    1,13:begin door(99,0);Col(10,7);RS(208);delay(999);Blast;DEAD end;
    2,11:begin door(101,0);
       if T[28]>1 then begin Col(10,7);RS(209);delay(999);Blast;DEAD end
       else begin T[28]:=2000;Col(10,7);RL(504);play(22,22,999);RS(211);
             delay(999);Blast;RS(212);PStat:=PStat+[4];T[29]:=14;end;
      end;
    41,88:if N1=55 then RL(512);
    end;

 end {main case}
end; { Room21 }
{----------}
overlay procedure Room22;   { Planetship (Lower Level) }
begin
case Prm of
101:case Vb of  { Security Tunnel #3 }
    1,13:door(100,0);
    2,11:begin Region:=5;door(102,0);Score(20,112);
       if not(20 in Wear)then RL(492)end;
    41,88:if N1=55 then RL(509);
    28:case N1 of 46:RS(216);55:RL(510);88:RL(511)end;
    42,44,75:if N1=46 then begin RL(513);T[28]:=2000;Add(7)end;
    39:if 88 in NounSet then begin RL(513);T[28]:=2000;Add(7)end;
    end;

102:if(Vb in[1..14,16,20..31,33..44,48..64,73..76,83..85,88..94])and
      not(20 in Wear)then RL(491) else
    case Vb of  { North Catwalk }
    1,11,13:begin Region:=Null;Door(101,0);Col(10,7);RS(209);delay(999);
       Blast;DEAD end;
    7:move(103);
    8:move(105);
    24,25,28:case N1 of 34,49:RL(493);
      131:if NStr='catwalk' then RL(494)else begin RS(195);RS(196)end end;
    75,76:if N1=42 then RL(495);
    51,59:if N1 in[42,54,131]then begin RL(496);DEAD;end;
    end;

103:if(Vb in[1..14,16,20..31,33..44,48..64,73..76,83..85,88..94])and
      not(20 in Wear)then RL(491) else
    case Vb of  { East Catwalk }
    6:move(102);
    8:move(104);
    24,25,28:case N1 of 34,49:RL(493);
      131:if NStr='catwalk' then RL(494)else begin RS(195);RS(196)end end;
    75,76:if N1=42 then RL(495);
    51,59:if N1 in[42,54,131]then begin RL(496);DEAD;end;
    end;

104:if(Vb in[1..14,16,20..31,33..44,48..64,73..76,83..85,88..94])and
      not(20 in Wear)then RL(491) else
    case Vb of  { South Catwalk }
    2,13:begin Region:=Null;Door(106,5);Score(20,113)end;
    5:move(103);
    6:move(105);
    24,25,28:case N1 of 34,49:RL(493);
      131:if NStr='catwalk' then RL(494)else begin RS(195);RS(196)end end;
    75,76:if N1=42 then RL(495);
    51,59:if N1 in[42,54,131]then begin RL(496);DEAD;end;
    end;

105:if(Vb in[1..14,16,20..31,33..44,48..64,73..76,83..85,88..94])and
      not(20 in Wear)then RL(491) else
    case Vb of  { West Catwalk }
    5:move(102);
    7:move(104);
    24,25,28:case N1 of 34,49:RL(493);
      131:if NStr='catwalk' then RL(494)else begin RS(195);RS(196)end end;
    75,76:if N1=42 then RL(495);
    51,59:if N1 in[42,54,131]then begin RL(496);DEAD;end;
    end;

 end {main case}
end; { Room22 }
{----------}
overlay procedure Room23;   { Planetship (Lower Level) }
 label JUMP;
begin
case Prm of
106:case Vb of  { Junction }
    1:begin Region:=5;Door(104,5);if not(20 in Wear)then RL(492)end;
    2:RL(328);
    3:door(108,5);
    4,11,13:door(107,20);
    41..44,88:if N1=56 then RL(532);
    end;

107:case Vb of  { Conference Room }
    3,13:door(106,20);
    39:if(30 in NounSet)and(19 in L[107])then R[19]:=107;
    end;

108:case Vb of  { Reactor Regulators }
    4,13:door(106,5);
    41:if N1=55 then
        if not en(65)then
         begin Add(65);L[108]:=L[108]+[40];Score(5,114);
          for x:=22 to 25 do R[x]:=108;RL(519);RL(520);
         end
        else RL(521);
    53:if en(65)then RL(522)else RL(523);
    28,24:case N1 of 55:if en(65)then goto JUMP else RL(523);
         40:JUMP:
           begin RL(525);
            for x:=1 to 25 do if x in Socket then
             if x=22 then writeln('  An ',FN(x),' is in one of the sockets.')
             else writeln('  A ',FN(x),' is in one of the sockets.')
           end;
          end;
    33:if(N2 in[40,55])and en(65)then
        begin i:=0;for x:=1 to 25 do if x in Socket then i:=i+1;
         if i<4 then
          if N1 in Inv then
           if N1 in[1,22..25]then
            begin
             writeln('The ',FN(N1),' fits perfectly in an open socket.');
             Van(N1);Socket:=Socket+[N1];R[N1]:=108;
             i:=0;for x:=1 to 25 do if x in Socket then i:=i+1;
             if(i>3)and(1 in Socket) and not(25 in Socket)then
              begin { ####  You have won the game!!!!!  #### }
               Col(10,7);delay(999);Static;Static;RS(221);Static;Static;
               delay(999);explode(1);sound(20);RS(222);delay(999);RS(223);
               Pause;Bor(0,0);writeln;Score(55,115);
               Add(66);Prm:=109;PStat:=[];PlayerInput(Line);
               Col(10,15);for x:=224 to 229 do RS(x);
               writeln;writeln;Pause;writeln;
               WON;  {  <<<-----  END OF GAME !!! *************}
              end
            end
           else writeln('The ',FN(N1),' won''t fit in any of the sockets.')
          else writeln('First you must have the ',FN(N1),'.')
         else RL(526)
        end;
    end;

 end {main case}
end; { Room23 }
{----------}
{**************************** END OF ROOM ROUTINES **************************}


{$Ia:DEFAULT.pas   <<<<<------  LOADS IN DEFAULT ROUTINES  *******************}


BEGIN { Main Program }
Assign1;Assign2;Assign3;Assign4;Assign5;
Names1;Names2;Names3;
Title;
Init1;Init2;Init3;
Place1;Place2;
Describe(Prm);

repeat

PlayerInput(LINE);
if length(input)>0 then Parser_Syntax(input);
if EFlag=Legal then
 begin
  MoreThanOne;
  if Present then
   if T[2]>1 then
    begin RL(11);Time1;
     case TFlag of 1:Time2A;2:Time2B;3:Time2C;4:Time2D;end end
   else
    begin SFlag:=false; if(Vb=71)and(Prm=55)and not en(35)then Vb:=1;
     case Prm of
       1                          :Room1;
       2,3                        :Room2;
       4..7                       :Room3;
       8..12                      :Room4;
      13..22                      :Room5;
      23..29                      :Room6;
      30..34                      :Room7;
      35..38                      :Room8;
      39..41                      :Room9;
      42..50                      :Room10;
      51..55                      :Room11;
      56                          :Room12;
      57..63                      :Room13;
      64..67,71,72                :Room14;
      68..70                      :Room15;
      73..77                      :Room16;
      78..80                      :Room17;
      81..83,93,95,96             :Room18;
      84..89                      :Room19;
      90..92                      :Room20;
      94,97..100                  :Room21;
      101..105                    :Room22;
      106..108                    :Room23;
     end; { Room Defaults }
     if not SFlag then
      case Vb of
       1..8,30,82,87              :Default0;
       16,17,18                   :Default1;
       9..15,32,35,51,77,79,62    :Default2;
       28,47                      :Default3;
       37,39                      :Default4;
       46,64                      :Default5;
       66..69,71                  :Default6;
       31,65,75,80,81,83,84,93,95 :Default7;
       41,50,88                   :Default8;
       20,22,24,26,70,76          :Default9;
       33                         :Default10;
       42,44,73,86,89,90,94       :Default11;
       48,54                      :Default12;
       19,53,56,72,74,78,91       :Default13;
       21,25,49,59,92             :Default14
      end;
     if en(128)then DEAD;Min(128);
     if not(Vb in[77..79,82,86,87,95])then
      begin Time1;case TFlag of 1:Time2A;2:Time2B;3:Time2C;4:Time2D;end end;
    end;
 end;

until false;
END. { ADGAME2 (Supernova) }
