program MakeData;

{ Data maker,
  easily convert thea PCX graphical file
  into a Turbo Pascal file with constants
  for use with my game called UrthWurm

  BdR 2002}

uses smallcrt, pcx_show, dos;

Const
  BlackPixel = 3;
  WhitePixel = 241;

  FontString = ' !"#$%&''()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~c);(Do|H';

  Scroll01 = 'Hi there!  welcome to this ''hidden'' scroll-text. I hope you enjoy ';
  Scroll02 = 'this little game. It''s a quick remake of a game called SFCave. ';
  Scroll03 = 'SFCave was created by Sunflat and was released for Windows 3.11 ';
  Scroll04 = 'and later for PalmOS. Urthwurm was made using Turbo Pascal 7.0 ';
  Scroll05 = 're-using some routines i made for another game I''m still working on. ';
  Scroll06 = 'So.. still reading eh? Why don''t you keep your eyes on the game!  ';
  Scroll07 = 'btw you can enter smilies on the hi-score table by typing :) or 8) or 8> etc. Try it!  ';
  Scroll08 = 'This is probably one of the LAST games ever written for MS-DOS. ';
  Scroll09 = 'Anyway, maybe i''ll write a *real* game someday  until then.. greets!';
             {1234567890123456789012345678901234567890}
  Scroll10 = '                                        Bas de Reuver, june 2002';
  Scroll11 = '              >> WARP >>                ';

  VgaSeg = $A000; {Offset to VGA memory segment}

var
  PasFile : Text;
  CurrentLetter, i : Byte;

  FlushKey : Char;

  SimulateFile : array [0..2048] of byte;
  SimulateOffsets : array [0..(32+32+30)] of word;

Procedure GetColor(color : Byte ; var red, green, blue : byte); { Getcolor }
Begin
   Port[$3c7] := Color;    { This procedure reads the values of    }
   Red   := Port[$3c9];    { Red, Green & Blue for a certain color }
   Green := Port[$3c9];    { from the [$3c9] port.                 }
   Blue  := Port[$3c9];
End;

procedure WriteHeaderComment(info : String);
var
  i : Integer;
  strBar : String;
begin
  { make a '----' which is as long as the Info-string }
  strBar := '';
  for i := 1 to Length(Info)+6 do
    strBar := strBar + '-';
  { write comment to file }
  WriteLn(PasFile, '{ ' + strBar + ' }');
  WriteLn(PasFile, '{ -- ' + Info + ' -- }');
  WriteLn(PasFile, '{ ' + strBar + ' }');
end;

procedure WriteLetterToFile(x_pos, y_pos : Word);
{ all letters are 8x8 pixels }
var
  x, y, readPixel, BitMask, CurrentBit : Byte;
  strLine, strTemp : String;
begin

  CurrentBit := 0;
  BitMask := 0;
  strLine := '';

  for y := 0 to 7 do
  begin
    BitMask := 0;
    for x := 0 to 7 do
    begin
      readPixel := mem[VgaSeg:((y_pos+y)*320)+(x_pos+x)]; {read a pixel from screen}
      {not black, then SET a bit of bitmask (to binairy 1)}
      if (readPixel <> 0) then
      begin
        BitMask := BitMask + ($80 Shr x);
        mem[VgaSeg:((y+y_pos)*320)+(x+x_pos)] := WhitePixel; {fill up with colour to give feedback of what is done}
      end
      else
        mem[VgaSeg:((y+y_pos)*320)+(x+x_pos)] := BlackPixel; {fill up with colour to give feedback of what is done}
    end;
    { one row of 8 pixels is coded to 1 bitmapped byte }
    Str(BitMask:3, strTemp);
    if (y > 0) then
      strLine := strLine + ', ';
    strLine := strLine + strTemp;
  end;
  { write line to file }
  strTemp := Copy(FontString, CurrentLetter+1, 1);

  strLine := '    db ' + strLine + ' { ' + strTemp + ' }';
  WriteLn(PasFile, strLine);
  { keep track of which letter }
  CurrentLetter := CurrentLetter + 1;
end;

procedure WritePatternToFile(x_pos, y_pos : Word);
{ all patterns are 16x16 pixels }
var
  x, y, readPixel : Byte;
  strLine, strTemp : String;
begin

  strLine := '';

  for x := 0 to 15 do
  begin
    strLine := '';
    for y := 0 to 15 do
    begin
      readPixel := mem[VgaSeg:((y_pos+y)*320)+(x_pos+x)]; {read a pixel from screen}
      {not black, then SET a bit of bitmask (to binairy 1)}
      mem[VgaSeg:((y_pos+y)*320)+(x_pos+x)] := 235-readPixel; {fill up with colour to give feedback of what is done}
      { make it pascal code.. }
      Str(readPixel:3, strTemp);
      if (y <> 0) then strLine := strLine + ',';;
      strLine := strLine + strTemp;
    end;
    { write line to file }
    strLine := '    db ' + strLine;
    if (x = 0) then strLine := strLine + ' { <-- }';
    WriteLn(PasFile, strLine);
  end;

end;

procedure WriteGraphicToFile(x_pos, y_pos, x_size, y_size : Word);
{ graphics sprites.. }
var
  x, y, Counter : Word;
  readPixel : Byte;
  strLine, strTemp : String;
begin

  Counter := (x_size+1) * (y_size+1);
  Str(Counter, strTemp);
  strLine := '... : Array[0..' + strTemp + '] of Byte = (';
  WriteLn(PasFile, strLine);
  WriteLn(PasFile, '  (');

  strLine := '';
  Counter := 0;

  for y := 0 to y_size do
    for x := 0 to x_size do
    begin
      readPixel := mem[VgaSeg:((y_pos+y)*320)+(x_pos+x)]; {read a pixel from screen}
      {not black, then SET a bit of bitmask (to binairy 1)}
      mem[VgaSeg:((y_pos+y)*320)+(x_pos+x)] := 235-readPixel; {fill up with colour to give feedback of what is done}
      { make it pascal code.. }
      Str(readPixel:3, strTemp);
      strLine := strLine + strTemp + ',';

      { full line.. ?}
      Inc(Counter);
      If (Counter = 16) Then
      begin
        Counter := 0;
        { write line to file }
        strLine := '    ' + strLine;
        WriteLn(PasFile, strLine);
        strLine := '';
      end;
    end;

  { could be left over pixels.. counter <> 0 }
  if (counter <> 0) then
  begin
    strLine := '    ' + strLine;
    WriteLn(PasFile, strLine);
  end;

  WriteLn(PasFile, '  );');

end;


procedure WritePaletteToFile;
var
  i, j, r, g, b : Byte;
  strLine, strR, strG, strB : String;
begin
  for i := 0 to 63 do
  begin
    strLine := '    ';
    for j := 0 to 3 do
    begin
      GetColor(((i*4)+j), r, g, b);
      Str(r:3, strR);
      Str(g:3, strG);
      Str(b:3, strB);
      strLine := strLine + '(' + strR +','+ strG +','+ strB + '), ';
    end;
    WriteLn(PasFile, strLine);
  end;
end;

procedure WriteScrollTextToFile;
var
  i, j, asciicode : byte;
  counter : word;
  strTemp, strLine, strNumber : String;
begin
  counter := 0;

  for i := 1 to 11 do
  begin
    { get next scroll part }
    case i of
     1: strTemp := Scroll01;
     2: strTemp := Scroll02;
     3: strTemp := Scroll03;
     4: strTemp := Scroll04;
     5: strTemp := Scroll05;
     6: strTemp := Scroll06;
     7: strTemp := Scroll07;
     8: strTemp := Scroll08;
     9: strTemp := Scroll09;
    10: strTemp := Scroll10;
    11: strTemp := Scroll11;
    end; {case}

    { build string }
    strLine :='';
    for j := 1 to length(strTemp) do
    begin
      asciicode := Ord(strTemp[j])-32;
      Str(asciicode:3, strNumber);
      strLine := strLine + strNumber + ', ';
      Inc(counter);
      if ((counter mod 16) = 0) then
      begin
        { dump to file}
        WriteLn(PasFile, strLine);
        strLine := '';
      end;
    end; {for j}
    { left over }
    if (strLine <> '') then
      { dump to file}
      WriteLn(PasFile, strLine);
  end; {for i}

  Str(counter, strNumber);
  strLine := '{ number of characters is ' + strNumber + ' }';
  WriteLn(PasFile, strLine);

end;


{ ---- MAIN PROGRAM ---- }
BEGIN
  {load the PCX file, all procedures/function taken from PCX_SHOW}
  assign(pcxfile, '8bit.pcx');
  reset(pcxfile,1);

  if ioresult <> 0 then error(paramstr(1)+' not found.');
  if not validpcx then error('Not a 256 color PCX file.');
  if not validpal then error('Palette corrupt.');
  setvideo($13);
  setpal;
  unpack;
  {PCX_SHOW end..}

  {BdR: my code starts here.. }
  CurrentLetter := 0;

  Assign(PasFile, 'grafdata.pas');
  Rewrite(PasFile);{rewrite: file doesnot exsist yet or has to be over written}
{  Reset(PasFile);

  {show result to check if green squares are somewhat correct..}
  repeat until keypressed;
  FlushKey := readkey ;

  { ---- the font ---- }
  WriteHeaderComment('font 8x8 pixels bitmapped');

  { first row }
  For i := 0 to 32 do
    WriteLetterToFile(i*8, 24);

  { second row }
  For i := 0 to 31 do
    WriteLetterToFile(i*8, 32);

  { third row }
  For i := 0 to 29 do
    WriteLetterToFile(i*8, 40);

  { fourth row, smilies }
  For i := 0 to 9 do
    WriteLetterToFile(i*8, 48);

  { ---- the patterns ---- }
  WriteHeaderComment('pattern 16x16 pixels bytemapped');
  for i := 0 to 9 do
    WritePatternToFile((i*17)+28, 73);

  { ---- the palette ---- }
  WriteHeaderComment('the palette');
  WritePaletteToFile;

  { ---- the skull sprite ---- }
  WriteHeaderComment('the skull sprite');
  WriteGraphicToFile(3, 74, 22, 14);

  { ---- the logo ---- }
  WriteHeaderComment('the logo');
  WriteGraphicToFile(4, 134, 296, 51);

  { ---- the scroll text ---- }
  WriteHeaderComment('the scroll text');
  WriteScrollTextToFile;


  {close file}
  Close(PasFile);

  {show result to check if green squares are somewhat correct..}
  repeat until keypressed;
  FlushKey := readkey;


  {show result to check if green squares are somewhat correct..}
  repeat until keypressed;
  FlushKey := readkey;

  {BdR: ..and ends here}

  {free PCX file, also taken from PCX_SHOW}
  setvideo(3);
{  close(pcxfile);}
  {PCX_SHOW end..}

END.
