/**
*	(c) Copyright 2003,2004 Point Mad, Lukas Lipka. All rights reserved.
*
*	FILE:			rect.c
*
*	PROJECT:		Phoenix engine - Core
*
*	DESCRIPTION:	Metric functions (rect and point calculations). Version 2
*
*	CONTRIBUTORS:
*					Lukas Lipka
*         Etelain Julien
*
*	TODO:			@
*
*	BUG:			@
*
*	MISTAKE:		@
*
*	IDEA:			@
*/

#include "kernel.h"
#include <stdio.h>
#include <stdarg.h>

/**
*	Point functions
*/

/**
*	NAME: PointAssign
*	DESCRIPTION: Creates a point in the specified x and y coordinates
*					and returns them in a structure poinitng to one point.
*	RETURN: Pointer to the point
*/
void PointAssign( TPoint *p, l_int x, l_int y )
{
	p->x = x;
 	p->y = y;
}

/**
*	NAME: PointInRect
*	DESCRIPTION: Calculates wherever a point is located in the specified
*					rectangle.
*	RETURN: true if the rect contains the point, otherwise false
*/
l_bool PointInRect ( TPoint p, TRect r )
{
	return (p.x >= r.a.x && p.y >= r.a.y && p.x <= r.b.x && p.y <= r.b.y);
}

/**
*	Rect functions
*/

/**
*	NAME: RectAssign
*	DESCRIPTION: Assigns the specified coordinates to a rectangle structure.
*	RETURN: Pointer to the rectangle
*/
void RectAssign( TRect *r, l_int ax, l_int ay, l_int bx, l_int by )
{
	r->a.x = ax;
	r->a.y = ay;
	r->b.x = bx;
	r->b.y = by;
}


/**
*	NAME: RectMove
*	DESCRIPTION: Moves a rectangle to the specified point
*/
void RectMove ( TRect *d, TRect r, TPoint p)
{
	*d = r;

	d->a.x += p.x;
	d->a.y += p.y;
	d->b.x += p.x;
	d->b.y += p.y;
}

/**
*	NAME: RectUnMove
*	DESCRIPTION: Moves a rectangle back from a prevoius call of RectMove
*/
void RectUnMove ( TRect *d, TRect r, TPoint p)
{
	*d = r;

	d->a.x -= p.x;
	d->a.y -= p.y;
	d->b.x -= p.x;
	d->b.y -= p.y;
}

/**
*	Size functions for rect
*/

/**
*	NAME: GetXDelta
*	DESCRIPTION: Calculates the position of the x coordinate of the rectangle
*	RETURN: x coordinate
*/
l_int GetXDelta(TRect r)
{
	return r.b.x-r.a.x;
}

/**
*	NAME: GetYDelta
*	DESCRIPTION: Calculates the position of the y coordinate of the rectangle
*	RETURN: y coordinate
*/
l_int GetYDelta(TRect r)
{
	return r.b.y-r.a.y;
}

/**
*	NAME: GetWidth
*	DESCRIPTION: Calculates the widht of the rectangle
*	RETURN: width of rectangle
*/
l_int GetWidth(TRect r)
{
	return r.b.x-r.a.x+1;
}

/**
*	NAME: GetHeight
*	DESCRIPTION: Calculates the height of the rectangle
*	RETURN: height of rectangle
*/
l_int GetHeight(TRect r)
{
	return r.b.y-r.a.y+1;
}

l_bool  RectOverlay ( TRect r, TRect d )
{
	//if ( r.a.x > d.b.x || r.a.y > d.b.y || r.b.x < d.a.x || r.b.y < d.a.y )
	//	return false;

	return _RectOverlay(r, d);
}

void  RectIntersept ( TRect *i , TRect r, TRect d )
{
	i->b.x = max(r.a.x, min(r.b.x, d.b.x));
	i->b.y = max(r.a.y, min(r.b.y, d.b.y));
	i->a.x = min(r.b.x, max(r.a.x, d.a.x));
	i->a.y = min(r.b.y, max(r.a.y, d.a.y));
}

PList NewListFromRect ( TRect t )
{
	PList List = NewList();
	PRect r   = (PRect)malloc(sizeof(TRect));

	r->a.x = t.a.x; r->a.y = t.a.y;
	r->b.x = t.b.x; r->b.y = t.b.y;

	ListAdd(List,NULL,r,free);

	return List;
}

void AddRectInList ( PList List, int ax, int ay, int bx, int by )
{
	if ( ax <= bx && ay <= by )
	{
		PRect r = (PRect)malloc(sizeof(TRect));
		r->a.x = ax; r->a.y = ay;
		r->b.x = bx; r->b.y = by;
		ListAdd(List,NULL,r,free);
	}
}

void RemoveZoneInListItem ( PList List, PListItem A, TRect b )
{
	TRect a = *(PRect)A->Data;

	if ( _RectOverlay (a,b) )
	{
		if ( a.a.x < b.a.x )
			AddRectInList(List,a.a.x,a.a.y,b.a.x-1,a.b.y);
		if ( a.a.y < b.a.y )
			AddRectInList(List,max(b.a.x,a.a.x),a.a.y,a.b.x,b.a.y-1);
		if ( a.b.x > b.b.x )
			AddRectInList(List,b.b.x+1,max(a.a.y,b.a.y),a.b.x,min(b.b.y,a.b.y));
		if ( a.b.y > b.b.y )
			AddRectInList(List,max(a.a.x,b.a.x),b.b.y+1,a.b.x,a.b.y);

		ListRemoveItem(List,A);
	}
}

void RemoveZoneInList ( PList l, TRect r )
{
	PListItem a, b, t;
	int n = 0;

	if ( l->Last )
	{
		a = b = l->Last;

		do
		{
			n++;
			a = a->Next;
		}
		while ( a != b );

		do
		{
			t = a->Next;
			RemoveZoneInListItem(l,a,r);
			a = t;
			n--;
		}
		while ( n );
	}
}
