; E100PKT, packet driver for DOS
; Copyright (C) 2018, Seth Simon (sethsimon@sdf.org)
;
; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see
; <https://www.gnu.org/licenses/>.

f_send_pkt:
    ; DS:SI = buffer
    ; CX = length
    cmp     cx, 1519    ; CF=1 if it's small enough
    cmc
    mov     bl, ERROR_CANT_SEND
    jc      .done

    ; Flexible mode interfered with the RU somehow. I could
    ; send and receive, but not too close temporally.
    ;
    ; I tried sharing the RU's memory, but that interfered with it too.
    ;
    ; I can't easily use the caller's memory because TCBs must be
    ; word-aligned, plus the obvious dangers.
    ;
    ; So I'm forced to use simplified mode and use an extra 1.5 KB
    ; of resident memory.
    push    eax
    push    cx
    push    si
    push    es
    push    di

    push    cs
    pop     es

    mov     di, tcb + 16
    mov     bx, tcb
    mov     word [es:di - 4], cx
    rep     movsb
    mov     word [es:bx], cx    ; Rezero the status
    xchg    ax, bx
    cwde                        ; EAX = tcb (since tcb < 0x8000)

    mov     bx, 0x10            ; CU Start
    call    toggle_irq_mask

    call    scb_command
    xchg    ax, si
    inc     si
.wait:              ; Wait until the adapter writes to the status
    cs      lodsb
    dec     si
    test    al, al
    jz      .wait

    call    toggle_irq_mask

    and     al, 0b1011_0000  ; Isolate Complete|OK|Underrun
    xor     al, 0b1010_0000  ; 0 if no errors
    cmp     al, 1
    cmc
    mov     bl, ERROR_CANT_SEND

    pop     di
    pop     es
    pop     si
    pop     cx
    pop     eax
.done:
    ret

