; E100PKT, packet driver for DOS
; Copyright (C) 2018, Seth Simon (sethsimon@sdf.org)
;
; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see
; <https://www.gnu.org/licenses/>.

;====================
;=======      =======
;       HW_INT
;=======      =======
;====================

hw_int:
    push    ax
    push    dx

    ; For some reason, it gets zeroed if I don't read it before
    ; acknowledging the interrupt.
    mov     dx, word [cs:csr_io_bar]
    inc     dx          ; SCB Interrupt Acknowledge Byte
    in      al, dx
    push    ax
    out     dx, al      ; Acknowledge only the interrupts
                        ; that actually occurred

    ; Let other hardware (but not the E100) raise interrupts.
    call    toggle_irq_mask
    mov     dx, word [cs:pic_port]
    dec     dx
    mov     al, 0x20
    out     dx, al      ; The actual IRQ (could be on the slave PIC)
    out     0x20, al    ; Exact same thing again, OR acknowledge IRQ 2

    sti                 ; Nonzero flags (assumed by call_receiver)
    cld

    pop     ax
    test    al, 1 << 6  ; FR?
    jz      .handled_fr
    push    ds
    push    es
    pusha
    push    cs
    pop     es
    push    cs
    pop     ds
    call    handle_fr
    call    reset_rfds
    popa
    pop     es
    pop     ds
.handled_fr:
    pop     dx
    pop     ax
    cli
    call    toggle_irq_mask
    iret

