; this file is part of ethflop, a floppy drive emulator over Ethernet
; Copyright (C) 2019-2024 Mateusz Viste
;
; contains STRINGS used by the transient loader
;
; MIT license


; ============================================================================
; === STRINGS USED BY THE TRANSIENT LOADER ===================================
; ============================================================================
; (no need to declare a .data section, tiny model imples DS == CS anyway)

; NOTE: part of the help screen is stored in STR_512.ASM

STR_HLP1 db "ethflop nSZ DSKNAME creates a new virtual floppy DSKNAME, SZ kB big", 13, 10,\
            "                    run 'ethflop n' for the list of available formats", 13, 10,\
            "ethflop l           displays the list of available virt. floppies", 13, 10,\
            "ethflop d DISKNAME  DELETES virt. floppy named DISKNAME - BE CAREFUL!", 13, 10,\
            "ethflop s           displays current status of the ethflop TSR", 13, 10,\
            "ethflop u           unloads the ethflop TSR", 13, 10,\
            "ethflop !           displays max stack usage since installed (see ETHFLOP.TXT)", 13, 10, 10,\
            "NOTES:", 13, 10,\
            " * Disk names must be 1 to 8 characters long. Only A-Z, 0-9 and '_-' allowed.", 13, 10,\
            " * ethflop requires the presence of an ethflopd server on the local network.", 13, 10,\
            " $" ; the space here is not meaningless - it enforces an extra LF under FreeDOS
STR_LOADED db "ethflop loaded, stack size = 0x$"
STR_ALREADYLOADED db "ERROR: ethflop is already installed",13,10,"$"
STR_NOTINSTALLED db "ERROR: ethflop is not installed or has been overloaded by another ISR",13,10,"$"
STR_FAILEDFREETSR db "ERROR: Failed to free TSR's memory segment",13,10,"$"
STR_UNINSTALLED db "ethflop has been uninstalled",13,10,"$"
STR_PKTDRVRNOTFOUND db "ERROR: no packet driver found",13,10,"$"
STR_PKTDRVRINITFAIL db "ERROR: packet driver initialization failed",13,10,"$"
STR_NO2F db "NOTE: no INT 2Fh,AH=13h support detected",13,10,"$"
STR_SERVERUNREACHABLE db "ERROR: server unreachable",13,10,"$"
STR_GHOSTERROR db "ERROR: drive B: appears to be a phantom drive",13,10,"$"
STR_BADSTACK db "!!! STACK OVERFLOW DETECTED !!!",13,10,"$"
STR_BADSTACKPTR_TOOLO db "BAD STACK PTR: COLLIDES WITH TSR AREA$"
STR_BADSTACKPTR_TOOHI db "BAD STACK PTR: OUT OF PROGRAM'S SPACE$"
STR_STKUSAGE db "max. stack usage so far: 0x$"
STR_BYTES db " bytes", 13, 10, "$"
STR_CRLF db 13, 10, "$"
