/* domain name server protocol
 *
 * This portion of the code needs some major work.  I ported it (read STOLE IT)
 * from NCSA and lost about half the code somewhere in the process.
 *
 * Note, this is a user level process.  We include <tcp.h> not <wattcp.h>
 *
 *  ?.? : Jul 24, 1997 - MX request support for FDSMTPOP have been added --YS
 *
 *  0.2 : Apr 24, 1991 - use substring portions of domain
 *  0.1 : Mar 18, 1991 - improved the trailing domain list
 *  0.0 : Feb 19, 1991 - pirated by Erick Engelke
 * -1.0 :              - NCSA code
 */

/*#include <copyright.h>*/
#include <stdio.h>
#include <string.h>
#include "tcp.h"
#include "dns.h"

/*
 * #include <elib.h>
 */

/* These next 'constants' are loaded from WATTCP.CFG file */

char *def_domain;
char *loc_domain;	/* current subname to be used by the domain system */

longword def_nameservers[ MAX_NAMESERVERS ];
int _last_nameserver;
word _domaintimeout = 0;

static longword timeoutwhen;

/*
longword def_nameserver;
longword def2_nameserver;
*/

static tcp_Socket *dom_sock;

/*static */
struct useek *question = NULL;

int qsize;

static int qinit()
{
    qsize = sizeof(struct useek);  /* For TCP mode secific stuff --YS */
    if(!question)
      {
        if((question = (struct useek*)malloc(qsize)) == NULL)
          return -1;
      }
    question->h.flags = intel16(DRD);
    question->h.qdcount = intel16(1);
    question->h.ancount = 0;
    question->h.nscount = 0;
    question->h.arcount = 0;
    return 0;
}

/*********************************************************************/
/*  packdom
*   pack a regular text string into a packed domain name, suitable
*   for the name server.
*
*   returns length
*/
static packdom(dst,src)
char *src,*dst;
{
    char *p,*q,*savedst;
    int i,dotflag,defflag;

    p = src;
    dotflag = defflag = 0;
    savedst = dst;

    do {			/* copy whole string */
	*dst = 0;
	q = dst + 1;
	while (*p && (*p != '.'))
	    *q++ = *p++;

	i = p - src;
	if (i > 0x3f)
	    return(-1);
	*dst = i;
	*q = 0;

	if (*p) {					/* update pointers */
	    dotflag = 1;
	    src = ++p;
	    dst = q;
	}
	else if (!dotflag && !defflag && loc_domain) {
	    p = loc_domain;		/* continue packing with default */
	    defflag = 1;
	    src = p;
	    dst = q;
	}
    }
    while (*p);
    q++;
    return(q-savedst);			/* length of packed string */
}

/*********************************************************************/
/*  unpackdom
*  Unpack a compressed domain name that we have received from another
*  host.  Handles pointers to continuation domain names -- buf is used
*  as the base for the offset of any pointer which is present.
*  returns the number of bytes at src which should be skipped over.
*  Includes the NULL terminator in its length count.
*/
int unpackdom(dst,src,buf)
char *src,*dst,buf[];
{
    int i,j,retval;
    char *savesrc;

    savesrc = src;
    retval = 0;

    while (*src) {
	j = *src;

	while ((j & 0xC0) == 0xC0) {
	    if (!retval)
		retval = src-savesrc+2;
	    src++;
	    src = &buf[(j & 0x3f)*256+*src];		/* pointer dereference */
	    j = *src;
	}

	src++;
	for (i=0; i < (j & 0x3f) ; i++)
	    *dst++ = *src++;

	*dst++ = '.';
    }

    *(--dst) = 0;			/* add terminator */
    src++;					/* account for terminator on src */

    if (!retval)
	retval = src-savesrc;

    return(retval);
}

/*********************************************************************/
/*  sendom
*   put together a domain lookup packet and send it
*   uses port 53
*	num is used as identifier
*/
static sendom(s,towho,num,mode)
char *s;
longword towho;
word num;
int mode;       /* YS: 0 - A/UDP, 1 - A/TCP, 2 - MX/UDP, 3 - MX/TCP */
{
    word i,ulen,status,iulen;
    byte *psave,*p;

    psave = (byte*)&(question->x);
    i = packdom(&(question->x),s);

    p = &(question->x[i]);
    *p++ = 0;				   /* high byte of qtype */
    *p++ = ((mode & 2)? DTYPEMX : DTYPEA); /* number is < 256, so we know high byte=0 */
    *p++ = 0;				   /* high byte of qclass */
    *p++ = DIN;				   /* qtype is < 256 */

    question->h.ident = intel16(num);
    ulen = sizeof(struct dhead)+(p-psave);

/*    sock_mode(dom_sock, TCP_MODE_BINARY | TCP_MODE_NONAGLE);*/
    if(mode & 1)
         tcp_open( dom_sock, 997, towho, 53, NULL );    /* divide err */
    else udp_open( dom_sock, 997, towho, 53, NULL );    /* divide err */
    sock_wait_established(dom_sock, sock_delay, NULL, &status);
    /*sock_tick(dom_sock, &status);*/
    if(mode & 1)
      {
        iulen = intel16(ulen);
        sock_write( dom_sock, (byte *) &iulen,   2);
      }
    sock_write( dom_sock, (byte *) question, ulen);
    return( ulen);
 sock_err: return 0;
}

int countpaths(pathstring)
char *pathstring;
{
    int     count = 0;
    char    *p;

    for(p=pathstring; (*p != 0) || (*(p+1) != 0); p++) {
	if(*p == 0)
	    count++;
    }
    return(++count);
}

static char *getpath(pathstring,whichone)
char *pathstring;            /* the path list to search      */
int   whichone;               /* which path to get, starts at 1 */
{
    char    *retval;

    if(whichone > countpaths(pathstring))
	return(NULL);
    whichone--;
    for(retval = pathstring;whichone ; retval++ ) {
	if(*retval == 0)
	    whichone--;
    }
    return(retval);
}

/*********************************************************************/
/*  ddextract
*   extract the ip number from a response message.
*   returns the appropriate status code and if the ip number is available,
*   copies it into mip
*/
static longword ddextract(qp,mip)
struct useek *qp;
unsigned char *mip;
{
    word i,j,nans,rcode;
    struct rrpart *rrp;
    byte *p,space[DOMSIZE];

    nans = intel16(qp->h.ancount);		/* number of answers */
    rcode = DRCODE & intel16(qp->h.flags);	/* return code for this message*/
    if (rcode > 0)
	return(rcode);

    if (nans > 0 &&								/* at least one answer */
    (intel16(qp->h.flags) & DQR)) {	/* response flag is set */
    p = (byte *)&qp->x;                 /* where question starts */
	i = unpackdom(space,p,qp);	/* unpack question name */
	/*  spec defines name then  QTYPE + QCLASS = 4 bytes */
	p += i+4;
/*
 *  at this point, there may be several answers.  We will take the first
 *  one which has an IP number.  There may be other types of answers that
 *  we want to support later.
 */
	while (nans-- > 0) {				/* look at each answer */
	    i = unpackdom(space,p,qp);			/* answer name to unpack */
	    /*			n_puts(space);*/
	    p += i;								/* account for string */
	    rrp = (struct rrpart *)p;			/* resource record here */
 /*
  *  check things which might not align on 68000 chip one byte at a time
  */
	    if (!*p && *(p+1) == DTYPEA && /* correct type and class */
	    !*(p+2) && *(p+3) == DIN) {
		movmem(rrp->rdata,mip,4);	/* save IP # 		*/
		return(0);						/* successful return */
	    }
	    movmem(&rrp->rdlength,&j,2);	/* 68000 alignment */
	    p += 10+intel16(j);				/* length of rest of RR */
	}
    }

    return(-1);						/* generic failed to parse */
}


struct mxrr *getmxanswer(qp, anum)
struct useek *qp;
int anum;
{
     int i, j;
     struct rrpart *rrp;
     byte *p, space[DOMSIZE];   
     if(++anum > intel16(qp->h.ancount)) return NULL;
                                          /* At 1st - skip question */
     p = (byte *)&qp->x;                 /* where question starts */
	i = unpackdom(space,p,qp);	/* unpack question name */
	/*  spec defines name then  QTYPE + QCLASS = 4 bytes */
	p += i;
	if (*p || *(p+1) != DTYPEMX || /* correct type and class */
	    *(p+2) || *(p+3) != DIN) return NULL;
	p += 4;
     /* Now skip 1st anum answers */
     for(j = 0; j < anum;)
       {
	    i = unpackdom(space,p,qp);
	    p += i;								/* account for string */
	    rrp = (struct rrpart *)p;	     /*  resource record here  */
	    if (!*p && *(p+1) == DTYPEMX && /* correct type and class */
	    !*(p+2) && *(p+3) == DIN) j++;
	    p += (10 + (j < anum ? intel16(rrp->rdlength) : 0));
       }
     return (struct mxrr*) p;
}

static longword mxtract(qp, qplen)
struct useek *qp;
unsigned short qplen;
{
  int errcode;
  
  if(!(intel16(qp -> h.flags) & DQR)) return 0;
  if(((errcode = intel16(qp -> h.flags) & DRCODE) != 0)) return /*-1*/ 0;
/*
        {
         if(errcode == DRNAME) return 0;
         else return -1;
        }
*/

#if 0
{ /* DUMP! */
/**/
 int i,j;
 unsigned char b[17];
 putchar('\n');
 for(i=0;i<=qplen/16;i++)
   {
     for(j=0;j<16;j++)
        {
          b[j] = ((unsigned char*)qp)[i*16+j];
          printf("%2.2x ",b[j]);
        }
     printf(" | ");
     for(j=0;j<16;j++) putchar(b[j] < 0x20 ? '.' : b[j]);
     putchar('\n');
   }
/**/
}
#endif

  return 1;

}

longword getmxip(qp, dom)
struct useek *qp;
char *dom;
{
     int i, j, total;
     struct rrpart *rrp;
     byte *p, space[DOMSIZE];   
     total = intel16(qp->h.ancount) + 
             intel16(qp->h.nscount) + 
             intel16(qp->h.arcount) ;
                                          /* At 1st - skip question */
     p = (byte *)&qp->x;                 /* where question starts */
	i = unpackdom(space,p,qp);	/* unpack question name */
	/*  spec defines name then  QTYPE + QCLASS = 4 bytes */
	p += i + 4;

     for(j = 0; j < total; j++)
       {
	    int flg = ((((char*)dom - (char*)qp) | 0xc000) == intel16(*(word*)p));
            i = unpackdom(space,p,qp);
	    p += i;								/* account for string */
	    rrp = (struct rrpart *)p;	     /*  resource record here  */
	    if (!*p && *(p+1) == DTYPEA && /* correct type and class */
	    !*(p+2) && *(p+3) == DIN && flg)
              return intel(*(longword*)(p + 10));
	    else p += (10 + intel16(rrp->rdlength));
       }
     unpackdom(space,dom,qp);
     {
       int c = strlen(space);
       if(c && space[c - 1] != '.')
         space[c] = '.', space[c + 1] = '\0';
     }
     return resolve(space);
}


word preference;

longword procmxlist(domname, u, minpref,log)
char *domname;
struct useek *u;
word minpref;
FILE *log;
          { 
            longword addr = 0;
            char buff[DOMSIZE];
            word wpref;
            char *prefdom = NULL;
            int j;
            if(u)
              {
                preference = (word) -1;
                for(j = 0; j < intel16(u -> h.ancount); j++)
                 {
                   struct mxrr *mxp = getmxanswer(u, j);
                   if(mxp)
                     {
                       wpref = intel16(mxp -> preference);
                       if(wpref > minpref && wpref < preference)
                         {
                           preference = wpref;
                           prefdom = (char*) (mxp -> mx);
                         }
                     }
                 }
              }
            if(preference == (word) -1) return 0;
            addr = getmxip(u, prefdom);
            buff[0] = '\0';
            unpackdom(buff, prefdom, (char*) u);
            if(addr && log)
              {
                fprintf(log," DNS> %s MX %d %s ", domname, preference, buff);
                fprintf(log,"%u.%u.%u.%u\n", ((unsigned char*) &addr)[3],
                                        ((unsigned char*) &addr)[2],
                                        ((unsigned char*) &addr)[1],
                                        ((unsigned char*) &addr)[0]);
              }
            return addr;
          }

/*********************************************************************/
/*  getdomain
*   Look at the results to see if our DOMAIN request is ready.
*   It may be a timeout, which requires another query.
*/

static longword udpdom(mode)
int mode;
{
    int i,uret;
    unsigned short iulen = qsize;
    longword desired;

    if(mode & 1)
      {
        if((sock_fastread(dom_sock, (byte *) &iulen, 2)) != 2) return -1;
        iulen = intel16(iulen);
      }
    if((question = (struct useek *) realloc(question, iulen)) == NULL) return -1;
    qsize = iulen;
    uret = sock_fastread(dom_sock, (byte*) question, iulen);
#if 0
    do {
         int Q_sz = qsize, uread;
         uret = 0;

         uread = sock_fastread(dom_sock, (byte *) question + uret, Q_sz - uret);
         if((mode & 1) && ((iulen = iulen - uret) != NULL))
           {
	      if(!(Q_sz - uret))
                {
                 byte *q;
                 if((q = (byte*)realloc(question, Q_sz + qsize)) == NULL) return -1;
                 question = (struct useek*)q; Q_sz += qsize;
                }
              uret += uread;
           }
       }
    while((mode & 1) && ((iulen = iulen - uret) != NULL));
#endif
    sock_close(dom_sock);

    /* this does not happen */
    if (uret < 0) {
    /*		netputevent(USERCLASS,DOMFAIL,-1);  */
                /*return(-1);*/
    }

 /* num = intel16(question->h.ident); */     /* get machine number */
/*
 *  check to see if the necessary information was in the UDP response
 */
    /* At first - maybe this is MX list --YS */
    if(mode & 2) 
      {
	        return mxtract(question,iulen);
      }

    i = ddextract(question, &desired);
    switch (i) {
        	case 3:	return(0);		/* name does not exist */
        	case 0: return(intel(desired)); /* we found the IP number */
        	case -1:return( 0 );		/* strange return code from ddextract */
        	default:return( 0 );            /* dunno */
    }
}


/**************************************************************************/
/*  Sdomain
*   DOMAIN based name lookup
*   query a domain name server to get an IP number
*	Returns the machine number of the machine record for future reference.
*   Events generated will have this number tagged with them.
*   Returns various negative numbers on error conditions.
*
*   if adddom is nonzero, add default domain
*/
static longword Sdomain(mname, adddom, nameserver, timedout , mode)
char *mname;
int adddom;
longword nameserver;
int mode;       /* YS: 0 - A, 1 - MX */
int *timedout;	/* set to 1 on timeout */
{
    char namebuff[512];
    int domainsremaining;
    int status, i;
    longword response;

    response = 0;
    *timedout = 1;

    if (!nameserver) {	/* no nameserver, give up now */
	outs("No nameserver defined!\n\r");
	return(-1L);
    }

    while (*mname && *mname < 33) mname ++;	/* kill leading spaces */

    if (!(*mname))
	return(0L);

    if(qinit()) return (-1L);			/* initialize some flag fields */

    strcpy( namebuff, mname );

    if ( adddom ) {
	if(namebuff[strlen(namebuff)-1] != '.') {       /* if no trailing dot */
	    if(loc_domain) {             /* there is a search list */
/*
		domainsremaining = countpaths( loc_domain );
*/
		strcat(namebuff,".");
		strcat(namebuff,getpath(loc_domain,1));
	    }
	} else
	    namebuff[ strlen(namebuff)-1] = 0;	/* kill trailing dot */
    }
    /*
     * This is not terribly good, but it attempts to use a binary
     * exponentially increasing delays.
     */

     for ( i = 2; i < 17; i *= 2) {
	sendom(namebuff,nameserver, 0xf001, mode);	/* try UDP */

        ip_timer_init( dom_sock, i );
        do {
            kbhit();
            tcp_tick( dom_sock );
            if (ip_timer_expired( dom_sock )) break;
            if ( watcbroke ) {
                break;
            }
            if (chk_timeout( timeoutwhen ))
                break;
            if ( sock_dataready( dom_sock )) *timedout = 0;
        } while ( *timedout );

	if ( !*timedout ) break;	/* got an answer */
    }

    if ( !*timedout )
	response = udpdom(mode);	/* process the received data */

    sock_close( dom_sock );
    return( response );
}

/*
 * nextdomain - given domain and count = 0,1,2,..., return next larger
 *		domain or NULL when no more are available
 */
static char *nextdomain( char *domain, int count )
{
    char *p;
    int i;

    p = domain;

    for (i = 0; i < count; ++i) {
	p = strchr( p, '.' );
	if (!p) return( NULL );
	++p;
    }
    return( p );
}


static longword _resolve(name, mode)
char *name;
int mode;
{
    longword ip_address, temp;
    int count, i;
    byte timeout[ MAX_NAMESERVERS ];
    /*struct useek qp;        /* temp buffer */
    tcp_Socket ds;          /* temp buffer */
    word oldhndlcbrk;


    /*question = &qp;*/
    dom_sock = &ds;
    if (!name) return( 0 );
    rip( name );


    if ( isaddr( name ))
	return( aton( name ));

    if (!_domaintimeout) _domaintimeout = sock_delay << 2;
    timeoutwhen = set_timeout( _domaintimeout );

    count = 0;
    memset( &timeout, 0, sizeof( timeout ));

    oldhndlcbrk = wathndlcbrk;
   /* wathndlcbrk = 1;        /* enable special interrupt mode */
/* ^^ Here I don't sure that I'm right, but else I can't interrupt program */
/*    during resolve... --YS                                               */

    watcbroke = 0;
    do {
	if ((loc_domain = nextdomain( def_domain, count )) == NULL)
		count = -1;	/* use default name */

	for ( i = 0; i < _last_nameserver ; ++i ) {
	    if (!timeout[i])
		if ((ip_address = Sdomain( name , count != -1 ,
			def_nameservers[i], &timeout[i] , mode)) != NULL)
		    break;	/* got name, bail out of loop */
	}

	if (count == -1) break;
        /*if (ip_address == -1) break;*/
	count++;
    } while (!ip_address);
    watcbroke = 0;          /* always clean up */
    wathndlcbrk = oldhndlcbrk;

    return( ip_address );
}


/*
 * resolve()
 * 	convert domain name -> address resolution.
 * 	returns 0 if name is unresolvable right now
 */
longword resolve(name)
char *name;
{
  _resolve(name,1);
}

struct useek *getmxlist(name)
char *name;
{
    char *c;
    struct useek *u = NULL;
    longword r;
    if((c = strchr(name, '@')) != NULL)  name = c + 1;
    r = _resolve(name,3);
    if(r && r != (longword) -1)
      {
        u = question;
        question = NULL;
      }
    return u;
}

