/*    =========================================================
 *    FreeDOS SMTP/POP3 client program vers. 0.30  (08-02-2001)
 *
 *    =    Base64 and xtext (see RFC 1891) (en|de)coding      =
 *    =                  implementation                       =
 *
 *              by Yury Semenov (yury@zipper.paco.net)
 *    =========================================================
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  THis version modified by John Zappe 5/16/02
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char base64[] =
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";


unsigned char *encode64(in, out)
unsigned char *in, *out;
{
   unsigned char *buf = out;
   int i, shift = 0, last = 0;   /* Need to initialize last to prevent run-on padding */
   unsigned short accum = 0;
   if(!in || !out) return NULL;
   while(*in || shift)
         {
            if(!*in) last = shift;
            accum <<= 8;
            shift += 8;
            accum |= *in;
            while(shift >= 6)
             {
                shift -= 6;
                *out++ = base64[(accum >> shift) & 0x3Fl];
                if(!*in) shift = 0;
             }
            in++;
         }
   for(i = last; i && i < 6; i += 2) *out++ = '=';
   *out = 0;
   return buf;
}

unsigned char *nencode64(in, out, n)
unsigned char *in, *out;
int n;
{
   unsigned char *buf = out;
   int i, shift = 0, last = 0;   /* see above comment */
   unsigned short accum = 0;
   if(!in || !out) return NULL;
   while((n > 0) || shift)
         {
            if(!n) last = shift;
            accum <<= 8;
            shift += 8;
            accum |= *in;
            while(shift >= 6)
             {
                shift -= 6;
                *out++ = base64[(accum >> shift) & 0x3Fl];
                if(!n) shift = 0;
             }
            in++;
            n--;
         }
   for(i = last; i && i < 6; i += 2) *out++ = '=';  /* see comment above */
   *out = 0;
   return buf;
}

unsigned char *decode64(in, out)
unsigned char *in, *out;
{
   unsigned char *buf = out;
   int i, k, shift = 0;
   unsigned short accum = 0;
   if(!in || !out) return NULL;
   for(i = 0, k = 0, *out = 0; ; i++)
         {
            char *c = in[i] ? strchr(base64, in[i]) : NULL;
            if(c)
            {
               accum <<= 6;
               shift += 6;
               accum |= (c - base64);
               if ( shift >= 8 )
               {
                  shift -= 8;
                  *(unsigned short*)(out + (k++)) = ((accum >> shift) & 0xff);
               }
            }
            else break;
         }
   return buf;
}

unsigned char *xtext(in, out) /* See RFC1891 */
unsigned char *in, *out;
{
   unsigned char *buf = out, c;
   if(!in || !out) return NULL;
   while((c = *in) != 0)
      {
        if(c != '+' && c != '=' && c >= 33 && c <= 126) *out++ = c;
        else sprintf((char*)out, "+%02.2X", c), out += 3;
        in++;
      }
   *out = 0;
   return buf;
}


