/*
 * This file is part of the ipcfg tool
 * http://picotcp4dos.sourceforge.net
 *
 * Copyright (C) 2015 Mateusz Viste
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <dos.h>
#include <stdint.h>
#include <stdio.h>
#include <time.h>

#include <picotcp.h>
#include <picodos.h>

#include "picoip.h"
#include "dhcp.h" /* include self for control */


uint32_t ipaddr, ipgw, ipdns1, ipdns2, netmask;

static void cb_dhcp(void *arg, int code) {
  struct pico_ip4 tmpip;
  if (code == PICO_DHCP_SUCCESS) {
    tmpip = pico_dhcp_get_address(arg);
    ipaddr = tmpip.addr;
    tmpip = pico_dhcp_get_gateway(arg);
    ipgw = tmpip.addr;
    tmpip = pico_dhcp_get_nameserver(arg, 0);
    ipdns1 = tmpip.addr;
    tmpip = pico_dhcp_get_nameserver(arg, 1);
    ipdns2 = tmpip.addr;
    tmpip = pico_dhcp_get_netmask(arg);
    netmask = tmpip.addr;
  }
}


/* returns the netmask length on success, or a negative number otherwise */
int dhcp_get(unsigned char *addr, unsigned char *gw, unsigned char *dns1, unsigned char *dns2) {
  uint32_t xid;
  int bitcount;
  time_t starttime = time(NULL);
  struct pico_device picodev;

  /* init picotcp, but without using any network config */
  if (picoinit(&picodev, PICOINIT_NOCONF) != 0) {
    return(-1);
  }

  if (pico_dhcp_initiate_negotiation(&picodev, &cb_dhcp, &xid) < 0) {
    picoquit(&picodev);
    return(-2);
  }

  for (ipaddr = 0 ; ipaddr == 0 ;) {
    union REGS regs;
    int86(0x28, &regs, &regs); /* DOS 2+ IDLE INTERRUPT */
    int86(0x28, &regs, &regs); /* DOS 2+ IDLE INTERRUPT */
    pico_stack_tick();
    if (time(NULL) - starttime >= 5) { /* timeout */
      picoquit(&picodev);
      return(DHCP_TIMEOUT);
    }
  }

  picoip2ip(ipaddr, addr);
  picoip2ip(ipgw, gw);
  picoip2ip(ipdns1, dns1);
  picoip2ip(ipdns2, dns2);

  /* count how many bits are set in netmask */
  for (bitcount = 0; bitcount < 32; bitcount++) {
    if ((netmask & 1) == 0) break;
    netmask >>= 1;
  }

  picoquit(&picodev);
  return(bitcount);
}
