/*
    Template for local message declaration file for msgComp
    Copyright (C) 1995 Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


/* $RCSfile: DECRYPT.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	Decrypt SKAUS encrypted string.
	mode:
		'S': for complete SKAUS number
		'G': for Programm ID (without revision)

	Encryption method:
		1) strrev()
		2)	newCh[0] = oldCh[0] XOR mode
			newCh[n] = (oldCh[n] + n) XOR oldCh[n-1]
			n = 1..(strlen(oldCh) + 1)

   Revision 1.1  1996/02/04 06:38:05  ska
   Initial revision

*/


#ifndef lint
static char rcsid[] = 
	"$Id: DECRYPT.C 1.3 1996/02/04 08:05:43 ska Exp ska $";
#endif

#ifdef CRYPT_SECURE
unsigned decrypt(char *str, unsigned mode, unsigned maxlen)
#define sec && c <= maxlen
#define sec1 if(c > maxlen) return 0xffff;
#else
unsigned decrypt(char *str, unsigned mode)
#define sec
#define sec1
#endif
{	unsigned c, o;

	c = 0;
	do o = *str = (*str ^ mode) - c++;
	while(++str, (mode = o) sec);
	sec1
	strrev(str - c);
	return c;
}
#undef sec
#undef sec1

unsigned crypt(char *str, unsigned mode)
{	unsigned c, o;

	c = 0;
	strrev(str);
	do *str = ((o = *str) + c++) ^ mode;
	while(++str, mode = o);
	return c;
}

#ifdef TEST
#include <stdio.h>
char a[] = "\x14\x1F\x08\x19\x02\x65\x0F\x70\x49";
char b[] = "\x00\x1F\x08\x19\x02\x65\x0F\x70\x78\x38";
main()
{
	decrypt(a, 'G');
	printf("group: %s\n", a);
	decrypt(b, 'S');
	printf("app: %s\n", b);
	crypt(a, 'G');

	decrypt(a, 'G');
	printf("group: %s\n", a);
	crypt(b, 'S');
	decrypt(b, 'S');
	printf("app: %s\n", b);
}
#endif
