//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2012 by PDSoft (Attila Padar)                *
//*                http://mpxplay.sourceforge.net                          *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//

#ifndef diskdriv_h
#define diskdriv_h

#include "in_file.h"

#ifdef __cplusplus
extern "C" {
#endif

#define MPXPLAY_DISKDRIVEDATA_INFOBIT_INTMDDS 1 // internally allocated mdds
#define MPXPLAY_DISKDRIVEDATA_INFOBIT_SYSUNIX 2 // unix (remote) file system (for text files and file-pathes)

typedef struct mpxplay_diskdrive_data_s{
 struct mpxplay_drivehand_func_s *mdfs;
 void *drive_data;
 void *file_data;
 mpxp_int32_t infobits;
 mpxp_uint32_t utftype;
 char lastdir[MAX_PATHNAMELEN]; // to save current (last) directory of the drive(s)
}mpxplay_diskdrive_data_s;

#define MPXPLAY_DRIVEHANDFUNC_INFOBIT_SLOWACCESS  (1 << 0) // like ftp,http
#define MPXPLAY_DRIVEHANDFUNC_INFOBIT_DISCONNECT  (1 << 1) // disconnect is allowed for this drive (like ftp,ice)
#define MPXPLAY_DRIVEHANDFUNC_INFOBIT_READONLY    (1 << 2) //
#define MPXPLAY_DRIVEHANDFUNC_INFOBIT_LISTTYPEDIR (1 << 3) // list type dir: 1. drive always uses / gives full path (do not assemble), 2. entries don't match with drive (don't use drive's mdds for entries)
#define MPXPLAY_DRIVEHANDFUNC_INFOBIT_ASYNCDIR    (1 << 4) // async (callbacked) directory reading, possible delayed song pos restore
#define MPXPLAY_DRIVEHANDFUNC_INFOBIT_NOAUTOSKIP  (1 << 5) // don't skip automatically to the next entry

//funcnums for drive_config()
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_MAJOR  0x01000000

//--- without any drive data
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_PREINIT              0x01000001 // preinitialize drive (eg. load DVB database) (calling before any mount)
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_CLOSEDRIVE           0x01000002 // close drive (eg. save DVB database) (calling at program close)
//--- with drive_data (mdds)
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_ABOUT                0x01000010 // open an "about" dialog (not implemented)
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GUICFG               0x01000011 // open a gui config (not implemented)
//argp1: mpxp_uint32_t (*callbackfn)(void *mdds,unsigned int cb_event,void *argp1,void *argp2)
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_SET_CALLBACKPSIFN    0x01000100 // set diskdrive's psi  callback function in sub-drive (to update playlist related infos)
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_CMD_RESETDRIVE       0x01001000 // ie: clear dir cache
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_CMD_MEDIAEJECTLOAD   0x01001001 // load/unload media
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_ISFILESYSUNX     0x01002000 // is filesystem unix style?
// argp1: char *pathname
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_ISALWAYSSTREAM   0x01002001 // is the path (media) always stream (dvb)
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_MAYBESTREAM      0x01002002 // may the path (media) be stream (http)
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_UTFTYPE          0x01002008 // filename text encoding
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_CHKBUFBLOCKBYTES 0x01002010 // before open (>0:value,0:nobuff,<0:set by Mpxplay)
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_PREBUFFERSIZE    0x01002011 // recommended buffer size for this drive
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_PREREADBUFBYTES  0x01002012 // fills up the prebuffer before start playing after open (>0:value,0:nobuff,<0:set by Mpxplay)
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_PREREADBUFMSEC   0x01002013 // same in msec (not implemented yet)
//argp1: char *dirname
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_ISDIREXISTS      0x01002100
//argp1: char *dirname
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_ISDIRROOT        0x01002101
//argp1: char *dest, argp2: unsigned long *maxdestlen
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_DRVLETTERSTR     0x01002200
//argp1: char *dest, argp2: unsigned long *maxdestlen
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_DRVTYPENAME      0x01002201
//argp1: char *dest, argp2: unsigned long *maxdestlen
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_DRVOPENNAME      0x01002202 // for ctrl-f
//argp1: char **dest, argp2: unsigned long *destlen
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_CONSTSESSIONS    0x01002205 // read built-in session list in mpxp_ftp.ini text format (like ice:)
//argp1: char *dest, argp2: char *src
#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_REALLYFULLPATH   0x01002300 // ie: ftp://user:pasw@server/dir/filename
//argp1: char *dest, argp2: unsigned long *maxdestlen
//#define MPXPLAY_DISKDRIV_CFGFUNCNUM_GET_ERRORLASTTEXT    0x01002500

//--- with filehand_data (mdfs)
#define MPXPLAY_DISKFILE_CFGFUNCNUM_CMD_TERMINATE       0x01006000 // terminate file connect/read (pre-close)
#define MPXPLAY_DISKFILE_CFGFUNCNUM_SET_CALLBACKPSIFN   0x01006001 // set diskfile's psi  callback function in sub-drive (to update playlist related infos)
#define MPXPLAY_DISKFILE_CFGFUNCNUM_GET_ISNONSEEKABLE   0x01006010 // is non-seekable media? (returns 0 or 1)
#define MPXPLAY_DISKFILE_CFGFUNCNUM_GET_ISLIVESTREAM    0x01006011 // is endless media?      (returns 0 or 1)
#define MPXPLAY_DISKFILE_CFGFUNCNUM_GET_ISASYNCREAD     0x01006012 // is async (non-blocking) read at playing? (parsing is always blocking read) (returns 0 or 1)
//argp1: unsigned long *blocksize
#define MPXPLAY_DISKFILE_CFGFUNCNUM_SET_FILEBLOCKSIZE   0x01006020 // after open
//argp1: unsigned long *readwaitenable
#define MPXPLAY_DISKFILE_CFGFUNCNUM_SET_READWAIT        0x01006021 // wait at read (1) or don't (0)
//argp1: unsigned long *disablekeepalive
#define MPXPLAY_DISKFILE_CFGFUNCNUM_SET_NOKEEPALIVE     0x01006022 // disable keep alive (1)
//argp1: char **exttype
#define MPXPLAY_DISKFILE_CFGFUNCNUM_GET_CONTENTTYPEEXT  0x01006030 // get (http/dtv) content type (via a file extension:MP3,AAC,TS,etc.) (if file has no extension)
#define MPXPLAY_DISKFILE_CFGFUNCNUM_GET_CONTENTBITRATE  0x01006034 // returns icy-br in kbits/sec
//argp1: char *dest argp2: unsigned long *maxdestlen
#define MPXPLAY_DISKFILE_CFGFUNCNUM_GET_CONTENT_ARTIST  0x01006041 // get low level content artist
//argp1: char *dest argp2: unsigned long *maxdestlen
#define MPXPLAY_DISKFILE_CFGFUNCNUM_GET_CONTENT_TITLE   0x01006040 // get low level content title
//argp1: char *dest argp2: unsigned long *maxdestlen
#define MPXPLAY_DISKFILE_CFGFUNCNUM_GET_CONTENT_GENRE   0x01006045 // get low level content genre
//argp1: char *filename
#define MPXPLAY_DISKFILE_CFGFUNCNUM_GET_PROGRAMID       0x01006050 // get the program-id extracted from the filename (DVB)
//argp1: char *destbuf (MAX_PATHNAMELEN) argp2:mpxp_uint32_t prog_id
#define MPXPLAY_DISKFILE_CFGFUNCNUM_GET_FNBYPRGID       0x01006051 // get (assemble) filename by a program-id (DVB), related to the same multiplex (same protocol, same freq)
//argp1:mpxp_int32_t *program_id   argp2:char *program_name
#define MPXPLAY_DISKFILE_CFGFUNCNUM_SET_PROGRAMNAME     0x01006060 // set/add a DVB program name by program id to the database
//argp1:mpxp_int32_t *program_id   argp2:mpxp_uint32_t *channel_id
#define MPXPLAY_DISKFILE_CFGFUNCNUM_SET_PROGRAMCHANID   0x01006061 // set program logical channel id by program id
//argp1:mpxp_int32_t *program_id   argp2:mpxp_uint32_t *ctrl_flags
#define MPXPLAY_DISKFILE_CFGFUNCNUM_SET_PROGRAMCTRLFLGS 0x01006062 // set program control flags (encrypted) by program id
//argp1:mpxp_int32_t *program_id
#define MPXPLAY_DISKFILE_CFGFUNCNUM_SET_PROGEVENTCHANGE 0x01006063 // notify dtv-driver about program current event change
//argp1:mpxp_int32_t *program_id   argp2:struct ffmpeg_epg_program_event_s *event_data
#define MPXPLAY_DISKFILE_CFGFUNCNUM_ADD_PROGEVENTENTRY  0x01006065 // add a new epg event entry by program id

//---- callback events
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_PROCPSISTART 0x01007000 // starting of a psi CB process
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_PROCPSISTOP  0x01007001 // end of a psi CB process
//argp1: char *filename
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_REFDIRENTRY   0x01007010 // refresh directory entry on display
//argp1: char *filename
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_NEWDIRENTRY   0x01007020 // new directory entry
//argp1: char *filename
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_ADDDIRENTRY   0x01007021 // add directory entry if it doesn't exist yet
//argp1: char *filename
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_DELDIRENTRY   0x01007025 // delete directory entry
//argp1: char *filename
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_CLOSEDIRENTRY 0x01007028 // delete directory entry
//argp1: char *oldfilename argp2: char *newfilename
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_FILENAME   0x01007030 // modify filename
//argp1: char *filename argp2: mpxp_ptrsize_t newtimelenms
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_FILESIZE  0x01007032 // modify size info of media in bytes
//argp1: char *filename argp2: mpxp_ptrsize_t newtimelenms
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_TIMELENMS  0x01007034 // modify length info of media in ms
//argp1: char *filename argp2: mpxp_ptrsize_t newtimeposms
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_TIMEPOSMS  0x01007038 // modify time position of media in ms (it's not a seeking!)
//argp1: char *filename
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_CHG_BEG 0x0100703E // metadata change begin sign
//argp1: char *filename
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_CHG_END 0x0100703F // metadata change end sign

#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_BASE   0x01007040 // modify metadata (ID3)
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_MASK   0x0f
//argp1: char *filename argp2: char *artist
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_ARTIST  (MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_BASE + 1) // modify artist (I3I_ARTIST)
//argp1: char *filename argp2: char *title
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_TITLE   (MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_BASE + 0) // modify title (I3I_TITLE)
//argp1: char *filename argp2: char *album
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_ALBUM   (MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_BASE + 2) // modify title (I3I_ALBUM)
//argp1: char *filename argp2: char *year
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_YEAR    (MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_BASE + 3) // modify title (I3I_YEAR)
//argp1: char *filename argp2: char *comment
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_COMMENT (MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_BASE + 4) // modify title (I3I_COMMENT)
//argp1: char *filename argp2: char *genre
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_GENRE   (MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_BASE + 5) // modify genre (I3I_GENRE)
//argp1: char *filename argp2: char *tracknum
#define MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_TRACKNUM (MPXPLAY_DISKDRIVE_CFGFUNCNUM_CBEVENT_MODDIRENTRY_I3I_BASE + 6) // modify genre (I3I_TRACKNUM)

//--- textfile config
#define MPXPLAY_DISKTEXTFILE_CFGFUNCNUM_GET_TEXTCODETYPE_SRC   0x01008000
//#define MPXPLAY_DISKTEXTFILE_CFGFUNCNUM_GET_TEXTCODETYPE_DEST  0x01008001
//argp1: unsigned long *textcodetype
#define MPXPLAY_DISKTEXTFILE_CFGFUNCNUM_SET_TEXTCODETYPE_SRC   0x01008500
#define MPXPLAY_DISKTEXTFILE_CFGFUNCNUM_SET_TEXTCODETYPE_DEST  0x01008501
// no arguments
#define MPXPLAY_DISKTEXTFILE_CFGFUNCNUM_SET_SEARCHSTRZ_ENABLE  0x01008510
#define MPXPLAY_DISKTEXTFILE_CFGFUNCNUM_SET_SEARCHSTRZ_DISABLE 0x01008511
#define MPXPLAY_DISKTEXTFILE_CFGFUNCNUM_SET_HTMLTEXT_SRC       0x01008512

//note: if a GET functions returns a number, it returns that in the error code
#define MPXPLAY_DISKDRIV_CFGERROR_SET_OK           1
#define MPXPLAY_DISKDRIV_CFGERROR_GET_OK           0
#define MPXPLAY_DISKDRIV_CFGERROR_INVALID_DRIVE   -1
#define MPXPLAY_DISKDRIV_CFGERROR_UNSUPPFUNC      -2 // not supported function
#define MPXPLAY_DISKDRIV_CFGERROR_ARGUMENTMISSING -3 // missing argument (for get or set)
#define MPXPLAY_DISKDRIV_CFGERROR_CANNOT_DO       -4

//drv_ftp config (ftp->flags)
#define DRVFTP_FTPDRIVE_FLAG_PASSIVE_MODE     (1<< 0)
#define DRVFTP_FTPDRIVE_FLAG_AUTO_RECONNECT   (1<< 1)
#define DRVFTP_FTPDRIVE_FLAG_USE_ANONYM_LOGIN (1<< 2)
#define DRVFTP_FTPDRIVE_FLAG_USE_UTF8         (1<< 3)
#ifdef MPXPLAY_UTF8
#define DRVFTP_FTPDRIVE_FLAG_DEFAULT_CONFIG (DRVFTP_FTPDRIVE_FLAG_PASSIVE_MODE|DRVFTP_FTPDRIVE_FLAG_AUTO_RECONNECT|DRVFTP_FTPDRIVE_FLAG_USE_ANONYM_LOGIN|DRVFTP_FTPDRIVE_FLAG_USE_UTF8)
#else
#define DRVFTP_FTPDRIVE_FLAG_DEFAULT_CONFIG (DRVFTP_FTPDRIVE_FLAG_PASSIVE_MODE|DRVFTP_FTPDRIVE_FLAG_AUTO_RECONNECT|DRVFTP_FTPDRIVE_FLAG_USE_ANONYM_LOGIN)
#endif

//drv_http config
#define DRVFTP_HTTPDRIVE_FLAG_HANDLE_METADATA  (1<< 0)
#define DRVFTP_HTTPDRIVE_FLAG_AUTO_RECONNECT   (1<< 1)
#define DRVFTP_HTTPDRIVE_FLAG_USE_UTF8         (1<< 3)
#define DRVFTP_HTTPDRIVE_FLAGS_DEFAULT_CONFIG  (DRVFTP_HTTPDRIVE_FLAG_HANDLE_METADATA | DRVFTP_HTTPDRIVE_FLAG_AUTO_RECONNECT | DRVFTP_HTTPDRIVE_FLAG_USE_UTF8)

#define MPXPLAY_ERROR_DISKDRIV_OK                    0
#define MPXPLAY_ERROR_DISKDRIV_ERROR              -400
#define MPXPLAY_ERROR_DISKDRIV_PROTOCOL           -401
#define MPXPLAY_ERROR_DISKDRIV_PATH               -402
#define MPXPLAY_ERROR_DISKDRIV_INIT               -403
#define MPXPLAY_ERROR_DISKDRIV_ERROR_ADDRINFO     -405
#define MPXPLAY_ERROR_DISKDRIV_SOCKET             -406
#define MPXPLAY_ERROR_DISKDRIV_OPENMODE           -409
#define MPXPLAY_ERROR_DISKDRIV_CONNECTION_CLOSED  -410
#define MPXPLAY_ERROR_DISKDRIV_CONNECT_TIMEOUT    -425
#define MPXPLAY_ERROR_DISKDRIV_CONNECT_TERMINATED -426
#define MPXPLAY_ERROR_DISKDRIV_CONNECT_SSL        -427
#define MPXPLAY_ERROR_DISKDRIV_LOGIN              -430
#define MPXPLAY_ERROR_DISKDRIV_DATACONN           -440
#define MPXPLAY_ERROR_DISKDRIV_RESPONSE           -441
#define MPXPLAY_ERROR_DISKDRIV_BUSY               -445
#define MPXPLAY_ERROR_DISKDRIV_READ               -450
#define MPXPLAY_ERROR_DISKDRIV_WRITE              -451
#define MPXPLAY_ERROR_DISKDRIV_CHUNK              -454
#define MPXPLAY_ERROR_DISKDRIV_TIMEOUT_READ       -455
#define MPXPLAY_ERROR_DISKDRIV_EOF                -460
#define MPXPLAY_ERROR_DISKDRIV_FILENOTFOUND       -470

#define MPXPLAY_ERROR_IS_DISKDRIV(errcode) ((errcode <= MPXPLAY_ERROR_DISKDRIV_ERROR) && (errcode > -500))

#define MPXPLAY_DISKDRIV_FILESIZE_UNKNOWN   0x7eeeeeee

typedef struct mpxplay_drivehand_func_s{
 char *drivername;
 mpxp_int32_t infobits;
 long         (*drive_config)(void *drive_data,unsigned long funcnum,void *argp1,void *argp2); // pre-config without argument
 unsigned int (*drive_name_check)(char *pathname); // check pathname, return true (1) if 'path' is supported by this drive-handler
 void        *(*drive_mount)(char *pathname);  // returns drivehand_data
 void         (*drive_unmount)(void *drivehand_data);
 unsigned int (*findfirst)(void *drivehand_data,char *pathname,unsigned int attrib,struct pds_find_t *ffblk);
 unsigned int (*findnext)(void *drivehand_data,struct pds_find_t *ffblk);
 void         (*findclose)(void *drivehand_data,struct pds_find_t *ffblk);
 char        *(*getcwd)(void *drivehand_data,char *buf,unsigned int buflen);
 int          (*chdir)(void *drivehand_data,char *path);
 int          (*mkdir)(void *drivehand_data,char *path);
 int          (*rmdir)(void *drivehand_data,char *path);
 int          (*rename)(void *drivehand_data,char *oldfilename,char *newfilename);
 int          (*unlink)(void *drivehand_data,char *filename);
 void *r15;
 void *r16;
 void *r17;
 void *r18;
 void *r19;
 void *r20;

 unsigned int (*file_name_check)(void *drivehand_data,char *filename);
 void *(*file_open) (void *drivehand_data,char *filename,unsigned long openmode, int *err_code); // returns filehand_data
 void  (*file_close) (void *filehand_data);
 long  (*file_read)  (void *filehand_data,char *buf,unsigned int len);
 long  (*file_write) (void *filehand_data,char *buf,unsigned int len);
 mpxp_filesize_t (*file_seek)  (void *filehand_data,mpxp_filesize_t offset,int fromwhere);
 mpxp_filesize_t (*file_tell)  (void *filehand_data);
 mpxp_filesize_t (*file_length)(void *filehand_data);
 int   (*file_eof)   (void *filehand_data);
 int   (*file_chsize)(void *filehand_data,mpxp_filesize_t offset);
 void *r31;
}mpxplay_drivehand_func_s; // 32*4=128 bytes

extern struct mpxplay_drivehand_func_s *mpxplay_diskdriv_all_drivehand_funcs[];

extern struct mpxplay_drivehand_func_s *mpxplay_diskdrive_search_driver(char *pathname);
extern void mpxplay_diskdrive_alldrives_preinit(void);
extern void mpxplay_diskdrive_alldrives_close(void);
extern unsigned long mpxplay_diskdrive_get_mdfs_infobits(struct mpxplay_diskdrive_data_s *mdds);
extern long mpxplay_diskdrive_drive_config(struct mpxplay_diskdrive_data_s *mdds,unsigned int funcnum,void *argp1,void *argp2);
extern unsigned int mpxplay_diskdrive_drive_mount(struct mpxplay_diskdrive_data_s *mdds,char *pathname);
extern void mpxplay_diskdrive_drive_unmount(struct mpxplay_diskdrive_data_s *mdds);
extern unsigned int mpxplay_diskdrive_findfirst(struct mpxplay_diskdrive_data_s *mdds,char *pathname,unsigned int attrib,struct pds_find_t *ffblk);
extern unsigned int mpxplay_diskdrive_findnext(struct mpxplay_diskdrive_data_s *mdds,struct pds_find_t *ffblk);
extern void mpxplay_diskdrive_findclose(struct mpxplay_diskdrive_data_s *mdds,struct pds_find_t *ffblk);
extern unsigned int mpxplay_diskdrive_checkdir(struct mpxplay_diskdrive_data_s *mdds,char *dirname);
extern unsigned int mpxplay_diskdrive_isdirroot(struct mpxplay_diskdrive_data_s *mdds,char *dirname);
extern char *mpxplay_diskdrive_getcwd(struct mpxplay_diskdrive_data_s *mdds,char *buf,unsigned int buflen);
extern int mpxplay_diskdrive_chdir(struct mpxplay_diskdrive_data_s *mdds,char *path);
extern int mpxplay_diskdrive_mkdir(struct mpxplay_diskdrive_data_s *mdds,char *path);
extern int mpxplay_diskdrive_rmdir(struct mpxplay_diskdrive_data_s *mdds,char *path);
extern int mpxplay_diskdrive_rename(struct mpxplay_diskdrive_data_s *mdds,char *oldfilename,char *newfilename);
extern int mpxplay_diskdrive_unlink(struct mpxplay_diskdrive_data_s *mdds,char *filename);

extern void *mpxplay_diskdrive_file_open(struct mpxplay_diskdrive_data_s *mdds,char *filename,unsigned long opentype, int *err_code);
extern struct mpxplay_diskdrive_data_s *mpxplay_diskdrive_file_get_mdds(void *mdfp);
extern char *mpxplay_diskdrive_file_get_filename(void *mdfp);
extern long mpxplay_diskdrive_file_config(void *mdfd,unsigned int funcnum,void *argp1,void *argp2);
extern void mpxplay_diskdrive_file_terminate(void *mdfp);
extern void mpxplay_diskdrive_file_close(void *mdfd);
extern long mpxplay_diskdrive_file_read(void *mdfd,char *buf,unsigned int len);
extern long mpxplay_diskdrive_file_write(void *mdfd,char *buf,unsigned int len);
extern mpxp_filesize_t mpxplay_diskdrive_file_seek(void *mdfd,mpxp_filesize_t offset,int fromwhere);
extern mpxp_filesize_t mpxplay_diskdrive_file_tell(void *mdfd);
extern mpxp_filesize_t mpxplay_diskdrive_file_length(void *mdfd);
extern int mpxplay_diskdrive_file_eof(void *mdfd);
extern int mpxplay_diskdrive_file_chsize(void *mdfd,mpxp_filesize_t offset);

extern mpxp_bool_t mpxplay_diskdrive_file_check_stream(char *filename);
extern int mpxplay_diskdrive_copy_file(char *filename_src, char *filename_dest);

extern unsigned int mpxplay_diskdrive_subdirscan_open(struct mpxplay_diskdrive_data_s *mdds,char *path_and_filename,unsigned int attrib,struct pds_subdirscan_t *dsi);
extern int mpxplay_diskdrive_subdirscan_findnextfile(struct mpxplay_diskdrive_data_s *mdds,struct pds_subdirscan_t *dsi);
extern void mpxplay_diskdrive_subdirscan_close(struct mpxplay_diskdrive_data_s *mdds,struct pds_subdirscan_t *dsi);

extern void *mpxplay_diskdrive_textfile_open(struct mpxplay_diskdrive_data_s *mdds,char *filename,unsigned int openmode); // openmodes: O_RDONLY,O_RDWR|O_CREAT
extern void *mpxplay_diskdrive_textfile_virtual_open(char *bufdata, unsigned int datalen, unsigned int openmode);
extern void mpxplay_diskdrive_textfile_close(void *fhp);
extern long mpxplay_diskdrive_textfile_config(void *fhp,unsigned int funcnum,void *argp1,void *argp2);
extern long mpxplay_diskdrive_textfile_readline(void *fhp,char *readbuf,unsigned long rbuflen);
extern long mpxplay_diskdrive_textfile_writeline(void *fhp,char *str);
extern mpxp_filesize_t mpxplay_diskdrive_textfile_filelength(void *fhp);
extern mpxp_filesize_t mpxplay_diskdrive_textfile_tell(void *fhp);

#ifdef __cplusplus
}
#endif

#endif // diskdriv_h
