/*****************************************************************************
 * dtv_bda.hpp : DirectShow BDA graph builder header for Mpxplay-MMC
 *****************************************************************************
 *
 * Author: Ken Self <kenself(at)optusnet(dot)com(dot)au>
 *         Attila Padar <mpxplay(at)freemail(dot)com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * ( at your option ) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

#include <wtypes.h>
#include <unknwn.h>
#include <ole2.h>
#include <limits.h>

/* FIXME: mingw.org doesn't define secure versions of
 * http://msdn.microsoft.com/en-us/library/f30dzcf6.aspxu */
#define NO_DSHOW_STRSAFE
#include <dshow.h>

#include <comcat.h>
#include <tuner.h>
#include <bdaiface.h>
#include <qedit.h>

#include "newfunc/newfunc.h"
#include "dtv_drv.h"

#define MMCgetVarName(var)  #var
#define MMCExecuteAndCheckWithReturn(x) {HRESULT hrm = (x); if (FAILED (hrm)) { return hrm; }}
#define MMCBDAInterfaceRelease(p) if(p) { (p)->Release(); (p) = NULL; }

class MMCBDAGraph : public ISampleGrabberCB
{
public:
	MMCBDAGraph();
    virtual ~MMCBDAGraph();
    int  BufferAdd(dvb_device_t *d);
    int  BufferRemove(dvb_device_t *d);
    void BuffersAllReadUnlock(void);
    void BuffersAllReset(void);
    void BuffersAllClose(void);
    int  BuffersAllRefill(dvb_device_t *d);
    int  BufferRead(dvb_device_t *d, uint8_t *destbuf, int requested_bytes);

    int  SubmitTuneRequest(dvb_device_t *d);
    int  SetInversion(dvb_device_t *d, int);

    int  IBDAGetSignalStats(BOOLEAN *bSignalPresent, BOOLEAN *bSignalLocked, LONG *lDbStrength);
#if 0
    int  IBDASetFrequency(ULONG ulFrequency, ULONG ulBandwidth);
#endif
    int  IBDAIsSignalPresent(void);

    int  GetSignalStrength(void);

    int  InitATSCtuner(dvb_device_t *d);
    int  InitCQAMtuner(dvb_device_t *d);
    int  InitDVBCtuner(dvb_device_t *d);
    int  InitDVBTtuner(dvb_device_t *d);
#ifdef MPXPLAY_DRVTV_ENABLE_DVBT2
    int  InitDVBT2tuner(dvb_device_t *d);
#endif
    int  InitDVBStuner(dvb_device_t *d);

    HRESULT Build(dvb_device_t *d);
    HRESULT StopFilter();
    void ClearFilter();
    dtvbda_data_buffer_s *data_buffers_chain; /* buffer chain for the connected clients */

private:
    ULONG ul_cbrc;
    STDMETHODIMP_( ULONG ) AddRef(void) { return ++ul_cbrc; }
    STDMETHODIMP_( ULONG ) Release(void) { return --ul_cbrc; }
    STDMETHODIMP QueryInterface(REFIID /*riid*/, void** /*p_p_object*/ ) { return E_NOTIMPL; }
    STDMETHODIMP SampleCB(double d_time, IMediaSample *p_sample);
    STDMETHODIMP BufferCB(double d_time, BYTE* p_buffer, long l_buffer_len);

    CLSID     guid_network_type_initialized;       /* network type in use */
    long      l_tuner_used;            /* Index of the Tuning Device in use */
    int       samplecb_counter;        /* counter to detect initial errors */
    WINBOOL   is_discontinuity;        /* stream error */
    IRunningObjectTable *p_ro_table;
    IMoniker  *p_moniker;
    DWORD     d_graph_register;        /* registration number for the RunningObjectTable */
    void     *data_bufferchain_mutex;  /* mutex for buffer chain */
    dtvbda_data_buffer_s data_buffer_device_read; /* buffer to read from device */
    mpxp_int64_t timeout_at_read;

    IMediaControl*    media_control_handler;
    IGraphBuilder*    filter_graph_handler;
    ITuningSpace*     tuning_space_handler;
    ITuneRequest*     tune_request_handler;
    IDVBTuneRequest*  dvb_tunerequest_handler;

    IDVBTLocator*     dvbt_locator_handler;
#ifdef MPXPLAY_DRVTV_ENABLE_DVBT2
    IDVBTLocator2*    dvbt2_locator_handler;
#endif

    ICreateDevEnum* p_system_dev_enum;
    IBaseFilter*    p_network_provider;
    IBaseFilter*    p_tuner_device;
    IBaseFilter*    p_capture_device;
    IBaseFilter*    p_sample_grabber;
    IBaseFilter*    p_mpeg_demux;
    IBaseFilter*    p_transport_info;
    IScanningTuner* p_scanning_tuner;
    ISampleGrabber* p_grabber;
    IBDA_Topology*   p_BDATopology;
    IUnknown*        p_BDATopolUnknown;
    IBDA_DeviceControl*     p_BDADeviceControl;
    IBDA_FrequencyFilter*   p_BDAFreqFilter;
    IBDA_SignalStatistics*  p_BDATunerStats;
    IBDA_SignalStatistics*  p_BDADemodulStats;

    int  IBDATopologyAlloc(void);
    void IBDATopologyFree(void);
    int  IBDATopologySearch(REFCLSID iid);
    int  IBDATunerStatsAlloc(void);
    void IBDATunerStatsFree(void);

    HRESULT TunerDeviceInit(dvb_device_t *p_dev_cfg, REFCLSID guid_network_type_request);
    HRESULT TunerDeviceValidate(void *p_tune_request);
    HRESULT CheckTuningSpace(dvb_device_t *d, REFCLSID guid_network_type_request );
    HRESULT GetFilterName(IBaseFilter *p_filter, char **psz_bstr_name );
    HRESULT GetPinName(IPin* p_pin, char **psz_bstr_name );
    HRESULT FindFilter(REFCLSID clsid, long *i_moniker_used, IBaseFilter *p_upstream, IBaseFilter **p_p_downstream);
    HRESULT ConnectFilterPins(IBaseFilter *p_filter_upstream, IBaseFilter *p_filter_downstream);
    HRESULT StartFilter(dvb_device_t *p_dev_cfg);
    HRESULT DestroyFilter();
    HRESULT RegisterFilter();
    void    DeregisterFilter();

    template<class SRC, class DEST>
	HRESULT MMCBDAQueryInterfaceWithCheckAndLog(SRC *p_src, REFIID riid, DEST **p_dest)
    {
    	HRESULT hrq = S_OK;
    	if(p_src && p_dest)
    	{
    		if(!*p_dest)
    		{
    			hrq = p_src->QueryInterface(riid, (void **)p_dest);
    			if (FAILED (hrq))
    			{
    				mpxplay_debugf(MPXPLAY_DEBUGOUT_WARNING, "Cannot QI %s for %s hr=0x%8lx",  MMCgetVarName(p_src) , MMCgetVarName(p_dest), hrq );
    			}
    		}
    	}
    	else
    	{
    		hrq = -1;
    		mpxplay_debugf(MPXPLAY_DEBUGOUT_WARNING, "%s / %s is NULL", MMCgetVarName(p_src), MMCgetVarName(p_dest));
    	}

    	return hrq;
	}

    template<class SRC, class DEST>
    HRESULT MMCBDAQueryInterfaceWithCheckAndLog(SRC *p_src, DEST **p_dest)
    {
    	return this->MMCBDAQueryInterfaceWithCheckAndLog(p_src, __uuidof(DEST), p_dest);
    }

    template<class IFACE>
	void MMCBDAInterfaceReleaseAndLog(IFACE **p_iface)
    {
    	if(p_iface && *p_iface)
    	{
    		ULONG mem_ref = (*p_iface)->Release();
    		if(mem_ref != 0)
			{
				MPXPLAY_DEBUG_MESSAGE(MPXPLAY_DEBUG_OUTPUT, "InterFaceRelease: %s mem_ref=%ld", MMCgetVarName(p_iface), mem_ref );
			}
    		*p_iface = NULL;
    	}
	}
};
