;Mpxplay-MMC x64 - Audio & video player
;Written by Pidi

!define ProgramVersionNumberShort "v322"
!define ProgramVersionNumberLong "v3.22"
!define BuildType "x64"
!define FullName  "Mpxplay/MMC ${ProgramVersionNumberLong} ${BuildType} - Mpxplay Multimedia Commander"
!define ShortName "MpxplayMMC"
!define ExeName "mpxp_mmc_x64.exe"
!define UnInstallRegPath "Software\Microsoft\Windows\CurrentVersion\Uninstall\${ShortName}${BuildType}"

;--------------------------------
;Includes

  !include "MUI.nsh"
  !include "Sections.nsh"
  !include "WinVer.nsh"
  !include "x64.nsh"
  !include "FileFunc.nsh"

;--------------------------------
;General

  SetCompressor /SOLID lzma

  ;Name and file
  Name "${FullName}"
  OutFile "${ShortName}-${ProgramVersionNumberShort}-${BuildType}-installer.exe"

  ;Default installation folder
  InstallDir ""

  ;Previous version installation folder
  Var PREV_INSTDIR

;--------------------------------
;Interface Configuration

  !define MUI_HEADERIMAGE
  !define MUI_COMPONENTSPAGE_NODESC
  !define MUI_FINISHPAGE_NOAUTOCLOSE
  !define MUI_UNFINISHPAGE_NOAUTOCLOSE
  !define MUI_ABORTWARNING

;--------------------------------
;Pages

  !define MUI_WELCOMEPAGE_TITLE_3LINES
  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE "COPYING"
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  !define MUI_FINISHPAGE_TITLE_3LINES
  !insertmacro MUI_PAGE_FINISH

  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !define MUI_FINISHPAGE_TITLE_3LINES
  !insertmacro MUI_UNPAGE_FINISH

;--------------------------------
;Languages

  !insertmacro MUI_LANGUAGE "English"

;--------------------------------
;Installer Sections

Section "-Remove previous version"

  ${If} $PREV_INSTDIR != ""

    Delete "$PREV_INSTDIR\${ExeName}"
    Delete "$PREV_INSTDIR\*.ini"
    Delete "$PREV_INSTDIR\*.dll"
    Delete "$PREV_INSTDIR\DOCS\*.*"

    SetShellVarContext all
    Delete "$PREV_INSTDIR\Uninstall ${ShortName}.lnk"
    RMDir  "$PREV_INSTDIR"
    SetShellVarContext current
    Delete "$PREV_INSTDIR\Uninstall ${ShortName}.lnk"
    RMDir  "$PREV_INSTDIR"

    SetShellVarContext all
    Delete "$SMPROGRAMS\${ShortName}\${ShortName}.lnk"
    Delete "$DESKTOP\${ShortName}.lnk"

    Delete "$PREV_INSTDIR\${ShortName}-uninstall.exe"
    RMDir  $PREV_INSTDIR\DOCS
    RMDir  $PREV_INSTDIR
    DeleteRegKey HKLM ${UnInstallRegPath}
  ${EndIf}

SectionEnd

Section "-Install"

  SetOutPath $INSTDIR

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\${ShortName}-uninstall.exe"

  ; Write the uninstall keys for Windows
  WriteRegStr   HKLM ${UnInstallRegPath} "UninstallString" "$INSTDIR\${ShortName}-uninstall.exe"
  WriteRegStr   HKLM ${UnInstallRegPath} "DisplayIcon" "$INSTDIR\${ShortName}-uninstall.exe"
  WriteRegStr   HKLM ${UnInstallRegPath} "DisplayName" "${FullName} (remove only)"
  WriteRegDWORD HKLM ${UnInstallRegPath} "NoModify" 1
  WriteRegDWORD HKLM ${UnInstallRegPath} "NoRepair" 1

  SetShellVarContext all
  CreateDirectory "$SMPROGRAMS\${ShortName}"
  CreateShortcut  "$SMPROGRAMS\${ShortName}\Uninstall ${ShortName}.lnk" "$INSTDIR\${ShortName}-uninstall.exe"

  File ".\${ExeName}"
  File ".\mpxplay.ini"
  File ".\*.dll"

  SetShellVarContext all
  CreateShortcut "$SMPROGRAMS\${ShortName}\${ShortName}.lnk" "$INSTDIR\${ExeName}"
  CreateShortcut "$DESKTOP\${ShortName}.lnk" "$INSTDIR\${ExeName}"

  SetShellVarContext current
  CreateDirectory "$LOCALAPPDATA\${ShortName}"
  CopyFiles $INSTDIR\*.ini "$LOCALAPPDATA\${ShortName}"

  SetOutPath "$INSTDIR\DOCS"
  File ".\DOCS\*.*"

SectionEnd

;--------------------------------
;Installer Functions

Function .onInit

  ${IfNot} ${RunningX64}
    MessageBox MB_OK|MB_ICONEXCLAMATION "This program could be installed only on x64 version of Windows" /SD IDOK
    Abort
  ${EndIf}

  ; Check Administrator's rights
  ClearErrors
  UserInfo::GetAccountType
  IfErrors not_admin
  Pop $R0
  StrCmp $R0 "Admin" admin
not_admin:
  ; No Administrator's rights
  MessageBox MB_YESNO|MB_ICONEXCLAMATION "For correct installation of this program you must have $\"Administrator's rights$\"!$\r$\nDo you wish to continue installation anyway?" \
    /SD IDNO IDYES admin
  Abort
admin:

  StrCpy $PREV_INSTDIR ""
  ReadRegStr $R0 HKLM ${UnInstallRegPath} "UninstallString"
  ${GetParent} $R0 $R1
  StrCmp $R1 "" +2
  StrCpy $PREV_INSTDIR $R1

  StrCmp $INSTDIR "" +1 +4
  StrCpy $INSTDIR $PREV_INSTDIR
  StrCmp $INSTDIR "" +1 +2
  StrCpy $INSTDIR "$PROGRAMFILES64\${ShortName}"

FunctionEnd

;--------------------------------
;Uninstaller Section

Section "Uninstall"

  ${DisableX64FSRedirection}

  MessageBox MB_YESNO|MB_ICONQUESTION "Keep ${ShortName}'s settings in registry and appdata ini files?" /SD IDYES IDYES keep_settings
  SetRegView 64
  DeleteRegKey HKCU "Software\GNU\${ShortName}"
  SetRegView lastused
  Delete $LOCALAPPDATA\${ShortName}\*.*
  RMDir $LOCALAPPDATA\${ShortName}

keep_settings:

  Delete "$INSTDIR\${ExeName}"
  Delete "$INSTDIR\*.ini"
  Delete "$INSTDIR\*.dll"
  Delete "$INSTDIR\DOCS\*.*"

  SetShellVarContext all
  Delete "$SMPROGRAMS\${ShortName}\Uninstall ${ShortName}.lnk"
  Delete "$SMPROGRAMS\${ShortName}\${ShortName}.lnk"
  RMDir  "$SMPROGRAMS\${ShortName}"
  Delete "$DESKTOP\${ShortName}.lnk"

  SetShellVarContext current
  Delete "$SMPROGRAMS\${ShortName}\Uninstall ${ShortName}.lnk"
  Delete "$SMPROGRAMS\${ShortName}\${ShortName}.lnk"
  RMDir  "$SMPROGRAMS\${ShortName}"
  Delete "$DESKTOP\${ShortName}.lnk"

  Delete "$INSTDIR\${ShortName}-uninstall.exe"
  RMDir  $INSTDIR\DOCS
  RMDir  $INSTDIR
  DeleteRegKey HKLM ${UnInstallRegPath}

  ${EnableX64FSRedirection}

SectionEnd
