#ifndef MOC_DIALOG_ELEMS_H
#define MOC_DIALOG_ELEMS_H
 
#include <QWidget>
#include <QtWidgets>

QT_BEGIN_NAMESPACE
class MainWindow;
QT_END_NAMESPACE

#define DISPQT_DIALOG_HEXACOLOR_LEN     7
#define DISPQT_DIALOG_HEXACOLOR_INVALID 0xFFFFFFFF
#define DISPQT_DIALOG_HEXACOLOR_VALID   0x00FFFFFF
#define DISPQT_DIALOG_HEXACOLOR_BLACK   0x00000000
#define DISPQT_DIALOG_HEXACOLOR_WHITE   0x00FFFFFF
//#define DISPQT_DIALOG_HEXACOLOR_ALPHA_DEFAULT   0x66000000 // default 0x66 = 40 % (set by gcfg->gui_background_color_alpha)
#define DISPQT_DIALOG_HEXACOLOR_ALPHA_CONFIG    0xD0000000 // less transparency
#define DISPQT_DIALOG_HEXACOLOR_ALPHA_DIALOG    0xD0000000 // less transparency
#define DISPQT_DIALOG_HEXACOLOR_ALPHA_MQMENU    0xD0000000 // less transparency is used for list and main qmenu (video contextmenu uses the default/general transparency)
#define DISPQT_DIALOG_HEXACOLOR_ALPHA_NONE      0xFF000000 // no alpha (full color)
#define DISPQT_DIALOG_HEXACOLOR_ALPHA_FULL      0x00000000 // full transparent (no color)
#define DISPQT_DIALOG_HEXACOLOR_ALPHA_SCALE     0xFF
#define DISPQT_DIALOG_HEXACOLOR_ALPHA_SHIFT     24

enum dispqt_dialog_window_types{
	DISPQT_DIALOG_WINDOWTYPE_DIALOG,       // aka textwin
	DISPQT_DIALOG_WINDOWTYPE_MAINWIN,      // main window
	DISPQT_DIALOG_WINDOWTYPE_DVBEPG,       // DVB/EPG dialog
	DISPQT_DIALOG_WINDOWTYPE_EPGVIDEOINFO, // EPG info over video(wall) surface
	DISPQT_DIALOG_WINDOWTYPE_QMENU_MAIN,   // main window menu
	DISPQT_DIALOG_WINDOWTYPE_QMENU_LIST,   // playlist editor context menu
	DISPQT_DIALOG_WINDOWTYPE_QMENU_VIDEO,  // video surface context menu
	DISPQT_DIALOG_WINDOWTYPE_VIDEOCTRLBAR, // window for video controlbar
	DISPQT_DIALOG_WINDOWTYPE_CONFIG        // window for configuration
};

#ifdef Q_OS_WIN
extern bool mpxplay_dispqt_dialog_elems_setwindowcomposition_win10(HWND m_hWnd, unsigned long color_hexa, unsigned int winVer);
extern void mpxplay_dispqt_dialog_elems_reset_windowcomposition_win10(HWND m_hWnd);
#endif

class DispQtDialogElemWindow : public QDialog
{
Q_OBJECT
public:
	DispQtDialogElemWindow(MainWindow *mainwindow = 0, QWidget *parent = 0, Qt::WindowFlags winFLags = Qt::Dialog, enum dispqt_dialog_window_types dialogType = DISPQT_DIALOG_WINDOWTYPE_DIALOG);

Q_SIGNALS:
	void dialogwin_signal_config_style_apply(bool initial);

public Q_SLOTS:
	void dialogwin_config_style_apply(bool initial);

protected:
	bool event(QEvent *event);
	void keyPressEvent(QKeyEvent *event);
	void dialogwin_config_get_colors(void);
	void dialogwin_config_style_color(void);
	unsigned long color_background_hexa;

private:
	MainWindow *main_window;
	Qt::WindowFlags window_flags;
	enum dispqt_dialog_window_types dialog_type;
	QColor color_dialog_background, color_dialog_text;
	QPalette color_palette;
	QPixmap bkgnd_image;
};

class DispQtDialogElemTabWidget : public QTabWidget
{
Q_OBJECT
public:
	DispQtDialogElemTabWidget(MainWindow *mainwindow = 0, QWidget *parent = 0);
	void tabwidget_config_style_apply(bool initial);

protected:
	void keyPressEvent(QKeyEvent *event);

private:
	MainWindow *main_window;
};

class DispQtDialogElemPushButton : public QPushButton
{
Q_OBJECT
public:
	DispQtDialogElemPushButton(MainWindow *mainwindow = 0, QWidget *parrent = 0, QString buttonTitle = "");

public Q_SLOTS:
	void pushbutton_set_style(bool initial);

private:
	MainWindow *main_window;
};

class DispQtDialogElemQmenu : public QMenu
{
Q_OBJECT
public:
	DispQtDialogElemQmenu(MainWindow *mainwindow = 0, QWidget *parent = 0, enum dispqt_dialog_window_types dialogType = DISPQT_DIALOG_WINDOWTYPE_QMENU_LIST);
	DispQtDialogElemQmenu(const QString &title, MainWindow *mainwindow, QWidget *parent, enum dispqt_dialog_window_types dialogType = DISPQT_DIALOG_WINDOWTYPE_QMENU_LIST);
	DispQtDialogElemQmenu *addMenu(const QString &title);

public Q_SLOTS:
	void qmenu_config_style_update();

private:
	MainWindow *main_window;
	enum dispqt_dialog_window_types dialog_type;
	bool translucent_enabled_last;
	unsigned long gui_layout_last, color_background_hexa_last;
	void qmenu_config_style_apply(bool initial);
};

class DispQtDialogElemMenubar : public QMenuBar
{
Q_OBJECT
public:
	DispQtDialogElemMenubar(MainWindow *main_window = 0, QWidget *parent = 0);
	DispQtDialogElemQmenu *addMenu(const QString &title);

public Q_SLOTS:
	void menubar_set_style(bool initial);

protected:
	bool event(QEvent *event);

private:
	MainWindow *main_window;
};

class DispQtDialogElemComboBox : public QComboBox
{
Q_OBJECT
public:
	DispQtDialogElemComboBox(MainWindow *main_window = 0, QWidget *parent = 0, bool colorize = false);

public Q_SLOTS:
	void combobox_set_style(bool initial);

private:
	MainWindow *main_window;
};

class DispQtDialogElemProgressBar : public QProgressBar
{
Q_OBJECT
public:
	DispQtDialogElemProgressBar(MainWindow *main_window = 0, QWidget *parent = 0);

public Q_SLOTS:
	void progressbar_set_style(bool initial);

private:
	MainWindow *main_window;
};

class DispQtDialogElemHeaderView : public QHeaderView
{
Q_OBJECT
public:
	DispQtDialogElemHeaderView(MainWindow *mainwindow = 0, Qt::Orientation orientation = Qt::Horizontal, QWidget *parent = 0);

public Q_SLOTS:
	void headerview_set_style(bool transparent_back);

private:
	MainWindow *main_window;
};

class DispQtDialogElemScrollBar : public QScrollBar
{
Q_OBJECT
public:
	DispQtDialogElemScrollBar(MainWindow *mainwindow = 0, Qt::Orientation orientation = Qt::Vertical, QWidget *parent = 0);

public Q_SLOTS:
	void scrollbar_set_style(bool initial);

private:
	MainWindow *main_window;
};

class DispQtDialogElemTextEdit : public QTextEdit
{
Q_OBJECT
public:
	DispQtDialogElemTextEdit(MainWindow *mainwindow = 0, QWidget *parent = 0);

public Q_SLOTS:
	void textedit_set_style(bool initial);

private:
	MainWindow *main_window;
	DispQtDialogElemScrollBar *vscrollbar;
};

//===========================================================================================

#define DISPQT_CONFIG_TOOLTIP_DURATION 15000

// embedded alternative elems in configpage_comboboxline_s (datatype flags)
#define DISPQT_CONFIG_COMBOTYPE_COMBOBOX  0
#define DISPQT_CONFIG_COMBOTYPE_CHKBOX    (1 << 24)
#define DISPQT_CONFIG_COMBOTYPE_SPINBOX   (2 << 24)
#define DISPQT_CONFIG_COMBOTYPE_EDITLINE  (3 << 24)
#define DISPQT_CONFIG_COMBOTYPE_GET(type) (type & 0xFF000000)
#define DISPQT_CONFIG_SPINBOX_VALPACK_MINMAX(val_min,val_max) ((val_min << 16) | val_max)
#define DISPQT_CONFIG_SPINBOX_VALUNPACK_MIN(val) (val >> 16)
#define DISPQT_CONFIG_SPINBOX_VALUNPACK_MAX(val) (val & 0xFFFF)

struct configpage_comboboxline_s {
	const char *title;
	unsigned long datatype;    // ARG_NUM, ARG_CHAR (|ARG_POINTER), | DISPQT_CONFIG_COMBOTYPE_
	void *data_var;
	unsigned long nb_values;   // var_size at DISPQT_CONFIGELEM_FLAG_EDITLINE, chkbit at DISPQT_CONFIG_COMBOTYPE_CHKBOX, packed val_min/val_max at DISPQT_CONFIG_COMBOTYPE_SPINBOX
	const char **data_values;
	const char **data_description;
	const char *tooltip;
};

struct configpage_chkbox_s {
	const char *name;
	unsigned long *chkvar;
	unsigned long chkbit;
	const char *tooltip;
};

struct configpage_spinbox_s {
	const char *name;
	unsigned long *var_ptr;
	long val_min, val_max;
};

struct configpage_editline_s {
	const char *name;
	char *var_ptr;
	unsigned long var_size;
	const char *tooltip;
};

//-------------------------------------------------------------------------------------------
class DispQtConfigpageCheckboxGroup : public QVBoxLayout
{
Q_OBJECT
public:
	DispQtConfigpageCheckboxGroup(MainWindow *main_window = 0, QWidget *parent = 0, const struct configpage_chkbox_s *chkbox_config = NULL, int nb_config = 0);
	~DispQtConfigpageCheckboxGroup();

	void checkboxgroup_applyall(void);

private:
	QCheckBox **chkbox_widgets;
	const struct configpage_chkbox_s *chkbox_config;
	int nb_of_chkboxconfig;
};

class DispQtConfigpageCheckboxGroupbox : public QGroupBox
{
Q_OBJECT
public:
	DispQtConfigpageCheckboxGroupbox(MainWindow *main_window = 0, QWidget *parent = 0, QString box_title = "", const struct configpage_chkbox_s *chkbox_config = NULL, int nb_config = 0);
	~DispQtConfigpageCheckboxGroupbox();

	void checkboxgroup_applyall(void);

private:
	DispQtConfigpageCheckboxGroup *checkbox_group;
};

//-------------------------------------------------------------------------------------------
class DispQtConfigpageSpinboxGroup : public QGridLayout
{
Q_OBJECT
public:
	DispQtConfigpageSpinboxGroup(MainWindow *main_window = 0, QWidget *parent = 0, const struct configpage_spinbox_s *spinbox_config = NULL, int nb_config = 0);
	~DispQtConfigpageSpinboxGroup();

	void spinboxgroup_applyall(void);

private:
	QSpinBox **spinbox_widgets;
	const struct configpage_spinbox_s *spinbox_config;
	int nb_of_spinboxconfig;
};

class DispQtConfigpageSpinboxGroupbox : public QGroupBox
{
Q_OBJECT
public:
	DispQtConfigpageSpinboxGroupbox(MainWindow *main_window = 0, QWidget *parent = 0, QString box_title = "", const struct configpage_spinbox_s *spinbox_config = NULL, int nb_config = 0);
	~DispQtConfigpageSpinboxGroupbox();

	void spinboxgroup_applyall(void);

private:
	DispQtConfigpageSpinboxGroup *spinbox_group;
};

//-------------------------------------------------------------------------------------------
class DispQtConfigpageEditlineGroup : public QGridLayout
{
Q_OBJECT
public:
	DispQtConfigpageEditlineGroup(MainWindow *main_window = 0, QWidget *parent = 0, const struct configpage_editline_s *editline_config = NULL, int nb_config = 0);
	~DispQtConfigpageEditlineGroup();

	void editlinegroup_applyall(void);

private:
	QLineEdit **lineedits;
	const struct configpage_editline_s *editline_config;
	int nb_of_editlineconfig;
};

class DispQtConfigpageEditlineGroupbox : public QGroupBox
{
Q_OBJECT
public:
	DispQtConfigpageEditlineGroupbox(MainWindow *main_window = 0, QWidget *parent = 0, QString box_title = "", const struct configpage_editline_s *editline_config = NULL, int nb_config = 0);
	~DispQtConfigpageEditlineGroupbox();
	void editlinegroupbox_applyall(void);

private:
	DispQtConfigpageEditlineGroup *editline_group;
};

//-------------------------------------------------------------------------------------------
class DispQtConfigpageComboboxGroup : public QGridLayout
{
Q_OBJECT
public:
	DispQtConfigpageComboboxGroup(MainWindow *main_window = 0, QWidget *parent = 0, const struct configpage_comboboxline_s *p_comboboxgroup_config = NULL, unsigned int nb_configs = 0);
	~DispQtConfigpageComboboxGroup();
	void comboboxgroup_applyall(void);

private:
	const struct configpage_comboboxline_s *comboboxgroup_config;
	int nb_of_comboboxconfig;
	void **gui_elems;
};

class DispQtConfigpageComboboxGroupbox : public QGroupBox
{
Q_OBJECT
public:
	DispQtConfigpageComboboxGroupbox(MainWindow *main_window = 0, QWidget *parent = 0, QString title = "", const struct configpage_comboboxline_s *p_comboboxgroup_config = NULL, unsigned int nb_configs = 0);
	~DispQtConfigpageComboboxGroupbox();
	void comboboxgroupbox_applyall(void);

private:
	DispQtConfigpageComboboxGroup *combobox_group;
};

#endif // MOC_DIALOG_ELEMS_H
