#ifndef MOC_DVBEPG_H
#define MOC_DVBEPG_H
 
#include <QWidget>
#include <QtWidgets>
#include <QStandardItemModel>
#include <QHash>
#include <QDateTime>
#include "moc_dialog_elems.h"
#include "moc_video_qt.h"
#include "mpxplay.h"
#include "diskdriv/dtv_drv.h"

QT_BEGIN_NAMESPACE
class MainWindow;
class DispQtDVBEPGProgram;
class DispQtDVBEPGEventsViewWidget;
class DispQtEPGTabWidget;
QT_END_NAMESPACE

#define DISPQT_EPG_REFRESH_INTERVAL_SEC  10

#define DISPQT_EPG_BUTTON_HEIGHT      20
#define DISPQT_EPG_SCAN_BUTTON_HEIGHT 18
#define DISPQT_EPG_PROGRAMS_WIDTH    100
#define DISPQT_EPG_RULER_HEIGHT       20
#define DISPQT_EPG_PROGRAM_HEIGHT     40
#define DISPQT_EPG_DESCRIPTION_HEIGHT 64
#define DISPQT_EPG_ITEMNUM_INITIAL_ALLOC 128

typedef struct dispqt_dvbepg_startstop_info_s{
	void **filehandler;
	mpxp_bool_t is_local_file;
	char dvb_filename[MAX_PATHNAMELEN];
	char local_filename[MAX_PATHNAMELEN];
}dispqt_dvbepg_startstop_info_s;

class DispQtDVBEPGItem : public QGraphicsItem
{
public:
	DispQtDVBEPGItem( DispQtDVBEPGEventsViewWidget *view, DispQtDVBEPGProgram *program, struct mpxplay_dvb_epg_event_data_s *event_data);

    QRectF boundingRect() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

    const QDateTime& get_event_start() const { return this->event_start_time;}
    QDateTime get_event_end() const { return QDateTime(this->event_start_time).addSecs(this->event_duration_secs); }
    uint32_t get_event_duration() const { return event_duration_secs;}
    const QString& get_event_name() const { return this->event_name; }
    QString get_event_description() const { return this->event_shortDescription; }
    QString get_event_extdescription() const { return this->event_extDescription; }
    int  get_event_parental_rating() const { return event_parental_rating; }
    bool epgitem_set_eventdata(struct mpxplay_dvb_epg_event_data_s *event_data);
    void epgitem_update_itemgeometry(void);
    bool epgitem_is_past_event(const QDateTime &ref_time) const;
    bool epgitem_is_curr_event(const QDateTime &ref_time) const;

protected:
    //void focusInEvent(QFocusEvent *event);
    void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *);
    void hoverEnterEvent(QGraphicsSceneHoverEvent *);
    void hoverLeaveEvent(QGraphicsSceneHoverEvent *);

private:
    bool epgitem_update_itemsize(QDateTime &start_time_gui, int32_t &duration_gui);
    void epgitem_update_itempos(void);
    DispQtDVBEPGEventsViewWidget *eventsview_widget;
    DispQtDVBEPGProgram *program_of_event;

    uint32_t    event_duration_secs;    // real duration of event in secs
    int32_t     event_duration_gui;     // limited duration of event for gui
    bool        event_is_fake;          // a fake event, because there's not valid event for this program
    uint8_t     event_parental_rating;
    QDateTime   event_start_time;       // real start time of event
    QDateTime   event_start_gui;        // limited start time for gui
    QString     event_name;             // event title
    QString     event_rich_hame;        // formatted event title
    QString     event_shortDescription; // short description
    QString     event_extDescription;   // extended description
    QRectF      m_boundingRect;
};

class DispQtDVBEPGProgram : public QObject
{
Q_OBJECT
public:
	DispQtDVBEPGProgram( DispQtDVBEPGEventsViewWidget *view, struct mpxplay_dvb_epg_protocol_data_s *prot_data, struct mpxplay_dvb_epg_frequency_data_s *freq_data, struct mpxplay_dvb_epg_program_data_s *prog_data);
	virtual ~DispQtDVBEPGProgram();

	void program_update_events(struct mpxplay_dvb_epg_event_data_s *epg_program_event_chain, const mpxp_uint64_t limit_datetime_min_secs, const mpxp_uint64_t limit_datetime_max_secs, mpxp_uint64_t *min_datetime_val);
	void program_clear_items(void);
	void program_remove_expired_events(const QDateTime &ref_datetime);
	void program_update_eventitems(void);
	void program_activate(void);
	size_t getPosition() const { return pos; }
	void setPosition( size_t newpos) { pos = newpos; }
	const DispQtDVBEPGItem *get_current_eventitem() const { return this->current_item; }
	void set_program_name(char *prog_name) { program_name = QString::fromUtf8(prog_name); }
	const QString & get_program_name() const {return program_name;}
	uint16_t get_protocol_id() { return this->protocol_id; }
	uint32_t get_frequency_hz() { return this->frequency_hz; }
	uint16_t get_program_id() { return this->program_id; }

	QHash<uint64_t, DispQtDVBEPGItem*> events_by_begintime;

private:
	const DispQtDVBEPGItem *current_item;
	DispQtDVBEPGEventsViewWidget *eventsview_widget;
	size_t pos;

	uint32_t frequency_hz;
	uint32_t program_ctrl_flags;
	uint16_t protocol_id;
	uint16_t program_id;
	uint16_t channel_id;
	bool program_has_fake_events;
	QString program_name;
};

class DispQtDVBEPGRulerWidget : public QWidget
{
Q_OBJECT
public:
	DispQtDVBEPGRulerWidget(DispQtDVBEPGEventsViewWidget *view = 0, QWidget* parent = 0 );
	virtual ~DispQtDVBEPGRulerWidget() { }
	void rulerwidget_config_style_apply(bool initial);
	void rulerwidget_set_widgetscale(double scale);

public slots:
	void rulerwidget_set_starttime(const QDateTime& startTime);
	void rulerwidget_set_offset(int offset);

protected:
	void paintEvent(QPaintEvent *event);

private:
	DispQtDVBEPGEventsViewWidget *eventsview_widget;
	int ruler_view_offset;
	qreal ruler_view_scale;
	QDateTime ruler_startTime;
};

class DispQtDVBEPGProgramsWidget : public QWidget
{
Q_OBJECT
public:
	DispQtDVBEPGProgramsWidget(DispQtDVBEPGEventsViewWidget *view, QWidget *parent);
	void programswidget_config_style_apply(bool initial);

public slots:
	void programswidget_add_program(const DispQtDVBEPGProgram *program);
	void programswidget_set_offset(int offset);
	void programswidget_clear();

protected:
	void paintEvent(QPaintEvent *event);

private:
	DispQtDVBEPGEventsViewWidget *epgview_widget;
	int programs_view_offset;
	QList<const DispQtDVBEPGProgram *> program_list;
};

class DispQtDVBEPGGraphicsScene : public QGraphicsScene
{
Q_OBJECT
public:
    explicit DispQtDVBEPGGraphicsScene( QObject *parent = 0 );
};

class DispQtDVBEPGEventsViewWidget : public QGraphicsView
{
Q_OBJECT

public:
    explicit DispQtDVBEPGEventsViewWidget(MainWindow *mainwindow, QWidget *parent = 0, bool local_file_epg_handling = false);
    virtual ~DispQtDVBEPGEventsViewWidget();

    void             eventsviewwidget_config_style_apply(bool initial);
    bool             eventsviewwidget_set_new_playfile(struct mpxplay_dvb_epg_protocol_data_s *prot_data, char *filename, bool is_local_file);

    bool             is_played_program(int protocol_id, mpxp_int32_t frequency_hz, mpxp_int32_t program_id);
    void             eventsviewwidget_set_widgetscale(double scaleFactor);
    void             datetimeval_to_qdatetime(QDateTime *qdatetime, mpxp_uint64_t datetime_val);
    mpxp_uint64_t    qdatetime_to_datetimeval(QDateTime qdatetime);
    void             set_epg_current_time(const QDateTime &newtime) { epg_current_time = newtime; }
    const QDateTime& get_epg_current_time() const { return epg_current_time; }
    void             set_eventsview_begin_time(const QDateTime &newtime) { eventsview_begin_time = newtime; }
    const QDateTime& get_eventsview_begintime() const { return eventsview_begin_time; }

    bool             eventsviewwidget_update_event_items(struct mpxplay_dvb_epg_protocol_data_s *prot_data);
    void             eventsviewwidget_initvals(void);
    void             eventsviewwidget_clear(void);
    void             eventsviewwidget_consolidate_items();
    void             eventsviewwidget_program_activate(DispQtDVBEPGProgram *);
    MainWindow      *main_window;
    bool             is_local_file_epg_handler;

signals:
    void             signal_eventsviewwidget_time_start_changed(const QDateTime&);
    void             signal_eventsviewwidget_item_focused(DispQtDVBEPGItem *);
    void             signal_eventsviewwidget_program_added(const DispQtDVBEPGProgram *);
    void             signal_eventsviewwidget_program_change(int);

protected:
    QDateTime        epg_current_time;
    QDateTime        eventsview_begin_time, eventsview_prev_begin_time;
    double           eventsview_zoom_scalefactor;

public slots:
    void            focusItem(DispQtDVBEPGItem *);

private:
    DispQtDVBEPGGraphicsScene *epg_scene;
    DispQtDialogElemScrollBar *vscrollbar, *hscrollbar;
    QHash<uint32_t, DispQtDVBEPGProgram*> program_datas;
    int current_protocol_id; // datas of currently playing program
    mpxp_int32_t current_frequency_hz, current_program_id;
    char current_filename[MAX_PATHNAMELEN];
};

class DispQtDVBEPGMainWidget : public QWidget
{
Q_OBJECT
public:
	DispQtDVBEPGMainWidget(MainWindow *mainwindow = 0, DispQtEPGTabWidget *parent = 0, bool local_file_epg_handling = false);
	bool dvbepgwidget_send_epginfos(struct mpxplay_dvb_epg_protocol_data_s *prot_data, char *currfilename);
	void dvbepg_config_style_apply(bool initial);
	DispQtDialogElemPushButton *button_refresh, *button_close;
    enum {DISPQT_DVBEPG_NOEPG_WIDGET = 0, DISPQT_DVBEPG_EPGVIEW_WIDGET};

public Q_SLOTS:
	void dvbepg_reload_epginfos_full(void);
	void dvbepgwidget_clear(void);
	void dvbepgwidget_set_zoom(int level);
	void dvbepgwidget_display_event_description(DispQtDVBEPGItem *epgItem);

protected:
	void keyPressEvent(QKeyEvent *event);

private:
	MainWindow *main_window;
	DispQtEPGTabWidget *parent_tabwidget;
	bool is_local_file_epg_handler;
	QStackedWidget *dvbepg_stacked_widget;
	DispQtDVBEPGRulerWidget *dvbepg_ruler_widget;
	DispQtDVBEPGProgramsWidget *dvbepg_programs_widget;
	DispQtDVBEPGEventsViewWidget *dvbepg_eventsview_widget;
	DispQtDialogElemTextEdit *dvbepg_description;
	char current_local_filename[MAX_PATHNAMELEN];
};

//=========================================================================================================================
class DispQtDVBScanProgramTable: public QTableView
{
Q_OBJECT
public:
	DispQtDVBScanProgramTable(MainWindow *mainwindow = 0, QWidget *parent = 0);
	void progtable_style_apply(bool initial);
	void progtable_clear(void);
	void progtable_send_epginfos(struct mpxplay_dvb_epg_protocol_data_s *prot_data);

protected:
	void mouseDoubleClickEvent(QMouseEvent *event);

private:
	QStandardItemModel *model_create(void);
	void table_setsizes(void);

	MainWindow *main_window;
	DispQtDialogElemHeaderView *header_view;
	DispQtDialogElemScrollBar *vscrollbar, *hscrollbar;
	QStandardItemModel *model_proglist;
	int row_height;
};

class DispQtDVBScanGWidget : public QWidget
{
Q_OBJECT
public:
	DispQtDVBScanGWidget(MainWindow *mainwindow = 0, QWidget *parent = 0);
	void dvbscanwidget_send_epginfos(struct mpxplay_dvb_epg_protocol_data_s *prot_data);
	void dvbscan_config_style_apply(bool initial);
	void dvb_stopscan_init(void);
	void dvb_scan_apply_settings(void);

public Q_SLOTS:
	void dvb_startscan_button_handler(void);
	void dvb_loadepg_button_handler(void);
	void dvb_stopscan_button_handler(void);
	void dvb_loadchannels_button_handler(void);
	void dvb_clearchannels_button_handler(void);

protected:
	void keyPressEvent(QKeyEvent *event);

private:
	void dvb_start_scan_handler(bool load_epg);
	MainWindow *main_window;
	DispQtConfigpageComboboxGroupbox *combobox_dvb_scan_settings;
	DispQtConfigpageComboboxGroupbox *combobox_dvb_result_control;
	DispQtDialogElemPushButton *button_startscan, *button_loadepg, *button_stopscan, *button_loadchannels, *button_clearchannels;
	QLabel *label_progress;
	DispQtDialogElemProgressBar *progressbar_scan;
	DispQtDVBScanProgramTable *programtable_scan;
	void *scan_handler;
};

class DispQtEPGLocalFileWidget : public DispQtDVBEPGMainWidget
{
Q_OBJECT
public:
	DispQtEPGLocalFileWidget(MainWindow *mainwindow = 0, DispQtEPGTabWidget *parent = 0);
};

class DispQtEPGTabWidget : public DispQtDialogElemTabWidget
{
Q_OBJECT
public:
	DispQtEPGTabWidget(MainWindow *mainwindow = 0, QWidget *parent = 0);
	void epgtabwidget_config_style_apply(bool initial);
	DispQtDVBEPGMainWidget *dvbepg_widget;
	DispQtDVBScanGWidget *dvbscan_widget;
	DispQtEPGLocalFileWidget *epglocalfile_widget;

private:
	MainWindow *main_window;
};

class DispQtEPGDialog : public DispQtDialogElemWindow
{
Q_OBJECT
public:
	DispQtEPGDialog(MainWindow *mainwindow = 0, QWidget *parent = 0, bool open_from_contextmenu = false);
	~DispQtEPGDialog();

Q_SIGNALS:
	void signal_epgdialog_geometry_update(void);
	void signal_epgdialog_config_style_apply(bool);
	void signal_epgdialog_send_dtvdbase_epginfos(void *, char *);
	void signal_epgdialog_send_scaninfos(void *);
	void signal_epgdialog_send_localfile_epginfos(void *, char *);

public Q_SLOTS:
	void epgdialog_geometry_update(void);
	void epgdialog_geometry_start_update(void);
	void epgdialog_config_style_apply(bool initial);
	void epgdialog_send_dtvdbase_epginfos(void *protocol_data, char *currfilename);
	void epgdialog_send_scaninfos(void *protocol_data);
	void epgdialog_send_localfile_epginfos(void *protocol_data, char *currfilename);

protected:
	void closeEvent(QCloseEvent *);
	bool event(QEvent *event);

private:
	void epgdialog_open(void);
	void epgdialog_close(void);
	MainWindow *main_window;
	DispQtEPGTabWidget *epgtab_widget;
	QTimer timer_epgdialog_geometryupdate;
	QMutex mutex_epg_update, mutex_scan_update, mutex_epg_localfile_update;
};

extern void mpxplay_dispqt_dvbepg_program_start(struct dispqt_dvbepg_startstop_info_s *dvbinfo);

#endif // MOC_DVBEPG_H
