#ifndef MOC_SEEKBAR_H
#define MOC_SEEKBAR_H
 
#include <QWidget>
#include <QtWidgets>
#include "disp_qt.h"
#include "moc_video_qt.h"

QT_BEGIN_NAMESPACE
class MainWindow;
QT_END_NAMESPACE

#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
class DispQtSeekPreviewWidget : QWidget
{
	Q_OBJECT
public:
	DispQtSeekPreviewWidget(MainWindow *main_window, QWidget *parent);
	~DispQtSeekPreviewWidget();
	void show_window(int globalpos_x, int eventpos_x, int sliderpos_y, int seekbar_width);
	void refresh_window(int globalpos_x, int eventpos_x, int sliderpos_y, int seekbar_width);
	void fadeout_window_start(void);
	void hide_window(void);
	void paint_window(void *preview_frame_p);

protected:
	void paintEvent(QPaintEvent *e);
	bool event(QEvent *event);
	void keyPressEvent(QKeyEvent *event);

private Q_SLOTS:
	void timeout_seek_activate(void);
	void fadeout_window_timerfunc(void);

private:
	void reset_window(void);
	unsigned long get_aspectratio_type(void);
	void set_window_size(void);

	MainWindow *main_window;
	QWidget *parent_window;
	AVFrame *decoded_video_frame, *output_video_frame;
	mpxp_ptrsize_t initiated_seekpos, requested_seekpos;
	int window_size_x, window_size_y, screen_max_x, screen_pos_x0;
	int opacity_curr;
	bool switch_on_window, clear_window;
	QTimer timer_timeout, timer_interval, timer_fadeout;
};
#endif

class DispQtMainwinSeekslider : public QSlider
{
Q_OBJECT
public:
	DispQtMainwinSeekslider(MainWindow *main_window = 0, QWidget *parent = 0, bool control_bar = false);
	~DispQtMainwinSeekslider();
	void mainwin_seekslider_config_style_apply(bool);
	void mainwin_seekslider_set_timelen(int timelen);
	void mainwin_seekslider_set_timepos(int);
	void seekslider_preview_send(void *preview_frame_p);
	void seekslider_preview_hide(void);

protected:
	void wheelEvent(QWheelEvent *event);
	void mousePressEvent(QMouseEvent *event);
	void mouseReleaseEvent(QMouseEvent *event);
	void mouseMoveEvent(QMouseEvent *event);
	bool event(QEvent *event);
	void keyPressEvent(QKeyEvent *event);

private:
	void seekbar_show_timepos_and_seekpreview(int cursor_globalpos_x, int cursor_widgetpos_x);
	MainWindow *main_window;
	QWidget *parent_widget;
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	DispQtSeekPreviewWidget *seek_preview;
#endif
	bool is_control_bar;
	bool mouse_is_pressed, mouse_is_moved_while_pressed;
	int time_len_ms, last_mousecursor_globalpos_x, last_mousecursor_widgetpos_x;
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	QPalette tooltip_palette;
#endif
	char tooltip_time_text[32];
};

class DispQtMainwinSeekbar : public QWidget
{
Q_OBJECT
public:
	DispQtMainwinSeekbar(MainWindow *main_window = 0, QWidget *parent = 0);
	void mainwinseekbar_set_currfileinfos(struct dispqt_currfileinfo_s *cur);

Q_SIGNALS:
	//void signal_mainwinseekbar_config_style_apply(bool lucent_enable);
	void signal_mainwinseekbar_set_timepos(int);
	void signal_mainwinseekbar_option_timemode_change(unsigned int);

public Q_SLOTS:
	void mainwinseekbar_config_style_apply(bool);
	void mainwinseekbar_set_timepos(int);
	void mainwinseekbar_option_timemode_change(unsigned int);
	void mainwinseekbar_timelabel_change_timemode(void);

private:
	MainWindow *main_window;
	QHBoxLayout *layout_seekbar;
	DispQtMainwinSeekslider *seek_slider;
	QLabel *label_songnums, *label_times;
	//QPushButton *label_songnums, *label_times;
	int time_len_ms;
	unsigned int time_display_mode;
	QMutex mutex_seekbar;
};


#endif // MOC_SEEKBAR_H
