REM
REM RefreshScreen(startx, starty, endx, endy)
REM Display the content of BigScreenBuffer onscreen
REM

SUB RefreshScreen(startx AS INTEGER, starty AS INTEGER, endx AS INTEGER, endy AS INTEGER)
  DIM AS INTEGER x, y, RenderStep = 1
  IF DraftModeFlag = 1 OR DraftModeFlag = -1 THEN RenderStep = 2
  FOR y = starty TO endy
    SCREENLOCK()
    IF ColorDepth = 8 THEN
        LINE (startx - DisplayOffsetX, y - DisplayOffsetY)-(endx - DisplayOffsetX, y - DisplayOffsetY), 0
        FOR x = startx TO endx STEP RenderStep
          IF BigScreenBuffer(x, y) > 0 THEN PSET (x - DisplayOffsetX, y - DisplayOffsetY), BigScreenBuffer(x, y)
        NEXT x
      ELSE
        LINE (startx - DisplayOffsetX, y - DisplayOffsetY)-(endx - DisplayOffsetX, y - DisplayOffsetY), AnsiPallette(0)
        FOR x = startx TO endx STEP RenderStep
          IF BigScreenBuffer(x, y) > 0 THEN PSET (x - DisplayOffsetX, y - DisplayOffsetY), AnsiPallette(BigScreenBuffer(x, y))
        NEXT x
    END IF
    SCREENUNLOCK()
  NEXT y
  IF DraftModeFlag = -1 THEN DraftModeFlag = 1
  SLEEP 1, 1 ' Doesn't harm to release the CPU once a while
END SUB
