REM
REM Saves the content of BigScreenBuffer to OutFile as a BMP graphic file.
REM Returns 0 if everything went fine, non-zero if a problem occured.
REM


FUNCTION SaveBmpFile(BYREF OutFile AS STRING, BYREF xlimit AS INTEGER, BYREF ylimit AS INTEGER) AS BYTE
  DIM AS BYTE Result = 0
  DIM AS INTEGER x, y, BmpFileHandler', xlimitbound
  BmpFileHandler = FREEFILE
  IF xlimit MOD 4 <> 0 OR ylimit MOD 4 <> 0 THEN ' Must be a multiple of 4, to avoid
      Result = 1                                 ' BMP 4-bytes boundary troubles.
    ELSE
      OPEN OutFile FOR OUTPUT AS BmpFileHandler
      REM Write BMP header
      PRINT #BmpFileHandler, "BM";
      PRINT #BmpFileHandler, IntToDWORD((xlimit * ylimit * 3) + 54 + 1024); 'here write the size of the file, in bytes (4 bytes)
      PRINT #BmpFileHandler, CHR(0,0,0,0);  ' Future use bytes (just leave zeroes there)
      PRINT #BmpFileHandler, IntToDWORD(54 + 1024); ' Offset where BMP data starts (offset 54 + palette size)
      PRINT #BmpFileHandler, CHR(40,0,0,0); ' size of info header (40 bytes)
      PRINT #BmpFileHandler, IntToDWORD(xlimit); ' image width (in 4 bytes)
      PRINT #BmpFileHandler, IntToDWORD(ylimit); ' image height (in 4 bytes)
      PRINT #BmpFileHandler, CHR(1,0); ' Number of planes (always set to 1)
      PRINT #BmpFileHandler, CHR(8,0); ' BPP count (in 2 bytes)
      PRINT #BmpFileHandler, CHR(0,0,0,0); ' Compression type (0 for no compression)
      PRINT #BmpFileHandler, IntToDWORD(xlimit * ylimit); ' Size of BMP image data
      PRINT #BmpFileHandler, CHR(0,0,0,0); ' X resolution pixels/meter (zero is okay)
      PRINT #BmpFileHandler, CHR(0,0,0,0); ' Y resolution pixels/meter (zero is okay)
      PRINT #BmpFileHandler, CHR(0,0,0,0); ' Number of colors in palette (zero = no palette or full-depth palette)
      PRINT #BmpFileHandler, CHR(0,0,0,0); ' Number of "important" colors (zero = all are important)
      REM Write BMP palette
      FOR x = 0 TO 255
        PRINT #BmpFileHandler, CHR((AnsiPallette(x)) AND &b11111111); ' Write Blue value
        PRINT #BmpFileHandler, CHR((AnsiPallette(x) SHR 8) AND &b11111111); ' Write Green value
        PRINT #BmpFileHandler, CHR((AnsiPallette(x) SHR 16) AND &b11111111); ' Write Red value
        PRINT #BmpFileHandler, CHR(0);
      NEXT x
      REM Start writing datas...
      FOR y = ylimit - 1 TO 0 STEP -1
        FOR x = 0 TO xlimit - 1
          PRINT #BmpFileHandler, CHR(BigScreenBuffer(x, y));
        NEXT x
      NEXT y
      CLOSE #BmpFileHandler
    END IF
  RETURN Result
END FUNCTION
