    //CPIED version 1.3c
   // Balthasar Szczepaski Copyright 2013
  //
 //   This file is part of CPIED
//    
    //CPIED is free software: you can redistribute it and/or modify
   // it under the terms of the GNU General Public License as published by
  //  the Free Software Foundation, either version 3 of the License, or
 //   (at your option) any later version.
//
    //CPIED is distributed in the hope that it will be useful,
   // but WITHOUT ANY WARRANTY; without even the implied warranty of
  //  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 //   GNU General Public License for more details.
//
    //You should have received a copy of the GNU General Public License along
   // with CPIED (copying.txt).  If not, see <http://www.gnu.org/licenses/>.


#define BLACK   0
#define GRAY    8
#define BLUE    1
#define LBLUE   9
#define GREEN   2      
#define LGREEN 10
#define CYAN    3
#define LCYAN  11
#define RED     4
#define LRED   12
#define MAGEN   5
#define LMAGEN 13
#define BROWN   6
#define YELLOW 14
#define LGRAY   7
#define WHITE  15

//#define C_BACK BLACK
#define C_SET  BROWN
#define C_NON  RED
#define C_SEL  GREEN

#include <graph.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <mem.h>
#include <dos.h>
#include <bios.h>
#include <process.h>

#define resetMaus setMaus

//Structures in the CPI file format
struct FontFileHeader
{
	unsigned char id0;
	unsigned char id[7];
	unsigned char reserved[8];
	short pnum;
	unsigned char ptyp;
	long fih_offset;
};

struct FontInfoHeader
{
	short num_codepages;
};

struct CodePageEntryHeader
{
	short cpeh_size;
	long next_cpeh_offset;
	short device_type;
	unsigned char device_name[8];
	short codepage;
	unsigned char reserved[6];
	long cpih_offset;
};

struct CodePageInfoHeader
{
	short version;
	short num_fonts;
	short size;
};

struct ScreenFontHeader
{
	unsigned char height;
	unsigned char width;
	unsigned char yaspect;
	unsigned char xaspect;
	short num_chars;
};

struct char8
{
	unsigned char lin[8];
};

struct char14
{
	unsigned char lin[14];
};

struct char16
{
	unsigned char lin[16];
};

struct ScreenFontBitmap16
{
	char16 lit[256];
};

struct ScreenFontBitmap14
{
	char14 lit[256];
};

struct ScreenFontBitmap8
{
	char8 lit[256];
};

	int status;
	char nazwap[256]="Nie_wybrano_pliku";
	char err[256];
	unsigned char NOFONT[8]={
		0x80,
		0x00,
		0x08,
		0x00,
		0x80,
		0x00,
		0x08,
		0x00};
	unsigned char FULLF[8]={
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff};
	
	FILE *CPI;
	FontFileHeader *FFH;
	FontInfoHeader *FIH;
	CodePageEntryHeader *CPEH[16];
	CodePageInfoHeader *CPIH[16];
	ScreenFontHeader *SFH[16][3];
	ScreenFontBitmap16 *SFB16[16];
	ScreenFontBitmap14 *SFB14[16];
	ScreenFontBitmap8 *SFB8[16];

	int byo8[16];
	int byo14[16];
	int byo16[16];
	int wys=8;
	int prew;
	int cp=0;
	int lit=0x42;
	int pre;
	int curx=2;
	int cury=2;
	int prex;
	int prey;
	int key;
	int tab=0;
	int pret;
	int any=0;
	char abc[17]="0123456789ABCDEF";
	REGS iR;
	REGS oR;
	SREGS sR;
	int maus=0;
	int mausv=1;
	int mausx;
	int mausy;
	//int premx;
	//int premy;
	int klik;
	int prek;
	
void showMaus();
void hideMaus();
int  setMaus ();
void getMaus (int *x,int *y,int *k);

void nullpointers();
void offset      ();

void new8  ();
void menu8 ();
void cpwys (int mode=0);
void redraw();

void displayDialog(int  color, char     *text,  int type=0);
int      message  (char *text, char     *value, int type=1);
unsigned question (char *text, char     *result);
unsigned question (char *text, unsigned *result);

void ramka8 ();
void ramka14();
void ramka16();
void lin8 (int mode=0);
void lin14(int mode=0);
void lin16(int mode=0);
void lit8 (int mode=0);
void lit14(int mode=0);
void lit16(int mode=0);

void spc8 ();
void spc14();
void spc16();
void bsp8 ();
void bsp14();
void bsp16();
void ent8 ();
void ent14();
void ent16();

int  otw ();
int  otw2();
void otw3();

int  zap ();
int  zap2(int format=0);
void zap3();

void use3();

int  zmn ();
void zmn3();

int  newCPI ();
int  newCPI2(short CP, short h);
void newCPI3();

void deleteCPI(short st=6,short a=0,short b=0);

int  newCP ();
int  newCP2(short CP,short h);
void newCP3();

void normCP();
void nextCP();
void prevCP();

int  delCP ();
int  delCP2();
void delCP3();

int  newF  ();
int  newF2 (short h);
void newF3();
int  newF8 (short CP);
int  newF14(short CP);
int  newF16(short CP);

void prevF();
void nextF();

int  delF  ();
int  delF2 ();
void delF3 ();
int  delF8 (short h);
int  delF14(short h);
int  delF16(short h);

int main(int argc,char* argv[]);

void showMaus()
{
	iR.x.ax=0x0001;
	int86(0x33,&iR,&oR);
}
void hideMaus()
{
	iR.x.ax=0x0002;
	int86(0x33,&iR,&oR);
}
int setMaus()
{
	iR.x.ax=0x0000;
	oR.x.ax=0x0000;
	int86(0x33,&iR,&oR);
	return oR.x.ax;
}
void getMaus(int *x,int *y,int *k)
{
	iR.x.ax=0x0003;
	int86(0x33,&iR,&oR);
	*y=oR.x.dx;
	*x=oR.x.cx;
	*k=oR.x.bx;
}

void nullpointers()
{
	short i,j;
	CPI = NULL;
	FFH = NULL;
	FIH = NULL;
	for(i=0;i<16;++i)
	{
		CPEH[i] = NULL;
		CPIH[i] = NULL;
		for(j=0;j<3;++j)
		{
			SFH[i][j] = NULL;
		}
		SFB8[i] = NULL;
		SFB16[i] = NULL;
		SFB14[i] = NULL;
		byo8[i]=0;
		byo14[i]=0;
		byo16[i]=0;
	
	}
}
void offset()
{
	long off=0;
	short i,j,s;
	off+=sizeof(FontFileHeader);
	FFH->fih_offset=off;
	off+=sizeof(FontInfoHeader);
	for(i=0,s=0;i<FIH->num_codepages;++i,s=0)
	{
		off+=sizeof(CodePageEntryHeader);
		CPEH[i]->cpih_offset=off;
		off+=sizeof(CodePageInfoHeader);
		for(j=0;j<CPIH[i]->num_fonts;++j)
		{
			s+=sizeof(ScreenFontHeader);
			s+=SFH[i][j]->num_chars*SFH[i][j]->height*((SFH[i][j]->width+7)/8);
		}
		off+=s;
		CPIH[i]->size=s;
		if(i==FIH->num_codepages-1)
			CPEH[i]->next_cpeh_offset=0;
		else
			CPEH[i]->next_cpeh_offset=off;
	}

}
void new8()
{
	_clearscreen(_GCLEARSCREEN);
	_setcolor(C_SEL);
	_moveto(0,0);
	_outgtext("CPIED     1.3c");
	_moveto(0,8);
	_outgtext("");
}
void menu8()
{
	_setcolor(C_SEL);
	_moveto(609,449);
	_outgtext(",");
	_moveto(472,456);
	_outgtext("Balthasar Szczepanski");
	_moveto(0,464);
	_outgtext("");
	if(any)
	{
		_moveto(0,472);
		_outgtext("1.new2.save3.load4.use5.number6.newF7.newCP8.delF9.delCP10.end");
	}
	else
	{
		_moveto(0,472);
		_outgtext("1.new3.load10.end");
	}
}
void cpwys(int mode)
{
	char cpw[256];
	_setfillmask(FULLF);
	_setcolor(BLACK);
	_rectangle(_GFILLINTERIOR,120,0,639,7);
	if(any)
	{
		if((unsigned)(CPEH[cp]->codepage)>=1000)
		{
			if((unsigned)(CPEH[cp]->codepage)>=10000)
			{
				if(strlen(nazwap)<52)
					sprintf(cpw,"cp%03u8x%02d%s",CPEH[cp]->codepage,wys,nazwap);
				else
					sprintf(cpw,"cp%03u8x%02dpath too long",CPEH[cp]->codepage,wys);
			}
			else
			{
				if(strlen(nazwap)<52)
					sprintf(cpw,"cp%03u8x%02d%s",CPEH[cp]->codepage,wys,nazwap);
				else
					sprintf(cpw,"cp%03u8x%02dpath too long",CPEH[cp]->codepage,wys);
			}
		}
		else
		{
			if(strlen(nazwap)<52)
				sprintf(cpw,"cp%03u8x%02d%s",CPEH[cp]->codepage,wys,nazwap);
			else
				sprintf(cpw,"cp%03u8x%02dpath too long",CPEH[cp]->codepage,wys);
		}
	}
	else
		strcpy(cpw, "No CPI open");
	_setcolor(C_SEL);
	_moveto(120,0);
	_outgtext(cpw);
	if(mode||!any)
		return;
	for(short i=0;i<FIH->num_codepages;++i)
	{
		if(i==cp)
			_setcolor(C_SEL);
		else
			_setcolor(C_NON);
		_moveto(328+(i%6)*48,16+(i/6)*8);
		if((unsigned)(CPEH[i]->codepage)>=1000)
			sprintf(cpw,"%5u",CPEH[i]->codepage);
		else
			sprintf(cpw,"  %03u",CPEH[i]->codepage);
		_outgtext(cpw);
	}
}
void redraw()//
{
	cury&=7;
	new8();
	menu8();
	cpwys();
	ramka8();
	ramka14();
	ramka16();
	lin8();
	lin14();
	lin16();
	lit8();
	lit14();
	lit16();
	return;
}

void displayDialog(int color,char *text,int type)
{
	_settextposition(13,21);
	char t1[43]="";
	strcpy(t1+1,text);
	t1[strlen(t1)]='';
	_setfillmask(FULLF);
	_setcolor(BLACK);
	_rectangle(_GFILLINTERIOR,152,184,487,215);
	_setcolor(color);
	_moveto(152,184);
	_outgtext(t1);
	_moveto(152,192);
	_outgtext("                                        ");
	_moveto(152,200);
	_outgtext("                                        ");
	_moveto(152,208);
	switch(type)
	{
	case 3:
		_outgtext("y/n");
		break;
	case 2:
		_outgtext("again?(y/n)");
		break;
	case 1:
		_outgtext("anykey");
		break;
	case 0:
	default:
		_outgtext("");
		break;
	}
}
int message(char *text, char *value, int type)
{
	if (type<2)
	{
		displayDialog(C_SET,text,1);
		printf("%s",value);
		_bios_keybrd(_KEYBRD_READ);
		return 0;
	}
	else
	{
		displayDialog(C_SET,text,type);
		printf("%s",value);
		unsigned short a;
		for(;;)
		{
			a=_bios_keybrd(_KEYBRD_READ);
			if((a&0xFF)==0x59||(a&0xFF)==0x79)//y
				return 0;
			if((a&0xFF)==0x4e||(a&0xff)==0x6e)//n
				return 1;
		}
	}
}
unsigned question(char *text, char *result)
{
	unsigned short p=0;
	displayDialog(C_SEL,text);
	for(;;)
	{
		key=_bios_keybrd(_KEYBRD_READ);
		switch(key&0xFF00)
		{
		case 0x0100: //esc
			return 1;
		case 0x1c00: //enter
			if(!p)
				return 1;
			result[p]=0;
			return 0;
		case 0x0e00: //backspace
			if(p)
			{
				putch(8);
				putch(32);
				putch(8);
				--p;
			}
			break;
		default:
			if(key&=0x00FF)
			{
				result[p++]=key;
				putch(key);
			}
		}
	}
}
unsigned question(char *text, unsigned short *result)
{
	char temp[256];
	unsigned st;
	st=question(text,temp);
	if(!st)
		*result=atoi(temp);
	return st;
}

void ramka8()
{
	if(!any)
		return;
	if(tab==0&&wys==8)
		_setcolor(C_SEL);
	else
		_setcolor(C_NON);
	_rectangle(_GBORDER,15,31,144,160);
	if(tab!=0&&wys==8)
		_setcolor(C_SEL);
	else
		_setcolor(C_NON);
	_rectangle(_GBORDER,175,31,304,160);
}
void ramka14()
{
	if(!any)
		return;
	if(tab==0&&wys==14)
		_setcolor(C_SEL);
	else
		_setcolor(C_NON);
	_rectangle(_GBORDER,15,223,144,448);
	if(tab!=0&&wys==14)
		_setcolor(C_SEL);
	else
		_setcolor(C_NON);
	_rectangle(_GBORDER,175,223,304,448);
}
void ramka16()
{
	if(!any)
		return;
	if(tab==0&&wys==16)
		_setcolor(C_SEL);
	else
		_setcolor(C_NON);
	_rectangle(_GBORDER,335,111,464,368);
	if(tab!=0&&wys==16)
		_setcolor(C_SEL);
	else
		_setcolor(C_NON);
	_rectangle(_GBORDER,495,111,624,368);
}
void lin8(int mode)
{
	if(!any)
		return;
	if(mode==3)
	{
		if(SFB8[cp]->lit[lit].lin[cury]&(0x80>>curx))
			_setcolor(C_SEL);
		else
			_setcolor(BLACK);
		_setpixel(176+curx+((lit&15)<<3),32+cury+((lit>>4)<<3));
		return;
	}
	char ab[2]="X";
	short color1,color2;
	if(byo8[cp]==0)
	{
		_setfillmask(FULLF);
		_setcolor(BLACK);
		_rectangle(_GFILLINTERIOR,176,32,303,159);
		_setfillmask(NOFONT);
		_setcolor(C_NON);
		_rectangle(_GFILLINTERIOR,176,32,303,159);
		return;
	}
	if(wys==8)
	{
		color1=C_SEL;
		color2=C_SEL;
	}
	else
	{	
		color1=C_SET;
		color2=C_NON;
	}
	int l;
	switch(mode)
	{
	case 2:
		_setcolor(C_NON);
		if((pre&15)!=(lit&15))
		{
			ab[0]=abc[pre&15];
			_moveto(176+((pre&15)<<3),24);
			_outgtext(ab);
		}
		if(pre>>4!=lit>>4)
		{
			ab[0]=abc[pre>>4];
			_moveto(168,32+((pre>>4)<<3));
			_outgtext(ab);
		}
		_setfillmask(SFB8[cp]->lit[pre].lin);
		_setcolor(C_SET);
		_rectangle(_GFILLINTERIOR,176+((pre&15)<<3),32+((pre>>4)<<3),183+((pre&15)<<3),39+((pre>>4)<<3));
	
	
	case 3:
	case 1:
		_setcolor(color2);
		ab[0]=abc[lit&15];
		_moveto(176+((lit&15)<<3),24);
		_outgtext(ab);
		ab[0]=abc[lit>>4];
		_moveto(168,32+((lit>>4)<<3));
		_outgtext(ab);
		_setfillmask(SFB8[cp]->lit[lit].lin);
		_setcolor(color1);
		_rectangle(_GFILLINTERIOR,176+((lit&15)<<3),32+((lit>>4)<<3),183+((lit&15)<<3),39+((lit>>4)<<3));
		break;
	case 0:
	default:
		_setfillmask(FULLF);
		_setcolor(BLACK);
		_rectangle(_GFILLINTERIOR,176,32,303,159);
		for(l=0;l<16;++l)
		{
			ab[0]=abc[l];
			if((lit&15)==l)
				_setcolor(color2);
			else
				_setcolor(C_NON);
			_moveto(176+(l<<3),24);_outgtext(ab);
			if(lit>>4==l)
				_setcolor(color2);
			else
				_setcolor(C_NON);
			_moveto(168,32+(l<<3));_outgtext(ab);
		}
		for(l=0;l<256;++l)
		{
			if(l==lit)
				_setcolor(color1);
			else
				_setcolor(C_SET);
			_setfillmask(SFB8[cp]->lit[l].lin);
			_rectangle(_GFILLINTERIOR,176+((l&15)<<3),32+((l>>4)<<3),183+((l&15)<<3),39+((l>>4)<<3));
		}
		break;
	}
}
void lin14(int mode)
{
	if(!any)
		return;
	if(mode==3)
	{
		if(SFB14[cp]->lit[lit].lin[cury]&(0x80>>curx))
			_setcolor(C_SEL);
		else
			_setcolor(BLACK);
		_setpixel(176+curx+((lit&15)<<3),224+cury+(lit>>4)*14);
		return;
	}
	char ab[2]="X";
	short color1,color2;
	if(byo14[cp]==0)
	{
		_setfillmask(FULLF);
		_setcolor(BLACK);
		_rectangle(_GFILLINTERIOR,176,224,303,447);
		_setfillmask(NOFONT);
		_setcolor(C_NON);
		_rectangle(_GFILLINTERIOR,176,224,303,447);
		return;
	}
	if(wys==14)
	{
		color1=C_SEL;
		color2=C_SEL;
	}
	else
	{	
		color1=C_SET;
		color2=C_NON;
	}
	int a,l;
	switch(mode)
	{
	case 2:
		_setcolor(C_NON);
		if((pre&15)!=(lit&15))
		{
			ab[0]=abc[pre&15];
			_moveto(176+((pre&15)<<3),216);_outgtext(ab);
		}
		if(pre>>4!=lit>>4)
		{
			ab[0]=abc[pre>>4];
			_moveto(168,227+(pre>>4)*14);_outgtext(ab);
		}
		a=(pre>>4)&3;
		_setcolor(C_SET);
		if(a)
		{
			_setfillmask(SFB14[cp]->lit[pre].lin+(a<<1)-8);
			_rectangle(_GFILLINTERIOR,176+((pre&15)<<3),224+(pre>>4)*14,183+((pre&15)<<3),223+(a<<1)+(pre>>4)*14);
		}
		_setfillmask(SFB14[cp]->lit[pre].lin+(a<<1));
		_rectangle(_GFILLINTERIOR,176+((pre&15)<<3),224+(a<<1)+(pre>>4)*14,183+((pre&15)<<3),231+(a<<1)+(pre>>4)*14);
		if(a!=3)
		{
			_setfillmask(SFB14[cp]->lit[pre].lin+(a<<1)+8);
			_rectangle(_GFILLINTERIOR,176+((pre&15)<<3),232+(a<<1)+(pre>>4)*14,183+((pre&15)<<3),237+(pre>>4)*14);
		}
	case 3:
	case 1:
		_setcolor(color2);
		ab[0]=abc[lit&15];
		_moveto(176+((lit&15)<<3),216);_outgtext(ab);
		ab[0]=abc[lit>>4];
		_moveto(168,227+(lit>>4)*14);_outgtext(ab);
		a=(lit>>4)&3;
		_setcolor(color1);
		if(a)
		{
			_setfillmask(SFB14[cp]->lit[lit].lin+(a<<1)-8);
			_rectangle(_GFILLINTERIOR,176+((lit&15)<<3),224+(lit>>4)*14,183+((lit&15)<<3),223+(a<<1)+(lit>>4)*14);
		}
		_setfillmask(SFB14[cp]->lit[lit].lin+(a<<1));
		_rectangle(_GFILLINTERIOR,176+((lit&15)<<3),224+(a<<1)+(lit>>4)*14,183+((lit&15)<<3),231+(a<<1)+(lit>>4)*14);
		if(a!=3)
		{
			_setfillmask(SFB14[cp]->lit[lit].lin+(a<<1)+8);
			_rectangle(_GFILLINTERIOR,176+((lit&15)<<3),232+(a<<1)+(lit>>4)*14,183+((lit&15)<<3),237+(lit>>4)*14);
		}		
		break;
	case 0:
	default:
		_setfillmask(FULLF);
		_setcolor(BLACK);
		_rectangle(_GFILLINTERIOR,176,224,303,447);
		for(l=0;l<16;++l)
		{
			ab[0]=abc[l];
			if((lit&15)==l)
				_setcolor(color2);
			else
				_setcolor(C_NON);
			_moveto(176+(l<<3),216);
			_outgtext(ab);
			if(lit>>4==l)
				_setcolor(color2);
			else
				_setcolor(C_NON);
			_moveto(168,227+l*14);
			_outgtext(ab);
		}
		for(l=0;l<256;++l)
		{
			a=(l>>4)&3;
			if(l==lit)
				_setcolor(color1);
			else
				_setcolor(C_SET);
			if(a)
			{
				_setfillmask(SFB14[cp]->lit[l].lin+(a<<1)-8);
				_rectangle(_GFILLINTERIOR,176+((l&15)<<3),224+(l>>4)*14,183+((l&15)<<3),223+(a<<1)+(l>>4)*14);
			}
			_setfillmask(SFB14[cp]->lit[l].lin+(a<<1));
			_rectangle(_GFILLINTERIOR,176+((l&15)<<3),224+(a<<1)+(l>>4)*14,183+((l&15)<<3),231+(a<<1)+(l>>4)*14);
			if(a!=3)
			{
				_setfillmask(SFB14[cp]->lit[l].lin+(a<<1)+8);
				_rectangle(_GFILLINTERIOR,176+((l&15)<<3),232+(a<<1)+(l>>4)*14,183+((l&15)<<3),237+(l>>4)*14);
			}
			
		}
		break;
	}
}
void lin16(int mode)
{
	if(!any)
		return;
	if(mode==3)
	{
		if(SFB16[cp]->lit[lit].lin[cury]&(0x80>>curx))
			_setcolor(C_SEL);
		else
			_setcolor(BLACK);
		_setpixel(496+curx+((lit&15)<<3),112+cury+((lit>>4)<<4));
		return;
	}
	char ab[2]="X";
	short color1,color2;
	if(byo16[cp]==0)
	{
		_setfillmask(FULLF);
		_setcolor(BLACK);
		_rectangle(_GFILLINTERIOR,496,112,623,367);
		_setfillmask(NOFONT);
		_setcolor(C_NON);
		_rectangle(_GFILLINTERIOR,496,112,623,367);
		return;
	}
	if(wys==16)
	{
		color1=C_SEL;
		color2=C_SEL;
	}
	else
	{
		color1=C_SET;
		color2=C_NON;
	}
	int l;
	switch(mode)
	{
	case 2:
		_setcolor(C_NON);
		if((pre&15)!=(lit&15))
		{
			ab[0]=abc[pre&15];
			_moveto(496+((pre&15)<<3),104);
			_outgtext(ab);
		}
		if(pre>>4!=lit>>4)
		{
			ab[0]=abc[pre>>4];
			_moveto(488,116+((pre>>4)<<4));
			_outgtext(ab);
		}
		_setcolor(C_SET);
		_setfillmask(SFB16[cp]->lit[pre].lin);
		_rectangle(_GFILLINTERIOR,496+((pre&15)<<3),112+((pre>>4)<<4),503+((pre&15)<<3),119+((pre>>4)<<4));
		_setfillmask(SFB16[cp]->lit[pre].lin+8);
		_rectangle(_GFILLINTERIOR,496+((pre&15)<<3),120+((pre>>4)<<4),503+((pre&15)<<3),127+((pre>>4)<<4));
	case 3:	
	case 1:
		_setcolor(color2);
		ab[0]=abc[lit&15];
		_moveto(496+((lit&15)<<3),104);
		_outgtext(ab);
		ab[0]=abc[lit>>4];
		_moveto(488,116+((lit>>4)<<4));
		_outgtext(ab);
		_setcolor(color1);
		_setfillmask(SFB16[cp]->lit[lit].lin);
		_rectangle(_GFILLINTERIOR,496+((lit&15)<<3),112+((lit>>4)<<4),503+((lit&15)<<3),119+((lit>>4)<<4));
		_setfillmask(SFB16[cp]->lit[lit].lin+8);
		_rectangle(_GFILLINTERIOR,496+((lit&15)<<3),120+((lit>>4)<<4),503+((lit&15)<<3),127+((lit>>4)<<4));
		break;
	case 0:
	default:
		_setfillmask(FULLF);
		_setcolor(BLACK);
		_rectangle(_GFILLINTERIOR,496,112,623,367);
		for(l=0;l<16;++l)
		{
			ab[0]=abc[l];
			if((lit&15)==l)
				_setcolor(color2);
			else
				_setcolor(C_NON);
			_moveto(496+(l<<3),104);_outgtext(ab);
			if(lit>>4==l)
				_setcolor(color2);
			else
				_setcolor(C_NON);
			_moveto(488,116+(l<<4));_outgtext(ab);
		}
		for(l=0;l<256;++l)
		{
			if(l==lit)
				_setcolor(color1);
			else
				_setcolor(C_SET);
			_setfillmask(SFB16[cp]->lit[l].lin);
			_rectangle(_GFILLINTERIOR,496+((l&15)<<3),112+((l>>4)<<4),503+((l&15)<<3),119+((l>>4)<<4));
			_setfillmask(SFB16[cp]->lit[l].lin+8);
			_rectangle(_GFILLINTERIOR,496+((l&15)<<3),120+((l>>4)<<4),503+((l&15)<<3),127+((l>>4)<<4));
		}
		break;
	}
}
void lit8(int mode)
{
	if(!any)
		return;
	short color;
	_setcolor(C_NON);
	if(byo8[cp]==0)
	{
		_setfillmask(FULLF);
		_setcolor(BLACK);
		_rectangle(_GFILLINTERIOR,16,32,143,159);
		_setfillmask(NOFONT);
		_setcolor(C_NON);
		_rectangle(_GFILLINTERIOR,16,32,143,159);
		return;
	}
	char ab[2]="q";
	if(wys==8)
		color=C_SEL;
	else
		color=C_NON;
	_setfillmask(FULLF);
	switch(mode)
	{
	case 2:
		_setcolor(C_NON);
		if(curx!=prex)
		{
			ab[0]=abc[prex];
			_moveto(20+(prex<<4),24);
			_outgtext(ab);
		}
		if(prey<8)
		{
			if(cury!=prey)
			{
				ab[0]=abc[prey];
				_moveto(8,36+(prey<<4));
				_outgtext(ab);
			}
			if(SFB8[cp]->lit[lit].lin[prey]&(0x80>>prex))
				_setcolor(C_SET);
			else
				_setcolor(BLACK);
			_rectangle(_GFILLINTERIOR,16+(prex<<4),32+(prey<<4),31+(prex<<4),47+(prey<<4));
		}
	case 1:
		_setcolor(color);
		ab[0]=abc[curx];
		_moveto(20+(curx<<4),24);
		_outgtext(ab);
		if(cury<8)
		{
			ab[0]=abc[cury];
			_moveto(8,36+(cury<<4));
			_outgtext(ab);
			if(SFB8[cp]->lit[lit].lin[cury]&(0x80>>curx))
				_setcolor(C_SET);
			else
				_setcolor(BLACK);
			_rectangle(_GFILLINTERIOR,16+(curx<<4),32+(cury<<4),31+(curx<<4),47+(cury<<4));
			if(wys==8)
			{
				_setcolor(C_SEL);
				_rectangle(_GBORDER,16+(curx<<4),32+(cury<<4),31+(curx<<4),47+(cury<<4));
				_setcolor(BLACK);
				_rectangle(_GBORDER,17+(curx<<4),33+(cury<<4),30+(curx<<4),46+(cury<<4));
			}
		}
		break;
	case 0:
	default:
		for(int l=0;l<8;++l)
		{
			if(l==curx)
				_setcolor(color);
			else
				_setcolor(C_NON);
			ab[0]=abc[l];
			
			_moveto(20+(l<<4),24);
			_outgtext(ab);
			if(l==cury)
				_setcolor(color);
			else
				_setcolor(C_NON);
			ab[0]=abc[l];
			_moveto(8,36+(l<<4));
			_outgtext(ab);
		}
		for(int a=0;a<8;++a)
		{
			for(int b=0;b<8;++b)
			{
				if(SFB8[cp]->lit[lit].lin[a]&(0x80>>b))
					_setcolor(C_SET);
				else
					_setcolor(BLACK);
				_rectangle(_GFILLINTERIOR,16+(b<<4),32+(a<<4),31+(b<<4),47+(a<<4));
			}
		}
		if(wys==8)
		{
			_setcolor(C_SEL);
			_rectangle(_GBORDER,16+(curx<<4),32+(cury<<4),31+(curx<<4),47+(cury<<4));
			_setcolor(BLACK);
			_rectangle(_GBORDER,17+(curx<<4),33+(cury<<4),30+(curx<<4),46+(cury<<4));
		}
		break;
	}
}
void lit14(int mode)
{
	if(!any)
		return;
	short color;
	_setcolor(C_NON);
	if(byo14[cp]==0)
	{
		_setfillmask(FULLF);
		_setcolor(BLACK);
		_rectangle(_GFILLINTERIOR,16,224,143,447);
		_setfillmask(NOFONT);
		_setcolor(C_NON);
		_rectangle(_GFILLINTERIOR,16,224,143,447);
		return;
	}
	char ab[2]="q";
	if(wys==14)
		color=C_SEL;
	else
		color=C_NON;
	_setfillmask(FULLF);
	switch(mode)
	{
	case 2:
		_setcolor(C_NON);
		if(curx!=prex)
		{
			ab[0]=abc[prex];
			_moveto(20+(prex<<4),216);
			_outgtext(ab);
		}
		if(prey<14)
		{
			if(cury!=prey)
			{
				ab[0]=abc[prey];
				_moveto(8,228+(prey<<4));
				_outgtext(ab);
			}
			if(SFB14[cp]->lit[lit].lin[prey]&(0x80>>prex))
				_setcolor(C_SET);
			else
				_setcolor(BLACK);
			_rectangle(_GFILLINTERIOR,16+(prex<<4),224+(prey<<4),31+(prex<<4),239+(prey<<4));
		}
	case 1:
		_setcolor(color);
		ab[0]=abc[curx];
		_moveto(20+(curx<<4),216);
		_outgtext(ab);
		if(cury<14)
		{
			ab[0]=abc[cury];
			_moveto(8,228+(cury<<4));
			_outgtext(ab);
			if(SFB14[cp]->lit[lit].lin[cury]&(0x80>>curx))
				_setcolor(C_SET);
			else
				_setcolor(BLACK);
			_rectangle(_GFILLINTERIOR,16+(curx<<4),224+(cury<<4),31+(curx<<4),239+(cury<<4));
			if(wys==14)
			{
				_setcolor(C_SEL);
				_rectangle(_GBORDER,16+(curx<<4),224+(cury<<4),31+(curx<<4),239+(cury<<4));
				_setcolor(BLACK);
				_rectangle(_GBORDER,17+(curx<<4),225+(cury<<4),30+(curx<<4),238+(cury<<4));
			}
		}
		break;
	case 0:
	default:
		for(int l=0;l<14;++l)
		{
			if(l==curx)
				_setcolor(color);
			else
				_setcolor(C_NON);
			ab[0]=abc[l];
			if(l<8)
			{
				_moveto(20+(l<<4),216);
				_outgtext(ab);
			}
			if(l==cury)
				_setcolor(color);
			else
				_setcolor(C_NON);
			ab[0]=abc[l];
			_moveto(8,228+(l<<4));
			_outgtext(ab);
		}
		for(int a=0;a<14;++a)
		{
			for(int b=0;b<8;++b)
			{
				if(SFB14[cp]->lit[lit].lin[a]&(0x80>>b))
					_setcolor(C_SET);
				else
					_setcolor(BLACK);
				_rectangle(_GFILLINTERIOR,16+(b<<4),224+(a<<4),31+(b<<4),239+(a<<4));				
			}
		}
		if(wys==14)
		{
			_setcolor(C_SEL);
			_rectangle(_GBORDER,16+(curx<<4),224+(cury<<4),31+(curx<<4),239+(cury<<4));
			_setcolor(BLACK);
			_rectangle(_GBORDER,17+(curx<<4),225+(cury<<4),30+(curx<<4),238+(cury<<4));
		}
		break;
	}
}
void lit16(int mode)
{
	if(!any)
		return;
	short color;
	_setcolor(C_NON);
	if(byo16[cp]==0)
	{
		_setfillmask(FULLF);
		_setcolor(BLACK);
		_rectangle(_GFILLINTERIOR,336,112,463,367);
		_setfillmask(NOFONT);
		_setcolor(C_NON);
		_rectangle(_GFILLINTERIOR,336,112,463,367);
		return;
	}
	char ab[2]="q";
	if(wys==16)
		color=C_SEL;
	else
		color=C_NON;
	_setfillmask(FULLF);
	switch(mode)
	{
	case 2:
		_setcolor(C_NON);
		if(curx!=prex)
		{
			ab[0]=abc[prex];
			_moveto(340+(prex<<4),104);
			_outgtext(ab);
		}
		if(cury!=prey)
		{
			ab[0]=abc[prey];
			_moveto(328,116+(prey<<4));
			_outgtext(ab);
		}
		if(SFB16[cp]->lit[lit].lin[prey]&(0x80>>prex))
			_setcolor(C_SET);
		else
			_setcolor(BLACK);
		_rectangle(_GFILLINTERIOR,336+(prex<<4),112+(prey<<4),351+(prex<<4),127+(prey<<4));
	case 1:
		_setcolor(color);
		ab[0]=abc[curx];
		_moveto(340+(curx<<4),104);
		_outgtext(ab);
		ab[0]=abc[cury];
		_moveto(328,116+(cury<<4));
		_outgtext(ab);
		if(SFB16[cp]->lit[lit].lin[cury]&(0x80>>curx))
			_setcolor(C_SET);
		else
			_setcolor(BLACK);
		_rectangle(_GFILLINTERIOR,336+(curx<<4),112+(cury<<4),351+(curx<<4),127+(cury<<4));		
		if(wys==16)
		{
			_setcolor(C_SEL);
			_rectangle(_GBORDER,336+(curx<<4),112+(cury<<4),351+(curx<<4),127+(cury<<4));
			_setcolor(BLACK);
			_rectangle(_GBORDER,337+(curx<<4),113+(cury<<4),350+(curx<<4),126+(cury<<4));
		}
		break;
	case 0:
	default:
		for(int l=0;l<16;++l)
		{
			if(l==curx)
				_setcolor(color);
			else
				_setcolor(C_NON);
			ab[0]=abc[l];
			if(l<8)
			{
				_moveto(340+(l<<4),104);
				_outgtext(ab);
			}
			if(l==cury)
				_setcolor(color);
			else
				_setcolor(C_NON);
			ab[0]=abc[l];
			_moveto(328,116+(l<<4));
			_outgtext(ab);
		}
		for(int a=0;a<16;++a)
		{
			for(int b=0;b<8;++b)
			{
				if(SFB16[cp]->lit[lit].lin[a]&(0x80>>b))
					_setcolor(C_SET);
				else
					_setcolor(BLACK);
				_rectangle(_GFILLINTERIOR,336+(b<<4),112+(a<<4),351+(b<<4),127+(a<<4));
			}
		}
		if(wys==16)
		{
			_setcolor(C_SEL);
			_rectangle(_GBORDER,336+(curx<<4),112+(cury<<4),351+(curx<<4),127+(cury<<4));
			_setcolor(BLACK);
			_rectangle(_GBORDER,337+(curx<<4),113+(cury<<4),350+(curx<<4),126+(cury<<4));
		}
	}
}

inline void spc8()
{
	SFB8[cp]->lit[lit].lin[cury]^=0x80>>curx;
}
inline void spc14()
{
	SFB14[cp]->lit[lit].lin[cury]^=0x80>>curx;
}
inline void spc16()
{
	SFB16[cp]->lit[lit].lin[cury]^=0x80>>curx;
}
inline void bsp8()
{
	SFB8[cp]->lit[lit].lin[cury]&=~(0x80>>curx);
}
inline void bsp14()
{
	SFB14[cp]->lit[lit].lin[cury]&=~(0x80>>curx);
}
inline void bsp16()
{
	SFB16[cp]->lit[lit].lin[cury]&=~(0x80>>curx);
}
inline void ent8()
{
	SFB8[cp]->lit[lit].lin[cury]|=0x80>>curx;
}
inline void ent14()
{
	SFB14[cp]->lit[lit].lin[cury]|=0x80>>curx;
}
inline void ent16()
{
	SFB16[cp]->lit[lit].lin[cury]|=0x80>>curx;
}

int otw()
{
	if(question("Filename",nazwap)==1)
		return 1;
	//deleteCPI();
	return otw2();
}
int otw2()
{
	int a;
	int b;
	//int c;
	//int d;
	bool NT=false;
	bool CPX=false;
	
	CPI=fopen(nazwap,"rb");
	if(CPI==NULL)
	{
		sprintf(err,"100:No valid file at this path\n");
		return 100;
	}
	deleteCPI();
	FFH=new FontFileHeader;
	if(!FFH)
	{
		sprintf(err,"116:Not enough memory for FFH\n");
		fclose(CPI);
		return 116;
	}
	fread(FFH,0x19,1,CPI);
	if(FFH->id0!=0xff)
	{
		if(FFH->id0==0x81&&FFH->id[0]==0xfc)//Looks like a CPX
		{
			fclose(CPI);
			deleteCPI(0);
			//First, try using UPX
			status=spawnlp(P_WAIT,"upx","upx","-d","-q","-o__TEMP__.com",nazwap,NULL);
			if(status==-1)
			//There is no UPX installed, try using cpx2cpi
			{
				status=spawnlp(P_WAIT,"cpx2cpi","cpx2cpi",nazwap,"__TEMP__.com","q",NULL);
				if(status==-1)//and there is no cpx2cpi
				{
					sprintf(err,"150:CPX not supported, install cpx2cpi\n");
					return 150;
				}
				if(status)//not converted
				{
					sprintf(err,"151:CPX decompression failed");
					if (status<3)//but file is created
						remove("__TEMP__.com");
					return 151;
				}
				CPX=true;
				CPI=fopen("__TEMP__.com","rb");
				if(CPI==NULL)//converted to an unopenable file
				{
					sprintf(err,"152:Cannot open decompressed file");
					return 152;
				}
				FFH=new FontFileHeader;
				if(!FFH)
				{
					sprintf(err,"116:Not enough memory for FFH\n");
					fclose(CPI);
					remove("__TEMP__.com");
					return 116;
				}
				fread(FFH,0x19,1,CPI);
				if(FFH->id0!=0xff)
				//converted to cpi but it's not a cpi
				{
					sprintf(err,"101:Unsupported format, id0=0x%02x\n",(short)(FFH->id0&0xff));
					fclose(CPI);
					remove("__TEMP__.com");
					deleteCPI(0);
					return 101;
				}
			}
			else//there is upx installed
			{
				if(status)//not converted
				{
					sprintf(err,"151:CPX decompression failed");
					//don't ktow if temp file created, delete anyway
					remove("__TEMP__.com");
					return 151;
				}
				CPX=true;
				CPI=fopen("__TEMP__.com","rb");
				if(CPI==NULL)//converted to an unopenable file
				{
					sprintf(err,"152:Cannot open decompressed file\n");
					return 152;
				}
				FFH=new FontFileHeader;
				if(!FFH)
				{
					sprintf(err,"116:Not enough memory for FFH\n");
					fclose(CPI);
					remove("__TEMP__.com");
					return 116;
				}
				fread(FFH,0x19,1,CPI);
				if(FFH->id0!=0xff)
				//converted to cpi but it's not a cpi
				{
					sprintf(err,"101:Unsupported format, id0=0x%02x\n",(short)(FFH->id0&0xff));
					fclose(CPI);
					remove("__TEMP__.com");
					deleteCPI(0);
					return 101;
				}
			}
		}
		else
		{
			sprintf(err,"101:Unsupported format, id0=0x%02x\n",(short)(FFH->id0&0xff));
			fclose(CPI);
			deleteCPI(0);
			return 101;
		}
	}
	if(!strcmp("FONT   ",(char *)(FFH->id)))
		;
	else if(!strcmp("FONT.NT",(char *)(FFH->id)))
	{
		NT=true;
		FFH->id[4]=' ';
		FFH->id[5]=' ';
		FFH->id[6]=' ';
	}
	else
	{
		sprintf(err,"102:Unsupported format, id=\"%c%c%c%c%c%c%c\"\n",FFH->id[0],FFH->id[1],FFH->id[2],FFH->id[3],FFH->id[4],FFH->id[5],FFH->id[6]);
		fclose(CPI);
		if(CPX)
			remove("__TEMP__.com");
		deleteCPI(0);
		return 102;
	}
	if(FFH->pnum!=1)
	{
		sprintf(err,"103:Wrong no. of pointers (%u)\n",FFH->pnum);
		fclose(CPI);
		if(CPX)
			remove("__TEMP__.com");
		deleteCPI(0);
		return 103;
	}
	if(FFH->ptyp!=1)
	{
		sprintf(err,"104:Wrong pointer type, (%u)\n",(short)(FFH->ptyp&0xff));
		fclose(CPI);
		if(CPX)
			remove("__TEMP__.com");
		deleteCPI(0);
		return 104;
	}
	
	FIH=new FontInfoHeader;
	if(!FIH)
	{
		sprintf(err,"116:Not enough memory for FIH\n");
		fclose(CPI);
		if(CPX)
			remove("__TEMP__.com");
		deleteCPI(0);
		return 116;
	}
	fseek(CPI,FFH->fih_offset,0);
	fread(FIH,0x2,1,CPI);
	if(FIH->num_codepages>16)
	{
		sprintf(err,"105:Too many codepages (%u)\n",FIH->num_codepages);
		fclose(CPI);
		if(CPX)
			remove("__TEMP__.com");
		deleteCPI(1);
		return 105;
	}
	if(FIH->num_codepages==0)
	{
		sprintf(err,"117:No codepages\n");
		fclose(CPI);
		if(CPX)
			remove("__TEMP__.com");
		deleteCPI(1);
		return 117;
	}

	for(a=0; a<FIH->num_codepages;++a)
	{
		if (a!=0)
			fseek(CPI,CPEH[a-1]->next_cpeh_offset,0);
		CPEH[a] = new CodePageEntryHeader;
		if(!CPEH[a])
		{
			sprintf(err,"116:Not enough memory for CPEH[%d]\n",a);
			fclose(CPI);
			if(CPX)
				remove("__TEMP__.com");
			deleteCPI(1);
			return 116;
		}
		fread(CPEH[a],0x1c,1,CPI);
		if(NT)
		{
			CPEH[a]->next_cpeh_offset+=ftell(CPI)-sizeof(CodePageEntryHeader);
			CPEH[a]->cpih_offset+=ftell(CPI)-sizeof(CodePageEntryHeader);
		}
		if(CPEH[a]->cpeh_size!=0x1c)
		{
			sprintf(err,"106:Wrong CPEH[%u] size (0x%x)\n",a,CPEH[a]->cpeh_size);
			fclose(CPI);
			if(CPX)
				remove("__TEMP__.com");
			deleteCPI(2,a);
			return 106;
		}
		if(CPEH[a]->device_type!=1)
		{
			sprintf(err,"107:Wrong device type(%u) in cp%03u\n",CPEH[a]->device_type,CPEH[a]->codepage);
			fclose(CPI);
			if(CPX)
				remove("__TEMP__.com");
			deleteCPI(2,a);
			return 107;
		}
		for(short i=0;i<a;++i)
		{
			if(CPEH[a]->codepage==CPEH[i]->codepage)
			{
				sprintf(err,"114:cp%03u duplicated in this CPI\n",CPEH[a]->codepage);
				fclose(CPI);
				if(CPX)
					remove("__TEMP__.com");
				deleteCPI(2,a);
				return 114;
			}
		}
		
		fseek(CPI,CPEH[a]->cpih_offset,0);
		CPIH[a] = new CodePageInfoHeader;
		if(!CPIH[a])
		{
			sprintf(err,"116:Not enough memory for CPIH[%d]\n",a);
			fclose(CPI);
			if(CPX)
				remove("__TEMP__.com");
			deleteCPI(2,a);
			return 116;
		}
		fread(CPIH[a],0x6,1,CPI);
		if(CPIH[a]->version!=1)
		{
			sprintf(err,"108:Wrong version of CPIH[%u] (%u)\n",a,CPIH[a]->version);
			fclose(CPI);
			if(CPX)
				remove("__TEMP__.com");
			deleteCPI(3,a);
			return 108;
		}
		if(CPIH[a]->num_fonts>3)
		{
			sprintf(err,"109:Too many fonts in cp%03u (%u)\n",CPEH[a]->codepage,CPIH[a]->num_fonts);
			fclose(CPI);
			if(CPX)
				remove("__TEMP__.com");
			deleteCPI(3,a);
			return 109;
		}
		if(CPIH[a]->num_fonts==0)
		{
			sprintf(err,"115:No fonts in cp%03u\n",CPEH[a]->codepage);
			fclose(CPI);
			if(CPX)
				remove("__TEMP__.com");
			deleteCPI(3,a);
			return 115;
		}
		
		for(b=0;b<CPIH[a]->num_fonts;++b)
		{
			SFH[a][b] = new ScreenFontHeader;
			if(!SFH[a][b])
			{
				sprintf(err,"116:Not enough memory for SFH[%d][%d]\n",a);
				fclose(CPI);
				if(CPX)
					remove("__TEMP__.com");
				if(b==0)
					deleteCPI(3,a);
				else
					deleteCPI(5,a,b-1);
				return 116;
			}
			fread(SFH[a][b],0x6,1,CPI);
			if(SFH[a][b]->height==8)
			{
				if (byo8[a]!=0)
				{
					sprintf(err,"113:Height 8 duplicated in cp%03u\n",CPEH[a]->codepage);
					fclose(CPI);
					if(CPX)
						remove("__TEMP__.com");
					deleteCPI(4,a,b);
					return 113;
				}
				byo8[a]=1;
			}
			if(SFH[a][b]->height==14)
			{
				if (byo14[a]!=0)
				{
					sprintf(err,"113:Height 14 duplicated in cp%03u\n",CPEH[a]->codepage);
					fclose(CPI);
					if(CPX)
						remove("__TEMP__.com");
					deleteCPI(4,a,b);
					return 113;
				}
				byo14[a]=1;
			}
			if(SFH[a][b]->height==16)
			{
				if (byo16[a]!=0)
				{
					sprintf(err,"113:Height 16 duplicated in cp%03u\n",CPEH[a]->codepage);
					fclose(CPI);
					if(CPX)
						remove("__TEMP__.com");
					deleteCPI(4,a,b);
					return 113;
				}
				byo16[a]=1;
			}
			if(SFH[a][b]->height!=8&&SFH[a][b]->height!=14&&SFH[a][b]->height!=16)
			{
				sprintf(err,"110:Wrong height (%u) in cp%03u\n",(short)(SFH[a][b]->height&0xff),CPEH[a]->codepage);
				fclose(CPI);
				if(CPX)
					remove("__TEMP__.com");
				deleteCPI(4,a,b);
				return 110;
			}
			if(SFH[a][b]->width!=8)
			{
				sprintf(err,"111:Wrong width (%u) in cp%03u\n",(short)(SFH[a][b]->width&0xff),CPEH[a]->codepage);
				fclose(CPI);
				if(CPX)
					remove("__TEMP__.com");
				deleteCPI(4,a,b);
				return 111;
			}
			if(SFH[a][b]->num_chars!=256)
			{
				sprintf(err,"112:Wrong no.of chars(%u)in cp%03ux%02u\n",SFH[a][b]->num_chars,CPEH[a]->codepage,SFH[a][b]->height);
				fclose(CPI);
				if(CPX)
					remove("__TEMP__.com");
				deleteCPI(4,a,b);
				return 112;
			}
			if(SFH[a][b]->height==16)
			{
				SFB16[a] = new ScreenFontBitmap16;
				if(!SFB16[a])
				{
					sprintf(err,"116:Not enough memory for SFB16[%d] (%d)\n",a,b);
					fclose(CPI);
					if(CPX)
						remove("__TEMP__.com");
					deleteCPI(4,a,b);
					return 116;
				}
				fread(SFB16[a],0x10,256,CPI);
			}
			if(SFH[a][b]->height==14)
			{
				SFB14[a] = new ScreenFontBitmap14;
				if(!SFB14[a])
				{
					sprintf(err,"116:Not enough memory for SFB14[%d] (%d)\n",a,b);
					fclose(CPI);
					if(CPX)
						remove("__TEMP__.com");
					deleteCPI(4,a,b);
					return 116;
				}
				fread(SFB14[a],0x0e,256,CPI);
			}
			if(SFH[a][b]->height==8)
			{
				SFB8[a] = new ScreenFontBitmap8;
				if(!SFB8[a])
				{
					sprintf(err,"116:Not enough memory for SFB8[%d] (%d)\n",a,b);
					fclose(CPI);
					if(CPX)
						remove("__TEMP__.com");
					deleteCPI(4,a,b);
					return 116;
				}
				fread(SFB8[a],0x08,256,CPI);
			}
		}
	}
	fclose(CPI);
	if(CPX)
		remove("__TEMP__.com");
	offset();
	return 0;
}
void otw3()//
{
	_setcolor(C_NON);
	_moveto(136,472);
	_outgtext("load");
	status=otw();
	switch(status)
	{
	case 100: //not loaded but nothing is lost
		message("CPI file not loaded",err);
	case 1: //cancelled
		redraw();
		return;
	case 0: //success
		any=1;
		cp=0;
		if(byo8[0])
			wys=8;
		else if(byo16[0])
			wys=16;
		else if(byo14[0])
			wys=14;
		redraw();
		return;
	default: //fail
		message("CPI file not loaded",err);
		any=0;
		redraw();
		return;
	}
}

int zap()
{
	int c;
	if(question("Filename",nazwap)==1)
		return 1;
	int format;
	c=strlen(nazwap)-4;
	if(!strcmpi(nazwap+c,".cpx"))
		format=1;
	else if(!strcmpi(nazwap+c,".cpi"))
		format=0;
	else if(message("WARNING","Unknown extension,save in CPI format?\n",3)==1)
		return 1;
	else
		format=0;
	return zap2(format);
}

int zap2(int format)
{
	//CPI - 0
	//CPX - 1;
	int a;
	int b;
	if(format==1)
	{
		CPI=fopen("__TEMP__.com","wb");
		if(CPI==NULL)
		{
			sprintf(err,"252:Cannot create temporary CPI file\n");
			return 252;
		}
	}
	else
	{
		CPI=fopen(nazwap,"wb");
		if(CPI==NULL)
		{
			sprintf(err,"200:Cannot create file at this path\n");
			return 200;
		}
	}
	fwrite(FFH,0x19,1,CPI);
	
	fseek(CPI,FFH->fih_offset,0);
	fwrite(FIH,0x2,1,CPI);
	
	for(a=0; a<FIH->num_codepages;++a)
	{
		if (a!=0)
			fseek(CPI,CPEH[a-1]->next_cpeh_offset,0);
		fwrite(CPEH[a],0x1c,1,CPI);

		fseek(CPI,CPEH[a]->cpih_offset,0);
		fwrite(CPIH[a],0x6,1,CPI);
		
		for(b=0;b<CPIH[a]->num_fonts;++b)
		{
			fwrite(SFH[a][b],0x6,1,CPI);
			if(SFH[a][b]->height==16)
				fwrite(SFB16[a],0x10,256,CPI);
			if(SFH[a][b]->height==14)
			{
				fwrite(SFB14[a],0x0e,256,CPI);
			}
			if(SFH[a][b]->height==8)
			{
				fwrite(SFB8[a],0x08,256,CPI);
			}
		}
	}

	fprintf(CPI,"\r\nThis file was created with CPIED 1.3c.%c",0x1a);
	fclose(CPI);
	if(format==1)
	{
		status=spawnlp(P_WAIT,"upx","upx","-q","-o",nazwap,"__TEMP__.com",NULL);
		if(status==-1)
		{
			sprintf(err,"250:CPX not supported, UPX required\n");
			return 250;
		}
		if(status)
		{
			sprintf(err,"251:CPX compression failed\n");
			remove("__TEMP__.com");
			return 251;
		}
		remove("__TEMP__.com");
	}
	return 0;
}
void zap3()//
{
	_setcolor(C_NON);
	_moveto(72,472);
	_outgtext("save");
	status=zap();
	if(status>1)
		message("CPI file not saved",err);
	redraw();
	return;
}

void use3()///needs to be improved
{
	_setcolor(C_NON);
	_moveto(72,472);
	_outgtext("save            use");
	status=zap();
	if(status>1)
		message("CPI file not saved",err);
	if(status==0)
	{
		_setvideomode(_DEFAULTMODE);
		sprintf(err,"mode con:cp prep=((%u) %s)",CPEH[cp]->codepage,nazwap);
		puts(err);
		system(err);
		sprintf(err,"mode con:cp sel=%u",CPEH[cp]->codepage);
		puts(err);
		system(err);
		//delay(5000);
		//closegraph();
		//initgraph(&kart16,&tryb16,"");
		_setvideomode(_VRES16COLOR);

	}
	redraw();
	return;
}

int zmn()
{
	unsigned short CP;
	if(question("Codepage number",&CP)==1)
		return 1;
	for(short i=0;i<FIH->num_codepages;++i)
	{
		if(CP==CPEH[i]->codepage&&i!=cp)
		{
			sprintf(err,"314:cp%03u already in this CPI\n",CP);
			return 314;
		}
	}
	CPEH[cp]->codepage=CP;
	return  0;
}
void zmn3()//
{
	_setcolor(C_NON);
	_moveto(256,472);
	_outgtext("number");
	status=zmn();
	if(status>1)
		message("Number not changed",err);
	redraw();
}

int newCPI()
{
	unsigned short CP,h;
	//char temp[51];
	if(question("First codepage number:",&CP)==1)
		return 1;
	if(question("Initial font height(8,14,16,all)",&h)==1)
		return 1;
	if(h!=0&&h!=8&&h!=14&&h!=16)
	{
		sprintf(err,"310:Wrong height (%u)\n",h);
		return 310;
	}
	return newCPI2(CP,h);
}
int newCPI2(short CP, short h)
{
	int t;
	deleteCPI();
	FFH=new FontFileHeader;
	if(!FFH)
	{
		sprintf(err,"316:Not enough memory for FFH\n");
		return 316;
	}
	FFH->id0=0xFF;
	strcpy((char *)(FFH->id),"FONT   ");
	strcpy((char *)(FFH->reserved),"\0\0\0\0\0\0\0");
	FFH->pnum=1;
	FFH->ptyp=1;
	FIH=new FontInfoHeader;
	if(!FIH)
	{
		sprintf(err,"316:Not enough memory for FIH\n");
		deleteCPI(0);
		return 316;
	}
	FIH->num_codepages=0;
	t = newCP2(CP,h);
	if (t!=0)
	{
		deleteCPI(1);
		return t;
	}
	sprintf(err,"0:Ok");
	return 0;
}
void newCPI3()//
{
	_setcolor(C_NON);
	_moveto(16,472);
	_outgtext("new");
	status=newCPI();
	switch(status)
	{
	case 310: //not created but nothing is lost
		message("CPI not created",err);
	case 1: //cancelled
		redraw();
		return;
	case 0: //success
		any=1;
		strcpy(nazwap,"new CPI");
		cp=0;
		if(byo8[0])
			wys=8;
		else if(byo16[0])
			wys=16;
		else if(byo14[0])
			wys=14;
		cury&=7;
		redraw();
		return;
	default: //fail
		message("CPI not created",err);
		any=0;
		redraw();
		return;
	}
}

void deleteCPI(short st,short a,short b)
{
	short i,j;
	switch(st)
	{
	case 6:
		if(FIH==NULL)
			return;
		a=FIH->num_codepages-1;
		b=CPIH[a]->num_fonts-1;
	case 5:
		switch(SFH[a][b]->height)
		{
		case 8:
			delete SFB8[a];
			SFB8[a] = NULL;
			byo8[a] = 0;
			break;
		case 14:
			delete SFB14[a];
			SFB14[a] = NULL;
			byo14[a] = 0;
			break;
		case 16:
			delete SFB16[a];
			SFB16[a] = NULL;
			byo16[a] = 0;
			break;
		}
	case 4:
		delete SFH[a][b];
		SFH[a][b] = NULL;
		for(j=0;j<b;++j)
		{
			switch(SFH[a][j]->height)
			{
			case 8:
				delete SFB8[a];
				SFB8[a] = NULL;
				byo8[a] = 0;
				break;
			case 14:
				delete SFB14[a];
				SFB14[a] = NULL;
				byo14[a] = 0;
				break;
			case 16:
				delete SFB16[a];
				SFB16[a] = NULL;
				byo16[a] = 0;
				break;
			}
			delete SFH[a][j];
			SFH[a][j] = NULL;
		}
	case 3:
		delete CPIH[a];
		CPIH[a] = NULL;
	case 2:
		delete CPEH[a];
		CPEH[a] = NULL;
		for(i=0;i<a;++i)
		{
			for(j=0;j<CPIH[i]->num_fonts;++j)
			{
				switch(SFH[i][j]->height)
				{
				case 8:
					delete SFB8[i];
					SFB8[i] = NULL;
					byo8[i] = 0;
					break;
				case 14:
					delete SFB14[i];
					SFB14[i] = NULL;
					byo14[i] = 0;
					break;
				case 16:
					delete SFB16[i];
					SFB16[i] = NULL;
					byo16[i] = 0;
					break;
				}
				delete SFH[i][j];
				SFH[i][j] = NULL;
			}
			delete CPIH[i];
			delete CPEH[i];
			CPIH[i] = NULL;
			CPEH[i] = NULL;
		}
	case 1:
		delete FIH;
		FIH = NULL;
	case 0:
		delete FFH;
		FFH = NULL;
	}
}

int newCP()
{
	unsigned short CP,h;
	//char temp[51];
	if(FIH->num_codepages>=16)
	{
		sprintf(err,"305:Already 16 codepages in this CPI\n");
		return 305;
	}
	if(question("Codepage number:",&CP)==1)
		return 1;
	for(short i=0;i<FIH->num_codepages;++i)
	{
		if(CP==CPEH[i]->codepage)
		{
			sprintf(err,"314:cp%03u already in this CPI\n",CP);
			return 314;
		}
	}
	if(question("Initial font height(8,14,16,all)",&h)==1)
		return 1;
	if(h!=0&&h!=8&&h!=14&&h!=16)
	{
		sprintf(err,"310:Wrong height (%u)\n",h);
		return 310;
	}
	return newCP2(CP,h);
}
int newCP2(short CP,short h)
{
	int t;
	if(!(CPEH[FIH->num_codepages] = new CodePageEntryHeader))
	{
		sprintf(err,"316:Not enough memory for CPEH[%d]\n",FIH->num_codepages);
		return 316;
	}
	if(!(CPIH[FIH->num_codepages] = new CodePageInfoHeader))
	{
		delete CPEH[FIH->num_codepages];
		CPEH[FIH->num_codepages] = NULL;
		sprintf(err,"316:Not enough memory for CPIH[%d]\n",FIH->num_codepages);
		return 316;
	}
	CPEH[FIH->num_codepages]->cpeh_size=0x1c;
	CPEH[FIH->num_codepages]->device_type=1;
	strcpy((char *)(CPEH[FIH->num_codepages]->device_name),"EGA    ");
	CPEH[FIH->num_codepages]->device_name[7]=' ';
	CPEH[FIH->num_codepages]->codepage=CP;
	strcpy((char *)(CPEH[FIH->num_codepages]->reserved),"\0\0\0\0\0");
	CPIH[FIH->num_codepages]->version=1;
	CPIH[FIH->num_codepages]->num_fonts=0;
	switch(h)
	{
	case 8:
		t= newF8(FIH->num_codepages);
		break;
	case 14:
		t= newF14(FIH->num_codepages);
		break;
	case 16:
		t = newF16(FIH->num_codepages);
		break;
	case 0:
		t= newF16(FIH->num_codepages);
		if(t!=0)
			break;
		t= newF14(FIH->num_codepages);
		if(t!=0)
		{
			delete SFB16[FIH->num_codepages];
			delete SFH[FIH->num_codepages][0];
			SFB16[FIH->num_codepages] = NULL;
			SFH[FIH->num_codepages][0] = NULL;
			byo16[FIH->num_codepages] = 0;
			break;
		}
		t= newF8(FIH->num_codepages);
		if(t!=0)
		{
			delete SFB16[FIH->num_codepages];
			delete SFB14[FIH->num_codepages];
			delete SFH[FIH->num_codepages][0];
			delete SFH[FIH->num_codepages][1];
			SFB16[FIH->num_codepages] = NULL;
			SFB14[FIH->num_codepages] = NULL;
			SFH[FIH->num_codepages][0] = NULL;
			SFH[FIH->num_codepages][1] = NULL;
			byo16[FIH->num_codepages] = 0;
			byo14[FIH->num_codepages] = 0;
			break;
		}
		break;
	default:
		sprintf(err,"510:%u ***?",h);
		t = 510;
	}
	if(t!=0)
	{
		delete CPIH[FIH->num_codepages];
		delete CPEH[FIH->num_codepages];
		CPEH[FIH->num_codepages] = NULL;
		CPEH[FIH->num_codepages] = NULL;
		return t;
	}
	++(FIH->num_codepages);
	sprintf(err,"0:OK");
	return 0;
}
void newCP3()//
{
	_setcolor(C_NON);
	_moveto(400,472);
	_outgtext("newCP");
	status=newCP();
	switch(status)
	{
	case 305:
	case 310:
	case 314:
		message("Codepage not created",err);
	case 1:
		redraw();
		return;
	case 0:
		cp=FIH->num_codepages-1;
		offset();
		new8();
		menu8();
		normCP();
		return;
	default:
		message("Codepage not created",err);
		offset();
		redraw();
		return;		
	}
}

void normCP()//
{
	prex=curx;
	prey=cury;
	
	if(wys==8&&byo8[cp]==0)
	{
		if(byo14[cp]!=0)
			wys=14;
		else if(byo16[cp]!=0)
			wys=16;
	}
	else if(wys==14&&byo14[cp]==0)
	{
		if(byo16[cp]!=0)
			wys=16;
		else if(byo8[cp]!=0)
			wys=8;
	}
	else if(wys==16&&byo16[cp]==0)
	{
		if(byo8[cp]!=0)
			wys=8;
		else if(byo14[cp]!=0)
			wys=14;
	}
	cury&=0x7;
	ramka8();
	ramka14();
	ramka16();
	cpwys();
	lin8();
	lin14();
	lin16();
	lit8();
	lit14();
	lit16();
	
	return;
}
void nextCP()//
{
	++cp;
	cp%=FIH->num_codepages;
	normCP();
	return;
}
void prevCP()//
{
	cp+=FIH->num_codepages-1;
	cp%=FIH->num_codepages;
	normCP();	
	return;
}

int  delCP()
{
	char temp[41];
	if(FIH->num_codepages<=1)
	{
		sprintf(err,"317:Last codepage\n");
		return 317;
	}
	sprintf(temp,"Delete cp%03u?\n",CPEH[cp]->codepage);
	if(message("WARNING",temp,3)==1)
		return 1;
	return delCP2();
}
int delCP2()
{
	short i;
	for(i=0;i<CPIH[cp]->num_fonts;++i)
	{
		switch(SFH[cp][i]->height)
		{
		case 16:
			delete SFB16[cp];
			break;
		case 14:
			delete SFB14[cp];
			break;
		case 8:
			delete SFB8[cp];
			break;
		}
		delete SFH[cp][i];
	}
	delete CPIH[cp];
	delete CPEH[cp];
	
	--(FIH->num_codepages);
	for(i=cp;i<FIH->num_codepages;++i)
	{
		CPEH[i] = CPEH[i+1];
		CPIH[i] = CPIH[i+1];
		SFH[i][0] = SFH[i+1][0];
		SFH[i][1] = SFH[i+1][1];
		SFH[i][2] = SFH[i+1][2];
		SFB16[i] = SFB16[i+1];
		SFB14[i] = SFB14[i+1];
		SFB8[i] = SFB8[i+1];
		byo16[i] = byo16[i+1];
		byo14[i] = byo14[i+1];
		byo8[i] = byo8[i+1];
	}
	CPEH[FIH->num_codepages] = NULL;
	CPIH[FIH->num_codepages] = NULL;
	SFH[FIH->num_codepages][0] = NULL;
	SFH[FIH->num_codepages][1] = NULL;
	SFH[FIH->num_codepages][2] = NULL;
	SFB16[FIH->num_codepages] = NULL;
	SFB14[FIH->num_codepages] = NULL;
	SFB8[FIH->num_codepages] = NULL;
	byo16[FIH->num_codepages] = 0;
	byo14[FIH->num_codepages] = 0;
	byo8[FIH->num_codepages] = 0;

	sprintf(err,"0:OK");
	return 0;
}
void delCP3()//
{
	_setcolor(C_NON);
	_moveto(536,472);
	_outgtext("delCP");
	status=delCP();
	if(status)
	{
		if(status>1)
			message("Codepage not deleted",err);
		redraw();
		return;
	}	
	offset();
	cp%=FIH->num_codepages;
	new8();
	menu8();
	normCP();
	return;
}

int newF()
{
	unsigned short h;
	if(CPIH[cp]->num_fonts>=3)
	{
		sprintf(err,"309:Already 3 fonts in cp%03u\n",CPEH[cp]->codepage);
		return 309;
	}
	if(question("Font height(8,14,16)",&h)==1)
		return 1;
	return newF2(h);
}
int newF2(short h)
{
	switch(h)
	{
	case 8:	
		return newF8(cp);
	case 14:
		return newF14(cp);
	case 16:
		return newF16(cp);
	default:
		sprintf(err,"310:Wrong height (%u)\n",h);
		return 310;
	}
}
void newF3()//
{
	_setcolor(C_NON);
	_moveto(336,472);
	_outgtext("newF");
	status=newF();
	switch(status)
	{
	case 309:
	case 310:
	case 313:
		message("Font not created",err);
	case 1:
		redraw();
		return;
	case 0:
		offset();
		redraw();
		return;
	default:
		message("Font not created",err);
		offset();
		redraw();
		return;
	}
}
int newF8(short CP)
{
	if(byo8[CP])
	{
		sprintf(err,"313:Height 8 already in cp%03u\n",CPEH[CP]->codepage);
		return 313;
	}
	if(!(SFH[CP][CPIH[CP]->num_fonts]=new ScreenFontHeader))
	{
		sprintf(err,"316:Not enough memory for SFH[%d][%d]\n",CP,CPIH[CP]->num_fonts);
		return 316;
	}
	if(!(SFB8[CP]=new ScreenFontBitmap8))
	{
		sprintf(err,"316:Not enough memory for SFB8[%d]\n",CP);
		delete SFH[CP][CPIH[CP]->num_fonts];
		SFH[CP][CPIH[CP]->num_fonts] = NULL;
		return 316;
	}
	memset(SFB8[CP],0,0x800);
	byo8[CP]=1;
	SFH[CP][CPIH[CP]->num_fonts]->height=8;
	SFH[CP][CPIH[CP]->num_fonts]->width=8;
	SFH[CP][CPIH[CP]->num_fonts]->yaspect=0;
	SFH[CP][CPIH[CP]->num_fonts]->xaspect=0;
	SFH[CP][CPIH[CP]->num_fonts]->num_chars=256;
	++(CPIH[CP]->num_fonts);
	offset();
	sprintf(err,"0:OK");
	return 0;
}
int newF14(short CP)
{
	if(byo14[CP])
	{
		sprintf(err,"313:Height 14 already in cp%03u\n",CPEH[CP]->codepage);
		return 313;
	}
	if(!(SFH[CP][CPIH[CP]->num_fonts]=new ScreenFontHeader))
	{
		sprintf(err,"316:Not enough memory for SFH[%d][%d]\n",CP,CPIH[CP]->num_fonts);
		return 316;
	}
	if(!(SFB14[CP]=new ScreenFontBitmap14))
	{
		sprintf(err,"316:Not enough memory for SFB14[%d]\n",CP);
		delete SFH[CP][CPIH[CP]->num_fonts];
		SFH[CP][CPIH[CP]->num_fonts] = NULL;
		return 316;
	}
	memset(SFB14[CP],0,0xe00);
	byo14[CP]=1;
	SFH[CP][CPIH[CP]->num_fonts]->height=14;
	SFH[CP][CPIH[CP]->num_fonts]->width=8;
	SFH[CP][CPIH[CP]->num_fonts]->yaspect=0;
	SFH[CP][CPIH[CP]->num_fonts]->xaspect=0;
	SFH[CP][CPIH[CP]->num_fonts]->num_chars=256;
	++(CPIH[CP]->num_fonts);
	offset();
	sprintf(err,"0:OK");
	return 0;
}
int newF16(short CP)
{
	if(byo16[CP])
	{
		sprintf(err,"313:Height 16 already in cp%03u\n",CPEH[CP]->codepage);
		return 313;
	}
	if(!(SFH[CP][CPIH[CP]->num_fonts]=new ScreenFontHeader))
	{
		sprintf(err,"316:Not enough memory for SFH[%d][%d]\n",CP,CPIH[CP]->num_fonts);
		return 316;
	}
	if(!(SFB16[CP]=new ScreenFontBitmap16))
	{
		sprintf(err,"316:Not enough memory for SFB16[%d]\n",CP);
		delete SFH[CP][CPIH[CP]->num_fonts];
		SFH[CP][CPIH[CP]->num_fonts] = NULL;
		return 316;
	}
	memset(SFB16[CP],0,0x1000);
	byo16[CP]=1;
	SFH[CP][CPIH[CP]->num_fonts]->height=16;
	SFH[CP][CPIH[CP]->num_fonts]->width=8;
	SFH[CP][CPIH[CP]->num_fonts]->yaspect=0;
	SFH[CP][CPIH[CP]->num_fonts]->xaspect=0;
	SFH[CP][CPIH[CP]->num_fonts]->num_chars=256;
	++(CPIH[CP]->num_fonts);
	sprintf(err,"0:OK");
	return 0;
}

void prevF()//
{
	prex=curx;
	prey=cury;
	switch(wys)
	{
	case 8:
		if (byo16[cp]!=0)
		{
			wys=16;
			lin16(1);
			lit16(1);
			ramka16();
		}
		else if(byo14[cp]!=0)
		{
			wys=14;
			lin14(1);
			lit14(1);
			ramka14();
		}
		lin8(1);
		lit8(1);
		ramka8();
		break;
	case 14:
		if (byo8[cp]!=0)
		{
			wys=8;
			cury%=8;
			lin8(1);
			lit8(2);
			ramka8();
		}
		else if(byo16[cp]!=0)
		{
			wys=16;
			lin16(1);
			lit16(1);
			ramka16();
		}
		lin14(1);
		lit14(2);
		ramka14();
		break;
	case 16:
		if (byo14[cp]!=0)
		{
			wys=14;
			cury%=14;
			lin14(1);
			lit14(2);
			ramka14();
		}
		else if(byo8[cp]!=0)
		{
			wys=8;
			cury%=8;
			lin8(1);
			lit8(2);
			ramka8();
		}
		lin16(1);
		lit16(2);
		ramka16();
		break;
	}
	cpwys(1);
	return;
}
void nextF()//
{
	prex=curx;
	prey=cury;
	switch(wys)
	{
	case 8:
		if(byo14[cp]!=0)
		{
			wys=14;
			lin14(1);
			lit14(1);
			ramka14();
		}
		else if (byo16[cp]!=0)
		{
			wys=16;
			lin16(1);
			lit16(1);
			ramka16();
		}
		lin8(1);
		lit8(1);
		ramka8();
		break;
	case 14:
		if(byo16[cp]!=0)
		{
			wys=16;
			lin16(1);
			lit16(1);
			ramka16();
		}
		else if (byo8[cp]!=0)
		{
			wys=8;
			cury%=8;
			lin8(1);
			lit8(2);
			ramka8();
		}
		lin14(1);
		lit14(2);
		ramka14();
		break;
	case 16:
		if(byo8[cp]!=0)
		{
			wys=8;
			cury%=8;
			lin8(1);
			lit8(2);
			ramka8();
		}
		else if (byo14[cp]!=0)
		{
			wys=14;
			cury%=14;
			lin14(1);
			lit14(2);
			ramka14();
		}
		lin16(1);
		lit16(2);
		ramka16();
		break;
	}
	cpwys(1);
	return;
}

int delF()
{
	char temp[41];
	if(CPIH[cp]->num_fonts<=1)
	{
		sprintf(err,"315:Last font in cp%03u\n",CPEH[cp]->codepage);
		return 315;
	}
	sprintf(temp,"Delete 8x%02u in cp%03u?\n",wys,CPEH[cp]->codepage);
	if(message("WARNING",temp,3)==1)
		return 1;
	return delF2();
}
int delF2()
{
	short h;
	
	for(short i=0;i<CPIH[cp]->num_fonts;++i)
	{
		if(SFH[cp][i]->height==wys)
		{
			h=i;
			break;
		}
	}
	switch(wys)
	{
	case 8:
		return delF8(h);
	case 14:
		return delF14(h);
	case 16:
		return delF16(h);
	default:
		sprintf(err,"510:%u ***?\n",h);
		return 510;
	}
}
void delF3()//
{
	_setcolor(C_NON);
	_moveto(472,472);
	_outgtext("delF");
	status=delF();
	if(status)
	{
		if(status>1)
			message("Font not deleted",err);
		redraw();
		return;
	}
	offset();
	new8();
	menu8();
	normCP();
	return;
}
int delF8(short h)
{
	short i;
	delete SFB8[cp];
	delete SFH[cp][h];
	byo8[cp]=0;
	--(CPIH[cp]->num_fonts);
	for(i=h;i<CPIH[cp]->num_fonts;++i)
	{
		SFH[cp][i] = SFH[cp][i+1];
	}
	SFH[cp][CPIH[cp]->num_fonts] = NULL;
	sprintf(err,"0:OK\n");
	return 0;
}
int delF14(short h)
{
	short i;
	delete SFB14[cp];
	delete SFH[cp][h];
	byo14[cp]=0;
	--(CPIH[cp]->num_fonts);
	for(i=h;i<CPIH[cp]->num_fonts;++i)
	{
		SFH[cp][i] = SFH[cp][i+1];
	}
	SFH[cp][CPIH[cp]->num_fonts] = NULL;
	sprintf(err,"0:OK\n");
	return 0;
}
int delF16(short h)
{
	short i;
	delete SFB16[cp];
	delete SFH[cp][h];
	byo16[cp]=0;
	--(CPIH[cp]->num_fonts);
	for(i=h;i<CPIH[cp]->num_fonts;++i)
	{
		SFH[cp][i] = SFH[cp][i+1];
	}
	SFH[cp][CPIH[cp]->num_fonts] = NULL;
	sprintf(err,"0:OK\n");
	return 0;
}


int main(int argc,char* argv[])
{

	nullpointers();

	if(argc>1)
	{
		sprintf(nazwap,"%s",argv[1]);
		status=otw2();
		if(status)
		{
			puts(err);
			return status;
		}
		any=1;
	}
	else
		any=0;
	if(!_setvideomode(_VRES16COLOR))
	{
		printf("400:Cannot enter graphic mode\n");//change number
		return 400;
	}
	_setplotaction(_GPSET); 
	if(byo8[0])
		wys=8;
	else if(byo16[0])
		wys=16;
	else if(byo14[0])
		wys=14;
	redraw();

	maus=setMaus();
	if(maus)
		showMaus();
	for(;;)
	{
		if(/*_bios_keybrd(_KEYBRD_READY)*/kbhit())
		{
			key=_bios_keybrd(_KEYBRD_READ);
			if(maus)
				hideMaus();
			if(tab==0)
			{
				if((key&0xFF00)==0x4800&&any)
				{
					//w gr
					prey=cury;
					prex=curx;
					cury+=wys-1;
					cury%=wys;
					switch(wys)
					{
					case 8:
						lit8(2);
						break;
					case 14:
						lit14(2);
						break;
					case 16:
						lit16(2);
						break;
					}
				}
				if((key&0xFF00)==0x5000&&any)
				{
					//w d
					prey=cury;
					prex=curx;
					++cury;
					cury%=wys;
					switch(wys)
					{
					case 8:
						lit8(2);
						break;
					case 14:
						lit14(2);
						break;
					case 16:
						lit16(2);
						break;
					}
				}
				if((key&0xFF00)==0x4b00&&any)
				{
					//w lewo
					prey=cury;
					prex=curx;
					--curx;
					curx&=0x7;
					switch(wys)
					{
					case 8:
						lit8(2);
						break;
					case 14:
						lit14(2);
						break;
					case 16:
						lit16(2);
						break;
					}
				}
				if((key&0xFF00)==0x4d00&&any)
				{
					//w prawo
					prey=cury;
					prex=curx;
					++curx;
					curx&=0x7;
					switch(wys)
					{
					case 8:
						lit8(2);
						break;
					case 14:
						lit14(2);
						break;
					case 16:
						lit16(2);
						break;
					}
				}
				if ((key&0xFF00)==0x3900&&any)
				{
					//spacja
					switch(wys)
					{
					case 8:
						spc8();
						lit8(1);
						lin8(3);
						break;
					case 14:
						spc14();
						lit14(1);
						lin14(3);
						break;
					case 16:
						spc16();
						lit16(1);
						lin16(3);
						break;
					}
				}
				if ((key&0xFF00)==0x0e00&&any)
				{
					//backspace
					switch(wys)
					{
					case 8:				
						bsp8();
						lit8(1);
						lin8(3);
						break;
					case 14:
						bsp14();
						lit14(1);
						lin14(3);
						break;
					case 16:
						bsp16();
						lit16(1);
						lin16(3);
						break;
					}
				}
				if ((key&0xFF00)==0x1c00&&any)
				{
					//enter
					switch(wys)
					{
					case 8:				
						ent8();
						lit8(1);
						lin8(3);
						break;
					case 14:
						ent14();
						lit14(1);
						lin14(3);
						break;
					case 16:
						ent16();
						lit16(1);
						lin16(3);
						break;
					}
				}
			}
			else
			{
				if((key&0xFF00)==0x4800&&any)
				{
					//w gr l
					pre=lit;
					lit-=16;
					lit&=0xFF;
					lit8();
					lit14();
					lit16();
					switch(wys)
					{
					case 8:
						lin8(2);
						break;
					case 14:
						lin14(2);
						break;
					case 16:
						lin16(2);
						break;
					}
				}
				if((key&0xFF00)==0x5000&&any)
				{
					//w d l
					pre=lit;
					lit+=16;
					lit&=0xFF;
					lit8();
					lit14();
					lit16();
					switch(wys)
					{
					case 8:
						lin8(2);
						break;
					case 14:
						lin14(2);
						break;
					case 16:
						lin16(2);
						break;
					}
				}
				if((key&0xFF00)==0x4b00&&any)
				{
					//w lewo l
					pre=lit;
					--lit;
					lit&=0xFF;
					lit8();
					lit14();
					lit16();
					switch(wys)
					{
					case 8:
						lin8(2);
						break;
					case 14:
						lin14(2);
						break;
					case 16:
						lin16(2);
						break;
					}
				}
				if((key&0xFF00)==0x4d00&&any)
				{
					//w prawo l
					pre=lit;
					++lit;
					lit&=0xFF;
					lit8();
					lit14();
					lit16();
					switch(wys)
					{
					case 8:
						lin8(2);
						break;
					case 14:
						lin14(2);
						break;
					case 16:
						lin16(2);
						break;
					}
				}
			}
			if ((key&0xFF00)==0x0f00&&any)
			{
				//tab
				if(!tab)
					tab=1;
				else
					tab=0;
				switch(wys)
				{
				case 8:
					ramka8();
					break;
				case 14:
					ramka14();
					break;
				case 16:
					ramka16();
					break;
				}
			}
			if ((key&0xFF00)==0x5100&&any)
			{
				nextCP();
			}
			if ((key&0xFF00)==0x4900&&any)
			{
				prevCP();
			}
			if ((key&0xFF00)==0x4700&&any)
			{
				prevF();
			}
			if ((key&0xFF00)==0x4f00&&any)
			{
				nextF();
			}
			if ((key&0xFF00)==0x3b00)
			{
				newCPI3();			
			}
			if ((key&0xFF00)==0x3c00&&any)
			{
				zap3();
			}
			if ((key&0xFF00)==0x3d00)
			{
				otw3();
			}
			if((key&0xFF00)==0x3e00&&any)
			{
				use3();
			}
			if ((key&0xFF00)==0x3f00&&any)
			{
				zmn3();
			}
			if ((key&0xFF00)==0x4000&&any)
			{
				newF3();
			}
			if ((key&0xFF00)==0x4100&&any)
			{
				newCP3();
			}
			if ((key&0xFF00)==0x4200&&any)
			{
				delF3();
			}
			if ((key&0xFF00)==0x4300&&any)
			{
				delCP3();
			}
			if ((key&0xFF00)==0x4400)
			{
				//koniec
				_setcolor(C_NON);
				_moveto(616,472);
				_outgtext("end");
				if(!any)
				{
					if(maus)
						resetMaus();
					break;
				}
				else if(!message("WARNING","A CPI is open; continue anyway?\n",3))
				{
					if(maus)
						resetMaus();
					break;
				}
				else
					redraw();
			}
			while(kbhit())
			{
				_bios_keybrd(_KEYBRD_READ);
			}
			if(maus&&mausv)
				showMaus();
		}
		else if(maus)
		{
			prek=klik;
			//premx=mausx;
			//premy=mausy;
			getMaus(&mausx,&mausy,&klik);
			
			if(any&&mausx>=16&&mausx<144&&mausy>=32&&mausy<160&&byo8[cp])
			{
				hideMaus();
				mausv=0;
				pret=tab;
				prew=wys;
				prex=curx;
				prey=cury;
				curx=(mausx-16)/16;
				cury=(mausy-32)/16;
				wys=8;
				tab=0;
				if(klik)
				{
					if(klik&0x01)
						ent8();
					else if(klik&0x2)
						bsp8();
					else if(klik&0x4)
						spc8();
					lin8(3);
				}
				if(prew!=wys||pret)
					ramka8();
				if(prex==curx&&prey==cury)
				{
					switch(prew)
					{
					case 16:
						lin16(1);
						ramka16();
						lit8(1);
						lit16(1);
						lin8(1);
						cpwys();
						break;
					case 14:
						lin14(1);
						ramka14();
						lit8(1);
						lit14(1);
						lin8(1);
						cpwys();
						break;
					}
					if(klik)
						lit8(1);
				}
				else
				{
					switch(prew)
					{
					case 16:
						lin16(2);
						ramka16();
						lit8(1);
						lit16(2);
						lin8(1);
						cpwys();
						break;
					case 14:
						lin14(2);
						ramka14();
						lit8(1);
						lit14(2);
						lin8(1);
						cpwys();
						break;
					case 8:
						lit8(2);
					}
				}
			}
			
			else if(any&&mausx>=16&&mausx<144&&mausy>=224&&mausy<448&&byo14[cp])
			{
				hideMaus();
				mausv=0;
				pret=tab;
				prew=wys;
				prex=curx;
				prey=cury;
				curx=(mausx-16)/16;
				cury=(mausy-224)/16;
				wys=14;
				tab=0;
				if(klik)
				{
					if(klik&0x01)
						ent14();
					else if(klik&0x2)
						bsp14();
					else if(klik&0x4)
						spc14();
					lin14(3);
				}
				if(prew!=wys||pret)
					ramka14();
				if(prex==curx&&prey==cury)
				{
					switch(prew)
					{
					case 16:
						lin16(1);
						ramka16();
						lit14(1);
						lit16(1);
						lin14(1);
						cpwys();
						break;
					case 8:
						lin8(1);
						ramka8();
						lit14(1);
						lit8(1);
						lin14(1);
						cpwys();
						break;
					}
					if(klik)
						lit14(1);
				}
				else
				{
					switch(prew)
					{
					case 16:
						lin16(2);
						ramka16();
						lit14(1);
						lit16(2);
						lin14(1);
						cpwys();
						break;
					case 8:
						lin8(2);
						ramka8();
						lit14(1);
						lit8(2);
						lin14(1);
						cpwys();
						break;
					case 14:
						lit14(2);
					}
				}
			}
			
			else if(any&&mausx>=336&&mausx<464&&mausy>=112&&mausy<368&&byo16[cp])
			{
				hideMaus();
				mausv=0;
				pret=tab;
				prew=wys;
				prex=curx;
				prey=cury;
				curx=(mausx-336)/16;
				cury=(mausy-112)/16;
				wys=16;
				tab=0;
				if(klik)
				{
					if(klik&0x01)
						ent16();
					else if(klik&0x2)
						bsp16();
					else if(klik&0x4)
						spc16();
					lin16(3);
				}
				if(prew!=wys||pret)
					ramka16();
				if(prex==curx&&prey==cury)
				{
					switch(prew)
					{
					case 8:
						lin8(1);
						ramka8();
						lit16(1);
						lit8(1);
						lin16(1);
						cpwys();
						break;
					case 14:
						lin14(1);
						ramka14();
						lit16(1);
						lit14(1);
						lin16(1);
						cpwys();
						break;
					}
					if(klik)
						lit16(1);
				}
				else
				{
					switch(prew)
					{
					case 8:
						lin8(2);
						ramka8();
						lit16(1);
						lit8(2);
						lin16(1);
						cpwys();
						break;
					case 14:
						lin14(2);
						ramka14();
						lit16(1);
						lit14(2);
						lin16(1);
						cpwys();
						break;
					case 16:
						lit16(2);
					}
				}
			}
			
			else if(any&&klik&&mausx>=176&&mausx<304&&mausy>=32&&mausy<160&&byo8[cp])
			{
				hideMaus();
				mausv=0;
				prew=wys;
				pre=lit;
				pret=tab;
				wys=8;
				cury&=0x7;
				tab=1;
				lit=((mausy-32)/8)*16+((mausx-176)/8);
				if (pre==lit)
				{
					switch(prew)
					{
					case 16:
						ramka16();
						ramka8();
						lin16(1);
						lit16(1);
						lin8(1);
						lit8(1);
						cpwys();
						break;
					case 14:
						ramka14();
						ramka8();
						lin14(1);
						lit14(1);
						lin8(1);
						lit8(1);
						cpwys();
						break;
					case 8:
						if(!pret)
							ramka8();
						break;
					}
				}
				else
				{
					lit8();
					lit14();
					lit16();
					switch(prew)
					{
					case 16:
						lin16(2);
						ramka16();
						ramka8();
						lin8(1);
						cpwys();
						break;
					case 14:
						lin14(2);
						ramka14();
						ramka8();
						lin8(1);
						cpwys();
						break;
					case 8:
						lin8(2);
						if(!pret)
							ramka8();
					}
				}
			}
			
			else if(any&&klik&&mausx>=176&&mausx<304&&mausy>=224&&mausy<448&&byo14[cp])
			{
				hideMaus();
				mausv=0;
				prew=wys;
				pre=lit;
				pret=tab;
				wys=14;
				cury%=14;
				tab=1;
				lit=((mausy-224)/14)*16+((mausx-176)/8);
				if (pre==lit)
				{
					switch(prew)
					{
					case 16:
						ramka16();
						ramka14();
						lin16(1);
						lit16(1);
						lin14(1);
						lit14(1);
						cpwys();
						break;
					case 8:
						ramka8();
						ramka14();
						lin8(1);
						lit8(1);
						lin14(1);
						lit14(1);
						cpwys();
						break;
					case 14:
						if(!pret)
							ramka14();
						break;
					}
				}
				else
				{
					lit8();
					lit14();
					lit16();
					switch(prew)
					{
					case 16:
						lin16(2);
						ramka16();
						ramka14();
						lin14(1);
						cpwys();
						break;
					case 8:
						lin8(2);
						ramka8();
						ramka14();
						lin14(1);
						cpwys();
						break;
					case 14:
						lin14(2);
						if(!pret)
							ramka14();
					}
				}
			}
			
			else if(any&&klik&&mausx>=496&&mausx<624&&mausy>=112&&mausy<368&&byo16[cp])
			{
				hideMaus();
				mausv=0;
				prew=wys;
				pre=lit;
				pret=tab;
				wys=16;
				cury&=0xf;
				tab=1;
				lit=((mausy-112)/16)*16+((mausx-496)/8);
				if (pre==lit)
				{
					switch(prew)
					{
					case 8:
						ramka8();
						ramka16();
						lin8(1);
						lit8(1);
						lin16(1);
						lit16(1);
						cpwys();
						break;
					case 14:
						ramka14();
						ramka16();
						lin14(1);
						lit14(1);
						lin16(1);
						lit16(1);
						cpwys();
						break;
					case 16:
						if(!pret)
							ramka16();
						break;
					}
				}
				else
				{
					lit8();
					lit14();
					lit16();
					switch(prew)
					{
					case 8:
						lin8(2);
						ramka8();
						ramka16();
						lin16(1);
						cpwys();
						break;
					case 14:
						lin14(2);
						ramka14();
						ramka16();
						lin16(1);
						cpwys();
						break;
					case 16:
						lin16(2);
						if(!pret)
							ramka16();
					}
				}
			}
			else if(any&&klik&&!prek&&mausx>=328&&mausx<616&&mausy>=16&&mausy<40)
			{
				int selcp;
				hideMaus();
				mausv=0;
				selcp=(mausx-328)/48+((mausy-16)/8)*6;
				if(selcp<FIH->num_codepages)
				{
					cp=selcp;
					normCP();
				}				
			}
			else if(any&&klik&&!prek&&mausx>=128&&mausx<184&&mausy<8)
			{
				hideMaus();
				mausv=0;
				if(klik&0x01)
					nextCP();
				else
					prevCP();
			}
			
			else if(any&&klik&&!prek&&mausx>=192&&mausx<224&&mausy<8)
			{
				hideMaus();
				mausv=0;
				if(klik&0x01)
					nextF();
				else
					prevF();
			}
			
			else if(klik&&!prek&&mausx<40&&mausy>=472)
			{
				hideMaus();
				mausv=0;
				newCPI3();
			}
			
			else if(any&&klik&&!prek&&mausx>=56&&mausx<104&&mausy>=472)
			{
				hideMaus();
				mausv=0;
				zap3();
			}
			
			else if(klik&&!prek&&mausx>=120&&mausx<168&&mausy>=472)
			{
				hideMaus();
				mausv=0;
				otw3();
			}
			
			else if(any&&klik&&!prek&&mausx>=184&&mausx<224&&mausy>=472)
			{
				hideMaus();
				mausv=0;
				use3();
			}
				
			else if(any&&klik&&!prek&&mausx>=240&&mausx<304&&mausy>=472)
			{
				hideMaus();
				mausv=0;
				zmn3();
			}
			
			
			else if(any&&klik&&!prek&&mausx>=320&&mausx<368&&mausy>=472)
			{
				hideMaus();
				mausv=0;
				newF3();
			}
			
			else if(any&&klik&&!prek&&mausx>=384&&mausx<440&&mausy>=472)
			{
				hideMaus();
				mausv=0;
				newCP3();
			}
			
			else if(any&&klik&&!prek&&mausx>=456&&mausx<504&&mausy>=472)
			{
				hideMaus();
				mausv=0;
				delF3();
			}
			
			else if(any&&klik&&!prek&&mausx>=520&&mausx<576&&mausy>=472)
			{
				hideMaus();
				mausv=0;
				delCP3();
			}
			
			else if(klik&&!prek&&mausx>=592&&mausy>=472)
			{
				hideMaus();
				mausv=0;
				_setcolor(C_NON);
				_moveto(616,472);
				_outgtext("end");
				if(!any)
				{
					resetMaus();
					break;
				}
				else if(!message("WARNING","A CPI is open; continue anyway?\n",3))
				{
					resetMaus();
					break;
				}
				else
					redraw();
			}
			
			else
			{
				//if(!mausv)
				//{
					mausv=1;
					showMaus();
				//}
			}
		}
	}

	deleteCPI();
	_setvideomode(_DEFAULTMODE);	
	return 0;
}
