; MIT License
;
; Copyright (c) 2021 Jerome Shidel
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in all
; copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE.

; NASM 2.14rc0 for DOS

%include 'FDBANNER.INC'

use16

cpu 8086

org 0x0100

    push    cs      ; DS is supposed to point to CS, but we will do it anyway
    pop     ds

    cld
    mov     si, Banner_data
    lodsw
    xchg    al, ah
    push    ax
NextLine:
    mov     ah, 0x02
    mov     dl, 0x0d
    int     0x21            ; Carriage return
    mov     dl, 0x0a
    int     0x21            ; Line Feed
LineLoop:
    pop     ax
    test    ah, ah
    jnz     SameChar
    lodsw
    xchg    al, ah
    test    ah, ah
    jz      Finished
SameChar:
    dec     ah
    push    ax
    xor     bh, bh
    shl     al, 1
    mov     bl, al
    mov     al, [Lookup_Table + bx]
    mov     bl, [Lookup_Table + bx + 1]
    mov     ah, 0x09
    xor     cx, cx
    inc     cx
    int     0x10            ; write char/attrib at cursor position
    mov     ah, 0x03
    int     0x10            ; get cursor position DL = column, DH = row
    inc     dl
    cmp     dl, IMAGE_FDBANNER_WIDTH
    je      NextLine
    mov     ah, 0x02
    int     0x10            ; move cursor right
    jmp     LineLoop

Finished:
    mov     ax,0x4c00
    int     0x21

Lookup_Table:
    dw      0x0720
    dw      0x1020
    dw      0x12db

Banner_data:
    IMAGE_FDBANNER_DRE