''
''
'' mpfr -- header translated with help of SWIG FB wrapper
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''

#inclib "mpfr"

#ifndef __mpfr_bi__
#define __mpfr_bi__

#define MPFR_VERSION_MAJOR 2
#define MPFR_VERSION_MINOR 3
#define MPFR_VERSION_PATCHLEVEL 0
#define MPFR_VERSION_STRING "2.3.0"
#define MPFR_VERSION (((2) Shl 16L) Or ((3) Shl 8) Or (0))

#define size_t Integer

enum mpfr_rnd_t
        GMP_RNDN = 0
        GMP_RNDZ
        GMP_RNDU
        GMP_RNDD
        GMP_RND_MAX
        GMP_RNDNA = -1
End enum


#define _MPFR_PREC_FORMAT 3

Type mpfr_prec_t As Uinteger

#define MPFR_PREC_MIN 2

Type mpfr_sign_t As Integer

Type __mpfr_struct
        _mpfr_prec As mpfr_prec_t
        _mpfr_sign As mpfr_sign_t
        _mpfr_exp As mp_exp_t
        _mpfr_d As mp_limb_t Ptr
End Type

Type mpfr_t As __mpfr_struct Ptr
Type mpfr_ptr As __mpfr_struct Ptr
Type mpfr_srcptr As __mpfr_struct Ptr

enum mpfr_kind_t
        MPFR_NAN_KIND = 0
        MPFR_INF_KIND = 1
        MPFR_ZERO_KIND = 2
        MPFR_REGULAR_KIND = 3
End enum


Declare Function mpfr_get_version Cdecl Alias "mpfr_get_version" () As Zstring Ptr
Declare Function mpfr_get_patches Cdecl Alias "mpfr_get_patches" () As Zstring Ptr
Declare Function mpfr_set_emin Cdecl Alias "mpfr_set_emin" (Byval As mp_exp_t) As Integer
Declare Function mpfr_set_emax Cdecl Alias "mpfr_set_emax" (Byval As mp_exp_t) As Integer
Declare Sub mpfr_set_default_rounding_mode Cdecl Alias "mpfr_set_default_rounding_mode" (Byval As mpfr_rnd_t)
Declare Function mpfr_print_rnd_mode Cdecl Alias "mpfr_print_rnd_mode" (Byval As mpfr_rnd_t) As Zstring Ptr
Declare Sub mpfr_clear_flags Cdecl Alias "mpfr_clear_flags" ()
Declare Sub mpfr_clear_underflow Cdecl Alias "mpfr_clear_underflow" ()
Declare Sub mpfr_clear_overflow Cdecl Alias "mpfr_clear_overflow" ()
Declare Sub mpfr_clear_nanflag Cdecl Alias "mpfr_clear_nanflag" ()
Declare Sub mpfr_clear_inexflag Cdecl Alias "mpfr_clear_inexflag" ()
Declare Sub mpfr_clear_erangeflag Cdecl Alias "mpfr_clear_erangeflag" ()
Declare Sub mpfr_set_underflow Cdecl Alias "mpfr_set_underflow" ()
Declare Sub mpfr_set_overflow Cdecl Alias "mpfr_set_overflow" ()
Declare Sub mpfr_set_nanflag Cdecl Alias "mpfr_set_nanflag" ()
Declare Sub mpfr_set_inexflag Cdecl Alias "mpfr_set_inexflag" ()
Declare Sub mpfr_set_erangeflag Cdecl Alias "mpfr_set_erangeflag" ()
Declare Function mpfr_underflow_p Cdecl Alias "mpfr_underflow_p" () As Integer
Declare Function mpfr_overflow_p Cdecl Alias "mpfr_overflow_p" () As Integer
Declare Function mpfr_nanflag_p Cdecl Alias "mpfr_nanflag_p" () As Integer
Declare Function mpfr_inexflag_p Cdecl Alias "mpfr_inexflag_p" () As Integer
Declare Function mpfr_erangeflag_p Cdecl Alias "mpfr_erangeflag_p" () As Integer
Declare Function mpfr_check_range Cdecl Alias "mpfr_check_range" (Byval As mpfr_ptr, Byval As Integer, Byval As mpfr_rnd_t) As Integer
Declare Sub mpfr_init2 Cdecl Alias "mpfr_init2" (Byval As mpfr_ptr, Byval As mpfr_prec_t)
Declare Sub mpfr_init Cdecl Alias "mpfr_init" (Byval As mpfr_ptr)
Declare Sub mpfr_clear Cdecl Alias "mpfr_clear" (Byval As mpfr_ptr)
Declare Sub mpfr_inits2 Cdecl Alias "mpfr_inits2" (Byval As mpfr_prec_t, Byval As mpfr_ptr, ...)
Declare Sub mpfr_inits Cdecl Alias "mpfr_inits" (Byval As mpfr_ptr, ...)
Declare Sub mpfr_clears Cdecl Alias "mpfr_clears" (Byval As mpfr_ptr, ...)
Declare Function mpfr_prec_round Cdecl Alias "mpfr_prec_round" (Byval As mpfr_ptr, Byval As mpfr_prec_t, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_can_round Cdecl Alias "mpfr_can_round" (Byval As mpfr_srcptr, Byval As mp_exp_t, Byval As mpfr_rnd_t, Byval As mpfr_rnd_t, Byval As mpfr_prec_t) As Integer
Declare Function mpfr_set_exp Cdecl Alias "mpfr_set_exp" (Byval As mpfr_ptr, Byval As mp_exp_t) As Integer
Declare Sub mpfr_set_prec Cdecl Alias "mpfr_set_prec" (Byval As mpfr_ptr, Byval As mpfr_prec_t)
Declare Sub mpfr_set_prec_raw Cdecl Alias "mpfr_set_prec_raw" (Byval As mpfr_ptr, Byval As mpfr_prec_t)
Declare Sub mpfr_set_default_prec Cdecl Alias "mpfr_set_default_prec" (Byval As mpfr_prec_t)
Declare Function mpfr_set_d Cdecl Alias "mpfr_set_d" (Byval As mpfr_ptr, Byval As Double, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_set_ld Cdecl Alias "mpfr_set_ld" (Byval As mpfr_ptr, Byval As Double, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_set_z Cdecl Alias "mpfr_set_z" (Byval As mpfr_ptr, Byval As mpz_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Sub mpfr_set_nan Cdecl Alias "mpfr_set_nan" (Byval As mpfr_ptr)
Declare Sub mpfr_set_inf Cdecl Alias "mpfr_set_inf" (Byval As mpfr_ptr, Byval As Integer)
Declare Function mpfr_set_f Cdecl Alias "mpfr_set_f" (Byval As mpfr_ptr, Byval As mpf_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_set_str Cdecl Alias "mpfr_set_str" (Byval As mpfr_ptr, Byval As String, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_get_f Cdecl Alias "mpfr_get_f" (Byval As mpf_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_set_si Cdecl Alias "mpfr_set_si" (Byval As mpfr_ptr, Byval As Integer, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_set_ui Cdecl Alias "mpfr_set_ui" (Byval As mpfr_ptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_set_si_2exp Cdecl Alias "mpfr_set_si_2exp" (Byval As mpfr_ptr, Byval As Integer, Byval As mp_exp_t, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_set_ui_2exp Cdecl Alias "mpfr_set_ui_2exp" (Byval As mpfr_ptr, Byval As Uinteger, Byval As mp_exp_t, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_set_q Cdecl Alias "mpfr_set_q" (Byval As mpfr_ptr, Byval As mpq_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_set4 Cdecl Alias "mpfr_set4" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t, Byval As Integer) As Integer
Declare Function mpfr_abs Cdecl Alias "mpfr_abs" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_set Cdecl Alias "mpfr_set" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_neg Cdecl Alias "mpfr_neg" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_signbit Cdecl Alias "mpfr_signbit" (Byval As mpfr_srcptr) As Integer
Declare Function mpfr_setsign Cdecl Alias "mpfr_setsign" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Integer, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_copysign Cdecl Alias "mpfr_copysign" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_get_d Cdecl Alias "mpfr_get_d" (Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Double
Declare Function mpfr_get_ld Cdecl Alias "mpfr_get_ld" (Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Double
Declare Function mpfr_get_d1 Cdecl Alias "mpfr_get_d1" (Byval As mpfr_srcptr) As Double
Declare Function mpfr_get_d_2exp Cdecl Alias "mpfr_get_d_2exp" (Byval As Integer Ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Double
Declare Function mpfr_get_ld_2exp Cdecl Alias "mpfr_get_ld_2exp" (Byval As Integer Ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Double
Declare Function mpfr_get_si Cdecl Alias "mpfr_get_si" (Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_get_ui Cdecl Alias "mpfr_get_ui" (Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Uinteger
Declare Function mpfr_get_str Cdecl Alias "mpfr_get_str" (Byval As Zstring Ptr, Byval As mp_exp_t Ptr, Byval As Integer, Byval As size_t, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Zstring Ptr
Declare Sub mpfr_get_z Cdecl Alias "mpfr_get_z" (Byval z As mpz_ptr, Byval f As mpfr_srcptr, Byval As mpfr_rnd_t)
Declare Sub mpfr_free_str Cdecl Alias "mpfr_free_str" (Byval As Zstring Ptr)
Declare Sub mpfr_random Cdecl Alias "mpfr_random" (Byval As mpfr_ptr)
Declare Sub mpfr_random2 Cdecl Alias "mpfr_random2" (Byval As mpfr_ptr, Byval As mp_size_t, Byval As mp_exp_t)
Declare Function mpfr_urandomb Cdecl Alias "mpfr_urandomb" (Byval As mpfr_ptr, Byval As gmp_randstate_t) As Integer
Declare Sub mpfr_nextabove Cdecl Alias "mpfr_nextabove" (Byval As mpfr_ptr)
Declare Sub mpfr_nextbelow Cdecl Alias "mpfr_nextbelow" (Byval As mpfr_ptr)
Declare Sub mpfr_nexttoward Cdecl Alias "mpfr_nexttoward" (Byval As mpfr_ptr, Byval As mpfr_srcptr)
Declare Function mpfr_pow Cdecl Alias "mpfr_pow" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_pow_si Cdecl Alias "mpfr_pow_si" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Integer, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_pow_ui Cdecl Alias "mpfr_pow_ui" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_ui_pow_ui Cdecl Alias "mpfr_ui_pow_ui" (Byval As mpfr_ptr, Byval As Uinteger, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_ui_pow Cdecl Alias "mpfr_ui_pow" (Byval As mpfr_ptr, Byval As Uinteger, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_pow_z Cdecl Alias "mpfr_pow_z" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpz_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sqrt Cdecl Alias "mpfr_sqrt" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sqrt_ui Cdecl Alias "mpfr_sqrt_ui" (Byval As mpfr_ptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_add Cdecl Alias "mpfr_add" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sub Cdecl Alias "mpfr_sub" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_mul Cdecl Alias "mpfr_mul" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_div Cdecl Alias "mpfr_div" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_add_ui Cdecl Alias "mpfr_add_ui" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sub_ui Cdecl Alias "mpfr_sub_ui" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_ui_sub Cdecl Alias "mpfr_ui_sub" (Byval As mpfr_ptr, Byval As Uinteger, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_mul_ui Cdecl Alias "mpfr_mul_ui" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_div_ui Cdecl Alias "mpfr_div_ui" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_ui_div Cdecl Alias "mpfr_ui_div" (Byval As mpfr_ptr, Byval As Uinteger, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_add_si Cdecl Alias "mpfr_add_si" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Integer, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sub_si Cdecl Alias "mpfr_sub_si" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Integer, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_si_sub Cdecl Alias "mpfr_si_sub" (Byval As mpfr_ptr, Byval As Integer, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_mul_si Cdecl Alias "mpfr_mul_si" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Integer, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_div_si Cdecl Alias "mpfr_div_si" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Integer, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_si_div Cdecl Alias "mpfr_si_div" (Byval As mpfr_ptr, Byval As Integer, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sqr Cdecl Alias "mpfr_sqr" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_const_pi Cdecl Alias "mpfr_const_pi" (Byval As mpfr_ptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_const_log2 Cdecl Alias "mpfr_const_log2" (Byval As mpfr_ptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_const_euler Cdecl Alias "mpfr_const_euler" (Byval As mpfr_ptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_const_catalan Cdecl Alias "mpfr_const_catalan" (Byval As mpfr_ptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_agm Cdecl Alias "mpfr_agm" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_log Cdecl Alias "mpfr_log" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_log2 Cdecl Alias "mpfr_log2" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_log10 Cdecl Alias "mpfr_log10" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_log1p Cdecl Alias "mpfr_log1p" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_exp Cdecl Alias "mpfr_exp" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_exp2 Cdecl Alias "mpfr_exp2" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_exp10 Cdecl Alias "mpfr_exp10" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_expm1 Cdecl Alias "mpfr_expm1" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_eint Cdecl Alias "mpfr_eint" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_cmp Cdecl Alias "mpfr_cmp" (Byval As mpfr_srcptr, Byval As mpfr_srcptr) As Integer
Declare Function mpfr_cmp3 Cdecl Alias "mpfr_cmp3" (Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As Integer) As Integer
Declare Function mpfr_cmp_d Cdecl Alias "mpfr_cmp_d" (Byval As mpfr_srcptr, Byval As Double) As Integer
Declare Function mpfr_cmp_ld Cdecl Alias "mpfr_cmp_ld" (Byval As mpfr_srcptr, Byval As Double) As Integer
Declare Function mpfr_cmpabs Cdecl Alias "mpfr_cmpabs" (Byval As mpfr_srcptr, Byval As mpfr_srcptr) As Integer
Declare Function mpfr_cmp_ui Cdecl Alias "mpfr_cmp_ui" (Byval As mpfr_srcptr, Byval As Uinteger) As Integer
Declare Function mpfr_cmp_si Cdecl Alias "mpfr_cmp_si" (Byval As mpfr_srcptr, Byval As Integer) As Integer
Declare Function mpfr_cmp_ui_2exp Cdecl Alias "mpfr_cmp_ui_2exp" (Byval As mpfr_srcptr, Byval As Uinteger, Byval As mp_exp_t) As Integer
Declare Function mpfr_cmp_si_2exp Cdecl Alias "mpfr_cmp_si_2exp" (Byval As mpfr_srcptr, Byval As Integer, Byval As mp_exp_t) As Integer
Declare Sub mpfr_reldiff Cdecl Alias "mpfr_reldiff" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t)
Declare Function mpfr_eq Cdecl Alias "mpfr_eq" (Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As Uinteger) As Integer
Declare Function mpfr_sgn Cdecl Alias "mpfr_sgn" (Byval As mpfr_srcptr) As Integer
Declare Function mpfr_mul_2exp Cdecl Alias "mpfr_mul_2exp" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_div_2exp Cdecl Alias "mpfr_div_2exp" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_mul_2ui Cdecl Alias "mpfr_mul_2ui" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_div_2ui Cdecl Alias "mpfr_div_2ui" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_mul_2si Cdecl Alias "mpfr_mul_2si" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Integer, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_div_2si Cdecl Alias "mpfr_div_2si" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Integer, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_rint Cdecl Alias "mpfr_rint" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_round Cdecl Alias "mpfr_round" (Byval As mpfr_ptr, Byval As mpfr_srcptr) As Integer
Declare Function mpfr_trunc Cdecl Alias "mpfr_trunc" (Byval As mpfr_ptr, Byval As mpfr_srcptr) As Integer
Declare Function mpfr_ceil Cdecl Alias "mpfr_ceil" (Byval As mpfr_ptr, Byval As mpfr_srcptr) As Integer
Declare Function mpfr_floor Cdecl Alias "mpfr_floor" (Byval As mpfr_ptr, Byval As mpfr_srcptr) As Integer
Declare Function mpfr_rint_round Cdecl Alias "mpfr_rint_round" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_rint_trunc Cdecl Alias "mpfr_rint_trunc" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_rint_ceil Cdecl Alias "mpfr_rint_ceil" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_rint_floor Cdecl Alias "mpfr_rint_floor" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_frac Cdecl Alias "mpfr_frac" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_Remquo cdecl alias "mpfr_remquo" (byval as mpfr_ptr, byval as integer ptr, byval as mpfr_srcptr, byval as mpfr_srcptr, byval as mpfr_rnd_t) as integer
Declare Function mpfr_Remainder cdecl alias "mpfr_remainder" (byval as mpfr_ptr, byval as mpfr_srcptr, byval as mpfr_srcptr, byval as mpfr_rnd_t) as integer
Declare Function mpfr_fits_ulong_p Cdecl Alias "mpfr_fits_ulong_p" (Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_fits_slong_p Cdecl Alias "mpfr_fits_slong_p" (Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_fits_uint_p Cdecl Alias "mpfr_fits_uint_p" (Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_fits_sint_p Cdecl Alias "mpfr_fits_sint_p" (Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_fits_ushort_p Cdecl Alias "mpfr_fits_ushort_p" (Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_fits_sshort_p Cdecl Alias "mpfr_fits_sshort_p" (Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_fits_uintmax_p Cdecl Alias "mpfr_fits_uintmax_p" (Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_fits_intmax_p Cdecl Alias "mpfr_fits_intmax_p" (Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Sub mpfr_extract Cdecl Alias "mpfr_extract" (Byval As mpz_ptr, Byval As mpfr_srcptr, Byval As Uinteger)
Declare Sub mpfr_swap Cdecl Alias "mpfr_swap" (Byval As mpfr_ptr, Byval As mpfr_ptr)
Declare Sub mpfr_dump Cdecl Alias "mpfr_dump" (Byval As mpfr_srcptr)
Declare Function mpfr_nan_p Cdecl Alias "mpfr_nan_p" (Byval As mpfr_srcptr) As Integer
Declare Function mpfr_inf_p Cdecl Alias "mpfr_inf_p" (Byval As mpfr_srcptr) As Integer
Declare Function mpfr_number_p Cdecl Alias "mpfr_number_p" (Byval As mpfr_srcptr) As Integer
Declare Function mpfr_integer_p Cdecl Alias "mpfr_integer_p" (Byval As mpfr_srcptr) As Integer
Declare Function mpfr_zero_p Cdecl Alias "mpfr_zero_p" (Byval As mpfr_srcptr) As Integer
Declare Function mpfr_greater_p Cdecl Alias "mpfr_greater_p" (Byval As mpfr_srcptr, Byval As mpfr_srcptr) As Integer
Declare Function mpfr_greaterequal_p Cdecl Alias "mpfr_greaterequal_p" (Byval As mpfr_srcptr, Byval As mpfr_srcptr) As Integer
Declare Function mpfr_less_p Cdecl Alias "mpfr_less_p" (Byval As mpfr_srcptr, Byval As mpfr_srcptr) As Integer
Declare Function mpfr_lessequal_p Cdecl Alias "mpfr_lessequal_p" (Byval As mpfr_srcptr, Byval As mpfr_srcptr) As Integer
Declare Function mpfr_lessgreater_p Cdecl Alias "mpfr_lessgreater_p" (Byval As mpfr_srcptr, Byval As mpfr_srcptr) As Integer
Declare Function mpfr_equal_p Cdecl Alias "mpfr_equal_p" (Byval As mpfr_srcptr, Byval As mpfr_srcptr) As Integer
Declare Function mpfr_unordered_p Cdecl Alias "mpfr_unordered_p" (Byval As mpfr_srcptr, Byval As mpfr_srcptr) As Integer
Declare Function mpfr_atanh Cdecl Alias "mpfr_atanh" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_acosh Cdecl Alias "mpfr_acosh" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_asinh Cdecl Alias "mpfr_asinh" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_cosh Cdecl Alias "mpfr_cosh" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sinh Cdecl Alias "mpfr_sinh" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_tanh Cdecl Alias "mpfr_tanh" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sech Cdecl Alias "mpfr_sech" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_csch Cdecl Alias "mpfr_csch" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_coth Cdecl Alias "mpfr_coth" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_acos Cdecl Alias "mpfr_acos" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_asin Cdecl Alias "mpfr_asin" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_atan Cdecl Alias "mpfr_atan" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sin Cdecl Alias "mpfr_sin" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sin_cos Cdecl Alias "mpfr_sin_cos" (Byval As mpfr_ptr, Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_cos Cdecl Alias "mpfr_cos" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_tan Cdecl Alias "mpfr_tan" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_atan2 Cdecl Alias "mpfr_atan2" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sec Cdecl Alias "mpfr_sec" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_csc Cdecl Alias "mpfr_csc" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_cot Cdecl Alias "mpfr_cot" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_hypot Cdecl Alias "mpfr_hypot" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_erf Cdecl Alias "mpfr_erf" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_erfc Cdecl Alias "mpfr_erfc" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_cbrt Cdecl Alias "mpfr_cbrt" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_root Cdecl Alias "mpfr_root" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_gamma Cdecl Alias "mpfr_gamma" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_lngamma Cdecl Alias "mpfr_lngamma" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_lgamma Cdecl Alias "mpfr_lgamma" (Byval As mpfr_ptr, Byval As Integer Ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_zeta Cdecl Alias "mpfr_zeta" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_zeta_ui Cdecl Alias "mpfr_zeta_ui" (Byval As mpfr_ptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_fac_ui Cdecl Alias "mpfr_fac_ui" (Byval As mpfr_ptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_j0 Cdecl Alias "mpfr_j0" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_j1 Cdecl Alias "mpfr_j1" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_jn Cdecl Alias "mpfr_jn" (Byval As mpfr_ptr, Byval As Integer, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_y0 Cdecl Alias "mpfr_y0" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_y1 Cdecl Alias "mpfr_y1" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_yn Cdecl Alias "mpfr_yn" (Byval As mpfr_ptr, Byval As Integer, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_min Cdecl Alias "mpfr_min" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_max Cdecl Alias "mpfr_max" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_dim Cdecl Alias "mpfr_dim" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_mul_z Cdecl Alias "mpfr_mul_z" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpz_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_div_z Cdecl Alias "mpfr_div_z" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpz_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_add_z Cdecl Alias "mpfr_add_z" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpz_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sub_z Cdecl Alias "mpfr_sub_z" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpz_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_cmp_z Cdecl Alias "mpfr_cmp_z" (Byval As mpfr_srcptr, Byval As mpz_srcptr) As Integer
Declare Function mpfr_mul_q Cdecl Alias "mpfr_mul_q" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpq_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_div_q Cdecl Alias "mpfr_div_q" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpq_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_add_q Cdecl Alias "mpfr_add_q" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpq_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sub_q Cdecl Alias "mpfr_sub_q" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpq_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_cmp_q Cdecl Alias "mpfr_cmp_q" (Byval As mpfr_srcptr, Byval As mpq_srcptr) As Integer
Declare Function mpfr_cmp_f Cdecl Alias "mpfr_cmp_f" (Byval As mpfr_srcptr, Byval As mpf_srcptr) As Integer
Declare Function mpfr_fma Cdecl Alias "mpfr_fma" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_fms Cdecl Alias "mpfr_fms" (Byval As mpfr_ptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_srcptr, Byval As mpfr_rnd_t) As Integer
Declare Function mpfr_sum Cdecl Alias "mpfr_sum" (Byval As mpfr_ptr, Byval __gmp_const As mpfr_ptr Ptr, Byval As Uinteger, Byval As mpfr_rnd_t) As Integer
Declare Sub mpfr_free_cache Cdecl Alias "mpfr_free_cache" ()
Declare Function mpfr_subnormalize Cdecl Alias "mpfr_subnormalize" (Byval As mpfr_ptr, Byval As Integer, Byval As mpfr_rnd_t) As Integer
Declare Sub mpfr_custom_init Cdecl Alias "mpfr_custom_init" (Byval As Any Ptr, Byval As mpfr_prec_t)
Declare Function mpfr_custom_get_mantissa Cdecl Alias "mpfr_custom_get_mantissa" (Byval As mpfr_srcptr) As Any Ptr
Declare Sub mpfr_custom_move Cdecl Alias "mpfr_custom_move" (Byval As mpfr_ptr, Byval As Any Ptr)
Declare Sub mpfr_custom_init_set Cdecl Alias "mpfr_custom_init_set" (Byval As mpfr_ptr, Byval As Integer, Byval As mp_exp_t, Byval As mpfr_prec_t, Byval As Any Ptr)
Declare Function mpfr_custom_get_kind Cdecl Alias "mpfr_custom_get_kind" (Byval As mpfr_srcptr) As Integer

Declare Function mpfr_get_z_exp Cdecl Alias "mpfr_get_z_exp" (Byval As mpz_ptr, Byval As mpfr_ptr) As Integer
#endif
