; Blowfish decryption routine in Assembly
; Copyright (C) 2002 Davi T. Figueiredo
;
; Used in bf.e (version 2.02), available from http://www16.brinkster.com/davitf/
;
; Export or use of this program may be restricted in some countries.
; Please read bf.txt for more information and for its license terms
; and disclaimer.

; See bf_enc.asm for some more information about the code.


PUSH EAX                    ;save initial values
PUSH EBX
PUSH ECX
PUSH EDX

MOV ECX,p_address_68

;EAX will store xL and EBX will store xR
;Get xL and xR (swapping them)

MOV EDX,[x_address]     ; Copy xL from memory
MOV BL,DH               ; Invert the byte order in xL
MOV BH,DL
SHL EBX,16
SHR EDX,16
MOV BL,DH
MOV BH,DL

MOV EDX,[x_address_4]   ; Copy xR from memory
MOV AL,DH               ; Invert the byte order in xR
MOV AH,DL
SHL EAX,16
SHR EDX,16
MOV AL,DH
MOV AH,DL


XOR EBX,[ECX]                   ; Do the first xorings
SUB ECX,4
XOR EAX,[ECX]


; This is very similar to bf_enc.asm, so please see the comments there.

Round:
SUB ECX,4

PUSH EBX
PUSH EAX


MOV EDX,EBX                     ;Compute F(xL)
SHR EDX,22
AND EDX,#000003FC
ADD EDX,s1_address
MOV EAX,[EDX]

MOV EDX,EBX
SHR EDX,14
AND EDX,#000003FC
ADD EDX,s2_address
ADD EAX,[EDX]

MOV EDX,EBX
SHR EDX,6
AND EDX,#000003FC
ADD EDX,s3_address
XOR EAX,[EDX]

MOV EDX,EBX
SHL EDX,2
AND EDX,#000003FC
ADD EDX,s4_address
ADD EAX,[EDX]                   ; EAX now contains the result of F

POP EBX                         ; Update xL and xR and swap them in the process
XOR EBX,EAX
POP EAX
XOR EAX,[ECX]


CMP ECX,p_address               ; Finished all 16 rounds?
JA Round                        ; No, so go back for next round


                ; Save EAX in xL and EBX in xR, thus unswapping them

MOV DL,AH               ; Invert the byte order in EAX
MOV DH,AL               ; The result will be in EDX
SHL EDX,16
SHR EAX,16
MOV DL,AH
MOV DH,AL
MOV [x_address],EDX     ; Save xL

MOV DL,BH               ; Invert the byte order in EBX
MOV DH,BL               ; The result will be in EDX
SHL EDX,16
SHR EBX,16
MOV DL,BH
MOV DH,BL
MOV [x_address_4],EDX     ; Save xR


POP EDX                         ; Restore initial values
POP ECX
POP EBX
POP EAX
RET                             ; End

